/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01g.services;

import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01g.api.utils.R01GConstants;
import com.ejie.r01g.config.loaders.R01GPortalLoaderFactory;
import com.ejie.r01g.config.loaders.R01GTemplateDataLoader;
import com.ejie.r01g.datastore.R01GPortalInDataStore;
import com.ejie.r01g.exceptions.R01GPortalModelPersistenceException;
import com.ejie.r01g.gestorportal.dbhelppers.dao.R01GDAOPortalModelLoader;
import com.ejie.r01g.gestorportal.ejb.page.R01GPageBMPUtil;
import com.ejie.r01g.gestorportal.ejb.publipdtes.R01GPubliPdtesCMPValue;
import com.ejie.r01g.gestorportal.ejb.repopubli.R01GRepoPubPagePortalCMPLocal;
import com.ejie.r01g.gestorportal.ejb.repopubli.R01GRepoPubPagePortalCMPUtil;
import com.ejie.r01g.gestorportal.ejb.repopubli.R01GRepoPubPagePortalCMPValue;
import com.ejie.r01g.services.R01GAliasAdminManager;
import com.ejie.r01g.services.R01GHistoryHelper;
import com.ejie.r01g.services.R01GPageAdminManager;
import com.ejie.r01g.services.R01GPortalModelManager;
import com.ejie.r01m.config.objects.portalmodel.R01MVisualAreasConfig;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MDataStoreException;
import com.ejie.r01m.exceptions.R01MJMSException;
import com.ejie.r01m.exceptions.R01MPortalModelException;
import com.ejie.r01m.exceptions.R01MPortalModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MPublisherException;
import com.ejie.r01m.exceptions.R01MPublisherModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MSearchIndexerException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.R01MBasePublicationTarget;
import com.ejie.r01m.objects.R01MURLAlias;
import com.ejie.r01m.objects.portalmodel.R01MPage;
import com.ejie.r01m.objects.portalmodel.R01MPageVAInclude;
import com.ejie.r01m.objects.portalmodel.R01MPortal;
import com.ejie.r01m.objects.portalmodel.R01MPortalPublicationRequested;
import com.ejie.r01m.objects.portalmodel.R01MPortalPublicationTarget;
import com.ejie.r01m.objects.portalmodel.R01MPortalTemplate;
import com.ejie.r01m.objects.portalmodel.R01MResource;
import com.ejie.r01m.objects.portalmodel.R01MVisualArea;
import com.ejie.r01m.objects.portalmodel.R01MVisualAreaInstance;
import com.ejie.r01m.objects.portalmodel.R01MVisualAreaInstanceResume;
import com.ejie.r01m.objects.publisher.R01MPublicationResourceItem;
import com.ejie.r01m.objects.publisher.R01MPublishActionObject;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MPathHelpper;
import com.ejie.r01m.utils.R01MUtils;
import com.ejie.r01m.utils.jms.R01MJMSUtils;
import com.ejie.r01m.utils.jms.R01MJmsQueueParam;
import com.ejie.r01m.utils.portal.R01MPortalPathHelpper;
import com.ejie.r01p.objects.publisher.R01PPublishDefinition;
import com.ejie.r01p.services.R01PAliasManagerAPI;
import com.ejie.r01p.services.R01PClientFactory;
import com.ejie.r01p.services.bzd.R01PPublisherManagerBzd;
import com.ejie.r01p.utils.publisher.R01MPublisherUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

public class R01GPublisherManager
implements R01PPublisherManagerBzd {
    private static final String LOG_TYPE_ID = "r01g.publisherManager";
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01g.publisherManager").intValue() != Level.OFF.intValue();
    private transient R01MUserContext _userCtx;
    private final transient R01GTemplateDataLoader _templateDataLoader = R01GPortalLoaderFactory.getTemplateDataLoader();

    public R01GPublisherManager() {
    }

    public R01GPublisherManager(R01MUserContext userCtx) {
        this();
        this._userCtx = userCtx;
    }

    public boolean isPagePublished(R01MPage page, String repositoryOid) {
        List publications = page.getPublicationInfo();
        HashMap<String, R01MPortalPublicationTarget> publicationsByRepository = new HashMap<String, R01MPortalPublicationTarget>();
        if (publications != null && !publications.isEmpty()) {
            for (R01MPortalPublicationTarget publicacion : publications) {
                if (publicationsByRepository.containsKey(publicacion.getOid()) && !((R01MPortalPublicationTarget)publicationsByRepository.get(publicacion.getOid())).getPublishDate().before(publicacion.getPublishDate())) continue;
                publicationsByRepository.put(publicacion.getOid(), publicacion);
            }
            if (StringUtils.isEmptyString((String)repositoryOid) || ((R01MPortalPublicationTarget)publicationsByRepository.get(repositoryOid)).getState() == 1) {
                return true;
            }
        }
        return false;
    }

    public void prepareToPublish(R01PPublishDefinition pubDef) throws R01MPublisherException {
        boolean inputParamsOK = true;
        try {
            this._checkPublishProcessInputParams(0, pubDef);
        }
        catch (R01MPublisherException pEx) {
            try {
                pubDef.setPublicationState(-1);
                this._updateErrorPublicationState(pubDef);
                this._sendStepFinishedMessage("ERROR", "Prepare to publish finished with errors. Error: " + pEx.getMessage(), 0, pubDef);
            }
            catch (R01MPublisherException pubEx) {
                R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager.prepareToPublish >> Error al actualizar el estado de publicaci\u00f3n a ERROR o al mandar el mensaje de finished: " + pubEx.getMessage() + " con el error: " + pEx.getMessage());
                throw new R01MPublisherException("R01GPublisherManager.prepareToPublish >> Error al actualizar el estado de publicaci\u00f3n a ERROR o al mandar el mensaje de finished: " + pubEx.getMessage() + " con el error: ", (Exception)((Object)pubEx));
            }
            inputParamsOK = false;
        }
        if (inputParamsOK) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("R01GPublisherManager.prepareToPublish >> Par\u00e1metros de entrada:\n" + pubDef.debugInfo("").toString());
            }
            boolean uploadFilesOK = true;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("R01GPublisherManager.prepareToPublish >> PASO 1: Crear la lista de recursos a publicar y subirla al interwoven para el objeto " + (StringUtils.isEmptyString((String)pubDef.getObjectOid()) ? " [empty / null] " : pubDef.getObjectOid()) + " de tipo " + Integer.toString(pubDef.getObjectType()));
            }
            List resourcesList = null;
            R01GPortalInDataStore dsMngr = null;
            Object[] object = null;
            try {
                object = this._prepareFilelistToPublish(pubDef.getObjectOid(), pubDef.getObjectType(), pubDef.getResourcesRelativePaths(), pubDef.getPublicationType());
            }
            catch (R01MPublisherException pEx) {
                try {
                    pubDef.setPublicationState(-1);
                    this._updateErrorPublicationState(pubDef);
                    this._sendStepFinishedMessage("ERROR", "Prepare to publish finished with errors. Error: " + pEx.getMessage(), 0, pubDef);
                }
                catch (R01MPublisherException pubEx) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager.prepareToPublish >> Error al mandar el mensaje de finished: " + pubEx.getMessage() + " con el error: " + pEx.getMessage());
                }
                uploadFilesOK = false;
            }
            if (uploadFilesOK && object != null && object.length > 1) {
                dsMngr = (R01GPortalInDataStore)object[0];
                resourcesList = (List)object[1];
            }
            if (uploadFilesOK && dsMngr != null && resourcesList != null && !resourcesList.isEmpty()) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("R01GPublisherManager.prepareToPublish >>  ... lista de recursos a publicar creada: " + resourcesList.toString() + " para el objeto " + (StringUtils.isEmptyString((String)pubDef.getObjectOid()) ? " [empty / null] " : pubDef.getObjectOid()) + " de tipo " + Integer.toString(pubDef.getObjectType()));
                }
                if ((pubDef.getPublicationType() == 0 || pubDef.getPublicationType() == 1) && pubDef.getObjectType() != 13 || pubDef.getObjectType() != 17 || pubDef.getObjectType() != 18) {
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).info("R01GPublisherManager.prepareToPublish >> PASO 2: Consolidar todos los elementos a publicar en la zona de STAGING");
                    }
                    boolean allCommitedCorrectly = this._consolidateResources(pubDef.getObjectOid(), pubDef.getObjectType(), dsMngr, resourcesList);
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).info("R01GPublisherManager.prepareToPublish >>  ... recursos consolidados " + (allCommitedCorrectly ? "CORRECTAMENTE" : "CON ERRORES") + " para el objeto " + (StringUtils.isEmptyString((String)pubDef.getObjectOid()) ? " [empty / null] " : pubDef.getObjectOid()) + " de tipo " + Integer.toString(pubDef.getObjectType()));
                    }
                }
                boolean executedSpecificMethodOK = true;
                if (pubDef.getStepsActions() != null && !pubDef.getStepsActions().isEmpty()) {
                    R01MPublishActionObject prepareToPublishAction = (R01MPublishActionObject)pubDef.getStepsActions().get(0);
                    Object prepareToPublishActionManager = null;
                    try {
                        prepareToPublishActionManager = ReflectionUtils.getObjectInstance((String)prepareToPublishAction.getActionClass(), null, null, (boolean)true);
                    }
                    catch (ReflectionException rEx) {
                        throw new R01MPublisherException("R01DPublisherManager.prepareToPublish >> Error al instanciar la clase manejadora de las acciones de publicaci\u00f3n: " + prepareToPublishAction.getActionClass() + "Al llamar a la ejecuci\u00f3n de la publicaci\u00f3n del objeto " + (pubDef.getObjectOid() == null ? "[no definido]" : pubDef.getObjectOid()) + " de tipo " + R01MConstants.OBJECT_DESCS[pubDef.getObjectType()] + ". Error: " + rEx.getMessage(), (Exception)((Object)rEx));
                    }
                    try {
                        ReflectionUtils.invokeMethod((Object)prepareToPublishActionManager, (String)prepareToPublishAction.getMethod(), (Class[])new Class[]{String.class, String.class}, (Object[])new Object[]{prepareToPublishAction.getObjectOid(), prepareToPublishAction.getParam()});
                    }
                    catch (ReflectionException refEx) {
                        try {
                            pubDef.setPublicationState(-1);
                            this._updateErrorPublicationState(pubDef);
                            this._sendStepFinishedMessage("ERROR", "PrepareToPublish finished with errors. Error: " + refEx.getMessage(), 0, pubDef);
                        }
                        catch (R01MPublisherException pubEx) {
                            R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.prepareToPublish >> Error al ejecutar las acciones mandar el mensaje de finished: " + pubEx.getMessage() + " con el error: " + refEx.getMessage());
                        }
                        executedSpecificMethodOK = false;
                    }
                    catch (Throwable ex) {
                        try {
                            pubDef.setPublicationState(-1);
                            this._updateErrorPublicationState(pubDef);
                            this._sendStepFinishedMessage("ERROR", "PrepareToPublish finished with errors. Error: " + ex.getMessage(), 0, pubDef);
                        }
                        catch (R01MPublisherException pubEx) {
                            R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.prepareToPublish >> Error al mandar el mensaje de finished: " + pubEx.getMessage() + " con el error: " + ex.getMessage());
                        }
                        executedSpecificMethodOK = false;
                    }
                }
                if (executedSpecificMethodOK) {
                    try {
                        pubDef.setPublicationState(-1);
                        this._sendStepFinishedMessage("OK", "Prepare to publish finished correctly", 0, pubDef);
                    }
                    catch (R01MPublisherException pubEx) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager.prepareToPublish >> Error al mandar el mensaje de finished: " + pubEx.getMessage() + " de OK");
                        throw pubEx;
                    }
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).info("R01GPublisherManager.prepareToPublish >> Proceso de prepareToPublish finalizado para el objeto " + (StringUtils.isEmptyString((String)pubDef.getObjectOid()) ? " [empty / null] " : pubDef.getObjectOid()) + " de tipo " + Integer.toString(pubDef.getObjectType()));
                    }
                }
            }
        }
    }

    public void prePublish(R01PPublishDefinition pubDef) throws R01MPublisherException {
        boolean inputParamsOK = true;
        try {
            this._checkPublishProcessInputParams(1, pubDef);
        }
        catch (R01MPublisherException pEx) {
            try {
                pubDef.setPublicationState(-1);
                this._updateErrorPublicationState(pubDef);
                this._sendStepFinishedMessage("ERROR", "PrePublish finished with errors. Error: " + pEx.getMessage(), 1, pubDef);
            }
            catch (R01MPublisherException pubEx) {
                R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager.prePublish >> Error al mandar el mensaje de finished: " + pubEx.getMessage() + " con el error: " + pEx.getMessage());
            }
            inputParamsOK = false;
        }
        if (inputParamsOK) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("R01GPublisherManager.prePublish >> Par\u00e1metros de entrada:" + pubDef.debugInfo("").toString());
            }
            if (pubDef.getObjectType() == 17 || pubDef.getObjectType() == 18) {
                boolean updateFileStructure = true;
                R01GPortalModelManager manager = new R01GPortalModelManager();
                try {
                    if (pubDef.getObjectType() != 17 && (manager.doLoadPageAliasesInState(pubDef.getObjectOid(), 1) == null || manager.doLoadPageAliasesInState(pubDef.getObjectOid(), 1).isEmpty()) && (manager.doLoadPageAliasesInState(pubDef.getObjectOid(), 0) == null || manager.doLoadPageAliasesInState(pubDef.getObjectOid(), 0).isEmpty()) || pubDef.getObjectType() == 18 && (manager.doLoadPortalAliasesInState(pubDef.getObjectOid(), 1) == null || manager.doLoadPortalAliasesInState(pubDef.getObjectOid(), 1).isEmpty()) && (manager.doLoadPortalAliasesInState(pubDef.getObjectOid(), 0) == null || manager.doLoadPortalAliasesInState(pubDef.getObjectOid(), 0).isEmpty())) {
                        updateFileStructure = false;
                    }
                }
                catch (R01MPortalModelException pmEx) {
                    throw new R01MPublisherException("R01GPublisherManager.prePublish >> Error al cargar los alias de la p\u00e1gina: Al llamar a la ejecuci\u00f3n de la publicaci\u00f3n del objeto " + pubDef.getObjectOid() + " de " + "tipo " + R01MConstants.OBJECT_DESCS[pubDef.getObjectType()] + ". " + "Error: " + pmEx.getMessage(), (Exception)((Object)pmEx));
                }
                catch (R01MSecurityException secEx) {
                    throw new R01MPublisherException("R01GPublisherManager.prePublish >> Error al cargar los alias de la p\u00e1gina: Al llamar a la ejecuci\u00f3n de la publicaci\u00f3n del objeto " + pubDef.getObjectOid() + " de " + "tipo " + R01MConstants.OBJECT_DESCS[pubDef.getObjectType()] + ". " + "Error: " + secEx.getMessage(), (Exception)((Object)secEx));
                }
                if (updateFileStructure) {
                    new R01PAliasManagerAPI().updateApacheRules(pubDef.getObjectOid(), pubDef.getObjectType() == 17 ? 4 : 3, false);
                }
            }
            boolean executedSpecificMethodOK = true;
            if (pubDef.getStepsActions() != null && !pubDef.getStepsActions().isEmpty()) {
                R01MPublishActionObject prePublishAction = (R01MPublishActionObject)pubDef.getStepsActions().get(0);
                Object prepareToPublishActionManager = null;
                try {
                    prepareToPublishActionManager = ReflectionUtils.getObjectInstance((String)prePublishAction.getActionClass(), null, null, (boolean)true);
                }
                catch (ReflectionException rEx) {
                    throw new R01MPublisherException("R01GPublisherManager.prePublish >> Error al instanciar la clase manejadora de las acciones de publicaci\u00f3n: " + prePublishAction.getActionClass() + "Al llamar a la ejecuci\u00f3n de la publicaci\u00f3n del objeto " + (pubDef.getObjectOid() == null ? "[no definido]" : pubDef.getObjectOid()) + " de tipo " + R01MConstants.OBJECT_DESCS[pubDef.getObjectType()] + ". Error: " + rEx.getMessage(), (Exception)((Object)rEx));
                }
                try {
                    ReflectionUtils.invokeMethod((Object)prepareToPublishActionManager, (String)prePublishAction.getMethod(), (Class[])new Class[]{String.class, String.class}, (Object[])new Object[]{prePublishAction.getObjectOid(), prePublishAction.getParam()});
                }
                catch (ReflectionException refEx) {
                    try {
                        pubDef.setPublicationState(-1);
                        this._updateErrorPublicationState(pubDef);
                        this._sendStepFinishedMessage("ERROR", "PrePublish finished with errors. Error: " + refEx.getMessage(), 1, pubDef);
                    }
                    catch (R01MPublisherException pubEx) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.prePublish >> Error al ejecutar las acciones mandar el mensaje de finished: " + pubEx.getMessage() + " con el error: " + refEx.getMessage());
                    }
                    executedSpecificMethodOK = false;
                }
                catch (Throwable ex) {
                    try {
                        pubDef.setPublicationState(-1);
                        this._updateErrorPublicationState(pubDef);
                        this._sendStepFinishedMessage("ERROR", "PrePublish finished with errors. Error: " + ex.getMessage(), 1, pubDef);
                    }
                    catch (R01MPublisherException pubEx) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.prePublish >> Error al mandar el mensaje de finished: " + pubEx.getMessage() + " con el error: " + ex.getMessage());
                    }
                    executedSpecificMethodOK = false;
                }
            }
            if (executedSpecificMethodOK) {
                try {
                    pubDef.setPublicationState(-1);
                    this._sendStepFinishedMessage("OK", "PrePublish finished correctly", 1, pubDef);
                }
                catch (R01MPublisherException pubEx) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager.prePublish >> Error al mandar el mensaje de finished: " + pubEx.getMessage() + " de OK");
                    throw pubEx;
                }
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("R01GPublisherManager.prePublish >> Proceso de prePublish finalizado para el objeto " + (StringUtils.isEmptyString((String)pubDef.getObjectOid()) ? " [empty / null] " : pubDef.getObjectOid()) + " de tipo " + Integer.toString(pubDef.getObjectType()));
                }
            }
        }
    }

    public void publish(R01PPublishDefinition pubDef) throws R01MPublisherException {
        boolean inputParamsOK = true;
        try {
            this._checkPublishProcessInputParams(2, pubDef);
        }
        catch (R01MPublisherException pEx) {
            try {
                pubDef.setPublicationState(-1);
                this._updateErrorPublicationState(pubDef);
                this._sendStepFinishedMessage("ERROR", "Publish finished with errors. Error: " + pEx.getMessage(), 2, pubDef);
            }
            catch (R01MPublisherException pubEx) {
                R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager.publish >> Error al mandar el mensaje de finished: " + pubEx.getMessage() + " con el error: " + pEx.getMessage());
            }
            inputParamsOK = false;
        }
        if (inputParamsOK) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("R01GPublisherManager.publish >> Par\u00e1metros de entrada:" + pubDef.debugInfo("").toString());
            }
            boolean executedSpecificMethodOK = true;
            if (pubDef.getStepsActions() != null && !pubDef.getStepsActions().isEmpty()) {
                R01MPublishActionObject publishAction = (R01MPublishActionObject)pubDef.getStepsActions().get(0);
                Object prepareToPublishActionManager = null;
                try {
                    prepareToPublishActionManager = ReflectionUtils.getObjectInstance((String)publishAction.getActionClass(), null, null, (boolean)true);
                }
                catch (ReflectionException rEx) {
                    throw new R01MPublisherException("R01DPublisherManager.publish >> Error al instanciar la clase manejadora de las acciones de publicaci\u00f3n: " + publishAction.getActionClass() + "Al llamar a la ejecuci\u00f3n de la publicaci\u00f3n del objeto " + (pubDef.getObjectOid() == null ? "[no definido]" : pubDef.getObjectOid()) + " de tipo " + R01MConstants.OBJECT_DESCS[pubDef.getObjectType()] + ". Error: " + rEx.getMessage(), (Exception)((Object)rEx));
                }
                try {
                    ReflectionUtils.invokeMethod((Object)prepareToPublishActionManager, (String)publishAction.getMethod(), (Class[])new Class[]{String.class, String.class}, (Object[])new Object[]{publishAction.getObjectOid(), publishAction.getParam()});
                }
                catch (ReflectionException refEx) {
                    try {
                        pubDef.setPublicationState(-1);
                        this._updateErrorPublicationState(pubDef);
                        this._sendStepFinishedMessage("ERROR", "Publish finished with errors. Error: " + refEx.getMessage(), 2, pubDef);
                    }
                    catch (R01MPublisherException pubEx) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.publish >> Error al ejecutar las acciones mandar el mensaje de finished: " + pubEx.getMessage() + " con el error: " + refEx.getMessage());
                    }
                    executedSpecificMethodOK = false;
                }
                catch (Throwable ex) {
                    try {
                        pubDef.setPublicationState(-1);
                        this._updateErrorPublicationState(pubDef);
                        this._sendStepFinishedMessage("ERROR", "Publish finished with errors. Error: " + ex.getMessage(), 2, pubDef);
                    }
                    catch (R01MPublisherException pubEx) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.publish >> Error al mandar el mensaje de finished: " + pubEx.getMessage() + " con el error: " + ex.getMessage());
                    }
                    executedSpecificMethodOK = false;
                }
            }
            if (executedSpecificMethodOK) {
                try {
                    pubDef.setPublicationState(-1);
                    this._sendStepFinishedMessage("OK", "Publish finished correctly", 2, pubDef);
                }
                catch (R01MPublisherException pubEx) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager.publish >> Error al mandar el mensaje de finished: " + pubEx.getMessage() + " de OK");
                    throw pubEx;
                }
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("R01GPublisherManager.publish >> Proceso de publish finalizado para el objeto " + (StringUtils.isEmptyString((String)pubDef.getObjectOid()) ? " [empty / null] " : pubDef.getObjectOid()) + " de tipo " + Integer.toString(pubDef.getObjectType()));
                }
            }
        }
    }

    public void postPublish(R01PPublishDefinition pubDef) throws R01MPublisherException {
        boolean inputParamsOK = true;
        try {
            this._checkPublishProcessInputParams(3, pubDef);
            if (pubDef.getPublicationState() != 0 && pubDef.getPublicationState() != 1 && pubDef.getPublicationState() != 2 && pubDef.getPublicationState() != 3) {
                R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager.postPublish >> Se ha solicitado el proceso de postPublish y el estado final de la publicaci\u00f3n no se reconoce o no es v\u00e1lido: " + Integer.toString(pubDef.getPublicationState()));
                throw new R01MPublisherException("Se ha solicitado el proceso de postPublish y el estado final de la publicaci\u00f3n no se reconoce o no es v\u00e1lido: " + Integer.toString(pubDef.getPublicationState()));
            }
        }
        catch (R01MPublisherException pEx) {
            try {
                this._updateErrorPublicationState(pubDef);
                this._sendStepFinishedMessage("ERROR", "PostPublish finished with errors. Error: " + pEx.getMessage(), 3, pubDef);
            }
            catch (R01MPublisherException pubEx) {
                R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager.postPublish >> Error al mandar el mensaje de finished: " + pubEx.getMessage() + " con el error: " + pEx.getMessage());
            }
            inputParamsOK = false;
        }
        if (inputParamsOK) {
            R01GAliasAdminManager aliasManager;
            if (pubDef.getObjectType() == 4 && (pubDef.getPublicationType() == 2 || pubDef.getPublicationType() == 3)) {
                try {
                    R01GPortalModelManager portalManager = new R01GPortalModelManager();
                    R01MPage page = portalManager.doLoadPortalPage(this._userCtx, pubDef.getObjectOid());
                    Map langAVs = page.getVisualAreasGroupedByLanguage();
                    if (langAVs != null && !langAVs.isEmpty()) {
                        String currLang2 = null;
                        String gendataDomainPrefix = XMLProperties.getProperty((String)R01MConstants.INTERNALAPI_APPCODE, (String)"autonomy/gendataPrefixInAutonomy/default", (String)"http://www.euskadi.net");
                        gendataDomainPrefix = XMLProperties.getProperty((String)R01MConstants.INTERNALAPI_APPCODE, (String)("autonomy/gendataPrefixInAutonomy/" + pubDef.getRepositoryOid()), (String)"http://www.euskadi.net");
                        for (String currLang2 : langAVs.keySet()) {
                            try {
                                StringBuffer gendataUrl = new StringBuffer();
                                for (R01MPortalPublicationTarget currentPublicationInfo : page.getPublicationInfo()) {
                                    if (currentPublicationInfo.getState() != 1) continue;
                                    gendataUrl.append(gendataDomainPrefix).append("/pages/data/").append(currentPublicationInfo.getUrl().substring(currentPublicationInfo.getUrl().lastIndexOf(47) + 1)).append('/').append(currLang2).append('_').append(currentPublicationInfo.getUrl().substring(currentPublicationInfo.getUrl().lastIndexOf(47) + 1)).append('/').append(XMLProperties.getProperty((String)R01MConstants.INTERNALAPI_APPCODE, (String)"autonomy/autonomyIndexService/gendataFileName", (String)"r01_gendata.txt"));
                                    break;
                                }
                                String databaseInAutonomy = XMLProperties.getProperty((String)R01MConstants.INTERNALAPI_APPCODE, (String)("autonomy/databaseInAutonomy/" + pubDef.getRepositoryOid()), (String)"euskadi_db");
                                R01PClientFactory.getSearchEngineIndexerAPI().injectDataForIndexInAutonomy(pubDef.getObjectOid(), currLang2 + "_" + pubDef.getObjectOid(), 1, "-", gendataUrl.toString(), databaseInAutonomy);
                            }
                            catch (R01MSearchIndexerException siEx) {
                                R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager.prepareToPublish >> Error al mandar a desindexar directamente en el autonomy la pagina de portal " + currLang2 + "_" + pubDef.getObjectOid() + ": " + siEx.getMessage());
                            }
                        }
                    }
                }
                catch (R01MPortalModelObjectsValidatorException pmEx) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager.prepareToPublish >> Error al cargar las AV por idioma para la p\u00e1gina " + (pubDef.getObjectOid() == null ? "[null]" : pubDef.getObjectOid()) + ". Error: " + pmEx.getMessage());
                }
                catch (R01MPortalModelException pmEx) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager.prepareToPublish >> Error al cargar la p\u00e1gina " + (pubDef.getObjectOid() == null ? "[null]" : pubDef.getObjectOid()) + ". Error: " + pmEx.getMessage());
                }
                catch (R01MSecurityException secEx) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager.prepareToPublish >> Error al cargar la p\u00e1gina " + (pubDef.getObjectOid() == null ? "[null]" : pubDef.getObjectOid()) + ". Error: " + secEx.getMessage());
                }
            }
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("R01GPublisherManager.postPublish >> Par\u00e1metros de entrada:" + pubDef.debugInfo("").toString() + "\n ESTADO FINAL DE LA PUBLICACI\u00d3N: " + R01MBasePublicationTarget.getPublicationStateLabel((int)pubDef.getPublicationState()));
            }
            boolean updatePublicationInformationOK = true;
            if (pubDef.getObjectType() == 4) {
                R01MPage page = null;
                try {
                    page = this._updatePublishInfo(pubDef.getObjectOid(), pubDef.getRepositoryOid(), pubDef.getPublicationType(), pubDef.getPublicationDate(), pubDef.getPublicationState());
                }
                catch (R01MPublisherException pEx) {
                    try {
                        this._updateErrorPublicationState(pubDef);
                        this._sendStepFinishedMessage("ERROR", "PostPublish finished with errors. Error: " + pEx.getMessage(), 3, pubDef);
                    }
                    catch (R01MPublisherException pubEx) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager.postPublish >>  Par\u00e1metros de entrada:\n" + pubDef.debugInfo("").toString() + "\n ESTADO FINAL DE LA PUBLICACI\u00d3N: " + R01MBasePublicationTarget.getPublicationStateLabel((int)pubDef.getPublicationState()) + "Error al mandar el mensaje de finished: " + pubEx.getMessage() + " con el error: " + pEx.getMessage());
                    }
                    updatePublicationInformationOK = false;
                }
                if (updatePublicationInformationOK) {
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).info("R01GPublisherManager.postPublish >> Actualizada la informaci\u00f3n de publicaci\u00f3n para el objeto " + (StringUtils.isEmptyString((String)pubDef.getObjectOid()) ? " [empty / null] " : pubDef.getObjectOid()) + " de tipo " + Integer.toString(pubDef.getObjectType()));
                    }
                    if (pubDef.getObjectType() == 10) {
                        R01GHistoryHelper.doInsertHistoryRecord(this._userCtx, page.getOid(), pubDef.getRepositoryOid(), page.getInternalName(), 1, 2, new StringBuffer("P\u00e1gina " + page.getOid() + R01MBasePublicationTarget.getPublicationStateLabel((int)pubDef.getPublicationState()) + ". Repositorio de publicaci\u00f3n: " + pubDef.getRepositoryOid()));
                        if (DEBUG) {
                            R01FLog.to((String)LOG_TYPE_ID).info("R01GPublisherManager.postPublish >> Actualizada la informaci\u00f3n del historico para el objeto " + (StringUtils.isEmptyString((String)pubDef.getObjectOid()) ? " [empty / null] " : pubDef.getObjectOid()) + " de tipo " + Integer.toString(pubDef.getObjectType()));
                        }
                    }
                    if (page.isIndexActive()) {
                        try {
                            if (pubDef.getPublicationType() == 0 || pubDef.getPublicationType() == 1) {
                                this._sendIndexMessage(pubDef.getObjectOid(), pubDef.getObjectType(), pubDef.getResourcesRelativePaths(), pubDef.getRepositoryOid(), null, pubDef.getPublicationType(), pubDef.getPublicationDate());
                            } else {
                                List indexers = new ArrayList();
                                indexers = XMLProperties.getPropertyList((String)R01MConstants.API_APPCODE, (String)"indexersConfigurations/default/indexer", Arrays.asList("com.ejie.r01k.searchorchestrator.indexer.indexers.R01KDataBaseIndexer"));
                                this._sendIndexMessage(pubDef.getObjectOid(), pubDef.getObjectType(), pubDef.getResourcesRelativePaths(), pubDef.getRepositoryOid(), indexers, pubDef.getPublicationType(), pubDef.getPublicationDate());
                            }
                        }
                        catch (R01MPublisherException pEx) {
                            try {
                                this._updateErrorPublicationState(pubDef);
                                this._sendStepFinishedMessage("ERROR", "PostPublish finished with errors. Error: " + pEx.getMessage(), 3, pubDef);
                            }
                            catch (R01MPublisherException pubEx) {
                                R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager.postPublish >>  Par\u00e1metros de entrada:\n" + pubDef.debugInfo("").toString() + "\n ESTADO FINAL DE LA PUBLICACI\u00d3N: " + R01MBasePublicationTarget.getPublicationStateLabel((int)pubDef.getPublicationState()) + "Error al mandar el mensaje de finished: " + pubEx.getMessage() + " con el error: " + pEx.getMessage());
                            }
                        }
                        if (DEBUG) {
                            R01FLog.to((String)LOG_TYPE_ID).info("R01GPublisherManager.postPublish >> Solicitada la indexaci\u00f3n para el objeto " + (StringUtils.isEmptyString((String)pubDef.getObjectOid()) ? " [empty / null] " : pubDef.getObjectOid()) + " de tipo " + Integer.toString(pubDef.getObjectType()));
                        }
                    } else if (page.isUnpublishIndexFiles()) {
                        try {
                            R01PPublishDefinition pubDefinition = new R01PPublishDefinition(pubDef.getUserName(), pubDef.getObjectOid(), 10, null, null, null, pubDef.getRepositoryOid(), pubDef.getPublicationType() == 0 || pubDef.getPublicationType() == 1 ? 0 : 2, new Date(), null, true, null, null);
                            R01PClientFactory.getPublisherAPI().publish(pubDefinition);
                        }
                        catch (R01MPublisherException pEx) {
                            R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager.postPublish >>  Par\u00e1metros de entrada:\n" + pubDef.debugInfo("").toString() + "\n ESTADO FINAL DE LA PUBLICACI\u00d3N: " + R01MBasePublicationTarget.getPublicationStateLabel((int)pubDef.getPublicationState()) + "Error al mandar el mensaje de finished: " + pEx.getMessage() + " con el error: " + pEx.getMessage());
                        }
                        page.setUnpublishIndexFiles(false);
                        R01GPageAdminManager manager = new R01GPageAdminManager(this._userCtx);
                        try {
                            manager.doUpdatePage(page, false);
                        }
                        catch (R01MPortalModelObjectsValidatorException pmovEx) {
                            R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager.postPublish >> Publicando la p\u00e1gina " + page.getPortalOid() + "-" + page.getInternalName() + ". " + "La p\u00e1gina ten\u00eda informaci\u00f3n de indexaci\u00f3n publicada pero actualmente ya no se indexa. " + "Se ha producido un error al guardar la informaci\u00f3n del flag que indica si se debe " + "despublicar los ficheros de indexaci\u00f3n en la pr\u00f3xima publicaci\u00f3n. El flag quedar\u00e1 " + "activado por lo que en la pr\u00f3xima publicaci\u00f3n de la p\u00e1gina volver\u00e1 a intentar " + "despublicar los ficheros de indexaci\u00f3n. " + "Error:" + pmovEx.getMessage());
                        }
                        catch (R01MSecurityException secEx) {
                            R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager.postPublish >> Publicando la p\u00e1gina " + page.getPortalOid() + "-" + page.getInternalName() + ". " + "La p\u00e1gina ten\u00eda informaci\u00f3n de indexaci\u00f3n publicada pero actualmente ya no se indexa. " + "Se ha producido un error al guardar la informaci\u00f3n del flag que indica si se debe " + "despublicar los ficheros de indexaci\u00f3n en la pr\u00f3xima publicaci\u00f3n. El flag quedar\u00e1 " + "activado por lo que en la pr\u00f3xima publicaci\u00f3n de la p\u00e1gina volver\u00e1 a intentar " + "despublicar los ficheros de indexaci\u00f3n. " + "Error:" + secEx.getMessage());
                        }
                        catch (R01MPortalModelException pmEx) {
                            R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager.postPublish >> Publicando la p\u00e1gina " + page.getPortalOid() + "-" + page.getInternalName() + ". " + "La p\u00e1gina ten\u00eda informaci\u00f3n de indexaci\u00f3n publicada pero actualmente ya no se indexa. " + "Se ha producido un error al guardar la informaci\u00f3n del flag que indica si se debe " + "despublicar los ficheros de indexaci\u00f3n en la pr\u00f3xima publicaci\u00f3n. El flag quedar\u00e1 " + "activado por lo que en la pr\u00f3xima publicaci\u00f3n de la p\u00e1gina volver\u00e1 a intentar " + "despublicar los ficheros de indexaci\u00f3n. " + "Error:" + pmEx.getMessage());
                        }
                    }
                    this._sendAliasMessage(pubDef);
                }
            } else if (pubDef.getObjectType() == 17) {
                aliasManager = new R01GAliasAdminManager(this._userCtx);
                try {
                    aliasManager.doDeletePageAliasesInState(pubDef.getObjectOid(), 0);
                }
                catch (R01MPortalModelException pmEx) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager.postPublish >> Error en el paso postPub de la publicaci\u00f3n de alias p\u00e1gina.Error al eliminar los alias de la p\u00e1gina " + pubDef.getObjectOid() + ". " + "Error:" + pmEx.getMessage());
                }
            } else if (pubDef.getObjectType() == 18) {
                aliasManager = new R01GAliasAdminManager(this._userCtx);
                try {
                    aliasManager.doDeletePortalAliasesInState(pubDef.getObjectOid(), 0);
                }
                catch (R01MPortalModelException pmEx) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager.postPublish >> Error en el paso postPub de la publicaci\u00f3n de alias p\u00e1gina.Error al eliminar los alias de la p\u00e1gina " + pubDef.getObjectOid() + ". " + "Error:" + pmEx.getMessage());
                }
            }
            boolean executedSpecificMethodOK = true;
            if (pubDef.getStepsActions() != null && !pubDef.getStepsActions().isEmpty()) {
                R01MPublishActionObject postPublishAction = (R01MPublishActionObject)pubDef.getStepsActions().get(0);
                Object postPublishActionManager = null;
                try {
                    postPublishActionManager = ReflectionUtils.getObjectInstance((String)postPublishAction.getActionClass(), null, null, (boolean)true);
                }
                catch (ReflectionException rEx) {
                    throw new R01MPublisherException("R01DPublisherManager.postPublish >> Error al instanciar la clase manejadora de las acciones de publicaci\u00f3n: " + postPublishAction.getActionClass() + "Al llamar a la ejecuci\u00f3n de la publicaci\u00f3n del objeto " + (pubDef.getObjectOid() == null ? "[no definido]" : pubDef.getObjectOid()) + " de tipo " + R01MConstants.OBJECT_DESCS[pubDef.getObjectType()] + ". Error: " + rEx.getMessage(), (Exception)((Object)rEx));
                }
                try {
                    ReflectionUtils.invokeMethod((Object)postPublishActionManager, (String)postPublishAction.getMethod(), (Class[])new Class[]{String.class, String.class}, (Object[])new Object[]{postPublishAction.getObjectOid(), postPublishAction.getParam()});
                }
                catch (ReflectionException refEx) {
                    try {
                        pubDef.setPublicationState(-1);
                        this._updateErrorPublicationState(pubDef);
                        this._sendStepFinishedMessage("ERROR", "PostPublish finished with errors. Error: " + refEx.getMessage(), 3, pubDef);
                    }
                    catch (R01MPublisherException pubEx) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.postPublish >> Error al ejecutar las acciones mandar el mensaje de finished: " + pubEx.getMessage() + " con el error: " + refEx.getMessage());
                    }
                    executedSpecificMethodOK = false;
                }
                catch (Throwable ex) {
                    try {
                        pubDef.setPublicationState(-1);
                        this._updateErrorPublicationState(pubDef);
                        this._sendStepFinishedMessage("ERROR", "PostPublish finished with errors. Error: " + ex.getMessage(), 3, pubDef);
                    }
                    catch (R01MPublisherException pubEx) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.postPublish >> Error al mandar el mensaje de finished: " + pubEx.getMessage() + " con el error: " + ex.getMessage());
                    }
                    executedSpecificMethodOK = false;
                }
            }
            if (executedSpecificMethodOK) {
                try {
                    this._sendStepFinishedMessage("OK", "PostPublish finished correctly", 3, pubDef);
                }
                catch (R01MPublisherException pubEx) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager.postPublish >>  Par\u00e1metros de entrada:\n" + pubDef.debugInfo("").toString() + "\n ESTADO FINAL DE LA PUBLICACI\u00d3N: " + R01MBasePublicationTarget.getPublicationStateLabel((int)pubDef.getPublicationState()) + "Error al mandar el mensaje de finished: " + pubEx.getMessage() + " de OK");
                    throw pubEx;
                }
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("R01GPublisherManager.postPublish >> Proceso de postPublish finalizado para el objeto " + (StringUtils.isEmptyString((String)pubDef.getObjectOid()) ? " [empty / null] " : pubDef.getObjectOid()) + " de tipo " + Integer.toString(pubDef.getObjectType()));
                }
            }
        }
    }

    public void updateStatePublishInfo(String objectOid, int objectType, String publicationOid, int publicationState) throws R01MPublisherException {
        if (objectType != 4) {
            R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager.updateStatePublishInfo >> Desde el modelo de portales s\u00f3lo se actualizar\u00e1 el estado de los objetos de tipo p\u00e1gina de portal. \nNo se actualiza la petici\u00f3n para el objeto " + objectOid + " de " + "tipo " + objectType + " con " + "oid de publicaci\u00f3n " + publicationOid + " para el " + "estado de publicaci\u00f3n: " + publicationState);
        } else {
            R01MPage page;
            if (StringUtils.isEmptyString((String)publicationOid)) {
                throw new R01MPublisherException("Se ha solicitado una actualizaci\u00f3n de estado de publicaci\u00f3n y no se ha indicado el Oid de la publicaci\u00f3n a actualizar. No se actualiza la petici\u00f3n para el objeto " + objectOid + " de " + "tipo " + objectType + " con " + "oid de publicaci\u00f3n " + publicationOid + " para el " + "estado de publicaci\u00f3n: " + publicationState);
            }
            R01GPortalModelManager portalManager = new R01GPortalModelManager();
            try {
                page = portalManager.doLoadPortalPage(this._userCtx, objectOid);
            }
            catch (R01MPortalModelException pmEx) {
                R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager.updateStatePublishInfo >> Error al cargar la p\u00e1gina " + (objectOid == null ? "[null]" : objectOid) + ". Error: " + pmEx.getMessage());
                throw new R01MPublisherException("Error al cargar la p\u00e1gina " + (objectOid == null ? "[null]" : objectOid), (Exception)((Object)pmEx));
            }
            catch (R01MSecurityException secEx) {
                R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager.updateStatePublishInfo >> Error al cargar la p\u00e1gina " + (objectOid == null ? "[null]" : objectOid) + ". Error: " + secEx.getMessage());
                throw new R01MPublisherException("Error al cargar la p\u00e1gina " + (objectOid == null ? "[null]" : objectOid), (Exception)((Object)secEx));
            }
            List publishInfoInDB = page.getPublicationInfo();
            if (publishInfoInDB == null) {
                R01FLog.to((String)LOG_TYPE_ID).warning("R01GPublisherManager.updateStatePublishInfo >> Se ha solicitado actualizar el estado de publicaci\u00f3n de la p\u00e1gina " + objectOid + " y no hab\u00eda informaci\u00f3n de publicaci\u00f3n.");
            } else {
                Date now = new Date();
                R01MPortalPublicationTarget pubTargetInDB = null;
                for (int i = 0; i < publishInfoInDB.size(); ++i) {
                    pubTargetInDB = (R01MPortalPublicationTarget)publishInfoInDB.get(i);
                    if (pubTargetInDB.getPublicationOid() != publicationOid) continue;
                    pubTargetInDB.setState(publicationState);
                    pubTargetInDB.setPublishDate(now);
                    break;
                }
                try {
                    R01GPageBMPUtil.getLocalHome().findByPrimaryKey(page.getOid()).updatePublishPage(this._userCtx, publishInfoInDB);
                }
                catch (FinderException fndEx) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("PUBLISHERMANAGER (" + page.getOid() + ") > La p\u00e1gina no existe.");
                    throw new R01MPublisherException("Error la p\u00e1gina de oid " + page.getOid() + " no existe. Error: " + fndEx.getMessage(), (Exception)((Object)fndEx));
                }
                catch (NamingException namEx) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("PUBLISHERMANAGER (" + page.getOid() + ") > Error al obtener el interfaz home del BMP de p\u00e1gina de portal.");
                    throw new R01MPublisherException("Error al obtener el interfaz home del BMP de p\u00e1gina de portal. Error: " + namEx.getMessage(), (Exception)namEx);
                }
                catch (EJBException ex) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("PUBLISHERMANAGER (" + page.getOid() + ") > Error interno al actualizar la p\u00e1gina de portal.");
                    throw new R01MPublisherException("Error interno al actualizar la p\u00e1gina de oid " + page.getOid() + ". Error: " + ex.getMessage(), (Exception)((Object)ex));
                }
                catch (R01MPortalModelException ex) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("PUBLISHERMANAGER (" + page.getOid() + ") > Error al actualizar la p\u00e1gina de portal.");
                    throw new R01MPublisherException("Error al actualizar la p\u00e1gina de oid " + page.getOid() + ". Error: " + ex.getMessage(), (Exception)((Object)ex));
                }
                List repoPubInBDCMPList = null;
                R01GRepoPubPagePortalCMPLocal repoPubCMP2 = null;
                R01GRepoPubPagePortalCMPValue repoPubCMPValue = null;
                try {
                    repoPubInBDCMPList = (List)R01GRepoPubPagePortalCMPUtil.getLocalHome().findByPagePortalOid(page.getOid());
                }
                catch (FinderException e) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("PUBLISHERMANAGER >>>> Error al buscar la lista de publicaciones para el portal: " + page.getOid());
                    throw new R01MPublisherException("No se encuentra el JNDI del EJB de Publicaciones.", (Exception)((Object)e));
                }
                catch (NamingException namEx) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("PUBLISHERMANAGER >>>> No se encuentra el JNDI del EJB de Publicaciones");
                    throw new R01MPublisherException("No se encuentra el JNDI del EJB de Publicaciones.", (Exception)namEx);
                }
                if (repoPubInBDCMPList != null && !repoPubInBDCMPList.isEmpty()) {
                    for (R01GRepoPubPagePortalCMPLocal repoPubCMP2 : repoPubInBDCMPList) {
                        repoPubCMPValue = repoPubCMP2.getR01GRepoPubPagePortalCMPValue();
                        if (!repoPubCMPValue.getPublishOid().equals(publicationOid)) continue;
                        try {
                            repoPubCMPValue.setPublishDate(now);
                            repoPubCMPValue.setState(publicationState);
                            repoPubCMP2.setR01GRepoPubPagePortalCMPValue(repoPubCMPValue);
                        }
                        catch (EJBException ejbEx) {
                            R01FLog.to((String)LOG_TYPE_ID).severe("PUBLISHERMANAGER >>>> No se puede actualizar la Publicaci\u00f3n de la p\u00e1gina " + page.getOid() + " con " + "Oid de publicaci\u00f3n: " + publicationOid);
                            throw new R01MPublisherException("No se puede actualizar la Publicaci\u00f3n de la p\u00e1gina " + page.getOid() + " con " + "Oid de publicaci\u00f3n: " + publicationOid + ": " + ejbEx.getMessage(), (Exception)((Object)ejbEx));
                        }
                    }
                }
            }
        }
    }

    private List _preparePageFileListToPublish(R01MPage page, int publicationType, R01GPortalInDataStore dsMngr) throws R01MPublisherException {
        List resourcesList = this._obtainFileListToPublish(page, publicationType);
        String publishFileName = "";
        publishFileName = publicationType == 0 || publicationType == 1 ? StringUtils.replaceString((String)XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/publicationFileName", (String)"publicationfilelist_$PAGE_INTERNALNAME$.txt"), (String)"$PAGE_INTERNALNAME$", (String)page.getInternalName()) : StringUtils.replaceString((String)XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/unpublicationFileName", (String)"unpublicationfilelist_$PAGE_INTERNALNAME$.txt"), (String)"$PAGE_INTERNALNAME$", (String)page.getInternalName());
        this._createFileAndUploadToIW(page.getOid(), 4, publishFileName, resourcesList, dsMngr);
        return resourcesList;
    }

    private List _preparePageAliasFileListToPublish(R01MPage page, R01GPortalInDataStore dsMngr) throws R01MPublisherException {
        List resourcesList = this._obtainPageAliasFileListToPublish(page);
        String publishFileName = "";
        publishFileName = StringUtils.replaceString((String)XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/publicationPageAliasFileName", (String)"publicationPageAliasFileList-$PAGE_INTERNALNAME$.txt"), (String)"$PAGE_INTERNALNAME$", (String)page.getInternalName());
        this._createFileAndUploadToIW(page.getOid(), 4, publishFileName, resourcesList, dsMngr);
        return resourcesList;
    }

    private List _preparePageIndexFileListToPublish(R01MPage page, String portalOid) {
        ArrayList<R01MPublicationResourceItem> resourcesList = new ArrayList<R01MPublicationResourceItem>();
        R01MPublicationResourceItem indexAndHTMLdata = new R01MPublicationResourceItem();
        indexAndHTMLdata.type = "filedir";
        String dirToDelete = R01MPortalPathHelpper.replacePortalPageCodeInPath((String)R01MPortalPathHelpper.INDEXES_DIR, (String)portalOid, (String)(portalOid + "-" + page.getInternalName()));
        indexAndHTMLdata.description = dirToDelete.substring(dirToDelete.indexOf("/pages"));
        resourcesList.add(indexAndHTMLdata);
        return resourcesList;
    }

    private List _preparePortalAliasFileListToPublish(String portalOid, int publicationType, List resourcesRelativePaths, R01GPortalInDataStore dsMngr) throws R01MPublisherException {
        ArrayList<R01MPublicationResourceItem> resourcesList = null;
        if (resourcesRelativePaths != null) {
            R01MPublicationResourceItem itemToPublish = null;
            resourcesList = new ArrayList<R01MPublicationResourceItem>();
            for (String resFilePath : resourcesRelativePaths) {
                itemToPublish = new R01MPublicationResourceItem();
                itemToPublish.type = "filedir";
                itemToPublish.description = resFilePath;
                resourcesList.add(itemToPublish);
            }
        } else {
            resourcesList = this._obtainPortalAliasFileListToPublish(portalOid);
        }
        String publishFileName = "";
        publishFileName = StringUtils.replaceString((String)XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/publicationPortalAliasFileName", (String)"publicationPortalAliasFileList-$PORTAL_OID$.txt"), (String)"$PORTAL_OID$", (String)portalOid);
        this._createFileAndUploadToIW(portalOid, 3, publishFileName, resourcesList, dsMngr);
        return resourcesList;
    }

    private List _preparePortalResourcesFileListToPublish(String portalOid, int publicationType, List resourcesRelativePaths, R01GPortalInDataStore dsMngr) throws R01MPublisherException {
        ArrayList<R01MPublicationResourceItem> resourcesList = new ArrayList<R01MPublicationResourceItem>();
        String resourceTypesPub = "analytics";
        Iterator itResourcesString = resourcesRelativePaths.iterator();
        while (itResourcesString.hasNext()) {
            R01MPublicationResourceItem itemToPublish = new R01MPublicationResourceItem();
            itemToPublish.type = "filedir";
            itemToPublish.description = (String)itResourcesString.next();
            if (itemToPublish.description.indexOf("access") > 0) {
                resourceTypesPub = "access";
            }
            resourcesList.add(itemToPublish);
        }
        String publishFileName = publicationType == 0 || publicationType == 1 ? StringUtils.replaceString((String)XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/publicationFileName", (String)"publicationfilelist_$PAGE_INTERNALNAME$.txt"), (String)"$PAGE_INTERNALNAME$", (String)(portalOid + "-" + resourceTypesPub + "-resourceFiles")) : StringUtils.replaceString((String)XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/unpublicationFileName", (String)"unpublicationfilelist_$PAGE_INTERNALNAME$.txt"), (String)"$PAGE_INTERNALNAME$", (String)(portalOid + "-" + resourceTypesPub + "-resourceFiles"));
        this._createFileAndUploadToIW(portalOid, 12, publishFileName, resourcesList, dsMngr);
        return resourcesList;
    }

    private List _preparePortalDynamicVAFileListToPublish(String portalOid, R01GPortalModelManager portalManager, R01GPortalInDataStore dsMngr) throws R01MPublisherException {
        R01MVisualAreasConfig visualareasConfig;
        ArrayList<R01MVisualAreaInstance> allDynamicVAsToPublish = new ArrayList<R01MVisualAreaInstance>();
        try {
            visualareasConfig = R01GPortalLoaderFactory.getPortalConfigLoader().loadVisualAreasConfig();
        }
        catch (R01MConfigLoadException clEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error en la publicaci\u00f3n de \u00e1reas visuales din\u00e1micas del portal " + portalOid + " " + "al cargar la configuraci\u00f3n global de \u00e1reas visuales. Error: " + clEx.getMessage());
            throw new R01MPublisherException("Error en la publicaci\u00f3n de \u00e1reas visuales din\u00e1micas del portal " + portalOid + " " + "al cargar la configuraci\u00f3n global de \u00e1reas visuales.", (Exception)((Object)clEx));
        }
        R01GDAOPortalModelLoader loader = new R01GDAOPortalModelLoader();
        for (Map.Entry me : visualareasConfig.getVisualAreasRegeneration().entrySet()) {
            List visualAreaInstances;
            R01MVisualArea visualArea = (R01MVisualArea)me.getValue();
            try {
                visualAreaInstances = loader.findVisualAreaInstancesReferenced(portalOid, visualArea.getOid());
            }
            catch (R01GPortalModelPersistenceException ex) {
                R01FLog.to((String)LOG_TYPE_ID).severe("Error al cargar las instancias de Area Visual din\u00e1micas en el portal " + portalOid + "." + "Error: " + ex.getMessage());
                throw new R01MPublisherException("Error al cargar las instancias de Area Visual din\u00e1micas en el portal " + portalOid, (Exception)((Object)ex));
            }
            if (visualAreaInstances == null || visualAreaInstances.isEmpty()) continue;
            for (R01MVisualAreaInstanceResume vaInstanceResume : visualAreaInstances) {
                try {
                    allDynamicVAsToPublish.add(portalManager.doLoadVisualAreaInstance(this._userCtx, vaInstanceResume.getOid()));
                }
                catch (R01MPortalModelException ex) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("Error en la publicaci\u00f3n de \u00e1reas visuales din\u00e1micas del portal " + portalOid + ". " + "Error al cargar el \u00e1rea visual de oid " + vaInstanceResume.getOid() + "." + "Error: " + ex.getMessage());
                }
                catch (R01MSecurityException ex) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("Error al cargar las instancias de Area Visual din\u00e1micas en el portal " + portalOid + "." + "Error: " + ex.getMessage());
                }
            }
        }
        List resourcesList = this._getVisualAreaFileListToPublish(portalOid, allDynamicVAsToPublish);
        String publishFileName = StringUtils.replaceString((String)R01GConstants.PORTAL_PUBLICATIONFILELISTNAME, (String)"$PAGE_INTERNALNAME$", (String)("dinamicVisualAreas-" + portalOid));
        this._createFileAndUploadToIW(portalOid, 14, publishFileName, resourcesList, dsMngr);
        return resourcesList;
    }

    private List _prepareVAFileListToPublish(String visualAreaOid, String portalOid, R01GPortalModelManager portalManager, R01GPortalInDataStore dsMngr) throws R01MPublisherException {
        R01MVisualAreaInstance visualArea = null;
        try {
            visualArea = portalManager.doLoadVisualAreaInstance(this._userCtx, visualAreaOid);
        }
        catch (R01MPortalModelException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al publicar el \u00e1rea visual " + visualAreaOid + "." + "Error al cargar la instancia del \u00e1rea visual. Error: " + ex.getMessage());
            throw new R01MPublisherException("Error al publicar el \u00e1rea visual " + visualAreaOid + "." + "Error al cargar la instancia del \u00e1rea visual.", (Exception)((Object)ex));
        }
        catch (R01MSecurityException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al publicar el \u00e1rea visual " + visualAreaOid + "." + "Error al cargar la instancia del \u00e1rea visual. Error: " + ex.getMessage());
            throw new R01MPublisherException("Error al publicar el \u00e1rea visual " + visualAreaOid + "." + "Error al cargar la instancia del \u00e1rea visual.", (Exception)((Object)ex));
        }
        ArrayList<R01MVisualAreaInstance> vaInstances = new ArrayList<R01MVisualAreaInstance>();
        vaInstances.add(visualArea);
        List resourcesList = this._getVisualAreaFileListToPublish(portalOid, vaInstances);
        String publishFileName = StringUtils.replaceString((String)R01GConstants.PORTAL_PUBLICATIONFILELISTNAME, (String)"$PAGE_INTERNALNAME$", (String)("visualArea-" + ((R01MVisualAreaInstance)vaInstances.get(0)).getName()));
        this._createFileAndUploadToIW(visualAreaOid, 7, publishFileName, resourcesList, dsMngr);
        return resourcesList;
    }

    private List _prepareSystemResourcesFileListToPublish(List resourcesRelativePaths) {
        ArrayList<R01MPublicationResourceItem> resourcesList = new ArrayList<R01MPublicationResourceItem>();
        R01MPublicationResourceItem itemToPublish = new R01MPublicationResourceItem();
        itemToPublish.type = "filedir";
        itemToPublish.description = (String)resourcesRelativePaths.get(0);
        resourcesList.add(itemToPublish);
        return resourcesList;
    }

    private List _getVisualAreaFileListToPublish(String portalOid, List vaInstances) {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("PUBLISHERMANAGER >>>> Componer los recursos a publicar: carpetas y ficheros...");
        }
        ArrayList<R01MPublicationResourceItem> resourcesToPublishList = new ArrayList<R01MPublicationResourceItem>();
        for (R01MVisualAreaInstance vaInstance : vaInstances) {
            List langsVA;
            if (vaInstance == null || (langsVA = vaInstance.getLanguages()) == null || langsVA.isEmpty()) continue;
            Iterator itLanguages = langsVA.iterator();
            while (itLanguages.hasNext()) {
                String vaLang = itLanguages.next().toString();
                R01MPublicationResourceItem itemToPublish = new R01MPublicationResourceItem();
                itemToPublish.type = "filedir";
                itemToPublish.description = R01MPathHelpper.getPortalAVPublicationPath((String)portalOid, (String)vaInstance.getVisualAreaOid(), (String)vaLang, (String)vaInstance.getName(), (String)R01MVisualAreasConfig.getGeneratedFileExtensionForVisualArea((String)vaInstance.getVisualAreaOid(), (String)"html"));
                resourcesToPublishList.add(itemToPublish);
            }
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tlista de recursos (carpetas y ficheros) a publicar obtenida...");
        }
        return resourcesToPublishList;
    }

    private void _createFileAndUploadToIW(String objectOid, int objectType, String publishFileName, List resourcesList, R01GPortalInDataStore dsMngr) throws R01MPublisherException {
        try {
            ByteArrayInputStream byteArrayInputStreamFileList = R01MPublisherUtils.generatePublicationFilelistInputStream((List)resourcesList);
            dsMngr.uploadPublishFile(publishFileName, (InputStream)byteArrayInputStreamFileList);
        }
        catch (R01MDataStoreException dsEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al subir el fichero de publiciones del recurso " + objectOid + " de tipo " + (objectType > R01MConstants.OBJECT_DESCS.length || objectType < 0 ? " {tipo inv\u00e1lido: " + objectType + "}" : R01MConstants.OBJECT_DESCS[objectType]) + " al datastore: " + dsEx.getMessage());
            throw new R01MPublisherException("Error al subir el fichero de publiciones del recurso " + objectOid + " de tipo " + (objectType > R01MConstants.OBJECT_DESCS.length || objectType < 0 ? " {tipo inv\u00e1lido: " + objectType + "}" : R01MConstants.OBJECT_DESCS[objectType]) + " al datastore.", (Exception)((Object)dsEx));
        }
    }

    private void _updatePublications(R01MPortal portal, R01MPage pagePortal, R01GPubliPdtesCMPValue publiPdteVO, String publicationOid, int publicationState) throws R01MPublisherException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("PUBLISHERMANAGER >>>> Actualizando las publicaciones de la p\u00e1gina :" + pagePortal.getOid() + " en el " + "repositorio de oid " + publicationOid);
        }
        R01MPortalPublicationTarget publicationTarget = new R01MPortalPublicationTarget();
        publicationTarget.setOid(publiPdteVO.getRepositoryOid());
        publicationTarget.setPublicationOid(publicationOid);
        publicationTarget.setPublisherConfirmation(0);
        publicationTarget.setMainAlias(pagePortal.getMainAliasURLByLang());
        R01GRepoPubPagePortalCMPValue publiVO = new R01GRepoPubPagePortalCMPValue();
        publiVO.setRepositoryOid(publiPdteVO.getRepositoryOid());
        publiVO.setPagePortalOid(publiPdteVO.getPageOid());
        publiVO.setPublishOid(publicationOid);
        publiVO.setPublicationConfirm(Integer.valueOf(Integer.toString(0)));
        publiVO.setMainAlias(publicationTarget.getMainAliasDBValue());
        if (publiPdteVO.getPublicationType() == 0 || publiPdteVO.getPublicationType() == 2) {
            publiVO.setPublishDate(Calendar.getInstance().getTime());
            publicationTarget.setPublishDate(Calendar.getInstance().getTime());
        } else {
            publiVO.setPublishDate(publiPdteVO.getOperationDate());
            publicationTarget.setPublishDate(publiPdteVO.getOperationDate());
        }
        publiVO.setState(publicationState);
        publicationTarget.setState(publicationState);
        if (publiPdteVO.getPublicationType() == 0 || publiPdteVO.getPublicationType() == 1) {
            String urlPublication = R01MPortalPathHelpper.obtainPublishedPageURL((String)portal.getPortalDomain(), (String)portal.getOid(), (String)pagePortal.getInternalName());
            publiVO.setUrl(urlPublication);
            publicationTarget.setUrl(urlPublication);
        } else {
            publiVO.setUrl("/");
            publicationTarget.setUrl("/");
        }
        Map pubRequestedMap = pagePortal.getRequestedPublications();
        if (pubRequestedMap != null) {
            for (Map.Entry entry : pubRequestedMap.entrySet()) {
                R01MPortalPublicationRequested pubReq = (R01MPortalPublicationRequested)entry.getValue();
                if (publiPdteVO.getPublicationType().intValue() != pubReq.getOperationType() || !publiPdteVO.getRepositoryOid().equals(pubReq.getRepositoryOid())) continue;
                pubRequestedMap.remove(entry.getKey());
            }
        }
        pagePortal.setRequestedPublications(pubRequestedMap);
        ArrayList<R01MPortalPublicationTarget> currPublishInfoInDB = pagePortal.getPublicationInfo();
        if (currPublishInfoInDB == null) {
            currPublishInfoInDB = new ArrayList<R01MPortalPublicationTarget>();
        } else if (!currPublishInfoInDB.isEmpty()) {
            for (int i = 0; i < currPublishInfoInDB.size(); ++i) {
                R01MPortalPublicationTarget pubTargetInDB = (R01MPortalPublicationTarget)currPublishInfoInDB.get(i);
                if (pubTargetInDB.getState() == publicationTarget.getState() && pubTargetInDB.getOid().equals(publicationTarget.getOid())) {
                    currPublishInfoInDB.remove(i--);
                    continue;
                }
                if (!pubTargetInDB.getOid().equals(publicationTarget.getOid()) || !(pubTargetInDB.getState() == 3 || pubTargetInDB.getState() == 2 || publicationState == 1 && pubTargetInDB.getState() == 4 || publicationState == 3 && pubTargetInDB.getState() == 4 || publicationState == 0 && pubTargetInDB.getState() == 5) && (publicationState != 2 || pubTargetInDB.getState() != 5)) continue;
                currPublishInfoInDB.remove(i--);
            }
        }
        currPublishInfoInDB.add(publicationTarget);
        pagePortal.setPublicationInfo(currPublishInfoInDB);
        try {
            R01GPageBMPUtil.getLocalHome().findByPrimaryKey(pagePortal.getOid()).updatePublishPage(this._userCtx, currPublishInfoInDB);
        }
        catch (FinderException fndEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("PUBLISHERMANAGER (" + pagePortal.getOid() + ") > La p\u00e1gina no existe.");
            throw new R01MPublisherException("Error la p\u00e1gina de oid " + pagePortal.getOid() + " no existe. Error: " + fndEx.getMessage(), (Exception)((Object)fndEx));
        }
        catch (NamingException namEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("PUBLISHERMANAGER (" + pagePortal.getOid() + ") > Error al obtener el interfaz home del BMP de p\u00e1gina de portal.");
            throw new R01MPublisherException("Error al obtener el interfaz home del BMP de p\u00e1gina de portal. Error: " + namEx.getMessage(), (Exception)namEx);
        }
        catch (EJBException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("PUBLISHERMANAGER (" + pagePortal.getOid() + ") > Error interno al actualizar la p\u00e1gina de portal.");
            throw new R01MPublisherException("Error interno al actualizar la p\u00e1gina de oid " + pagePortal.getOid() + ". Error: " + ex.getMessage(), (Exception)((Object)ex));
        }
        catch (R01MPortalModelException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("PUBLISHERMANAGER (" + pagePortal.getOid() + ") > Error al actualizar la p\u00e1gina de portal.");
            throw new R01MPublisherException("Error al actualizar la p\u00e1gina de oid " + pagePortal.getOid() + ". Error: " + ex.getMessage(), (Exception)((Object)ex));
        }
        boolean existsRepoPub = false;
        List repoPubInBDCMPList = null;
        R01GRepoPubPagePortalCMPLocal repoPubCMP2 = null;
        R01GRepoPubPagePortalCMPLocal pubCMPToUpdate = null;
        R01GRepoPubPagePortalCMPValue repoPubCMPValue = null;
        try {
            repoPubInBDCMPList = (List)R01GRepoPubPagePortalCMPUtil.getLocalHome().findByPagePortalOid(pagePortal.getOid());
        }
        catch (FinderException e) {
            R01FLog.to((String)LOG_TYPE_ID).severe("PUBLISHERMANAGER >>>> Error al buscar la lista de publicaciones para el portal: " + pagePortal.getOid());
            throw new R01MPublisherException("No se encuentra el JNDI del EJB de Publicaciones.", (Exception)((Object)e));
        }
        catch (NamingException namEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("PUBLISHERMANAGER >>>> No se encuentra el JNDI del EJB de Publicaciones");
            throw new R01MPublisherException("No se encuentra el JNDI del EJB de Publicaciones.", (Exception)namEx);
        }
        if (repoPubInBDCMPList != null && !repoPubInBDCMPList.isEmpty()) {
            for (R01GRepoPubPagePortalCMPLocal repoPubCMP2 : repoPubInBDCMPList) {
                repoPubCMPValue = repoPubCMP2.getR01GRepoPubPagePortalCMPValue();
                if (repoPubCMPValue.getRepositoryOid().equals(publiVO.getRepositoryOid()) && (repoPubCMPValue.getState() == 3 || repoPubCMPValue.getState() == 2 || publicationState == 1 && repoPubCMPValue.getState() == 4 || publicationState == 3 && repoPubCMPValue.getState() == 4 || publicationState == 0 && repoPubCMPValue.getState() == 5 || publicationState == 2 && repoPubCMPValue.getState() == 5)) {
                    try {
                        repoPubCMP2.remove();
                    }
                    catch (EJBException ejbEx) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("PUBLISHERMANAGER >>>> No se puede crear la Publicaci\u00f3n de la p\u00e1gina " + pagePortal.getOid() + " en el Repositorio: " + publiVO.getRepositoryOid());
                        throw new R01MPublisherException("No se puede crear la Publicaci\u00f3n de la p\u00e1gina " + pagePortal.getOid() + " en el Repositorio de publicaci\u00f3n: " + publiVO.getRepositoryOid() + ": " + ejbEx.getMessage(), (Exception)((Object)ejbEx));
                    }
                    catch (RemoveException remEx) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("PUBLISHERMANAGER >>>> No se puede crear la Publicaci\u00f3n de la p\u00e1gina " + pagePortal.getOid() + " en el Repositorio: " + publiVO.getRepositoryOid());
                        throw new R01MPublisherException("No se puede crear la Publicaci\u00f3n de la p\u00e1gina " + pagePortal.getOid() + " en el Repositorio de publicaci\u00f3n: " + publiVO.getRepositoryOid() + ": " + remEx.getMessage(), (Exception)((Object)remEx));
                    }
                }
                if (!repoPubCMPValue.getPrimaryKey().equals((Object)publiVO.getPrimaryKey())) continue;
                existsRepoPub = true;
                pubCMPToUpdate = repoPubCMP2;
            }
        } else {
            existsRepoPub = false;
        }
        if (existsRepoPub) {
            pubCMPToUpdate.setR01GRepoPubPagePortalCMPValue(publiVO);
        } else {
            try {
                R01GRepoPubPagePortalCMPUtil.getLocalHome().create(publiVO);
            }
            catch (CreateException crtEx) {
                R01FLog.to((String)LOG_TYPE_ID).severe("PUBLISHERMANAGER >>>> No se puede crear la Publicaci\u00f3n de la p\u00e1gina " + pagePortal.getOid() + " en el Repositorio: " + publiVO.getRepositoryOid());
                throw new R01MPublisherException("No se puede crear la Publicaci\u00f3n de la p\u00e1gina " + pagePortal.getOid() + " en el Repositorio de publicaci\u00f3n: " + publiVO.getRepositoryOid() + ": " + crtEx.getMessage(), (Exception)((Object)crtEx));
            }
            catch (NamingException namEx) {
                R01FLog.to((String)LOG_TYPE_ID).severe("PUBLISHERMANAGER >>>> No se encuentra el JNDI del EJB de Publicaciones");
                throw new R01MPublisherException("No se encuentra el JNDI del EJB de Publicaciones.", (Exception)namEx);
            }
        }
    }

    private List _obtainFileListToPublish(R01MPage page, int publicationType) throws R01MPublisherException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("PUBLISHERMANAGER >>>> Componer los recursos a publicar: carpetas y ficheros...");
        }
        ArrayList<R01MPublicationResourceItem> resourcesToPublishList = new ArrayList<R01MPublicationResourceItem>();
        String portalOid = page != null && !StringUtils.isEmptyString((String)page.getPortalOid()) ? page.getPortalOid() : "[portal o page null]";
        String pageInternalName = page != null && !StringUtils.isEmptyString((String)page.getInternalName()) ? page.getInternalName() : "[internal name null]";
        R01MPublicationResourceItem pageToPublish = new R01MPublicationResourceItem();
        pageToPublish.type = "filedir";
        pageToPublish.description = R01MPathHelpper.getPortalPagePublicationPath((String)portalOid, (String)pageInternalName);
        resourcesToPublishList.add(pageToPublish);
        R01MPublicationResourceItem pageStylesToPublish = new R01MPublicationResourceItem();
        pageStylesToPublish.type = "filedir";
        pageStylesToPublish.description = R01MPathHelpper.getPortalResourcePublicationPath((String)portalOid, (String)pageInternalName, (int)4, (String)R01MPortalPathHelpper.getPageStylesFilename((String)portalOid, (String)pageInternalName, (boolean)true, (boolean)false));
        resourcesToPublishList.add(pageStylesToPublish);
        R01MPublicationResourceItem pageStylesToPublishSASS = new R01MPublicationResourceItem();
        pageStylesToPublishSASS.type = "filedir";
        pageStylesToPublishSASS.description = R01MPathHelpper.getPortalResourcePublicationPath((String)portalOid, (String)pageInternalName, (int)4, (String)R01MPortalPathHelpper.getPageStylesFilename((String)portalOid, (String)pageInternalName, (boolean)false, (boolean)true));
        resourcesToPublishList.add(pageStylesToPublishSASS);
        R01MPublicationResourceItem pageScriptsToPublish = new R01MPublicationResourceItem();
        pageScriptsToPublish.type = "filedir";
        pageScriptsToPublish.description = R01MPathHelpper.getPortalResourcePublicationPath((String)portalOid, (String)pageInternalName, (int)3, (String)R01MPortalPathHelpper.getPageScriptsFilename((String)portalOid, (String)pageInternalName, (boolean)true));
        resourcesToPublishList.add(pageScriptsToPublish);
        R01MPublicationResourceItem indexAndHTMLdata = new R01MPublicationResourceItem();
        indexAndHTMLdata.type = "filedir";
        String dirToDelete = R01MPortalPathHelpper.replacePortalPageCodeInPath((String)R01MPortalPathHelpper.INDEXES_DIR, (String)portalOid, (String)(portalOid + "-" + pageInternalName));
        indexAndHTMLdata.description = dirToDelete.substring(dirToDelete.indexOf("/pages"));
        resourcesToPublishList.add(indexAndHTMLdata);
        if (publicationType == 0 || publicationType == 1) {
            if (page.isIndexPage()) {
                R01MPublicationResourceItem indexPageToPublish = new R01MPublicationResourceItem();
                indexPageToPublish.type = "filedir";
                indexPageToPublish.description = R01MPathHelpper.getPortalInitialPublicationPath((String)portalOid, (String)XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/indexPageName"));
                resourcesToPublishList.add(indexPageToPublish);
            }
            try {
                R01MPortalTemplate portalTemplate = this._templateDataLoader.loadTemplate(portalOid, page.getTemplateOid());
                List templateResources = portalTemplate.getTemplateResources();
                if (templateResources != null && !templateResources.isEmpty()) {
                    Iterator templateResourcesIterator = templateResources.iterator();
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).info("PUBLISHERMANAGER >>>> Los recursos de la p\u00e1gina a publicar son: ");
                    }
                    while (templateResourcesIterator.hasNext()) {
                        R01MResource templateResource = (R01MResource)templateResourcesIterator.next();
                        R01MPublicationResourceItem itemToPublish = new R01MPublicationResourceItem();
                        itemToPublish.type = "filedir";
                        String fileName = templateResource.getFileName();
                        if (templateResource.isSass() && fileName.lastIndexOf(".") != -1) {
                            fileName = fileName.substring(0, fileName.lastIndexOf(".")).concat(".css");
                        }
                        itemToPublish.description = R01MPathHelpper.getPortalResourcePublicationPath((String)portalOid, (String)pageInternalName, (int)R01MPortalPathHelpper.obtainResourceTypeFromFile((String)fileName), (String)fileName);
                        resourcesToPublishList.add(itemToPublish);
                        if (!DEBUG) continue;
                        R01FLog.to((String)LOG_TYPE_ID).info("PUBLISHERMANAGER >>>> Recurso a publicar:" + templateResource.getFileName());
                    }
                }
            }
            catch (R01MConfigLoadException cfgEx) {
                R01FLog.to((String)LOG_TYPE_ID).severe("PUBLISHERMANAGER >>>> Error al cargar la plantilla de la p\u00e1gina " + page.getOid() + ". Error:" + cfgEx.getMessage());
                throw new R01MPublisherException("Error al cargar la plantilla de la p\u00e1gina " + page.getOid(), (Exception)((Object)cfgEx));
            }
            Map visualAreas = page.getVisualAreas();
            if (visualAreas != null && !visualAreas.isEmpty()) {
                for (Map.Entry meVA : visualAreas.entrySet()) {
                    R01MVisualAreaInstance currVaInstance;
                    R01MPageVAInclude vaInstanceInclude = (R01MPageVAInclude)meVA.getValue();
                    if (vaInstanceInclude.getInstanceOid() == null || vaInstanceInclude.getInstanceOid().trim().equals("")) continue;
                    try {
                        currVaInstance = R01MClientFactory.getPortalModelAPI((R01MUserContext)this._userCtx, (String)portalOid).loadVAInstance(vaInstanceInclude.getInstanceOid());
                    }
                    catch (R01MPortalModelException pmExc) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("PUBLISHERMANAGER >>>> Error al cargar la instancia de VA " + vaInstanceInclude.getInstanceOid() + ". Error:" + pmExc.getMessage());
                        throw new R01MPublisherException("Error al cargar la instancia de VA " + vaInstanceInclude.getInstanceOid(), (Exception)((Object)pmExc));
                    }
                    catch (R01MSecurityException secExc) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("PUBLISHERMANAGER >>>> Error de seguridad al cargar la instancia de VA " + vaInstanceInclude.getInstanceOid() + ". Error:" + secExc.getMessage());
                        throw new R01MPublisherException("Error de seguridad al cargar la instancia de VA " + vaInstanceInclude.getInstanceOid(), (Exception)((Object)secExc));
                    }
                    Map instanceResources = currVaInstance.getInstanceResources();
                    if (instanceResources == null || instanceResources.isEmpty()) continue;
                    for (Map.Entry meInstanceResource : instanceResources.entrySet()) {
                        R01MResource instanceResource = (R01MResource)meInstanceResource.getValue();
                        R01MPublicationResourceItem itemToPublish = new R01MPublicationResourceItem();
                        itemToPublish.type = "filedir";
                        if (instanceResource.getType() == 2) {
                            String pathFileResource = instanceResource.getFileName();
                            String resourceFileName = pathFileResource.substring(pathFileResource.lastIndexOf(47) + 1, pathFileResource.length());
                            itemToPublish.description = R01MPathHelpper.getPortalResourcePublicationPath((String)portalOid, (String)pageInternalName, (int)2, (String)resourceFileName);
                        } else if (instanceResource.getType() == 7) {
                            String[] paths = instanceResource.getFileName().split("/");
                            String fileName = paths[paths.length - 1];
                            if (fileName.indexOf(46) > 0) {
                                fileName = fileName.substring(0, fileName.indexOf(46));
                            } else if (DEBUG) {
                                R01FLog.to((String)LOG_TYPE_ID).warning("PUBLISHERMANAGER >>>> El recurso a publicar '" + fileName + "' no tiene el formato correcto.");
                            }
                            if (DEBUG) {
                                R01FLog.to((String)LOG_TYPE_ID).info("PUBLISHERMANAGER >>>> Recurso a publicar:" + fileName);
                            }
                            itemToPublish.description = R01MPathHelpper.getPortalAVPublicationPath((String)portalOid, (String)vaInstanceInclude.getVisualAreaOid(), (String)paths[2], (String)fileName, (String)R01MVisualAreasConfig.getGeneratedFileExtensionForVisualArea((String)vaInstanceInclude.getVisualAreaOid(), (String)"html"));
                        } else if (instanceResource.getType() == 11) {
                            if (DEBUG) {
                                R01FLog.to((String)LOG_TYPE_ID).info("PUBLISHERMANAGER >>>> Recurso a publicar:" + instanceResource.getFileName());
                            }
                            itemToPublish.description = instanceResource.getFileName();
                        } else {
                            itemToPublish.description = R01MPathHelpper.getPortalAVResourcePublicationPath((String)portalOid, (String)currVaInstance.getVisualAreaOid(), (String)R01MPortalPathHelpper.obtainResourceDirFromFile((String)instanceResource.getFileName()), (String)instanceResource.getFileName());
                        }
                        resourcesToPublishList.add(itemToPublish);
                    }
                }
            }
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\tlista de recursos (carpetas y ficheros) a publicar obtenida...");
            }
        }
        return resourcesToPublishList;
    }

    private List _obtainPageAliasFileListToPublish(R01MPage page) {
        ArrayList<R01MPublicationResourceItem> resourcesToPublishList = new ArrayList<R01MPublicationResourceItem>();
        R01MPublicationResourceItem itemToPublish = new R01MPublicationResourceItem();
        String apacheFileName = XMLProperties.getProperty((String)R01MConstants.API_APPCODE, (String)"aliasManagement/pageFriendlyUrl/apacheFileName", (String)".htaccess");
        Map pageAliasesByState = null;
        try {
            pageAliasesByState = new R01GPortalModelManager().doLoadPageAliasesByState(page.getOid());
        }
        catch (R01MPortalModelException pmEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.prepareToPublish._obtainAliasFileListToPublish >> Error al recoger los aliases a publicar de la p\u00e1gina " + page.getOid() + ": " + pmEx.getMessage());
        }
        catch (R01MSecurityException secEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.prepareToPublish._obtainAliasFileListToPublish >> Error al recoger los aliases a publicar de la p\u00e1gina " + page.getOid() + ": " + secEx.getMessage());
        }
        if (pageAliasesByState != null && pageAliasesByState.values() != null) {
            for (List aliasesInState : pageAliasesByState.values()) {
                Iterator itAliases = aliasesInState.iterator();
                while (itAliases.hasNext()) {
                    itemToPublish = new R01MPublicationResourceItem();
                    itemToPublish.type = "filedir";
                    itemToPublish.description = R01MPathHelpper.getPortalResourcePublicationPath((String)page.getPortalOid(), (int)12, (String)StringUtils.replaceString((String)(((R01MURLAlias)itAliases.next()).getAlias() + "/" + apacheFileName), (String)"//", (String)"/"));
                    resourcesToPublishList.add(itemToPublish);
                }
            }
        }
        return resourcesToPublishList;
    }

    private List _obtainPortalAliasFileListToPublish(String portalOid) {
        ArrayList<R01MPublicationResourceItem> resourcesToPublishList = new ArrayList<R01MPublicationResourceItem>();
        R01MPublicationResourceItem itemToPublish = new R01MPublicationResourceItem();
        String apacheFileName = XMLProperties.getProperty((String)R01MConstants.API_APPCODE, (String)"aliasManagement/portalFriendlyUrl/apacheFileName", (String)".htaccess");
        Map<String, List<R01MURLAlias>> portalAliasesByState = null;
        try {
            portalAliasesByState = new R01GPortalModelManager().doLoadPortalAliasesByState(portalOid);
        }
        catch (R01MPortalModelException pmEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.prepareToPublish._obtainAliasFileListToPublish >> Error al recoger los aliases a publicar del portal " + portalOid + ": " + pmEx.getMessage());
        }
        catch (R01MSecurityException secEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.prepareToPublish._obtainAliasFileListToPublish >> Error al recoger los aliases a publicar del portal " + portalOid + ": " + secEx.getMessage());
        }
        if (portalAliasesByState != null && portalAliasesByState.values() != null) {
            for (List<R01MURLAlias> aliasesInState : portalAliasesByState.values()) {
                Iterator<R01MURLAlias> itAliases = aliasesInState.iterator();
                while (itAliases.hasNext()) {
                    itemToPublish = new R01MPublicationResourceItem();
                    itemToPublish.type = "filedir";
                    R01MURLAlias currentAlias = itAliases.next();
                    itemToPublish.description = R01MPathHelpper.getPortalResourcePublicationPath((String)portalOid, (int)12, (String)StringUtils.replaceString((String)(currentAlias.getAlias() + "/" + apacheFileName), (String)"//", (String)"/"));
                    resourcesToPublishList.add(itemToPublish);
                }
            }
        }
        return resourcesToPublishList;
    }

    private Object[] _prepareFilelistToPublish(String objectOid, int objectType, List resourcesRelativePaths, int publicationType) throws R01MPublisherException {
        List resourcesList = new ArrayList();
        R01GPortalModelManager portalManager = new R01GPortalModelManager();
        String portalOid = "";
        R01GPortalInDataStore dsMngr = null;
        if (objectType == 4 || objectType == 10 || objectType == 17) {
            R01MPage page;
            try {
                page = portalManager.doLoadPortalPage(this._userCtx, objectOid);
            }
            catch (R01MPortalModelException pmEx) {
                R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager.prepareToPublish._prepareFilelistToPublish >> Error al cargar la p\u00e1gina " + (objectOid == null ? "[null]" : objectOid) + ". Error: " + pmEx.getMessage());
                throw new R01MPublisherException("Error al cargar la p\u00e1gina " + (objectOid == null ? "[null]" : objectOid), (Exception)((Object)pmEx));
            }
            catch (R01MSecurityException secEx) {
                R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager.prepareToPublish._prepareFilelistToPublish >> Error al cargar la p\u00e1gina " + (objectOid == null ? "[null]" : objectOid) + ". Error: " + secEx.getMessage());
                throw new R01MPublisherException("Error al cargar la p\u00e1gina " + (objectOid == null ? "[null]" : objectOid), (Exception)((Object)secEx));
            }
            portalOid = page.getPortalOid();
            try {
                dsMngr = new R01GPortalInDataStore(this._userCtx, portalOid);
            }
            catch (R01MDataStoreException dsEx) {
                R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager.prepareToPublish._prepareFilelistToPublish >> Error en acceso al Storage de almacenamiento." + dsEx.getMessage());
                throw new R01MPublisherException("Error en acceso al storage de almacenamiento.", (Exception)((Object)dsEx));
            }
            if (objectType == 4) {
                resourcesList = this._preparePageFileListToPublish(page, publicationType, dsMngr);
            } else if (objectType == 10) {
                resourcesList = this._preparePageIndexFileListToPublish(page, portalOid);
            } else if (objectType == 17) {
                resourcesList = this._preparePageAliasFileListToPublish(page, dsMngr);
            }
        } else if (objectType == 12 || objectType == 14 || objectType == 18) {
            portalOid = objectOid;
            try {
                dsMngr = new R01GPortalInDataStore(this._userCtx, portalOid);
            }
            catch (R01MDataStoreException dsEx) {
                R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager.prepareToPublish._prepareFilelistToPublish >> Error en acceso al Storage de almacenamiento." + dsEx.getMessage());
                throw new R01MPublisherException("Error en acceso al storage de almacenamiento.", (Exception)((Object)dsEx));
            }
            if (objectType == 12) {
                resourcesList = this._preparePortalResourcesFileListToPublish(portalOid, publicationType, resourcesRelativePaths, dsMngr);
            } else if (objectType == 14) {
                resourcesList = this._preparePortalDynamicVAFileListToPublish(portalOid, portalManager, dsMngr);
            } else if (objectType == 18) {
                resourcesList = this._preparePortalAliasFileListToPublish(portalOid, publicationType, resourcesRelativePaths, dsMngr);
            }
        } else if (objectType == 7) {
            try {
                portalOid = portalManager.doGetVisualAreaParentPortalOid(objectOid);
            }
            catch (R01MPortalModelException ex) {
                R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager.prepareToPublish._prepareFilelistToPublish >> Error al publicar el \u00e1rea visual " + objectOid + "." + "Error al obtener el portal al que pertenece. Error: " + ex.getMessage());
                throw new R01MPublisherException("Error al publicar el \u00e1rea visual " + objectOid + "." + "Error al obtener el portal al que pertenece.", (Exception)((Object)ex));
            }
            try {
                dsMngr = new R01GPortalInDataStore(this._userCtx, portalOid);
            }
            catch (R01MDataStoreException dsEx) {
                R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager.prepareToPublish._prepareFilelistToPublish >> Error en acceso al Storage de almacenamiento." + dsEx.getMessage());
                throw new R01MPublisherException("Error en acceso al storage de almacenamiento.", (Exception)((Object)dsEx));
            }
            resourcesList = this._prepareVAFileListToPublish(objectOid, portalOid, portalManager, dsMngr);
        } else if (objectType == 13) {
            resourcesList = this._prepareSystemResourcesFileListToPublish(resourcesRelativePaths);
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("R01GPublisherManager.prepareToPublish._prepareFilelistToPublish >>  ... lista de recursos a publicar cargada: " + (resourcesList == null ? "[null]" : resourcesList.toString()));
        }
        return new Object[]{dsMngr, resourcesList};
    }

    private boolean _consolidateResources(String objectOid, int objectType, R01GPortalInDataStore dsMngr, List resourcesList) {
        boolean allCommitedCorrectly = true;
        if (objectType == 4) {
            StringBuffer errors = dsMngr.consolidatePage(resourcesList);
            if (DEBUG && errors == null) {
                R01FLog.to((String)LOG_TYPE_ID).info("R01GPublisherManager.prepareToPublish._consolidateResources >> \trecursos a publicar submitidos al STAGING");
            } else if (errors != null) {
                allCommitedCorrectly = false;
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("R01GPublisherManager.prepareToPublish._consolidateResources >> \terrores en la consolidaci\u00f3n: " + errors.toString());
                }
                try {
                    ByteArrayInputStream byteArrayInputStreamFileListErrors = new ByteArrayInputStream(errors.toString().getBytes("UTF-8"));
                    dsMngr.uploadPublishFile("error_" + R01MConstants.OBJECT_DESCS[objectType] + "-" + objectOid, (InputStream)byteArrayInputStreamFileListErrors);
                }
                catch (R01MDataStoreException dsEx) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager.prepareToPublish._consolidateResources >> Error al subir el fichero de errores de consolidaci\u00f3n al datastore: " + dsEx.getMessage());
                }
                catch (UnsupportedEncodingException ueEx) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager.prepareToPublish._consolidateResources >> Error al subir el fichero de errores de consolidaci\u00f3n al datastore: " + ueEx.getMessage());
                }
            }
        } else {
            StringBuffer errors = dsMngr.consolidatePortalResources(resourcesList);
            if (DEBUG && errors == null) {
                R01FLog.to((String)LOG_TYPE_ID).info("R01GPublisherManager.prepareToPublish._consolidateResources >> \trecursos a publicar submitidos al STAGING");
            } else if (errors != null) {
                allCommitedCorrectly = false;
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("R01GPublisherManager.prepareToPublish._consolidateResources >> \terrores en la consolidaci\u00f3n:: " + errors.toString());
                }
                try {
                    ByteArrayInputStream byteArrayInputStreamFileListErrors = new ByteArrayInputStream(errors.toString().getBytes("UTF-8"));
                    dsMngr.uploadPublishFile("error_" + R01MConstants.OBJECT_DESCS[objectType] + "-" + objectOid, (InputStream)byteArrayInputStreamFileListErrors);
                }
                catch (R01MDataStoreException dsEx) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager.prepareToPublish._consolidateResources >> Error al subir el fichero de errores de consolidaci\u00f3n al datastore :" + dsEx.getMessage());
                }
                catch (UnsupportedEncodingException ueEx) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager.prepareToPublish._consolidateResources >> Error al subir el fichero de errores de consolidaci\u00f3n al datastore: " + ueEx.getMessage());
                }
            }
        }
        return allCommitedCorrectly;
    }

    private R01MPage _updatePublishInfo(String objectOid, String repositoryOid, int publicationType, Date publicationDate, int publicationState) throws R01MPublisherException {
        String publicationOid;
        R01MPortal portal;
        R01MPage page;
        String pageOid = objectOid;
        R01GPortalModelManager portalManager = new R01GPortalModelManager();
        try {
            page = portalManager.doLoadPortalPage(this._userCtx, pageOid);
        }
        catch (R01MPortalModelException pmEx) {
            throw new R01MPublisherException("Error al cargar la p\u00e1gina " + (objectOid == null ? "[null]" : pageOid), (Exception)((Object)pmEx));
        }
        catch (R01MSecurityException secEx) {
            throw new R01MPublisherException("Error al cargar la p\u00e1gina " + (objectOid == null ? "[null]" : pageOid), (Exception)((Object)secEx));
        }
        String portalOid = page.getPortalOid();
        try {
            portal = R01GPortalLoaderFactory.getPortalDataLoader().loadPortal(portalOid);
        }
        catch (R01MConfigLoadException clEx) {
            throw new R01MPublisherException((Exception)((Object)clEx));
        }
        try {
            publicationOid = R01MUtils.generateNewOid((String)R01MConstants.PUBLISHER_APPCODE);
        }
        catch (GUIDDispenserException gdEx) {
            throw new R01MPublisherException((Exception)((Object)gdEx));
        }
        R01GPubliPdtesCMPValue publiPdteVO = new R01GPubliPdtesCMPValue();
        publiPdteVO.setPageOid(pageOid);
        publiPdteVO.setPublicationType(Integer.valueOf(Integer.toString(publicationType)));
        publiPdteVO.setOperationDate(publicationDate);
        publiPdteVO.setRepositoryOid(repositoryOid);
        this._updatePublications(portal, page, publiPdteVO, publicationOid, publicationState);
        return page;
    }

    private void _sendIndexMessage(String objectOid, int objectType, List resourcesRelativePaths, String repositoryOid, List indexers, int publicationType, Date publicationDate) throws R01MPublisherException {
        ArrayList<R01MJmsQueueParam> paramList = new ArrayList<R01MJmsQueueParam>();
        paramList.add(new R01MJmsQueueParam(1, "objectOid", (Object)objectOid));
        paramList.add(new R01MJmsQueueParam(3, "objectType", (Object)Integer.toString(objectType)));
        paramList.add(new R01MJmsQueueParam(1, "metadataFileNames", null));
        paramList.add(new R01MJmsQueueParam(2, "doLoadLazy", (Object)"false"));
        if (publicationType == 0 || publicationType == 1) {
            paramList.add(new R01MJmsQueueParam(2, "publishIndexData", (Object)"true"));
            paramList.add(new R01MJmsQueueParam(1, "repositoryOid", (Object)repositoryOid));
            paramList.add(new R01MJmsQueueParam(3, "publicationType", (Object)Integer.toString(0)));
            paramList.add(new R01MJmsQueueParam(1, "pubDateInMillis", (Object)Long.toString(publicationDate.getTime())));
        } else {
            paramList.add(new R01MJmsQueueParam(2, "publishIndexData", (Object)"false"));
        }
        paramList.add(new R01MJmsQueueParam(1, "indexers", (Object)(indexers == null ? "" : indexers.toString().replaceFirst("\\[", "").replaceFirst("\\]", ""))));
        paramList.add(new R01MJmsQueueParam(1, "indexFilesToPublish", (Object)""));
        paramList.add(new R01MJmsQueueParam(1, "managerClass", (Object)R01MConstants.PORTAL_INDEXER_MANAGER));
        paramList.add(new R01MJmsQueueParam(3, "indexType", (Object)Integer.toString(0)));
        try {
            R01MJMSUtils.sendJMSMessage((String)"r01IndexObject", paramList);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("Mensaje enviado a r01IndexObject");
            }
        }
        catch (R01MJMSException jmsExc) {
            HashMap<String, String> publicationsMap = new HashMap<String, String>();
            publicationsMap.put("default", "PostPublish finished with errors.\nuserName: " + (this._userCtx.getUserName() == null ? "[null]" : this._userCtx.getUserName()) + "\nobjectOid: " + (objectOid == null ? "[null]" : objectOid) + "\nobjectType: " + (objectType >= R01MConstants.OBJECT_DESCS.length || objectType < 0 ? "desconocido (" + objectType + ")" : R01MConstants.OBJECT_DESCS[objectType]) + "\n" + (objectType == 11 ? " resourcesRelativePaths: " + resourcesRelativePaths.toString() + "\n" : "") + "repositoryOid: " + (repositoryOid == null ? "[null]" : repositoryOid) + "\npublicationType: " + Integer.toString(publicationType) + "\npublicationDate: " + (publicationDate == null ? "[null]" : DateUtils.getDateFormated((Date)publicationDate, (String)"dd/mm/yyyy")));
            R01PClientFactory.getPublisherAPI().postPublishFinished(objectOid, objectType, "ERROR al enviar el mensaje de indexaci\u00f3n.", publicationsMap);
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al enviar el mensaje r01IndexObject. Error:" + jmsExc.getMessage());
            throw new R01MPublisherException("Error al enviar el mensaje r01IndexObject", (Exception)((Object)jmsExc));
        }
    }

    private void _sendAliasMessage(R01PPublishDefinition pubDef) throws R01MPublisherException {
        R01PPublishDefinition pubDefinition = new R01PPublishDefinition(pubDef.getUserName(), pubDef.getObjectOid(), 17, pubDef.getPublicationOid(), null, null, pubDef.getRepositoryOid(), pubDef.getPublicationType() == 0 || pubDef.getPublicationType() == 1 ? 0 : 2, null, null, true, null, null);
        R01PClientFactory.getPublisherAPI().publish(pubDefinition);
    }

    private void _checkPublishProcessInputParams(int step, R01PPublishDefinition pubDef) throws R01MPublisherException {
        String processStep = "undefined";
        if (step == 0) {
            processStep = "prepareToPublish";
        } else if (step == 1) {
            processStep = "prePublish";
        } else if (step == 2) {
            processStep = "publish";
        } else if (step == 3) {
            processStep = "postPublish";
        }
        try {
            pubDef.validateObject();
        }
        catch (R01MPublisherModelObjectsValidatorException pubExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager." + processStep + " >> La publicaci\u00f3n no es v\u00e1lida para ejecutar la operaci\u00f3n " + processStep);
            R01FLog.to((String)LOG_TYPE_ID).severe(pubDef.debugInfo("").toString());
            throw new R01MPublisherException("La publicaci\u00f3n no es v\u00e1lida para ejecutar la operaci\u00f3n " + processStep, (Exception)((Object)pubExc));
        }
        if (this._userCtx == null) {
            R01FLog.to((String)LOG_TYPE_ID).severe("R01GPublisherManager." + processStep + " >> El objeto no tiene inicializado un contexto de usuario y es necesario para ejecutar la operaci\u00f3n " + processStep);
            throw new R01MPublisherException("El objeto no tiene inicializado un contexto de usuario y es necesario para ejecutar la operaci\u00f3n " + processStep);
        }
    }

    private void _sendStepFinishedMessage(String messageType, String MessageDescription, int step, R01PPublishDefinition pubDef) throws R01MPublisherException {
        HashMap<String, String> publicationsMap = new HashMap<String, String>();
        StringBuffer msg = new StringBuffer();
        msg.append(MessageDescription);
        msg.append('\n');
        msg.append(pubDef.debugInfo(""));
        if (step == 3) {
            msg.append("\npublicationState:");
            msg.append(pubDef.getPublicationState());
        }
        publicationsMap.put("default", msg.toString());
        if (step == 0) {
            R01PClientFactory.getPublisherAPI().prepareToPublishFinished(pubDef.getObjectOid(), pubDef.getObjectType(), messageType, publicationsMap);
        } else if (step == 1) {
            R01PClientFactory.getPublisherAPI().prePublishFinished(pubDef.getObjectOid(), pubDef.getObjectType(), messageType, publicationsMap);
        } else if (step == 2) {
            R01PClientFactory.getPublisherAPI().publishFinished(pubDef.getObjectOid(), pubDef.getObjectType(), messageType, publicationsMap);
        } else if (step == 3) {
            R01PClientFactory.getPublisherAPI().postPublishFinished(pubDef.getObjectOid(), pubDef.getObjectType(), messageType, publicationsMap);
        }
    }

    private void _updateErrorPublicationState(R01PPublishDefinition pubDef) throws R01MPublisherException {
        if (StringUtils.isEmptyString((String)pubDef.getPublicationOid()) && pubDef.getObjectType() == 4) {
            R01MPage page;
            R01GPortalModelManager portalManager = new R01GPortalModelManager();
            try {
                page = portalManager.doLoadPortalPage(this._userCtx, pubDef.getObjectOid());
            }
            catch (R01MPortalModelException pmEx) {
                R01FLog.to((String)LOG_TYPE_ID).severe("PostPublish >> Error al cargar la p\u00e1gina " + (pubDef.getObjectOid() == null ? "[null]" : pubDef.getObjectOid()) + ". Error: " + pmEx.getMessage());
                throw new R01MPublisherException("Error al cargar la p\u00e1gina " + (pubDef.getObjectOid() == null ? "[null]" : pubDef.getObjectOid()), (Exception)((Object)pmEx));
            }
            catch (R01MSecurityException secEx) {
                R01FLog.to((String)LOG_TYPE_ID).severe("PostPublish >> Error al cargar la p\u00e1gina " + (pubDef.getObjectOid() == null ? "[null]" : pubDef.getObjectOid()) + ". Error: " + secEx.getMessage());
                throw new R01MPublisherException("Error al cargar la p\u00e1gina " + (pubDef.getObjectOid() == null ? "[null]" : pubDef.getObjectOid()), (Exception)((Object)secEx));
            }
            List publishInfoInDB = page.getPublicationInfo();
            if (publishInfoInDB != null) {
                R01MPortalPublicationTarget pubTargetInDB = null;
                for (int i = 0; i < publishInfoInDB.size(); ++i) {
                    pubTargetInDB = (R01MPortalPublicationTarget)publishInfoInDB.get(i);
                    if (!pubTargetInDB.getOid().equals(pubDef.getRepositoryOid()) || (pubDef.getPublicationState() != 1 && pubDef.getPublicationState() != 3 && pubDef.getPublicationState() != 4 || pubTargetInDB.getState() != 1 && pubTargetInDB.getState() != 3 && pubTargetInDB.getState() != 4) && (pubDef.getPublicationState() != 0 && pubDef.getPublicationState() != 2 && pubDef.getPublicationState() != 5 || pubTargetInDB.getState() != 0 && pubTargetInDB.getState() != 2 && pubTargetInDB.getState() != 5)) continue;
                    pubDef.setPublicationOid(pubTargetInDB.getPublicationOid());
                    break;
                }
            }
        }
        this.updateStatePublishInfo(pubDef.getObjectOid(), pubDef.getObjectType(), pubDef.getPublicationOid(), pubDef.getPublicationState() == 1 || pubDef.getPublicationState() == 3 ? 3 : 2);
    }
}

