/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01g.services;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.NumberUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01g.config.loaders.R01GPortalLoaderFactory;
import com.ejie.r01g.datastore.R01GPortalInDataStore;
import com.ejie.r01g.ejb.services.labelslistener.R01GLabelsListenerSLUtil;
import com.ejie.r01g.exceptions.R01GPortalModelPersistenceException;
import com.ejie.r01g.gestorportal.dbhelppers.dao.R01GDAOPortalModelLoader;
import com.ejie.r01g.gestorportal.dbhelppers.ejb.R01GEjbPortalModelLoader;
import com.ejie.r01g.services.R01GAliasAdminManager;
import com.ejie.r01g.services.R01GBasePortalManager;
import com.ejie.r01g.services.R01GCategoryAdminManager;
import com.ejie.r01g.services.R01GHistoryHelper;
import com.ejie.r01g.services.R01GPageAdminManager;
import com.ejie.r01g.services.R01GTemplateAdminManager;
import com.ejie.r01g.services.R01GVisualAreaAdminManager;
import com.ejie.r01g.services.helpers.R01GIndexerHelper;
import com.ejie.r01g.templates.processors.R01GPageTemplateChangeAnalyzer;
import com.ejie.r01g.util.R01GUtils;
import com.ejie.r01g.visualareas.helpper.R01GVAHelpper;
import com.ejie.r01m.config.objects.cataloguing.R01MChangesLabelsPacket;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MContentModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MDataStoreException;
import com.ejie.r01m.exceptions.R01MDeletePageException;
import com.ejie.r01m.exceptions.R01MDuplicatePageException;
import com.ejie.r01m.exceptions.R01MDuplicateVisualAreaException;
import com.ejie.r01m.exceptions.R01MJMSException;
import com.ejie.r01m.exceptions.R01MModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MPortalModelException;
import com.ejie.r01m.exceptions.R01MPortalModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MPublisherException;
import com.ejie.r01m.exceptions.R01MSearchIndexerException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.R01MBasePublicationTarget;
import com.ejie.r01m.objects.R01MURLAlias;
import com.ejie.r01m.objects.cataloguing.R01MStructureCatalog;
import com.ejie.r01m.objects.cataloguing.picks.R01MGeoPicks;
import com.ejie.r01m.objects.portalmodel.R01MPage;
import com.ejie.r01m.objects.portalmodel.R01MPageVAInclude;
import com.ejie.r01m.objects.portalmodel.R01MParamInstance;
import com.ejie.r01m.objects.portalmodel.R01MPortalCategory;
import com.ejie.r01m.objects.portalmodel.R01MPortalHistoryFilter;
import com.ejie.r01m.objects.portalmodel.R01MPortalLocation;
import com.ejie.r01m.objects.portalmodel.R01MPortalPublicationRequested;
import com.ejie.r01m.objects.portalmodel.R01MPortalTemplate;
import com.ejie.r01m.objects.portalmodel.R01MSearchedPortalPage;
import com.ejie.r01m.objects.portalmodel.R01MVisualAreaInstance;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexDefinition;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexablePortalPage;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.bzd.R01MPortalModelManagerBzd;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.jms.R01MJMSUtils;
import com.ejie.r01m.utils.jms.R01MJmsQueueParam;
import com.ejie.r01p.objects.publisher.R01PPublishDefinition;
import com.ejie.r01p.objects.searchengine.indexer.R01PPortalPageToIndexableConverter;
import com.ejie.r01p.services.R01PClientFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class R01GPortalModelManager
extends R01GBasePortalManager
implements R01MPortalModelManagerBzd {
    private static String LOG_TYPE_ID = "r01g.portalManager";
    private static final boolean DEBUG = R01FLog.getLogLevel((String)LOG_TYPE_ID).intValue() != Level.OFF.intValue();

    public boolean doCheckAliasExistence(R01MURLAlias alias) throws R01MPortalModelException {
        R01GAliasAdminManager manager = new R01GAliasAdminManager();
        return manager.doCheckAliasExistence(alias);
    }

    public boolean doCheckAliasExistence(String portalOid, R01MURLAlias alias) throws R01MPortalModelException {
        R01GAliasAdminManager manager = new R01GAliasAdminManager();
        return manager.doCheckAliasExistence(portalOid, alias);
    }

    public Map doSavePortalPage(R01MUserContext userCtx, R01MPage page, boolean sassCompile) throws R01MPortalModelException, R01MSecurityException, R01MPortalModelObjectsValidatorException, R01MDuplicatePageException {
        Map<String, R01MPageVAInclude> vaInclude;
        String opDesc = "Salvando la p\u00e1gina " + page.getOid();
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        R01GPageAdminManager manager = new R01GPageAdminManager(userCtx);
        try {
            R01MIndexDefinition indexDefinition;
            List<String> indexers;
            page.validateObject();
            if (this._doCheckPageExistence(page.getOid())) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\t... la p\u00e1gina ya existe es una actualizacion");
                }
                vaInclude = manager.doUpdatePage(page, sassCompile);
            } else {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\t... la p\u00e1gina es NUEVA");
                }
                vaInclude = manager.doCreatePage(page);
            }
            if (page.isIndexActive()) {
                indexers = new ArrayList<String>();
                indexers = XMLProperties.getPropertyList((String)R01MConstants.API_APPCODE, (String)"indexersConfigurations/default/indexer", Arrays.asList("com.ejie.r01k.searchorchestrator.indexer.indexers.R01KDataBaseIndexer"));
                indexDefinition = new R01MIndexDefinition(0, page.getOid(), 4, null, indexers, false, -1, null, null, null);
                R01GIndexerHelper.doIndexObject(indexDefinition);
            } else if (R01PClientFactory.getSearchEngineIndexerAPI().checkObjectExistence(page.getOid())) {
                R01MIndexDefinition indexDefinition2 = new R01MIndexDefinition(1, page.getOid(), 4, null, null, false, -1, null, null, null);
                R01GIndexerHelper.doUnIndexObject(indexDefinition2);
            }
            indexers = new ArrayList();
            indexers.add("com.ejie.r01k.searchorchestrator.indexer.indexers.R01KApacheMetaVarsIndexer");
            indexDefinition = new R01MIndexDefinition(0, page.getOid(), 4, null, indexers, false, -1, null, null, null);
            R01GIndexerHelper.doIndexObject(indexDefinition);
        }
        catch (R01MPortalModelException pmEx) {
            pmEx.printStackTrace(System.out);
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + pmEx.getMessage());
            throw new R01MPortalModelException(opDesc + " >> Error:" + pmEx.getMessage(), (Exception)((Object)pmEx));
        }
        catch (R01MSearchIndexerException siEx) {
            siEx.printStackTrace(System.out);
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + siEx.getMessage());
            throw new R01MPortalModelException(opDesc + " >> Error:" + siEx.getMessage(), (Exception)((Object)siEx));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
        return vaInclude;
    }

    public R01MPage doCopyPortalPage(R01MUserContext userCtx, String pageOidTo, String pageOidFrom) throws R01MPortalModelException, R01MSecurityException {
        String opDesc = "Copiando la p\u00e1gina " + pageOidFrom + " en la p\u00e1gina " + pageOidTo;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        R01GPageAdminManager manager = new R01GPageAdminManager(userCtx);
        try {
            if (this._doCheckPageExistence(pageOidFrom) && this._doCheckPageExistence(pageOidTo)) {
                R01MPage copiedPage;
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\t... las p\u00e1ginas son correctas");
                }
                if ((copiedPage = manager.doCopyPortalPage(pageOidTo, pageOidFrom)).isIndexActive()) {
                    List indexers = new ArrayList();
                    indexers = XMLProperties.getPropertyList((String)R01MConstants.API_APPCODE, (String)"indexersConfigurations/default/indexer", Arrays.asList("com.ejie.r01k.searchorchestrator.indexer.indexers.R01KDataBaseIndexer"));
                    R01MIndexDefinition indexDefinition = new R01MIndexDefinition(0, pageOidTo, 4, null, indexers, false, -1, null, null, null);
                    R01GIndexerHelper.doIndexObject(indexDefinition);
                }
                return copiedPage;
            }
            throw new R01MPortalModelException("No se encuentra el identificador de la p\u00e1gina Origen " + pageOidFrom + " , o el identificador de la p\u00e1gina Destino " + pageOidTo);
        }
        catch (R01MPortalModelException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException(opDesc + " >> Error:" + ex.getMessage(), (Exception)((Object)ex));
        }
    }

    public void doCopyVisualAreasFromPage(R01MUserContext userCtx, String pageOidTo, String pageOidFrom) throws R01MPortalModelException, R01MSecurityException {
        String opDesc = "Copiando las AVs de la p\u00e1gina " + pageOidFrom + " en la p\u00e1gina " + pageOidTo;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        R01GPageAdminManager manager = new R01GPageAdminManager(userCtx);
        try {
            if (this._doCheckPageExistence(pageOidFrom) && this._doCheckPageExistence(pageOidTo)) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\t... las p\u00e1ginas son correctas");
                }
                manager.doCopyVisualAreasFromPage(pageOidTo, pageOidFrom);
                return;
            }
            throw new R01MPortalModelException("No se encuentra el identificador de la p\u00e1gina Origen " + pageOidFrom + " , o el identificador de la p\u00e1gina Destino " + pageOidTo);
        }
        catch (R01MPortalModelException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException(opDesc + " >> Error:" + ex.getMessage(), (Exception)((Object)ex));
        }
    }

    public Map doAnalyzeTemplatePage(R01MUserContext userCtx, String pageOid, String templateOid) throws R01MPortalModelException, R01MSecurityException {
        super.validateSecurityContext(userCtx, pageOid, 1);
        String opDesc = "Analizando el cambio de plantilla de la p\u00e1gina " + pageOid + " a la plantilla " + templateOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        HashMap<String, Map> resultVA = new HashMap<String, Map>();
        try {
            R01MPortalTemplate templateDef;
            R01GPageAdminManager manager = new R01GPageAdminManager(userCtx);
            R01MPage page = manager.doLoadPage(pageOid);
            try {
                templateDef = R01GPortalLoaderFactory.getTemplateDataLoader().loadTemplate(page.getPortalOid(), templateOid);
            }
            catch (R01MConfigLoadException cfgEx) {
                R01FLog.to((String)LOG_TYPE_ID).severe("Error al cargar la plantilla: " + templateOid + ".Error:" + cfgEx.getMessage());
                throw new R01MPortalModelException("Error al cargar la plantilla: " + cfgEx.toString(), (Exception)((Object)cfgEx));
            }
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("Analizar el cambio de la plantilla de la pagina " + page.getOid() + " del portal " + page.getPortalOid() + ":\r\n\tPlantilla Actual: " + page.getTemplateOid() + "\r\n\tNueva Plantilla: " + templateDef.getOid());
            }
            R01GPageTemplateChangeAnalyzer templateAnalyzer = new R01GPageTemplateChangeAnalyzer(page, templateDef);
            resultVA.put("newVAs", templateAnalyzer.getNewAVs());
            resultVA.put("modifiedVAs", templateAnalyzer.getChangedAVs());
            resultVA.put("sameVAs", templateAnalyzer.getNotChangedAVs());
            resultVA.put("deletedVAs", templateAnalyzer.getDeletedAVs());
            R01FLog.to((String)LOG_TYPE_ID).info(templateAnalyzer.printDebugInfo());
        }
        catch (R01MPortalModelException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException(opDesc + ".Error:", (Exception)((Object)ex));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
        return resultVA;
    }

    public Map doChangePageTemplate(R01MUserContext userCtx, String pageOid, String templateOid) throws R01MPortalModelException, R01MSecurityException {
        Map<String, R01MPageVAInclude> newVAs;
        String opDesc = "Modificando la plantilla de la p\u00e1gina " + pageOid + " a la plantilla " + templateOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        try {
            R01GPageAdminManager manager = new R01GPageAdminManager(userCtx);
            newVAs = manager.doChangePageTemplate(pageOid, templateOid);
        }
        catch (R01MPortalModelException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException(opDesc + ".Error:", (Exception)((Object)ex));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
        return newVAs;
    }

    public void doChangePageCategory(R01MUserContext userCtx, String pageOid, String categoryOid) throws R01MPortalModelException, R01MSecurityException {
        String opDesc = "Modificando la categor\u00eda de la p\u00e1gina " + pageOid + " a la categor\u00eda " + categoryOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        try {
            R01GPageAdminManager manager = new R01GPageAdminManager(userCtx);
            manager.doChangePageCategory(pageOid, categoryOid);
        }
        catch (R01MPortalModelException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException(opDesc + ".Error:", (Exception)((Object)ex));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
    }

    public void doPublishPortalPage(R01MUserContext userCtx, R01MPage page) throws R01MPortalModelException, R01MPortalModelObjectsValidatorException {
        String opDesc = "Publicaci\u00f3n de la p\u00e1gina " + page.getOid();
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc + " en los repositorios siguientes:");
        }
        Map publicationsRequested = page.getRequestedPublications();
        try {
            if (publicationsRequested != null && !publicationsRequested.isEmpty()) {
                for (Map.Entry me : publicationsRequested.entrySet()) {
                    R01MPortalPublicationRequested petPub = (R01MPortalPublicationRequested)me.getValue();
                    petPub.validateObject();
                    if (!DEBUG) continue;
                    R01FLog.to((String)LOG_TYPE_ID).info(petPub.debugInfo("\t").toString());
                }
                R01GPageAdminManager manager = new R01GPageAdminManager(userCtx);
                manager.doPublishPage(page.getOid(), page.getRequestedPublications());
            }
        }
        catch (R01MPortalModelException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException(opDesc + ".Error:" + ex.getMessage(), (Exception)((Object)ex));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
    }

    public boolean isPagePublished(R01MUserContext userCtx, String pageOid, String repositoryOid) throws R01MSecurityException, R01MPortalModelException {
        super.validateSecurityContext(userCtx, pageOid, 1);
        String opDesc = "Validando si la p\u00e1gina " + pageOid + " est\u00e1 publicada en el repositorio " + repositoryOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        boolean isPagePublishedInRepo = false;
        R01GPageAdminManager manager = new R01GPageAdminManager(userCtx);
        isPagePublishedInRepo = manager.isPagePublished(pageOid, repositoryOid);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\u00bfLa p\u00e1gina de identificador '" + pageOid + "' est\u00e1 publicada en '" + repositoryOid + "?" + isPagePublishedInRepo);
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
        return isPagePublishedInRepo;
    }

    public void doPublishPortalResources(R01MUserContext userCtx, String portalOid, String repositoryOid, String[] resourcesRelativePath) throws R01MPortalModelException, R01MSecurityException {
        super.validateSecurityContext(userCtx, portalOid, 0);
        String opDesc = "Publicaci\u00f3n de recursos adicionales del portal " + portalOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        R01MPortalPublicationRequested petPub = new R01MPortalPublicationRequested();
        petPub.setRepositoryOid(repositoryOid);
        try {
            List<String> resouscesPath = Arrays.asList(resourcesRelativePath);
            R01PPublishDefinition pubDefinition = new R01PPublishDefinition(userCtx.getUserName(), portalOid, 12, null, null, resouscesPath, petPub.getRepositoryOid(), petPub.getOperationType(), petPub.getOperationDate(), null, true, null, null);
            R01PClientFactory.getPublisherAPI().publish(pubDefinition);
        }
        catch (R01MPublisherException pubExc) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).severe("/tError al publicar los recursos adicionales del portal " + portalOid + ".");
            }
            throw new R01MPortalModelException("Error al publicar los recursos adicionales del portal " + portalOid + ". Error: " + pubExc.getMessage(), (Exception)((Object)pubExc));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
    }

    public void doPublishPortalAliases(R01MUserContext userCtx, String portalOid, String repositoryOid) throws R01MPortalModelException, R01MSecurityException {
        String opDesc = "Publicaci\u00f3n de los alias de portal " + portalOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc + " en el repositorio " + repositoryOid);
        }
        try {
            R01GAliasAdminManager manager = new R01GAliasAdminManager(userCtx);
            manager.doPublishPortalAliases(portalOid, repositoryOid);
        }
        catch (R01MPublisherException pubEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + pubEx.getMessage());
            throw new R01MPortalModelException(opDesc + ".Error:" + pubEx.getMessage(), (Exception)((Object)pubEx));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
    }

    public void doPublishPortalAlias(R01MUserContext userCtx, String portalOid, String aliasOid, String repositoryOid) throws R01MPortalModelException, R01MSecurityException {
        String opDesc = "Publicaci\u00f3n de los alias de portal " + portalOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc + " en el repositorio " + repositoryOid);
        }
        try {
            R01GAliasAdminManager manager = new R01GAliasAdminManager(userCtx);
            manager.doPublishPortalAlias(portalOid, aliasOid, repositoryOid);
        }
        catch (R01MPublisherException pubEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + pubEx.getMessage());
            throw new R01MPortalModelException(opDesc + ".Error:" + pubEx.getMessage(), (Exception)((Object)pubEx));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
    }

    public void doChangePageCatalog(R01MUserContext userCtx, String pageOid, List structureCatalogation) throws R01MPortalModelException, R01MSecurityException, R01MPortalModelObjectsValidatorException {
        String opDesc = "Catalogaci\u00f3n en ejes de la p\u00e1gina " + pageOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc + " en los ejes siguientes:");
        }
        try {
            if (structureCatalogation != null && !structureCatalogation.isEmpty()) {
                for (R01MStructureCatalog catalog : structureCatalogation) {
                    try {
                        catalog.validateObject();
                    }
                    catch (R01MContentModelObjectsValidatorException ex) {
                        throw new R01MPortalModelObjectsValidatorException(ex.getMessage());
                    }
                    if (!DEBUG) continue;
                    R01FLog.to((String)LOG_TYPE_ID).info(catalog.debugInfo("\t").toString());
                }
            } else if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("La catalogaci\u00f3n en ejes de la p\u00e1gina " + pageOid + " ES NULA.");
            }
            R01GPageAdminManager manager = new R01GPageAdminManager(userCtx);
            manager.doChangePageCatalogation(pageOid, structureCatalogation);
        }
        catch (R01MPortalModelException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException(opDesc + ".Error:" + ex.getMessage(), (Exception)((Object)ex));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
    }

    public void doChangePageGeoCatalog(R01MUserContext userCtx, String pageOid, R01MGeoPicks geoCatalogation) throws R01MPortalModelException, R01MSecurityException, R01MPortalModelObjectsValidatorException {
        String opDesc = "Catalogaci\u00f3n geogr\u00e1fica de la p\u00e1gina " + pageOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc + " en:");
        }
        try {
            R01GPageAdminManager manager = new R01GPageAdminManager(userCtx);
            manager.doChangePageGeoCatalogation(pageOid, geoCatalogation);
        }
        catch (R01MPortalModelException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException(opDesc + ".Error:" + ex.getMessage(), (Exception)((Object)ex));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
    }

    public void doSaveVisualAreaInstance(R01MUserContext userCtx, String portalOid, String pageOid, String vaIncludeId, R01MVisualAreaInstance vaInstance) throws R01MPortalModelException, R01MSecurityException, R01MDuplicateVisualAreaException, R01MPortalModelObjectsValidatorException {
        String opDesc = "Guardando la instancia de Area Visual " + vaInstance.getOid() + " del tipo " + vaInstance.getVisualAreaOid();
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        boolean savePage = false;
        try {
            R01GVisualAreaAdminManager manager = new R01GVisualAreaAdminManager(userCtx);
            if (this._doCheckVisualAreaInstanceExistence(vaInstance.getOid())) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\t... la instancia de VA ya existe es una actualizacion");
                }
                manager.doUpdateVisualArea(portalOid, vaInstance);
                if (vaInstance.getVisualAreaOid().equals(R01MConstants.VA_CONTAINER_TYPE) || vaInstance.getVisualAreaOid().equals(R01MConstants.VA_RESULTS_TYPE)) {
                    savePage = true;
                }
            } else {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\t... la instancia de VA es NUEVA");
                }
                manager.doCreateVisualArea(portalOid, vaInstance);
                savePage = true;
            }
            if (savePage) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\t... creando la relaci\u00f3n instancia de VA " + vaInstance.getOid() + " con la p\u00e1gina de oid " + pageOid);
                }
                R01GPageAdminManager pageManager = new R01GPageAdminManager(userCtx);
                pageManager.doReferencedVAInstance(pageOid, vaIncludeId, vaInstance.getOid());
            }
        }
        catch (R01MPortalModelException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException(opDesc + ".Error:" + ex.getMessage(), (Exception)((Object)ex));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
    }

    public void doReferenceVisualAreaInstance(R01MUserContext userCtx, String pageOid, String vaIncludeId, String vaInstanceOid) throws R01MPortalModelException, R01MSecurityException {
        String opDesc = "Referenciando la instancia de VA de oid " + vaInstanceOid + " con la p\u00e1gina " + pageOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        R01GPageAdminManager pageManager = new R01GPageAdminManager(userCtx);
        pageManager.doReferencedVAInstance(pageOid, vaIncludeId, vaInstanceOid);
    }

    public String doCloneVisualAreaInstance(R01MUserContext userCtx, String portalOid, String pageOid, String vaIncludeId, String sourceVAInstanceOid, String newVAInstanceName) throws R01MPortalModelException, R01MSecurityException, R01MPortalModelObjectsValidatorException, R01MDuplicateVisualAreaException {
        R01MVisualAreaInstance sourceVAInstance;
        R01MParamInstance particularCSSInstance;
        String opDesc = "Referenciando la instancia de VA de oid " + sourceVAInstanceOid + " con la p\u00e1gina " + pageOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        if ((particularCSSInstance = R01GVAHelpper.getInstanceParam((R01MVisualAreaInstance)(sourceVAInstance = this.doLoadVisualAreaInstance(userCtx, sourceVAInstanceOid)), (String)"all", (String)"particularCSS")) != null) {
            particularCSSInstance.setCDATAValue(StringUtils.replaceString((String)particularCSSInstance.getValue(), (String)sourceVAInstance.getName(), (String)newVAInstanceName));
        }
        String newVAInstanceOid = R01GUtils.generateNewOid();
        sourceVAInstance.setOid(newVAInstanceOid);
        sourceVAInstance.setName(newVAInstanceName);
        try {
            this.doSaveVisualAreaInstance(userCtx, portalOid, pageOid, vaIncludeId, sourceVAInstance);
        }
        catch (R01MPortalModelObjectsValidatorException ex) {
            throw ex;
        }
        catch (R01MDuplicateVisualAreaException ex) {
            throw ex;
        }
        R01GPageAdminManager pageManager = new R01GPageAdminManager(userCtx);
        pageManager.doReferencedVAInstance(pageOid, vaIncludeId, newVAInstanceOid);
        return newVAInstanceOid;
    }

    public void doReferenceMigratedVisualAreaInstance(R01MUserContext userCtx, String portalOid, String pageOid, String vaIncludeId, String vaInstanceOid, String newVAInstanceName) throws R01MPortalModelException, R01MDuplicateVisualAreaException, R01MPortalModelObjectsValidatorException, R01MSecurityException {
        String opDesc = "Referenciando la instancia de VA 'MIGRADA' de oid " + vaInstanceOid + " con la p\u00e1gina " + pageOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        try {
            R01GVisualAreaAdminManager manager = new R01GVisualAreaAdminManager(userCtx);
            R01MVisualAreaInstance vaInstance = manager.doLoadVisualAreaInstance(vaInstanceOid);
            if (!vaInstance.getName().equals(newVAInstanceName)) {
                manager.doRegisterChangeName(vaInstanceOid, vaInstance.getName(), newVAInstanceName);
            }
            vaInstance.setName(newVAInstanceName);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\t... la instancia de VA es NUEVA");
            }
            manager.doUpdateVisualArea(portalOid, vaInstance);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\t... creando la relaci\u00f3n instancia de VA " + vaInstance.getOid() + " con la p\u00e1gina de oid " + pageOid);
            }
            R01GPageAdminManager pageManager = new R01GPageAdminManager(userCtx);
            pageManager.doReferencedVAInstance(pageOid, vaIncludeId, vaInstance.getOid());
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\t... creando la relaci\u00f3n instancia de VA " + vaInstance.getOid() + " con la p\u00e1gina de oid " + pageOid);
            }
        }
        catch (R01MPortalModelException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException(opDesc + ".Error:" + ex.getMessage(), (Exception)((Object)ex));
        }
    }

    public void doSaveAlias(R01MUserContext userCtx, String portalOid, R01MURLAlias alias) throws R01MPortalModelException, R01MSecurityException {
        super.validateSecurityContext(userCtx, portalOid, 0);
        String opDesc = "Guardando el alias  " + alias.getAlias() + " del portal " + portalOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        try {
            R01GAliasAdminManager manager = new R01GAliasAdminManager(userCtx);
            try {
                alias.validateObject();
            }
            catch (R01MModelObjectsValidatorException ex) {
                throw new R01MPortalModelException((Exception)((Object)ex));
            }
            if (manager.doCheckAliasExistence(portalOid, alias)) {
                throw new R01MPortalModelException((Exception)((Object)new R01MPortalModelObjectsValidatorException("El alias '" + alias.getAlias() + "' ya existe para el portal '" + portalOid + "' o bien como alias de alguna p\u00e1gina del portal.")));
            }
            if (this._doCheckPortalAliasExistence(alias.getOid())) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\t... el alias ya existe es una actualizacion");
                }
                manager.doUpdateAlias(portalOid, alias);
            } else {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\t... el alias es NUEVO, se va ha crear");
                }
                manager.doCreateAlias(portalOid, alias);
            }
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
        }
        catch (R01MPortalModelException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException(opDesc + ".Error:" + ex.getMessage(), (Exception)((Object)ex));
        }
        try {
            this._sendAliasStructureUpdateMessage(portalOid, true);
        }
        catch (R01MJMSException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException(opDesc + ".Error:" + ex.getMessage(), (Exception)((Object)ex));
        }
    }

    public void doRegeneratePortalAliases(R01MUserContext userCtx, String portalOid) throws R01MPortalModelException, R01MSecurityException {
        super.validateSecurityContext(userCtx, portalOid, 0);
        String opDesc = "Regenerando todos los alias del portal " + portalOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        try {
            this._sendAliasStructureUpdateMessage(portalOid, false);
        }
        catch (R01MJMSException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException(opDesc + ".Error:" + ex.getMessage(), (Exception)((Object)ex));
        }
    }

    public void doUpdatePageAliasesState(R01MUserContext userCtx, String pageOid, int initialState, int finalState) throws R01MPortalModelException, R01MSecurityException {
        String opDesc = "Actualizando el estado de los aliases de la p\u00e1gina " + pageOid + ". " + "Los aliases en estado " + initialState + " se quedar\u00e1n con estado " + finalState;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        try {
            R01GAliasAdminManager manager = new R01GAliasAdminManager(userCtx);
            manager.doUpdatePageAliasesState(pageOid, initialState, finalState);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
        }
        catch (R01MPortalModelException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException(opDesc + ".Error:" + ex.getMessage(), (Exception)((Object)ex));
        }
    }

    public void doUpdatePageAliasesState(R01MUserContext userCtx, String pageOid, List aliases, int finalState) throws R01MPortalModelException, R01MSecurityException {
        String opDesc = "Actualizando el estado de los aliases de la p\u00e1gina " + pageOid + ". " + "Los aliases se quedar\u00e1n con estado " + finalState;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        try {
            R01GAliasAdminManager manager = new R01GAliasAdminManager(userCtx);
            manager.doUpdatePageAliasesState(pageOid, aliases, finalState);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
        }
        catch (R01MPortalModelException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException(opDesc + ".Error:" + ex.getMessage(), (Exception)((Object)ex));
        }
    }

    public void doUpdatePortalAliasesState(R01MUserContext userCtx, String portalOid, int initialState, int finalState) throws R01MPortalModelException, R01MSecurityException {
        super.validateSecurityContext(userCtx, portalOid, 0);
        String opDesc = "Actualizando el estado de los aliases del portal " + portalOid + ". " + "Los aliases en estado " + initialState + " se quedar\u00e1n con estado " + finalState;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        try {
            R01GAliasAdminManager manager = new R01GAliasAdminManager(userCtx);
            manager.doUpdatePortalAliasesState(portalOid, initialState, finalState);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
        }
        catch (R01MPortalModelException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException(opDesc + ".Error:" + ex.getMessage(), (Exception)((Object)ex));
        }
    }

    public void doSaveCategory(R01MUserContext userCtx, String portalOid, R01MPortalCategory category) throws R01MPortalModelException, R01MSecurityException {
        super.validateSecurityContext(userCtx, portalOid, 0);
        String opDesc = "Guardando la categor\u00eda  " + category.getOid() + " del portal " + portalOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        try {
            R01GCategoryAdminManager manager = new R01GCategoryAdminManager(userCtx);
            if (this._doCheckCategoryExistence(category.getOid())) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\t... la categor\u00eda ya existe es una actualizacion");
                }
                manager.doUpdateCategory(category);
            } else {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\t... la categor\u00eda es NUEVA, se va ha crear");
                }
                manager.doCreateCategory(portalOid, category);
            }
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
        }
        catch (R01MPortalModelException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException(opDesc + ".Error:" + ex.getMessage(), (Exception)((Object)ex));
        }
    }

    public void doSaveTemplate(R01MUserContext userCtx, String portalOid, String templateId) throws R01MPortalModelException, R01MSecurityException {
        super.validateSecurityContext(userCtx, portalOid, 0);
        String opDesc = "Guardando la plantilla  " + templateId + " del portal " + portalOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        try {
            R01GTemplateAdminManager manager = new R01GTemplateAdminManager(userCtx);
            if (!this._doCheckTemplateExistence(portalOid, templateId) && DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\t... la plantilla es NUEVA, se va ha crear");
            }
            manager.doCreateTemplate(portalOid, templateId);
        }
        catch (R01MPortalModelException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException(opDesc + ".Error:" + ex.getMessage(), (Exception)((Object)ex));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
    }

    public void doChangeInitialPage(R01MUserContext userCtx, String portalOid, String pageOid) throws R01MPortalModelException, R01MSecurityException {
        String opDesc = "Cambiando la p\u00e1gina de INICIO del portal " + portalOid + " a la p\u00e1gina " + pageOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        try {
            R01GPageAdminManager manager = new R01GPageAdminManager(userCtx);
            if (!this._doCheckPageExistence(pageOid)) {
                throw new R01MPortalModelException("La p\u00e1gina que se quiere establecer como p\u00e1gina de inicio NO EXISTE");
            }
            manager.doChangeInitialPage(portalOid, pageOid);
        }
        catch (R01MPortalModelException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException(opDesc + ".Error:" + ex.getMessage(), (Exception)((Object)ex));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
    }

    public void doRedirectUrlPage(R01MUserContext userCtx, String portalOid, String pageOid, String redirectUrl) throws R01MPortalModelException, R01MSecurityException {
        String opDesc = "Cambiando la p\u00e1gina de redirecci\u00f3n " + portalOid + " a la p\u00e1gina " + pageOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        try {
            R01GPageAdminManager manager = new R01GPageAdminManager(userCtx);
            if (!this._doCheckPageExistence(pageOid)) {
                throw new R01MPortalModelException("La p\u00e1gina que se quiere establecer como p\u00e1gina de inicio NO EXISTE");
            }
            manager.doRedirectUrlPage(portalOid, pageOid, redirectUrl);
        }
        catch (R01MPortalModelException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException(opDesc + ".Error:" + ex.getMessage(), (Exception)((Object)ex));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
    }

    public void doDeletePortalPage(R01MUserContext userCtx, String pageOid) throws R01MPortalModelException, R01MSecurityException, R01MDeletePageException {
        String opDesc = "Borrado de la p\u00e1gina " + pageOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        try {
            if (this._doCheckPageExistence(pageOid)) {
                R01GPageAdminManager manager = new R01GPageAdminManager(userCtx);
                manager.doDeletePage(pageOid);
                if (R01PClientFactory.getSearchEngineIndexerAPI().checkObjectExistence(pageOid)) {
                    R01MIndexDefinition indexDefinition = new R01MIndexDefinition(1, pageOid, 4, null, null, false, -1, null, null, null);
                    R01GIndexerHelper.doUnIndexObject(indexDefinition);
                }
            }
        }
        catch (R01MPortalModelException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException(opDesc + ".Error:" + ex.getMessage(), (Exception)((Object)ex));
        }
        catch (R01MSearchIndexerException siEx) {
            siEx.printStackTrace(System.out);
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + siEx.getMessage());
            throw new R01MPortalModelException(opDesc + " >> Error:" + siEx.getMessage(), (Exception)((Object)siEx));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
    }

    public boolean doDeleteCategory(R01MUserContext userCtx, String portalOid, String categoryOid) throws R01MPortalModelException, R01MSecurityException {
        super.validateSecurityContext(userCtx, portalOid, 0);
        String opDesc = "Borrado de la categor\u00eda " + categoryOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        try {
            if (!this._doCheckCategoryExistence(categoryOid) || this._doCheckPagesWithCategory(categoryOid)) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : La categor\u00eda de OID " + categoryOid + " no EXISTE, o no se puede borrar!!!.");
                }
                return false;
            }
            R01GCategoryAdminManager manager = new R01GCategoryAdminManager(userCtx);
            manager.doDeleteCategory(categoryOid);
        }
        catch (R01MPortalModelException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException(opDesc + ".Error:" + ex.getMessage(), (Exception)((Object)ex));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
        return true;
    }

    public boolean doDeleteAlias(R01MUserContext userCtx, String portalOid, R01MURLAlias alias) throws R01MPortalModelException, R01MSecurityException {
        super.validateSecurityContext(userCtx, portalOid, 0);
        String opDesc = "Borrado del alias " + alias.getAlias();
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        try {
            if (!this._doCheckPortalAliasExistence(alias.getOid())) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : El alias " + alias.getAlias() + " no EXISTE.");
                }
                return false;
            }
            R01GAliasAdminManager manager = new R01GAliasAdminManager(userCtx);
            manager.doDeleteAlias(portalOid, alias);
        }
        catch (R01MPortalModelException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException(opDesc + ".Error:" + ex.getMessage(), (Exception)((Object)ex));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
        try {
            this._sendAliasStructureUpdateMessage(portalOid, true);
        }
        catch (R01MJMSException jmsEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + jmsEx.getMessage());
            throw new R01MPortalModelException(opDesc + ".Error:" + jmsEx.getMessage(), (Exception)((Object)jmsEx));
        }
        return true;
    }

    public boolean doDeleteTemplate(R01MUserContext userCtx, String portalOid, String templateId) throws R01MPortalModelException, R01MSecurityException {
        super.validateSecurityContext(userCtx, portalOid, 0);
        String opDesc = "Borrado de la plantilla de OID " + templateId;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        try {
            if (!this._doCheckTemplateExistence(portalOid, templateId) || this._doCheckPagesWithTemplate(portalOid, templateId)) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : La plantilla de OID " + templateId + " no EXISTE o no se puede borrar!!!.");
                }
                return false;
            }
            R01GTemplateAdminManager manager = new R01GTemplateAdminManager(userCtx);
            manager.doDeleteTemplate(portalOid, templateId);
        }
        catch (R01MPortalModelException ex) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            }
            throw new R01MPortalModelException(opDesc + ".Error:" + ex.getMessage(), (Exception)((Object)ex));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
        return true;
    }

    public R01MPage doLoadPortalPage(R01MUserContext userCtx, String pageOid) throws R01MPortalModelException, R01MSecurityException {
        super.validateSecurityContext(userCtx, pageOid, 1);
        String opDesc = "Cargar la p\u00e1gina de OID " + pageOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        try {
            R01GPageAdminManager manager = new R01GPageAdminManager(userCtx);
            R01MPage currPage = manager.doLoadPage(pageOid);
            if (currPage != null && currPage.getVisualAreas() != null && !currPage.getVisualAreas().isEmpty()) {
                Map vaRefNumber;
                R01GDAOPortalModelLoader loader = new R01GDAOPortalModelLoader();
                try {
                    vaRefNumber = loader.executeNumberPagesWithVisualAreasInstances(pageOid);
                }
                catch (R01GPortalModelPersistenceException ex) {
                    throw new R01MPortalModelException("Error en la consulta del n\u00famero de refencias de instancias de la p\u00e1gina " + pageOid, (Exception)((Object)ex));
                }
                if (vaRefNumber != null && !vaRefNumber.isEmpty()) {
                    R01GDAOPortalModelLoader vaLoader = new R01GDAOPortalModelLoader();
                    for (Map.Entry meVAs : currPage.getVisualAreas().entrySet()) {
                        R01MPageVAInclude vaInclude = (R01MPageVAInclude)meVAs.getValue();
                        if (StringUtils.isEmptyString((String)vaInclude.getInstanceOid())) continue;
                        if (vaRefNumber.get(vaInclude.getInstanceOid()) != null && NumberUtils.isNumber((String)vaRefNumber.get(vaInclude.getInstanceOid()).toString()) && Integer.parseInt(vaRefNumber.get(vaInclude.getInstanceOid()).toString()) > 1) {
                            vaInclude.setInstanceReferenced(true);
                        }
                        try {
                            vaInclude.setLastDateRegeneration(vaLoader.executeLoadLastRegenerationVA(vaInclude.getInstanceOid()));
                        }
                        catch (R01GPortalModelPersistenceException pmExc) {
                            R01FLog.to((String)LOG_TYPE_ID).warning("Error al obtener la fecha de regeneraci\u00f3n de la instancia de VA de oid " + vaInclude.getInstanceOid() + ".Error:" + pmExc.getMessage());
                        }
                    }
                }
            }
            return currPage;
        }
        catch (R01MPortalModelException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException("Error >>" + opDesc, (Exception)((Object)ex));
        }
    }

    public String doGetPageParentPortalOid(String pageOid) throws R01MPortalModelException {
        String opDesc = "Obtener el portal al que pertenece la pagina " + pageOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        R01GDAOPortalModelLoader service = new R01GDAOPortalModelLoader();
        try {
            return service.executeLoadPagePortalOid(pageOid);
        }
        catch (R01GPortalModelPersistenceException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException("Error >>" + opDesc, (Exception)((Object)ex));
        }
    }

    public String doGetVisualAreaParentPortalOid(String vaOid) throws R01MPortalModelException {
        String opDesc = "Obtener el portal al que pertenece un area visual " + vaOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        R01GDAOPortalModelLoader service = new R01GDAOPortalModelLoader();
        try {
            return service.executeLoadVAPortalOid(vaOid);
        }
        catch (R01GPortalModelPersistenceException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException("Error >>" + opDesc, (Exception)((Object)ex));
        }
    }

    public List doLoadPortalPageHistory(R01MUserContext userCtx, String pageOid, R01MPortalHistoryFilter filter) throws R01MPortalModelException, R01MSecurityException {
        String opDesc = "Cargar hist\u00f3rico de la p\u00e1gina " + pageOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        R01GHistoryHelper helper = new R01GHistoryHelper();
        try {
            return helper.doLoadPortalPageHistory(userCtx, pageOid, filter);
        }
        catch (R01MPortalModelException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException("Error >>" + opDesc, (Exception)((Object)ex));
        }
    }

    public Map<String, R01MBasePublicationTarget> doLoadRunningPublications() throws R01MPortalModelException, R01MSecurityException {
        String opDesc = "Cargar publicaciones y despublicaciones en estado RUNNING";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        R01GDAOPortalModelLoader loader = new R01GDAOPortalModelLoader();
        try {
            return loader.executeLoadRunningPublications();
        }
        catch (R01GPortalModelPersistenceException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException("Error >>" + opDesc, (Exception)((Object)ex));
        }
    }

    public List doLoadPageAliasesInState(String pageOid, int state) throws R01MPortalModelException, R01MSecurityException {
        String opDesc = "Cargar alias de p\u00e1gina en el estado " + state;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        R01GDAOPortalModelLoader loader = new R01GDAOPortalModelLoader();
        try {
            return loader.executeLoadPageAliasesInState(pageOid, state);
        }
        catch (R01GPortalModelPersistenceException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException("Error >>" + opDesc, (Exception)((Object)ex));
        }
    }

    public List<R01MURLAlias> doLoadPageAliasesByAlias(String portalOid, String alias) throws R01MPortalModelException, R01MSecurityException {
        String opDesc = "Cargar alias de p\u00e1gina: " + alias;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        R01GDAOPortalModelLoader loader = new R01GDAOPortalModelLoader();
        try {
            return loader.executeLoadPageAliasesByAlias(portalOid, alias);
        }
        catch (R01GPortalModelPersistenceException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException("Error >>" + opDesc, (Exception)((Object)ex));
        }
    }

    public Map doLoadPageAliasesByState(String pageOid) throws R01MPortalModelException, R01MSecurityException {
        String opDesc = "Cargar alias de p\u00e1gina agrupados por estado.";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        R01GDAOPortalModelLoader loader = new R01GDAOPortalModelLoader();
        try {
            return loader.executeLoadPageAliasesByState(pageOid);
        }
        catch (R01GPortalModelPersistenceException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException("Error >>" + opDesc, (Exception)((Object)ex));
        }
    }

    public List<R01MURLAlias> doLoadPortalAliasesInState(String portalOid, int state) throws R01MPortalModelException, R01MSecurityException {
        String opDesc = "Cargar alias de portal en el estado " + state;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        R01GDAOPortalModelLoader loader = new R01GDAOPortalModelLoader();
        try {
            return loader.executeLoadPortalAliasesInState(portalOid, state);
        }
        catch (R01GPortalModelPersistenceException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException("Error >>" + opDesc, (Exception)((Object)ex));
        }
    }

    public List<R01MURLAlias> doLoadPortalAliasesInStateAndGeneratedWithSameName(String portalOid, int state) throws R01MPortalModelException, R01MSecurityException {
        String opDesc = "Cargar alias de portal en el estado " + state;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        R01GDAOPortalModelLoader loader = new R01GDAOPortalModelLoader();
        try {
            return loader.executeLoadPortalAliasesInStateAndGeneratedWithSameName(portalOid, state);
        }
        catch (R01GPortalModelPersistenceException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException("Error >>" + opDesc, (Exception)((Object)ex));
        }
    }

    public List<R01MURLAlias> doLoadPortalAliasesByAlias(String portalOid, String alias) throws R01MPortalModelException, R01MSecurityException {
        String opDesc = "Cargar alias de portal por texto de alias";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        R01GDAOPortalModelLoader loader = new R01GDAOPortalModelLoader();
        try {
            return loader.executeLoadPortalAliasesByAlias(portalOid, alias);
        }
        catch (R01GPortalModelPersistenceException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException("Error >>" + opDesc, (Exception)((Object)ex));
        }
    }

    public Map<String, List<R01MURLAlias>> doLoadPortalAliasesByState(String portalOid) throws R01MPortalModelException, R01MSecurityException {
        String opDesc = "Cargar alias de portal por estado de alias";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        R01GDAOPortalModelLoader loader = new R01GDAOPortalModelLoader();
        try {
            return loader.executeLoadPortalAliasesByState(portalOid);
        }
        catch (R01GPortalModelPersistenceException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException("Error >>" + opDesc, (Exception)((Object)ex));
        }
    }

    public List doLoadPageActiveAliases(String pageOid) throws R01MPortalModelException, R01MSecurityException {
        String opDesc = "Cargar alias activos de p\u00e1gina";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        R01GDAOPortalModelLoader loader = new R01GDAOPortalModelLoader();
        try {
            return loader.executeLoadPageActiveAliases(pageOid);
        }
        catch (R01GPortalModelPersistenceException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException("Error >>" + opDesc, (Exception)((Object)ex));
        }
    }

    public List doLoadPageActiveAliasesOfPortal(String portalOid) throws R01MPortalModelException, R01MSecurityException {
        String opDesc = "Cargar todos los alias de p\u00e1gina activos para un portal";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        R01GDAOPortalModelLoader loader = new R01GDAOPortalModelLoader();
        try {
            return loader.executeLoadPageActiveAliasesOfPortal(portalOid);
        }
        catch (R01GPortalModelPersistenceException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException("Error >>" + opDesc, (Exception)((Object)ex));
        }
    }

    public List doLoadPortalActiveAliases(String portalOid) throws R01MPortalModelException, R01MSecurityException {
        String opDesc = "Cargar alias activos de portal.";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        R01GDAOPortalModelLoader loader = new R01GDAOPortalModelLoader();
        try {
            return loader.executeLoadPortalActiveAliases(portalOid);
        }
        catch (R01GPortalModelPersistenceException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException("Error >>" + opDesc, (Exception)((Object)ex));
        }
    }

    public R01MPortalLocation doLoadPortalLocation(R01MUserContext userCtx, String portalOid) throws R01MPortalModelException, R01MSecurityException {
        super.validateSecurityContext(userCtx, portalOid, 0);
        String opDesc = "Cargar la informaci\u00f3n del storage del portal  " + portalOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        R01GDAOPortalModelLoader loader = new R01GDAOPortalModelLoader();
        try {
            return loader.executeLoadPortalLocation(portalOid);
        }
        catch (R01GPortalModelPersistenceException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException("Error >>" + opDesc, (Exception)((Object)ex));
        }
    }

    public R01MVisualAreaInstance doLoadVisualAreaInstance(R01MUserContext userCtx, String vaInstanceOid) throws R01MPortalModelException, R01MSecurityException {
        super.validateSecurityContext(userCtx, vaInstanceOid, 2);
        String opDesc = "Cargar la instancia de OID " + vaInstanceOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        try {
            R01GVisualAreaAdminManager manager = new R01GVisualAreaAdminManager(userCtx);
            return manager.doLoadVisualAreaInstance(vaInstanceOid);
        }
        catch (R01MPortalModelException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException("Error >>" + opDesc, (Exception)((Object)ex));
        }
    }

    public List doFindPortalPages(R01MUserContext userCtx, String portalOid, R01MSearchedPortalPage searchPagePortal) throws R01MPortalModelException, R01MSecurityException {
        super.validateSecurityContext(userCtx, portalOid, 0);
        String opDesc = "Buscar p\u00e1ginas en el portal  " + portalOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\n\tB\u00fasqueda de p\u00e1ginas de portal que cumplen los siguientes criterios:");
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\n\tPortal: " + portalOid);
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\n\tNombre interno de p\u00e1gina: " + searchPagePortal.getInternalName());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\n\tNombre de p\u00e1gina: " + searchPagePortal.getName());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\n\tDescripci\u00f3n de p\u00e1gina: " + searchPagePortal.getDescription());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\n\tPlantilla: " + searchPagePortal.getTemplateId());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\n\tCategor\u00eda: " + searchPagePortal.getCategoryOid());
        }
        R01GDAOPortalModelLoader loader = new R01GDAOPortalModelLoader();
        try {
            return loader.findPortalPages(portalOid, searchPagePortal);
        }
        catch (R01GPortalModelPersistenceException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException("Error >>" + opDesc, (Exception)((Object)ex));
        }
    }

    public List doFindPortalPagesWithVisualArea(R01MUserContext userCtx, String portalOid, String typeVAOid) throws R01MPortalModelException, R01MSecurityException {
        super.validateSecurityContext(userCtx, portalOid, 0);
        String opDesc = "Buscar p\u00e1ginas del tipo " + typeVAOid + " en el portal  " + portalOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01GDAOPortalModelLoader loader = new R01GDAOPortalModelLoader();
            return loader.findPortalPagesWithVisualAreaType(portalOid, typeVAOid);
        }
        catch (R01GPortalModelPersistenceException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException("Error >>" + opDesc, (Exception)((Object)ex));
        }
    }

    public List doFindPortalPagesWithVisualAreaInstance(R01MUserContext userCtx, String portalOid, String instanceOid) throws R01MPortalModelException, R01MSecurityException {
        super.validateSecurityContext(userCtx, portalOid, 0);
        String opDesc = "Buscar p\u00e1ginas de instancia " + instanceOid + " en el portal  " + portalOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        try {
            R01GDAOPortalModelLoader loader = new R01GDAOPortalModelLoader();
            return loader.findPortalPagesWithVisualAreaInstance(portalOid, instanceOid);
        }
        catch (R01GPortalModelPersistenceException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException("Error >>" + opDesc, (Exception)((Object)ex));
        }
    }

    public List doFindVisualAreaInstances(R01MUserContext userCtx, String portalOid, String typeVAOid, String internalName) throws R01MPortalModelException, R01MSecurityException {
        super.validateSecurityContext(userCtx, portalOid, 0);
        String opDesc = "Buscar instancias de VAs del tipo " + typeVAOid + " en el portal  " + portalOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        try {
            R01GDAOPortalModelLoader loader = new R01GDAOPortalModelLoader();
            List visualAreas = loader.findVisualAreaInstances(portalOid, typeVAOid, internalName);
            if (visualAreas != null && visualAreas.size() > 1) {
                Collections.sort(visualAreas);
            }
            return visualAreas;
        }
        catch (R01GPortalModelPersistenceException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException("Error >>" + opDesc, (Exception)((Object)ex));
        }
    }

    public boolean existsVisualAreaInstance(R01MUserContext userCtx, String visualAreaOid) throws R01MPortalModelException, R01MSecurityException {
        super.validateSecurityContext(userCtx, visualAreaOid, 2);
        return this._doCheckVisualAreaInstanceExistence(visualAreaOid);
    }

    public List doLoadPageVALinks(R01MUserContext userCtx, String pageOid) throws R01MPortalModelException, R01MSecurityException {
        super.validateSecurityContext(userCtx, pageOid, 1);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("PORTALMANAGER > Cargar los enlace de las areas visuales de la p\u00e1gina " + pageOid);
        }
        List vaPageLinks = null;
        R01GDAOPortalModelLoader service = new R01GDAOPortalModelLoader();
        try {
            vaPageLinks = service.executeLoadPageVALinks(pageOid);
        }
        catch (R01GPortalModelPersistenceException ex) {
            throw new R01MPortalModelException("Error en la carga de los enlaces de las VAs de la p\u00e1gina " + pageOid + ".Error:" + ex.getMessage(), (Exception)((Object)ex));
        }
        return vaPageLinks;
    }

    public Map doLoadPageVADescriptions(R01MUserContext userCtx, String pageOid) throws R01MPortalModelException, R01MSecurityException {
        super.validateSecurityContext(userCtx, pageOid, 1);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("PORTALMANAGER > Cargar las descripciones de las areas visuales de la p\u00e1gina " + pageOid);
        }
        R01GPageAdminManager manager = new R01GPageAdminManager(userCtx);
        return manager.doLoadPageVADescriptions(pageOid);
    }

    public R01MIndexablePortalPage doPreparePageToBeIndexed(R01MUserContext userCtx, String pageOid) throws R01MSecurityException, R01MPortalModelException {
        R01PPortalPageToIndexableConverter converter;
        R01MIndexablePortalPage outIdxPage;
        R01MPage page;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("Preparando la pagina de portal " + pageOid + " para su indexaci\u00f3n....");
        }
        if ((page = this.doLoadPortalPage(userCtx, pageOid)) == null) {
            return null;
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("PASO 1: Obtener el contenido indexable");
        }
        if ((outIdxPage = (converter = new R01PPortalPageToIndexableConverter(userCtx, page)).getIndexablePage()) == null) {
            return null;
        }
        boolean copyIndexableXMLToPortalFolder = XMLProperties.getBoolean((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/pageIndexPrepareOps/copyIndexableXMLToPortalFolder", (boolean)true);
        if (copyIndexableXMLToPortalFolder) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("PASO 2: Subir el XML indexable a la carpeta del portal");
            }
            try {
                R01GPortalInDataStore portalInDS = new R01GPortalInDataStore(userCtx, page.getPortalOid());
                String idxDescriptorXML = "<?xml version='1.0' encoding='ISO-8859-1'?>" + XOManager.getXML((String)R01MConstants.INDEXABLEOBJECTS_MAPFILE, (Object)outIdxPage);
                portalInDS.updateIndexableDescriptor(page.getInternalName(), idxDescriptorXML);
            }
            catch (XOMarshallerException xoEx) {
                throw new R01MPortalModelException("No se ha podido convertir el contenido indexable en XML: " + xoEx.getMessage(), (Exception)((Object)xoEx));
            }
            catch (R01MDataStoreException dsEx) {
                throw new R01MPortalModelException("NO se ha podido subir el XML indexable al dataStore: " + dsEx.getMessage(), (Exception)((Object)dsEx));
            }
        }
        return outIdxPage;
    }

    public R01MIndexablePortalPage doGetIndexablePortalPage(R01MUserContext userCtx, String pageOid) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "Cargando la versi\u00f3n indexable del contenido " + pageOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        R01MPage thePortalPage = this.doLoadPortalPage(userCtx, pageOid);
        R01MIndexablePortalPage outIdxPage = null;
        try {
            R01GPortalInDataStore portalInDS = new R01GPortalInDataStore(userCtx, thePortalPage.getPortalOid());
            String indexablePageXML = portalInDS.downloadIndexableDescriptor(thePortalPage.getInternalName());
            if (indexablePageXML == null) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("...en el almacenamiento de paginas NO existe el fichero XML con la versi\u00f3n indexable de la pagina " + pageOid + "... se crea la pagina indexable!");
                }
                outIdxPage = R01MClientFactory.getPortalModelAPI((R01MUserContext)userCtx, (String)thePortalPage.getPortalOid()).preparePageToBeIndexed(pageOid);
            } else {
                outIdxPage = (R01MIndexablePortalPage)XOManager.getObject((String)R01MConstants.INDEXABLEOBJECTS_MAPFILE, (String)indexablePageXML);
            }
        }
        catch (XOMarshallerException xoEx) {
            throw new R01MPortalModelException("El xml indexable de la pagina " + pageOid + " NO es correcto: " + xoEx.getMessage(), (Exception)((Object)xoEx));
        }
        catch (R01MDataStoreException dsEx) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("...en el almacenamiento de paginas NO existe el fichero XML con la versi\u00f3n indexable de la pagina " + pageOid + "... se crea la pagina indexable!");
            }
            outIdxPage = R01MClientFactory.getPortalModelAPI((R01MUserContext)userCtx, (String)thePortalPage.getPortalOid()).preparePageToBeIndexed(pageOid);
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
        return outIdxPage;
    }

    public Map doGetOperationsGroupByPages(R01MUserContext userCtx, R01MChangesLabelsPacket changesPacket) throws R01MPortalModelException, R01MSecurityException {
        if (!this._validateAdminContext(userCtx)) {
            throw new R01MSecurityException("El usuario no tiene permisos para ejecutar esta operaci\u00f3n.");
        }
        try {
            return R01GLabelsListenerSLUtil.getLocalHome().create().doCreateOperationsGroup(changesPacket);
        }
        catch (Exception ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error en la creaci\u00f3n de los grupos de operaciones.Error:" + ex.getMessage());
            throw new R01MPortalModelException("Error en la creaci\u00f3n de los grupos de operaciones.Error:" + ex.getMessage());
        }
    }

    private boolean _validateAdminContext(R01MUserContext userCtx) {
        if (userCtx == null) {
            return false;
        }
        return userCtx.getUserProfile().equals("masterSystem");
    }

    private boolean _doCheckPageExistence(String pageOid) throws R01MPortalModelException {
        String opDesc = "Comprobar la existencia de la p\u00e1gina " + pageOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01GEjbPortalModelLoader modelLoader = new R01GEjbPortalModelLoader();
            boolean exist = modelLoader.executeCheckPageExistence(pageOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc + ".Resultado:" + exist);
            }
            return exist;
        }
        catch (R01GPortalModelPersistenceException cmEx) {
            throw new R01MPortalModelException("Error >>" + opDesc, (Exception)((Object)cmEx));
        }
    }

    private boolean _doCheckVisualAreaInstanceExistence(String vaInstanceOid) throws R01MPortalModelException {
        String opDesc = "Comprobar la existencia del area visual " + vaInstanceOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01GEjbPortalModelLoader modelLoader = new R01GEjbPortalModelLoader();
            boolean exist = modelLoader.executeCheckVisualAreaInstanceExistence(vaInstanceOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc + ".Resultado:" + exist);
            }
            return exist;
        }
        catch (R01GPortalModelPersistenceException cmEx) {
            throw new R01MPortalModelException("Error >>" + opDesc, (Exception)((Object)cmEx));
        }
    }

    private boolean _doCheckPortalAliasExistence(String aliasOid) throws R01MPortalModelException {
        String opDesc = "Comprobar la existencia del alias " + aliasOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01GEjbPortalModelLoader modelLoader = new R01GEjbPortalModelLoader();
            boolean exist = modelLoader.executeCheckPortalAliasExistence(aliasOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc + ".Resultado:" + exist);
            }
            return exist;
        }
        catch (R01GPortalModelPersistenceException cmEx) {
            throw new R01MPortalModelException("Error >>" + opDesc, (Exception)((Object)cmEx));
        }
    }

    private boolean _doCheckCategoryExistence(String categoryOid) throws R01MPortalModelException {
        String opDesc = "Comprobar la existencia de la categor\u00eda " + categoryOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01GEjbPortalModelLoader modelLoader = new R01GEjbPortalModelLoader();
            boolean exist = modelLoader.executeCheckCategoryExistence(categoryOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc + ".Resultado:" + exist);
            }
            return exist;
        }
        catch (R01GPortalModelPersistenceException cmEx) {
            throw new R01MPortalModelException("Error >>" + opDesc, (Exception)((Object)cmEx));
        }
    }

    private boolean _doCheckPagesWithCategory(String categoryOid) throws R01MPortalModelException {
        String opDesc = "Comprobar la existencia de p\u00e1ginas con la categor\u00eda " + categoryOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01GDAOPortalModelLoader finder = new R01GDAOPortalModelLoader();
            boolean exist = finder.executePagesWithCategory(categoryOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc + ".Resultado:" + exist);
            }
            return exist;
        }
        catch (R01GPortalModelPersistenceException cmEx) {
            throw new R01MPortalModelException("Error >>" + opDesc, (Exception)((Object)cmEx));
        }
    }

    private boolean _doCheckTemplateExistence(String portalOid, String templateId) throws R01MPortalModelException {
        String opDesc = "Comprobar la existencia de la plantilla " + templateId;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01GEjbPortalModelLoader modelLoader = new R01GEjbPortalModelLoader();
            boolean exist = modelLoader.executeCheckTemplateExistence(portalOid, templateId);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc + ".Resultado:" + exist);
            }
            return exist;
        }
        catch (R01GPortalModelPersistenceException cmEx) {
            throw new R01MPortalModelException("Error >>" + opDesc, (Exception)((Object)cmEx));
        }
    }

    private boolean _doCheckPagesWithTemplate(String portalOid, String templateId) throws R01MPortalModelException {
        String opDesc = "Comprobar la existencia de p\u00e1ginas con la plantilla " + templateId;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01GDAOPortalModelLoader finder = new R01GDAOPortalModelLoader();
            boolean exist = finder.executePagesWithTemplate(portalOid, templateId);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc + ".Resultado:" + exist);
            }
            return exist;
        }
        catch (R01GPortalModelPersistenceException cmEx) {
            throw new R01MPortalModelException("Error >>" + opDesc, (Exception)((Object)cmEx));
        }
    }

    private void _sendAliasStructureUpdateMessage(String portalOid, boolean onlyModified) throws R01MJMSException {
        ArrayList<R01MJmsQueueParam> paramList = new ArrayList<R01MJmsQueueParam>();
        paramList.add(new R01MJmsQueueParam(3, "objectType", (Object)Integer.toString(3)));
        paramList.add(new R01MJmsQueueParam(1, "objectOid", (Object)portalOid));
        paramList.add(new R01MJmsQueueParam(2, "onlyModified", (Object)Boolean.toString(onlyModified)));
        try {
            R01MJMSUtils.sendJMSMessage((String)"r01UpdateAlias", paramList);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("Mensaje enviado a r01UpdateAlias");
            }
        }
        catch (R01MJMSException jmsExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al enviar el mensaje r01UpdateAlias. Error:" + jmsExc.getMessage());
            throw new R01MJMSException("Error al enviar el mensaje r01UpdateAlias", (Exception)((Object)jmsExc));
        }
    }
}

