/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01g.services;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01g.config.loaders.R01GPortalLoaderFactory;
import com.ejie.r01g.datastore.R01GPortalInDataStore;
import com.ejie.r01g.services.R01GBasePortalManager;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.datastore.R01MDataStoreItemFilter;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MDataStoreException;
import com.ejie.r01m.exceptions.R01MPortalModelException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.datastore.R01MDataStoreItem;
import com.ejie.r01m.objects.portalmodel.R01MPortal;
import com.ejie.r01m.services.bzd.R01MPortalDataManagerBzd;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;

public class R01GPortalDataManager
extends R01GBasePortalManager
implements R01MPortalDataManagerBzd {
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01g.dataAPI").intValue() != Level.OFF.intValue();
    private transient R01GPortalInDataStore _thePortalInDataStore;

    public R01GPortalDataManager() {
    }

    public R01GPortalDataManager(R01MUserContext userCtx, R01MPortal port) throws R01MSecurityException, R01MPortalModelException {
        this();
        this._obtainPortalInDataStore(userCtx, port);
    }

    private R01GPortalInDataStore _obtainPortalInDataStore(R01MUserContext userCtx, String portalOid) throws R01MSecurityException, R01MPortalModelException {
        if (this._thePortalInDataStore == null) {
            try {
                R01MPortal portal = R01GPortalLoaderFactory.getPortalDataLoader().loadPortal(portalOid);
                this._obtainPortalInDataStore(userCtx, portal);
            }
            catch (R01MConfigLoadException cfgLoadEx) {
                throw new R01MPortalModelException("Error de configuracion al cargar el portal " + portalOid + ": " + cfgLoadEx.getMessage(), (Exception)((Object)cfgLoadEx));
            }
        }
        return this._thePortalInDataStore;
    }

    private R01GPortalInDataStore _obtainPortalInDataStore(R01MUserContext userCtx, R01MPortal portal) throws R01MPortalModelException {
        if (this._thePortalInDataStore == null) {
            this._thePortalInDataStore = new R01GPortalInDataStore(userCtx, portal);
        } else if (!this._thePortalInDataStore.getPortal().getOid().equals(portal.getOid())) {
            throw new R01MPortalModelException("Se est\u00e1 intentando reutilizar el mismo datamanager con dos portales distintos!!! Crear un objeto datamanager para cada uno de ellos");
        }
        return this._thePortalInDataStore;
    }

    public InputStream doDownloadAdminPage(R01MUserContext userCtx, String portalOid, String pageInternalName) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doDownloadAdminPage > portalOid=" + portalOid + " pageInternalName=" + pageInternalName;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        try {
            return portalInDataStore.downloadAdminPage(pageInternalName);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPortalModelException("Error al descargar la pagina de administracion " + pageInternalName + " del portal " + portalOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public byte[] doDownloadAdminPageChunk(R01MUserContext userCtx, String portalOid, String pageInternalName, long offset, int length) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doDownloadAdminPageChunk > portalOid=" + portalOid + " pageInternalName=" + pageInternalName + " chunk=" + offset + "," + length;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        try {
            return portalInDataStore.downloadAdminPageChunk(pageInternalName, offset, length);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPortalModelException("Error al descargar el fragmento " + offset + " de la pagina de administracion " + pageInternalName + " del portal " + portalOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public InputStream doDownloadPage(R01MUserContext userCtx, String portalOid, String pageInternalName) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doDownloadPage > portalOid=" + portalOid + " pageInternalName=" + pageInternalName;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        try {
            return portalInDataStore.downloadPage(pageInternalName);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPortalModelException("Error al descargar la pagina " + pageInternalName + " del portal " + portalOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public byte[] doDownloadPageChunk(R01MUserContext userCtx, String portalOid, String pageInternalName, long offset, int length) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doDownloadPageChunk > portalOid=" + portalOid + " pageInternalName=" + pageInternalName + " offset=" + offset + "," + length;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        try {
            return portalInDataStore.downloadPageChunk(pageInternalName, offset, length);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPortalModelException("Error al descargar el fragmento " + offset + " de la pagina " + pageInternalName + " del portal " + portalOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public InputStream doDownloadTemplate(R01MUserContext userCtx, String portalOid, String templateInternalName) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doDownloadTemplate > portalOid=" + portalOid + " templateInternalName=" + templateInternalName;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        try {
            return portalInDataStore.downloadTemplate(templateInternalName);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPortalModelException("Error al descargar la plantilla " + templateInternalName + " del portal " + portalOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public byte[] doDownloadTemplateChunk(R01MUserContext userCtx, String portalOid, String templateInternalName, long offset, int length) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doDownloadTemplateChunk > portalOid=" + portalOid + " templateInternalName=" + templateInternalName + " offset=" + offset + "," + length;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        try {
            return portalInDataStore.downloadTemplateChunk(templateInternalName, offset, length);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPortalModelException("Error al descargar el fragmento " + offset + " de la plantilla " + templateInternalName + " del portal " + portalOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public InputStream doDownloadAV(R01MUserContext userCtx, String portalOid, String avType, String avLang, String avOid) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doDownloadAV > portalOid=" + portalOid + " av=" + avType + "," + avLang + "," + avOid;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        try {
            return portalInDataStore.downloadAV(avType, avLang, avOid);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPortalModelException("Error al descargar el av=" + avType + "," + avLang + "," + avOid + " del portal " + portalOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public byte[] doDownloadAVChunk(R01MUserContext userCtx, String portalOid, String avType, String avLang, String avOid, long offset, int length) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doDownloadAVChunk > portalOid=" + portalOid + " av=" + avType + "," + avLang + "," + avOid + " offset=" + offset + "," + length;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        try {
            return portalInDataStore.downloadAVChunk(avType, avLang, avOid, offset, length);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPortalModelException("Error al descargar el fragmento " + offset + " del av=" + avType + "," + avLang + "," + avOid + " del portal " + portalOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public InputStream doDownloadPortalResource(R01MUserContext userCtx, String portalOid, int resourceType, String resourceName) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doDownloadPortalResource > portalOid=" + portalOid + " resource=" + resourceType + "," + resourceName;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        try {
            return portalInDataStore.downloadPortalResource(resourceType, resourceName);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPortalModelException("Error al descargar el recurso " + resourceType + "," + resourceName + " del portal " + portalOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public byte[] doDownloadPortalResourceChunk(R01MUserContext userCtx, String portalOid, int resourceType, String resourceName, long offset, int length) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doDownloadPortalResourceChunk > portalOid=" + portalOid + " resource=" + resourceType + "," + resourceName + " chunk=" + offset + "," + length;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        try {
            return portalInDataStore.downloadPortalResourceChunk(resourceType, resourceName, offset, length);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPortalModelException("Error al descargar el fragmento " + offset + " recurso " + resourceType + "," + resourceName + " del portal " + portalOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public InputStream doDownloadPortalFile(R01MUserContext userCtx, String portalOid, String resourceWARelativePath) throws R01MSecurityException, R01MPortalModelException {
        super.validateSecurityContext(userCtx, portalOid, 0);
        if (DEBUG) {
            R01FLog.to((String)"r01g.manager").info("doDownloadPortalResource > portalOid=" + portalOid + " resourceWARelativePath=" + resourceWARelativePath);
        }
        if (resourceWARelativePath != null) {
            R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
            try {
                boolean existResource = portalInDataStore.checkResourceFileExistence(resourceWARelativePath);
                if (DEBUG) {
                    R01FLog.to((String)"r01g.manager").info("El recurso '" + resourceWARelativePath + ": " + (existResource ? "Existe" : "NO Existe") + " en el path " + resourceWARelativePath);
                }
                if (!existResource) {
                    throw new R01MPortalModelException("Error en la validaci\u00f3n de la existencia del recurso " + resourceWARelativePath);
                }
            }
            catch (R01MDataStoreException ex) {
                throw new R01MPortalModelException("Error en la validaci\u00f3n de la existencia del recurso " + resourceWARelativePath, (Exception)((Object)ex));
            }
            try {
                return portalInDataStore.downloadPortalResource(0, resourceWARelativePath);
            }
            catch (R01MDataStoreException ex) {
                throw new R01MPortalModelException("Error en la descarga del recurso " + resourceWARelativePath, (Exception)((Object)ex));
            }
        }
        return null;
    }

    public byte[] doDownloadPortalFileChunk(R01MUserContext userCtx, String portalOid, String resourceWARelativePath, long offset, int length) throws R01MSecurityException, R01MPortalModelException {
        super.validateSecurityContext(userCtx, portalOid, 0);
        if (DEBUG) {
            R01FLog.to((String)"r01g.manager").info("doDownloadPortalResourceChunk > portalOid=" + portalOid + " resourceWARelativePath=" + resourceWARelativePath + " offset=" + offset + ":" + length);
        }
        if (resourceWARelativePath != null) {
            R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
            try {
                boolean existResource = portalInDataStore.checkResourceFileExistence(resourceWARelativePath);
                if (DEBUG) {
                    R01FLog.to((String)"r01g.manager").info("El recurso '" + resourceWARelativePath + ": " + (existResource ? "Existe" : "NO Existe") + " en el path " + resourceWARelativePath);
                }
                if (!existResource) {
                    throw new R01MPortalModelException("Error en la validaci\u00f3n de la existencia del recurso " + resourceWARelativePath);
                }
            }
            catch (R01MDataStoreException ex) {
                throw new R01MPortalModelException("Error en la validaci\u00f3n de la existencia del recurso " + resourceWARelativePath, (Exception)((Object)ex));
            }
            try {
                return portalInDataStore.downloadPortalResourceChunk(0, resourceWARelativePath, offset, length);
            }
            catch (R01MDataStoreException ex) {
                throw new R01MPortalModelException("Error en la descarga del recurso " + resourceWARelativePath, (Exception)((Object)ex));
            }
        }
        return null;
    }

    public InputStream doDownloadAVResource(R01MUserContext userCtx, String portalOid, String avType, String resourceType, String resourceName) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doDownloadAVResource > portalOid=" + portalOid + " av=" + avType + " resource=" + resourceType + "," + resourceName;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        try {
            return portalInDataStore.downloadAVResource(avType, resourceType, resourceName);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPortalModelException("Error al descargar recurso " + resourceType + "," + resourceName + " del AV tipo " + avType + " del portal " + portalOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public byte[] doDownloadAVResourceChunk(R01MUserContext userCtx, String portalOid, String avType, String resourceType, String resourceName, long offset, int length) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doDownloadAVResourceChunk > portalOid=" + portalOid + " av=" + avType + " resource=" + resourceType + "," + resourceName + " chunk=" + offset + "," + length;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        try {
            return portalInDataStore.downloadAVResourceChunk(avType, resourceType, resourceName, offset, length);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPortalModelException("Error al descargar el fragmento " + offset + " del recurso " + resourceType + "," + resourceName + " del AV tipo " + avType + " del portal " + portalOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public void doUploadAdminPage(R01MUserContext userCtx, String portalOid, String pageInternalName, InputStream pageHtml) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doUploadAdminPage > portalOid=" + portalOid + " pageInternalName=" + pageInternalName;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        try {
            portalInDataStore.uploadAdminPage(pageInternalName, pageHtml);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPortalModelException("Error al actualizar la pagina " + pageInternalName + " del portal " + portalOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public void doUploadAdminPageChunk(R01MUserContext userCtx, String portalOid, String pageInternalName, byte[] pageHtmlChunk, long offset) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doUploadAdminPageChunk > portalOid=" + portalOid + " pageInternalName=" + pageInternalName + " chunk=" + offset;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        try {
            portalInDataStore.uploadAdminPageChunk(pageInternalName, pageHtmlChunk, offset);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPortalModelException("Error al actualizar el fragmento " + offset + " la pagina de administracion " + pageInternalName + " del portal " + portalOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public void doUploadPage(R01MUserContext userCtx, String portalOid, String pageInternalName, InputStream pageHtml) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doUploadPage > portalOid=" + portalOid + " pageInternalName=" + pageInternalName;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        try {
            portalInDataStore.uploadPage(pageInternalName, pageHtml);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPortalModelException("Error al actualizar la pagina " + pageInternalName + " del portal " + portalOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public void doUploadPageChunk(R01MUserContext userCtx, String portalOid, String pageInternalName, byte[] pageHtmlChunk, long offset) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doUploadPageChunk > portalOid=" + portalOid + " pageInternalName=" + pageInternalName + " chunk=" + offset;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        try {
            portalInDataStore.uploadPageChunk(pageInternalName, pageHtmlChunk, offset);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPortalModelException("Error al actualizar el fragmento " + offset + " la pagina " + pageInternalName + " del portal " + portalOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public void doUploadInitialPage(R01MUserContext userCtx, String portalOid, String pageInternalName, InputStream pageHtml) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doUploadInitialPage > portalOid=" + portalOid + " pageInternalName=" + pageInternalName;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        try {
            portalInDataStore.uploadInitialPage(pageInternalName, pageHtml);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPortalModelException("Error al actualizar la pagina de inicio " + pageInternalName + " del portal " + portalOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public void doUploadTemplate(R01MUserContext userCtx, String portalOid, String templateInternalName, InputStream templateHtml) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doUploadTemplate > portalOid=" + portalOid + " templateInternalName=" + templateInternalName;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        try {
            portalInDataStore.uploadTemplate(templateInternalName, templateHtml);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPortalModelException("Error al actualizar la plantilla " + templateInternalName + " del portal " + portalOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public void doUploadTemplateChunk(R01MUserContext userCtx, String portalOid, String templateInternalName, byte[] templateHtmlChunk, long offset) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doUploadTemplateChunk > portalOid=" + portalOid + " templateInternalName=" + templateInternalName + " chunk=" + offset;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        try {
            portalInDataStore.uploadTemplateChunk(templateInternalName, templateHtmlChunk, offset);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPortalModelException("Error al actualizar el fragmento " + offset + " de la plantilla " + templateInternalName + " del portal " + portalOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public void doUploadPublishFile(R01MUserContext userCtx, String portalOid, String fileListPublishName, InputStream pubFileList) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doUploadPublishFile > portalOid=" + portalOid + " pubFileName=" + fileListPublishName;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        try {
            portalInDataStore.uploadPublishFile(fileListPublishName, pubFileList);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPortalModelException("Error al actualizar el fichero de publicacion " + fileListPublishName + " del portal " + portalOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public void doUploadAV(R01MUserContext userCtx, String portalOid, String avType, String avInternalName, String avLang, InputStream avHtml) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doUploadAV > portalOid=" + portalOid + " av=" + avType + "," + avInternalName + "," + avLang;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        try {
            portalInDataStore.uploadAV(avType, avInternalName, avLang, avHtml);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPortalModelException("Error al actualizar el av " + avType + "," + avInternalName + "," + avLang + " del portal " + portalOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public void doUploadAVChunk(R01MUserContext userCtx, String portalOid, String avType, String avInternalName, String avLang, byte[] avHtmlChunk, long offset) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doUploadAVChunk > portalOid=" + portalOid + " av=" + avType + "," + avInternalName + "," + avLang + " offset=" + offset;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        try {
            portalInDataStore.uploadAVChunk(avType, avInternalName, avLang, avHtmlChunk, offset);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPortalModelException("Error al actualizar el fragmento " + offset + " del av " + avType + "," + avInternalName + "," + avLang + " del portal " + portalOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public void doUploadPortalResource(R01MUserContext userCtx, String portalOid, int resourceType, String resourceName, InputStream resource) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doUploadPortalResource > portalOid=" + portalOid + " resource=" + resourceType + "," + resourceName;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        try {
            portalInDataStore.uploadPortalResource(resourceType, resourceName, resource);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPortalModelException("Error al actualizar el recurso " + resourceType + "," + resourceName + " del portal " + portalOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public void doUploadPortalResource(R01MUserContext userCtx, String portalOid, int resourceType, String pageInternalName, String resourceName, InputStream resource) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doUploadPortalResource > portalOid=" + portalOid + " resource=" + resourceType + "," + resourceName;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        try {
            portalInDataStore.uploadPortalResource(resourceType, pageInternalName, resourceName, resource);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPortalModelException("Error al actualizar el recurso " + resourceType + "," + resourceName + " del portal " + portalOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public void doUploadPortalResource(R01MUserContext userCtx, String portalOid, int resourceType, String pageInternalName, String language, String resourceName, InputStream resource) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doUploadPortalResource > portalOid=" + portalOid + " resource=" + resourceType + "," + resourceName;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        try {
            portalInDataStore.uploadPortalResource(resourceType, pageInternalName, language, resourceName, resource);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPortalModelException("Error al actualizar el recurso " + resourceType + "," + resourceName + " del portal " + portalOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public void doUploadPortalResourceChunk(R01MUserContext userCtx, String portalOid, int resourceType, String resourceName, byte[] resChunk, long offset) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doUploadPortalResourceChunk > portalOid=" + portalOid + " resource=" + resourceType + "," + resourceName + "," + " offset=" + offset;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        try {
            portalInDataStore.uploadPortalResourceChunk(resourceType, resourceName, resChunk, offset);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPortalModelException("Error al actualizar el fragmento " + offset + " del recurso " + resourceType + "," + resourceName + " del portal " + portalOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public void doUploadAVResource(R01MUserContext userCtx, String portalOid, String avType, int resourceType, String resourceName, InputStream resource) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doUploadAVResource > portalOid=" + portalOid + " av=" + avType + " resource=" + resourceType + "," + resourceName;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        try {
            portalInDataStore.uploadAVResource(avType, resourceType, resourceName, resource);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPortalModelException("Error al actualizar el recurso " + resourceType + "," + resourceName + " del av " + avType + " del portal " + portalOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public void doUploadAVResourceChunk(R01MUserContext userCtx, String portalOid, String avType, String resourceType, String resourceName, byte[] resChunk, long offset) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doUploadAVResourceChunk > portalOid=" + portalOid + " av=" + avType + " resource=" + resourceType + "," + resourceName + "," + " offset=" + offset;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        try {
            portalInDataStore.uploadAVResourceChunk(avType, resourceType, resourceName, resChunk, offset);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPortalModelException("Error al actualizar el fragmento " + offset + " del recurso " + resourceType + "," + resourceName + " del av " + avType + " del portal " + portalOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public void doDeletePage(R01MUserContext userCtx, String portalOid, String pageInternalName) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doDeletePage > portalOid=" + portalOid + " page=" + pageInternalName;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        try {
            portalInDataStore.deletePage(pageInternalName);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPortalModelException("Error al borrar la pagina " + pageInternalName + " del portal " + portalOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public void doDeleteResource(R01MUserContext userCtx, String portalOid, String resourceWorkAreaRelativePath) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doDeleteResource > portalOid=" + portalOid + " resourcePath=" + resourceWorkAreaRelativePath;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        try {
            portalInDataStore.deleteResource(resourceWorkAreaRelativePath);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPortalModelException("Error al borrar el recurso " + resourceWorkAreaRelativePath + " del portal " + portalOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public void doDeleteTemplate(R01MUserContext userCtx, String portalOid, String templateInternalName) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doDeleteTemplate > portalOid=" + portalOid + " template=" + templateInternalName;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        try {
            portalInDataStore.deleteTemplate(templateInternalName);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPortalModelException("Error al borrar la plantilla " + templateInternalName + " del portal " + portalOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public void doCreatePublishDir(R01MUserContext userCtx, String portalOid) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doCreatePublishDir > portalOid=" + portalOid;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        try {
            portalInDataStore.createPublishDir();
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPortalModelException("Error al crear el directorio de publicaci\u00f3n del portal " + portalOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public StringBuffer doConsolidatePage(R01MUserContext userCtx, String portalOid, List resourcesToConsolidate) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doConsolidatePage > portalOid=" + portalOid;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        return portalInDataStore.consolidatePage(resourcesToConsolidate);
    }

    public StringBuffer doConsolidatePortalResources(R01MUserContext userCtx, String portalOid, List resourcesToConsolidate) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doConsolidatePortalResources > portalOid=" + portalOid;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        return portalInDataStore.consolidatePortalResources(resourcesToConsolidate);
    }

    public StringBuffer doConsolidatePortalResource(R01MUserContext userCtx, String portalOid, int resourceType) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doConsolidatePortalResouce > portalOid=" + portalOid + " resourceType=" + resourceType;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        return portalInDataStore.consolidatePortalResource(resourceType);
    }

    public StringBuffer doConsolidatePortalResourceFile(R01MUserContext userCtx, String portalOid, int resourceType, String resourceFileName) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doConsolidatePortalResouceFile > portalOid=" + portalOid + " resourceType=" + resourceType + " resourceFileName=" + resourceFileName;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        return portalInDataStore.consolidatePortalResourceFile(resourceType, resourceFileName);
    }

    public StringBuffer doConsolidatePortalResourceFile(R01MUserContext userCtx, String portalOid, int resourceType, String pageInternalName, String resourceFileName) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doConsolidatePortalResouceFile > portalOid=" + portalOid + " resourceType=" + resourceType + " resourceFileName=" + resourceFileName;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        return portalInDataStore.consolidatePortalResourceFile(resourceType, pageInternalName, resourceFileName);
    }

    public StringBuffer doConsolidatePortalResourceFile(R01MUserContext userCtx, String portalOid, int resourceType, String pageInternalName, String language, String resourceFileName) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doConsolidatePortalResouceFile > portalOid=" + portalOid + " resourceType=" + resourceType + " resourceFileName=" + resourceFileName;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        return portalInDataStore.consolidatePortalResourceFile(resourceType, pageInternalName, resourceFileName);
    }

    public boolean doCheckResourceFileExistence(R01MUserContext userCtx, String portalOid, String filePath) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doCheckResourceFileExistence > portalOid=" + portalOid + " file=" + filePath;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        try {
            return portalInDataStore.checkResourceFileExistence(filePath);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPortalModelException("Error al chequear la existencia del fichero " + filePath + " en el portal " + portalOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public R01MDataStoreItem[] doGetImageResourcesFileList(R01MUserContext userCtx, String portalOid) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doGetImageResourcesFileList > portalOid=" + portalOid;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        try {
            return portalInDataStore.getImageResourcesFileList();
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPortalModelException("Error al obtener las imagenes del portal " + portalOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public R01MDataStoreItem[] doGetResourcesFileList(R01MUserContext userCtx, String portalOid, String dirWARelativePath) throws R01MSecurityException, R01MPortalModelException {
        return this.doGetResourcesFileList(userCtx, portalOid, dirWARelativePath, false);
    }

    public R01MDataStoreItem[] doGetResourcesFileList(R01MUserContext userCtx, String portalOid, String dirWARelativePath, boolean isRecursive) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doGetResourcesFileList > portalOid=" + portalOid + " dir=" + dirWARelativePath;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        return this.doGetResourcesFileList(userCtx, portalOid, dirWARelativePath, isRecursive, null, null);
    }

    public R01MDataStoreItem[] doGetResourcesFileList(R01MUserContext userCtx, String portalOid, String dirWARelativePath, boolean isRecursive, R01MDataStoreItemFilter filter, R01MDataStoreItemFilter readOnlyFilter) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "doGetResourcesFileList > portalOid=" + portalOid + " dir=" + dirWARelativePath;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA: " + opDesc);
        }
        R01GPortalInDataStore portalInDataStore = this._obtainPortalInDataStore(userCtx, portalOid);
        try {
            return portalInDataStore.getResourcesFileList(dirWARelativePath, isRecursive, filter, readOnlyFilter);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPortalModelException("Error al obtener los recursos del directorio " + dirWARelativePath + " del portal " + portalOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }
}

