/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01g.services;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.NumberUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01g.api.R01GVisualAreasAPI;
import com.ejie.r01g.api.utils.R01GConstants;
import com.ejie.r01g.config.loaders.R01GPortalLoaderFactory;
import com.ejie.r01g.datastore.R01GCommonPortalInDataStore;
import com.ejie.r01g.datastore.R01GPortalInDataStore;
import com.ejie.r01g.exceptions.R01GPortalModelPersistenceException;
import com.ejie.r01g.gestorportal.dbhelppers.dao.R01GDAOPortalModelLoader;
import com.ejie.r01g.gestorportal.dbhelppers.dao.R01GDAOPortalModelManager;
import com.ejie.r01g.gestorportal.dbhelppers.ejb.R01GEjbPortalModelLoader;
import com.ejie.r01g.gestorportal.ejb.portal.R01GPortalBMPUtil;
import com.ejie.r01g.gestorportal.ejb.portal.R01GPortalCMPPK;
import com.ejie.r01g.gestorportal.ejb.portal.R01GPortalCMPUtil;
import com.ejie.r01g.gestorportal.ejb.visualarea.R01GVisualAreaBMPUtil;
import com.ejie.r01g.gestorportal.ejb.visualarea.R01GVisualAreaCMPPK;
import com.ejie.r01g.gestorportal.ejb.visualarea.R01GVisualAreaCMPUtil;
import com.ejie.r01g.gestorportal.ejb.visualarea.R01GVisualAreaCMPValue;
import com.ejie.r01g.objects.R01GComposeVAResult;
import com.ejie.r01g.services.R01GBasePortalManager;
import com.ejie.r01g.services.R01GPortalModelManager;
import com.ejie.r01g.util.R01GProperties;
import com.ejie.r01g.visualareas.helpper.R01GVAHelpper;
import com.ejie.r01m.config.objects.portalmodel.R01MVisualAreasConfig;
import com.ejie.r01m.config.objects.publisher.R01MAllowedPublicationTarget;
import com.ejie.r01m.config.objects.publisher.R01MPublicationConfig;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MConfigControllerException;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MDataStoreException;
import com.ejie.r01m.exceptions.R01MPortalModelException;
import com.ejie.r01m.exceptions.R01MPortalModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MPublisherException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.R01MBaseLocationObject;
import com.ejie.r01m.objects.misc.R01MOperationInModelObjectResult;
import com.ejie.r01m.objects.portalmodel.R01MPortal;
import com.ejie.r01m.objects.portalmodel.R01MPortalLocation;
import com.ejie.r01m.objects.portalmodel.R01MPortalPublicationRequested;
import com.ejie.r01m.objects.portalmodel.R01MVisualArea;
import com.ejie.r01m.objects.portalmodel.R01MVisualAreaInstance;
import com.ejie.r01m.objects.portalmodel.R01MVisualAreaInstanceResume;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.bzd.R01MPortalAdminBzd;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MDateUtils;
import com.ejie.r01m.utils.R01MDozerMappingUtils;
import com.ejie.r01m.utils.R01MPathHelpper;
import com.ejie.r01m.utils.jms.R01MJMSUtils;
import com.ejie.r01m.utils.jms.R01MJmsQueueParam;
import com.ejie.r01p.objects.publisher.R01PPublishDefinition;
import com.ejie.r01p.services.R01PClientFactory;
import com.ejie.r01p.utils.R01PConstants;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import net.sf.dozer.util.mapping.MappingException;

public class R01GPortalAdminManager
extends R01GBasePortalManager
implements R01MPortalAdminBzd {
    private static String LOG_TYPE_ID = "r01g.manager";
    private static final boolean DEBUG = R01FLog.getLogLevel((String)LOG_TYPE_ID).intValue() != Level.OFF.intValue();
    private static final String HTACCESS_REDIRECTION_TYPE = XMLProperties.get((String)R01GProperties.applicationCode, (String)"portal/htaccessRedirectionType", (String)"htaccess");
    private static final String SCRIPT_RESOURCES_LOCATION = XMLProperties.get((String)R01GProperties.applicationCode, (String)"portal/commonResources/scriptCustomResources");
    private transient List allDynamicVAsToPublish = null;
    private final R01GPortalModelManager manager = new R01GPortalModelManager();
    private R01MVisualAreasConfig _visualareasConfig = null;

    public R01GPortalAdminManager() {
        try {
            this._visualareasConfig = R01GPortalLoaderFactory.getPortalConfigLoader().loadVisualAreasConfig();
        }
        catch (R01MConfigLoadException cfgExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("No se ha podido cargar la configuraci\u00f3n de Areas Visuales.Error:" + cfgExc.getMessage());
            this._visualareasConfig = null;
        }
    }

    public void doSavePortal(R01MUserContext userCtx, String portalXML) throws R01MPortalModelException, R01MSecurityException, R01MPortalModelObjectsValidatorException {
        R01MPortal portal = this.doSaveBasePortal(userCtx, portalXML);
        this.doUpdatePortalState(userCtx, portal);
    }

    public R01MPortal doSaveBasePortal(R01MUserContext userCtx, String portalXML) throws R01MPortalModelException, R01MSecurityException, R01MPortalModelObjectsValidatorException {
        R01MPortal portal = null;
        if (portalXML != null && !StringUtils.isEmptyString((String)portalXML)) {
            try {
                portal = (R01MPortal)XOManager.getObject((String)R01MConstants.PORTALMODEL_MAPFILE, (String)portalXML);
            }
            catch (XOMarshallerException ex) {
                throw new R01MPortalModelObjectsValidatorException((Exception)((Object)ex));
            }
        }
        if (portal == null) {
            throw new R01MPortalModelObjectsValidatorException("Portal NULL");
        }
        super.validateSecurityContext(userCtx, portal.getOid(), 0);
        String opDesc = "Guardando el portal " + portal.getOid();
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        try {
            portal.validateObject();
            if (this._doCheckPortalExistence(portal.getOid())) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\t... el portal ya existe es una actualizacion");
                }
                this._doUpdatePortal(userCtx, portal.getOid(), portalXML);
            } else {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\t... el portal es NUEVO");
                }
                this._doCreatePortal(userCtx, portal.getOid(), portalXML);
            }
        }
        catch (R01MPortalModelException pmEx) {
            pmEx.printStackTrace(System.out);
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + pmEx.getMessage());
            throw new R01MPortalModelException(opDesc + " >> Error:" + pmEx.getMessage(), (Exception)((Object)pmEx));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
        return portal;
    }

    public void doUpdatePortalState(R01MUserContext userCtx, R01MPortal portal) throws R01MPortalModelException, R01MSecurityException, R01MPortalModelObjectsValidatorException {
        String opDesc = "Guardando el portal " + portal.getOid();
        try {
            try {
                R01GPortalLoaderFactory.getPortalDataLoader().reload(portal.getOid());
            }
            catch (R01MConfigLoadException cfgExc) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("Error >>>>>> " + opDesc + ": " + cfgExc.getMessage());
                }
                throw new R01MPortalModelException("Error en la carga del portal " + portal.getOid(), (Exception)((Object)cfgExc));
            }
            this._doRegeneratePortalCookies(userCtx);
            this._doRegenerateHtaccess(userCtx, portal);
            this._doRegeneratePageTracking(userCtx, portal);
            this._doRegenerateDefaultNavigator(userCtx, portal);
        }
        catch (R01MPortalModelException pmEx) {
            pmEx.printStackTrace(System.out);
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + pmEx.getMessage());
            throw new R01MPortalModelException(opDesc + " >> Error:" + pmEx.getMessage(), (Exception)((Object)pmEx));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
    }

    public String doLoadXMLPortal(R01MUserContext userCtx, String portalOid) throws R01MPortalModelException, R01MSecurityException {
        String portalXMLDescriptor;
        super.validateSecurityContext(userCtx, portalOid, 0);
        String opDesc = "Cargando el portal " + portalOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        try {
            portalXMLDescriptor = R01GPortalCMPUtil.getLocalHome().findByPrimaryKey(new R01GPortalCMPPK(portalOid)).getPortalXml();
        }
        catch (NamingException namingEx) {
            throw new R01MPortalModelException("Error al encontrar el home del CMP de portal: " + namingEx.getMessage());
        }
        catch (FinderException findEx) {
            throw new R01MPortalModelException("No existe el portal " + portalOid + ": " + findEx.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
        return portalXMLDescriptor;
    }

    public void doDeletePortal(R01MUserContext userCtx, String portalOid) throws R01MPortalModelException, R01MSecurityException {
        super.validateSecurityContext(userCtx, portalOid, 0);
        String opDesc = "Borrando el portal " + portalOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        if (this._doCheckPortalExistence(portalOid)) {
            this._doDeletePortal(portalOid);
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
    }

    public List[] doRegeneratePortalDynamicVAs(R01MUserContext userCtx, String portalOid) throws R01MSecurityException, R01MPortalModelException {
        super.validateSecurityContext(userCtx, portalOid, 0);
        String opDesc = "Regenerando las Areas Visuales del portal " + portalOid;
        List excludePortalsRegenerationVAs = XMLProperties.getPropertyList((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"regeneratorVAs/excludePortalsRegenerationVAs/portalOid", new ArrayList());
        if (excludePortalsRegenerationVAs != null && !excludePortalsRegenerationVAs.isEmpty() && excludePortalsRegenerationVAs.contains(portalOid)) {
            return null;
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("Comprobando si el store del portal " + portalOid + " est\u00e1 congelado.");
        }
        boolean storeIsActive = true;
        try {
            R01GPortalInDataStore portalDS = new R01GPortalInDataStore(userCtx, portalOid);
            storeIsActive = portalDS.isActiveStore(this.manager.doLoadPortalLocation(userCtx, portalOid).getDataRepositoryOid());
        }
        catch (Exception exc) {
            storeIsActive = true;
        }
        if (!storeIsActive) {
            R01FLog.to((String)LOG_TYPE_ID).warning("El store del portal " + portalOid + " ESTA CONGELADO o ha fallado la consulta del store del portal !!!!!!!!!!!!!!!!!!!!!!!!!.");
            throw new R01MPortalModelException("No se puede acceder al almacenamiento debido a que est\u00e1 congelado!!!!!!!!!!!!!!");
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("El store del portal " + portalOid + " NO est\u00e1 congelado.");
        }
        ArrayList<R01MOperationInModelObjectResult> resultOK = new ArrayList<R01MOperationInModelObjectResult>();
        ArrayList<R01MOperationInModelObjectResult> resultNotOK = new ArrayList<R01MOperationInModelObjectResult>();
        List[] result = new List[2];
        if (this._visualareasConfig != null && this._visualareasConfig.getVisualAreasRegeneration() != null && !this._visualareasConfig.getVisualAreasRegeneration().isEmpty()) {
            this.allDynamicVAsToPublish = new ArrayList();
            R01GDAOPortalModelLoader loader = new R01GDAOPortalModelLoader();
            for (Map.Entry me : this._visualareasConfig.getVisualAreasRegeneration().entrySet()) {
                List visualAreaInstances;
                R01MVisualArea visualArea = (R01MVisualArea)me.getValue();
                try {
                    visualAreaInstances = loader.findVisualAreaInstancesReferenced(portalOid, visualArea.getOid());
                }
                catch (R01GPortalModelPersistenceException ex) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("Error al cargar las instancias de Area Visual referenciadas en el portal " + portalOid + ".Error" + ex.getMessage());
                    throw new R01MPortalModelException("Error al cargar las instancias de Area Visual referenciadas en el portal " + portalOid, (Exception)((Object)ex));
                }
                if (visualAreaInstances == null || visualAreaInstances.isEmpty()) continue;
                for (R01MVisualAreaInstanceResume vaInstance : visualAreaInstances) {
                    R01FLog.to((String)LOG_TYPE_ID).info("Regenerando el area visual " + vaInstance.getName());
                    try {
                        R01MOperationInModelObjectResult operationResult = this.doRegenerateVA(userCtx, portalOid, vaInstance.getOid(), false, false, R01MConstants.DEFAULT_LANG);
                        if (operationResult.isOperationOK()) {
                            resultOK.add(operationResult);
                            continue;
                        }
                        resultNotOK.add(operationResult);
                    }
                    catch (Exception e) {
                        resultNotOK.add(new R01MOperationInModelObjectResult(vaInstance.getOid(), 7, false, "Error en doRegenerateVA.Error:" + e.getMessage()));
                    }
                }
            }
            if (this.allDynamicVAsToPublish != null && !this.allDynamicVAsToPublish.isEmpty()) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("...regenerando el Area Visual en el storage...");
                }
                userCtx.setUserName("Administrator-" + portalOid);
                try {
                    Map allowedTargets;
                    R01MPublicationConfig pubConfig;
                    R01MPortal portal;
                    try {
                        portal = R01GPortalLoaderFactory.getPortalDataLoader().loadPortal(portalOid);
                    }
                    catch (R01MConfigLoadException cfgEx) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("ADMIN SERVER >> Error al cargar el portal de oid " + portalOid + ". Error: " + cfgEx.getMessage());
                        throw new R01MPublisherException("Error al cargar el portal de oid " + portalOid, (Exception)((Object)cfgEx));
                    }
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER >> Portal " + portalOid + " cargado.");
                    }
                    try {
                        pubConfig = R01MClientFactory.getStorageConfigAPI().getWorkAreaConfig(portal.getStoreLocation().getServerOid(), portal.getStoreLocation().getDataRepositoryOid(), portal.getStoreLocation().getAreaOid(), portal.getStoreLocation().getWorkAreaOid()).getAllowedPublicationTargetsConfig();
                    }
                    catch (R01MConfigLoadException clEx) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("ADMIN SERVER >> Error al cargar la configuraci\u00f3n de publicaci\u00f3n para el portal de oid " + portalOid + ". Error:" + clEx.getMessage());
                        throw new R01MPublisherException("Error al cargar la configuraci\u00f3n de publicaci\u00f3n para el portal de oid " + portalOid, (Exception)((Object)clEx));
                    }
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER >> Cargada la informaci\u00f3n de configuraci\u00f3n del portal " + portalOid);
                    }
                    if ((allowedTargets = pubConfig.getAllowedTargets()) != null && !allowedTargets.isEmpty()) {
                        for (R01MAllowedPublicationTarget target : allowedTargets.values()) {
                            if (DEBUG) {
                                R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER >> Mandando la publicaci\u00f3n de AV din\u00e1micas del portal:  " + portalOid + " en el destino " + target.getTargetOid());
                            }
                            R01PPublishDefinition pubDefinition = new R01PPublishDefinition(userCtx.getUserName(), portalOid, 14, null, null, null, target.getTargetOid(), 0, null, null, true, null, null);
                            R01PClientFactory.getPublisherAPI().publish(pubDefinition);
                            if (!DEBUG) continue;
                            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER >> Publicaci\u00f3n de AV din\u00e1micas del portal:  " + portalOid + " en el destino " + target.getTargetOid() + " enviada.");
                        }
                    } else if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER >> No hay repositorios de publicaci\u00f3n permitidos para el portal:  " + portalOid + " --> " + (allowedTargets == null ? "[NULL]" : "VAC\u00cdO"));
                    }
                }
                catch (R01MPublisherException pubExc) {
                    R01MOperationInModelObjectResult publicationResult = new R01MOperationInModelObjectResult();
                    publicationResult.setOperationOK(false);
                    publicationResult.setMsg("Error en la publicaci\u00f3n del Area Visual. Error:" + pubExc.getMessage());
                    resultNotOK.add(publicationResult);
                }
            }
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        result[0] = resultOK;
        result[1] = resultNotOK;
        return result;
    }

    public List[] doRegeneratePortalDynamicVAsJMS(R01MUserContext userCtx, String portalOid) throws R01MSecurityException, R01MPortalModelException {
        List[] result = null;
        int processFlag = 99;
        try {
            processFlag = R01MClientFactory.getConfigControllerAPI().doGetProcessFlag(R01PConstants.REG_VA_PROCESS_APLIC, R01PConstants.REG_VA_PROCESS_CLUSTER, R01PConstants.REG_VA_PROCESS_NAME);
        }
        catch (R01MConfigControllerException ex) {
            processFlag = 99;
            R01FLog.to((String)LOG_TYPE_ID).info("Ha fallado la obtenci\u00f3n del flag de Regeneraci\u00f3n de AV de la Base de Datos.");
        }
        if (processFlag != 1) {
            ArrayList<String> allPortalsOid = null;
            String opDesc = "Regenerando las Areas Visuales ";
            if ("all".equals(portalOid)) {
                try {
                    allPortalsOid = R01MClientFactory.getPortalConfigAPI().loadPortalOids();
                }
                catch (R01MConfigLoadException ex) {
                    R01FLog.to((String)"r01m.portalAPI").info("CLIENT API : Los portales no se han podido cargar error:" + ex.getMessage());
                }
            } else {
                allPortalsOid = new ArrayList<String>();
                allPortalsOid.add(portalOid);
            }
            if (allPortalsOid != null && !allPortalsOid.isEmpty()) {
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API : Los portales a regenerar son:" + allPortalsOid.size());
                ArrayList<String> allPortalsOK = new ArrayList<String>();
                ArrayList<String> allPortalsNotOK = new ArrayList<String>();
                result = new List[2];
                List excludePortalsRegenerationVAs = XMLProperties.getPropertyList((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"regeneratorVAs/excludePortalsRegenerationVAs/portalOid", new ArrayList());
                Iterator itPortals = allPortalsOid.iterator();
                while (itPortals.hasNext()) {
                    block17: {
                        result[0] = new ArrayList();
                        result[1] = new ArrayList();
                        String currPortalOid = (String)itPortals.next();
                        if (excludePortalsRegenerationVAs != null && !excludePortalsRegenerationVAs.isEmpty() && excludePortalsRegenerationVAs.contains(currPortalOid)) continue;
                        super.validateSecurityContext(userCtx, currPortalOid, 0);
                        if (DEBUG) {
                            R01FLog.to((String)LOG_TYPE_ID).info("Comprobando si el store del portal " + currPortalOid + " est\u00e1 congelado.");
                        }
                        boolean storeIsActive = true;
                        try {
                            R01GPortalInDataStore portalDS = new R01GPortalInDataStore(userCtx, currPortalOid);
                            storeIsActive = portalDS.isActiveStore(this.manager.doLoadPortalLocation(userCtx, currPortalOid).getDataRepositoryOid());
                        }
                        catch (Exception exc) {
                            storeIsActive = true;
                        }
                        if (!storeIsActive) {
                            R01FLog.to((String)LOG_TYPE_ID).warning("El store del portal " + currPortalOid + " ESTA CONGELADO o ha fallado la consulta del store del portal !!!!!!!!!!!!!!!!!!!!!!!!!.");
                            throw new R01MPortalModelException("No se puede acceder al almacenamiento debido a que est\u00e1 congelado!!!!!!!!!!!!!!");
                        }
                        if (DEBUG) {
                            R01FLog.to((String)LOG_TYPE_ID).info("El store del portal " + currPortalOid + " NO est\u00e1 congelado.");
                        }
                        try {
                            if (StringUtils.isEmptyString((String)currPortalOid)) break block17;
                            allPortalsOK.add(currPortalOid);
                            ArrayList<R01MJmsQueueParam> paramList = new ArrayList<R01MJmsQueueParam>();
                            paramList.add(new R01MJmsQueueParam(1, "portalOid", (Object)currPortalOid));
                            R01MJMSUtils.sendJMSMessage((String)"r01RegeneratorPortal", paramList);
                            if (!DEBUG) break block17;
                            R01FLog.to((String)LOG_TYPE_ID).info("Mensaje enviado a r01RegeneratorPortal");
                        }
                        catch (Exception secEx) {
                            allPortalsNotOK.add(currPortalOid);
                            secEx.printStackTrace(System.out);
                            continue;
                        }
                    }
                    result[0].add(allPortalsOK);
                    result[1].add(allPortalsNotOK);
                }
            }
            if (DEBUG) {
                R01FLog.to((String)"r01g.services").info("MODEL SERVER (end) : " + opDesc);
            }
        }
        return result;
    }

    public void doDeleteRegHistoryPortal(String portalOid) throws R01MSecurityException, R01MPortalModelException {
        R01GDAOPortalModelManager porModMan = new R01GDAOPortalModelManager();
        try {
            porModMan.executeDeleteHistoryRegenerationVA(portalOid);
        }
        catch (R01GPortalModelPersistenceException ex) {
            throw new R01MPortalModelException((Exception)((Object)ex));
        }
    }

    public void doInsertRegHistoryPortal(List paramListRVA) throws R01MSecurityException, R01MPortalModelException {
        R01GDAOPortalModelManager porModMan = new R01GDAOPortalModelManager();
        try {
            porModMan.executeInsertHistoryRegenerationVA(paramListRVA);
        }
        catch (R01GPortalModelPersistenceException ex) {
            throw new R01MPortalModelException((Exception)((Object)ex));
        }
    }

    public void doLoadPendingPortal(String portalOid) throws R01MSecurityException, R01MPortalModelException {
        R01GDAOPortalModelManager porModMan = new R01GDAOPortalModelManager();
        try {
            porModMan.executeLoadPendingPortal(portalOid);
        }
        catch (R01GPortalModelPersistenceException ex) {
            throw new R01MPortalModelException((Exception)((Object)ex));
        }
    }

    public R01MOperationInModelObjectResult doRegenerateVA(R01MUserContext userCtx, String portalOid, String visualAreaInstanceOid, boolean bExecuteInmediateRegeneration, boolean bRegenerateOnlyDynamicVAs, String lang) throws R01MSecurityException, R01MPortalModelException {
        R01GVisualAreaCMPValue vaInstanceVO;
        R01MVisualAreaInstance vaInstance;
        super.validateSecurityContext(userCtx, portalOid, 0);
        String opDesc = "Regenerando el area visual > " + visualAreaInstanceOid + " del portal " + portalOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01MOperationInModelObjectResult result = new R01MOperationInModelObjectResult();
        result.setOid(visualAreaInstanceOid);
        result.setObjType(7);
        try {
            vaInstance = R01GVisualAreaBMPUtil.getLocalHome().findByPrimaryKey(visualAreaInstanceOid).getVisualAreaObject();
        }
        catch (FinderException fndEx) {
            result.setOperationOK(false);
            result.setMsg("No se puede cargar el objeto de instancia de Area Visual de oid " + visualAreaInstanceOid + " . Error:" + fndEx.getMessage());
            return result;
        }
        catch (NamingException namEx) {
            result.setOperationOK(false);
            result.setMsg("No se encuentra el home del BMP de instancia de Area Visual. Error:" + namEx.getMessage());
            return result;
        }
        try {
            vaInstanceVO = R01GVisualAreaCMPUtil.getLocalHome().findByPrimaryKey(new R01GVisualAreaCMPPK(visualAreaInstanceOid)).getR01GVisualAreaCMPValue();
        }
        catch (FinderException fndEx) {
            result.setOperationOK(false);
            result.setMsg("No se puede obtener el registro de instancia de Area Visual. Error:" + fndEx.getMessage());
            return result;
        }
        catch (NamingException namEx) {
            result.setOperationOK(false);
            result.setMsg("No se encuentra el home del CMP de instancia de Area Visual. Error:" + namEx.getMessage());
            return result;
        }
        if (this._visualareasConfig == null) {
            try {
                this._visualareasConfig = R01GPortalLoaderFactory.getPortalConfigLoader().loadVisualAreasConfig();
            }
            catch (R01MConfigLoadException ex) {
                result = new R01MOperationInModelObjectResult();
                result.setOperationOK(false);
                result.setMsg("No se puede obtener de la Base de Datos el registro de instancia de Area Visual. Error:" + ex.getMessage());
                return result;
            }
        }
        Map dynamicVAs = this._visualareasConfig.getVisualAreasRegeneration();
        boolean isDynamicVA = false;
        boolean bExecuteRegeneration = true;
        long period = 0L;
        if (dynamicVAs != null && !dynamicVAs.isEmpty() && dynamicVAs.containsKey(vaInstance.getVisualAreaOid())) {
            isDynamicVA = true;
            long lastRegeneration = DateUtils.getDateAsMillis((Date)vaInstanceVO.getLastRegenerationDate());
            long today = DateUtils.getDateAsMillis((Date)R01MDateUtils.today());
            String strPeriod = R01GVAHelpper.getInstanceParamValue((R01MVisualAreaInstance)vaInstance, (String)"all", (String)"timerRefresh");
            if (NumberUtils.isLong((String)strPeriod)) {
                period = Long.parseLong(strPeriod);
            }
            bExecuteRegeneration = false;
            if (bExecuteInmediateRegeneration) {
                bExecuteRegeneration = true;
            } else if (today - lastRegeneration > period) {
                bExecuteRegeneration = true;
            }
        }
        Date lastRegenerationDate = null;
        if (bExecuteRegeneration) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("...regenerando el Area Visual en el storage...");
            }
            R01GVisualAreasAPI visualAreaAPI = new R01GVisualAreasAPI(userCtx);
            boolean isDynamicVAError = false;
            Iterator itLanguages = vaInstance.getLanguages().iterator();
            while (itLanguages.hasNext()) {
                String vaLang = itLanguages.next().toString();
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\t...generando el \u00e1rea visual en el idioma " + vaLang);
                }
                R01GComposeVAResult htmlRenderResult = visualAreaAPI.renderVisualAreaInstance(portalOid, vaLang, vaInstance);
                if (!isDynamicVA || htmlRenderResult.getStateResult() != 2 && htmlRenderResult.getStateResult() != 3) continue;
                isDynamicVAError = true;
            }
            if (isDynamicVAError) {
                result.setOperationOK(false);
                result.setMsg("Error en la regeneraci\u00f3n del Area Visual --- NO SE PUBLICA.");
                return result;
            }
            if (!bRegenerateOnlyDynamicVAs) {
                visualAreaAPI.renderResourcesVisualArea(portalOid, vaInstance);
            }
            Calendar mydate = Calendar.getInstance();
            mydate.setTimeInMillis(R01MDateUtils.today().getTime());
            lastRegenerationDate = mydate.getTime();
            try {
                R01GVisualAreaCMPUtil.getLocalHome().findByPrimaryKey(new R01GVisualAreaCMPPK(visualAreaInstanceOid)).setLastRegenerationDate(lastRegenerationDate);
            }
            catch (FinderException fndEx) {
                result.setOperationOK(false);
                result.setMsg("No se puede obtener el registro de instancia de Area Visual de oid " + visualAreaInstanceOid + " . Error:" + fndEx.getMessage());
                return result;
            }
            catch (NamingException namEx) {
                result.setOperationOK(false);
                result.setMsg("No se encuentra el home del CMP de instancia de Area Visual. Error:" + namEx.getMessage());
                return result;
            }
            if (isDynamicVA) {
                if (this.allDynamicVAsToPublish != null) {
                    this.allDynamicVAsToPublish.add(vaInstance);
                }
                if (bRegenerateOnlyDynamicVAs) {
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).info("...regenerando el Area Visual en el storage...");
                    }
                    try {
                        Map allowedTargets;
                        R01MPublicationConfig pubConfig;
                        R01MPortal portal;
                        try {
                            portal = R01GPortalLoaderFactory.getPortalDataLoader().loadPortal(portalOid);
                        }
                        catch (R01MConfigLoadException cfgEx) {
                            R01FLog.to((String)LOG_TYPE_ID).severe("ADMIN SERVER >> Error al cargar el portal de oid " + portalOid + ". Error:" + cfgEx.getMessage());
                            throw new R01MPublisherException("Error al cargar el portal de oid " + portalOid, (Exception)((Object)cfgEx));
                        }
                        if (DEBUG) {
                            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER >> Portal " + portalOid + " cargado.");
                        }
                        try {
                            pubConfig = R01MClientFactory.getStorageConfigAPI().getWorkAreaConfig(portal.getStoreLocation().getServerOid(), portal.getStoreLocation().getDataRepositoryOid(), portal.getStoreLocation().getAreaOid(), portal.getStoreLocation().getWorkAreaOid()).getAllowedPublicationTargetsConfig();
                        }
                        catch (R01MConfigLoadException clEx) {
                            R01FLog.to((String)LOG_TYPE_ID).severe("ADMIN SERVER >> Error al cargar la configuraci\u00f3n de publicaci\u00f3n para el portal de oid " + portalOid + ". Error:" + clEx.getMessage());
                            throw new R01MPublisherException("Error al cargar la configuraci\u00f3n de publicaci\u00f3n para el portal de oid " + portalOid, (Exception)((Object)clEx));
                        }
                        if (DEBUG) {
                            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER >> Cargada la informaci\u00f3n de configuraci\u00f3n del portal " + portalOid);
                        }
                        if ((allowedTargets = pubConfig.getAllowedTargets()) != null && !allowedTargets.isEmpty()) {
                            for (R01MAllowedPublicationTarget target : allowedTargets.values()) {
                                if (DEBUG) {
                                    R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER >> Mandando la publicaci\u00f3n del AV:  " + vaInstance.getOid() + " en el destino " + target.getTargetOid());
                                }
                                R01PPublishDefinition pubDefinition = new R01PPublishDefinition("Administrator-" + portalOid, vaInstance.getOid(), 7, null, null, null, target.getTargetOid(), 0, null, null, true, null, null);
                                R01PClientFactory.getPublisherAPI().publish(pubDefinition);
                                if (!DEBUG) continue;
                                R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER >> Publicaci\u00f3n del AV " + vaInstance.getOid() + " en el destino " + target.getTargetOid() + " enviada.");
                            }
                        } else if (DEBUG) {
                            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER >> No hay repositorios de publicaci\u00f3n permitidos para el portal:  " + portalOid + " --> " + (allowedTargets == null ? "[NULL]" : "VAC\u00cdO"));
                        }
                    }
                    catch (R01MPublisherException pubExc) {
                        result.setOperationOK(false);
                        result.setMsg("Error en la publicaci\u00f3n del Area Visual. Error:" + pubExc.getMessage());
                        return result;
                    }
                }
            }
        }
        result.setOperationOK(true);
        result.setMsg(R01MDateUtils.dateTimeSecondsToStr((Date)(lastRegenerationDate != null ? lastRegenerationDate : R01MDateUtils.today()), (String)(lang != null ? lang : R01MConstants.DEFAULT_LANG)));
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return result;
    }

    public void doMigrateVisualArea(R01MUserContext userCtx, String portalOid, R01MVisualAreaInstance vaInstance) throws R01MSecurityException, R01MPortalModelException {
        R01GVisualAreaCMPValue visualAreaVO;
        super.validateSecurityContext(userCtx, portalOid, 0);
        String opDesc = "Migrando el area visual > " + vaInstance.getOid() + " del portal " + portalOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        try {
            visualAreaVO = (R01GVisualAreaCMPValue)R01MDozerMappingUtils.map((String)R01MConstants.PORTALMANAGER_APPCODE, (Object)vaInstance, R01GVisualAreaCMPValue.class);
        }
        catch (MappingException mapExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error en el mapeo del objeto de instancia de Area Visual a su Value Object. Error:" + mapExc.getMessage());
            throw new R01MPortalModelException("Error en el mapeo del objeto de instancia de Area Visual de oid " + vaInstance.getOid() + "  a su Value Object.", (Exception)((Object)mapExc));
        }
        visualAreaVO.setPortalOid(portalOid);
        visualAreaVO.setLastModifiedDate(R01MDateUtils.today());
        try {
            visualAreaVO.setXMLInstance(vaInstance.getXML());
        }
        catch (XOMarshallerException xoExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al obtener el XML de definici\u00f3n del Area Visual. Error:" + xoExc.getMessage());
            throw new R01MPortalModelException("Error al obtener el XML de definici\u00f3n del objeto de instancia de Area Visual de oid " + vaInstance.getOid() + "  a su Value Object.", (Exception)((Object)xoExc));
        }
        try {
            R01GVisualAreaCMPUtil.getLocalHome().create(visualAreaVO);
        }
        catch (CreateException crtEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("\r\nError: No se puede crear el Area Visual en Base de Datos.");
            throw new R01MPortalModelException("No se puede crear el Area Visual en Base de Datos. Error: " + crtEx.getMessage(), (Exception)((Object)crtEx));
        }
        catch (NamingException namEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("\r\nError al obtener el interfaz home del CMP de Areas Visuales.");
            throw new R01MPortalModelException("Error al obtener el interfaz home del CMP de Areas Visuales: " + namEx.getMessage(), (Exception)namEx);
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
    }

    private boolean _doCheckPortalExistence(String portalOid) throws R01MPortalModelException {
        String opDesc = "Comprobar la existencia del portal " + portalOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01GEjbPortalModelLoader modelLoader = new R01GEjbPortalModelLoader();
            boolean exist = modelLoader.executeCheckPortalExistence(portalOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc + ".Resultado:" + exist);
            }
            return exist;
        }
        catch (R01GPortalModelPersistenceException cmEx) {
            throw new R01MPortalModelException("Error >>" + opDesc, (Exception)((Object)cmEx));
        }
    }

    private void _doCreatePortal(R01MUserContext userCtx, String portalOid, String portalXML) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "Creando el NUEVO portal " + portalOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        try {
            R01GPortalBMPUtil.getLocalHome().create(userCtx, portalOid, portalXML);
        }
        catch (CreateException crtEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("\r\nError: No se puede crear el Portal y Storage en Base de Datos.");
            throw new R01MPortalModelException("No se puede crear el Portal y Storage en Base de Datos. Error: " + crtEx.getMessage(), (Exception)((Object)crtEx));
        }
        catch (NamingException namEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("\r\nError al obtener el interfaz home del BMP de portales.");
            throw new R01MPortalModelException("Error al obtener el interfaz home del BMP de portales: " + namEx.getMessage(), (Exception)namEx);
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
    }

    private void _doUpdatePortal(R01MUserContext userCtx, String portalOid, String portalXML) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "ACTUALIZANDO el portal " + portalOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        try {
            R01GPortalBMPUtil.getLocalHome().findByPrimaryKey(portalOid).update(userCtx, portalOid, portalXML);
        }
        catch (FinderException fndEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("\r\nError: No se puede encontrar el Portal en Base de Datos.");
            throw new R01MPortalModelException("No se puede encontrar el Portal en Base de Datos. Error: " + fndEx.getMessage(), (Exception)((Object)fndEx));
        }
        catch (NamingException namEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("\r\nError al obtener el interfaz home del BMP de portales.");
            throw new R01MPortalModelException("Error al obtener el interfaz home del BMP de portales: " + namEx.getMessage(), (Exception)namEx);
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
    }

    private void _doDeletePortal(String portalOid) throws R01MPortalModelException {
        String opDesc = "BORRANDO el portal " + portalOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        try {
            R01GPortalBMPUtil.getLocalHome().findByPrimaryKey(portalOid).remove();
        }
        catch (FinderException fndEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("\r\nError: No se puede encontrar el Portal en Base de Datos.");
            throw new R01MPortalModelException("No se puede encontrar el Portal en Base de Datos.Error: " + fndEx.getMessage(), (Exception)((Object)fndEx));
        }
        catch (NamingException namEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("\r\nError al obtener el interfaz home del BMP de portales.");
            throw new R01MPortalModelException("Error al obtener el interfaz home del BMP de portales.Error: " + namEx.getMessage(), (Exception)namEx);
        }
        catch (EJBException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("\r\nError en el borrado del portal " + portalOid + ".");
            throw new R01MPortalModelException("Error en el borrado del portal " + portalOid + ".Error:" + ex.getMessage(), (Exception)((Object)ex));
        }
        catch (RemoveException rmExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("\r\nEl portal " + portalOid + " no se puede borrar.");
            throw new R01MPortalModelException("El portal " + portalOid + " no se puede borrar.Error:" + rmExc.getMessage(), (Exception)((Object)rmExc));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
    }

    private void _doRegenerateDefaultNavigator(R01MUserContext userCtx, R01MPortal portal) throws R01MPortalModelException {
        String opDesc = "Regenerando el fichero defaultNavigator del portal " + portal.getOid();
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        if (portal.getDefaultNavigators() != null) {
            InputStream defaultNavigatorIS;
            StringBuffer defaultNavigatorFileText = new StringBuffer(286);
            defaultNavigatorFileText.append("<!-- Establecimiento de las migas de pan por defecto -->\n<!-- ############################################### -->\n\n<!-- Si se accede a una pagina de categoria superior a 1 y no existen cookies que \n     indiquen una navegacion previa por el portal, se establecen las siguientes migas de pan: -->\n\n");
            R01GCommonPortalInDataStore commonDatastore = new R01GCommonPortalInDataStore(userCtx);
            try {
                defaultNavigatorIS = commonDatastore.downloadDefaultNavigatorSection();
            }
            catch (R01MDataStoreException dsEx) {
                throw new R01MPortalModelException("Error en download de la plantilla de reglas para el establecimiento de migas de pan din\u00e1micas del portal " + portal.getOid() + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
            }
            String languageDependantSectionString = "";
            try {
                languageDependantSectionString = StringUtils.loadFromStream((InputStream)defaultNavigatorIS);
                if (languageDependantSectionString == null) {
                    languageDependantSectionString = "";
                }
            }
            catch (IOException ex) {
                throw new R01MPortalModelException("Error al obtener el valor en texto de la plantilla de reglas para el establecimiento de migas de pan din\u00e1micas del portal " + portal.getOid() + ": " + ex.getMessage(), (Exception)ex);
            }
            boolean hasDefaultNavigators = false;
            for (Map.Entry defaultNavigatorEntry : portal.getDefaultNavigators().entrySet()) {
                String key = (String)defaultNavigatorEntry.getKey();
                String[] keyParts = key.split("_");
                String level = keyParts[1];
                String language = keyParts[0];
                String value = (String)defaultNavigatorEntry.getValue();
                String[] valueParts = value.split("##");
                String title = valueParts[0];
                String url = valueParts[1];
                HashMap<String, String> varValuesBase = new HashMap<String, String>();
                varValuesBase.put("level", level);
                varValuesBase.put("language", language);
                varValuesBase.put("title", title);
                varValuesBase.put("url", url);
                defaultNavigatorFileText.append("\n").append(StringUtils.replaceVariableValues((String)languageDependantSectionString, (String)"$", varValuesBase));
                hasDefaultNavigators = true;
            }
            if (hasDefaultNavigators) {
                R01MPublicationConfig pubConfig;
                ByteArrayInputStream composedDefaultNavigatorIS = new ByteArrayInputStream(defaultNavigatorFileText.toString().getBytes());
                R01GPortalInDataStore portalDatastore = new R01GPortalInDataStore(userCtx, portal);
                String portalDefaultNavigatorFileName = R01GConstants.DEFAULT_NAVIGATOR_FILENAME;
                try {
                    portalDatastore.uploadAndSubmitFileInPortalRootPath(portalDefaultNavigatorFileName, (InputStream)composedDefaultNavigatorIS);
                }
                catch (R01MDataStoreException ex) {
                    throw new R01MPortalModelException("Error al subir el fichero de migas de pan por defecto del portal: " + portal.getOid() + " " + portalDefaultNavigatorFileName + ": " + ex.toString(), (Exception)((Object)ex));
                }
                try {
                    pubConfig = R01MClientFactory.getStorageConfigAPI().getWorkAreaConfig(portal.getStoreLocation().getServerOid(), portal.getStoreLocation().getDataRepositoryOid(), portal.getStoreLocation().getAreaOid(), portal.getStoreLocation().getWorkAreaOid()).getAllowedPublicationTargetsConfig();
                }
                catch (R01MConfigLoadException cfgExc) {
                    throw new R01MPortalModelException("Error al cargar la configuraci\u00f3n de publicaci\u00f3n del portal " + portal.getOid() + ": " + cfgExc.toString(), (Exception)((Object)cfgExc));
                }
                Map targets = pubConfig.getAllowedTargets();
                for (String repository : targets.keySet()) {
                    R01MPortalPublicationRequested petPub = new R01MPortalPublicationRequested();
                    petPub.setRepositoryOid(repository);
                    try {
                        List<String> resouscesPath = Arrays.asList(portalDefaultNavigatorFileName);
                        R01PPublishDefinition pubDefinition = new R01PPublishDefinition(userCtx.getUserName(), portal.getOid(), 12, null, portalDefaultNavigatorFileName, resouscesPath, petPub.getRepositoryOid(), petPub.getOperationType(), petPub.getOperationDate(), null, true, null, null);
                        R01PClientFactory.getPublisherAPI().publish(pubDefinition);
                    }
                    catch (R01MPublisherException pubExc) {
                        R01MOperationInModelObjectResult publicationResult = new R01MOperationInModelObjectResult();
                        publicationResult.setOperationOK(false);
                        publicationResult.setMsg("Error en la publicaci\u00f3n de recursos comunes. Error:" + pubExc.getMessage());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _doRegenerateHtaccess(R01MUserContext userCtx, R01MPortal portal) throws R01MPortalModelException {
        block55: {
            R01MPublicationConfig pubConfig;
            block54: {
                R01MPublicationConfig pubConfig2;
                String opDesc = "Regenerando el fichero .htaccess del portal " + portal.getOid();
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
                }
                if (portal.getRedirectionType() == null || !portal.getRedirectionType().equalsIgnoreCase(HTACCESS_REDIRECTION_TYPE)) break block54;
                StringBuilder htaccessFileText = new StringBuilder(286);
                boolean htaccessHasData = false;
                R01GCommonPortalInDataStore commonDatastore = new R01GCommonPortalInDataStore(userCtx);
                try {
                    InputStream portalHtaccessIS = commonDatastore.downloadPortalHtaccess();
                    try {
                        htaccessFileText.append(StringUtils.loadFromStream((InputStream)portalHtaccessIS));
                    }
                    finally {
                        if (Collections.singletonList(portalHtaccessIS).get(0) != null) {
                            portalHtaccessIS.close();
                        }
                    }
                }
                catch (R01MDataStoreException dsEx) {
                    throw new R01MPortalModelException("Error en download de la plantilla global para la generacion del htaccess del portal " + portal.getOid() + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
                }
                catch (IOException ex) {
                    throw new R01MPortalModelException("Error al obtener el valor en texto de la plantilla de reglas generales para la generacion del htaccess del portal " + portal.getOid() + ": " + ex.getMessage(), (Exception)ex);
                }
                HashMap<String, String> varValuesBase = new HashMap<String, String>();
                if (portal.getPreHomeRedirect() != null) {
                    String languageDependantSectionString = "";
                    try {
                        InputStream languageDependantSectionIS = commonDatastore.downloadLanguageDependantPortalHtaccessSection();
                        try {
                            languageDependantSectionString = StringUtils.loadFromStream((InputStream)languageDependantSectionIS);
                            if (languageDependantSectionString == null) {
                                languageDependantSectionString = "";
                            }
                        }
                        finally {
                            if (Collections.singletonList(languageDependantSectionIS).get(0) != null) {
                                languageDependantSectionIS.close();
                            }
                        }
                    }
                    catch (R01MDataStoreException dsEx) {
                        throw new R01MPortalModelException("Error en download de la plantilla de reglas dependientes del lenguaje para la generacion del htaccess del portal " + portal.getOid() + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
                    }
                    catch (IOException ex) {
                        throw new R01MPortalModelException("Error al obtener el valor en texto de la plantilla de reglas dependientes del lenguaje para la generacion del htaccess del portal " + portal.getOid() + ": " + ex.getMessage(), (Exception)ex);
                    }
                    if (!portal.getPreHomeRedirect().isEmpty()) {
                        htaccessHasData = true;
                    }
                    for (Map.Entry entry : portal.getPreHomeRedirect().entrySet()) {
                        if (StringUtils.isEmptyString((String)((String)entry.getValue()))) continue;
                        if (((String)entry.getValue()).startsWith("fullUri:")) {
                            varValuesBase.put("language", "");
                            varValuesBase.put("languageCond", entry.getKey().toString());
                            varValuesBase.put("languagePageRedirect", this._putFinalSlash((String)entry.getValue()).substring("fullUri:".length()));
                        } else {
                            varValuesBase.put("language", "/" + this._putFinalSlash((String)entry.getKey()));
                            varValuesBase.put("languageCond", entry.getKey().toString());
                            varValuesBase.put("languagePageRedirect", (String)entry.getValue());
                        }
                        htaccessFileText.append(StringUtils.replaceVariableValues((String)languageDependantSectionString, (String)"$", varValuesBase));
                    }
                }
                if (!StringUtils.isEmptyString((String)portal.getPortalPreHome())) {
                    String defaultSectionString = "";
                    try {
                        InputStream defaultSectionIS = commonDatastore.downloadDefaultPortalHtaccessSection();
                        try {
                            defaultSectionString = StringUtils.loadFromStream((InputStream)defaultSectionIS);
                            if (defaultSectionString == null) {
                                defaultSectionString = "";
                            }
                        }
                        finally {
                            if (Collections.singletonList(defaultSectionIS).get(0) != null) {
                                defaultSectionIS.close();
                            }
                        }
                    }
                    catch (R01MDataStoreException dsEx) {
                        throw new R01MPortalModelException("Error en download de la plantilla de reglas de redireccion por defecto para la generacion del htaccess del portal " + portal.getOid() + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
                    }
                    catch (IOException ex) {
                        throw new R01MPortalModelException("Error al obtener el valor en texto de la plantilla de reglas de redirecci\u00f3n por defecto para la generacion del htaccess del portal " + portal.getOid() + ": " + ex.getMessage(), (Exception)ex);
                    }
                    varValuesBase.put("defaultPageRedirect", this._putFinalSlash(portal.getPortalPreHome()));
                    htaccessFileText.append("\n");
                    htaccessFileText.append(StringUtils.replaceVariableValues((String)defaultSectionString, (String)"$", varValuesBase));
                    if (!htaccessHasData) {
                        htaccessHasData = true;
                    }
                }
                if (!htaccessHasData) break block55;
                R01GPortalInDataStore portalDatastore = new R01GPortalInDataStore(userCtx, portal);
                String portalRedirectFileName = R01GConstants.HTACCESS_REDIRECTIONS_FILENAME;
                try {
                    ByteArrayInputStream htaccessIS = new ByteArrayInputStream(htaccessFileText.toString().getBytes());
                    try {
                        portalDatastore.uploadAndSubmitFileInPortalRootPath(portalRedirectFileName, (InputStream)htaccessIS);
                    }
                    finally {
                        if (Collections.singletonList(htaccessIS).get(0) != null) {
                            ((InputStream)htaccessIS).close();
                        }
                    }
                }
                catch (R01MDataStoreException ex) {
                    throw new R01MPortalModelException("Error al subir el fichero de redirecciones del portal " + portal.getOid() + " " + portalRedirectFileName + ": " + ex.toString(), (Exception)((Object)ex));
                }
                catch (IOException ex) {
                    throw new R01MPortalModelException("Error al subir el fichero de redirecciones del portal " + portal.getOid() + " " + portalRedirectFileName + ": " + ex.toString(), (Exception)ex);
                }
                try {
                    pubConfig2 = R01MClientFactory.getStorageConfigAPI().getWorkAreaConfig(portal.getStoreLocation().getServerOid(), portal.getStoreLocation().getDataRepositoryOid(), portal.getStoreLocation().getAreaOid(), portal.getStoreLocation().getWorkAreaOid()).getAllowedPublicationTargetsConfig();
                }
                catch (R01MConfigLoadException cfgExc) {
                    throw new R01MPortalModelException("Error al cargar la configuraci\u00f3n de publicaci\u00f3n del portal " + portal.getOid() + ": " + cfgExc.toString(), (Exception)((Object)cfgExc));
                }
                Map targets = pubConfig2.getAllowedTargets();
                for (String repository : targets.keySet()) {
                    R01MPortalPublicationRequested petPub = new R01MPortalPublicationRequested();
                    petPub.setRepositoryOid(repository);
                    try {
                        List<String> resouscesPath = Arrays.asList(portalRedirectFileName);
                        R01PPublishDefinition pubDefinition = new R01PPublishDefinition(userCtx.getUserName(), portal.getOid(), 12, null, portalRedirectFileName, resouscesPath, petPub.getRepositoryOid(), petPub.getOperationType(), petPub.getOperationDate(), null, true, null, null);
                        R01PClientFactory.getPublisherAPI().publish(pubDefinition);
                    }
                    catch (R01MPublisherException pubExc) {
                        R01MOperationInModelObjectResult publicationResult = new R01MOperationInModelObjectResult();
                        publicationResult.setOperationOK(false);
                        publicationResult.setMsg("Error en la publicaci\u00f3n de recursos comunes. Error:" + pubExc.getMessage());
                    }
                }
                break block55;
            }
            R01GPortalInDataStore portalDatastore = new R01GPortalInDataStore(userCtx, portal);
            String htaccessFileName = R01GConstants.HTACCESS_REDIRECTIONS_FILENAME;
            try {
                String htaccessPath = R01MPathHelpper.getPortalResourceWorkAreaRelativePath((String)portal.getOid(), (int)6, (String)("/" + htaccessFileName));
                portalDatastore.deleteResource(htaccessPath);
            }
            catch (R01MDataStoreException ex) {
                throw new R01MPortalModelException("Error al subir el fichero de redirecciones del portal " + portal.getOid() + " " + htaccessFileName + ": " + ex.toString(), (Exception)((Object)ex));
            }
            try {
                pubConfig = R01MClientFactory.getStorageConfigAPI().getWorkAreaConfig(portal.getStoreLocation().getServerOid(), portal.getStoreLocation().getDataRepositoryOid(), portal.getStoreLocation().getAreaOid(), portal.getStoreLocation().getWorkAreaOid()).getAllowedPublicationTargetsConfig();
            }
            catch (R01MConfigLoadException cfgExc) {
                throw new R01MPortalModelException("Error al cargar la configuraci\u00f3n de publicaci\u00f3n del portal " + portal.getOid() + ": " + cfgExc.toString(), (Exception)((Object)cfgExc));
            }
            Map targets = pubConfig.getAllowedTargets();
            for (String repository : targets.keySet()) {
                R01MPortalPublicationRequested petPub = new R01MPortalPublicationRequested();
                petPub.setRepositoryOid(repository);
                try {
                    List<String> resouscesPath = Arrays.asList(htaccessFileName);
                    R01PPublishDefinition pubDefinition = new R01PPublishDefinition(userCtx.getUserName(), portal.getOid(), 12, null, htaccessFileName, resouscesPath, petPub.getRepositoryOid(), petPub.getOperationType(), petPub.getOperationDate(), null, true, null, null);
                    R01PClientFactory.getPublisherAPI().publish(pubDefinition);
                }
                catch (R01MPublisherException pubExc) {
                    R01MOperationInModelObjectResult publicationResult = new R01MOperationInModelObjectResult();
                    publicationResult.setOperationOK(false);
                    publicationResult.setMsg("Error en la publicaci\u00f3n de recursos comunes. Error:" + pubExc.getMessage());
                }
            }
        }
    }

    private void _doRegeneratePortalCookies(R01MUserContext userCtx) throws R01MPortalModelException {
        List portalList;
        String opDesc = "Regenerando el fichero de las cookies de todos los portales.";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        StringBuffer portalCookiesJS = new StringBuffer(68);
        portalCookiesJS.append("var r01PortalPagesInfoArray = new Array();\n");
        R01GDAOPortalModelLoader dataLoader = new R01GDAOPortalModelLoader();
        try {
            portalList = dataLoader.executeLoadPortalOids();
        }
        catch (R01GPortalModelPersistenceException pmExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error en la carga de los identificadores de portales para la creaci\u00f3n del fichero de cookies de portal.Error:" + pmExc.getMessage());
            throw new R01MPortalModelException("Error en la carga de los identificadores de portales para la creaci\u00f3n del fichero de cookies de portal.", (Exception)((Object)pmExc));
        }
        R01MPortal portal = null;
        String portalOid2 = null;
        R01GEjbPortalModelLoader portalLoader = new R01GEjbPortalModelLoader();
        int index = 0;
        for (String portalOid2 : portalList) {
            try {
                portal = portalLoader.executeLoadPortal(portalOid2);
            }
            catch (R01GPortalModelPersistenceException pmExc) {
                R01FLog.to((String)LOG_TYPE_ID).severe("Error en la carga del portal " + portalOid2 + " para la creaci\u00f3n del fichero de cookies de portal.Error:" + pmExc.getMessage());
                continue;
            }
            String newLangPages = "";
            String coma = "";
            Map.Entry meHomeRedirect2 = null;
            if (portal == null || portal.getPreHomeRedirect() == null) continue;
            for (Map.Entry meHomeRedirect2 : portal.getPreHomeRedirect().entrySet()) {
                String newLang = (String)meHomeRedirect2.getKey();
                String newLangPage = (String)meHomeRedirect2.getValue();
                newLangPages = newLangPages + coma + newLang + "=" + newLangPage;
                if (coma.length() != 0) continue;
                coma = ",";
            }
            portalCookiesJS.append("r01PortalPagesInfoArray[" + Integer.toString(index) + "]" + " = new r01PortalInfo(\"" + portal.getOid() + "\"" + ",\"" + (portal.getAllPortalDomain() != null ? portal.getAllPortalDomain() : "") + "\"" + "," + Boolean.toString(portal.isMainDomain()) + "" + "," + Boolean.toString(portal.isReuseCookie()) + "" + ",\"" + (portal.getPortalPreHome() != null ? portal.getPortalPreHome() : "") + "\"" + ",\"" + (newLangPages != null ? newLangPages : "") + "\"" + ",\"" + (portal.getPageContentPreview() != null ? portal.getPageContentPreview() : "") + "\"" + ",\"" + (portal.getUrlContentError() != null ? portal.getUrlContentError() : "") + "\"" + ",\"" + (portal.getUrlPageError() != null ? portal.getUrlPageError() : "") + "\"" + ",\"" + (portal.getUrlVAError() != null ? portal.getUrlVAError() : "") + "\");\n");
            ++index;
        }
        byte[] portalCooliesByte = portalCookiesJS.toString().getBytes();
        ByteArrayInputStream portalCookiesArrayIS = new ByteArrayInputStream(portalCooliesByte);
        R01GCommonPortalInDataStore common = new R01GCommonPortalInDataStore(userCtx);
        try {
            R01MPortalLocation loc = new R01MPortalLocation(R01GProperties.SYSTEMSERVER_CONFIGS_LOCATION, R01GProperties.SYSTEMDATASTORE_CONFIGS_LOCATION, R01GProperties.SYSTEMAREA_CONFIGS_LOCATION, R01GProperties.SYSTEMWORKAREA_CONFIGS_LOCATION);
            common.uploadPortalScriptResource("r01portalCookies.js", (InputStream)portalCookiesArrayIS, (R01MBaseLocationObject)loc);
            common.consolidatePortalScriptResource("r01portalCookies.js");
            try {
                List targets = XMLProperties.getPropertyList((String)R01GProperties.applicationCode, (String)"system/publicationConfig/allowedTargets/allowedTarget");
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER >> Obtenidos los destinos de publicaci\u00f3n permitidos para las publicaciones de recursos del sistema\n(indicados en el properties de R01G: system/publicationConfig/allowedTargets/allowedTarget):\n" + (targets == null ? "[null]" : targets.toString()));
                }
                if (targets != null && !targets.isEmpty()) {
                    ArrayList<String> resourcesPaths = new ArrayList<String>();
                    resourcesPaths.add(SCRIPT_RESOURCES_LOCATION);
                    for (String currTargetOid : targets) {
                        if (DEBUG) {
                            R01FLog.to((String)LOG_TYPE_ID).info("R01GPublisherManager.publishSystemResources >> Mandando la publicaci\u00f3n para el destino: " + currTargetOid);
                        }
                        R01PPublishDefinition pubDefinition = new R01PPublishDefinition(userCtx.getUserName(), null, 13, null, "r01portalCookies.js", resourcesPaths, currTargetOid, 0, null, null, true, null, null);
                        R01PClientFactory.getPublisherAPI().publish(pubDefinition);
                        if (!DEBUG) continue;
                        R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER >> Publicaci\u00f3n en el destino: " + currTargetOid + " enviada");
                    }
                }
            }
            catch (R01MPublisherException pubExc) {
                R01MOperationInModelObjectResult publicationResult = new R01MOperationInModelObjectResult();
                publicationResult.setOperationOK(false);
                publicationResult.setMsg("Error en la publicaci\u00f3n de recursos comunes. Error:" + pubExc.getMessage());
            }
        }
        catch (R01MDataStoreException dsExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error en la actualizaci\u00f3n del recurso r01portalCookies.js.Error:" + dsExc.getMessage());
            throw new R01MPortalModelException("Error en la actualizaci\u00f3n del recurso r01portalCookies.js en el datastore.", (Exception)((Object)dsExc));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
    }

    private void _doRegeneratePageTracking(R01MUserContext userCtx, R01MPortal portal) throws R01MPortalModelException {
        R01MPublicationConfig pubConfig;
        InputStream pageTrackingIS;
        String pagetrackingString = "";
        if (portal.getAnalytics() != null && portal.getAnalytics().isActivate()) {
            R01GCommonPortalInDataStore commonDatastore = new R01GCommonPortalInDataStore(userCtx);
            try {
                pageTrackingIS = commonDatastore.downloadPageTrackingScript();
            }
            catch (R01MDataStoreException dsEx) {
                throw new R01MPortalModelException("Error en download del script r01PortalTracking.html", (Exception)((Object)dsEx));
            }
            try {
                pagetrackingString = StringUtils.loadFromStream((InputStream)pageTrackingIS);
                if (pagetrackingString == null) {
                    pagetrackingString = "";
                }
            }
            catch (IOException ex) {
                throw new R01MPortalModelException("Error al obtener el InputStream del script r01PortalTracking.html a String: " + ex.toString(), (Exception)ex);
            }
            HashMap<String, String> varValuesBase = new HashMap<String, String>();
            if (portal.getAnalytics() != null) {
                if (!StringUtils.isEmptyString((String)portal.getAnalytics().getGaDomainName())) {
                    StringBuffer gaCode = new StringBuffer(77);
                    gaCode.append("_gaq.push(['_setDomainName', '");
                    gaCode.append(portal.getAnalytics().getGaDomainName());
                    gaCode.append("']);\n\t _gaq.push(['_setAllowLinker', true]);\n\t _gaq.push(['_setAllowHash', false]);");
                    varValuesBase.put("gaDomainName", gaCode.toString());
                } else {
                    varValuesBase.put("gaDomainName", "");
                }
                varValuesBase.put("tracking-code", portal.getAnalytics().getTrackingCode());
            } else {
                varValuesBase.put("tracking-code", "");
                varValuesBase.put("gaDomainName", "");
            }
            pagetrackingString = StringUtils.replaceVariableValues((String)pagetrackingString, (String)"$", varValuesBase);
        } else {
            pagetrackingString = "<!-- ANAL\u00cdTICAS WEB DESACTIVADAS -->";
        }
        pageTrackingIS = new ByteArrayInputStream(pagetrackingString.getBytes());
        R01GPortalInDataStore portalDatastore = new R01GPortalInDataStore(userCtx, portal);
        String pageTrackingName = portal.getOid() + "-" + R01GConstants.PORTAL_ANALYTICS_FILENAME;
        try {
            portalDatastore.uploadAndSubmitFileInPortalRootPath(pageTrackingName, pageTrackingIS);
        }
        catch (R01MDataStoreException ex) {
            throw new R01MPortalModelException("Error al subir el fichero del script " + portal.getOid() + "-analytics.html: " + ex.toString(), (Exception)((Object)ex));
        }
        try {
            pubConfig = R01MClientFactory.getStorageConfigAPI().getWorkAreaConfig(portal.getStoreLocation().getServerOid(), portal.getStoreLocation().getDataRepositoryOid(), portal.getStoreLocation().getAreaOid(), portal.getStoreLocation().getWorkAreaOid()).getAllowedPublicationTargetsConfig();
        }
        catch (R01MConfigLoadException cfgExc) {
            throw new R01MPortalModelException("Error al cargar la configuraci\u00f3n de publicaci\u00f3n del portal " + portal.getOid() + ": " + cfgExc.toString(), (Exception)((Object)cfgExc));
        }
        Map targets = pubConfig.getAllowedTargets();
        for (String repository : targets.keySet()) {
            R01MPortalPublicationRequested petPub = new R01MPortalPublicationRequested();
            petPub.setRepositoryOid(repository);
            try {
                List<String> resouscesPath = Arrays.asList(pageTrackingName);
                R01PPublishDefinition pubDefinition = new R01PPublishDefinition(userCtx.getUserName(), portal.getOid(), 12, null, pageTrackingName, resouscesPath, petPub.getRepositoryOid(), petPub.getOperationType(), petPub.getOperationDate(), null, true, null, null);
                R01PClientFactory.getPublisherAPI().publish(pubDefinition);
            }
            catch (R01MPublisherException pubExc) {
                R01MOperationInModelObjectResult publicationResult = new R01MOperationInModelObjectResult();
                publicationResult.setOperationOK(false);
                publicationResult.setMsg("Error en la publicaci\u00f3n de recursos comunes. Error:" + pubExc.getMessage());
            }
        }
    }

    private String _putFinalSlash(String url) {
        if (url != null && !url.endsWith("/")) {
            return new String(url).concat("/");
        }
        return url;
    }
}

