/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01g.services;

import com.ejie.r01f.clone.CloneUtils;
import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01g.api.R01GPagesAPI;
import com.ejie.r01g.config.loaders.R01GPortalLoaderFactory;
import com.ejie.r01g.datastore.R01GPortalInDataStore;
import com.ejie.r01g.exceptions.R01GPortalModelPersistenceException;
import com.ejie.r01g.gestorportal.dbhelppers.dao.R01GDAOPortalModelLoader;
import com.ejie.r01g.gestorportal.ejb.page.R01GPageBMPUtil;
import com.ejie.r01g.gestorportal.ejb.page.R01GPageCMPLocal;
import com.ejie.r01g.gestorportal.ejb.page.R01GPageCMPPK;
import com.ejie.r01g.gestorportal.ejb.page.R01GPageCMPUtil;
import com.ejie.r01g.gestorportal.ejb.repopubli.R01GRepoPubPagePortalCMPLocal;
import com.ejie.r01g.gestorportal.ejb.repopubli.R01GRepoPubPagePortalCMPUtil;
import com.ejie.r01g.gestorportal.ejb.repopubli.R01GRepoPubPagePortalCMPValue;
import com.ejie.r01g.services.R01GBasePortalManager;
import com.ejie.r01g.services.R01GHistoryHelper;
import com.ejie.r01g.services.R01GPublisherManager;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MCatalogException;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MDataStoreException;
import com.ejie.r01m.exceptions.R01MDeletePageException;
import com.ejie.r01m.exceptions.R01MDuplicatePageException;
import com.ejie.r01m.exceptions.R01MJMSException;
import com.ejie.r01m.exceptions.R01MPortalModelException;
import com.ejie.r01m.exceptions.R01MPortalModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MPublisherException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.R01MBasePublicationRequested;
import com.ejie.r01m.objects.cataloguing.R01MStructureCatalog;
import com.ejie.r01m.objects.cataloguing.picks.R01MGeoPick;
import com.ejie.r01m.objects.cataloguing.picks.R01MGeoPicks;
import com.ejie.r01m.objects.cataloguing.structures.R01MLabel;
import com.ejie.r01m.objects.portalmodel.R01MPage;
import com.ejie.r01m.objects.portalmodel.R01MPageVAInclude;
import com.ejie.r01m.objects.portalmodel.R01MPortal;
import com.ejie.r01m.objects.portalmodel.R01MPortalPublicationRequested;
import com.ejie.r01m.objects.portalmodel.R01MPortalPublicationTarget;
import com.ejie.r01m.objects.publisher.R01MPublish;
import com.ejie.r01m.objects.publisher.R01MPublishActionObject;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MPublisherAPI;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import com.ejie.r01m.utils.jms.R01MJMSUtils;
import com.ejie.r01m.utils.jms.R01MJmsQueueParam;
import com.ejie.r01m.utils.portal.R01MPortalPathHelpper;
import com.ejie.r01p.objects.publisher.R01PPublishDefinition;
import com.ejie.r01p.services.R01PClientFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

public class R01GPageAdminManager
extends R01GBasePortalManager {
    private static final String LOG_TYPE_ID = "r01g.pageManager";
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01g.pageManager").intValue() != Level.OFF.intValue();
    private transient R01MUserContext _userCtx;

    public R01GPageAdminManager(R01MUserContext userCtx) {
        this._userCtx = userCtx;
    }

    public Map<String, R01MPageVAInclude> doCreatePage(R01MPage page) throws R01MPortalModelException, R01MSecurityException, R01MDuplicatePageException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("PAGEMANAGER > Creando la p\u00e1gina de oid " + page.getOid() + " para el portal " + page.getPortalOid());
        }
        if (this._validatePageInternalName(page.getPortalOid(), page.getInternalName())) {
            throw new R01MDuplicatePageException("Ya existe una p\u00e1gina con el nombre interno " + page.getInternalName());
        }
        try {
            R01GPageBMPUtil.getLocalHome().create(this._userCtx, page);
        }
        catch (R01MPortalModelException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("PAGEMANAGER (" + page.getOid() + ") > Error al crear la p\u00e1gina.");
            throw new R01MPortalModelException("Error al crear la p\u00e1gina de oid " + page.getOid() + ". Error: " + ex.getMessage(), (Exception)((Object)ex));
        }
        catch (CreateException crtEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("PAGEMANAGER (" + page.getOid() + ") > No se puede crear la p\u00e1gina.");
            throw new R01MPortalModelException("No se puede crear la p\u00e1gina de oid " + page.getOid() + ". Error: " + crtEx.getMessage(), (Exception)((Object)crtEx));
        }
        catch (NamingException namEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("PAGEMANAGER (" + page.getOid() + ") > Error al obtener el interfaz home del BMP de p\u00e1gina de portal.");
            throw new R01MPortalModelException("Error al obtener el interfaz home del BMP de p\u00e1gina de portal: " + namEx.getMessage(), (Exception)namEx);
        }
        catch (R01MSecurityException secExc) {
            throw secExc;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
            throw new R01MPortalModelException("Error desconocido: " + ex.getMessage(), ex);
        }
        StringBuffer msg = new StringBuffer(50);
        msg.append("Portal:");
        msg.append(page.getPortalOid());
        msg.append(" ,Nombre :");
        msg.append(page.getInternalName());
        msg.append(" - ");
        msg.append(page.getName());
        R01GHistoryHelper.doInsertHistoryRecord(this._userCtx, page.getOid(), "", page.getInternalName(), 1, 1, msg);
        return page.getVisualAreas();
    }

    public R01MPage doLoadPage(String pageOid) throws R01MPortalModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("PAGEMANAGER > Cargando la p\u00e1gina de oid " + pageOid);
        }
        try {
            return R01GPageBMPUtil.getLocalHome().findByPrimaryKey(pageOid).getPageObject();
        }
        catch (FinderException fndEx) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("PAGEMANAGER (" + pageOid + ") > La p\u00e1gina no existe.");
            }
            return null;
        }
        catch (NamingException namEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("PAGEMANAGER (" + pageOid + ") > Error al obtener el interfaz home del CMP de p\u00e1gina de portal.");
            throw new R01MPortalModelException("Error al obtener el interfaz home del CMP de p\u00e1gina de portal. Error: " + namEx.getMessage(), (Exception)namEx);
        }
    }

    public String doGetPageInternalName(String pageOid) throws R01MPortalModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("PAGEMANAGER > Cargando el nombre interno de la p\u00e1gina de oid " + pageOid);
        }
        try {
            return R01GPageCMPUtil.getLocalHome().findByPrimaryKey(new R01GPageCMPPK(pageOid)).getInternalName();
        }
        catch (FinderException fndEx) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("PAGEMANAGER (" + pageOid + ") > La p\u00e1gina no existe.");
            }
            return null;
        }
        catch (NamingException namEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("PAGEMANAGER (" + pageOid + ") > Error al obtener el interfaz home del CMP de p\u00e1gina de portal.");
            throw new R01MPortalModelException("Error al obtener el interfaz home del CMP de p\u00e1gina de portal. Error: " + namEx.getMessage(), (Exception)namEx);
        }
    }

    public Map doLoadPageVADescriptions(String pageOid) throws R01MPortalModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("PAGEMANAGER > Cargando las descripciones de las VAs de la p\u00e1gina de oid " + pageOid);
        }
        R01GDAOPortalModelLoader service = new R01GDAOPortalModelLoader();
        try {
            return service.executeLoadPageVADescriptions(pageOid);
        }
        catch (R01GPortalModelPersistenceException ex) {
            throw new R01MPortalModelException("Error en la validaci\u00f3n del nombre interno de la p\u00e1gina.", (Exception)((Object)ex));
        }
    }

    public Map<String, R01MPageVAInclude> doUpdatePage(R01MPage page, boolean sassCompile) throws R01MSecurityException, R01MPortalModelException, R01MPortalModelObjectsValidatorException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("PAGEMANAGER > Actualizando la p\u00e1gina de oid " + page.getOid() + " para el portal " + page.getPortalOid());
        }
        page.validateObject();
        try {
            R01GPageBMPUtil.getLocalHome().findByPrimaryKey(page.getOid()).update(this._userCtx, page, sassCompile);
        }
        catch (FinderException fndEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("PAGEMANAGER (" + page.getOid() + ") > No se puede encontrar la p\u00e1gina.");
            throw new R01MPortalModelException("No se puede encontrar la p\u00e1gina de oid " + page.getOid() + ". Error: " + fndEx.getMessage(), (Exception)((Object)fndEx));
        }
        catch (R01MPortalModelException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("PAGEMANAGER (" + page.getOid() + ") > Error al crear la p\u00e1gina.");
            throw new R01MPortalModelException("Error al crear la p\u00e1gina de oid " + page.getOid() + ". Error: " + ex.getMessage(), (Exception)((Object)ex));
        }
        catch (NamingException namEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("PAGEMANAGER (" + page.getOid() + ") > Error al obtener el interfaz home del BMP de p\u00e1gina de portal.");
            throw new R01MPortalModelException("Error al obtener el interfaz home del BMP de p\u00e1gina de portal: " + namEx.getMessage(), (Exception)namEx);
        }
        try {
            this._sendAliasStructureUpdateMessage(page.getOid());
        }
        catch (R01MJMSException ex) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tERROR al enviar el mensaje de creaci\u00f3n de estructura de aliases");
        }
        StringBuffer msg = new StringBuffer(50);
        msg.append("Portal:");
        msg.append(page.getPortalOid());
        msg.append(" ,Nombre interno:");
        msg.append(page.getName());
        R01GHistoryHelper.doInsertHistoryRecord(this._userCtx, page.getOid(), "", page.getInternalName(), 1, 2, msg);
        return page.getVisualAreas();
    }

    public void doDeletePage(String pageOid) throws R01MSecurityException, R01MPortalModelException, R01MDeletePageException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("PAGEMANAGER > Borrando la p\u00e1gina de oid " + pageOid);
        }
        if (this._validatePageForDeletion(pageOid)) {
            try {
                R01GPageBMPUtil.getLocalHome().findByPrimaryKey(pageOid).delete(this._userCtx);
            }
            catch (FinderException fndEx) {
                R01FLog.to((String)LOG_TYPE_ID).severe("PAGEMANAGER (" + pageOid + ") > La p\u00e1gina no existe.");
                throw new R01MPortalModelException("Error la p\u00e1gina de oid " + pageOid + " no existe. Error: " + fndEx.getMessage(), (Exception)((Object)fndEx));
            }
            catch (NamingException namEx) {
                R01FLog.to((String)LOG_TYPE_ID).severe("PAGEMANAGER (" + pageOid + ") > Error al obtener el interfaz home del BMP de p\u00e1gina de portal.");
                throw new R01MPortalModelException("Error al obtener el interfaz home del BMP de p\u00e1gina de portal. Error: " + namEx.getMessage(), (Exception)namEx);
            }
            catch (EJBException ex) {
                R01FLog.to((String)LOG_TYPE_ID).severe("PAGEMANAGER (" + pageOid + ") > Error interno al borrar la p\u00e1gina de portal.");
                throw new R01MPortalModelException("Error interno al borrar la p\u00e1gina de oid " + pageOid + ". Error: " + ex.getMessage(), (Exception)((Object)ex));
            }
            catch (R01MPortalModelException ex) {
                R01FLog.to((String)LOG_TYPE_ID).severe("PAGEMANAGER (" + pageOid + ") > Error al borrar la p\u00e1gina de portal.");
                throw new R01MPortalModelException("Error al borrar la p\u00e1gina de oid " + pageOid + ". Error: " + ex.getMessage(), (Exception)((Object)ex));
            }
        } else {
            throw new R01MDeletePageException("La p\u00e1gina no se puede BORRAR, es posible que est\u00e9 publicada o sea la p\u00e1gina de inicio.");
        }
        R01GHistoryHelper.doInsertHistoryRecord(this._userCtx, pageOid, "", "PAGINA BORRADA", 1, 3, new StringBuffer(""));
    }

    public R01MPage doCopyPortalPage(String pageOidTo, String pageOidFrom) throws R01MSecurityException, R01MPortalModelException {
        R01MGeoPicks geolabels;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("PAGEMANAGER > Copiando la p\u00e1gina de oid " + pageOidFrom + " en " + pageOidTo);
        }
        R01MPage pageFrom = this.doLoadPage(pageOidFrom);
        R01MPage currPage = this.doLoadPage(pageOidTo);
        R01MPage pageTo = (R01MPage)CloneUtils.cloneByReflection((Object)pageFrom);
        pageTo.setUrlAliases(new ArrayList());
        pageTo.setOid(currPage.getOid());
        pageTo.setDescription(currPage.getDescription());
        pageTo.setInternalName(currPage.getInternalName());
        pageTo.setName(currPage.getName());
        pageTo.setCreateDate(currPage.getCreateDate());
        pageTo.setAuthor(currPage.getAuthor());
        pageTo.setRequestedPublications(null);
        pageTo.setPublicationInfo(null);
        pageTo.setIndexPage(0);
        if (pageTo.getIndexPage() == 1) {
            pageTo.setIndexPage(0);
        }
        if ((geolabels = pageTo.getGeoLabels()) != null && !geolabels.getGeopicks().isEmpty()) {
            ArrayList<R01MGeoPick> newGeoLabels = new ArrayList<R01MGeoPick>();
            for (R01MGeoPick currLabel : geolabels.getGeopicks()) {
                try {
                    currLabel.setOid(R01MUtils.generateNewOid((String)R01MConstants.PORTALMANAGER_APPCODE));
                }
                catch (GUIDDispenserException guidDispEx) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("Error al asignar nuevos identificadores a las etiquetas de catalogaci\u00f3n geogr\u00e1fica.Error:" + guidDispEx.getMessage());
                    throw new R01MPortalModelException("Error al asignar nuevos identificadores a las etiquetas de catalogaci\u00f3n geogr\u00e1fica.", (Exception)((Object)guidDispEx));
                }
                newGeoLabels.add(currLabel);
            }
            pageTo.setGeoLabels(new R01MGeoPicks(newGeoLabels));
        }
        try {
            R01GPageBMPUtil.getLocalHome().findByPrimaryKey(pageOidTo).copyAndUpdatePage(this._userCtx, pageTo);
        }
        catch (FinderException fndEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("\t... La p\u00e1gina no existe.");
            throw new R01MPortalModelException("Error la p\u00e1gina de oid " + pageOidTo + " no existe. Error: " + fndEx.getMessage(), (Exception)((Object)fndEx));
        }
        catch (NamingException namEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("\t... Error al obtener el interfaz home del BMP de p\u00e1gina de portal.");
            throw new R01MPortalModelException("Error al obtener el interfaz home del BMP de p\u00e1gina de portal. Error: " + namEx.getMessage(), (Exception)namEx);
        }
        catch (R01MPortalModelException pmEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("\t... Error al copiar la p\u00e1gina " + pageOidFrom + " en la p\u00e1gina " + pageOidTo);
            throw new R01MPortalModelException("Error al copiar la p\u00e1gina " + pageOidFrom + " en la p\u00e1gina " + pageOidTo + ". Error: " + pmEx.getMessage(), (Exception)((Object)pmEx));
        }
        if (pageTo.getLabels() != null && !pageTo.getLabels().isEmpty()) {
            this.doChangePageCatalogation(pageTo.getOid(), pageTo.getLabels());
        }
        if (geolabels != null && !geolabels.getGeopicks().isEmpty()) {
            this.doChangePageGeoCatalogation(pageTo.getOid(), pageTo.getGeoLabels());
        }
        R01GHistoryHelper.doInsertHistoryRecord(this._userCtx, pageTo.getOid(), "", pageTo.getInternalName(), 1, 2, new StringBuffer("Copia de la p\u00e1gina ").append(pageFrom.getInternalName()));
        return pageTo;
    }

    public void doCopyVisualAreasFromPage(String pageOidTo, String pageOidFrom) throws R01MSecurityException, R01MPortalModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("PAGEMANAGER > Copiando las AVs de la p\u00e1gina de oid " + pageOidFrom + " en " + pageOidTo);
        }
        R01MPage pageTo = this.doLoadPage(pageOidTo);
        R01MPage pageFrom = this.doLoadPage(pageOidFrom);
        try {
            R01GPageBMPUtil.getLocalHome().findByPrimaryKey(pageOidTo).copyVisualAreasFromPage(this._userCtx, pageFrom);
        }
        catch (FinderException fndEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("\t... La p\u00e1gina no existe.");
            throw new R01MPortalModelException("Error la p\u00e1gina de oid " + pageOidTo + " no existe. Error: " + fndEx.getMessage(), (Exception)((Object)fndEx));
        }
        catch (NamingException namEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("\t... Error al obtener el interfaz home del BMP de p\u00e1gina de portal.");
            throw new R01MPortalModelException("Error al obtener el interfaz home del BMP de p\u00e1gina de portal. Error: " + namEx.getMessage(), (Exception)namEx);
        }
        catch (R01MPortalModelException pmEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("\t... Error al copiar la p\u00e1gina " + pageOidFrom + " en la p\u00e1gina " + pageOidTo);
            throw new R01MPortalModelException("Error al copiar la p\u00e1gina " + pageOidFrom + " en la p\u00e1gina " + pageOidTo + ". Error: " + pmEx.getMessage(), (Exception)((Object)pmEx));
        }
        R01GHistoryHelper.doInsertHistoryRecord(this._userCtx, pageTo.getOid(), "", pageTo.getInternalName(), 1, 2, new StringBuffer("Copia de las Areas Visuales de la p\u00e1gina ").append(pageFrom.getInternalName()));
    }

    public void doChangePageCategory(String pageOid, String categoryOid) throws R01MSecurityException, R01MPortalModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("PAGEMANAGER > Cambiando la categor\u00eda de la p\u00e1gina de oid " + pageOid + " a la nueva categor\u00eda " + categoryOid);
        }
        try {
            R01GPageBMPUtil.getLocalHome().findByPrimaryKey(pageOid).changePageCategory(this._userCtx, categoryOid);
        }
        catch (FinderException fndEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("PAGEMANAGER (" + pageOid + ") > La p\u00e1gina no existe.");
            throw new R01MPortalModelException("Error la p\u00e1gina de oid " + pageOid + " no existe. Error: " + fndEx.getMessage(), (Exception)((Object)fndEx));
        }
        catch (NamingException namEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("PAGEMANAGER (" + pageOid + ") > Error al obtener el interfaz home del BMP de p\u00e1gina de portal.");
            throw new R01MPortalModelException("Error al obtener el interfaz home del BMP de p\u00e1gina de portal. Error: " + namEx.getMessage(), (Exception)namEx);
        }
        catch (EJBException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("PAGEMANAGER (" + pageOid + ") > Error interno al cambiar la categor\u00eda de la p\u00e1gina de oid " + pageOid + ". Error: " + ex.getMessage());
            throw new R01MPortalModelException("Error interno al cambiar la categor\u00eda de la p\u00e1gina de oid " + pageOid + ". Error: " + ex.getMessage(), (Exception)((Object)ex));
        }
        catch (R01MPortalModelException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("PAGEMANAGER (" + pageOid + ") > Error al cambiar la categor\u00eda de la p\u00e1gina de oid " + pageOid + ". Error: " + ex.getMessage());
            throw new R01MPortalModelException("Error al cambiar la categor\u00eda de la p\u00e1gina de oid " + pageOid + ". Error: " + ex.getMessage(), (Exception)((Object)ex));
        }
        R01GHistoryHelper.doInsertHistoryRecord(this._userCtx, pageOid, "", this.doGetPageInternalName(pageOid), 1, 2, new StringBuffer("Cambiada la categor\u00eda a ").append(categoryOid));
    }

    public Map<String, R01MPageVAInclude> doChangePageTemplate(String pageOid, String templateOid) throws R01MSecurityException, R01MPortalModelException {
        Map newVAs;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("PAGEMANAGER > Cambiando la plantilla de la p\u00e1gina de oid " + pageOid + " a la nueva plantilla " + templateOid);
        }
        try {
            newVAs = R01GPageBMPUtil.getLocalHome().findByPrimaryKey(pageOid).changePageTemplate(this._userCtx, templateOid);
        }
        catch (FinderException fndEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("PAGEMANAGER (" + pageOid + ") > La p\u00e1gina no existe.");
            throw new R01MPortalModelException("Error la p\u00e1gina de oid " + pageOid + " no existe. Error: " + fndEx.getMessage(), (Exception)((Object)fndEx));
        }
        catch (NamingException namEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("PAGEMANAGER (" + pageOid + ") > Error al obtener el interfaz home del BMP de p\u00e1gina de portal.");
            throw new R01MPortalModelException("Error al obtener el interfaz home del BMP de p\u00e1gina de portal. Error: " + namEx.getMessage(), (Exception)namEx);
        }
        catch (EJBException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("PAGEMANAGER (" + pageOid + ") > Error interno al cambiar la plantilla de la p\u00e1gina de oid " + pageOid + ". Error: " + ex.getMessage());
            throw new R01MPortalModelException("Error interno al cambiar la plantilla de la p\u00e1gina de oid " + pageOid + ". Error: " + ex.getMessage(), (Exception)((Object)ex));
        }
        catch (R01MPortalModelException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("PAGEMANAGER (" + pageOid + ") > Error al cambiar la plantilla de la p\u00e1gina de oid " + pageOid + ". Error: " + ex.getMessage());
            throw new R01MPortalModelException("Error al cambiar la plantilla de la p\u00e1gina de oid " + pageOid + ". Error: " + ex.getMessage(), (Exception)((Object)ex));
        }
        R01GHistoryHelper.doInsertHistoryRecord(this._userCtx, pageOid, "", this.doGetPageInternalName(pageOid), 1, 2, new StringBuffer("Cambiada la plantilla a ").append(templateOid));
        return newVAs;
    }

    public void doChangePageCatalogation(String pageOid, List<R01MStructureCatalog> structureCatalogation) throws R01MSecurityException, R01MPortalModelException {
        String opDesc = "Cambiando la catalogaci\u00f3n en ejes de la p\u00e1gina de oid " + pageOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("PAGEMANAGER (INIT)> " + opDesc);
        }
        try {
            R01GPageBMPUtil.getLocalHome().findByPrimaryKey(pageOid).changeCatalogationPage(this._userCtx, structureCatalogation);
        }
        catch (FinderException fndEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("PAGEMANAGER (" + pageOid + ") > La p\u00e1gina no existe.");
            throw new R01MPortalModelException("Error la p\u00e1gina de oid " + pageOid + " no existe. Error: " + fndEx.getMessage(), (Exception)((Object)fndEx));
        }
        catch (NamingException namEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("PAGEMANAGER (" + pageOid + ") > Error al obtener el interfaz home del BMP de p\u00e1gina de portal.");
            throw new R01MPortalModelException("Error al obtener el interfaz home del BMP de p\u00e1gina de portal. Error: " + namEx.getMessage(), (Exception)namEx);
        }
        catch (EJBException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("PAGEMANAGER (" + pageOid + ") > Error interno al catalogar en ejes la p\u00e1gina de portal.");
            throw new R01MPortalModelException("Error interno al catalogar en ejes la p\u00e1gina de oid " + pageOid + ". Error: " + ex.getMessage(), (Exception)((Object)ex));
        }
        catch (R01MPortalModelException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("PAGEMANAGER (" + pageOid + ") > Error al catalogar en ejes la p\u00e1gina de portal.");
            throw new R01MPortalModelException("Error al catalogar en ejes la p\u00e1gina de oid " + pageOid + ". Error: " + ex.getMessage(), (Exception)((Object)ex));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("PAGEMANAGER > " + opDesc + " .Guardando hist\u00f3rico.");
        }
        StringBuffer msg = new StringBuffer("Cambiada la catalogaci\u00f3n en ejes a : ");
        if (structureCatalogation != null && !structureCatalogation.isEmpty()) {
            for (R01MStructureCatalog catalog : structureCatalogation) {
                msg.append("\n Estructura:");
                msg.append(catalog.structureOid);
                msg.append(", Eje:");
                msg.append(catalog.oid);
                msg.append(", Role:");
                msg.append(catalog.role);
                String labelName = "";
                try {
                    R01MLabel currLabel = R01MClientFactory.getCatalogAPI((R01MUserContext)this._userCtx).loadLabel(catalog.oid);
                    if (currLabel != null) {
                        labelName = currLabel.getStandarizedTermValue("es");
                    } else {
                        msg.append("La etiqueta de identificador '" + catalog.oid + "' no existe.");
                    }
                }
                catch (R01MCatalogException ignore) {
                    ignore.printStackTrace(System.out);
                }
                msg.append("\nEtiqueta:");
                msg.append(labelName);
            }
        } else {
            msg.append(" vac\u00edo.");
        }
        R01GHistoryHelper.doInsertHistoryRecord(this._userCtx, pageOid, "", this.doGetPageInternalName(pageOid), 1, 5, msg);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("PAGEMANAGER (END)>" + opDesc);
        }
    }

    public void doChangePageGeoCatalogation(String pageOid, R01MGeoPicks geoCatalogation) throws R01MSecurityException, R01MPortalModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("PAGEMANAGER > Cambiando la catalogaci\u00f3n geogr\u00e1fica de la p\u00e1gina de oid " + pageOid);
        }
        try {
            R01GPageBMPUtil.getLocalHome().findByPrimaryKey(pageOid).changeGeoCatalogationPage(this._userCtx, geoCatalogation);
        }
        catch (FinderException fndEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("PAGEMANAGER (" + pageOid + ") > La p\u00e1gina no existe.");
            throw new R01MPortalModelException("Error la p\u00e1gina de oid " + pageOid + " no existe. Error: " + fndEx.getMessage(), (Exception)((Object)fndEx));
        }
        catch (NamingException namEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("PAGEMANAGER (" + pageOid + ") > Error al obtener el interfaz home del BMP de p\u00e1gina de portal.");
            throw new R01MPortalModelException("Error al obtener el interfaz home del BMP de p\u00e1gina de portal. Error: " + namEx.getMessage(), (Exception)namEx);
        }
        catch (EJBException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("PAGEMANAGER (" + pageOid + ") > Error interno al catalogar geogr\u00e1ficamente la p\u00e1gina de portal.");
            throw new R01MPortalModelException("Error interno al catalogar geogr\u00e1ficamente la p\u00e1gina de oid " + pageOid + ". Error: " + ex.getMessage(), (Exception)((Object)ex));
        }
        catch (R01MPortalModelException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("PAGEMANAGER (" + pageOid + ") > Error al catalogar geogr\u00e1ficamente la p\u00e1gina de portal.");
            throw new R01MPortalModelException("Error al catalogar geogr\u00e1ficamente la p\u00e1gina de oid " + pageOid + ". Error: " + ex.getMessage(), (Exception)((Object)ex));
        }
        StringBuffer msg = new StringBuffer("Cambiada la catalogaci\u00f3n geogr\u00e1fica a : ");
        if (geoCatalogation != null && !geoCatalogation.getGeopicks().isEmpty()) {
            for (R01MGeoPick geocatalog : geoCatalogation.getGeopicks()) {
                msg.append("\n" + (geocatalog.getGeocode().getCountry() != null ? "Pa\u00eds:" + geocatalog.getGeocode().getCountry().getName() + " " : "") + (geocatalog.getGeocode().getTerritory() != null ? "Territorio:" + geocatalog.getGeocode().getTerritory().getName() + " " : "") + (geocatalog.getGeocode().getRegion() != null ? "Provincia:" + geocatalog.getGeocode().getRegion().getName() + " " : "") + (geocatalog.getGeocode().getMunicipality() != null ? "Municipio:" + geocatalog.getGeocode().getMunicipality().getName() + " " : "") + (geocatalog.getGeocode().getLocality() != null ? "Ciudad:" + geocatalog.getGeocode().getLocality().getName() + " " : "") + (geocatalog.getGeocode().getStreet() != null ? ", Calle:" + geocatalog.getGeocode().getStreet().getName() : ""));
            }
        } else {
            msg.append(" vac\u00edo.");
        }
        R01GHistoryHelper.doInsertHistoryRecord(this._userCtx, pageOid, "", this.doGetPageInternalName(pageOid), 1, 5, msg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doPublishPage(String pageOid, Map<String, R01MPortalPublicationRequested> publicationsRequested) throws R01MPortalModelException {
        R01GPortalInDataStore datastore;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("R01GPageAdminManager.doPublishPage >> Publicando la p\u00e1gina de oid " + pageOid);
        }
        R01MPage page = this.doLoadPage(pageOid);
        try {
            datastore = new R01GPortalInDataStore(this._userCtx, page.getPortalOid());
        }
        catch (R01MDataStoreException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("R01GPageAdminManager.doPublishPage >> Error al cargar el portal " + page.getPortalOid());
            throw new R01MPortalModelException("Error al cargar el portal " + page.getPortalOid() + ". Error: " + ex.getMessage(), (Exception)((Object)ex));
        }
        try {
            datastore.createPublishDir();
        }
        catch (R01MDataStoreException dsExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("R01GPageAdminManager.doPublishPage >> Error al crear el directorio de publicaci\u00f3n del portal " + page.getPortalOid() + ".");
            throw new R01MPortalModelException("Error al crear el directorio de publicaci\u00f3n del portal " + page.getPortalOid() + " .Error: " + dsExc.getMessage(), (Exception)((Object)dsExc));
        }
        ArrayList<R01MPortalPublicationTarget> currPublishInfoInDB = page.getPublicationInfo();
        if (currPublishInfoInDB == null) {
            currPublishInfoInDB = new ArrayList<R01MPortalPublicationTarget>();
        }
        try {
            for (R01MPortalPublicationRequested publicationRequested : publicationsRequested.values()) {
                String publicationOid;
                String repositoryOid = publicationRequested.getRepositoryOid();
                Date publicationDate = publicationRequested.getOperationDate();
                int publicationType = publicationRequested.getOperationType();
                for (int i = 0; i < currPublishInfoInDB.size(); ++i) {
                    R01MPortalPublicationTarget pubTarget = (R01MPortalPublicationTarget)currPublishInfoInDB.get(i);
                    if (!pubTarget.getOid().equals(repositoryOid) || (pubTarget.getState() != 4 || publicationType != 1 && publicationType != 0) && (pubTarget.getState() != 5 || publicationType != 3 && publicationType != 2)) continue;
                    R01MPublisherAPI publisherAPI = R01MClientFactory.getPublisherAPI();
                    R01MPublish pub = publisherAPI.obtainPublicationInfoObject(null, pageOid, 4, null, null, null, repositoryOid, publicationType, publicationDate);
                    pub.setOid(pubTarget.getPublicationOid());
                    try {
                        if (pubTarget.getPublishDate().after(new Date())) {
                            publisherAPI.removeDeployment(pub);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    currPublishInfoInDB.remove(pubTarget);
                    page.setPublicationInfo(currPublishInfoInDB);
                    break;
                }
                try {
                    publicationOid = R01MUtils.generateNewOid((String)R01MConstants.PUBLISHER_APPCODE);
                }
                catch (GUIDDispenserException gdEx) {
                    throw new R01MPublisherException((Exception)((Object)gdEx));
                }
                String publishUrl = "/";
                if (publicationType == 0 || publicationType == 1) {
                    R01MPortal currPortal = null;
                    try {
                        currPortal = R01GPortalLoaderFactory.getPortalDataLoader().loadPortal(page.getPortalOid());
                    }
                    catch (R01MConfigLoadException ex1) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("R01GPageAdminManager.doPublishPage >> Error al cargar el portal de la p\u00e1gina a publicar: " + page.getOid());
                    }
                    publishUrl = R01MPortalPathHelpper.obtainPublishedPageURL((String)currPortal.getPortalDomain(), (String)page.getPortalOid(), (String)page.getInternalName());
                }
                R01MPortalPublicationTarget publicationTarget = new R01MPortalPublicationTarget();
                publicationTarget.setOid(repositoryOid);
                publicationTarget.setPublicationOid(publicationOid);
                publicationTarget.setPublishDate(publicationDate);
                publicationTarget.setPublisherConfirmation(0);
                publicationTarget.setUrl(publishUrl);
                publicationTarget.setMainAlias(page.getMainAliasURLByLang());
                R01GRepoPubPagePortalCMPLocal repoPubCMP = null;
                R01GRepoPubPagePortalCMPValue publiVO = new R01GRepoPubPagePortalCMPValue();
                publiVO.setRepositoryOid(repositoryOid);
                publiVO.setPagePortalOid(pageOid);
                publiVO.setPublishOid(publicationOid);
                publiVO.setPublicationConfirm(Integer.valueOf(Integer.toString(0)));
                publiVO.setPublishDate(publicationDate);
                publiVO.setMainAlias(publicationTarget.getMainAliasDBValue());
                publiVO.setUrl("/");
                if (publicationType == 0 || publicationType == 1) {
                    publicationTarget.setState(4);
                    publiVO.setState(4);
                } else {
                    publicationTarget.setState(5);
                    publiVO.setState(5);
                }
                currPublishInfoInDB.add(publicationTarget);
                page.setPublicationInfo(currPublishInfoInDB);
                boolean existsRepoPub = false;
                List repoPubCMPList = null;
                R01GRepoPubPagePortalCMPValue repoPubCMPValue = null;
                try {
                    repoPubCMPList = (List)R01GRepoPubPagePortalCMPUtil.getLocalHome().findByPagePortalOid(page.getOid());
                }
                catch (FinderException e) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("R01GPageAdminManager.doPublishPage >> Error al buscar la lista de publicaciones para el portal: " + page.getOid());
                    throw new R01MPublisherException("No se encuentra el JNDI del EJB de Publicaciones.", (Exception)((Object)e));
                }
                catch (NamingException namEx) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("R01GPageAdminManager.doPublishPage >> No se encuentra el JNDI del EJB de Publicaciones");
                    throw new R01MPublisherException("No se encuentra el JNDI del EJB de Publicaciones.", (Exception)namEx);
                }
                if (repoPubCMPList != null && !repoPubCMPList.isEmpty()) {
                    for (R01GRepoPubPagePortalCMPLocal currentRepoPubCMP : repoPubCMPList) {
                        repoPubCMPValue = currentRepoPubCMP.getR01GRepoPubPagePortalCMPValue();
                        if (!repoPubCMPValue.getPrimaryKey().equals((Object)publiVO.getPrimaryKey())) continue;
                        repoPubCMP = currentRepoPubCMP;
                        existsRepoPub = true;
                        break;
                    }
                } else {
                    existsRepoPub = false;
                }
                if (existsRepoPub) {
                    repoPubCMP.setR01GRepoPubPagePortalCMPValue(publiVO);
                } else {
                    try {
                        R01GRepoPubPagePortalCMPUtil.getLocalHome().create(publiVO);
                    }
                    catch (CreateException crtEx) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("R01GPageAdminManager.doPublishPage >> No se puede crear la Publicaci\u00f3n de la p\u00e1gina " + page.getOid() + " en el Repositorio: " + publiVO.getRepositoryOid());
                        throw new R01MPublisherException("No se puede crear la Publicaci\u00f3n de la p\u00e1gina " + page.getOid() + " en el Repositorio de publicaci\u00f3n: " + publiVO.getRepositoryOid() + ": " + crtEx.getMessage(), (Exception)((Object)crtEx));
                    }
                    catch (NamingException namEx) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("R01GPageAdminManager.doPublishPage >> No se encuentra el JNDI del EJB de Publicaciones");
                        throw new R01MPublisherException("No se encuentra el JNDI del EJB de Publicaciones.", (Exception)namEx);
                    }
                }
                try {
                    R01GPageBMPUtil.getLocalHome().findByPrimaryKey(pageOid).updatePublishPage(this._userCtx, currPublishInfoInDB);
                }
                catch (FinderException fndEx) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("PAGEMANAGER (" + pageOid + ") > La p\u00e1gina no existe.");
                    throw new R01MPortalModelException("Error la p\u00e1gina de oid " + pageOid + " no existe. Error: " + fndEx.getMessage(), (Exception)((Object)fndEx));
                }
                catch (NamingException namEx) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("PAGEMANAGER (" + pageOid + ") > Error al obtener el interfaz home del BMP de p\u00e1gina de portal.");
                    throw new R01MPortalModelException("Error al obtener el interfaz home del BMP de p\u00e1gina de portal. Error: " + namEx.getMessage(), (Exception)namEx);
                }
                catch (EJBException ex) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("PAGEMANAGER (" + pageOid + ") > Error interno al actualizar la p\u00e1gina de portal.");
                    throw new R01MPortalModelException("Error interno al actualizar la p\u00e1gina de oid " + pageOid + ". Error: " + ex.getMessage(), (Exception)((Object)ex));
                }
                catch (R01MPortalModelException ex) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("PAGEMANAGER (" + pageOid + ") > Error al actualizar la p\u00e1gina de portal.");
                    throw new R01MPortalModelException("Error al actualizar la p\u00e1gina de oid " + pageOid + ". Error: " + ex.getMessage(), (Exception)((Object)ex));
                }
                ArrayList<R01MPublishActionObject> stepsActions = null;
                if (!StringUtils.isEmptyString((String)publicationRequested.getCallbackUrl())) {
                    if (stepsActions == null) {
                        stepsActions = new ArrayList<R01MPublishActionObject>();
                    }
                    StringBuffer callBackUrlParam = new StringBuffer(100);
                    callBackUrlParam.append(publicationRequested.getCallbackUrl());
                    if (publicationRequested.getCallbackUrlParameters() != null && !publicationRequested.getCallbackUrlParameters().isEmpty()) {
                        callBackUrlParam.append(";");
                        for (Map.Entry entry : publicationRequested.getCallbackUrlParameters().entrySet()) {
                            callBackUrlParam.append((String)entry.getKey());
                            callBackUrlParam.append(",");
                            callBackUrlParam.append((String)entry.getValue());
                            callBackUrlParam.append(";");
                        }
                        callBackUrlParam.deleteCharAt(callBackUrlParam.length() - 1);
                    }
                    R01MPublishActionObject postPublishAction = new R01MPublishActionObject();
                    postPublishAction.setStep(3);
                    postPublishAction.setObjectOid(pageOid);
                    postPublishAction.setActionClass("com.ejie.r01p.publisher.R01MPortalModelPublisherActions");
                    postPublishAction.setMethod("invokeCallbackUrl");
                    postPublishAction.setParam(callBackUrlParam.toString());
                    stepsActions.add(postPublishAction);
                }
                try {
                    R01PPublishDefinition pubDefinition = new R01PPublishDefinition(this._userCtx.getUserName(), pageOid, 4, null, null, null, repositoryOid, publicationType, publicationDate, stepsActions, true, null, null);
                    R01PClientFactory.getPublisherAPI().publish(pubDefinition);
                    try {
                        StringBuffer msg = new StringBuffer(50);
                        msg.append("Portal:");
                        msg.append(page.getPortalOid());
                        msg.append(" ,Nombre interno:");
                        msg.append(page.getName());
                        msg.append(" ,Usuario:");
                        msg.append(this._userCtx.getUserName());
                        msg.append(" , Tipo de acci\u00f3n:");
                        msg.append(R01MBasePublicationRequested.getPublicationTypeLabel((int)publicationType));
                        R01GHistoryHelper.doInsertHistoryRecord(this._userCtx, page.getOid(), "", page.getInternalName(), 1, 4, msg);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace(System.out);
                    }
                }
                catch (R01MPublisherException pubEx) {
                    if (publicationType == 0 || publicationType == 1) {
                        publicationTarget.setState(3);
                        publiVO.setState(3);
                    } else {
                        publicationTarget.setState(2);
                        publiVO.setState(2);
                    }
                    repoPubCMP.setR01GRepoPubPagePortalCMPValue(publiVO);
                    for (R01MPortalPublicationTarget r01MPortalPublicationTarget : currPublishInfoInDB) {
                        if (!r01MPortalPublicationTarget.getPublicationOid().equals(publicationTarget.getOid())) continue;
                        currPublishInfoInDB.remove(r01MPortalPublicationTarget);
                        break;
                    }
                    currPublishInfoInDB.add(publicationTarget);
                    page.setPublicationInfo(currPublishInfoInDB);
                    try {
                        R01GPageBMPUtil.getLocalHome().findByPrimaryKey(pageOid).updatePublishPage(this._userCtx, currPublishInfoInDB);
                        throw new R01MPortalModelException("Error en la publicaci\u00f3n de la p\u00e1gina de portal " + pageOid, (Exception)((Object)pubEx));
                    }
                    catch (FinderException fndEx) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("PAGEMANAGER (" + pageOid + ") > La p\u00e1gina no existe.");
                        throw new R01MPortalModelException("Error la p\u00e1gina de oid " + pageOid + " no existe. Error: " + fndEx.getMessage(), (Exception)((Object)fndEx));
                    }
                    catch (NamingException namEx) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("PAGEMANAGER (" + pageOid + ") > Error al obtener el interfaz home del BMP de p\u00e1gina de portal.");
                        throw new R01MPortalModelException("Error al obtener el interfaz home del BMP de p\u00e1gina de portal. Error: " + namEx.getMessage(), (Exception)namEx);
                    }
                    catch (EJBException ex) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("PAGEMANAGER (" + pageOid + ") > Error interno al actualizar la p\u00e1gina de portal.");
                        throw new R01MPortalModelException("Error interno al actualizar la p\u00e1gina de oid " + pageOid + ". Error: " + ex.getMessage(), (Exception)((Object)ex));
                    }
                    catch (R01MPortalModelException ex) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("PAGEMANAGER (" + pageOid + ") > Error al actualizar la p\u00e1gina de portal.");
                        throw new R01MPortalModelException("Error al actualizar la p\u00e1gina de oid " + pageOid + ". Error: " + ex.getMessage(), (Exception)((Object)ex));
                    }
                    return;
                }
            }
        }
        catch (R01MPublisherException pubExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("R01GPageAdminManager.doPublishPage >> Error al publicar la p\u00e1gina " + pageOid + ".");
            throw new R01MPortalModelException("Error al publicar la p\u00e1gina " + pageOid + ". Error: " + pubExc.getMessage(), (Exception)((Object)pubExc));
        }
    }

    public boolean isPagePublished(String pageOid, String repositoryOid) throws R01MPortalModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("PAGEMANAGER > Validando si la p\u00e1gina de oid " + pageOid + " esta publicada en el repositorio " + repositoryOid);
        }
        R01MPage page = this.doLoadPage(pageOid);
        R01GPublisherManager publisher = new R01GPublisherManager();
        return publisher.isPagePublished(page, repositoryOid);
    }

    public void doReferencedVAInstance(String pageOid, String vaIncludeId, String vaInstanceOid) throws R01MSecurityException, R01MPortalModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("PAGEMANAGER > Referenciando en el identificador " + vaIncludeId + " de la p\u00e1gina de oid " + pageOid + " la instancia de VA " + vaInstanceOid);
        }
        try {
            String[][] vaIncludeIdInstanceOid = new String[][]{{vaIncludeId, vaInstanceOid}};
            R01GPageBMPUtil.getLocalHome().findByPrimaryKey(pageOid).referenceVAInstance(this._userCtx, vaIncludeIdInstanceOid);
        }
        catch (FinderException fndEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("\t... La p\u00e1gina no existe.");
            throw new R01MPortalModelException("Error la p\u00e1gina de oid " + pageOid + " no existe. Error: " + fndEx.getMessage(), (Exception)((Object)fndEx));
        }
        catch (NamingException namEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("\t... Error al obtener el interfaz home del BMP de p\u00e1gina de portal.");
            throw new R01MPortalModelException("Error al obtener el interfaz home del BMP de p\u00e1gina de portal. Error: " + namEx.getMessage(), (Exception)namEx);
        }
        catch (R01MPortalModelException pmEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("\t... Error al referenciar la instancia " + vaInstanceOid + " con la p\u00e1gina " + pageOid);
            throw new R01MPortalModelException("Error al referenciar la instancia " + vaInstanceOid + " con la p\u00e1gina " + pageOid + ". Error: " + pmEx.getMessage(), (Exception)((Object)pmEx));
        }
    }

    public void doReferencedVAInstances(String pageOid, String[][] referencedRelations) throws R01MSecurityException, R01MPortalModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("PAGEMANAGER > Referenciando en la p\u00e1gina de oid " + pageOid + " las instancias  " + StringUtils.printArrayStrings((String[][])referencedRelations));
        }
        try {
            R01GPageBMPUtil.getLocalHome().findByPrimaryKey(pageOid).referenceVAInstance(this._userCtx, referencedRelations);
        }
        catch (FinderException fndEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("\t... La p\u00e1gina no existe.");
            throw new R01MPortalModelException("Error la p\u00e1gina de oid " + pageOid + " no existe. Error: " + fndEx.getMessage(), (Exception)((Object)fndEx));
        }
        catch (NamingException namEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("\t... Error al obtener el interfaz home del BMP de p\u00e1gina de portal.");
            throw new R01MPortalModelException("Error al obtener el interfaz home del BMP de p\u00e1gina de portal. Error: " + namEx.getMessage(), (Exception)namEx);
        }
        catch (R01MPortalModelException pmEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("\t... Error al referenciar una instancia con la p\u00e1gina " + pageOid);
            throw new R01MPortalModelException("Error al referenciar una instancia con la p\u00e1gina " + pageOid + ". Error: " + pmEx.getMessage(), (Exception)((Object)pmEx));
        }
    }

    public void doChangeInitialPage(String portalOid, String pageOid) throws R01MSecurityException, R01MPortalModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("PAGEMANAGER > Estableciendo la p\u00e1gina " + pageOid + " como p\u00e1gina inicial del portal " + portalOid);
        }
        try {
            Collection pageCMPs = R01GPageCMPUtil.getLocalHome().findByInitialPage(portalOid);
            if (pageCMPs != null && !pageCMPs.isEmpty()) {
                for (R01GPageCMPLocal pageCMP : pageCMPs) {
                    if (pageCMP.getOid().equals(pageOid)) continue;
                    pageCMP.setInitialPage(0);
                }
            }
        }
        catch (FinderException ex) {
        }
        catch (NamingException namEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("\t... Error al obtener el interfaz home del CMP de p\u00e1ginas de inicio de portal.");
            throw new R01MPortalModelException("Error al obtener el interfaz home del CMP de p\u00e1ginas de inicio de portal. Error: " + namEx.getMessage(), (Exception)namEx);
        }
        try {
            R01GPageBMPUtil.getLocalHome().findByPrimaryKey(pageOid).setInitialPage(this._userCtx);
        }
        catch (FinderException fndEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("\t... La p\u00e1gina no existe.");
            throw new R01MPortalModelException("Error la p\u00e1gina de oid " + pageOid + " no existe. Error: " + fndEx.getMessage(), (Exception)((Object)fndEx));
        }
        catch (NamingException namEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("\t... Error al obtener el interfaz home del BMP de p\u00e1gina de portal.");
            throw new R01MPortalModelException("Error al obtener el interfaz home del BMP de p\u00e1gina de portal. Error: " + namEx.getMessage(), (Exception)namEx);
        }
        R01GPagesAPI pagesAPI = new R01GPagesAPI(this._userCtx);
        pagesAPI.createInitialPage(this.doLoadPage(pageOid));
    }

    public void doRedirectUrlPage(String portalOid, String pageOid, String redirectUrl) throws R01MSecurityException, R01MPortalModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("PAGEMANAGER > Estableciendo la p\u00e1gina " + pageOid + " como p\u00e1gina inicial del portal " + portalOid);
        }
        R01MPage page = this.doLoadPage(pageOid);
        page.setRedirectUrl(redirectUrl);
        try {
            this.doUpdatePage(page, false);
        }
        catch (R01MPortalModelObjectsValidatorException ex1) {
            R01FLog.to((String)"r01g.portalManager").severe("Error al actulizar la p\u00e1gina: " + ex1.getMessage());
        }
    }

    private boolean _validatePageInternalName(String portalOid, String pageInternalName) throws R01MPortalModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("Comprobar la existencia de otra p\u00e1gina con el mismo nombre interno: " + pageInternalName);
        }
        R01GDAOPortalModelLoader service = new R01GDAOPortalModelLoader();
        try {
            return service.executeValidatePage(portalOid, pageInternalName);
        }
        catch (R01GPortalModelPersistenceException ex) {
            throw new R01MPortalModelException("Error en la validaci\u00f3n del nombre interno de la p\u00e1gina.", (Exception)((Object)ex));
        }
    }

    private boolean _validatePageForDeletion(String pageOid) throws R01MPortalModelException {
        boolean isDeleteable = true;
        R01MPage page = this.doLoadPage(pageOid);
        if (page.isIndexPage()) {
            return false;
        }
        List publications = page.getPublicationInfo();
        if (publications != null && !publications.isEmpty()) {
            for (R01MPortalPublicationTarget publicacion1 : publications) {
                if (publicacion1.getState() != 1) continue;
                boolean isUnpublished = false;
                for (R01MPortalPublicationTarget publicacion2 : publications) {
                    if (!publicacion1.getOid().equals(publicacion2.getOid()) || publicacion2.getState() != 0) continue;
                    isUnpublished = true;
                    if (!publicacion1.getPublishDate().after(publicacion2.getPublishDate())) break;
                    isDeleteable = false;
                    break;
                }
                if (isUnpublished) continue;
                isDeleteable = false;
                break;
            }
        }
        return isDeleteable;
    }

    private void _sendAliasStructureUpdateMessage(String pageOid) throws R01MJMSException {
        ArrayList<R01MJmsQueueParam> paramList = new ArrayList<R01MJmsQueueParam>();
        paramList.add(new R01MJmsQueueParam(3, "objectType", (Object)Integer.toString(4)));
        paramList.add(new R01MJmsQueueParam(1, "objectOid", (Object)pageOid));
        try {
            R01MJMSUtils.sendJMSMessage((String)"r01UpdateAlias", paramList);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("Mensaje enviado a r01UpdateAlias");
            }
        }
        catch (R01MJMSException jmsExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al enviar el mensaje r01UpdateAlias. Error:" + jmsExc.getMessage());
            throw new R01MJMSException("Error al enviar el mensaje r01UpdateAlias", (Exception)((Object)jmsExc));
        }
    }
}

