/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01g.services;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01g.exceptions.R01GPortalIndexException;
import com.ejie.r01m.exceptions.R01MIndexerModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MSearchIndexerException;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexDefinition;
import com.ejie.r01p.services.R01PClientFactory;
import java.util.HashMap;
import java.util.logging.Level;

public class R01GIndexerManager {
    private static String LOG_TYPE_ID = "r01d.indexerProcessor";
    private static boolean DEBUG = R01FLog.getLogLevel((String)LOG_TYPE_ID).intValue() != Level.OFF.intValue();

    public void prepareToIndex(R01MIndexDefinition indexElement) throws R01GPortalIndexException {
        try {
            indexElement.validateObject();
        }
        catch (R01MIndexerModelObjectsValidatorException pubExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("R01GIndexerManager.prepareToIndex >> El objeto de indexaci\u00f3n no es v\u00e1lido.");
            R01FLog.to((String)LOG_TYPE_ID).severe(indexElement.debugInfo("").toString());
            throw new R01GPortalIndexException("El objeto de indexaci\u00f3n no es v\u00e1lido (paso R01GIndexerManager.prepareToIndex).", (Exception)((Object)pubExc));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("R01GIndexerManager.prepareToIndex >>");
            R01FLog.to((String)LOG_TYPE_ID).info(indexElement.debugInfo("").toString());
        }
        HashMap<String, String> indexersMap = new HashMap<String, String>();
        indexersMap.put("default", "Prepare to index finished correctly.");
        try {
            R01PClientFactory.getSearchEngineIndexerAPI().prepareToIndexFinished(indexElement.getObjectOid(), indexElement.getObjectType(), "OK", indexersMap);
        }
        catch (R01MSearchIndexerException siEx) {
            throw new R01GPortalIndexException((Exception)((Object)siEx));
        }
    }
}

