/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01g.services;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01g.exceptions.R01GPortalModelPersistenceException;
import com.ejie.r01g.gestorportal.dbhelppers.dao.R01GDAOHistoryManager;
import com.ejie.r01g.services.R01GBasePortalManager;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MPortalModelException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.portalmodel.R01MPortalHistoryFilter;
import java.util.List;
import java.util.logging.Level;

public class R01GHistoryHelper
extends R01GBasePortalManager {
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01g.historyHelpper").intValue() != Level.OFF.intValue();

    public static void doInsertHistoryRecord(R01MUserContext userCtx, String pageOid, String targetObjOid, String targetObjName, int targetObjType, int historyActionOid, StringBuffer historyNotes) {
        try {
            R01GDAOHistoryManager historyManager = new R01GDAOHistoryManager(userCtx);
            historyManager.executeSavePortalHistory(pageOid, targetObjOid, targetObjName, targetObjType, historyActionOid, historyNotes);
        }
        catch (R01GPortalModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
        }
    }

    public List doLoadPortalPageHistory(R01MUserContext userCtx, String pageOid, R01MPortalHistoryFilter filter) throws R01MPortalModelException, R01MSecurityException {
        super.validateSecurityContext(userCtx, pageOid, 1);
        String opDesc = "Cargar el hist\u00f3rico de la p\u00e1gina " + pageOid;
        if (DEBUG) {
            R01FLog.to((String)"r01g.historyHelpper").info("MODEL SERVER (init): " + opDesc);
        }
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01g.historyHelpper").info("\tFiltro:\n");
            }
            if (filter != null && DEBUG) {
                if (filter.getBeforeDate() != null) {
                    R01FLog.to((String)"r01g.historyHelpper").info("\t\tFecha desde:" + filter.getBeforeDate().toString() + "\n");
                }
                if (filter.getAfterDate() != null) {
                    R01FLog.to((String)"r01g.historyHelpper").info("\t\tFecha hasta:" + filter.getAfterDate().toString() + "\n");
                }
                if (filter.getAuthor() != null) {
                    R01FLog.to((String)"r01g.historyHelpper").info("\t\tAutor:" + filter.getAuthor() + "\n");
                }
                if (filter.getAction() != null) {
                    R01FLog.to((String)"r01g.historyHelpper").info("\t\tAutor:" + filter.getAction().toString() + "\n");
                }
            }
            R01GDAOHistoryManager manager = new R01GDAOHistoryManager(userCtx);
            return manager.executeLoadPortalHistory(pageOid, filter, userCtx.getUserLang());
        }
        catch (R01GPortalModelPersistenceException ex) {
            R01FLog.to((String)"r01g.historyHelpper").severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MPortalModelException("Error >>" + opDesc, (Exception)((Object)ex));
        }
    }
}

