/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01g.services;

import com.ejie.r01f.clone.CloneUtils;
import com.ejie.r01f.exceptions.ExceptionUtils;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01g.exceptions.R01GPortalModelPersistenceException;
import com.ejie.r01g.gestorportal.dbhelppers.dao.R01GDAOPortalFindersObjsLoader;
import com.ejie.r01g.services.R01GPortalModelManager;
import com.ejie.r01m.config.objects.cataloguing.R01MChangesLabelOperation;
import com.ejie.r01m.config.objects.cataloguing.R01MChangesLabelsOperationImpl;
import com.ejie.r01m.config.objects.cataloguing.R01MChangesLabelsOperationsGroup;
import com.ejie.r01m.config.objects.cataloguing.R01MChangesLabelsOperationsList;
import com.ejie.r01m.config.objects.cataloguing.R01MChangesLabelsPacket;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MCatalogException;
import com.ejie.r01m.exceptions.R01MPortalModelException;
import com.ejie.r01m.exceptions.R01MSearchIndexerException;
import com.ejie.r01m.objects.cataloguing.R01MStructureCatalog;
import com.ejie.r01m.objects.portalmodel.R01MPage;
import com.ejie.r01m.objects.portalmodel.R01MPageResume;
import com.ejie.r01m.objects.portalmodel.R01MPortalPublicationTarget;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexDefinition;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.catalog.R01MCatalogUtils;
import com.ejie.r01m.utils.jms.R01MJMSUtils;
import com.ejie.r01p.config.objects.cataloguing.R01PChangesLabelsOperationBase;
import com.ejie.r01p.services.R01PClientFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class R01GChangesLabelsOperationManager
extends R01PChangesLabelsOperationBase
implements R01MChangesLabelsOperationImpl {
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01g.changeslabelslistener").intValue() != Level.OFF.intValue();
    private R01GPortalModelManager manager = new R01GPortalModelManager();

    public boolean doProcessOperationGroup(R01MUserContext userCtx, String packetOid, R01MChangesLabelsOperationsGroup operationGroup) {
        R01MPage page;
        boolean hasErrors = false;
        if (DEBUG) {
            R01FLog.to((String)"r01g.changeslabelslistener").info("PORTAL CHANGESLABELSOPERATIONMANAGER >> Ejecutando el grupo de operaciones :\r\n" + operationGroup.composeDebugInfo().toString());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01g.changeslabelslistener").info("PORTAL CHANGESLABELSOPERATIONMANAGER >> Cargando la p\u00e1gina " + operationGroup.getObjectOid());
        }
        try {
            page = this.manager.doLoadPortalPage(userCtx, operationGroup.getObjectOid());
        }
        catch (R01MPortalModelException pmExc) {
            R01FLog.to((String)"r01g.changeslabelslistener").severe("PORTAL CHANGESLABELSOPERATIONMANAGER >> Error en la carga de la p\u00e1gina " + operationGroup.getObjectOid() + ".Error:" + pmExc.getMessage());
            R01MJMSUtils.sendPortalOperationError((String)packetOid, (String)operationGroup.getObjectOid(), (String)("Error en la carga de la p\u00e1gina:" + ExceptionUtils.serializeExceptionStackTrace((Throwable)pmExc)));
            return true;
        }
        catch (Exception ex) {
            R01FLog.to((String)"r01g.changeslabelslistener").severe("PORTAL CHANGESLABELSOPERATIONMANAGER >> Error GENERAL en la carga de la p\u00e1gina " + operationGroup.getObjectOid() + ".Error:" + ex.getMessage());
            R01MJMSUtils.sendPortalOperationError((String)packetOid, (String)operationGroup.getObjectOid(), (String)("Error GENERAL en la carga de la p\u00e1gina:" + ExceptionUtils.serializeExceptionStackTrace((Throwable)ex)));
            return true;
        }
        if (DEBUG) {
            R01FLog.to((String)"r01g.changeslabelslistener").info("PORTAL CHANGESLABELSOPERATIONMANAGER >> Cargado la p\u00e1gina " + page.getOid());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01g.changeslabelslistener").info("PORTAL CHANGESLABELSOPERATIONMANAGER >> Procesando un grupo de operaciones para la p\u00e1gina " + page.getOid());
        }
        hasErrors = this._doProcessOperationsGroup(userCtx, packetOid, page, operationGroup);
        return hasErrors;
    }

    public Map doCreateOperationsGroups(R01MChangesLabelsPacket changesPacket) throws R01MCatalogException {
        return super.doCreateOperationsGroups(changesPacket, 3);
    }

    public List doReorganizedAdmOperations(List operations) throws R01MCatalogException {
        ArrayList<R01MChangesLabelOperation> newPacketOperations = new ArrayList<R01MChangesLabelOperation>();
        for (R01MChangesLabelOperation operation : operations) {
            if (operation.getOperationType() >= 1 && operation.getOperationType() <= 6) {
                List pagesResume;
                R01GDAOPortalFindersObjsLoader loader = new R01GDAOPortalFindersObjsLoader();
                try {
                    if (operation.getOperationType() == 4) {
                        if (DEBUG) {
                            R01FLog.to((String)"r01g.changeslabelslistener").info("PORTAL RECATALOG >> Buscando p\u00e1ginas para la operaci\u00f3n DELETE...");
                        }
                        pagesResume = loader.findPortalPagesWithCatalog(null, operation.getLabelOid(), null);
                    } else {
                        if (DEBUG) {
                            R01FLog.to((String)"r01g.changeslabelslistener").info("PORTAL RECATALOG >> Buscando p\u00e1ginas con b\u00fasqueda com\u00fan...");
                        }
                        pagesResume = loader.findPortalPagesWithCatalog(operation.getSourceStructureOid(), operation.getLabelOid(), Integer.toString(operation.getSourceRole()));
                    }
                }
                catch (R01GPortalModelPersistenceException ex) {
                    R01FLog.to((String)"r01g.changeslabelslistener").severe("PORTAL RECATALOG >> Error en la ejecuci\u00f3n de la query de consulta de p\u00e1ginas catalogadas en la etiqueta " + operation.getLabelOid() + ".Error:" + ex.getMessage());
                    throw new R01MCatalogException("Error en la ejecuci\u00f3n de la query de consulta de p\u00e1ginas catalogadas en la etiqueta " + operation.getLabelOid());
                }
                if (pagesResume != null && !pagesResume.isEmpty()) {
                    if (DEBUG) {
                        R01FLog.to((String)"r01g.changeslabelslistener").info("PORTAL RECATALOG >> Existen " + pagesResume.size() + " p\u00e1ginas para ejecutar la operaci\u00f3n solicitada.");
                    }
                    for (R01MPageResume currPage : pagesResume) {
                        R01MChangesLabelOperation newOperation = (R01MChangesLabelOperation)CloneUtils.cloneByReflection((Object)operation);
                        newOperation.setObjectOid(currPage.getOid());
                        newOperation.setObjectType(1);
                        newPacketOperations.add(newOperation);
                    }
                    continue;
                }
                R01FLog.to((String)"r01g.changeslabelslistener").info("PORTAL RECATALOG >> No existen p\u00e1ginas para ejecutar la operaci\u00f3n solicitada.");
                continue;
            }
            R01FLog.to((String)"r01g.changeslabelslistener").warning("PORTAL RECATALOG >> Tipo de operaci\u00f3n desconocida");
        }
        return newPacketOperations;
    }

    private boolean _doProcessOperationsGroup(R01MUserContext userCtx, String packetOid, R01MPage page, R01MChangesLabelsOperationsGroup operationGroup) {
        R01FLog.to((String)"r01g.changeslabelslistener").info("PORTAL CHANGESLABELSOPERATIONMANAGER >> Ejecuci\u00f3n de un grupo de operaciones de recatalogaci\u00f3n DE ADMINISTRACION sobre la p\u00e1gina \"" + page.getOid() + "\"");
        boolean hasErrors = false;
        ArrayList sourceLabels = new ArrayList();
        if (page.getLabels() != null && !page.getLabels().isEmpty()) {
            Iterator itSourceLabels = page.getLabels().iterator();
            while (itSourceLabels.hasNext()) {
                sourceLabels.add(itSourceLabels.next());
            }
        }
        R01FLog.to((String)"r01g.changeslabelslistener").info("PORTAL CHANGESLABELSOPERATIONMANAGER >> Obtener las operaciones...");
        List pageOperations = null;
        try {
            pageOperations = ((R01MChangesLabelsOperationsList)XOManager.getObject((String)R01MConstants.STRUCTURESMODEL_MAPFILE, (String)operationGroup.getOperationsGroupXML())).getOperations();
        }
        catch (XOMarshallerException xoExc) {
            R01FLog.to((String)"r01g.changeslabelslistener").severe("PORTAL CHANGESLABELSOPERATIONMANAGER >> Error al mapear el XML de lista de operaciones a objeto. Error:" + xoExc.getMessage());
            return true;
        }
        R01FLog.to((String)"r01g.changeslabelslistener").info("PORTAL CHANGESLABELSOPERATIONMANAGER >> Tratar las operaciones...");
        boolean bRecatalogPage = false;
        if (pageOperations != null && !pageOperations.isEmpty()) {
            block8: for (R01MChangesLabelOperation operation : pageOperations) {
                if (DEBUG) {
                    R01FLog.to((String)"r01g.changeslabelslistener").info("PORTAL CHANGESLABELSOPERATIONMANAGER >> Ejecutando la operaci\u00f3n :\r\n" + operation.composeDebugInfo("\t").toString());
                }
                if (operation.getOperationType() >= 1 && operation.getOperationType() <= 6) {
                    R01MStructureCatalog newStructureCatalog = null;
                    if (operation.getOperationType() == 2) {
                        newStructureCatalog = new R01MStructureCatalog();
                        newStructureCatalog.setStructureOid(operation.getTargetStructureOid());
                        newStructureCatalog.setOid(operation.getLabelOid());
                        newStructureCatalog.setRole(Integer.toString(operation.getTargetRole()));
                    }
                    if (operation.getOperationType() == 5) {
                        newStructureCatalog = new R01MStructureCatalog();
                        newStructureCatalog.setStructureOid(operation.getSourceStructureOid());
                        newStructureCatalog.setOid(operation.getLabelOid());
                        newStructureCatalog.setRole(Integer.toString(operation.getSourceRole()));
                        if (page.getLabels() != null) {
                            if (R01MCatalogUtils.existCatalogInList((R01MStructureCatalog)newStructureCatalog, (List)page.getLabels())) continue;
                            page.getLabels().add(newStructureCatalog);
                            bRecatalogPage = true;
                            continue;
                        }
                        ArrayList<R01MStructureCatalog> newLabels = new ArrayList<R01MStructureCatalog>();
                        newLabels.add(newStructureCatalog);
                        page.setLabels(newLabels);
                        bRecatalogPage = true;
                        continue;
                    }
                    if (page.getLabels() == null || page.getLabels().isEmpty()) continue;
                    boolean bHitLabel = false;
                    for (R01MStructureCatalog catalog : sourceLabels) {
                        switch (operation.getOperationType()) {
                            case 3: 
                            case 4: 
                            case 6: {
                                if (!catalog.getStructureOid().equals(operation.getSourceStructureOid()) || !catalog.getOid().equals(operation.getLabelOid()) || Integer.parseInt(catalog.getRole()) != operation.getSourceRole()) break;
                                page.setLabels(R01MCatalogUtils.removeCatalogFromList((R01MStructureCatalog)catalog, (List)page.getLabels()));
                                bRecatalogPage = true;
                                bHitLabel = true;
                                break;
                            }
                            case 2: {
                                if (!catalog.getStructureOid().equals(operation.getSourceStructureOid()) || !catalog.getOid().equals(operation.getLabelOid()) || Integer.parseInt(catalog.getRole()) != operation.getSourceRole()) break;
                                page.setLabels(R01MCatalogUtils.removeCatalogFromList((R01MStructureCatalog)catalog, (List)page.getLabels()));
                                page.getLabels().add(newStructureCatalog);
                                bRecatalogPage = true;
                                bHitLabel = true;
                                break;
                            }
                            case 1: {
                                bRecatalogPage = true;
                                break;
                            }
                        }
                        if (!bHitLabel) continue;
                        continue block8;
                    }
                    continue;
                }
                R01FLog.to((String)"r01g.changeslabelslistener").warning("PORTAL CHANGESLABELSOPERATIONMANAGER >> Tipo de operaci\u00f3n desconocida");
            }
            if (bRecatalogPage) {
                if (DEBUG) {
                    R01FLog.to((String)"r01g.changeslabelslistener").info("PORTAL CHANGESLABELSOPERATIONMANAGER >> EJECUTANDO LA RECATALOGACION DE LA PAGINA (" + page.getOid() + ")");
                }
                hasErrors = this._launchRecatalogPage(userCtx, packetOid, page);
            } else if (DEBUG) {
                R01FLog.to((String)"r01g.changeslabelslistener").info("PORTAL CHANGESLABELSOPERATIONMANAGER >> No hay cambios en la catalogaci\u00f3n de la p\u00e1gina de oid " + page.getOid() + " por la operaci\u00f3n " + ".");
            }
            if (DEBUG) {
                R01FLog.to((String)"r01g.changeslabelslistener").info("PORTAL CHANGESLABELSOPERATIONMANAGER >> Notificando cambio de fin de catalogaci\u00f3n de la p\u00e1gina de oid " + page.getOid() + ".");
            }
            R01MJMSUtils.sendPortalOperationOK((String)packetOid, (String)page.getOid());
            if (DEBUG) {
                R01FLog.to((String)"r01g.changeslabelslistener").info("PORTAL CHANGESLABELSOPERATIONMANAGER >> Mensaje de la recatalogaci\u00f3n de la p\u00e1gina de oid " + page.getOid() + " enviado.");
            }
        }
        return hasErrors;
    }

    private boolean _launchRecatalogPage(R01MUserContext userCtx, String packetOid, R01MPage page) {
        if (DEBUG) {
            R01FLog.to((String)"r01g.changeslabelslistener").info("PORTAL CHANGESLABELSOPERATIONMANAGER >> Cambiando la catalogaci\u00f3n de la p\u00e1gina de oid " + page.getOid() + ".");
        }
        boolean hasErrors = false;
        if (XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"recatalogConfig/recatalogEnabled", (String)"true").trim().equalsIgnoreCase("true")) {
            try {
                hasErrors = this._recatalogPage(userCtx, packetOid, page);
            }
            catch (Exception ex) {
                R01FLog.to((String)"r01g.changeslabelslistener").severe("PORTAL CHANGESLABELSOPERATIONMANAGER >> Error GENERAL en la RECATALOGACION de la p\u00e1gina " + page.getOid() + ".Error:" + ex.getMessage());
                R01MJMSUtils.sendPortalOperationError((String)packetOid, (String)page.getOid(), (String)("Error GENERAL en la RECATALOGACION de la p\u00e1gina:" + ExceptionUtils.serializeExceptionStackTrace((Throwable)ex)));
                hasErrors = true;
            }
        } else {
            StringBuffer msg = new StringBuffer();
            msg.append("Recatalogando la p\u00e1gina \"");
            msg.append(page.getOid());
            msg.append("\" de nombre \"");
            msg.append(page.getName());
            msg.append("\" en la catalogaci\u00f3n :\n");
            if (page.getLabels() != null && !page.getLabels().isEmpty()) {
                for (R01MStructureCatalog label : page.getLabels()) {
                    msg.append(label.debugInfo("\t"));
                }
            }
            msg.append("\r\n");
            R01MJMSUtils.writeSimulateRecatalogLog((String)packetOid, (String)"Portal", (String)msg.toString());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01g.changeslabelslistener").info("PORTAL CHANGESLABELSOPERATIONMANAGER >> Cambiada la catalogaci\u00f3n de la p\u00e1gina de oid " + page.getOid() + ".");
        }
        return hasErrors;
    }

    private boolean _recatalogPage(R01MUserContext userCtx, String packetOid, R01MPage page) {
        R01FLog.to((String)"r01g.changeslabelslistener").info("PORTAL CHANGESLABELSOPERATIONMANAGER >> Guardando la pagina " + page.getOid());
        try {
            this.manager.doChangePageCatalog(userCtx, page.getOid(), page.getLabels());
        }
        catch (Exception ex) {
            R01FLog.to((String)"r01g.changeslabelslistener").severe("PORTAL CHANGESLABELSOPERATIONMANAGER >> Error al guardar la p\u00e1gina " + page.getOid() + " recatalogado.Error:" + ex.getMessage());
            R01MJMSUtils.sendPortalOperationError((String)packetOid, (String)page.getOid(), (String)("Error al guardar la p\u00e1gina recatalogada:" + ExceptionUtils.serializeExceptionStackTrace((Throwable)ex)));
            return true;
        }
        if (page.isIndexActive()) {
            R01FLog.to((String)"r01g.changeslabelslistener").info("PORTAL CHANGESLABELSOPERATIONMANAGER >> Reindexando la p\u00e1gina " + page.getOid() + " debido a la operacion de recatalogaci\u00f3n de p\u00e1ginas.");
            List publicationInfo = page.getPublicationInfo();
            boolean isPagePublished = false;
            if (publicationInfo != null && publicationInfo.size() > 0) {
                R01MPortalPublicationTarget repository;
                Iterator itPublicationRepository = publicationInfo.iterator();
                while (itPublicationRepository.hasNext() && !(isPagePublished = page.isPublishedInRepository((repository = (R01MPortalPublicationTarget)itPublicationRepository.next()).getOid()))) {
                }
            }
            try {
                R01MIndexDefinition indexDefinition = new R01MIndexDefinition(0, page.getOid(), 4, null, null, isPagePublished, -1, null, null, null);
                R01PClientFactory.getSearchEngineIndexerAPI().index(indexDefinition, R01MConstants.CONTENT_INDEXER_MANAGER);
            }
            catch (R01MSearchIndexerException idxExc) {
                R01FLog.to((String)"r01d.changeslabelslistener").severe("PAGE CHANGESLABELSOPERATIONMANAGER >> Error al indexar la catalogaci\u00f3n de la  p\u00e1gina " + page.getPortalOid() + "-" + page.getOid() + ".Error:" + idxExc.getMessage());
                R01MJMSUtils.sendContentOperationError((String)packetOid, (String)page.getOid(), (String)("Error al indexar la catalogaci\u00f3n del contenido:" + ExceptionUtils.serializeExceptionStackTrace((Throwable)idxExc)));
                return true;
            }
            catch (Exception ex) {
                R01FLog.to((String)"r01d.changeslabelslistener").severe("PAGE CHANGESLABELSOPERATIONMANAGER >> Error al indexar la catalogaci\u00f3n de la  p\u00e1gina " + page.getPortalOid() + "-" + page.getOid() + ".Error:" + ex.getMessage());
                R01MJMSUtils.sendContentOperationError((String)packetOid, (String)page.getOid(), (String)("Error GENERAL al indexar la catalogaci\u00f3n del contenido:" + ExceptionUtils.serializeExceptionStackTrace((Throwable)ex)));
                return true;
            }
        }
        return false;
    }
}

