/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01g.services;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01g.gestorportal.ejb.categories.R01GCategoryCMPLocal;
import com.ejie.r01g.gestorportal.ejb.categories.R01GCategoryCMPPK;
import com.ejie.r01g.gestorportal.ejb.categories.R01GCategoryCMPUtil;
import com.ejie.r01g.gestorportal.ejb.categories.R01GCategoryCMPValue;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MPortalModelException;
import com.ejie.r01m.objects.portalmodel.R01MPortalCategory;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MDozerMappingUtils;
import java.util.logging.Level;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import net.sf.dozer.util.mapping.MappingException;

public class R01GCategoryAdminManager {
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01g.categoryManager").intValue() != Level.OFF.intValue();
    private static final int OPERATION_NEW = 0;
    private static final int OPERATION_UPDATE = 1;
    private static final String[] OPERATION_DESC = new String[]{"CREATE", "UPDATE"};
    private R01MUserContext _userCtx;

    public R01GCategoryAdminManager(R01MUserContext userCtx) {
        this._userCtx = userCtx;
    }

    public void doCreateCategory(String portalOid, R01MPortalCategory category) throws R01MPortalModelException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.categoryManager").info("CATEGORY (" + category.getOid() + ") > CREATE > Creando nueva categor\u00eda para el portal " + portalOid);
        }
        this._processCategory(category, portalOid, 0);
        if (DEBUG) {
            R01FLog.to((String)"r01g.categoryManager").info("CATEGORY (" + category.getOid() + ") > CREATE > Creada una nueva categor\u00eda para el portal " + portalOid);
        }
    }

    public void doUpdateCategory(R01MPortalCategory category) throws R01MPortalModelException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.categoryManager").info("CATEGORY (" + category.getOid() + ") > UPDATE > Actualizando la categor\u00eda ...");
        }
        this._processCategory(category, null, 1);
        if (DEBUG) {
            R01FLog.to((String)"r01g.categoryManager").info("CATEGORY (" + category.getOid() + ") > UPDATE > Categor\u00eda Actualizada.");
        }
    }

    public void doDeleteCategory(String categoryOid) throws R01MPortalModelException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.categoryManager").info("\tejbRemove()...");
        }
        if (DEBUG) {
            R01FLog.to((String)"r01g.categoryManager").info("CATEGORY (" + categoryOid + ") > DELETE > Borrando la categor\u00eda.");
        }
        try {
            R01GCategoryCMPUtil.getLocalHome().findByPrimaryKey(new R01GCategoryCMPPK(categoryOid)).remove();
        }
        catch (EJBException ejbEx) {
            R01FLog.to((String)"r01g.categoryManager").severe("CATEGORY (" + categoryOid + ") > DELETE > Error en CMP de categor\u00eda.");
            throw new R01MPortalModelException("Error al borrar el categor\u00eda " + categoryOid + ": " + ejbEx.getMessage());
        }
        catch (RemoveException remEx) {
            R01FLog.to((String)"r01g.categoryManager").severe("CATEGORY (" + categoryOid + ") > DELETE > No se puede borrar el categor\u00eda.");
            throw new R01MPortalModelException("No se puede borrar el categor\u00eda " + categoryOid + ": " + remEx.getMessage());
        }
        catch (FinderException findEx) {
            R01FLog.to((String)"r01g.categoryManager").severe("CATEGORY (" + categoryOid + ")> DELETE > No existe la categor\u00eda.");
            throw new R01MPortalModelException("No existe el categor\u00eda " + categoryOid + ": " + findEx.getMessage());
        }
        catch (NamingException namEx) {
            R01FLog.to((String)"r01g.categoryManager").severe("CATEGORY (" + categoryOid + ")> DELETE > Error al localizar el home del CMP de categor\u00eda.");
            throw new R01MPortalModelException("Error al localizar el home del CMP de categor\u00eda: " + namEx.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01g.categoryManager").info("CATEGORY (" + categoryOid + ")> DELETE > Categor\u00eda Borrada!");
        }
    }

    private void _processCategory(R01MPortalCategory category, String portalOid, int operation) throws R01MPortalModelException {
        R01GCategoryCMPValue categoryVO;
        if (DEBUG) {
            R01FLog.to((String)"r01g.categoryManager").info("CATEGORY (" + category.getOid() + ") > " + OPERATION_DESC[operation] + " > Creando/Actualizando la categor\u00eda ...");
        }
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01g.categoryManager").info("CATEGORY (" + category.getOid() + ") > " + OPERATION_DESC[operation] + " > Mapeo de la categor\u00eda");
            }
            categoryVO = (R01GCategoryCMPValue)R01MDozerMappingUtils.map((String)R01MConstants.PORTALMANAGER_APPCODE, (Object)category, R01GCategoryCMPValue.class);
        }
        catch (MappingException mapEx) {
            R01FLog.to((String)"r01g.categoryManager").severe("CATEGORY (" + category.getOid() + ") > " + OPERATION_DESC[operation] + " > Error al mapear los miembros del objeto categor\u00eda al Value Object correspondiente.");
            throw new R01MPortalModelException("Error al mapear los miembros del objeto categor\u00eda al Value Object correspondiente: " + mapEx.getMessage(), (Exception)((Object)mapEx));
        }
        catch (Exception e) {
            R01FLog.to((String)"r01g.categoryManager").severe("CATEGORY (" + category.getOid() + ") > " + OPERATION_DESC[operation] + " > Ha fallado el Mapeo de la categor\u00eda : " + e.getMessage());
            throw new R01MPortalModelException("Error al mapear los miembros del objeto categor\u00eda al Value Object correspondiente: " + e.getMessage(), e);
        }
        catch (Throwable thEx) {
            thEx.printStackTrace();
            R01FLog.to((String)"r01g.categoryManager").severe("CATEGORY (" + category.getOid() + ") > " + OPERATION_DESC[operation] + " > Ha fallado el Mapeo de la categor\u00eda : " + thEx.getMessage());
            throw new R01MPortalModelException("Error al mapear los miembros del objeto categor\u00eda al Value Object correspondiente.");
        }
        if (DEBUG) {
            R01FLog.to((String)"r01g.categoryManager").info("CATEGORY (" + category.getOid() + ") > Tratando la operaci\u00f3n.");
        }
        if (operation == 0) {
            categoryVO.setPortalOid(portalOid);
            try {
                if (DEBUG) {
                    R01FLog.to((String)"r01g.categoryManager").info("CATEGORY (" + category.getOid() + ") > Creando la categor\u00eda.");
                }
                R01GCategoryCMPUtil.getLocalHome().create(categoryVO);
            }
            catch (CreateException crtEx) {
                R01FLog.to((String)"r01g.categoryManager").severe("CATEGORY (" + category.getOid() + ") > " + OPERATION_DESC[operation] + " > Error al crear la categor\u00eda.");
                throw new R01MPortalModelException("Error al crear la categor\u00eda " + category.getOid() + ": " + crtEx.getMessage(), (Exception)((Object)crtEx));
            }
            catch (NamingException namEx) {
                R01FLog.to((String)"r01g.categoryManager").severe("CATEGORY (" + category.getOid() + ") > " + OPERATION_DESC[operation] + " > Error al encontrar el home del CMP de categor\u00edas.");
                throw new R01MPortalModelException("Error al encontrar el home del CMP de categor\u00edas: " + namEx.getMessage(), (Exception)namEx);
            }
        }
        try {
            R01GCategoryCMPLocal categoryCMPLocal = R01GCategoryCMPUtil.getLocalHome().findByPrimaryKey(new R01GCategoryCMPPK(category.getOid()));
            categoryVO.setPortalOid(categoryCMPLocal.getPortalOid());
            categoryCMPLocal.setR01GCategoryCMPValue(categoryVO);
        }
        catch (NamingException namEx) {
            R01FLog.to((String)"r01g.categoryManager").severe("CATEGORY (" + category.getOid() + ") > " + OPERATION_DESC[operation] + " > Error al encontrar el home del CMP de categor\u00edas.");
            throw new R01MPortalModelException("Error al encontrar el home del CMP de categor\u00edas: " + namEx.getMessage(), (Exception)namEx);
        }
        catch (FinderException findEx) {
            R01FLog.to((String)"r01g.categoryManager").severe("CATEGORY (" + category.getOid() + ") > " + OPERATION_DESC[operation] + " > La categor\u00eda NO existe en la base de datos.");
            throw new R01MPortalModelException("La categor\u00eda " + category.getOid() + " NO existe en la base de datos", (Exception)((Object)findEx));
        }
        if (DEBUG) {
            R01FLog.to((String)"r01g.categoryManager").info("CATEGORY (" + category.getOid() + ") > " + OPERATION_DESC[operation] + " > Categor\u00eda Actualizada.");
        }
    }
}

