/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01g.services;

import com.ejie.r01f.util.StringUtils;
import com.ejie.r01g.exceptions.R01GPortalModelPersistenceException;
import com.ejie.r01g.gestorportal.dbhelppers.dao.R01GDAOPortalModelLoader;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.portalmodel.R01MPortal;

abstract class R01GBasePortalManager {
    public static final int SECURE_PORTAL_PORTAL = 0;
    public static final int SECURE_PAGE_PORTAL = 1;
    public static final int SECURE_VA_PORTAL = 2;

    R01GBasePortalManager() {
    }

    protected void validateSecurityContext(R01MUserContext userCtx, String oid, int objectType) throws R01MSecurityException {
        if (userCtx == null) {
            throw new R01MSecurityException("El contexto de Usuario no es v\u00e1lido.");
        }
        if (StringUtils.isEmptyString((String)oid)) {
            throw new R01MSecurityException("El Identificador no es v\u00e1lido.");
        }
        boolean isAccesible = false;
        if (!userCtx.isMasterSystem()) {
            String portalOid;
            R01GDAOPortalModelLoader loader = new R01GDAOPortalModelLoader();
            try {
                switch (objectType) {
                    case 0: {
                        portalOid = oid;
                        break;
                    }
                    case 2: {
                        portalOid = loader.executeLoadVAPortalOid(oid);
                        break;
                    }
                    case 1: {
                        portalOid = loader.executeLoadPagePortalOid(oid);
                        break;
                    }
                    default: {
                        throw new R01MSecurityException("El objeto especificado no es v\u00e1lido.");
                    }
                }
            }
            catch (R01GPortalModelPersistenceException ex) {
                throw new R01MSecurityException("Error en la validaci\u00f3n de seguridad.Error:" + ex.getMessage(), (Exception)((Object)ex));
            }
            for (R01MPortal portal : userCtx.getUserPortals().values()) {
                if (!portal.getOid().equals(portalOid)) continue;
                isAccesible = true;
            }
        } else {
            isAccesible = true;
        }
        if (!isAccesible) {
            throw new R01MSecurityException("El usuario no tiene acceso al portal.");
        }
    }
}

