/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01g.services;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01g.datastore.R01GPortalInDataStore;
import com.ejie.r01g.exceptions.R01GPortalModelPersistenceException;
import com.ejie.r01g.gestorportal.dbhelppers.dao.R01GDAOPortalModelLoader;
import com.ejie.r01g.gestorportal.ejb.aliases.R01GPageAliasCMPLocal;
import com.ejie.r01g.gestorportal.ejb.aliases.R01GPageAliasCMPUtil;
import com.ejie.r01g.gestorportal.ejb.aliases.R01GPageAliasCMPValue;
import com.ejie.r01g.gestorportal.ejb.aliases.R01GPortalAliasCMPLocal;
import com.ejie.r01g.gestorportal.ejb.aliases.R01GPortalAliasCMPPK;
import com.ejie.r01g.gestorportal.ejb.aliases.R01GPortalAliasCMPUtil;
import com.ejie.r01g.gestorportal.ejb.aliases.R01GPortalAliasCMPValue;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MDataStoreException;
import com.ejie.r01m.exceptions.R01MPortalModelException;
import com.ejie.r01m.exceptions.R01MPublisherException;
import com.ejie.r01m.objects.R01MURLAlias;
import com.ejie.r01m.objects.portalmodel.R01MPortalCustomElement;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MDozerMappingUtils;
import com.ejie.r01m.utils.R01MPathHelpper;
import com.ejie.r01p.objects.publisher.R01PPublishDefinition;
import com.ejie.r01p.services.R01PClientFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import net.sf.dozer.util.mapping.MappingException;

public class R01GAliasAdminManager {
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01g.aliasManager").intValue() != Level.OFF.intValue();
    private static final int OPERATION_NEW = 0;
    private static final int OPERATION_UPDATE = 1;
    private static final int OPERATION_DELETE = 2;
    private static final String[] OPERATION_DESC = new String[]{"CREATE", "UPDATE", "DELETE"};
    private R01MUserContext _userCtx;

    public R01GAliasAdminManager() {
    }

    public R01GAliasAdminManager(R01MUserContext userCtx) {
        this._userCtx = userCtx;
    }

    public void doCreateAlias(String portalOid, R01MURLAlias alias) throws R01MPortalModelException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.aliasManager").info("ALIAS (" + alias.getAlias() + ") > CREATE > Creando nuevo alias para el portal " + portalOid);
        }
        this._processAlias(alias, portalOid, 0);
        if (DEBUG) {
            R01FLog.to((String)"r01g.aliasManager").info("ALIAS (" + alias.getAlias() + ") > CREATE > Creada un nuevo alias para el portal " + portalOid);
        }
    }

    public boolean doCheckAliasExistence(R01MURLAlias alias) throws R01MPortalModelException {
        String opDesc = "Comprobar la existencia del alias " + alias;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01g.aliasManager").info("MODEL SERVER (init): " + opDesc);
            }
            R01GDAOPortalModelLoader modelLoader = new R01GDAOPortalModelLoader();
            boolean exist = modelLoader.executeCheckAliasExistence(alias);
            if (DEBUG) {
                R01FLog.to((String)"r01g.aliasManager").info("MODEL SERVER (end) : " + opDesc);
            }
            return exist;
        }
        catch (R01GPortalModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MPortalModelException(cmEx.getMessage());
        }
    }

    public boolean doCheckAliasExistence(String portalOid, R01MURLAlias alias) throws R01MPortalModelException {
        String opDesc = "Comprobar la existencia del alias " + alias;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01g.aliasManager").info("MODEL SERVER (init): " + opDesc);
            }
            R01GDAOPortalModelLoader modelLoader = new R01GDAOPortalModelLoader();
            boolean exist = modelLoader.executeCheckAliasExistence(portalOid, alias);
            if (DEBUG) {
                R01FLog.to((String)"r01g.aliasManager").info("MODEL SERVER (end) : " + opDesc);
            }
            return exist;
        }
        catch (R01GPortalModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MPortalModelException(cmEx.getMessage());
        }
    }

    public void doUpdateAlias(String portalOid, R01MURLAlias alias) throws R01MPortalModelException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.aliasManager").info("ALIAS (" + alias.getAlias() + ") > UPDATE > Actualizando el alias ...");
        }
        this._processAlias(alias, portalOid, 1);
        if (DEBUG) {
            R01FLog.to((String)"r01g.aliasManager").info("ALIAS (" + alias.getAlias() + ") > UPDATE > Alias actualizado.");
        }
    }

    public void doUpdatePageAliasesState(String pageOid, int initialState, int finalState) throws R01MPortalModelException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.aliasManager").info("ALIAS DE P\u00c1GINA Y ESTADO INICIAL (" + pageOid + ", " + initialState + ") > " + "UPDATE > Actualizando los aliases ...");
        }
        try {
            Collection aliasesInOriginalState = R01GPageAliasCMPUtil.getLocalHome().findByPageOidAndState(pageOid, initialState);
            for (R01GPageAliasCMPLocal aliasCMPLocal : aliasesInOriginalState) {
                R01GPageAliasCMPValue value = aliasCMPLocal.getR01GPageAliasCMPValue();
                value.setState(finalState);
                aliasCMPLocal.setR01GPageAliasCMPValue(value);
            }
        }
        catch (NamingException namEx) {
            R01FLog.to((String)"r01g.aliasManager").severe("ALIAS DE P\u00c1GINA (" + pageOid + ") Y ESTADO " + initialState + " > " + "Error al encontrar el home del CMP de aliases.");
            throw new R01MPortalModelException("Error al encontrar el home del CMP de aliases: " + namEx.getMessage(), (Exception)namEx);
        }
        catch (FinderException findEx) {
            R01FLog.to((String)"r01g.aliasManager").info("No existen alias para la p\u00e1gina " + pageOid + " y el estado " + initialState + ". " + "No se actualiza nada.");
        }
        if (DEBUG) {
            R01FLog.to((String)"r01g.aliasManager").info("ALIAS DE P\u00c1GINA (" + pageOid + ") > UPDATE > Aliases actualizados.");
        }
    }

    public void doUpdatePageAliasesState(String pageOid, List aliases, int finalState) throws R01MPortalModelException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.aliasManager").info("ALIAS DE P\u00c1GINA (" + pageOid + ") > " + "UPDATE > Actualizando los aliases ...");
        }
        try {
            for (R01MURLAlias currentAlias : aliases) {
                R01GPageAliasCMPLocal aliasCMPLocal = R01GPageAliasCMPUtil.getLocalHome().findByPageAndAliasAndLanguage(pageOid, currentAlias.getAlias(), currentAlias.getLang());
                R01GPageAliasCMPValue value = aliasCMPLocal.getR01GPageAliasCMPValue();
                value.setState(finalState);
                aliasCMPLocal.setR01GPageAliasCMPValue(value);
            }
        }
        catch (NamingException namEx) {
            R01FLog.to((String)"r01g.aliasManager").severe("ALIAS DE P\u00c1GINA (" + pageOid + ") > " + "Error al encontrar el home del CMP de aliases.");
            throw new R01MPortalModelException("Error al encontrar el home del CMP de aliases: " + namEx.getMessage(), (Exception)namEx);
        }
        catch (FinderException findEx) {
            R01FLog.to((String)"r01g.aliasManager").info("No existen alias para la p\u00e1gina. No se actualiza nada.");
        }
        if (DEBUG) {
            R01FLog.to((String)"r01g.aliasManager").info("ALIAS DE P\u00c1GINA (" + pageOid + ") > UPDATE > Aliases actualizados.");
        }
    }

    public void doDeletePageAliasesInState(String pageOid, int state) throws R01MPortalModelException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.aliasManager").info("ALIAS DE P\u00c1GINA Y ESTADO (" + pageOid + ", " + state + ") > " + "DELETE > Eliminando los aliases ...");
        }
        try {
            Collection aliasesInOriginalState = R01GPageAliasCMPUtil.getLocalHome().findByPageOidAndState(pageOid, state);
            Iterator itAliasesToUpdate = aliasesInOriginalState.iterator();
            while (itAliasesToUpdate.hasNext()) {
                ((R01GPageAliasCMPLocal)itAliasesToUpdate.next()).remove();
            }
        }
        catch (NamingException namEx) {
            R01FLog.to((String)"r01g.aliasManager").severe("ALIAS DE P\u00c1GINA (" + pageOid + ") Y ESTADO " + state + " > " + "Error al encontrar el home del CMP de aliases.");
            throw new R01MPortalModelException("Error al encontrar el home del CMP de aliases: " + namEx.getMessage(), (Exception)namEx);
        }
        catch (FinderException findEx) {
            R01FLog.to((String)"r01g.aliasManager").info("No existen alias para la p\u00e1gina " + pageOid + " y el estado " + state + ". " + "No se borra nada.");
        }
        catch (EJBException ejbEx) {
            R01FLog.to((String)"r01g.aliasManager").severe("ALIAS DE P\u00c1GINA (" + pageOid + ") Y ESTADO " + state + " > " + "Error: " + ejbEx.getMessage());
            throw new R01MPortalModelException("Error en el EJB de aliases: " + ejbEx.getMessage(), (Exception)((Object)ejbEx));
        }
        catch (RemoveException rEx) {
            R01FLog.to((String)"r01g.aliasManager").severe("ALIAS DE P\u00c1GINA (" + pageOid + ") Y ESTADO " + state + " > " + "Error al eliminar el alias: " + rEx.getMessage());
            throw new R01MPortalModelException("Error al eliminar el alias: " + rEx.getMessage(), (Exception)((Object)rEx));
        }
        if (DEBUG) {
            R01FLog.to((String)"r01g.aliasManager").info("ALIAS DE P\u00c1GINA (" + pageOid + ") > UPDATE > Aliases actualizados.");
        }
    }

    public void doDeletePortalAliasesInState(String portalOid, int state) throws R01MPortalModelException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.aliasManager").info("ALIAS DE PORTAL Y ESTADO (" + portalOid + ", " + state + ") > " + "DELETE > Eliminando los aliases ...");
        }
        try {
            Collection aliasesInOriginalState = R01GPortalAliasCMPUtil.getLocalHome().findByPortalOidAndState(portalOid, state);
            Iterator itAliasesToUpdate = aliasesInOriginalState.iterator();
            while (itAliasesToUpdate.hasNext()) {
                ((R01GPortalAliasCMPLocal)itAliasesToUpdate.next()).remove();
            }
        }
        catch (NamingException namEx) {
            R01FLog.to((String)"r01g.aliasManager").severe("ALIAS DE PORTAL (" + portalOid + ") Y ESTADO " + state + " > " + "Error al encontrar el home del CMP de aliases.");
            throw new R01MPortalModelException("Error al encontrar el home del CMP de aliases: " + namEx.getMessage(), (Exception)namEx);
        }
        catch (FinderException findEx) {
            R01FLog.to((String)"r01g.aliasManager").info("No existen alias para el portal " + portalOid + " y el estado " + state + ". " + "No se borra nada.");
        }
        catch (EJBException ejbEx) {
            R01FLog.to((String)"r01g.aliasManager").severe("ALIAS DE PORTAL (" + portalOid + ") Y ESTADO " + state + " > " + "Error: " + ejbEx.getMessage());
            throw new R01MPortalModelException("Error en el EJB de aliases: " + ejbEx.getMessage(), (Exception)((Object)ejbEx));
        }
        catch (RemoveException rEx) {
            R01FLog.to((String)"r01g.aliasManager").severe("ALIAS DE PORTAL (" + portalOid + ") Y ESTADO " + state + " > " + "Error al eliminar el alias: " + rEx.getMessage());
            throw new R01MPortalModelException("Error al eliminar el alias: " + rEx.getMessage(), (Exception)((Object)rEx));
        }
        if (DEBUG) {
            R01FLog.to((String)"r01g.aliasManager").info("ALIAS DE PORTAL (" + portalOid + ") > UPDATE > Aliases actualizados.");
        }
    }

    public void doUpdatePortalAliasesState(String portalOid, int initialState, int finalState) throws R01MPortalModelException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.aliasManager").info("ALIAS DE PORTAL Y ESTADO INICIAL (" + portalOid + ", " + initialState + ") > " + "UPDATE > Actualizando los aliases ...");
        }
        try {
            Collection aliasesInOriginalState = R01GPortalAliasCMPUtil.getLocalHome().findByPortalOidAndState(portalOid, initialState);
            for (R01GPortalAliasCMPLocal aliasCMPLocal : aliasesInOriginalState) {
                R01GPortalAliasCMPValue value = aliasCMPLocal.getR01GPortalAliasCMPValue();
                value.setState(finalState);
                aliasCMPLocal.setR01GPortalAliasCMPValue(value);
            }
        }
        catch (NamingException namEx) {
            R01FLog.to((String)"r01g.aliasManager").severe("ALIAS DE PORTAL (" + portalOid + ") Y ESTADO " + initialState + " > " + "Error al encontrar el home del CMP de aliases.");
            throw new R01MPortalModelException("Error al encontrar el home del CMP de aliases: " + namEx.getMessage(), (Exception)namEx);
        }
        catch (FinderException findEx) {
            R01FLog.to((String)"r01g.aliasManager").info("No existen alias para la portal " + portalOid + " y el estado " + initialState + ". " + "No se actualiza nada.");
        }
        if (DEBUG) {
            R01FLog.to((String)"r01g.aliasManager").info("ALIAS DE PORTAL (" + portalOid + ") > UPDATE > Aliases actualizados.");
        }
    }

    public void doDeleteAlias(String portalOid, R01MURLAlias alias) throws R01MPortalModelException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.aliasManager").info("\tejbRemove()...");
        }
        if (DEBUG) {
            R01FLog.to((String)"r01g.aliasManager").info("ALIAS (" + alias.getAlias() + ") > DELETE > Borrando el alias.");
        }
        try {
            R01GPortalAliasCMPLocal aliasCMPLocal = R01GPortalAliasCMPUtil.getLocalHome().findByPrimaryKey(new R01GPortalAliasCMPPK(alias.getOid()));
            R01GPortalAliasCMPValue aliasVO = (R01GPortalAliasCMPValue)R01MDozerMappingUtils.map((String)R01MConstants.PORTALMANAGER_APPCODE, (Object)alias, R01GPortalAliasCMPValue.class);
            aliasVO.setPortalOid(portalOid);
            aliasVO.setState(0);
            aliasCMPLocal.setR01GPortalAliasCMPValue(aliasVO);
        }
        catch (EJBException ejbEx) {
            R01FLog.to((String)"r01g.aliasManager").severe("ALIAS (" + alias.getAlias() + ") > DELETE > Error en CMP de alias.");
            throw new R01MPortalModelException("Error al borrar el alias " + alias.getAlias() + ": " + ejbEx.getMessage());
        }
        catch (FinderException findEx) {
            R01FLog.to((String)"r01g.aliasManager").severe("ALIAS (" + alias.getAlias() + ")> DELETE > No existe el alias.");
            throw new R01MPortalModelException("No existe el alias " + alias.getAlias() + ": " + findEx.getMessage());
        }
        catch (NamingException namEx) {
            R01FLog.to((String)"r01g.aliasManager").severe("ALIAS (" + alias.getAlias() + ")> DELETE > Error al localizar el home del CMP de alias.");
            throw new R01MPortalModelException("Error al localizar el home del CMP de alias: " + namEx.getMessage());
        }
        this._updateAliasesInDataStore(alias, portalOid, 2);
        if (DEBUG) {
            R01FLog.to((String)"r01g.aliasManager").info("ALIAS (" + alias.getAlias() + ")> DELETE > Alias Borrada!");
        }
    }

    public void doPublishPortalAliases(String portalOid, String repositoryOid) throws R01MPublisherException {
        R01PPublishDefinition pubDefinition = new R01PPublishDefinition(this._userCtx.getUserName(), portalOid, 18, null, null, null, repositoryOid, 0, null, null, true, null, null);
        R01PClientFactory.getPublisherAPI().publish(pubDefinition);
    }

    public void doPublishPortalAlias(String portalOid, String aliasOid, String repositoryOid) throws R01MPublisherException {
        R01GDAOPortalModelLoader service = new R01GDAOPortalModelLoader();
        R01MURLAlias aliasToPublish = null;
        List aliasToDelete = null;
        try {
            aliasToPublish = service.executeLoadPortalAlias(portalOid, aliasOid);
            aliasToDelete = service.executeLoadPortalAliasesInState(portalOid, 0);
        }
        catch (R01GPortalModelPersistenceException e) {
            throw new R01MPublisherException("No se encuentra en BD el alias de portal(" + portalOid + ") de oid " + aliasOid, (Exception)((Object)e));
        }
        ArrayList<String> addedAlias = new ArrayList<String>();
        if (aliasToPublish != null || aliasToDelete != null && !aliasToDelete.isEmpty()) {
            String apacheFileName = XMLProperties.getProperty((String)R01MConstants.API_APPCODE, (String)"aliasManagement/portalFriendlyUrl/apacheFileName", (String)".htaccess");
            ArrayList<String> resourceRelativePaths = new ArrayList<String>();
            String htaccessPath = null;
            if (aliasToPublish != null && !addedAlias.contains(aliasToPublish.getAlias())) {
                htaccessPath = R01MPathHelpper.getPortalResourcePublicationPath((String)portalOid, (int)12, (String)StringUtils.replaceString((String)(aliasToPublish.getAlias() + "/" + apacheFileName), (String)"//", (String)"/"));
                resourceRelativePaths.add(htaccessPath);
                addedAlias.add(aliasToPublish.getAlias());
            }
            if (aliasToDelete != null && !aliasToDelete.isEmpty()) {
                for (R01MURLAlias alias : aliasToDelete) {
                    if (addedAlias.contains(alias.getAlias())) continue;
                    htaccessPath = R01MPathHelpper.getPortalResourcePublicationPath((String)portalOid, (int)12, (String)StringUtils.replaceString((String)(alias.getAlias() + "/" + apacheFileName), (String)"//", (String)"/"));
                    resourceRelativePaths.add(htaccessPath);
                    addedAlias.add(alias.getAlias());
                }
            }
            R01PPublishDefinition pubDefinition = new R01PPublishDefinition(this._userCtx.getUserName(), portalOid, 18, null, null, resourceRelativePaths, repositoryOid, 0, null, null, true, null, null);
            R01PClientFactory.getPublisherAPI().publish(pubDefinition);
        }
    }

    private void _processAlias(R01MURLAlias alias, String portalOid, int operation) throws R01MPortalModelException {
        R01GPortalAliasCMPValue aliasVO;
        if (DEBUG) {
            R01FLog.to((String)"r01g.aliasManager").info("ALIAS (" + alias.getAlias() + ") > " + OPERATION_DESC[operation] + " > Creando/Actualizando el alias ...");
        }
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01g.aliasManager").info("ALIAS (" + alias.getAlias() + ") > " + OPERATION_DESC[operation] + " > Mapeo del alias");
            }
            aliasVO = (R01GPortalAliasCMPValue)R01MDozerMappingUtils.map((String)R01MConstants.PORTALMANAGER_APPCODE, (Object)alias, R01GPortalAliasCMPValue.class);
        }
        catch (MappingException mapEx) {
            R01FLog.to((String)"r01g.aliasManager").severe("ALIAS (" + alias.getAlias() + ") > " + OPERATION_DESC[operation] + " > Error al mapear los miembros del objeto alias al Value Object correspondiente.");
            throw new R01MPortalModelException("Error al mapear los miembros del objeto alias al Value Object correspondiente: " + mapEx.getMessage(), (Exception)((Object)mapEx));
        }
        catch (Exception e) {
            R01FLog.to((String)"r01g.aliasManager").severe("ALIAS (" + alias.getAlias() + ") > " + OPERATION_DESC[operation] + " > Ha fallado el Mapeo del alias : " + e.getMessage());
            throw new R01MPortalModelException("Error al mapear los miembros del objeto alias al Value Object correspondiente: " + e.getMessage(), e);
        }
        catch (Throwable thEx) {
            thEx.printStackTrace();
            R01FLog.to((String)"r01g.aliasManager").severe("ALIAS (" + alias.getAlias() + ") > " + OPERATION_DESC[operation] + " > Ha fallado el Mapeo del alias : " + thEx.getMessage());
            throw new R01MPortalModelException("Error al mapear los miembros del objeto alias al Value Object correspondiente.");
        }
        if (DEBUG) {
            R01FLog.to((String)"r01g.aliasManager").info("ALIAS (" + alias.getAlias() + ") > Tratando la operaci\u00f3n.");
        }
        if (operation == 0) {
            aliasVO.setPortalOid(portalOid);
            aliasVO.setState(1);
            try {
                if (DEBUG) {
                    R01FLog.to((String)"r01g.aliasManager").info("ALIAS (" + alias.getAlias() + ") > Creando el alias.");
                }
                R01GPortalAliasCMPUtil.getLocalHome().create(aliasVO);
            }
            catch (CreateException crtEx) {
                R01FLog.to((String)"r01g.aliasManager").severe("ALIAS (" + alias.getAlias() + ") > " + OPERATION_DESC[operation] + " > Error al crear el alias.");
                throw new R01MPortalModelException("Error al crear el alias " + alias.getAlias() + ": " + crtEx.getMessage(), (Exception)((Object)crtEx));
            }
            catch (NamingException namEx) {
                R01FLog.to((String)"r01g.aliasManager").severe("ALIAS (" + alias.getAlias() + ") > " + OPERATION_DESC[operation] + " > Error al encontrar el home del CMP de aliases.");
                throw new R01MPortalModelException("Error al encontrar el home del CMP de aliases: " + namEx.getMessage(), (Exception)namEx);
            }
        }
        try {
            R01GPortalAliasCMPLocal aliasCMPLocal = R01GPortalAliasCMPUtil.getLocalHome().findByPrimaryKey(new R01GPortalAliasCMPPK(alias.getOid()));
            if (!aliasCMPLocal.getAlias().equals(alias.getAlias())) {
                R01MURLAlias newAlias = new R01MURLAlias();
                newAlias.setAlias(aliasCMPLocal.getAlias());
                newAlias.setDomain(alias.getDomain());
                newAlias.setLang(alias.getLang());
                newAlias.setUrl(alias.getUrl());
                R01GPortalAliasCMPValue newAliasCMP = (R01GPortalAliasCMPValue)R01MDozerMappingUtils.map((String)R01MConstants.PORTALMANAGER_APPCODE, (Object)newAlias, R01GPortalAliasCMPValue.class);
                newAliasCMP.setState(0);
                newAliasCMP.setPortalOid(portalOid);
                try {
                    R01GPortalAliasCMPUtil.getLocalHome().create(newAliasCMP);
                }
                catch (CreateException cEx) {
                    R01FLog.to((String)"r01g.aliasManager").severe("ALIAS (" + aliasCMPLocal.getAlias() + " - " + alias.getAlias() + ") >> " + "Actualizando un alias (y cambiando la friendlyURL). " + "\nError al crear el alias 'ficticio' para que se borre en la publicaci\u00f3n: " + cEx.getMessage());
                    throw new R01MPortalModelException("Error al crear el registro que marca que se borre el alias viejo en la publicaci\u00f3n: " + cEx.getMessage(), (Exception)((Object)cEx));
                }
            }
            aliasVO.setPortalOid(aliasCMPLocal.getPortalOid());
            aliasVO.setState(1);
            aliasCMPLocal.setR01GPortalAliasCMPValue(aliasVO);
        }
        catch (NamingException namEx) {
            R01FLog.to((String)"r01g.aliasManager").severe("ALIAS (" + alias.getAlias() + ") > " + OPERATION_DESC[operation] + " > Error al encontrar el home del CMP de aliases.");
            throw new R01MPortalModelException("Error al encontrar el home del CMP de aliases: " + namEx.getMessage(), (Exception)namEx);
        }
        catch (FinderException findEx) {
            R01FLog.to((String)"r01g.aliasManager").severe("ALIAS (" + alias.getAlias() + ") > " + OPERATION_DESC[operation] + " > El alias NO existe en la base de datos.");
            throw new R01MPortalModelException("El alias " + alias.getAlias() + " NO existe en la base de datos", (Exception)((Object)findEx));
        }
        this._updateAliasesInDataStore(alias, portalOid, operation);
    }

    private void _updateAliasesInDataStore(R01MURLAlias alias, String portalOid, int operation) throws R01MPortalModelException {
        R01GPortalInDataStore datastore;
        try {
            datastore = new R01GPortalInDataStore(this._userCtx, portalOid);
        }
        catch (R01MDataStoreException ex) {
            if (DEBUG) {
                R01FLog.to((String)"r01g.aliasManager").severe("R01GAliasAdminManager (" + alias.getAlias() + ") > Error al acceder al storage del portal " + portalOid);
            }
            throw new R01MPortalModelException("Error al acceder al storage del portal " + portalOid + ". Error: " + ex.getMessage(), (Exception)((Object)ex));
        }
        try {
            HashMap<String, R01MURLAlias> aliases = new HashMap<String, R01MURLAlias>();
            Collection aliasesCMP = R01GPortalAliasCMPUtil.getLocalHome().findByPortalOid(portalOid);
            for (R01GPortalAliasCMPLocal aliasCMP : aliasesCMP) {
                aliases.put(aliasCMP.getDomain(), new R01MURLAlias(aliasCMP.getAlias(), aliasCMP.getUrl(), aliasCMP.getDomain(), aliasCMP.getLang()));
            }
            R01MPortalCustomElement portalAlias = new R01MPortalCustomElement();
            portalAlias.setUrlAliases(aliases);
            datastore.updatePortalAliasDescriptor(XOManager.getXML((String)R01MConstants.PORTALALIAS_MAPFILE, (Object)portalAlias));
        }
        catch (NamingException namEx) {
            R01FLog.to((String)"r01g.aliasManager").severe("ALIAS (" + alias.getAlias() + ") > " + OPERATION_DESC[operation] + " > Error al encontrar el home del CMP de aliases para el portal " + portalOid + ".");
            throw new R01MPortalModelException("Error al encontrar el home del CMP de aliases para el portal " + portalOid + ": " + namEx.getMessage(), (Exception)namEx);
        }
        catch (FinderException findEx) {
            R01FLog.to((String)"r01g.aliasManager").severe("ALIAS DE PORTAL (" + portalOid + ") > " + OPERATION_DESC[operation] + " > NO existen alias en la base de datos.");
            throw new R01MPortalModelException("No existen alias para el portal " + portalOid, (Exception)((Object)findEx));
        }
        catch (R01MDataStoreException dsExc) {
            throw new R01MPortalModelException("Error al crear el fichero XML de alias de portal " + portalOid + " en el storage del portal: " + dsExc.toString(), (Exception)((Object)dsExc));
        }
        catch (XOMarshallerException mapEx) {
            R01FLog.to((String)"r01g.portalManager").severe("R01GAliasAdminManager (" + portalOid + ") > Error al mapear el XML de definici\u00f3n del alias.");
            throw new R01MPortalModelException("Error al mapear el XML de definici\u00f3n del alias de portal " + portalOid + ".Error: " + mapEx.getMessage(), (Exception)((Object)mapEx));
        }
    }
}

