/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01g.ejb.services.loaders;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01g.config.loaders.R01GPortalLoaderFactory;
import com.ejie.r01g.exceptions.R01GPortalModelPersistenceException;
import com.ejie.r01g.gestorportal.dbhelppers.dao.R01GDAOPortalModelLoader;
import com.ejie.r01m.config.objects.portalmodel.R01MVisualAreasConfig;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MMiscDataLoadException;
import com.ejie.r01m.objects.portalmodel.R01MPortal;
import com.ejie.r01m.objects.portalmodel.R01MPortalCategory;
import com.ejie.r01m.objects.portalmodel.R01MPortalTemplate;
import com.ejie.r01m.services.bzd.R01MPortalConfigLoaderBzd;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

public class R01GLoaderServicesSLBaseBean
implements SessionBean,
R01MPortalConfigLoaderBzd {
    private static final long serialVersionUID = 4209290334997995938L;
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01g.services").intValue() != Level.OFF.intValue();
    private SessionContext context;

    public void setSessionContext(SessionContext newContext) throws EJBException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.services").info("\tR01GLoaderServicesSL.setSessionContext()...");
        }
        this.context = newContext;
    }

    public void ejbRemove() throws EJBException, RemoteException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.services").info("\tR01GLoaderServicesSL.ejbRemove()...");
        }
    }

    public void ejbActivate() throws EJBException, RemoteException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.services").info("\tR01GLoaderServicesSL.ejbActivate()...");
        }
    }

    public void ejbPassivate() throws EJBException, RemoteException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.services").info("\tR01GLoaderServicesSL.ejbPassivate()...");
        }
    }

    public void ejbCreate() throws CreateException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.services").info("\tR01GLoaderServicesSL.ejbCreate()...");
        }
    }

    public R01MVisualAreasConfig loadVisualAreasConfig() throws R01MConfigLoadException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.services").info("\tR01GLoaderServicesSL.loadVisualAreasConfig()...");
        }
        return R01GPortalLoaderFactory.getPortalConfigLoader().loadVisualAreasConfig();
    }

    public void reloadAllPortalConfig() throws R01MConfigLoadException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.services").info("\tR01GLoaderServicesSL.loadAllPortalConfig()...");
        }
        R01GPortalLoaderFactory.getPortalDataLoader().reloadAllPortalConfig();
    }

    public Map loadAllPortalConfig() throws R01MConfigLoadException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.services").info("\tR01GLoaderServicesSL.loadAllPortalConfig()...");
        }
        return R01GPortalLoaderFactory.getPortalDataLoader().loadAllPortals();
    }

    public List loadPortals() throws R01MConfigLoadException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.services").info("\tR01GLoaderServicesSL.loadPortals()...");
        }
        R01GDAOPortalModelLoader portalLoader = new R01GDAOPortalModelLoader();
        try {
            return portalLoader.executeLoadPortalOids();
        }
        catch (R01GPortalModelPersistenceException ex) {
            throw new R01MConfigLoadException("Error en la carga de los identificadores de portales.");
        }
    }

    public R01MPortal loadPortal(String portalOid) throws R01MConfigLoadException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.services").info("\tR01GLoaderServicesSL.loadPortal()...");
        }
        return R01GPortalLoaderFactory.getPortalDataLoader().loadPortal(portalOid);
    }

    public List loadPortalAlias(String portalOid) throws R01MConfigLoadException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.services").info("\tR01GLoaderServicesSL.loadPortalAlias()...");
        }
        R01GDAOPortalModelLoader portalLoader = new R01GDAOPortalModelLoader();
        List urlAliases = null;
        try {
            urlAliases = portalLoader.executeLoadPortalActiveAliases(portalOid);
        }
        catch (R01GPortalModelPersistenceException ex) {
            throw new R01MConfigLoadException("Error en la carga de los aliases del portal " + portalOid + ".");
        }
        return urlAliases;
    }

    public R01MPortalCategory loadPortalCategory(String portalOid, String categoryOid) throws R01MConfigLoadException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.services").info("\tR01GLoaderServicesSL.loadPortalCategory()...");
        }
        R01GDAOPortalModelLoader portalLoader = new R01GDAOPortalModelLoader();
        R01MPortalCategory category = null;
        try {
            category = portalLoader.executeLoadPortalCategory(portalOid, categoryOid);
        }
        catch (R01GPortalModelPersistenceException ex) {
            throw new R01MConfigLoadException("Error en la carga de las categorias del portal " + portalOid + ".");
        }
        return category;
    }

    public R01MPortalTemplate loadPortalTemplate(String portalOid, String templateId) throws R01MConfigLoadException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.services").info("\tR01GLoaderServicesSL.loadPortalTemplate()...");
        }
        if (DEBUG) {
            R01FLog.to((String)"r01g.services").info("Cargando la plantilla " + templateId + " del portal:" + portalOid);
        }
        return R01GPortalLoaderFactory.getTemplateDataLoader().loadTemplate(portalOid, templateId);
    }

    public List loadPortalTemplates(String portalOid, boolean ordered, String lang) throws R01MConfigLoadException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.services").info("\tR01GLoaderServicesSL.loadPortalTemplates()...");
        }
        R01GDAOPortalModelLoader portalLoader = new R01GDAOPortalModelLoader();
        List templates = null;
        try {
            templates = portalLoader.executeLoadPortalTemplates(portalOid);
        }
        catch (R01GPortalModelPersistenceException ex) {
            throw new R01MConfigLoadException("Error en la carga de las plantillas del portal " + portalOid + ".");
        }
        if (ordered && templates != null && !templates.isEmpty()) {
            if (DEBUG) {
                R01FLog.to((String)"r01g.services").info("\tR01GLoaderServicesSL.loadPortalTemplates()...Ordenando las plantillas por el nombre en " + lang);
            }
            if (lang.equals("eu")) {
                Collections.sort(templates, new R01MTemplateNameEUComparator());
            }
            Collections.sort(templates, new R01MTemplateNameESComparator());
        }
        return templates;
    }

    public List loadPortalCategories(String portalOid, boolean ordered, String lang) throws R01MConfigLoadException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.services").info("\tR01GLoaderServicesSL.loadPortalCategories()...");
        }
        R01GDAOPortalModelLoader portalLoader = new R01GDAOPortalModelLoader();
        List categories = null;
        try {
            categories = portalLoader.executeLoadPortalCategories(portalOid);
        }
        catch (R01GPortalModelPersistenceException ex) {
            throw new R01MConfigLoadException("Error en la carga de las categorias del portal " + portalOid + ".");
        }
        if (ordered && categories != null && !categories.isEmpty()) {
            if (DEBUG) {
                R01FLog.to((String)"r01g.services").info("\tR01GLoaderServicesSL.loadPortalCategories()...Ordenando las categor\u00edas por el nombre en " + lang);
            }
            if (lang.equals("eu")) {
                Collections.sort(categories, new R01MCategoryNameEUComparator());
            }
            Collections.sort(categories, new R01MCategoryNameESComparator());
        }
        return categories;
    }

    public Map loadLanguages(String lang) throws R01MMiscDataLoadException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.services").info("\tR01GLoaderServicesSL.loadLanguages()...");
        }
        return R01GPortalLoaderFactory.getMiscellaneousDataLoader().loadLanguages(lang);
    }

    public Map loadEvents(String lang) throws R01MMiscDataLoadException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.services").info("\tR01GLoaderServicesSL.loadEvents()...");
        }
        return R01GPortalLoaderFactory.getMiscellaneousDataLoader().loadEvents(lang);
    }

    class R01MCategoryNameESComparator
    implements Comparator {
        R01MCategoryNameESComparator() {
        }

        public int compare(Object o1, Object o2) {
            R01MPortalCategory categoryObj1 = (R01MPortalCategory)o1;
            R01MPortalCategory categoryObj2 = (R01MPortalCategory)o2;
            return categoryObj1.getNameES().compareTo(categoryObj2.getNameES());
        }
    }

    class R01MCategoryNameEUComparator
    implements Comparator {
        R01MCategoryNameEUComparator() {
        }

        public int compare(Object o1, Object o2) {
            R01MPortalCategory categoryObj1 = (R01MPortalCategory)o1;
            R01MPortalCategory categoryObj2 = (R01MPortalCategory)o2;
            return categoryObj1.getNameEU().compareTo(categoryObj2.getNameEU());
        }
    }

    class R01MTemplateNameESComparator
    implements Comparator {
        R01MTemplateNameESComparator() {
        }

        public int compare(Object o1, Object o2) {
            R01MPortalTemplate templateObj1 = (R01MPortalTemplate)o1;
            R01MPortalTemplate templateObj2 = (R01MPortalTemplate)o2;
            return templateObj1.getNameES().compareTo(templateObj2.getNameES());
        }
    }

    class R01MTemplateNameEUComparator
    implements Comparator {
        R01MTemplateNameEUComparator() {
        }

        public int compare(Object o1, Object o2) {
            R01MPortalTemplate templateObj1 = (R01MPortalTemplate)o1;
            R01MPortalTemplate templateObj2 = (R01MPortalTemplate)o2;
            return templateObj1.getNameEU().compareTo(templateObj2.getNameEU());
        }
    }
}

