/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01g.ejb.services.admin;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01g.services.R01GPortalAdminManager;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MJMSException;
import com.ejie.r01m.exceptions.R01MPortalModelException;
import com.ejie.r01m.exceptions.R01MPortalModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.misc.R01MOperationInModelObjectResult;
import com.ejie.r01m.objects.portalmodel.R01MPortal;
import com.ejie.r01m.objects.portalmodel.R01MVisualAreaInstance;
import com.ejie.r01m.services.bzd.R01MPortalAdminBzd;
import com.ejie.r01n.ejb.notifier.R01NCachesNotifierSLUtil;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;

public class R01GPortalAdminServicesSLBaseBean
implements SessionBean,
R01MPortalAdminBzd {
    private static final long serialVersionUID = 3363541073894840982L;
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01g.services").intValue() != Level.OFF.intValue();
    private SessionContext context;

    public void setSessionContext(SessionContext newContext) throws EJBException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.services").info("\tR01GPortalAdminServicesSL.setSessionContext()...");
        }
        this.context = newContext;
    }

    public void ejbRemove() throws EJBException, RemoteException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.services").info("\tR01GPortalAdminServicesSL.ejbRemove()...");
        }
    }

    public void ejbActivate() throws EJBException, RemoteException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.services").info("\tR01GPortalAdminServicesSL.ejbActivate()...");
        }
    }

    public void ejbPassivate() throws EJBException, RemoteException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.services").info("\tR01GPortalAdminServicesSL.ejbPassivate()...");
        }
    }

    public void ejbCreate() throws CreateException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.services").info("\tR01GPortalAdminServicesSL.ejbCreate()");
        }
    }

    public void doSavePortal(R01MUserContext userCtx, String portalXML) throws EJBException, R01MPortalModelException, R01MPortalModelObjectsValidatorException, R01MSecurityException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.services").info("\tR01GPortalAdminServicesSL.doSavePortal()...");
        }
        R01MPortal portal = this.doSaveBasePortal(userCtx, portalXML);
        this.doUpdatePortalState(userCtx, portal);
        this._reloadCaches();
    }

    public R01MPortal doSaveBasePortal(R01MUserContext userCtx, String portalXML) throws EJBException, R01MPortalModelException, R01MPortalModelObjectsValidatorException, R01MSecurityException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.services").info("\tR01GPortalAdminServicesSL.doSavePortal()...");
        }
        R01GPortalAdminManager service = new R01GPortalAdminManager();
        return service.doSaveBasePortal(userCtx, portalXML);
    }

    public void doUpdatePortalState(R01MUserContext userCtx, R01MPortal portal) throws EJBException, R01MPortalModelException, R01MPortalModelObjectsValidatorException, R01MSecurityException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.services").info("\tR01GPortalAdminServicesSL.doSavePortal()...");
        }
        R01GPortalAdminManager service = new R01GPortalAdminManager();
        service.doUpdatePortalState(userCtx, portal);
    }

    public String doLoadXMLPortal(R01MUserContext userCtx, String portalOid) throws EJBException, R01MPortalModelException, R01MSecurityException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.services").info("\tR01GPortalAdminServicesSL.doLoadXMLPortal()...");
        }
        R01GPortalAdminManager service = new R01GPortalAdminManager();
        return service.doLoadXMLPortal(userCtx, portalOid);
    }

    public void doDeletePortal(R01MUserContext userCtx, String portalOid) throws EJBException, R01MPortalModelException, R01MSecurityException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.services").info("\tR01GPortalAdminServicesSL.doDeletePortal()...");
        }
        R01GPortalAdminManager service = new R01GPortalAdminManager();
        service.doDeletePortal(userCtx, portalOid);
    }

    public List[] doRegeneratePortalDynamicVAs(R01MUserContext userCtx, String portalOid) throws EJBException, R01MSecurityException, R01MPortalModelException {
        String opDesc = "Regenerando las Areas Visuales del portal " + portalOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01g.services").info("MODEL SERVER (init): " + opDesc);
            }
            R01GPortalAdminManager admMgr = new R01GPortalAdminManager();
            List[] result = admMgr.doRegeneratePortalDynamicVAs(userCtx, portalOid);
            if (DEBUG) {
                R01FLog.to((String)"r01g.services").info("MODEL SERVER (end) : " + opDesc);
            }
            return result;
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
        catch (R01MPortalModelException pmEx) {
            throw new EJBException((Exception)((Object)pmEx));
        }
    }

    public List[] doRegeneratePortalDynamicVAsJMS(R01MUserContext userCtx, String portalOid) throws EJBException, R01MSecurityException, R01MPortalModelException {
        String opDesc = "Cargando las Areas Visuales ";
        List[] result = new List[2];
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01g.services").info("MODEL SERVER (init): " + opDesc);
            }
            R01GPortalAdminManager admMgr = new R01GPortalAdminManager();
            result = admMgr.doRegeneratePortalDynamicVAsJMS(userCtx, portalOid);
            if (DEBUG) {
                R01FLog.to((String)"r01g.services").info("MODEL SERVER (end) : " + opDesc);
            }
        }
        catch (R01MSecurityException secEx) {
            secEx.printStackTrace(System.out);
            throw new EJBException((Exception)((Object)secEx));
        }
        catch (R01MPortalModelException pmEx) {
            throw new EJBException((Exception)((Object)pmEx));
        }
        catch (EJBException ejbEx) {
            throw new EJBException((Exception)((Object)ejbEx));
        }
        return result;
    }

    public R01MOperationInModelObjectResult doRegenerateVA(R01MUserContext userCtx, String portalOid, String visualAreaOid, boolean bExecuteInmediateRegeneration, boolean bRegenerateOnlyDynamicVAs, String lang) throws EJBException, R01MSecurityException, R01MPortalModelException {
        String opDesc = "Regenerando el Area Visual de oid " + visualAreaOid + " del portal " + portalOid;
        if (DEBUG) {
            R01FLog.to((String)"r01g.services").info("MODEL SERVER (init): " + opDesc);
        }
        try {
            R01GPortalAdminManager admMgr = new R01GPortalAdminManager();
            R01MOperationInModelObjectResult result = admMgr.doRegenerateVA(userCtx, portalOid, visualAreaOid, bExecuteInmediateRegeneration, bRegenerateOnlyDynamicVAs, lang);
            if (DEBUG) {
                R01FLog.to((String)"r01g.services").info("MODEL SERVER (end) : " + opDesc);
            }
            return result;
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
        catch (R01MPortalModelException pmEx) {
            throw new EJBException((Exception)((Object)pmEx));
        }
    }

    public void doMigrateVisualArea(R01MUserContext userCtx, String portalOid, R01MVisualAreaInstance vaInstance) throws EJBException, R01MPortalModelException, R01MSecurityException {
        String opDesc = "Migrando el Area Visual de oid " + vaInstance.getOid() + " del portal " + portalOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01g.services").info("MODEL SERVER (init): " + opDesc);
            }
            R01GPortalAdminManager admMgr = new R01GPortalAdminManager();
            admMgr.doMigrateVisualArea(userCtx, portalOid, vaInstance);
            if (DEBUG) {
                R01FLog.to((String)"r01g.services").info("MODEL SERVER (end) : " + opDesc);
            }
        }
        catch (R01MPortalModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    private void _reloadCaches() {
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01g.cache").info("Notificando la recarga de caches de portales");
            }
            R01NCachesNotifierSLUtil.getHome().create().reloadPortalCache();
            if (DEBUG) {
                R01FLog.to((String)"r01g.cache").info("Fin notificaci\u00f3n de la recarga de caches de portales");
            }
        }
        catch (R01MJMSException jmsExc) {
            if (DEBUG) {
                R01FLog.to((String)"r01g.cache").severe("REGENERADOR: Error en la recarga de caches de portales:" + jmsExc.getMessage());
            }
            jmsExc.printStackTrace(System.out);
        }
        catch (RemoteException rmtExc) {
            if (DEBUG) {
                R01FLog.to((String)"r01g.cache").severe("REGENERADOR: No se encuentra el EJB de recarga de caches de portales:" + rmtExc.getMessage());
            }
            rmtExc.printStackTrace(System.out);
        }
        catch (CreateException crtExc) {
            if (DEBUG) {
                R01FLog.to((String)"r01g.cache").severe("REGENERADOR: No se puede crear el servicio de recarga de caches de portales:" + crtExc.getMessage());
            }
            crtExc.printStackTrace(System.out);
        }
        catch (NamingException namExc) {
            if (DEBUG) {
                R01FLog.to((String)"r01g.cache").severe("REGENERADOR: No se encuentra el EJB de recarga de portales:" + namExc.getMessage());
            }
            namExc.printStackTrace(System.out);
        }
        R01FLog.to((String)"r01g.services").info("%%%%%%%%%%%%%%%%% FIN PROCESO DE CARGA DE CACHES DE PORTALES ( " + new Date() + " )%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\r\n\r\n\r\n\r\n\r\n\r\n");
    }
}

