/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01j.services.messagepatternsmanager;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01j.ejb.messagesmanager.ejb.cmp.aggregator.R01JAggregatorRunningPacketCMPLocal;
import com.ejie.r01j.ejb.messagesmanager.ejb.cmp.aggregator.R01JAggregatorRunningPacketCMPUtil;
import com.ejie.r01j.ejb.messagesmanager.ejb.cmp.aggregator.R01JAggregatorRunningPacketCMPValue;
import com.ejie.r01p.objects.R01PAggregatorPacket;
import com.ejie.r01p.objects.R01PAggregatorPacketItem;
import com.ejie.r01p.utils.R01PConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

public class R01JMessagePatternsManager {
    private static final String LOG_TYPE_ID = "r01j.aggregatorManager";
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01j.aggregatorManager").intValue() != Level.OFF.intValue();

    public boolean newAggregatorRunningPacket(R01PAggregatorPacket packet) {
        try {
            R01JAggregatorRunningPacketCMPValue aggregatorRunningPacketVO = new R01JAggregatorRunningPacketCMPValue();
            aggregatorRunningPacketVO.setPacketOid(packet.getOid());
            aggregatorRunningPacketVO.setPacketDescriptor(XOManager.getXML((String)R01PConstants.AGGREGATOR_MAPFILE, (Object)packet));
            aggregatorRunningPacketVO.setPacketStartTime(new Date().getTime());
            aggregatorRunningPacketVO.setTimeout(packet.getTimeout());
            aggregatorRunningPacketVO.setNumberOfPendingItems(packet.getItemMap().size());
            aggregatorRunningPacketVO.setFinishedItemOids("");
            R01JAggregatorRunningPacketCMPUtil.getLocalHome().create(aggregatorRunningPacketVO);
        }
        catch (CreateException crtEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al crear el paquete en ejecuci\u00f3n " + packet.getOid() + " (" + packet.getExecutorClass() + " - " + packet.getExecutorMethod() + ")\n" + " >> Error: " + crtEx.getMessage());
            crtEx.printStackTrace(System.out);
            return false;
        }
        catch (NamingException nameEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("No se encuentra el EJB que gestiona el paquete en ejecuci\u00f3n " + packet.getOid() + " (" + packet.getExecutorClass() + " - " + packet.getExecutorMethod() + ")\n" + " >> Error: " + nameEx.getMessage());
            nameEx.printStackTrace(System.out);
            return false;
        }
        catch (XOMarshallerException xoEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al obtener el descriptor del paquete " + packet.getOid() + " (error al pasar de Objetos a XML)\n" + " >> Error: " + xoEx.getMessage());
            xoEx.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    public boolean receivedAggregatorResponseItem(R01PAggregatorPacketItem finishedItem) {
        Collection packetToUpdate;
        try {
            packetToUpdate = R01JAggregatorRunningPacketCMPUtil.getLocalHome().findByPacketOid(finishedItem.getPacketOid());
        }
        catch (FinderException ex) {
            R01FLog.to((String)LOG_TYPE_ID).warning("R01JMessagePatternsManager.receivedAggregatorResponseItem - No se encuentra el paquete " + finishedItem.getPacketOid() + ". No se hace nada\n");
            return false;
        }
        catch (NamingException nameEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("R01JMessagePatternsManager.receivedAggregatorResponseItem - No se encuentra el EJB que gestiona el paquete en ejecuci\u00f3n " + finishedItem.getPacketOid() + "\n" + " >> Error: " + nameEx.getMessage());
            nameEx.printStackTrace(System.out);
            return false;
        }
        for (R01JAggregatorRunningPacketCMPLocal aggregatorCurrentRunningPacket : packetToUpdate) {
            R01PAggregatorPacket packet;
            R01JAggregatorRunningPacketCMPValue aggregatorRunningPacketVO = aggregatorCurrentRunningPacket.getR01JAggregatorRunningPacketCMPValue();
            String finishedItemsString = aggregatorRunningPacketVO.getFinishedItemOids();
            ArrayList<Object> finishedItemOids = new ArrayList();
            if (!StringUtils.isEmptyString((String)finishedItemsString)) {
                finishedItemOids = new ArrayList<String>(Arrays.asList(aggregatorRunningPacketVO.getFinishedItemOids().split(",")));
            }
            if (finishedItemOids.contains(finishedItem.getOid())) continue;
            int pendingItems = aggregatorRunningPacketVO.getNumberOfPendingItems() - 1;
            finishedItemOids.add(finishedItem.getOid());
            try {
                packet = (R01PAggregatorPacket)XOManager.getObject((String)R01PConstants.AGGREGATOR_MAPFILE, (String)aggregatorRunningPacketVO.getPacketDescriptor());
            }
            catch (XOMarshallerException xoEx) {
                R01FLog.to((String)LOG_TYPE_ID).severe("R01JMessagePatternsManager.receivedAggregatorResponseItem - Error al mapear el descriptor del paquete: " + finishedItem.getPacketOid() + "\n" + " >> Error: " + xoEx.getMessage());
                xoEx.printStackTrace(System.out);
                return false;
            }
            ((R01PAggregatorPacketItem)packet.getItemMap().get(finishedItem.getOid())).setStates(finishedItem.getStates());
            try {
                aggregatorRunningPacketVO.setPacketDescriptor(XOManager.getXML((String)R01PConstants.AGGREGATOR_MAPFILE, (Object)packet));
            }
            catch (XOMarshallerException xoEx) {
                R01FLog.to((String)LOG_TYPE_ID).severe("R01JMessagePatternsManager.receivedAggregatorResponseItem - Error al parsear el paquete (objeto a XML): " + finishedItem.getPacketOid() + "\n" + " >> Error: " + xoEx.getMessage());
                xoEx.printStackTrace(System.out);
                return false;
            }
            aggregatorRunningPacketVO.setNumberOfPendingItems(pendingItems);
            StringBuffer sbFinishedOids = new StringBuffer();
            Iterator itOidItem = finishedItemOids.iterator();
            while (itOidItem.hasNext()) {
                sbFinishedOids.append((String)itOidItem.next()).append(',');
            }
            aggregatorRunningPacketVO.setFinishedItemOids(sbFinishedOids.substring(0, sbFinishedOids.length() - 1));
            aggregatorCurrentRunningPacket.setR01JAggregatorRunningPacketCMPValue(aggregatorRunningPacketVO);
            if (pendingItems != 0) continue;
            if (!this._executeDefinedActionInPacket(packet)) {
                return false;
            }
            try {
                aggregatorCurrentRunningPacket.remove();
            }
            catch (EJBException ejbEx) {
                R01FLog.to((String)LOG_TYPE_ID).severe("R01JMessagePatternsManager.receivedAggregatorResponseItem - Error al eliminar el paquete que ya ha sido procesado: " + finishedItem.getPacketOid() + "\n" + " >> Error: " + ejbEx.getMessage());
                ejbEx.printStackTrace(System.out);
                return false;
            }
            catch (RemoveException remEx) {
                R01FLog.to((String)LOG_TYPE_ID).severe("R01JMessagePatternsManager.receivedAggregatorResponseItem - Error al eliminar el paquete que ya ha sido procesado:  " + finishedItem.getPacketOid() + "\n" + " >> Error: " + remEx.getMessage());
                remEx.printStackTrace(System.out);
                return false;
            }
        }
        return true;
    }

    public boolean proccessAggregatorRunningPacketsInTimeout() {
        Collection packetToProccess;
        try {
            packetToProccess = R01JAggregatorRunningPacketCMPUtil.getLocalHome().findByTimeoutInSpecificTime(new Date().getTime());
        }
        catch (FinderException ex) {
            R01FLog.to((String)LOG_TYPE_ID).info("R01JMessagePatternsManager.proccessAggregatorRunningPacketsInTimeout - No se existen paquetes que hayan alcanzado el timeout para la hora: " + new Date().getTime() + ". " + "No se hace nada\n");
            return true;
        }
        catch (NamingException nameEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("R01JMessagePatternsManager.proccessAggregatorRunningPacketsInTimeout - No se encuentra el EJB que gestiona los paquetes que alcanzan el timeout.\n >> Error: " + nameEx.getMessage());
            nameEx.printStackTrace(System.out);
            return false;
        }
        boolean response = true;
        for (R01JAggregatorRunningPacketCMPLocal aggregatorCurrentRunningPacket : packetToProccess) {
            R01PAggregatorPacket packet;
            R01JAggregatorRunningPacketCMPValue aggregatorRunningPacketVO = aggregatorCurrentRunningPacket.getR01JAggregatorRunningPacketCMPValue();
            try {
                packet = (R01PAggregatorPacket)XOManager.getObject((String)R01PConstants.AGGREGATOR_MAPFILE, (String)aggregatorRunningPacketVO.getPacketDescriptor());
            }
            catch (XOMarshallerException xoEx) {
                R01FLog.to((String)LOG_TYPE_ID).severe("R01JMessagePatternsManager.proccessAggregatorRunningPacketsInTimeout - Error al mapear el descriptor del paquete: " + aggregatorRunningPacketVO.getPacketOid() + "\n" + " >> Error: " + xoEx.getMessage());
                xoEx.printStackTrace(System.out);
                response = false;
                continue;
            }
            if (packet.getActionInTimeout() == R01PAggregatorPacket.EXECUTE_FULL_PACKET_ACTION) {
                if (!this._executeDefinedActionInPacket(packet)) {
                    response = false;
                    continue;
                }
            } else if (packet.getActionInTimeout() == R01PAggregatorPacket.EXECUTE_RECEIVED_ELEMENTS_ACTION) {
                Map definedItemsInThePacket = packet.getItemMap();
                HashMap itemsToProcess = new HashMap();
                List<Object> receivedItemOids = new ArrayList();
                String finishedItemsString = aggregatorRunningPacketVO.getFinishedItemOids();
                if (finishedItemsString != null) {
                    receivedItemOids = Arrays.asList(aggregatorRunningPacketVO.getFinishedItemOids().split(","));
                }
                for (String itemOid : receivedItemOids) {
                    if (!definedItemsInThePacket.containsKey(itemOid)) continue;
                    itemsToProcess.put(itemOid, definedItemsInThePacket.get(itemOid));
                }
                packet.setItemMap(itemsToProcess);
                if (!this._executeDefinedActionInPacket(packet)) {
                    response = false;
                    continue;
                }
            } else if (packet.getActionInTimeout() != R01PAggregatorPacket.RESET_ACTION && packet.getActionInTimeout() == R01PAggregatorPacket.NOTHING_ACTION && DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("R01JMessagePatternsManager.proccessAggregatorRunningPacketsInTimeout - El paquete " + packet.getOid() + " ha llegado al timeout definido y " + "no ha recibido respuesta de todos sus items. Para este paquete se ha definido que no se realice ninguna acci\u00f3n en este caso.\n" + "Datos del paquete;:\n" + "\t- OID: " + packet.getOid() + "\n" + "\t- TIMEOUT:" + packet.getTimeout() + "\n" + "\t- ACTION IN TIMEOUT:" + packet.getActionInTimeout() + "\n" + "\t- CLASS TO EXECUTE:" + packet.getExecutorClass() + "\n" + "\t- METHOD TO EXECUTE:" + packet.getExecutorMethod() + "\n" + "\t- DESCRIPTOR DEL PAQUETE:" + aggregatorRunningPacketVO.getPacketDescriptor() + "\n");
            }
            try {
                aggregatorCurrentRunningPacket.remove();
            }
            catch (EJBException ejbEx) {
                R01FLog.to((String)LOG_TYPE_ID).severe("R01JMessagePatternsManager.proccessAggregatorRunningPacketsInTimeout - Error al eliminar el paquete que ya ha sido procesado: " + packet.getOid() + "\n" + " >> Error: " + ejbEx.getMessage());
                ejbEx.printStackTrace(System.out);
                response = false;
            }
            catch (RemoveException remEx) {
                R01FLog.to((String)LOG_TYPE_ID).severe("R01JMessagePatternsManager.proccessAggregatorRunningPacketsInTimeout - Error al eliminar el paquete que ya ha sido procesado:  " + packet.getOid() + "\n" + " >> Error: " + remEx.getMessage());
                remEx.printStackTrace(System.out);
                response = false;
            }
        }
        return response;
    }

    private boolean _executeDefinedActionInPacket(R01PAggregatorPacket packet) {
        String executionClassName = packet.getExecutorClass();
        String executionMethodName = packet.getExecutorMethod();
        try {
            Object instance = ReflectionUtils.getObjectInstance((String)executionClassName, null, null, (boolean)true);
            ReflectionUtils.invokeMethod((Object)instance, (String)executionMethodName, (Class[])new Class[]{R01PAggregatorPacket.class}, (Object[])new Object[]{packet});
        }
        catch (ReflectionException refEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("R01JMessagePatternsManager._executeDefinedActionInPacket - Error al invocar la llamada al metodo del paquete: " + packet.getOid() + " " + "(" + executionClassName + "." + executionMethodName + ") " + "\u00bfExiste esa clase y m\u00e9todo?\n" + " >> Error: " + refEx.getMessage());
            refEx.printStackTrace(System.out);
            return false;
        }
        catch (Throwable th) {
            R01FLog.to((String)LOG_TYPE_ID).severe("R01JMessagePatternsManager._executeDefinedActionInPacket - Error en la ejecuci\u00f3n de la llamada al metodo del paquete: " + packet.getOid() + " " + "(" + executionClassName + "." + executionMethodName + ")\n" + " >> Error: " + th.getMessage());
            th.printStackTrace(System.out);
            return false;
        }
        return true;
    }
}

