/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01n.ejb.notifier;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.exceptions.R01MJMSException;
import com.ejie.r01m.utils.R01MConstants;
import java.rmi.RemoteException;
import java.util.Properties;
import java.util.logging.Level;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class R01NCachesNotifierSLBaseBean
implements SessionBean {
    private static final long serialVersionUID = 1188667769308781893L;
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01n.cache").intValue() != Level.OFF.intValue();
    private SessionContext context;

    public void setSessionContext(SessionContext newContext) throws EJBException {
        if (DEBUG) {
            R01FLog.to((String)"r01n.cache").info("\tsetSessionContext()");
        }
        this.context = newContext;
    }

    public void ejbRemove() throws EJBException, RemoteException {
        if (DEBUG) {
            R01FLog.to((String)"r01n.cache").info("\tejbRemove()");
        }
    }

    public void ejbActivate() throws EJBException, RemoteException {
        if (DEBUG) {
            R01FLog.to((String)"r01n.cache").info("\tejbActivate()");
        }
    }

    public void ejbPassivate() throws EJBException, RemoteException {
        if (DEBUG) {
            R01FLog.to((String)"r01n.cache").info("\tejbPassivate()");
        }
    }

    public void ejbCreate() throws CreateException {
        if (DEBUG) {
            R01FLog.to((String)"r01n.cache").info("\tejbCreate()");
        }
    }

    public void reloadConfigCache() throws R01MJMSException {
        this._sendReloadNotify("reloadConfigCache", "allAdminConfig", null);
    }

    public void reloadEntitiesConfigCache() throws R01MJMSException {
        this._sendReloadNotify("reloadConfigCache", "entitiesConfig", null);
    }

    public void reloadLinkedRelationsConfigCache() throws R01MJMSException {
        this._sendReloadNotify("reloadConfigCache", "linkedRelationsConfig", null);
    }

    public void reloadResourcesContainerConfigCache() throws R01MJMSException {
        this._sendReloadNotify("reloadConfigCache", "resourcesContainerConfig", null);
    }

    public void reloadStorageConfigCache() throws R01MJMSException {
        this._sendReloadNotify("reloadConfigCache", "storageConfig", null);
    }

    public void reloadTypologyConfigCache() throws R01MJMSException {
        this._sendReloadNotify("reloadConfigCache", "typologyConfig", null);
    }

    public void reloadTypologyManagementConfigCache() throws R01MJMSException {
        this._sendReloadNotify("reloadConfigCache", "typologyManagementConfig", null);
    }

    public void reloadSearchMetadataStorageConfigCache() throws R01MJMSException {
        this._sendReloadNotify("reloadConfigCache", "searchMetaDataStorageConfig", null);
    }

    public void reloadMiscellaneousConfigCache() throws R01MJMSException {
        this._sendReloadNotify("reloadConfigCache", "miscellaneousConfig", null);
    }

    public void reloadCatalogCache() throws R01MJMSException {
        this._sendReloadNotify("reloadConfigCache", "allCatalogConfig", null);
    }

    public void reloadPortalCache() throws R01MJMSException {
        this._sendReloadNotify("reloadConfigCache", "allPortalConfig", null);
    }

    public void resetPortalTemplatesCache() throws R01MJMSException {
        Properties props = new Properties();
        props.put("action", "1");
        this._sendReloadNotify("r01PortalTemplatesCache", "", props);
    }

    public void reloadSearchEngineCache() throws R01MJMSException {
        this._sendReloadNotify("reloadConfigCache", "searchEngineConfig", null);
    }

    private void _sendReloadNotify(String msgType, String cacheType, Properties props) throws R01MJMSException {
        block20: {
            TopicConnectionFactory topicConnectionFactory;
            InitialContext jndiContext;
            if (DEBUG) {
                R01FLog.to((String)"r01n.cache").info("Enviando el paquete para RECARGA DE CACHES !!!!!!!!!!!!!!!!");
            }
            try {
                jndiContext = new InitialContext();
                topicConnectionFactory = (TopicConnectionFactory)jndiContext.lookup(XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"canalesyserviciosJMSConfig/canalesyserviciosConnectionFactory", (String)"r01.r01JMSConnectionFactory"));
            }
            catch (NamingException namExc) {
                R01FLog.to((String)"r01n.cache").severe("Error obteniendo la factor\u00eda JMS de recarga de caches. Error:" + namExc.getMessage());
                throw new R01MJMSException("Error obteniendo la factor\u00eda JMS de recarga de caches.", (Exception)namExc);
            }
            Topic topicCache = null;
            try {
                topicCache = (Topic)jndiContext.lookup(XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"canalesyserviciosJMSConfig/reloadCacheJMS", (String)"r01n.r01nJMSTopic"));
            }
            catch (NamingException namExc) {
                R01FLog.to((String)"r01n.cache").severe("Error obteniendo la cola JMS de recarga de caches. Error:" + namExc.getMessage());
                throw new R01MJMSException("Error obteniendo la cola JMS de recarga de cahes.", (Exception)namExc);
            }
            TopicConnection topicConnection = null;
            try {
                R01FLog.to((String)"r01n.cache").info("Abrir una conexi\u00f3n JMS para notificar la recarga de caches.");
                topicConnection = topicConnectionFactory.createTopicConnection();
                if (topicConnection != null && topicCache != null) {
                    TopicSession topicSession = topicConnection.createTopicSession(false, 1);
                    TopicPublisher publishCache = topicSession.createPublisher(topicCache);
                    Message message = topicSession.createMessage();
                    message.setJMSType(msgType);
                    message.setStringProperty("ControlDestination", msgType);
                    message.setStringProperty("cacheType", StringUtils.isEmptyString((String)cacheType) ? "" : cacheType);
                    if (props != null) {
                        for (String string : props.keySet()) {
                            String value = props.getProperty(string);
                            message.setStringProperty(string, value);
                        }
                    }
                    if (!StringUtils.isEmptyString((String)cacheType)) {
                        R01FLog.to((String)"r01n.cache").info("Enviando el mensaje de recarga de la cache \"" + cacheType + "\".");
                    } else {
                        R01FLog.to((String)"r01n.cache").info("Enviando el mensaje de tipo \"" + msgType + "\".");
                    }
                    publishCache.publish(message);
                    break block20;
                }
                R01FLog.to((String)"r01n.cache").severe("ERROR:La conexi\u00f3n o el publicador es NULO.");
                throw new R01MJMSException("ERROR:La conexi\u00f3n o el publicador es NULO.");
            }
            catch (JMSException jmsExc) {
                R01FLog.to((String)"r01n.cache").severe("Error en el env\u00edo del mensaje de recarga de caches. Error:" + jmsExc.getMessage());
                throw new R01MJMSException("Error en el env\u00edo del mensaje de recarga de caches.", (Exception)((Object)jmsExc));
            }
            finally {
                if (topicConnection != null) {
                    try {
                        topicConnection.close();
                    }
                    catch (JMSException jmsExc) {
                        R01FLog.to((String)"r01n.cache").severe("No se ha podido cerrar la conexi\u00f3n con la cola de mensajes. Error:" + jmsExc.getMessage());
                    }
                }
            }
        }
    }
}

