/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01n.ejb.mdb.listener.cache;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.DateUtils;
import com.ejie.r01m.config.objects.container.R01MResourcesContainerManagementConfig;
import com.ejie.r01m.config.objects.storage.R01MDataRepository;
import com.ejie.r01m.config.objects.storage.R01MServer;
import com.ejie.r01m.objects.contentmodel.R01MLinkedRelationsGroup;
import com.ejie.r01m.services.R01MClientFactory;
import java.util.Date;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;

public class R01NReloadCachesMDBBean
implements MessageDrivenBean,
MessageListener {
    private static final long serialVersionUID = -5856563223325258407L;
    private static final String SEP = "~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~";
    private static final String START_SEP = "\r\n\r\n\r\n\r\n~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~";
    private static final String END_SEP = "~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~\r\n\r\n\r\n\r\n";
    private static final String LOGGER_RELOADCACHES = "r01m.loadConfigOnStartup";
    private MessageDrivenContext context;
    private static boolean isReloadActive = false;

    public void setMessageDrivenContext(MessageDrivenContext newContext) throws EJBException {
        R01FLog.to((String)LOGGER_RELOADCACHES).info("\tR01NReloadCachesMDBBean.setMessageDrivenContext()");
        this.context = newContext;
    }

    public void ejbRemove() throws EJBException {
        R01FLog.to((String)LOGGER_RELOADCACHES).info("\tR01NReloadCachesMDBBean.ejbRemove()");
    }

    public void ejbCreate() throws CreateException {
        R01FLog.to((String)LOGGER_RELOADCACHES).info("\tR01NReloadCachesMDBBean.ejbCreate()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        block28: {
            if (!isReloadActive) {
                isReloadActive = true;
                R01FLog.to((String)LOGGER_RELOADCACHES).info("\ttR01NReloadCachesMDBBean.onMessage()");
                try {
                    Map servers;
                    if (!msg.getJMSType().equals("reloadConfigCache")) break block28;
                    R01FLog.to((String)LOGGER_RELOADCACHES).info("CACHE RELOAD >> Mensaje de actualizar cach\u00e9 Apps recibido <<<<<<<<<<<>>>>>>>>>>>>");
                    String cacheType = null;
                    try {
                        cacheType = msg.getStringProperty("cacheType");
                        R01FLog.to((String)LOGGER_RELOADCACHES).info("CACHE RELOAD >> Reload de cache Apps " + cacheType);
                    }
                    catch (JMSException jmsExc) {
                        R01FLog.to((String)LOGGER_RELOADCACHES).severe("CACHE RELOAD >> Error al recoger el mensaje de recarga de cach\u00e9 Apps de la cola.Error:" + jmsExc.getMessage());
                        isReloadActive = false;
                        return;
                    }
                    if (cacheType.equals("allAdminConfig")) {
                        this._loadConfigurations();
                    } else if (cacheType.equals("entitiesConfig")) {
                        this._loadEntitiesConfig(true);
                    } else if (cacheType.equals("linkedRelationsConfig")) {
                        this._loadLinkedRelationsConfig(true);
                    } else if (cacheType.equals("resourcesContainerConfig")) {
                        this._loadResourcesContainerConfig(true);
                    } else if (cacheType.equals("storageConfig")) {
                        this._loadStorageConfig(true);
                    } else if (cacheType.equals("typologyConfig")) {
                        this._loadTypologyConfig(true);
                    } else if (cacheType.equals("typologyManagementConfig")) {
                        servers = this._loadStorageConfig(true);
                        this._loadTypologyManagementConfig(servers, true);
                    } else if (cacheType.equals("searchMetaDataStorageConfig")) {
                        servers = this._loadStorageConfig(true);
                        this._loadSearchMetaDataStorageConfig(servers, true);
                    } else if (cacheType.equals("miscellaneousConfig")) {
                        this._loadMiscellaneousDataConfig();
                    }
                    long dateTS = DateUtils.getDateAsMillis((Date)new Date());
                    R01MClientFactory.getConfigLoadersTimingAPI().setLoadTimeStamp(dateTS);
                    R01FLog.to((String)LOGGER_RELOADCACHES).info("%%%%%%%%%%%%%%%%% SERVIDOR DE CARGA DE CONFIGURACIONES APPS DEL GESTOR DE CONTENIDOS INICIADO (" + DateUtils.getDateFormated((Date)DateUtils.getDateFromMillis((long)dateTS), (String)"dd/MM/yyyy hh:mm:ss") + ")%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                    R01FLog.to((String)LOGGER_RELOADCACHES).severe("ERROR GENERAL EN onMessage DE LA CLASE R01NReloadCachesMDBBean.Error:" + e.getMessage());
                }
                catch (Throwable th) {
                    th.printStackTrace(System.out);
                    R01FLog.to((String)LOGGER_RELOADCACHES).severe("ERROR GENERAL EN onMessage DE LA CLASE R01NReloadCachesMDBBean.Error:" + th.getMessage());
                }
                finally {
                    isReloadActive = false;
                }
            }
        }
    }

    private void _loadConfigurations() {
        R01FLog.to((String)LOGGER_RELOADCACHES).info("\r\n\r\n\r\n%%%%%%%%%%%%%%%%% CARGANDO CONFIGURACIONES APPS DEL GESTOR DE CONTENIDOS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        try {
            R01MClientFactory.getConfigLoadersTimingAPI().startLoadingConfig();
            this._loadTypologyConfig(true);
            Map servers = this._loadStorageConfig(true);
            this._loadTypologyManagementConfig(servers, true);
            this._loadSearchMetaDataStorageConfig(servers, true);
            this._loadMiscellaneousDataConfig();
            this._loadEntitiesConfig(true);
            this._loadLinkedRelationsConfig(true);
            this._loadResourcesContainerConfig(true);
        }
        catch (Exception ex) {
            R01FLog.to((String)LOGGER_RELOADCACHES).severe("%%%%%%%%%%%%%%%%% SERVIDOR DE CARGA DE CONFIGURACIONES APPS.Error en carga de TODAS las configuraciones. " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    private Map _loadStorageConfig(boolean reset) {
        String opDesc = "configuraci\u00f3n de almacenamiento";
        R01FLog.to((String)LOGGER_RELOADCACHES).info("\r\n\r\n\r\n\r\n~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~CARGA de configuraci\u00f3n de almacenamiento");
        Map servers = null;
        try {
            if (reset) {
                R01MClientFactory.getStorageConfigAPI().reset();
            }
            servers = R01MClientFactory.getStorageConfigAPI().getAllServerConfig();
        }
        catch (Exception ex) {
            R01FLog.to((String)LOGGER_RELOADCACHES).severe("Error en carga de configuraci\u00f3n de almacenamiento: " + ex.getMessage());
            ex.printStackTrace();
        }
        R01FLog.to((String)LOGGER_RELOADCACHES).info("FIN DE CARGA de configuraci\u00f3n de almacenamiento~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~\r\n\r\n\r\n\r\n");
        return servers;
    }

    private void _loadTypologyConfig(boolean reset) {
        String opDesc = "configuaci\u00f3n de tipolog\u00edas";
        R01FLog.to((String)LOGGER_RELOADCACHES).info("\r\n\r\n\r\n\r\n~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~CARGA de " + opDesc);
        try {
            String[] clusterOids = R01MClientFactory.getTypologyConfigAPI().loadClustersOids();
            if (reset) {
                R01MClientFactory.getTypologyConfigAPI().reset();
            }
            if (clusterOids != null && clusterOids.length > 0) {
                for (int i = 0; i < clusterOids.length; ++i) {
                    R01MClientFactory.getTypologyConfigAPI().getClusterConfig(clusterOids[i]);
                }
            }
        }
        catch (Exception ex) {
            R01FLog.to((String)LOGGER_RELOADCACHES).severe("Error en carga de " + opDesc + ": " + ex.getMessage());
            ex.printStackTrace();
        }
        R01FLog.to((String)LOGGER_RELOADCACHES).info("FIN DE CARGA de " + opDesc + END_SEP);
    }

    private void _loadTypologyManagementConfig(Map servers, boolean reset) {
        String opDesc = "configuraci\u00f3n de gesti\u00f3n de tipolog\u00edas";
        R01FLog.to((String)LOGGER_RELOADCACHES).info("\r\n\r\n\r\n\r\n~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~CARGA de " + opDesc);
        try {
            Map reloadServers = null;
            reloadServers = servers == null ? R01MClientFactory.getStorageConfigAPI().getAllServerConfig() : servers;
            if (reloadServers != null) {
                if (reset) {
                    R01MClientFactory.getTypologyManagementConfigAPI().reset();
                }
                for (Map.Entry me : reloadServers.entrySet()) {
                    R01MServer server = (R01MServer)me.getValue();
                    Map datarepo = server.getDataRepositories();
                    for (Map.Entry meDatarepo : datarepo.entrySet()) {
                        R01MDataRepository datarepository = (R01MDataRepository)meDatarepo.getValue();
                        R01MClientFactory.getTypologyManagementConfigAPI().getTypologyManagementConfig(server.getOid(), datarepository.getOid());
                    }
                }
            } else {
                R01FLog.to((String)LOGGER_RELOADCACHES).warning("La carga de " + opDesc + " es VACIA. Revisar la configuraci\u00f3n.");
            }
        }
        catch (Exception ex) {
            R01FLog.to((String)LOGGER_RELOADCACHES).severe("Error en carga de " + opDesc + ": " + ex.getMessage());
            ex.printStackTrace();
        }
        R01FLog.to((String)LOGGER_RELOADCACHES).info("FIN DE CARGA de " + opDesc + END_SEP);
    }

    private void _loadSearchMetaDataStorageConfig(Map servers, boolean reset) {
        String opDesc = "almacenamiento de metaDatos para la b\u00fasqueda";
        R01FLog.to((String)LOGGER_RELOADCACHES).info("\r\n\r\n\r\n\r\n~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~CARGA de " + opDesc);
        try {
            Map serversLoaded = servers;
            if (servers == null) {
                serversLoaded = R01MClientFactory.getStorageConfigAPI().getAllServerConfig();
            }
            if (reset) {
                R01MClientFactory.getSearchMetaDataStorageConfigAPI().reset();
            }
            for (Map.Entry me : serversLoaded.entrySet()) {
                R01MServer server = (R01MServer)me.getValue();
                Map datarepo = server.getDataRepositories();
                for (Map.Entry meDatarepo : datarepo.entrySet()) {
                    R01MDataRepository datarepository = (R01MDataRepository)meDatarepo.getValue();
                    R01MClientFactory.getSearchMetaDataStorageConfigAPI().getSearchMetaDataStorageConfig(server.getOid(), datarepository.getOid());
                }
            }
        }
        catch (Exception ex) {
            R01FLog.to((String)LOGGER_RELOADCACHES).severe("Error en carga de " + opDesc + ": " + ex.getMessage());
            ex.printStackTrace(System.out);
        }
        R01FLog.to((String)LOGGER_RELOADCACHES).info("FIN DE CARGA de " + opDesc + END_SEP);
    }

    private void _loadMiscellaneousDataConfig() {
        String opDesc = "configuraci\u00f3n de datos miscelaneos";
        R01FLog.to((String)LOGGER_RELOADCACHES).info("\r\n\r\n\r\n\r\n~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~CARGA de " + opDesc);
        try {
            R01MClientFactory.getMiscellaneousAPI().getDeepthLevels("es");
            R01MClientFactory.getMiscellaneousAPI().getDeepthLevels("eu");
            R01MClientFactory.getMiscellaneousAPI().getEvents("es");
            R01MClientFactory.getMiscellaneousAPI().getEvents("eu");
            R01MClientFactory.getMiscellaneousAPI().getLanguages("es");
            R01MClientFactory.getMiscellaneousAPI().getLanguages("eu");
            R01MClientFactory.getMiscellaneousAPI().getStatus("es");
            R01MClientFactory.getMiscellaneousAPI().getStatus("eu");
            R01MClientFactory.getMiscellaneousAPI().getUpdatePeriods("es");
            R01MClientFactory.getMiscellaneousAPI().getUpdatePeriods("eu");
        }
        catch (Exception ex) {
            R01FLog.to((String)LOGGER_RELOADCACHES).severe("Error en carga de " + opDesc + ": " + ex.getMessage());
            ex.printStackTrace(System.out);
        }
        R01FLog.to((String)LOGGER_RELOADCACHES).info("FIN DE CARGA de " + opDesc + END_SEP);
    }

    private Map _loadEntitiesConfig(boolean reset) {
        String opDesc = "configuraci\u00f3n de entidades";
        R01FLog.to((String)LOGGER_RELOADCACHES).info("\r\n\r\n\r\n\r\n~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~CARGA de configuraci\u00f3n de entidades");
        Map groups = null;
        try {
            if (reset) {
                R01MClientFactory.getEntitiesConfigAPI().reset();
            }
            groups = R01MClientFactory.getEntitiesConfigAPI().getAllGroupConfig();
        }
        catch (Exception ex) {
            R01FLog.to((String)LOGGER_RELOADCACHES).severe("Error en carga de configuraci\u00f3n de entidades: " + ex.getMessage());
            ex.printStackTrace();
        }
        R01FLog.to((String)LOGGER_RELOADCACHES).info("FIN DE CARGA de configuraci\u00f3n de entidades~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~\r\n\r\n\r\n\r\n");
        return groups;
    }

    private R01MLinkedRelationsGroup _loadLinkedRelationsConfig(boolean reset) {
        String opDesc = "configuraci\u00f3n de relaciones";
        R01FLog.to((String)LOGGER_RELOADCACHES).info("\r\n\r\n\r\n\r\n~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~CARGA de configuraci\u00f3n de relaciones");
        R01MLinkedRelationsGroup linkedRelations = null;
        try {
            if (reset) {
                R01MClientFactory.getLinkedRelationsConfigAPI().reset();
            }
            linkedRelations = R01MClientFactory.getLinkedRelationsConfigAPI().getLinkedRelationsConfig();
        }
        catch (Exception ex) {
            R01FLog.to((String)LOGGER_RELOADCACHES).severe("Error en carga de configuraci\u00f3n de relaciones: " + ex.getMessage());
            ex.printStackTrace();
        }
        R01FLog.to((String)LOGGER_RELOADCACHES).info("FIN DE CARGA de configuraci\u00f3n de relaciones~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~\r\n\r\n\r\n\r\n");
        return linkedRelations;
    }

    private R01MResourcesContainerManagementConfig _loadResourcesContainerConfig(boolean reset) {
        String opDesc = "configuraci\u00f3n de contenedores de recursos";
        R01FLog.to((String)LOGGER_RELOADCACHES).info("\r\n\r\n\r\n\r\n~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~CARGA de configuraci\u00f3n de contenedores de recursos");
        R01MResourcesContainerManagementConfig resourcesContainersCfg = null;
        try {
            if (reset) {
                R01MClientFactory.getResourcesContainerConfigAPI().reset();
            }
            resourcesContainersCfg = R01MClientFactory.getResourcesContainerConfigAPI().getResourcesContainerConfig();
        }
        catch (Exception ex) {
            R01FLog.to((String)LOGGER_RELOADCACHES).severe("Error en carga de configuraci\u00f3n de contenedores de recursos: " + ex.getMessage());
            ex.printStackTrace();
        }
        R01FLog.to((String)LOGGER_RELOADCACHES).info("FIN DE CARGA de configuraci\u00f3n de contenedores de recursos~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~i~~\r\n\r\n\r\n\r\n");
        return resourcesContainersCfg;
    }
}

