/*
 * Decompiled with CFR 0.152.
 */
package es.ejie.frmk.infraestructura.logs.incidencias;

import es.ejie.frmk.infraestructura.logs.base.Q70LogInterno;
import es.ejie.frmk.infraestructura.logs.base.Q70Mensaje;
import es.ejie.frmk.infraestructura.logs.base.interfaces.Q70Log;
import es.ejie.frmk.infraestructura.logs.base.interfaces.Q70LogFlushable;
import es.ejie.frmk.infraestructura.logs.incidencias.Q70LogIncidenciasInterface;
import es.ejie.frmk.infraestructura.logs.incidencias.Q70LogIncidenciasServidor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;

public class Q70LogIncidencias
implements Q70LogIncidenciasInterface,
Q70LogFlushable {
    private static Q70LogIncidencias logIncidencias;
    protected static final String GRAVEDAD_DEFECTO = "ERROR";
    protected static final String COMPONENTE_DEFECTO = "GESTOR DE EXCEPCIONES";
    private Q70Log log;

    private Q70LogIncidencias() {
    }

    public static synchronized Q70LogIncidencias getSingleton() {
        if (logIncidencias == null) {
            logIncidencias = new Q70LogIncidencias();
        }
        return logIncidencias;
    }

    public void log(Throwable throwable) {
        if (this.log == null) {
            Q70LogIncidenciasServidor.getSingleton().log(throwable);
            return;
        }
        if (Q70LogIncidenciasServidor.getSingleton().isEnabled()) {
            Q70LogIncidenciasServidor.getSingleton().log(throwable);
        }
        if (this.log.isEnabled()) {
            this.doLog(throwable, COMPONENTE_DEFECTO, GRAVEDAD_DEFECTO);
        }
    }

    public void log(Throwable throwable, String string) {
        if (this.log == null) {
            Q70LogIncidenciasServidor.getSingleton().log(throwable, string);
            return;
        }
        if (Q70LogIncidenciasServidor.getSingleton().isEnabled()) {
            Q70LogIncidenciasServidor.getSingleton().log(throwable, string);
        }
        if (this.log.isEnabled()) {
            this.doLog(throwable, string, GRAVEDAD_DEFECTO);
        }
    }

    public void log(Throwable throwable, String string, String string2) {
        if (this.log == null) {
            Q70LogIncidenciasServidor.getSingleton().log(throwable, string, string2);
            return;
        }
        if (Q70LogIncidenciasServidor.getSingleton().isEnabled()) {
            Q70LogIncidenciasServidor.getSingleton().log(throwable, string, string2);
        }
        if (this.log.isEnabled()) {
            this.doLog(throwable, string, string2);
        }
    }

    private void doLog(Throwable throwable, String string, String string2) {
        Q70Mensaje q70Mensaje = new Q70Mensaje();
        if (throwable != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            String string3 = "\n" + stringWriter.toString();
            q70Mensaje.put("EXCEPCION", throwable.getMessage());
            q70Mensaje.put("PILA", string3);
        } else {
            q70Mensaje.put("EXCEPCION", null);
            q70Mensaje.put("PILA", null);
        }
        q70Mensaje.put("COMPONENTE", string);
        q70Mensaje.put("GRAVEDAD", string2);
        try {
            this.log.log((Map)q70Mensaje);
        }
        catch (NullPointerException nullPointerException) {
            Q70LogInterno.log((String)q70Mensaje.toString());
        }
    }

    public boolean isEnabled() {
        if (this.log == null) {
            return Q70LogIncidenciasServidor.getSingleton().isEnabled();
        }
        return this.log.isEnabled() || Q70LogIncidenciasServidor.getSingleton().isEnabled();
    }

    public void setLog(Q70Log q70Log) {
        this.log = q70Log;
    }

    public void flush() {
        this.log.flush();
    }
}

