/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.model;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.displaytag.decorator.ColumnDecorator;
import org.displaytag.util.Href;
import org.displaytag.util.HtmlAttributeMap;
import org.displaytag.util.HtmlTagUtil;
import org.displaytag.util.MultipleHtmlAttribute;

public class HeaderCell {
    private HtmlAttributeMap htmlAttributes;
    private HtmlAttributeMap headerAttributes;
    private Href href;
    private String paramName;
    private String paramProperty;
    private String title;
    private boolean sortable;
    private ColumnDecorator columnDecorator;
    private int columnNumber;
    private boolean alreadySorted;
    private String beanPropertyName;
    private boolean showNulls;
    private int maxLength;
    private int maxWords;
    private boolean autoLink;
    private int group;

    public int getGroup() {
        return this.group;
    }

    public void setGroup(int groupingOrder) {
        this.group = groupingOrder;
    }

    public boolean getAutoLink() {
        return this.autoLink;
    }

    public void setAutoLink(boolean autoLinkEnabled) {
        this.autoLink = autoLinkEnabled;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int numOfChars) {
        this.maxLength = numOfChars;
    }

    public int getMaxWords() {
        return this.maxWords;
    }

    public void setMaxWords(int numOfWords) {
        this.maxWords = numOfWords;
    }

    public boolean getShowNulls() {
        return this.showNulls;
    }

    public void setShowNulls(boolean outputNulls) {
        this.showNulls = outputNulls;
    }

    public String getBeanPropertyName() {
        return this.beanPropertyName;
    }

    public void setBeanPropertyName(String propertyName) {
        this.beanPropertyName = propertyName;
    }

    public boolean isAlreadySorted() {
        return this.alreadySorted;
    }

    public void setAlreadySorted() {
        this.alreadySorted = true;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void setColumnNumber(int number) {
        this.columnNumber = number;
    }

    public ColumnDecorator getColumnDecorator() {
        return this.columnDecorator;
    }

    public void setColumnDecorator(ColumnDecorator decorator) {
        this.columnDecorator = decorator;
    }

    public boolean getSortable() {
        return this.sortable;
    }

    public void setSortable(boolean isSortable) {
        this.sortable = isSortable;
    }

    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        if (this.beanPropertyName != null) {
            return StringUtils.capitalize((String)this.beanPropertyName);
        }
        return "";
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public HtmlAttributeMap getHtmlAttributes() {
        return this.htmlAttributes;
    }

    public void setHtmlAttributes(HtmlAttributeMap attributes) {
        this.htmlAttributes = attributes;
    }

    public HtmlAttributeMap getHeaderAttributes() {
        return this.headerAttributes;
    }

    public void setHeaderAttributes(HtmlAttributeMap attributes) {
        this.headerAttributes = attributes;
    }

    public void addHeaderClass(String cssClass) {
        Object classAttributes = this.headerAttributes.get("class");
        if (classAttributes == null) {
            this.headerAttributes.put("class", new MultipleHtmlAttribute(cssClass));
        } else {
            ((MultipleHtmlAttribute)classAttributes).addAttributeValue(cssClass);
        }
    }

    public String getOpenTag() {
        return HtmlTagUtil.createOpenTagString("td", this.htmlAttributes);
    }

    public String getHeaderOpenTag() {
        return HtmlTagUtil.createOpenTagString("th", this.headerAttributes);
    }

    public String getCloseTag() {
        return "</td>";
    }

    public String getHeaderCloseTag() {
        return "</th>";
    }

    public void setHref(Href baseHref) {
        this.href = baseHref;
    }

    public Href getHref() {
        return this.href;
    }

    public void setParamName(String name) {
        this.paramName = name;
    }

    public String getParamName() {
        return this.paramName;
    }

    public void setParamProperty(String property) {
        this.paramProperty = property;
    }

    public String getParamProperty() {
        return this.paramProperty;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.DEFAULT_STYLE).append("columnNumber", this.columnNumber).append("title", (Object)this.title).append("beanPropertyName", (Object)this.beanPropertyName).toString();
    }
}

