/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.decorator;

import java.beans.PropertyDescriptor;
import java.util.HashMap;
import javax.servlet.jsp.PageContext;
import org.apache.commons.beanutils.PropertyUtils;

abstract class Decorator {
    private PageContext pageContext;
    private static HashMap propertyMap = new HashMap();
    private Object decoratedObject;

    Decorator() {
    }

    public void init(PageContext context, Object decorated) {
        this.pageContext = context;
        this.decoratedObject = decorated;
    }

    public PageContext getPageContext() {
        return this.pageContext;
    }

    public Object getDecoratedObject() {
        return this.decoratedObject;
    }

    public void finish() {
        this.pageContext = null;
        this.decoratedObject = null;
    }

    public boolean searchGetterFor(String propertyName) {
        PropertyDescriptor[] descriptors = PropertyUtils.getPropertyDescriptors(this.getClass());
        int j = 0;
        while (j < descriptors.length) {
            if (propertyName.equals(descriptors[j].getName())) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public boolean hasGetterFor(String propertyName) {
        Boolean cachedResult;
        String simpleProperty = propertyName;
        if (simpleProperty != null && simpleProperty.indexOf(".") > 0) {
            simpleProperty = simpleProperty.substring(0, simpleProperty.indexOf("."));
        }
        if ((cachedResult = (Boolean)propertyMap.get(this.getClass().getName() + "#" + simpleProperty)) != null) {
            return cachedResult;
        }
        boolean hasGetter = this.searchGetterFor(simpleProperty);
        propertyMap.put(this.getClass().getName() + "#" + simpleProperty, new Boolean(hasGetter));
        return hasGetter;
    }
}

