/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.utils.urlreferencer;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01m.exceptions.R01MPortalModelException;
import com.ejie.r01m.objects.link.R01MLinkItem;
import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.objects.urlreference.R01MHtmlLink;
import com.ejie.r01m.objects.urlreference.R01MUrlReference;
import com.ejie.r01m.objects.urlreference.R01MUrlReferencePresentationPage;
import com.ejie.r01m.objects.urlreference.R01MUrlReferenceWindowAppearance;
import com.ejie.r01m.objects.urlreference.R01MUrlResult;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MConstantsUrlReferenceConfig;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineUtils;
import com.ejie.r01m.utils.searchengine.R01MSearchResultsFormatterConstants;
import com.ejie.r01m.utils.url.R01MPortalURL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;

public class R01MUrlReferenceUtils {
    public static void computeURLsToHtml(R01MUrlReference urlReference, String htmlToApply) {
        if (urlReference == null || urlReference.getRefResults() == null) {
            return;
        }
        for (int i = 0; i < urlReference.getRefResults().size(); ++i) {
            R01MUrlResult urlResult = (R01MUrlResult)urlReference.getRefResults().get(i);
            urlResult.setRefUrlHTML(R01MUrlReferenceUtils.getHtml(urlReference, null, htmlToApply, null, i).toString());
        }
    }

    public static R01MUrlResult getUrlResult(R01MUrlReference urlReference, int index) {
        if (urlReference == null) {
            return null;
        }
        return urlReference.getRefResult(index);
    }

    public static StringBuffer getHtml(R01MUrlReference urlReference) {
        return R01MUrlReferenceUtils.getHtml(urlReference, null, 0);
    }

    public static StringBuffer getHtml(R01MUrlReference urlReference, String htmlToApply) {
        return R01MUrlReferenceUtils.getHtml(urlReference, htmlToApply, 0);
    }

    public static StringBuffer getHtml(R01MUrlReference urlReference, String htmlToApply, int elementResult) {
        return R01MUrlReferenceUtils.getHtml(urlReference, null, htmlToApply, null, elementResult);
    }

    public static StringBuffer getHtml(R01MUrlReference urlReference, Properties properties, String htmlToApply, String className, int elementResult) {
        StringBuffer html = new StringBuffer(21);
        R01MUrlResult urlResult = R01MUrlReferenceUtils.getUrlResult(urlReference, elementResult);
        if (urlResult == null) {
            return new StringBuffer("<a href=\"JavaScript:alert('URL NOT Configured');\" />");
        }
        R01MQueryObject queryObject = R01MUrlReferenceUtils.getQueryObject(urlReference);
        String refUrl = urlResult.getRefUrl();
        if (urlResult.getRefUrl() == null || StringUtils.isEmptyString((String)urlResult.getRefUrl())) {
            refUrl = "#";
        }
        if (queryObject != null) {
            String queryString = "r01kQry=" + R01MSearchEngineUtils.encodeQueryObjectInURL(queryObject, false);
            if (urlResult != null && urlResult.getRefUrl() != null && urlResult.getRefUrl().indexOf("?") != -1) {
                refUrl = urlResult.getRefUrl().substring(0, urlResult.getRefUrl().indexOf("?")) + "?" + queryString;
            }
        }
        if (urlReference.getRefUrlType() == 0 && !refUrl.startsWith("/") && !"#".equals(refUrl) && StringUtils.isEmptyString((String)R01MUrlReferenceUtils.getUrlProtocol(refUrl))) {
            refUrl = "http://" + refUrl;
        }
        html.append("<a");
        html.append(R01MUrlReferenceUtils.composeHrefWindowAppearance(refUrl, urlReference.getRefWindowAppearance(), urlReference.getJsEvents()));
        if (!StringUtils.isEmptyString((String)urlReference.getRefTextAlt())) {
            html.append(" title=\"");
            html.append(urlReference.getRefTextAlt());
            html.append("\"");
        }
        if (className != null && className.length() > 0) {
            html.append(" class=\"");
            html.append(className);
            html.append("\"");
        }
        if (properties != null && !properties.isEmpty()) {
            for (Map.Entry<Object, Object> meAttribute : properties.entrySet()) {
                html.append(" ");
                html.append(meAttribute.getKey());
                html.append("=\"");
                html.append(meAttribute.getValue());
                html.append("\"");
            }
        }
        html.append(">");
        if (htmlToApply != null && htmlToApply.length() > 0) {
            html.append(htmlToApply);
        } else if (urlResult.getRefText() != null && urlResult.getRefText().length() > 0) {
            html.append(urlResult.getRefText());
        } else if (urlReference.getRefTextAlt() != null && urlReference.getRefTextAlt().length() > 0) {
            html.append(R01MUrlReferenceUtils.filtrarHTML(urlReference.getRefTextAlt()));
        } else if (urlReference.getRefUrlType() == 7) {
            String[] refUrlSplit = urlResult.getRefUrl().split("/");
            String fileName = refUrlSplit[refUrlSplit.length - 1];
            html.append(fileName);
        } else {
            html.append(refUrl);
        }
        html.append("</a>");
        return html;
    }

    public static StringBuffer composeHrefWindowAppearance(String refUrl, R01MUrlReferenceWindowAppearance refWindowAppearance) {
        return R01MUrlReferenceUtils.composeHrefWindowAppearance(refUrl, refWindowAppearance, null);
    }

    public static StringBuffer composeHrefWindowAppearance(String refUrl, R01MUrlReferenceWindowAppearance refWindowAppearance, Map jsEvents) {
        StringBuffer link = new StringBuffer(20);
        link.append(" href=\"");
        boolean windowOpen = false;
        StringBuffer htmlEvent = new StringBuffer(122);
        if (refWindowAppearance != null) {
            if (refWindowAppearance.getRefNewWindow().equals(R01MConstantsUrlReferenceConfig.DEFAULT_LINK_NEW_WINDOW) || StringUtils.isEmptyString((String)refWindowAppearance.getRefNewWindow())) {
                link.append(refUrl);
                link.append("\"");
            } else {
                link.append(refUrl);
                link.append("\" target=\"");
                String windowTarget = refWindowAppearance.getRefWindowTarget();
                if (windowTarget == null || StringUtils.isEmptyString((String)windowTarget)) {
                    windowTarget = "_blank";
                }
                link.append(windowTarget);
                link.append("\"");
                if (refWindowAppearance.getRefWindowAccessible() != null && refWindowAppearance.getRefWindowAccessible().equals("false")) {
                    windowOpen = true;
                    htmlEvent.append("window.open('");
                    htmlEvent.append(refUrl);
                    htmlEvent.append("','");
                    htmlEvent.append(windowTarget);
                    htmlEvent.append("','height=");
                    htmlEvent.append(refWindowAppearance.getRefWindowHeight());
                    htmlEvent.append(",width=");
                    htmlEvent.append(refWindowAppearance.getRefWindowWidth());
                    htmlEvent.append(",left=");
                    htmlEvent.append(refWindowAppearance.getRefWindowX());
                    htmlEvent.append(",top=");
                    htmlEvent.append(refWindowAppearance.getRefWindowY());
                    htmlEvent.append(",menubar=yes,resizable=yes,status=yes,titlebar=yes,toolbar=yes,location=yes,directories=yes,scrollbars=yes');return false;");
                }
            }
        } else {
            link.append(refUrl);
            link.append("\"");
        }
        if (jsEvents != null && !jsEvents.isEmpty()) {
            for (Map.Entry ent : jsEvents.entrySet()) {
                if (StringUtils.isEmptyString((String)ent.getValue().toString())) continue;
                link.append(" ");
                link.append(ent.getKey());
                link.append("=\"");
                link.append(StringEscapeUtils.escapeHtml((String)StringEscapeUtils.unescapeJavaScript((String)ent.getValue().toString())));
                if (!ent.getValue().toString().endsWith(";")) {
                    link.append(";");
                }
                if (ent.getKey().equals("ONCLICK") && windowOpen) {
                    link.append(htmlEvent);
                    windowOpen = false;
                }
                link.append("\"");
            }
        }
        if (windowOpen) {
            link.append(" onclick=\"");
            link.append(htmlEvent);
            link.append("\"");
        }
        return link;
    }

    public static String getRefText(R01MUrlReference urlReference, int elementResult) {
        String text = "";
        R01MUrlResult urlResult = R01MUrlReferenceUtils.getUrlResult(urlReference, elementResult);
        if (urlResult != null) {
            text = urlResult.getRefText();
        }
        return R01MUrlReferenceUtils.filtrarHTML(text);
    }

    public static boolean isEmptyRefText(R01MUrlReference urlReference) {
        return urlReference == null || urlReference.getRefText() == null || StringUtils.isEmptyString((String)urlReference.getRefText());
    }

    public static String getNormalUrl(R01MUrlResult urlResult) {
        String url = null;
        if (urlResult != null) {
            url = urlResult.getResultDetail() != null && urlResult.getResultDetail().containsKey(R01MSearchResultsFormatterConstants.NORMAL_URL) ? (String)urlResult.getResultDetail().get(R01MSearchResultsFormatterConstants.NORMAL_URL) : urlResult.getRefUrl();
        }
        return url;
    }

    public static String getNormalUrl(R01MLinkItem link) {
        String url = null;
        if (link != null) {
            url = link.getData() != null && link.getData().containsKey("url") ? (String)link.getData().get("url") : link.getUrl();
        }
        return url;
    }

    public static R01MUrlReference getUrlReference(String refHTML) {
        return R01MUrlReferenceUtils.parseURLToURLReference(refHTML);
    }

    public static R01MUrlReference parseURLToURLReference(String refHTML) {
        String htmlRef = refHTML;
        R01MUrlReference urlReference = new R01MUrlReference();
        R01MUrlResult urlResult = new R01MUrlResult();
        R01MUrlReferenceWindowAppearance windowAppeareance = new R01MUrlReferenceWindowAppearance();
        String url = "";
        int type = -1;
        String newWindow = "";
        String newAccesible = "";
        String text = "";
        String textAlt = "";
        String windowHeight = "";
        String windowWidth = "";
        String posX = "";
        String posY = "";
        String windowTarget = "";
        ArrayList<R01MUrlResult> resultsList = new ArrayList<R01MUrlResult>();
        R01MHtmlLink htmlLink = new R01MHtmlLink();
        R01MPortalURL portalURL = null;
        try {
            String img = null;
            if (htmlRef.indexOf("><") > 0) {
                img = htmlRef.substring(htmlRef.indexOf("><") + 1, htmlRef.lastIndexOf("><") + 1);
                htmlRef = htmlRef.replaceAll(img, "");
            }
            String pathMap = R01MConstants.HTMLTOURLREFERENCER_MAPFILE;
            htmlRef = R01MUrlReferenceUtils.encodeXMLEntities(htmlRef);
            if (!StringUtils.isEmptyString((String)(htmlRef = R01MHtmlLink.validateHtmlTagAttributes(htmlRef)))) {
                htmlLink = (R01MHtmlLink)XOManager.getObject((String)pathMap, (String)htmlRef);
            }
            text = img == null ? htmlLink.getA() : img;
            textAlt = htmlLink.getAlt();
            if (textAlt == null || textAlt.equals("")) {
                textAlt = htmlLink.getTitle();
            }
            if (text == null) {
                text = "";
            }
            if (textAlt == null) {
                textAlt = "";
            }
            if ((url = htmlLink.getHref()).indexOf("path=") != -1) {
                url = url.substring(url.indexOf("path=") + "path=".length(), url.length());
                urlReference.setUserInfoCollecter("true");
            }
            portalURL = new R01MPortalURL(url);
            type = R01MUrlReferenceUtils.getUrlType(portalURL.getURLType());
            urlReference.setRefUrlType(portalURL.getURLType());
            windowTarget = htmlLink.getTarget();
            String onmousedown = htmlLink.getOnmousedown();
            if (onmousedown != null && onmousedown.length() > 0) {
                StringTokenizer tokenStr = new StringTokenizer(onmousedown, ",");
                while (tokenStr.hasMoreTokens()) {
                    String token = tokenStr.nextToken().replaceAll(" ", "");
                    if (token.indexOf("window.open") != -1) {
                        String[] aux = null;
                        aux = token.indexOf("'") != -1 ? token.split("'") : token.split("\"");
                        url = aux[1];
                        continue;
                    }
                    if (token.indexOf("height") != -1) {
                        windowHeight = token.substring(token.indexOf("height") + "height".length() + 1, token.length());
                        continue;
                    }
                    if (token.indexOf("width") != -1) {
                        windowWidth = token.substring(token.indexOf("width") + "width".length() + 1, token.length());
                        continue;
                    }
                    if (token.indexOf("left") != -1) {
                        posX = token.substring(token.indexOf("left") + "left".length() + 1, token.length());
                        continue;
                    }
                    if (token.indexOf("top") == -1) continue;
                    posY = token.substring(token.indexOf("top") + "top".length() + 1, token.length());
                }
                newWindow = "true";
                newAccesible = "false";
            }
            if (windowTarget != null && !StringUtils.isEmptyString((String)windowTarget)) {
                newWindow = "true";
                newAccesible = "true";
            }
        }
        catch (XOMarshallerException xoEx) {
            R01FLog.to((String)"r01m.urlComposer").severe("Error en la transformacion del link a objeto: " + xoEx.getMessage());
            xoEx.printStackTrace();
            return null;
        }
        urlResult.setRefUrl(url);
        urlResult.setRefText(StringUtils.encodeXMLEntities((String)text));
        urlReference.setRefTextAlt(textAlt);
        if (type == 1 || type == 3) {
            R01MUrlReferencePresentationPage presentationPage = new R01MUrlReferencePresentationPage();
            presentationPage.setPortalGUID(portalURL.getPortalCode());
            presentationPage.setPageOid(portalURL.getPageCode());
            presentationPage.setLanguagePage(portalURL.getPortalLang());
            urlReference.setPageObject(presentationPage);
            if (type == 3) {
                portalURL.getURLPart("queryValue");
                HashMap<String, String> queryResult = new HashMap<String, String>();
                R01MQueryObject queryObject = R01MSearchEngineUtils.obtainQueryObjectFromUrl("?" + portalURL.getURLPart("queryType") + "=" + portalURL.getURLPart("queryValue"));
                String xmlMapping = R01MConstants.QUERY_RESULTS_MAPFILE;
                String queryXML = "";
                if (queryObject != null) {
                    try {
                        queryXML = XOManager.getXML((String)xmlMapping, (Object)queryObject);
                    }
                    catch (XOMarshallerException ex) {
                        R01FLog.to((String)"r01m.urlComposer").severe("Error mappeando el objeto de la query: " + ex.getMessage());
                    }
                }
                queryResult.put(R01MConstantsUrlReferenceConfig.QUERY_XML, queryXML);
                urlResult.setResultDetail(queryResult);
            }
        } else if (type == 5) {
            HashMap<String, String> newsLetterResult = new HashMap<String, String>();
            newsLetterResult.put(R01MConstantsUrlReferenceConfig.NEWSLETTER_PUBLISHYEAR, portalURL.getURLPart("bopvYear"));
            newsLetterResult.put(R01MConstantsUrlReferenceConfig.NEWSLETTER_PUBLISHMONTH, portalURL.getURLPart("bopvMonth"));
            newsLetterResult.put(R01MConstantsUrlReferenceConfig.NEWSLETTER_NUMBERCODE, portalURL.getURLPart("bopvDisp"));
            urlResult.setResultDetail(newsLetterResult);
        }
        resultsList.add(urlResult);
        urlReference.setRefResults(resultsList);
        urlReference.setRefUrlType(type);
        windowAppeareance.setRefNewWindow(newWindow);
        windowAppeareance.setRefWindowAccessible(newAccesible);
        windowAppeareance.setRefWindowHeight(windowHeight);
        windowAppeareance.setRefWindowWidth(windowWidth);
        windowAppeareance.setRefWindowX(posX);
        windowAppeareance.setRefWindowY(posY);
        windowAppeareance.setRefWindowTarget(windowTarget);
        urlReference.setRefWindowAppearance(windowAppeareance);
        if (urlReference != null) {
            R01MUrlReferenceUtils.computeURLsToHtml(urlReference, null);
        }
        return urlReference;
    }

    public static R01MUrlReference convertURLToURLReference(String refUrl) {
        R01MUrlReference urlReference = new R01MUrlReference();
        R01MUrlResult urlResult = new R01MUrlResult();
        R01MUrlReferenceWindowAppearance windowAppeareance = new R01MUrlReferenceWindowAppearance();
        int type = -1;
        String text = "";
        String textAlt = "";
        String windowHeight = "";
        String windowWidth = "";
        String posX = "";
        String posY = "";
        String windowTarget = "";
        ArrayList<R01MUrlResult> resultsList = new ArrayList<R01MUrlResult>();
        R01MPortalURL portalURL = null;
        urlReference.setUserInfoCollecter("false");
        portalURL = new R01MPortalURL(refUrl);
        type = R01MUrlReferenceUtils.getUrlType(portalURL.getURLType());
        urlReference.setRefUrlType(portalURL.getURLType());
        urlResult.setRefUrl(refUrl);
        urlResult.setRefText(StringUtils.encodeXMLEntities((String)text));
        urlReference.setRefTextAlt(textAlt);
        if (type == 1 || type == 3) {
            R01MUrlReferencePresentationPage presentationPage = new R01MUrlReferencePresentationPage();
            presentationPage.setPortalGUID(portalURL.getPortalCode());
            presentationPage.setPageOid(portalURL.getPageCode());
            presentationPage.setLanguagePage(portalURL.getPortalLang());
            urlReference.setPageObject(presentationPage);
            if (type == 3) {
                portalURL.getURLPart("queryValue");
                HashMap<String, String> queryResult = new HashMap<String, String>();
                R01MQueryObject queryObject = R01MSearchEngineUtils.obtainQueryObjectFromUrl("?" + portalURL.getURLPart("queryType") + "=" + portalURL.getURLPart("queryValue"));
                String xmlMapping = R01MConstants.QUERY_RESULTS_MAPFILE;
                String queryXML = "";
                if (queryObject != null) {
                    try {
                        queryXML = XOManager.getXML((String)xmlMapping, (Object)queryObject);
                    }
                    catch (XOMarshallerException ex) {
                        R01FLog.to((String)"r01m.urlComposer").severe("Error mappeando el objeto de la query: " + ex.getMessage());
                    }
                }
                queryResult.put(R01MConstantsUrlReferenceConfig.QUERY_XML, queryXML);
                urlResult.setResultDetail(queryResult);
            }
        } else if (type == 5) {
            HashMap<String, String> newsLetterResult = new HashMap<String, String>();
            newsLetterResult.put(R01MConstantsUrlReferenceConfig.NEWSLETTER_PUBLISHYEAR, portalURL.getURLPart("bopvYear"));
            newsLetterResult.put(R01MConstantsUrlReferenceConfig.NEWSLETTER_PUBLISHMONTH, portalURL.getURLPart("bopvMonth"));
            newsLetterResult.put(R01MConstantsUrlReferenceConfig.NEWSLETTER_NUMBERCODE, portalURL.getURLPart("bopvDisp"));
            urlResult.setResultDetail(newsLetterResult);
        }
        resultsList.add(urlResult);
        urlReference.setRefResults(resultsList);
        urlReference.setRefUrlType(type);
        windowAppeareance.setRefNewWindow("false");
        windowAppeareance.setRefWindowAccessible("false");
        windowAppeareance.setRefWindowHeight(windowHeight);
        windowAppeareance.setRefWindowWidth(windowWidth);
        windowAppeareance.setRefWindowX(posX);
        windowAppeareance.setRefWindowY(posY);
        windowAppeareance.setRefWindowTarget(windowTarget);
        urlReference.setRefWindowAppearance(windowAppeareance);
        if (urlReference != null) {
            R01MUrlReferenceUtils.computeURLsToHtml(urlReference, null);
        }
        return urlReference;
    }

    public static int getUrlType(int urlType) {
        int returnType = 0;
        switch (urlType) {
            case -1: {
                returnType = -1;
                break;
            }
            case 0: {
                returnType = 0;
                break;
            }
            case 1: {
                returnType = 1;
                break;
            }
            case 2: {
                returnType = 2;
                break;
            }
            case 10: {
                returnType = 2;
                break;
            }
            case 11: {
                returnType = 0;
                break;
            }
            case 12: {
                returnType = 0;
                break;
            }
            case 13: {
                returnType = 5;
                break;
            }
            case 14: {
                returnType = 3;
                break;
            }
            case 21: {
                returnType = 7;
                break;
            }
            default: {
                returnType = 0;
            }
        }
        return returnType;
    }

    public static String encodeUrlSpaces(String cadena) {
        if (cadena == null || cadena.length() == 0) {
            return cadena;
        }
        StringBuffer cadenaAux = new StringBuffer(cadena.length());
        for (int i = 0; i < cadena.length(); ++i) {
            if (cadena.charAt(i) == ' ') {
                cadenaAux.append("%20");
                continue;
            }
            cadenaAux.append(cadena.charAt(i));
        }
        return cadenaAux.toString();
    }

    public static StringBuffer encodeUrlSpaces(StringBuffer cadena) {
        if (cadena == null || StringUtils.isEmptyStringBuffer((StringBuffer)cadena)) {
            return cadena;
        }
        StringBuffer cadenaAux = new StringBuffer(cadena.length());
        for (int i = 0; i < cadena.length(); ++i) {
            if (cadena.charAt(i) == ' ') {
                cadenaAux.append("%20");
                continue;
            }
            cadenaAux.append(cadena.charAt(i));
        }
        return cadenaAux;
    }

    public static R01MUrlReference getUrlReferenceObject(String xml) {
        List results;
        R01MUrlReference urlReference = null;
        if (!StringUtils.isEmptyString((String)xml)) {
            try {
                urlReference = (R01MUrlReference)XOManager.getObject((String)R01MConstants.URLREFERENCER_MAPFILE, (String)xml);
            }
            catch (XOMarshallerException xoEx) {
                R01FLog.to((String)"r01m.urlComposer").severe("Error en la obtenci\u00f3n del objeto que encapsula el xml resultado de realizar una invocaci\u00f3n al referenciador." + xoEx.getMessage());
                return null;
            }
        }
        if (urlReference != null && (results = urlReference.getRefResults()) != null && !results.isEmpty()) {
            for (R01MUrlResult result : results) {
                result.setRefUrl(R01MUrlReferenceUtils.filterAmpCharacter(result.getRefUrl()));
            }
        }
        return urlReference;
    }

    public static String getUrlReferenceXML(R01MUrlReference urlReference) throws R01MPortalModelException {
        String xml = "";
        if (urlReference != null) {
            try {
                xml = XOManager.getXML((String)R01MConstants.URLREFERENCER_MAPFILE, (Object)urlReference);
            }
            catch (XOMarshallerException xoEx) {
                xoEx.printStackTrace(System.out);
                throw new R01MPortalModelException("Error en la obtenci\u00f3n del xml que encapsula la informaci\u00f3n resultado de realizar una invocaci\u00f3n al referenciador." + xoEx.getMessage());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return xml;
    }

    public static Map composeNewsletterResultDetail(String url) {
        HashMap<String, String> resultDetail = new HashMap<String, String>();
        if (!StringUtils.isEmptyString((String)url)) {
            R01MPortalURL portalUrl = new R01MPortalURL(url);
            resultDetail.put(R01MConstantsUrlReferenceConfig.NEWSLETTER_PUBLISHYEAR, portalUrl.getURLPart("bopvYear"));
            resultDetail.put(R01MConstantsUrlReferenceConfig.NEWSLETTER_PUBLISHMONTH, portalUrl.getURLPart("bopvMonth"));
            String dispNum = portalUrl.getURLPart("bopvDisp");
            if (!StringUtils.isEmptyString((String)dispNum)) {
                if (dispNum.indexOf("a") != -1) {
                    resultDetail.put(R01MConstantsUrlReferenceConfig.NEWSLETTER_NUMBERCODE, dispNum.substring(0, dispNum.length() - 1));
                    resultDetail.put(R01MConstantsUrlReferenceConfig.NEWSLETTER_LANG, "a");
                } else if (dispNum.indexOf("e") != -1) {
                    resultDetail.put(R01MConstantsUrlReferenceConfig.NEWSLETTER_NUMBERCODE, dispNum.substring(0, dispNum.length() - 1));
                    resultDetail.put(R01MConstantsUrlReferenceConfig.NEWSLETTER_LANG, "e");
                } else {
                    resultDetail.put(R01MConstantsUrlReferenceConfig.NEWSLETTER_NUMBERCODE, dispNum);
                }
            }
        }
        return resultDetail;
    }

    private static String filterAmpCharacter(String value) {
        String targetValue = "";
        try {
            String patternStr = "&(?![#a-zA-Z0-9]+;)";
            if (value != null && !value.trim().equals("")) {
                Pattern pattern = Pattern.compile(patternStr);
                Matcher matcher = pattern.matcher(value);
                StringBuffer buf = new StringBuffer();
                while (matcher.find()) {
                    String strReplacement = "&amp;";
                    matcher.appendReplacement(buf, "");
                    buf.append(strReplacement);
                }
                matcher.appendTail(buf);
                targetValue = buf.toString();
            }
        }
        catch (Exception e) {
            return value;
        }
        return targetValue;
    }

    public static void main(String[] args) {
        try {
            String refHTML = "<A urltype='url' href='asdas' title='sdad'>asdasd</A>";
            String pathMap = "d:/eAdmin/aplic/r01l/html/datos/";
            R01MHtmlLink htmlLink = (R01MHtmlLink)XOManager.getObject((String)pathMap, (String)refHTML);
            String text = htmlLink.getA();
            int type = htmlLink.getUrltype();
            String url = htmlLink.getHref();
            R01FLog.to((String)"r01m.test").info("text:" + text + ";type:" + type + ";url:" + url);
        }
        catch (XOMarshallerException maExc) {
            R01FLog.to((String)"r01m.urlComposer").severe("Error en la transformacion del link a objeto: " + maExc.getMessage());
        }
    }

    public static String filtrarHTML(String cadena) {
        return cadena;
    }

    public static String filtrarEspaciosHTML(String cadena) {
        String resp = "";
        if (cadena != null && cadena.length() > 0) {
            resp = cadena;
            resp = StringUtils.replaceString((String)resp, (String)" ", (String)"&nbsp;");
        }
        return resp;
    }

    private static R01MQueryObject getQueryObject(R01MUrlReference urlReference) {
        R01MQueryObject queryObject = null;
        if (urlReference != null && urlReference.getRefResults() != null && urlReference.getRefResults().size() > 0) {
            for (int i = 0; i < urlReference.getRefResults().size(); ++i) {
                R01MUrlResult urlResult = (R01MUrlResult)urlReference.getRefResults().get(i);
                if (urlResult == null || urlResult.getResultDetail() == null || !urlResult.getResultDetail().containsKey(R01MConstantsUrlReferenceConfig.QUERY_XML)) continue;
                try {
                    String queryXml = (String)urlResult.getResultDetail().get(R01MConstantsUrlReferenceConfig.QUERY_XML);
                    if (queryXml != null && queryXml.length() > 0) {
                        queryObject = R01MClientFactory.getSearchEngineSessionAPI().getQueryObjectFromXML(queryXml);
                        continue;
                    }
                    R01FLog.to((String)"r01m.urlComposer").warning("Error al obtener el objeto R01MQueryObject del xml: null\r\nSe lanza la query general (sin parametros)");
                    continue;
                }
                catch (XOMarshallerException xoEx) {
                    xoEx.printStackTrace(System.out);
                    R01FLog.to((String)"r01m.urlComposer").warning("Error al transformar el objeto R01MQueryObject del xml:" + (Object)((Object)xoEx) + "\r\nSe lanza la query general (sin parametros)");
                }
            }
        }
        return queryObject;
    }

    private static String encodeXMLEntities(String xml) {
        StringBuffer xmlResp = new StringBuffer();
        for (int i = 0; i < xml.length(); ++i) {
            if (xml.charAt(i) == '&') {
                xmlResp.append("&amp;");
                continue;
            }
            xmlResp.append(xml.charAt(i));
        }
        return xmlResp.toString();
    }

    private static String getUrlProtocol(String url) {
        String protocol = null;
        String external_url_regexp = "(([A-Za-z]+:[\\/]+)|([mailto:]+))*(.*)";
        Pattern p = null;
        Matcher m = null;
        p = Pattern.compile(external_url_regexp);
        m = p.matcher(url);
        if (m.matches() && m.groupCount() == 4) {
            protocol = m.group(1);
        }
        return protocol;
    }
}

