/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.utils.url;

import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.utils.R01MConstants;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class R01MPortalURL {
    private static final String EXTERNAL_URL_REGEXP = XMLProperties.getProperty((String)R01MConstants.API_APPCODE, (String)"urlPatterns/externalUrl", (String)"([A-Za-z]+:[\\/]+)*(.*)");
    private static final String ALIAS_REGEXP = XMLProperties.getProperty((String)R01MConstants.API_APPCODE, (String)"urlPatterns/aliasUrl", (String)"^(?:(http)://)?([^/]+)?/([^/]+)/?$");
    private static final String PORTAL_REGEXP = XMLProperties.getProperty((String)R01MConstants.API_APPCODE, (String)"urlPatterns/portalUrl", (String)"^(?:(http)://)?(?:([^/]+))?/([^-/]+)-([^/]+)/([^/]+)/?$");
    private static final String CONTENT_REGEXP = XMLProperties.getProperty((String)R01MConstants.API_APPCODE, (String)"urlPatterns/contentUrl", (String)"^(?:(http)://)?(?:([^/]+))?/(contenidos)/([^/]+)/([^/]+)/([^_/]+)_([^/]+)(/.*)?$");
    private static final String CONTENT_REDIR_IN_PORTAL_REGEXP = XMLProperties.getProperty((String)R01MConstants.API_APPCODE, (String)"urlPatterns/contentRedirPortalUrl", (String)"^(?:(http)://)?(?:([^/]+))?/([^-/]+)-([^/]+)/([^/]+)/(.*(?!r01hRedirectCont))/r01hRedirectCont/([^/]+)/([^/]+)/([^/]+)/([^_/]+)_([^/]+)(/.*)$");
    private static final String CONTENT_REDIR_REGEXP = XMLProperties.getProperty((String)R01MConstants.API_APPCODE, (String)"urlPatterns/contentRedirUrl", (String)"^(?:(http)://)?(?:([^/]+))?/(.*(?!r01hRedirectCont))/r01hRedirectCont/([^/]+)/([^/]+)/([^/]+)/([^_/]+)_([^/]+)(/.*)$");
    private static final String CONTENT_IN_PORTAL_REGEXP = XMLProperties.getProperty((String)R01MConstants.API_APPCODE, (String)"urlPatterns/contentInPortalUrl", (String)"^(?:(http)://)?(?:([^/]+))?/([^-/]+)-([^/]+)/([^/]+)/([^/]+)/([^/]+)/([^/]+)/([^_/]+)_([^/]+)(/.*)?$");
    private static final String BOPV1_REGEXP = XMLProperties.getProperty((String)R01MConstants.API_APPCODE, (String)"urlPatterns/bopv1Url", (String)"^(?:(http)://)?(?:([^/]+))?/cgi-bin_k54/bopv_20\\?[a-zA-Z]&[a-zA-Z]=([0-9]{4})([0-9]{2})([0-9]{2})&[a-zA-Z]=([0-9]+)$");
    private static final String BOPV2_REGEXP = XMLProperties.getProperty((String)R01MConstants.API_APPCODE, (String)"urlPatterns/bopv2Url", (String)"^(?:(http)://)?(?:([^/]+))?/bopv2/datos/([0-9]{4})/([0-9]{2})/([0-9]{2}([0-9]+)[a-zA-Z]+.pdf)");
    private static final String SEARCH_REGEXP = XMLProperties.getProperty((String)R01MConstants.API_APPCODE, (String)"urlPatterns/searchUrl", (String)"^(?:(http)://)?(?:([^/]+))?(/([^-/]+)-([^/]+)?/([^/?]+))?\\\\?.*(searchGUID|r01kCommonSearchQry|r01kStoredQry|fullText|r01kQry|languageAplication)=([^&]+).*");
    private static final String DATAFILE_REGEX = XMLProperties.getProperty((String)R01MConstants.API_APPCODE, (String)"urlPatterns/dataFileUrl", (String)"^/?[^/]+\\.(?:html|shtml)$");
    private static final String ATTACHMENT_REGEX = XMLProperties.getProperty((String)R01MConstants.API_APPCODE, (String)"urlPatterns/attachmentUrl", (String)"^/?([^:\\.]+/)?[^/]+\\.[^/.(?:html|shtml|HTML|SHTML)]+$");
    public static String DEFAULT_USER_INFO_COLLECTER = "false";
    public static String USER_INFO_COLLECTER_PATH = "/r01ltUserInfoCollecterWAR/r01lUserInfoCollecter.jsp?";
    public static final int URL_TYPE_UNKNOWN = -1;
    public static final int URL_TYPE_EXTERNAL = 0;
    public static final int URL_TYPE_PORTALPAGE = 1;
    public static final int URL_TYPE_CONTENT_REDIRECTED = 10;
    public static final int URL_TYPE_ALIAS = 11;
    public static final int URL_TYPE_APP = 12;
    public static final int URL_TYPE_BOPV = 13;
    public static final int URL_TYPE_SEARCH = 14;
    public static final int URL_TYPE_CONTENT = 2;
    public static final int URL_TYPE_ATTACHMENT = 21;
    public static final String ALIAS_NAME = "alias";
    public static final String CONTENT_REPOSITORY = "contentRepository";
    public static final String CONTENT_TYPE = "contentType";
    public static final String CONTENT_NAME = "contentName";
    public static final String DOCUMENT_INTERNAL_NAME = "documentInternalName";
    public static final String DOCUMENT_LANG = "documentLang";
    public static final String DOCUMENT_FILE = "documentFile";
    public static final String CONTENTREDIR_SRC_CONTENT = "contentRedirSrc";
    public static final String QUERY_TYPE = "queryType";
    public static final String QUERY_VALUE = "queryValue";
    public static final String BOPV_YEAR = "bopvYear";
    public static final String BOPV_MONTH = "bopvMonth";
    public static final String BOPV_DAY = "bopvDay";
    public static final String BOPV_DISP = "bopvDisp";
    private String _url;
    private int _urlType = -1;
    private String _protocol;
    private String _webSite;
    private String _portalCode;
    private String _pageCode;
    private String _portalLang;
    private boolean _isAttachment = false;
    private Properties _urlParts;

    public R01MPortalURL() {
    }

    public R01MPortalURL(String newUrl) {
        this();
        this._url = newUrl;
        this._parseURL(this._url);
    }

    public int getURLType() {
        return this._urlType;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public String getWebSite() {
        return this._webSite;
    }

    public String getPortalCode() {
        return this._portalCode;
    }

    public String getPageCode() {
        return this._pageCode;
    }

    public String getPortalLang() {
        return this._portalLang;
    }

    public boolean isAttachment() {
        return this._isAttachment;
    }

    public String getURLPart(String urlPartId) {
        return this._urlParts != null ? this._urlParts.getProperty(urlPartId) : null;
    }

    public String composeDebugInfo() {
        StringBuffer sb = new StringBuffer(400);
        if (this._url == null) {
            return "";
        }
        sb.append("URL: ");
        sb.append(this._url);
        sb.append("\r\n\t-type: ");
        sb.append(this._getURLTypeDesc(this._urlType));
        sb.append("\r\n\t-protocol: ");
        sb.append(this._protocol);
        sb.append("\r\n\t-site: ");
        sb.append(this._webSite);
        sb.append("\r\n\t-portal: ");
        sb.append(this._portalCode);
        sb.append("\r\n\t-page: ");
        sb.append(this._pageCode);
        sb.append("\r\n\t-portalLang: ");
        sb.append(this._portalLang);
        if (this._urlParts != null) {
            sb.append("\r\n\t-urlParts: ");
            Map.Entry<Object, Object> me2 = null;
            for (Map.Entry<Object, Object> me2 : this._urlParts.entrySet()) {
                sb.append("\r\n\t\t-");
                sb.append(me2.getKey());
                sb.append(": ");
                sb.append(me2.getValue());
            }
        }
        return sb.toString();
    }

    private String _getURLTypeDesc(int urlType) {
        switch (urlType) {
            case -1: {
                return "unknown";
            }
            case 11: {
                return ALIAS_NAME;
            }
            case 12: {
                return "application";
            }
            case 13: {
                return "bopv";
            }
            case 2: {
                return "content";
            }
            case 21: {
                return "adjunto";
            }
            case 10: {
                return "contentRedirected";
            }
            case 14: {
                return "search";
            }
            case 0: {
                return "external";
            }
            case 1: {
                return "portalPage";
            }
        }
        return "unknown";
    }

    private void _parseURL(String url) {
        if (url == null) {
            return;
        }
        Pattern p = null;
        Matcher m = null;
        p = Pattern.compile(BOPV1_REGEXP);
        m = p.matcher(url);
        if (m.matches()) {
            this._urlType = 13;
            this._parseBOPV1Url(m);
            return;
        }
        p = Pattern.compile(BOPV2_REGEXP);
        m = p.matcher(url);
        if (m.matches()) {
            this._urlType = 13;
            this._parseBOPV2Url(m);
            return;
        }
        p = Pattern.compile(CONTENT_REDIR_IN_PORTAL_REGEXP);
        m = p.matcher(url);
        if (m.matches()) {
            this._urlType = 10;
            this._parseRedirInPortalUrl(m);
            return;
        }
        p = Pattern.compile(CONTENT_REDIR_REGEXP);
        m = p.matcher(url);
        if (m.matches()) {
            this._urlType = 10;
            this._parseRedirInContent(m);
            return;
        }
        p = Pattern.compile(CONTENT_IN_PORTAL_REGEXP);
        m = p.matcher(url);
        if (m.matches()) {
            this._urlType = 2;
            this._parseContentInPortalUrl(m);
            return;
        }
        p = Pattern.compile(CONTENT_REGEXP);
        m = p.matcher(url);
        if (m.matches()) {
            this._urlType = 2;
            this._parseContent(m);
            return;
        }
        p = Pattern.compile(SEARCH_REGEXP);
        m = p.matcher(url);
        if (m.matches()) {
            this._urlType = 14;
            this._parseSearchUrl(m);
            return;
        }
        p = Pattern.compile(PORTAL_REGEXP);
        m = p.matcher(url);
        if (m.matches()) {
            this._urlType = 1;
            this._parsePortalUrl(m);
            return;
        }
        p = Pattern.compile(ATTACHMENT_REGEX);
        m = p.matcher(url);
        if (m.matches()) {
            this._urlType = 21;
            return;
        }
        p = Pattern.compile(ALIAS_REGEXP);
        m = p.matcher(url);
        if (m.matches()) {
            this._urlType = 11;
            this._parseAliasUrl(m);
            return;
        }
        p = Pattern.compile(EXTERNAL_URL_REGEXP);
        m = p.matcher(url);
        if (m.matches()) {
            this._urlType = 0;
            this._parseExternalUrl(m);
            return;
        }
        this._urlType = 0;
    }

    private void _parseAliasUrl(Matcher m) {
        this._urlParts = new Properties();
        if (m.groupCount() == 3) {
            this._protocol = m.group(1);
            this._webSite = m.group(2);
        } else if (m.groupCount() == 2) {
            this._webSite = m.group(2);
        }
        this._urlParts.put(ALIAS_NAME, m.group(3));
    }

    private void _parsePortalUrl(Matcher m) {
        this._urlParts = new Properties();
        if (m.groupCount() == 5) {
            this._protocol = m.group(1);
            this._webSite = m.group(2);
        } else if (m.groupCount() == 4) {
            this._webSite = m.group(2);
        }
        this._portalCode = m.group(3);
        this._pageCode = m.group(4);
        this._portalLang = m.group(5);
    }

    private void _parseExternalUrl(Matcher m) {
        this._urlParts = new Properties();
        if (m.groupCount() == 2) {
            this._protocol = m.group(1);
            this._webSite = m.group(2);
        } else if (m.groupCount() == 1) {
            this._webSite = m.group(0);
        }
    }

    private void _parseSearchUrl(Matcher m) {
        this._urlParts = new Properties();
        if (m.groupCount() == 11) {
            this._protocol = m.group(1);
            this._webSite = m.group(2);
        } else if (m.groupCount() == 10) {
            this._webSite = m.group(2);
        }
        this._portalCode = m.group(4);
        this._pageCode = m.group(5);
        this._portalLang = m.group(6);
        this._urlParts.put(QUERY_TYPE, m.group(7));
        this._urlParts.put(QUERY_VALUE, m.group(8));
    }

    private void _parseContentInPortalUrl(Matcher m) {
        this._urlParts = new Properties();
        if (m.groupCount() == 11) {
            this._protocol = m.group(1);
            this._webSite = m.group(2);
        } else if (m.groupCount() == 10) {
            this._webSite = m.group(2);
        }
        this._portalCode = m.group(3);
        this._pageCode = m.group(4);
        this._portalLang = m.group(5);
        this._urlParts.put(CONTENT_REPOSITORY, m.group(6));
        this._urlParts.put(CONTENT_TYPE, m.group(7));
        this._urlParts.put(CONTENT_NAME, m.group(8));
        this._urlParts.put(DOCUMENT_LANG, m.group(9));
        this._urlParts.put(DOCUMENT_INTERNAL_NAME, m.group(10));
        this._urlParts.put(DOCUMENT_FILE, m.group(11));
        this._parseAttachment(this._urlParts.getProperty(DOCUMENT_FILE));
    }

    private void _parseRedirInPortalUrl(Matcher m) {
        this._urlParts = new Properties();
        if (m.groupCount() == 12) {
            this._protocol = m.group(1);
            this._webSite = m.group(2);
        } else if (m.groupCount() == 10) {
            this._webSite = m.group(2);
        }
        this._portalCode = m.group(3);
        this._pageCode = m.group(4);
        this._portalLang = m.group(5);
        this._urlParts.put(CONTENTREDIR_SRC_CONTENT, m.group(6));
        this._urlParts.put(CONTENT_REPOSITORY, m.group(7));
        this._urlParts.put(CONTENT_TYPE, m.group(8));
        this._urlParts.put(CONTENT_NAME, m.group(9));
        this._urlParts.put(DOCUMENT_LANG, m.group(10));
        this._urlParts.put(DOCUMENT_INTERNAL_NAME, m.group(11));
        this._urlParts.put(DOCUMENT_FILE, m.group(12));
        this._parseAttachment(this._urlParts.getProperty(DOCUMENT_FILE));
    }

    private void _parseRedirInContent(Matcher m) {
        this._urlParts = new Properties();
        if (m.groupCount() == 9) {
            this._protocol = m.group(1);
            this._webSite = m.group(2);
        } else if (m.groupCount() == 8) {
            this._webSite = m.group(2);
        }
        this._urlParts.put(CONTENTREDIR_SRC_CONTENT, m.group(3));
        this._urlParts.put(CONTENT_REPOSITORY, m.group(4));
        this._urlParts.put(CONTENT_TYPE, m.group(5));
        this._urlParts.put(CONTENT_NAME, m.group(6));
        this._urlParts.put(DOCUMENT_LANG, m.group(7));
        this._urlParts.put(DOCUMENT_INTERNAL_NAME, m.group(8));
        this._urlParts.put(DOCUMENT_FILE, m.group(9));
        this._parseAttachment(this._urlParts.getProperty(DOCUMENT_FILE));
    }

    private void _parseContent(Matcher m) {
        this._urlParts = new Properties();
        if (m.groupCount() == 8) {
            this._protocol = m.group(1);
            this._webSite = m.group(2);
        } else {
            this._webSite = m.group(2);
        }
        this._urlParts.put(CONTENT_REPOSITORY, m.group(3));
        this._urlParts.put(CONTENT_TYPE, m.group(4));
        this._urlParts.put(CONTENT_NAME, m.group(5));
        this._urlParts.put(DOCUMENT_LANG, m.group(6));
        this._urlParts.put(DOCUMENT_INTERNAL_NAME, m.group(7));
        this._urlParts.put(DOCUMENT_FILE, m.group(8));
        this._parseAttachment(this._urlParts.getProperty(DOCUMENT_FILE));
    }

    private void _parseAttachment(String filePart) {
        if (filePart == null) {
            return;
        }
        Pattern p = Pattern.compile(DATAFILE_REGEX);
        Matcher m = p.matcher(filePart);
        if (m.matches()) {
            this._isAttachment = false;
        } else {
            this._isAttachment = true;
            this._urlType = 21;
        }
    }

    private void _parseBOPV1Url(Matcher m) {
        this._urlParts = new Properties();
        if (m.groupCount() == 6) {
            this._protocol = m.group(1);
            this._webSite = m.group(2);
        } else if (m.groupCount() == 5) {
            this._webSite = m.group(2);
        }
        this._urlParts.put(BOPV_YEAR, m.group(3));
        this._urlParts.put(BOPV_MONTH, m.group(4));
        this._urlParts.put(BOPV_DAY, m.group(5));
        this._urlParts.put(BOPV_DISP, m.group(6));
    }

    private void _parseBOPV2Url(Matcher m) {
        this._urlParts = new Properties();
        if (m.groupCount() == 5) {
            this._protocol = m.group(1);
            this._webSite = m.group(2);
        } else if (m.groupCount() == 4) {
            this._webSite = m.group(1);
        }
        this._urlParts.put(BOPV_YEAR, m.group(3));
        this._urlParts.put(BOPV_MONTH, m.group(4));
        this._urlParts.put(BOPV_DISP, m.group(6));
    }
}

