/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.utils.searchengine;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.servlet.URLDecoder;
import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.util.URLEncoder;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.config.objects.typology.R01MContentCluster;
import com.ejie.r01m.config.objects.typology.R01MContentTypeMetaData;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.exceptions.R01MCatalogException;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MPortalModelException;
import com.ejie.r01m.exceptions.R01MSearchStorageException;
import com.ejie.r01m.exceptions.R01MSearchWebException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.formComposer.R01MFormComposerQueryParser;
import com.ejie.r01m.objects.link.R01MLink;
import com.ejie.r01m.objects.link.R01MLinkItem;
import com.ejie.r01m.objects.link.R01MWindowAppearance;
import com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj;
import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedArea;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedCluster;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedContentType;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedDataRepository;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedFamily;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedMetaData;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedOrderByMetaData;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedServer;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedStructureCatalog;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItemPublicationInfo;
import com.ejie.r01m.searchengine.formatters.R01MSearchFormatterDirectiveUtils;
import com.ejie.r01m.searchengine.formatters.R01MSearchResultDecoratorDirectiveListener;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchResultItemsFormatter;
import com.ejie.r01m.searchengine.formatters.preferences.R01MSearchSessionFormatterPreferences;
import com.ejie.r01m.searchengine.servlet.R01MSearchEngineWebConstants;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import com.ejie.r01m.utils.link.R01MLinkUtils;
import com.ejie.r01m.utils.searchengine.R01MFullTextQueryUtils;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;

public abstract class R01MSearchEngineUtils {
    private static String LOG_TYPE_ID = "r01k.session";
    private static boolean DEBUG = R01FLog.getLogLevel((String)LOG_TYPE_ID).intValue() != Level.OFF.intValue();
    private static final List QRY_PRESENTATION_EXCLUDED_METADATA = XMLProperties.getPropertyList((String)R01MConstants.API_APPCODE, (String)"searchEngine/queryPresentation/exclude/metaDataList/metaData");
    private static final List QRY_PRESENTATION_METADATA_ORDER = XMLProperties.getPropertyList((String)R01MConstants.API_APPCODE, (String)"searchEngine/queryPresentation/order/metaDataList/metaData");
    public static final String QUERY_PATTERN = XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"searchEngine/queryUrlPattern", (String)".*\\?.*(searchGUID|r01kCommonSearchQry|r01kStoredQry|fullText|r01kQry|languageAplication|r01SearchEngine)=([^&]+).*");
    private static final String QUERYV1PARAMFILTER = "languageAplication";
    public static final String URL_ENCODING_UTF = "UTF-8";
    public static final String URL_ENCODING_ISO_8859 = "ISO-8859-1";
    private static final String OPERATOR_PREFIX = "operator.";
    public static final int GERERAL_LABELS = 0;
    public static final int ORGANISMO_LABELS = 1;

    public static String obtainContext(String context, R01MQueryObject qry) {
        String outContext = null;
        try {
            if (context == null) {
                if (qry != null && qry.getContext() != null) {
                    outContext = qry.getContext();
                } else if (R01MClientFactory.getSearchEngineConfigAPI().getSearchEngineConfig().getDefaultContext() != null) {
                    outContext = R01MClientFactory.getSearchEngineConfigAPI().getSearchEngineConfig().getDefaultContext();
                } else {
                    outContext = XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"searchEngine/defaultSearchEngineContext");
                    if (outContext == null) {
                        outContext = XMLProperties.get((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"defaultSearchEngineContext");
                    }
                    if (outContext == null) {
                        outContext = "intranet";
                    }
                }
            } else {
                outContext = context;
            }
        }
        catch (R01MConfigLoadException r01MConfigLoadException) {
            // empty catch block
        }
        if (outContext == null) {
            R01FLog.to((String)"r01m.session").severe("NO se ha pasado un contexto de b\u00fasqueda y NO est\u00e1 definida la propiedad defaultContext en el fichero de configuracion del motor de b\u00fasqueda: NO SE PUEDE AVERIGUAR EL CONTEXTO, ASI QUE NO SE PUEDE EJECUTAR LA B\u00daSQUEDA!!!!");
            outContext = "intranet";
        }
        return outContext;
    }

    public static String obtainContentRepositoryAlias(List documentPublicationInfo) {
        String contentAlias = "contenidos";
        if (documentPublicationInfo != null && !documentPublicationInfo.isEmpty()) {
            for (R01MSearchResultItemPublicationInfo currPublication : documentPublicationInfo) {
                if (currPublication.getState() != 1) continue;
                contentAlias = ((R01MSearchResultItemPublicationInfo)documentPublicationInfo.get(0)).getRepositoryAlias();
                if (!StringUtils.isEmptyString((String)contentAlias)) break;
                contentAlias = "contenidos";
                break;
            }
        }
        return contentAlias;
    }

    public static StringBuffer decorateSearchResult(String lang, String searchServiceURL, boolean debug, String qryURLEncoded, String guideDefOid, String currGuideNodePath, Reader textToDecorateReader) throws R01MSearchWebException {
        StringBuffer decoratedText = null;
        String textToDecorate = null;
        try {
            decoratedText = new StringBuffer(5000);
            textToDecorate = StringUtils.loadFromReader((Reader)textToDecorateReader);
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace(System.out);
            throw new R01MSearchWebException("Error al escribir en la salida del custom tag: " + ioEx.toString());
        }
        try {
            R01MSearchResultDecoratorDirectiveListener dirListener = new R01MSearchResultDecoratorDirectiveListener(lang, searchServiceURL, debug, qryURLEncoded, guideDefOid, currGuideNodePath);
            Pattern p = Pattern.compile("(\\$\\[r01[^]$]+\\]\\$)");
            Matcher m = p.matcher(textToDecorate);
            boolean directiveValid = m.find();
            String foundDirective = null;
            int dirPos = -1;
            String replaceString = null;
            while (directiveValid) {
                foundDirective = textToDecorate.substring(m.start(), m.end());
                replaceString = new String(dirListener.processDirective(foundDirective, dirPos = m.start()));
                if (replaceString != null && replaceString.indexOf("[ERROR]") > 0) {
                    R01FLog.to((String)"r01m.session").warning("ERROR al decorar el resultado de busqueda...\r\n" + replaceString);
                }
                if (replaceString != null) {
                    m.appendReplacement(decoratedText, replaceString);
                }
                directiveValid = m.find();
            }
            m.appendTail(decoratedText);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
        return decoratedText;
    }

    public static StringBuffer decorateSearchResult(String lang, String searchServiceURL, String moreParameters, String qryURLEncoded, String guideDefOid, String currGuideNodePath, Reader textToDecorateReader) throws R01MSearchWebException {
        StringBuffer decoratedText = null;
        String textToDecorate = null;
        try {
            decoratedText = new StringBuffer(5000);
            textToDecorate = StringUtils.loadFromReader((Reader)textToDecorateReader);
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace(System.out);
            throw new R01MSearchWebException("Error al escribir en la salida del custom tag: " + ioEx.toString());
        }
        try {
            R01MSearchResultDecoratorDirectiveListener dirListener = new R01MSearchResultDecoratorDirectiveListener(lang, searchServiceURL, moreParameters, qryURLEncoded, guideDefOid, currGuideNodePath);
            Pattern p = Pattern.compile("(\\$\\[r01[^]$]+\\]\\$)");
            Matcher m = p.matcher(textToDecorate);
            boolean directiveValid = m.find();
            String foundDirective = null;
            int dirPos = -1;
            String replaceString = null;
            while (directiveValid) {
                foundDirective = textToDecorate.substring(m.start(), m.end());
                replaceString = new String(dirListener.processDirective(foundDirective, dirPos = m.start()));
                if (replaceString != null && replaceString.indexOf("[ERROR]") > 0) {
                    R01FLog.to((String)"r01m.session").warning("ERROR al decorar el resultado de busqueda...\r\n" + replaceString);
                }
                if (replaceString != null) {
                    m.appendReplacement(decoratedText, replaceString);
                }
                directiveValid = m.find();
            }
            m.appendTail(decoratedText);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
        return decoratedText;
    }

    public static StringBuffer decorateSearchResult(String lang, String searchServiceURL, String moreParameters, String qryURLEncoded, String guideDefOid, String currGuideNodePath, StringBuffer textToDecorate) throws R01MSearchWebException {
        StringReader r = new StringReader(textToDecorate.toString());
        return R01MSearchEngineUtils.decorateSearchResult(lang, searchServiceURL, moreParameters, qryURLEncoded, guideDefOid, currGuideNodePath, (Reader)r);
    }

    public static String decorateRSSFeedLink(String rssId, String queryString, boolean showText, Properties propRSS) {
        StringBuffer outHtml = new StringBuffer("");
        String rssTitle = (String)propRSS.get("rssTitle");
        String subscripcionRSS = (String)propRSS.get("subscripcionRSS");
        String whatIsRSS = (String)propRSS.get("whatIsRSS");
        String lang = (String)propRSS.get("lang");
        String presentationPage = (String)propRSS.get("presentationPage");
        if (R01MSearchEngineWebConstants.ACTIVE_RSSFEED == 1) {
            R01MLink rssUrlReference = new R01MLink();
            rssUrlReference.setType(8);
            rssUrlReference.setWindowAppareance(new R01MWindowAppearance());
            R01MLinkItem urlResult = new R01MLinkItem();
            StringBuffer urlToEncode = new StringBuffer(50);
            String ampersand = "&amp;";
            urlToEncode.append("r01kLang");
            urlToEncode.append('=');
            urlToEncode.append(lang);
            urlToEncode.append(ampersand);
            urlToEncode.append(queryString);
            urlToEncode.append(ampersand);
            urlToEncode.append("r01kPageContents");
            urlToEncode.append('=');
            urlToEncode.append(presentationPage);
            urlToEncode.append(ampersand);
            urlToEncode.append("r01kRssTitle");
            urlToEncode.append('=');
            urlToEncode.append(rssTitle);
            urlToEncode.append(ampersand);
            urlToEncode.append("r01kRss");
            urlToEncode.append("=1");
            urlResult.setUrl("/r01htSearchResultWAR/r01hPresentationRSS.jsp?" + urlToEncode.toString());
            ArrayList<R01MLinkItem> refResults = new ArrayList<R01MLinkItem>();
            refResults.add(urlResult);
            rssUrlReference.setLinks(refResults);
            rssUrlReference.getFirstLinkItem().setTitle(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "visualAreasResources", lang, "portal.rss.linkTitle"));
            StringBuffer rssHTML = new StringBuffer();
            String typeVA = (String)propRSS.get("typeVA");
            if (StringUtils.isEmptyString((String)typeVA) || !"SearchResult".equals(typeVA)) {
                rssHTML.append("<img id=\"rssImg_");
                rssHTML.append(rssId);
                rssHTML.append("\" class=\"rssDecorateImage\" src=\"/AVComun/images/r01feedrss.gif\" alt=\"");
                if (StringUtils.isEmptyString((String)rssTitle)) {
                    rssHTML.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "visualAreasResources", lang, "portal.rss.linkTitle"));
                } else {
                    rssHTML.append(URLDecoder.decode((String)rssTitle, null));
                }
                rssHTML.append("\"/>");
                if (showText) {
                    rssHTML.append(subscripcionRSS);
                }
                outHtml.append(R01MLinkUtils.getHtml(rssUrlReference, rssHTML.toString()));
            } else {
                if (showText) {
                    rssHTML.append(subscripcionRSS);
                }
                String linkClass = "r01RssSearchLink";
                outHtml.append(R01MLinkUtils.getHtml(rssUrlReference, null, rssHTML.toString(), linkClass, 0));
            }
            if (showText) {
                Properties vars = new Properties();
                vars.put("LANG", lang != null ? lang : R01MConstants.DEFAULT_LANG);
                String thePresentationPage = presentationPage != null ? (presentationPage.endsWith("/") ? presentationPage.substring(0, presentationPage.length() - 1) : presentationPage) : "";
                String rssHelpPortalPage = thePresentationPage + R01MSearchEngineWebConstants.RSS_PAGE_INFO;
                rssHelpPortalPage = StringUtils.replaceVariableValues((String)rssHelpPortalPage, (char)'$', (Map)vars);
                outHtml.append(" - <a href=\"");
                outHtml.append(rssHelpPortalPage);
                outHtml.append("\" title=\"feeds RSS\" target=\"_blank\">");
                outHtml.append(whatIsRSS);
                outHtml.append("</a>");
            }
        }
        return outHtml.toString();
    }

    public static String decorateRispLink(String linkId, String queryString, boolean showText, Properties propRisp) {
        StringBuffer outHtml = new StringBuffer("");
        String rispUrl = (String)propRisp.get("rispUrl");
        String rispImage = (String)propRisp.get("rispImage");
        String rispTitle = (String)propRisp.get("rispTitle");
        String labelRisp = (String)propRisp.get("labelRisp");
        String whatIsRisp = (String)propRisp.get("whatIsRisp");
        String whatIsRispTitle = (String)propRisp.get("whatIsRispTitle");
        String lang = (String)propRisp.get("lang");
        String presentationPage = (String)propRisp.get("presentationPage");
        if (R01MSearchEngineWebConstants.ACTIVE_RISP == 1) {
            R01MLink rispUrlReference = new R01MLink();
            rispUrlReference.setType(8);
            rispUrlReference.setWindowAppareance(new R01MWindowAppearance());
            R01MLinkItem urlResult = new R01MLinkItem();
            StringBuffer urlToEncode = new StringBuffer(50);
            String ampersand = "&amp;";
            urlToEncode.append("r01kLang");
            urlToEncode.append('=');
            urlToEncode.append(lang);
            urlToEncode.append(ampersand);
            urlToEncode.append(queryString);
            urlResult.setUrl(rispUrl + "?" + urlToEncode.toString());
            ArrayList<R01MLinkItem> refResults = new ArrayList<R01MLinkItem>();
            refResults.add(urlResult);
            rispUrlReference.setLinks(refResults);
            rispUrlReference.getFirstLinkItem().setTitle(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.xml.linkTitle"));
            StringBuffer rispHTML = new StringBuffer();
            String typeVA = (String)propRisp.get("typeVA");
            if (StringUtils.isEmptyString((String)typeVA) || !"SearchResult".equals(typeVA)) {
                rispHTML.append("<img id=\"rispImg_");
                rispHTML.append(linkId);
                rispHTML.append("\" class=\"rispDecorateImage\" src=\"");
                rispHTML.append(rispImage);
                rispHTML.append("\" alt=\"");
                if (StringUtils.isEmptyString((String)rispTitle)) {
                    rispHTML.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.xml.linkTitle"));
                } else {
                    rispHTML.append(URLDecoder.decode((String)rispTitle, null));
                }
                rispHTML.append("\"/>");
                if (showText) {
                    rispHTML.append(labelRisp);
                }
                outHtml.append(R01MLinkUtils.getHtml(rispUrlReference, rispHTML.toString()));
            } else {
                if (showText) {
                    rispHTML.append(labelRisp);
                }
                String linkClass = linkId + "Link";
                outHtml.append(R01MLinkUtils.getHtml(rispUrlReference, null, rispHTML.toString(), linkClass, 0));
            }
            if (showText) {
                Properties vars = new Properties();
                vars.put("LANG", lang != null ? lang : R01MConstants.DEFAULT_LANG);
                String thePresentationPage = presentationPage != null ? (presentationPage.endsWith("/") ? presentationPage.substring(0, presentationPage.length() - 1) : presentationPage) : "";
                String rispHelpPortalPage = thePresentationPage + (String)propRisp.get("rispPageInfo");
                rispHelpPortalPage = StringUtils.replaceVariableValues((String)rispHelpPortalPage, (char)'$', (Map)vars);
                outHtml.append(" - <a href=\"");
                outHtml.append(rispHelpPortalPage);
                outHtml.append("\" title=\"");
                outHtml.append(whatIsRispTitle);
                outHtml.append("\" target=\"_blank\">");
                outHtml.append(whatIsRisp);
                outHtml.append("</a>");
            }
        }
        return outHtml.toString();
    }

    public static List composeQueryPresentationEffectiveMetaDataList(List metaData, boolean showAllMetadataDescription) {
        if (metaData == null) {
            return null;
        }
        HashMap<String, R01MSearchedMetaData> mdMap = new HashMap<String, R01MSearchedMetaData>(metaData.size());
        R01MSearchedMetaData currMD2 = null;
        String currMDOid2 = null;
        for (R01MSearchedMetaData currMD2 : metaData) {
            mdMap.put(currMD2.getOid(), currMD2);
        }
        ArrayList<R01MSearchedMetaData> outMetaDataList = new ArrayList<R01MSearchedMetaData>();
        if (QRY_PRESENTATION_METADATA_ORDER != null) {
            for (String currMDOid2 : QRY_PRESENTATION_METADATA_ORDER) {
                currMD2 = (R01MSearchedMetaData)mdMap.get(currMDOid2);
                if (currMD2 == null) continue;
                outMetaDataList.add(currMD2);
                mdMap.remove(currMDOid2);
            }
        }
        if (QRY_PRESENTATION_EXCLUDED_METADATA != null && !showAllMetadataDescription) {
            for (String currMDOid2 : QRY_PRESENTATION_EXCLUDED_METADATA) {
                mdMap.remove(currMDOid2);
            }
        }
        outMetaDataList.addAll(mdMap.values());
        return outMetaDataList;
    }

    public static StringBuffer formatLabelsList(String lang, List theList, boolean and) {
        StringBuffer sb;
        if (theList != null && !theList.isEmpty()) {
            sb = new StringBuffer(50);
            R01MSearchedStructureCatalog currCat = null;
            String currLabelStr = null;
            Iterator it = theList.iterator();
            while (it.hasNext()) {
                currCat = (R01MSearchedStructureCatalog)it.next();
                try {
                    List organismosLabels = R01MClientFactory.getCatalogAPI(R01MAuthManager.createMasterSystemUserContext()).loadLabelInStructureWithRole(R01MConstants.FIXED_STRUCTURES.departamentosStructOid, currCat.getLabelOid(), Integer.parseInt(R01MConstants.FIXED_STRUCTURES.departamentosStructRole));
                }
                catch (R01MCatalogException e) {
                    e.printStackTrace();
                }
                catch (R01MSecurityException e) {
                    e.printStackTrace();
                }
                currLabelStr = R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(currCat.getStructureOid(), currCat.getLabelOid(), currCat.getRole());
                sb.append(currLabelStr);
                if (it.hasNext() && and) {
                    sb.append(' ');
                    sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "item.and"));
                    sb.append(' ');
                    continue;
                }
                if (!it.hasNext() || and) continue;
                sb.append(' ');
                sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "item.or"));
                sb.append(' ');
            }
        } else {
            sb = new StringBuffer("");
        }
        return sb;
    }

    public static StringBuffer[] formatLabelsListByStructure(String lang, List theList, boolean and) {
        StringBuffer sb = null;
        StringBuffer sbOrganismos = new StringBuffer();
        if (theList != null && !theList.isEmpty()) {
            R01MSearchedStructureCatalog currCat2 = null;
            String currLabelStr = null;
            for (R01MSearchedStructureCatalog currCat2 : theList) {
                currLabelStr = R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(currCat2.getStructureOid(), currCat2.getLabelOid(), currCat2.getRole());
                boolean isFixedStructure = false;
                for (int i = 1; i <= 4 && !(isFixedStructure = R01MSearchEngineUtils.searchLaLabelInOrganizationStructure(currCat2.getLabelOid(), currLabelStr, sbOrganismos, i, lang, and)); ++i) {
                }
                if (isFixedStructure) continue;
                if (sb == null) {
                    sb = new StringBuffer(50);
                }
                sb.append(currLabelStr);
                R01MSearchEngineUtils.setDataSeparator(sb, and, lang);
            }
        }
        if (sb != null && sb.toString().endsWith(";&nbsp;")) {
            sb.delete(sb.toString().lastIndexOf(";&nbsp;"), sb.toString().lastIndexOf(";&nbsp;") + 7);
        }
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)sbOrganismos)) {
            if (sbOrganismos.toString().endsWith(";&nbsp;")) {
                sbOrganismos.delete(sbOrganismos.toString().lastIndexOf(";&nbsp;"), sbOrganismos.toString().lastIndexOf(";&nbsp;") + 7);
            }
        } else {
            sbOrganismos = null;
        }
        StringBuffer[] labelsList = new StringBuffer[3];
        labelsList[0] = sb;
        labelsList[1] = sbOrganismos;
        return labelsList;
    }

    public static StringBuffer formatLabelListBlock(String structureLabels, String blockLiteral, String catalaogId) {
        StringBuffer sb = new StringBuffer(200);
        sb.append("<li><span id='catalog_").append(catalaogId).append("' class=\"r01QueryCatalog\"><span class='r01FullQueryTitle'>").append(blockLiteral).append("</span><span class='r01FullQueryText'>&nbsp;").append(structureLabels).append("</span></span></li>");
        return sb;
    }

    public static StringBuffer formatMetaDataList(String lang, List clusters, List families, List typos, List metaData, List orderByMetaData) {
        return R01MSearchEngineUtils.formatMetaDataList(lang, clusters, families, typos, metaData, orderByMetaData, false);
    }

    public static StringBuffer formatMetaDataList(String lang, List clusters, List families, List typos, List metaData, List orderByMetaData, boolean showAllMetadataDescription) {
        if (metaData == null || metaData.isEmpty()) {
            return new StringBuffer("");
        }
        R01MSearchedCluster cluster = clusters != null && !clusters.isEmpty() ? (R01MSearchedCluster)clusters.get(0) : null;
        R01MSearchedFamily family = families != null && !families.isEmpty() ? (R01MSearchedFamily)families.get(0) : null;
        R01MSearchedContentType type = typos != null && !typos.isEmpty() ? (R01MSearchedContentType)typos.get(0) : null;
        StringBuffer sb = new StringBuffer(200);
        List effectiveMetaDataList = R01MSearchEngineUtils.composeQueryPresentationEffectiveMetaDataList(metaData, showAllMetadataDescription);
        if (effectiveMetaDataList != null && !effectiveMetaDataList.isEmpty()) {
            R01MSearchedMetaData currSearchedMetaData = null;
            Iterator it = effectiveMetaDataList.iterator();
            while (it.hasNext()) {
                currSearchedMetaData = (R01MSearchedMetaData)it.next();
                if (currSearchedMetaData.getValue() != null && !StringUtils.isEmptyString((String)currSearchedMetaData.getValue())) {
                    if (currSearchedMetaData.getOid().equals("fullText")) {
                        if (currSearchedMetaData.getValue() != null && !StringUtils.isEmptyString((String)currSearchedMetaData.getValue())) {
                            sb.append(R01MFullTextQueryUtils.filterWords(currSearchedMetaData.getValue(), "<(.|\\n)+?>"));
                        }
                    } else {
                        sb.append(R01MSearchFormatterDirectiveUtils.composeMetaDataNameDirective(cluster != null ? cluster.getOid() : "null", family != null ? family.getOid() : "null", type != null ? type.getOid() : "null", currSearchedMetaData.getOid(), currSearchedMetaData.getValue()));
                        if (0 <= currSearchedMetaData.getValue().indexOf("(")) {
                            sb.append(R01MSearchFormatterDirectiveUtils.composeMetaDataDirective(cluster != null ? cluster.getOid() : "null", family != null ? family.getOid() : "null", type != null ? type.getOid() : "null", currSearchedMetaData.getOid(), currSearchedMetaData.getValue()));
                        } else {
                            sb.append(":&nbsp;(");
                            sb.append(R01MSearchFormatterDirectiveUtils.composeMetaDataDirective(cluster != null ? cluster.getOid() : "null", family != null ? family.getOid() : "null", type != null ? type.getOid() : "null", currSearchedMetaData.getOid(), currSearchedMetaData.getValue()));
                            sb.append(')');
                        }
                    }
                }
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
        }
        return sb;
    }

    public static StringBuffer formatSearchResultMetaDataList(String lang, List clusters, List families, List typos, List metaData, List orderByMetaData, boolean showAllMetadataDescription) {
        if (metaData == null || metaData.isEmpty()) {
            return new StringBuffer("");
        }
        R01MSearchedCluster cluster = clusters != null && !clusters.isEmpty() ? (R01MSearchedCluster)clusters.get(0) : null;
        R01MSearchedFamily family = families != null && !families.isEmpty() ? (R01MSearchedFamily)families.get(0) : null;
        R01MSearchedContentType type = typos != null && !typos.isEmpty() ? (R01MSearchedContentType)typos.get(0) : null;
        StringBuffer sb = new StringBuffer(200);
        List effectiveMetaDataList = R01MSearchEngineUtils.composeQueryPresentationEffectiveMetaDataList(metaData, showAllMetadataDescription);
        if (effectiveMetaDataList != null && !effectiveMetaDataList.isEmpty()) {
            R01MSearchedMetaData currSearchedMetaData2 = null;
            for (R01MSearchedMetaData currSearchedMetaData2 : effectiveMetaDataList) {
                boolean isDate;
                String operatorMessage;
                block16: {
                    if (currSearchedMetaData2.getValue() == null || StringUtils.isEmptyString((String)currSearchedMetaData2.getValue())) continue;
                    if (currSearchedMetaData2.getOid().equals("fullText")) {
                        if (currSearchedMetaData2.getValue() == null || StringUtils.isEmptyString((String)currSearchedMetaData2.getValue())) continue;
                        sb.append("<li>").append("<span id=\"metaId_").append(currSearchedMetaData2.getOid()).append("\" class='r01QueryTypoMetaData'>").append("<span class='r01FullQueryTitle'>").append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "item.full.fullTerm")).append("</span>").append("&nbsp;").append("<span class='r01FullQueryText'>").append(R01MFullTextQueryUtils.filterWords(currSearchedMetaData2.getValue(), "<(.|\\n)+?>")).append("</span>").append("</span>").append("</li>");
                        continue;
                    }
                    sb.append("<li>").append("<span id=\"metaId_").append(currSearchedMetaData2.getOid()).append("\" class='r01QueryTypoMetaData'>").append("<span class='r01FullQueryTitle'>").append(R01MSearchFormatterDirectiveUtils.composeMetaDataNameDirective(cluster != null ? cluster.getOid() : "null", family != null ? family.getOid() : "null", type != null ? type.getOid() : "null", currSearchedMetaData2.getOid(), currSearchedMetaData2.getValue())).append("</span>");
                    String operator = currSearchedMetaData2.getOid() + "." + OPERATOR_PREFIX + currSearchedMetaData2.getOperationSelected();
                    operatorMessage = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, operator);
                    if (operatorMessage == null || operatorMessage.length() <= 0) {
                        operator = OPERATOR_PREFIX + currSearchedMetaData2.getOperationSelected();
                        operatorMessage = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, operator);
                    }
                    isDate = false;
                    if ("eu".equals(lang)) {
                        String dateStr1 = null;
                        String dateStr2 = null;
                        if (currSearchedMetaData2.getValue().matches("\\d{2}/\\d{2}/\\d{4}")) {
                            dateStr1 = currSearchedMetaData2.getValue();
                            isDate = true;
                        } else if (currSearchedMetaData2.getValue().matches("\\d{2}/\\d{2}/\\d{4},\\d{2}/\\d{2}/\\d{4}")) {
                            dateStr1 = currSearchedMetaData2.getValue().split(",")[0];
                            dateStr2 = currSearchedMetaData2.getValue().split(",")[1];
                            isDate = true;
                        }
                        if (dateStr1 != null) {
                            try {
                                Date date1 = DateUtils.getDateFromFormatedString((String)dateStr1, (String)"dd/MM/yyyy");
                                if (dateStr2 == null) {
                                    currSearchedMetaData2.setValue(DateUtils.getDateFormated((Date)date1, (String)"yyyy/MM/dd"));
                                    break block16;
                                }
                                Date date2 = DateUtils.getDateFromFormatedString(dateStr2, (String)"dd/MM/yyyy");
                                currSearchedMetaData2.setValue(DateUtils.getDateFormated((Date)date1, (String)"yyyy/MM/dd") + "&nbsp;-&nbsp;" + DateUtils.getDateFormated((Date)date2, (String)"yyyy/MM/dd"));
                            }
                            catch (Exception e) {}
                        }
                    } else if (currSearchedMetaData2.getValue().matches("\\d{2}/\\d{2}/\\d{4},\\d{2}/\\d{2}/\\d{4}")) {
                        currSearchedMetaData2.setValue(currSearchedMetaData2.getValue().replace(",", "&nbsp;-&nbsp;"));
                        isDate = true;
                    }
                }
                if (!isDate && "BETWEEN".equals(currSearchedMetaData2.getOperationSelected().toUpperCase()) && currSearchedMetaData2.getValue().indexOf(",") != -1) {
                    currSearchedMetaData2.setValue(currSearchedMetaData2.getValue().replace(",", "&nbsp;-&nbsp;"));
                }
                sb.append("<span class='r01FullQueryText'>:&nbsp;");
                sb.append(R01MSearchEngineUtils.composeOperatorLiteral(operatorMessage, R01MSearchFormatterDirectiveUtils.composeMetaDataDirective(cluster != null ? cluster.getOid() : "null", family != null ? family.getOid() : "null", type != null ? type.getOid() : "null", currSearchedMetaData2.getOid(), currSearchedMetaData2.getValue())));
                sb.append("</span></span></li>");
            }
        }
        return sb;
    }

    public static StringBuffer formatFullTextMetadata(String lang, List clusters, List families, List typos, List metaData) {
        return R01MSearchEngineUtils.formatFullTextMetadata(lang, clusters, families, typos, metaData, false);
    }

    public static StringBuffer formatFullTextMetadata(String lang, List clusters, List families, List typos, List metaData, boolean showAllMetadataDescription) {
        if (metaData == null || metaData.isEmpty()) {
            return new StringBuffer("");
        }
        R01MSearchedCluster cluster = clusters != null && !clusters.isEmpty() ? (R01MSearchedCluster)clusters.get(0) : null;
        R01MSearchedFamily family = families != null && !families.isEmpty() ? (R01MSearchedFamily)families.get(0) : null;
        R01MSearchedContentType type = typos != null && !typos.isEmpty() ? (R01MSearchedContentType)typos.get(0) : null;
        StringBuffer sb = new StringBuffer(200);
        boolean swOpenSpan = true;
        boolean swCloseSpan = false;
        List effectiveMetaDataList = R01MSearchEngineUtils.composeQueryPresentationEffectiveMetaDataList(metaData, showAllMetadataDescription);
        if (effectiveMetaDataList != null && !effectiveMetaDataList.isEmpty()) {
            R01MSearchedMetaData currSearchedMetaData2 = null;
            for (R01MSearchedMetaData currSearchedMetaData2 : effectiveMetaDataList) {
                if (currSearchedMetaData2.getValue() == null || StringUtils.isEmptyString((String)currSearchedMetaData2.getValue())) continue;
                if (currSearchedMetaData2.getOid().equals("fullText")) {
                    if (currSearchedMetaData2.getValue() == null || StringUtils.isEmptyString((String)currSearchedMetaData2.getValue())) continue;
                    sb.append("<span class='r01QueryTypoMetaData'><div><span class='r01FullQueryTitle'>");
                    sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "item.full.fullText"));
                    sb.append("</span>&nbsp;<span class='r01FullQueryText'>");
                    sb.append(R01MFullTextQueryUtils.filterWords(currSearchedMetaData2.getValue(), "<(.|\\n)+?>"));
                    sb.append("</span></div></span>#");
                    continue;
                }
                if (swOpenSpan) {
                    sb.append("<span class='r01QueryTypoMetaData'><div><span class='r01FullQueryTitle'>");
                    sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "item.full.metadata"));
                    sb.append("</span></div>");
                    swOpenSpan = false;
                    swCloseSpan = true;
                }
                sb.append("<div><span class='r01FullQueryTitle'>&nbsp;-&nbsp;");
                sb.append(R01MSearchFormatterDirectiveUtils.composeMetaDataNameDirective(cluster != null ? cluster.getOid() : "null", family != null ? family.getOid() : "null", type != null ? type.getOid() : "null", currSearchedMetaData2.getOid(), currSearchedMetaData2.getValue()));
                sb.append("</span>");
                String operator = OPERATOR_PREFIX + currSearchedMetaData2.getOperationSelected();
                String operatorMessage = R01MSearchEngineUtils.composeOperatorLiteral(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, operator), "");
                sb.append("<span class='r01FullQueryText'>:&nbsp;");
                sb.append(operatorMessage);
                sb.append("&nbsp;");
                if (0 <= currSearchedMetaData2.getValue().indexOf("(")) {
                    sb.append(R01MSearchFormatterDirectiveUtils.composeMetaDataDirective(cluster != null ? cluster.getOid() : "null", family != null ? family.getOid() : "null", type != null ? type.getOid() : "null", currSearchedMetaData2.getOid(), currSearchedMetaData2.getValue()));
                } else {
                    sb.append(R01MSearchFormatterDirectiveUtils.composeMetaDataDirective(cluster != null ? cluster.getOid() : "null", family != null ? family.getOid() : "null", type != null ? type.getOid() : "null", currSearchedMetaData2.getOid(), currSearchedMetaData2.getValue()));
                }
                sb.append("</span></div>");
            }
        }
        if (swCloseSpan) {
            sb.append("</span>");
        }
        return sb;
    }

    public static StringBuffer formatFullTextOrderMetadata(String lang, List clusters, List families, List typos, List orderMetadata) {
        String typeOid;
        String text = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "item.full.result.orderby");
        StringBuffer sb = new StringBuffer(200);
        R01MSearchedCluster cluster = clusters != null && !clusters.isEmpty() ? (R01MSearchedCluster)clusters.get(0) : null;
        R01MSearchedFamily family = families != null && !families.isEmpty() && families.size() == 1 ? (R01MSearchedFamily)families.get(0) : null;
        R01MSearchedContentType type = typos != null && !typos.isEmpty() && typos.size() == 1 ? (R01MSearchedContentType)typos.get(0) : null;
        String clusterOid = cluster != null ? cluster.getOid() : null;
        String familyOid = family != null ? family.getOid() : null;
        String string = typeOid = type != null ? type.getOid() : null;
        if (!orderMetadata.isEmpty()) {
            sb.append("<span class='r01QueryTypoMetaData'><div><span class='r01FullQueryTitle'>");
            sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "item.full.orderby"));
            sb.append("&nbsp</span><span class='r01FullQueryText'>");
            Iterator mdIt = orderMetadata.iterator();
            while (mdIt.hasNext()) {
                R01MSearchedOrderByMetaData orderMD = (R01MSearchedOrderByMetaData)mdIt.next();
                try {
                    R01MContentTypeMetaData ctm = R01MClientFactory.getTypologyConfigAPI().getContentTypeMetaData(clusterOid, familyOid, typeOid, orderMD.getOid());
                    String name = ctm != null && ctm.getName(lang) != null ? ctm.getName(lang) : "";
                    sb.append(R01MSearchEngineUtils.composeOperatorLiteral(text, name.concat(",").concat(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, OPERATOR_PREFIX + orderMD.getOrder()))));
                }
                catch (R01MConfigLoadException ex) {
                    ex.printStackTrace(System.out);
                    return new StringBuffer();
                }
                if (!mdIt.hasNext()) continue;
                sb.append(",&nbsp");
            }
            sb.append("</span></div></span>");
            return sb;
        }
        return sb;
    }

    public static StringBuffer formatSearchResultOrderMetadata(String lang, List clusters, List families, List typos, List orderMetadata) {
        String typeOid;
        String text = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "item.full.result.orderby");
        StringBuffer sb = new StringBuffer(200);
        R01MSearchedCluster cluster = clusters != null && !clusters.isEmpty() ? (R01MSearchedCluster)clusters.get(0) : null;
        R01MSearchedFamily family = families != null && !families.isEmpty() && families.size() == 1 ? (R01MSearchedFamily)families.get(0) : null;
        R01MSearchedContentType type = typos != null && !typos.isEmpty() && typos.size() == 1 ? (R01MSearchedContentType)typos.get(0) : null;
        String clusterOid = cluster != null ? cluster.getOid() : null;
        String familyOid = family != null ? family.getOid() : null;
        String string = typeOid = type != null ? type.getOid() : null;
        if (!orderMetadata.isEmpty()) {
            sb.append("<span id='meta_Order' class='r01QueryTypoMetaData'><span class='r01FullQueryTitle'>");
            sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "item.full.orderby"));
            sb.append("&nbsp</span><span class='r01FullQueryText'>");
            Iterator mdIt = orderMetadata.iterator();
            while (mdIt.hasNext()) {
                R01MSearchedOrderByMetaData orderMD = (R01MSearchedOrderByMetaData)mdIt.next();
                try {
                    R01MContentTypeMetaData ctm = R01MClientFactory.getTypologyConfigAPI().getContentTypeMetaData(clusterOid, familyOid, typeOid, orderMD.getOid());
                    String name = ctm != null && ctm.getName(lang) != null ? ctm.getName(lang) : "";
                    sb.append(R01MSearchEngineUtils.composeOperatorLiteral(text, name.concat(",").concat(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, OPERATOR_PREFIX + orderMD.getOrder()))));
                }
                catch (R01MConfigLoadException ex) {
                    ex.printStackTrace(System.out);
                    return new StringBuffer();
                }
                if (!mdIt.hasNext()) continue;
                sb.append(",&nbsp");
            }
            sb.append("</span></span>");
            return sb;
        }
        return sb;
    }

    public static StringBuffer formatTypo(String lang, List clusters, List families, List types) {
        Iterator<R01MContentCluster> it;
        if (!(clusters != null && !clusters.isEmpty() || families != null && !families.isEmpty() || types != null && !types.isEmpty())) {
            return new StringBuffer("");
        }
        StringBuffer sb = new StringBuffer(300);
        String clusterOid = "euskadi";
        if (clusters != null && !clusters.isEmpty()) {
            clusterOid = ((R01MSearchedCluster)clusters.get(0)).getOid();
        } else {
            try {
                Map<String, R01MContentCluster> clusterCfgs = R01MClientFactory.getTypologyConfigAPI().getAllClusterConfig();
                if (clusterCfgs != null && (it = clusterCfgs.values().iterator()).hasNext()) {
                    clusterOid = it.next().getOid();
                }
            }
            catch (R01MConfigLoadException cfgLoadEx) {
                cfgLoadEx.printStackTrace(System.out);
            }
        }
        if (families != null && !families.isEmpty()) {
            R01MSearchedFamily currSearchedFamily = null;
            it = families.iterator();
            while (it.hasNext()) {
                currSearchedFamily = (R01MSearchedFamily)((Object)it.next());
                if (types != null && !types.isEmpty()) continue;
                sb.append(R01MSearchFormatterDirectiveUtils.composeTypoDirective(clusterOid, currSearchedFamily.getOid(), null));
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            if (types != null && !types.isEmpty()) {
                R01MSearchedContentType currSearchedType = null;
                sb.append(R01MSearchFormatterDirectiveUtils.composeTypoDirective(clusterOid, currSearchedFamily.getOid(), null));
                sb.append(" (");
                Iterator it2 = types.iterator();
                while (it2.hasNext()) {
                    currSearchedType = (R01MSearchedContentType)it2.next();
                    sb.append(R01MSearchFormatterDirectiveUtils.composeTypoDirective(clusterOid, currSearchedFamily.getOid(), currSearchedType.getOid()));
                    if (!it2.hasNext()) continue;
                    sb.append(',');
                }
                sb.append(')');
            }
        }
        return sb;
    }

    public static String formatDateTypeSearchResultMetaData(String lang, String dateStr) {
        if (dateStr == null) {
            return "";
        }
        String searchResultsDateFormat = DateUtils.getLanguageDateFormat((String)lang, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
        String presentationDateFormat = DateUtils.getLanguageDateFormat((String)lang, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS);
        return DateUtils.reformatDateString((String)dateStr, (String)searchResultsDateFormat, (String)presentationDateFormat);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map formatAndDecorateSearchResult(String lang, R01MSearchSessionFormatterPreferences prefs, R01MSearchResultItem[] items) {
        Map<Object, Object> formatedAndDecoratedResults = new LinkedHashMap();
        R01MSearchSessionFormatterPreferences appliedPrefs = prefs == null ? new R01MSearchSessionFormatterPreferences() : prefs;
        if (appliedPrefs.formatterImpls.searchResultItemFormatterClassName == null) return new HashMap();
        try {
            R01MSearchResultItemsFormatter resultsFormatter = (R01MSearchResultItemsFormatter)ReflectionUtils.getObjectInstance((String)appliedPrefs.formatterImpls.searchResultItemFormatterClassName);
            formatedAndDecoratedResults = resultsFormatter.doFormatSimpleResultItems(lang, appliedPrefs.resultsFormatterPreferences, items);
            if (items == null) return formatedAndDecoratedResults;
            if (items.length <= 0) return formatedAndDecoratedResults;
            int i = 0;
            while (i < items.length) {
                try {
                    StringBuffer itemHtml = (StringBuffer)formatedAndDecoratedResults.get(items[i].getDocumentOid());
                    formatedAndDecoratedResults.put(items[i].documentOid, R01MSearchEngineUtils.decorateSearchResult(lang, null, null, null, null, null, itemHtml));
                }
                catch (R01MSearchWebException ex) {
                    ex.printStackTrace(System.out);
                }
                ++i;
            }
            return formatedAndDecoratedResults;
        }
        catch (ReflectionException refEx) {
            refEx.printStackTrace(System.out);
            return formatedAndDecoratedResults;
        }
    }

    public static Map formatAndDecorateSearchResult(String lang, R01MSearchResultItem[] items) {
        return R01MSearchEngineUtils.formatAndDecorateSearchResult(lang, R01MSearchEngineUtils.composeDataGridFormatterPreferences(), items);
    }

    public static R01MSearchSessionFormatterPreferences composeDataGridFormatterPreferences() {
        String itemFormatterClassName;
        R01MSearchSessionFormatterPreferences prefs = new R01MSearchSessionFormatterPreferences();
        prefs.formatterImpls.sessionFormatterClassName = "com.ejie.r01m.searchengine.formatters.html.defaults.R01MDefSearchSessionHtmlFormatter";
        prefs.formatterImpls.searchResultItemFormatterClassName = itemFormatterClassName = XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"searchEngine/contentListHTMLFormatters/searchResultItem", (String)"com.ejie.r01m.searchengine.formatters.html.contentlist.R01MContentListSearchResultItemsHtmlFormatter");
        R01MWindowAppearance contentPageWindowAppearance = new R01MWindowAppearance();
        contentPageWindowAppearance.setNewWindow(true);
        prefs.resultsFormatterPreferences.itemUrlPrefix = R01MConstants.PREV_PAGE;
        prefs.resultsFormatterPreferences.formatterAtributtes = new HashMap();
        prefs.resultsFormatterPreferences.formatterAtributtes.put("urlReferenceWindowAppearance", contentPageWindowAppearance);
        prefs.showSearchBox = false;
        prefs.showGuide = false;
        prefs.showTagsCloud = false;
        prefs.queryFormatterPreferences.showRepositoriesResume = false;
        prefs.queryFormatterPreferences.showStorageConditionsResume = false;
        prefs.queryFormatterPreferences.showTypoConditionsResume = false;
        prefs.queryFormatterPreferences.showMetaDataConditionsResume = false;
        prefs.queryFormatterPreferences.showStructureLabelsConditionsResume = false;
        prefs.queryFormatterPreferences.showGeoLabelsConditionsResume = false;
        prefs.queryFormatterPreferences.showOrderByResume = false;
        prefs.guideFormatterPreferences.showGuideElementsSubTotals = false;
        prefs.guideFormatterPreferences.guideType = 2;
        prefs.guideFormatterPreferences.guideColumnsNum = 3;
        prefs.navBarFormatterPreferences.showSourceResultsNavBars = true;
        prefs.formatterImpls.searchResultsNavBarFormatterClassName = "";
        prefs.resultsFormatterPreferences.showContentInfoInResultItem = true;
        prefs.resultsFormatterPreferences.showDocumentInfoInResultItem = true;
        prefs.resultsFormatterPreferences.showDataFileInfoInResultItem = false;
        prefs.resultsFormatterPreferences.showCatalogInfoInResultItem = false;
        return prefs;
    }

    public static String fixTextForRSS(StringBuffer text) {
        return text != null ? R01MSearchEngineUtils.fixTextForRSS(text.toString()) : null;
    }

    public static String fixTextForRSS(String text) {
        if (text == null) {
            return null;
        }
        String textReplaced = text.replaceAll("\\<.*?\\>", "");
        textReplaced = StringEscapeUtils.unescapeHtml((String)textReplaced);
        return StringUtils.filterInvalidXMLCharacters((String)textReplaced);
    }

    public static String encodeQueryObjectInURL(R01MQueryObject qry) {
        return R01MSearchEngineUtils.encodeQueryObjectInURL(qry, true);
    }

    public static String encodeQueryObjectInURL(R01MQueryObject qry, boolean includePresentationProps) {
        String qryEncoded;
        StringBuffer outQry = new StringBuffer("");
        if (qry == null) {
            return outQry.toString();
        }
        if (includePresentationProps && qry.getQueryOid() != null) {
            outQry.append("i:" + qry.getQueryOid() + ";");
        }
        outQry.append(R01MSearchEngineUtils._composeSearchedObjListQueryString("sS", qry.getServers()));
        outQry.append(R01MSearchEngineUtils._composeSearchedObjListQueryString("sR", qry.getDataRepositories()));
        outQry.append(R01MSearchEngineUtils._composeSearchedObjListQueryString("sA", qry.getAreas()));
        outQry.append(R01MSearchEngineUtils._composeSearchedObjListQueryString("sW", qry.getWorkAreas()));
        outQry.append(R01MSearchEngineUtils._composeSearchedObjListQueryString("tC", qry.getContentClusters()));
        outQry.append(R01MSearchEngineUtils._composeSearchedObjListQueryString("tF", qry.getContentFamilies()));
        outQry.append(R01MSearchEngineUtils._composeSearchedObjListQueryString("tT", qry.getContentTypes()));
        outQry.append(R01MSearchEngineUtils._composeSearchedObjListQueryString("m", qry.getMetaData()));
        outQry.append(R01MSearchEngineUtils._composeSearchedObjListQueryString("mO", qry.getORMetaData()));
        outQry.append(R01MSearchEngineUtils._composeSearchedObjListQueryString("o", qry.getOrderBy()));
        outQry.append(R01MSearchEngineUtils._composeSearchedObjListQueryString("cA", qry.getCatalogLabelsAnd()));
        outQry.append(R01MSearchEngineUtils._composeSearchedObjListQueryString("cO", qry.getCatalogLabelsOr()));
        outQry.append(R01MSearchEngineUtils._composeSearchedObjListQueryString("p", qry.getPublishRepositories()));
        if (includePresentationProps) {
            outQry.append(R01MSearchEngineUtils._composeQueryPresentationPropertiesQueryString("pp", qry.getPresentationProperties()));
        }
        try {
            qryEncoded = URLEncoder.encode((String)outQry.toString(), (String)URL_ENCODING_UTF);
        }
        catch (UnsupportedEncodingException ex) {
            qryEncoded = outQry.toString();
        }
        return qryEncoded;
    }

    private static StringBuffer _composeSearchedObjListQueryString(String mark, List objList) {
        if (objList == null) {
            return new StringBuffer("");
        }
        StringBuffer outQry = new StringBuffer();
        outQry.append(mark);
        outQry.append(':');
        Iterator it = objList.iterator();
        while (it.hasNext()) {
            R01MBaseSearchedObj obj = (R01MBaseSearchedObj)it.next();
            if ("sR".equals(mark) || "sA".equals(mark) || "sW".equals(mark)) {
                String key = obj.getKey();
                outQry.append(key.substring(key.lastIndexOf(46) + 1));
            } else {
                outQry.append(obj.getKey());
            }
            if (!it.hasNext()) continue;
            outQry.append(',');
        }
        outQry.append(';');
        if (outQry.length() == mark.length() + 2) {
            return new StringBuffer("");
        }
        return outQry;
    }

    public static String encodeQueryObjectInString(R01MQueryObject qry) {
        StringBuffer outQry = new StringBuffer("");
        if (qry == null) {
            return outQry.toString();
        }
        outQry.append("i:" + qry.getQueryOid() + ";");
        outQry.append(R01MSearchEngineUtils._composeSearchedObjListQueryString("sS", qry.getServers()));
        outQry.append(R01MSearchEngineUtils._composeSearchedObjListQueryString("sR", qry.getDataRepositories()));
        outQry.append(R01MSearchEngineUtils._composeSearchedObjListQueryString("sA", qry.getAreas()));
        outQry.append(R01MSearchEngineUtils._composeSearchedObjListQueryString("sW", qry.getWorkAreas()));
        outQry.append(R01MSearchEngineUtils._composeSearchedObjListQueryString("tC", qry.getContentClusters()));
        outQry.append(R01MSearchEngineUtils._composeSearchedObjListQueryString("tF", qry.getContentFamilies()));
        outQry.append(R01MSearchEngineUtils._composeSearchedObjListQueryString("tT", qry.getContentTypes()));
        outQry.append(R01MSearchEngineUtils._composeSearchedObjListQueryString("m", qry.getMetaData()));
        outQry.append(R01MSearchEngineUtils._composeSearchedObjListQueryString("mO", qry.getORMetaData()));
        outQry.append(R01MSearchEngineUtils._composeSearchedObjListQueryString("o", qry.getOrderBy()));
        outQry.append(R01MSearchEngineUtils._composeSearchedObjListQueryString("cA", qry.getCatalogLabelsAnd()));
        outQry.append(R01MSearchEngineUtils._composeSearchedObjListQueryString("cO", qry.getCatalogLabelsOr()));
        outQry.append(R01MSearchEngineUtils._composeSearchedObjListQueryString("p", qry.getPublishRepositories()));
        outQry.append(R01MSearchEngineUtils._composeQueryPresentationPropertiesQueryString("pp", qry.getPresentationProperties()));
        return outQry.toString();
    }

    private static StringBuffer _composeQueryPresentationPropertiesQueryString(String mark, Map props) {
        StringBuffer outQry = new StringBuffer("");
        if (props != null && !props.isEmpty()) {
            outQry.append(mark);
            outQry.append(':');
            Map.Entry me = null;
            Iterator it = props.entrySet().iterator();
            while (it.hasNext()) {
                me = it.next();
                outQry.append((String)me.getKey());
                outQry.append('.');
                outQry.append(String.valueOf(me.getValue()));
                if (!it.hasNext()) continue;
                outQry.append(',');
            }
        }
        return outQry;
    }

    public static R01MQueryObject decodeURLInQueryObject(String queryString) {
        if (StringUtils.isEmptyString((String)queryString)) {
            return null;
        }
        R01MQueryObject outQry = new R01MQueryObject();
        String[] qryStrSplitted = queryString.split(";");
        if (qryStrSplitted != null && qryStrSplitted.length > 0) {
            for (int i = 0; i < qryStrSplitted.length; ++i) {
                if (R01MSearchEngineUtils._extractSearchedObjFromKey(qryStrSplitted[i], outQry)) continue;
                outQry = null;
                break;
            }
        }
        return outQry;
    }

    private static boolean _extractSearchedObjFromKey(String key, R01MQueryObject ioQry) {
        String patternStr = "(i|sS|sR|sA|sW|tC|tF|tT|m|mA|mO|o|cA|cO|p|pp):([^;:]+)";
        Pattern p = Pattern.compile(patternStr);
        Matcher m = p.matcher(key);
        if (m.find()) {
            String type = m.group(1);
            String values = m.group(2);
            if (!StringUtils.isEmptyString((String)values)) {
                String[] valuesSplitted = values.split(",");
                if ("i".equals(type)) {
                    ioQry.setQueryOid(m.group(2));
                } else if ("sS".equals(type)) {
                    for (int i = 0; i < valuesSplitted.length; ++i) {
                        ioQry.addServerFromKey(valuesSplitted[i]);
                    }
                } else if ("sR".equals(type)) {
                    for (int i = 0; i < valuesSplitted.length; ++i) {
                        if (ioQry.getServers() == null || ioQry.getServers().isEmpty()) continue;
                        Iterator itKeys = ioQry.getServers().iterator();
                        while (itKeys.hasNext()) {
                            ioQry.addDataRepositoryFromKey(((R01MSearchedServer)itKeys.next()).getServerOid() + "." + valuesSplitted[i]);
                        }
                    }
                } else if ("sA".equals(type)) {
                    for (int i = 0; i < valuesSplitted.length; ++i) {
                        if (ioQry.getServers() == null || ioQry.getServers().isEmpty()) continue;
                        Iterator itServerKeys = ioQry.getServers().iterator();
                        while (itServerKeys.hasNext()) {
                            String serverKey = ((R01MSearchedServer)itServerKeys.next()).getServerOid();
                            if (ioQry.getDataRepositories() == null || ioQry.getDataRepositories().isEmpty()) continue;
                            Iterator itKeys = ioQry.getDataRepositories().iterator();
                            while (itKeys.hasNext()) {
                                ioQry.addAreaFromKey(serverKey + "." + ((R01MSearchedDataRepository)itKeys.next()).getDataRepositoryOid() + "." + valuesSplitted[i]);
                            }
                        }
                    }
                } else if ("sW".equals(type)) {
                    for (int i = 0; i < valuesSplitted.length; ++i) {
                        if (ioQry.getServers() == null || ioQry.getServers().isEmpty()) continue;
                        Iterator itServerKeys = ioQry.getServers().iterator();
                        while (itServerKeys.hasNext()) {
                            String serverKey = ((R01MSearchedServer)itServerKeys.next()).getServerOid();
                            if (ioQry.getDataRepositories() == null || ioQry.getDataRepositories().isEmpty()) continue;
                            Iterator itDataRepositoryKeys = ioQry.getDataRepositories().iterator();
                            while (itDataRepositoryKeys.hasNext()) {
                                String datarepositoryKey = ((R01MSearchedDataRepository)itDataRepositoryKeys.next()).getDataRepositoryOid();
                                if (ioQry.getAreas() == null || ioQry.getAreas().isEmpty()) continue;
                                Iterator itKeys = ioQry.getAreas().iterator();
                                while (itKeys.hasNext()) {
                                    ioQry.addWorkAreaFromKey(serverKey + "." + datarepositoryKey + "." + ((R01MSearchedArea)itKeys.next()).getAreaOid() + "." + valuesSplitted[i]);
                                }
                            }
                        }
                    }
                } else if ("tC".equals(type)) {
                    for (int i = 0; i < valuesSplitted.length; ++i) {
                        ioQry.addContentClusterFromKey(valuesSplitted[i]);
                    }
                } else if ("tF".equals(type)) {
                    for (int i = 0; i < valuesSplitted.length; ++i) {
                        ioQry.addContentFamilyFromKey(valuesSplitted[i]);
                    }
                } else if ("tT".equals(type)) {
                    for (int i = 0; i < valuesSplitted.length; ++i) {
                        ioQry.addContentTypeFromKey(valuesSplitted[i]);
                    }
                } else if ("m".equals(type) || "mA".equals(type)) {
                    valuesSplitted = R01MSearchEngineUtils._splitMetaDataConditions(values);
                    for (int i = 0; i < valuesSplitted.length; ++i) {
                        ioQry.addMetaDataFromKey(valuesSplitted[i]);
                    }
                } else if ("mO".equals(type)) {
                    valuesSplitted = R01MSearchEngineUtils._splitMetaDataConditions(values);
                    for (int i = 0; i < valuesSplitted.length; ++i) {
                        ioQry.addORMetaDataFromKey(valuesSplitted[i]);
                    }
                } else if ("o".equals(type)) {
                    for (int i = 0; i < valuesSplitted.length; ++i) {
                        ioQry.addOrderByMetaDataFromKey(valuesSplitted[i]);
                    }
                } else if ("cA".equals(type)) {
                    for (int i = 0; i < valuesSplitted.length; ++i) {
                        ioQry.addANDStructureCatalogFromKey(valuesSplitted[i]);
                    }
                } else if ("cO".equals(type)) {
                    for (int i = 0; i < valuesSplitted.length; ++i) {
                        ioQry.addORStructureCatalogFromKey(valuesSplitted[i]);
                    }
                } else if ("p".equals(type)) {
                    for (int i = 0; i < valuesSplitted.length; ++i) {
                        ioQry.addPublishRepositoryFromKey(valuesSplitted[i]);
                        ioQry.setPublishedItemsOnly(true);
                    }
                } else if ("pp".equals(type)) {
                    for (int i = 0; i < valuesSplitted.length; ++i) {
                        String[] propertySplitted = valuesSplitted[i].split("\\.");
                        if (propertySplitted.length != 2) continue;
                        ioQry.setPresentationProperty(propertySplitted[0], propertySplitted[1]);
                    }
                }
            }
            return true;
        }
        return false;
    }

    private static String[] _splitMetaDataConditions(String metaDataConditions) {
        ArrayList<String> valuesList = new ArrayList<String>();
        Pattern pattern = Pattern.compile("([^,.]+.(?:IN|ANY|ALL).\\([^\\)]+\\)|[^,.]+.BETWEEN.[^,]+,[^,]+|\".+\"|[^,]+)");
        Matcher match = pattern.matcher(metaDataConditions);
        while (match.find()) {
            String concurrence = match.group();
            valuesList.add(concurrence);
        }
        return valuesList.toArray(new String[0]);
    }

    public static R01MQueryObject obtainQueryObjectFromUrl(String queryString) {
        R01MQueryObject queryObject = new R01MQueryObject();
        Pattern p = Pattern.compile(QUERY_PATTERN);
        Matcher m = p.matcher(queryString);
        if (m.matches()) {
            String queryType = m.group(1);
            String queryValue = m.group(2);
            if (queryType.equals("r01kCommonSearchQry")) {
                queryObject = R01MFormComposerQueryParser.parseQueryStringToQueryObject(queryValue);
            } else if (queryType.equals("searchGUID") || queryType.equals("r01kStoredQry")) {
                if (queryValue != null && !StringUtils.isEmptyString((String)queryValue)) {
                    try {
                        queryObject = R01MClientFactory.getSearchEnginePersistenceAPI().loadQuery(queryValue);
                    }
                    catch (R01MSearchStorageException ex) {
                        ex.printStackTrace(System.out);
                    }
                }
            } else if (queryType.equals("r01kQry")) {
                queryObject = R01MSearchEngineUtils.decodeURLInQueryObject(queryValue);
            } else if (queryType.equals("fullText")) {
                queryObject = new R01MQueryObject();
                queryObject.setFullTextSearch(true);
                queryObject.setFullText(queryValue);
            } else if (queryType.equals(QUERYV1PARAMFILTER)) {
                StringBuffer newQuery = new StringBuffer();
                newQuery.append("&r01kQry=");
                StringBuffer newURLEncoded = new StringBuffer();
                p = Pattern.compile("&(languageSearch|numberOfElements|typesId|nodeId)=([^&]+)");
                m = p.matcher(queryString);
                while (m.find()) {
                    String valueType = m.group(1);
                    String valueVal = m.group(2);
                    if ("languageSearch".equals(valueType)) {
                        newURLEncoded.append("&r01kLang=");
                        newURLEncoded.append(valueVal);
                        continue;
                    }
                    if ("numberOfElements".equals(valueType)) {
                        newQuery.append("pp:r01NavBarBlockSize.10,r01PageSize.10;");
                        continue;
                    }
                    if ("typesId".equals(valueType)) {
                        String[] tipos = valueVal.split(";");
                        if (tipos.length <= 0) continue;
                        newQuery.append("tT:");
                        for (int i = 0; i < tipos.length; ++i) {
                            TypoConversion newTypeId;
                            try {
                                newTypeId = R01MSearchEngineUtils._convertTypeId(tipos[i]);
                            }
                            catch (R01MPortalModelException ex) {
                                newTypeId = new TypoConversion("error", "error", "error");
                            }
                            newQuery.append(newTypeId.typoOid);
                            newQuery.append(';');
                        }
                        continue;
                    }
                    if (!"nodeId".equals(valueType)) continue;
                    newQuery.append("cA:");
                    newQuery.append(valueVal);
                    newQuery.append(';');
                }
                p = Pattern.compile("attributeId=([^&]+)&attributeName=[^&]+&\\1Operation=(EQ|LIKE|GT|LT|GTE|LTE)&\\1=([^&]+)");
                m = p.matcher(queryString);
                while (m.find()) {
                    String metadataOid = m.group(1);
                    if ("language".equals(metadataOid) || "publish".equals(metadataOid)) continue;
                    newQuery.append("m:");
                    newQuery.append(metadataOid);
                    newQuery.append('.');
                    newQuery.append(m.group(2));
                    newQuery.append('.');
                    newQuery.append(m.group(3));
                    newQuery.append(';');
                }
                newQuery.append(newURLEncoded);
                if (DEBUG) {
                    R01FLog.to((String)"r01m.session").info("newQuery=" + newQuery.toString());
                }
                queryObject = R01MSearchEngineUtils.decodeURLInQueryObject(newQuery.toString());
            }
            if (queryString.indexOf("r01SearchEngine=meta") >= 0) {
                queryObject.setFullTextSearch(false);
            } else if (queryString.indexOf("r01SearchEngine=full") >= 0) {
                queryObject.setFullTextSearch(true);
            } else if (!StringUtils.isEmptyString((String)queryObject.getFullText())) {
                queryObject.setFullTextSearch(true);
            }
        }
        return queryObject;
    }

    public static void sanitizeQuery(R01MQueryObject qry) {
        if (qry.getMetaData() != null && !qry.getMetaData().isEmpty()) {
            for (R01MSearchedMetaData srchMeta : qry.getMetaData()) {
                srchMeta.setValue(R01MSearchEngineUtils.sanitizeParam(srchMeta.getValue()));
            }
        }
    }

    public static String sanitizeParam(String sourceText) {
        if (StringUtils.isEmptyString((String)sourceText)) {
            return sourceText;
        }
        String paramFormatted = sourceText;
        paramFormatted = R01MSearchEngineUtils.sanitizeParam(paramFormatted, "(?i)<script.*?>.*?</script.*?>");
        paramFormatted = R01MSearchEngineUtils.sanitizeParam(paramFormatted, "(?i).*javascript:.*");
        paramFormatted = R01MSearchEngineUtils.sanitizeParam(paramFormatted, "<(.|\\n)+?>");
        return paramFormatted;
    }

    public static String sanitizeParam(String sourceText, String pattern) {
        StringBuffer finalText = new StringBuffer("");
        Pattern p1 = Pattern.compile(pattern);
        Matcher m1 = p1.matcher(sourceText);
        while (m1.find()) {
            m1.appendReplacement(finalText, "");
        }
        m1.appendTail(finalText);
        return finalText.toString();
    }

    private static TypoConversion _convertTypeId(String v1Type) throws R01MPortalModelException {
        Properties p = XMLProperties.getProperties((String)R01MConstants.SEARCHENGINE_APPCODE, (String)"contentsRepositoryConfig/migratedTypes");
        if (p == null) {
            throw new R01MPortalModelException("Error!!! NO se ha definido en el fichero de properties la tabla de traducci\u00f3n de tipos para migraci\u00f3n V1->V2!!!!!");
        }
        String effectiveV1Type = p.getProperty("t" + v1Type);
        if (effectiveV1Type == null) {
            effectiveV1Type = v1Type;
            if (DEBUG) {
                R01FLog.to((String)"r01m.session").info("\t\t... NO se ha definido la traducci\u00f3n del tipo " + v1Type + " en la seccion migratedTypes del fichero properties de r01k!!!\r\nSe traduce por si mismo!!!!");
            }
        }
        if (DEBUG) {
            R01FLog.to((String)"r01m.session").info("\t\t...el tipo v1 " + v1Type + " se transforma en tipo " + effectiveV1Type);
        }
        TypoConversion typoConversion = new TypoConversion(effectiveV1Type);
        if (typoConversion.clusterOid != null && typoConversion.familyOid != null && typoConversion.typoOid != null) {
            return typoConversion;
        }
        return null;
    }

    private static String composeOperatorLiteral(String message, String values) {
        Object[] params = values.split(",");
        return MessageFormat.format(message, params);
    }

    private static boolean searchLaLabelInOrganizationStructure(String labelOid, String label, StringBuffer sbOrganismos, int level, String lang, boolean and) {
        boolean isFixedStructure = false;
        try {
            List organismosLabels = R01MClientFactory.getCatalogAPI(R01MAuthManager.createMasterSystemUserContext()).loadLabelInStructureWithRole(R01MConstants.FIXED_STRUCTURES.organismosStructOid, labelOid, level);
            if (organismosLabels != null && !organismosLabels.isEmpty()) {
                if (sbOrganismos == null) {
                    sbOrganismos = new StringBuffer(50);
                }
                sbOrganismos.append(label);
                isFixedStructure = true;
                R01MSearchEngineUtils.setDataSeparator(sbOrganismos, and, lang);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return isFixedStructure;
    }

    private static void setDataSeparator(StringBuffer sb, boolean and, String lang) {
        if (and) {
            if (sb == null) {
                sb = new StringBuffer(50);
            }
            sb.append(";&nbsp;");
        } else {
            if (sb != null) {
                sb = new StringBuffer(50);
            }
            sb.append(";&nbsp;");
        }
    }

    static class TypoConversion {
        public String clusterOid;
        public String familyOid;
        public String typoOid;
        private Map typesConversion = new HashMap();

        public TypoConversion() {
            this._init();
        }

        public TypoConversion(String newClusterOid, String newFamilyOid, String newTypoOid) {
            this();
            this.clusterOid = newClusterOid;
            this.familyOid = newFamilyOid;
            this.typoOid = newTypoOid;
        }

        public TypoConversion(String v1TypeId) {
            this();
            String[] clusterFamilyType = (String[])this.typesConversion.get(v1TypeId);
            if (clusterFamilyType != null) {
                this.clusterOid = clusterFamilyType[0];
                this.familyOid = clusterFamilyType[1];
                this.typoOid = clusterFamilyType[2];
            }
        }

        private void _init() {
            this.typesConversion.put("1", new String[]{"euskadi", "enlaces", "enlace"});
            this.typesConversion.put("55", new String[]{"euskadi", "enlaces", "servicio_online"});
            this.typesConversion.put("2", new String[]{"euskadi", "eventos", "evento"});
            this.typesConversion.put("29", new String[]{"euskadi", "eventos", "evento"});
            this.typesConversion.put("30", new String[]{"euskadi", "eventos", "evento"});
            this.typesConversion.put("31", new String[]{"euskadi", "eventos", "evento"});
            this.typesConversion.put("32", new String[]{"euskadi", "eventos", "evento"});
            this.typesConversion.put("3", new String[]{"euskadi", "informacion", "informacion"});
            this.typesConversion.put("36", new String[]{"euskadi", "informacion", "informacion"});
            this.typesConversion.put("33", new String[]{"euskadi", "informacion", "informacion"});
            this.typesConversion.put("53", new String[]{"euskadi", "informacion", "faq"});
            this.typesConversion.put("54", new String[]{"euskadi", "informacion", "recurso_tecnico"});
            this.typesConversion.put("4", new String[]{"euskadi", "prensa_comunicacion", "noticia"});
            this.typesConversion.put("18", new String[]{"euskadi", "prensa_comunicacion", "nota_prensa"});
            this.typesConversion.put("19", new String[]{"euskadi", "prensa_comunicacion", "noticia"});
            this.typesConversion.put("50", new String[]{"euskadi", "prensa_comunicacion", "publicidad"});
            this.typesConversion.put("5", new String[]{"euskadi", "procedimientos_administrativos", "ayuda_subvencion"});
            this.typesConversion.put("6", new String[]{"euskadi", "procedimientos_administrativos", "autorizacion"});
            this.typesConversion.put("7", new String[]{"euskadi", "procedimientos_administrativos", "carnet"});
            this.typesConversion.put("8", new String[]{"euskadi", "procedimientos_administrativos", "registro"});
            this.typesConversion.put("9", new String[]{"euskadi", "procedimientos_administrativos", "inspeccion"});
            this.typesConversion.put("10", new String[]{"euskadi", "procedimientos_administrativos", "multa_sancion"});
            this.typesConversion.put("12", new String[]{"euskadi", "procedimientos_administrativos", "procedimiento_otro"});
            this.typesConversion.put("13", new String[]{"euskadi", "procedimientos_administrativos", "premio_concurso"});
            this.typesConversion.put("14", new String[]{"euskadi", "procedimientos_administrativos", "procedimiento_otro"});
            this.typesConversion.put("15", new String[]{"euskadi", "procedimientos_administrativos", "arbitraje_denuncia_reclamacion"});
            this.typesConversion.put("17", new String[]{"euskadi", "procedimientos_administrativos", "contratacion"});
            this.typesConversion.put("11", new String[]{"euskadi", "rrhh", "rrhh"});
            this.typesConversion.put("35", new String[]{"euskadi", "organizacion", "institucion"});
            this.typesConversion.put("16", new String[]{"euskadi", "organizacion", "organo"});
            this.typesConversion.put("21", new String[]{"euskadi", "estadisticas", "estadistica"});
            this.typesConversion.put("22", new String[]{"euskadi", "documentacion", "informe_estudio"});
            this.typesConversion.put("28", new String[]{"euskadi", "documentacion", "libro"});
            this.typesConversion.put("23", new String[]{"euskadi", "documentacion", "memoria"});
            this.typesConversion.put("24", new String[]{"euskadi", "documentacion", "plan_programa_proyecto"});
            this.typesConversion.put("25", new String[]{"euskadi", "documentacion", "plan_programa_proyecto"});
            this.typesConversion.put("26", new String[]{"euskadi", "documentacion", "plan_programa_proyecto"});
            this.typesConversion.put("20", new String[]{"euskadi", "documentacion", "informe_estudio"});
            this.typesConversion.put("37", new String[]{"euskadi", "documentacion", "boletin_revista"});
            this.typesConversion.put("38", new String[]{"euskadi", "documentacion", "memoria"});
            this.typesConversion.put("51", new String[]{"euskadi", "documentacion", "inventario"});
            this.typesConversion.put("52", new String[]{"euskadi", "documentacion", "manual"});
            this.typesConversion.put("27", new String[]{"euskadi", "directorios", "centro"});
            this.typesConversion.put("34", new String[]{"euskadi", "legislacion", "normativa"});
            this.typesConversion.put("60", new String[]{"euskadi", "turismo", "a_alojamiento"});
            this.typesConversion.put("61", new String[]{"euskadi", "turismo", "b_restauracion"});
            this.typesConversion.put("62", new String[]{"euskadi", "turismo", "d_destinos_turisticos"});
            this.typesConversion.put("64", new String[]{"euskadi", "turismo", "c_transporte_y_movilidad"});
            this.typesConversion.put("65", new String[]{"euskadi", "turismo", "e_oficinas_turisticas"});
            this.typesConversion.put("66", new String[]{"euskadi", "turismo", "g_naturaleza"});
            this.typesConversion.put("67", new String[]{"euskadi", "turismo", "h_cultura_y_patrimonio"});
            this.typesConversion.put("68", new String[]{"euskadi", "turismo", "i_deportes"});
            this.typesConversion.put("69", new String[]{"euskadi", "turismo", "j_gastronomia"});
            this.typesConversion.put("70", new String[]{"euskadi", "turismo", "k_ocio"});
            this.typesConversion.put("71", new String[]{"euskadi", "turismo", "l_compras"});
            this.typesConversion.put("72", new String[]{"euskadi", "turismo", "n_negocios"});
        }

        public String getClusterOid() {
            return this.clusterOid;
        }

        public void setClusterOid(String theClusterOid) {
            this.clusterOid = theClusterOid;
        }

        public String getFamilyOid() {
            return this.familyOid;
        }

        public void setFamilyOid(String theFamilyOid) {
            this.familyOid = theFamilyOid;
        }

        public String getTypoOid() {
            return this.typoOid;
        }

        public void setTypoOid(String theTypoOid) {
            this.typoOid = theTypoOid;
        }

        public Map getTypesConversion() {
            return this.typesConversion;
        }

        public void setTypesConversion(Map theTypesConversion) {
            this.typesConversion = theTypesConversion;
        }
    }
}

