/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.utils.searchengine;

import com.ejie.r01f.log.R01FLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class R01MFullTextQueryUtils {
    public static String filterWords(String searchQueryString, String wordsToRemoveRegExp) {
        StringBuffer outFilteredText = new StringBuffer("");
        Pattern p = Pattern.compile(wordsToRemoveRegExp, 2);
        Matcher m = p.matcher(searchQueryString);
        boolean directiveValid = m.find();
        while (directiveValid) {
            m.appendReplacement(outFilteredText, "");
            directiveValid = m.find();
        }
        m.appendTail(outFilteredText);
        return outFilteredText.toString();
    }

    public static FixedQuery fixSearchQueryString(String searchQueryString, int maxFullTextStringLength, int maxFullTextWords, String wordsToRemoveRegExp, String reservedWordsRegExp, String searchEngineFunctionsRegExp) {
        int theMaxFullTextWords = maxFullTextWords > 0 ? maxFullTextWords : 20;
        int theMaxFullTextStringLength = maxFullTextStringLength > 0 ? maxFullTextStringLength : 255;
        String theWordsToRemoveRegExp = wordsToRemoveRegExp != null ? wordsToRemoveRegExp : "DELETE\\s*=\\s*TRUE";
        String theReservedWordsRegExp = reservedWordsRegExp != null ? reservedWordsRegExp : "\\b(?:OR|NOT|EOR|XOR|NEAR[0-9]{0,2}|%|\\||~)\\b";
        String theSearchEngineFunctionsRegExp = searchEngineFunctionsRegExp != null ? searchEngineFunctionsRegExp : "(?:DREFUZZY|SOUNDEX)\\s*\\([^)]+\\)";
        String theQueryString = R01MFullTextQueryUtils._filterTags(searchQueryString);
        if ((theQueryString = R01MFullTextQueryUtils.filterWords(theQueryString, theWordsToRemoveRegExp)).length() > theMaxFullTextStringLength) {
            theQueryString = theQueryString.substring(0, theMaxFullTextStringLength);
        }
        Collection extractedWordsCol = R01MFullTextQueryUtils._extractQueryWords(theQueryString, theReservedWordsRegExp, theSearchEngineFunctionsRegExp);
        ExtractedQueryWord currWord2 = null;
        ExtractedQueryWord prevWord = null;
        int searchedWordsCount = 0;
        StringBuffer query = new StringBuffer("");
        for (ExtractedQueryWord currWord2 : extractedWordsCol) {
            if ("\"\"".equals(currWord2.word) || "''".equals(currWord2.word)) continue;
            if (currWord2.type == 9) {
                ++searchedWordsCount;
            }
            if (searchedWordsCount > theMaxFullTextWords) break;
            if (prevWord != null) {
                if (prevWord.type == currWord2.type && currWord2.type == 9) {
                    query.append(" + ");
                } else if (!"(".equals(prevWord.word) && !")".equals(currWord2.word)) {
                    query.append(' ');
                }
            }
            query.append(currWord2.word);
            prevWord = currWord2;
        }
        return new FixedQuery(searchedWordsCount, searchQueryString, query);
    }

    private static Collection _extractQueryWords(String queryString, String reservedWordsRegExp, String searchEngineFunctionRegExp) {
        String qryStr = new String(queryString);
        ArrayList<ExtractedQueryWord> searchedWords = new ArrayList<ExtractedQueryWord>();
        Pattern p = null;
        Matcher m = null;
        boolean directiveValid = false;
        String foundPattern = null;
        StringBuffer queryString2 = null;
        queryString2 = new StringBuffer("");
        p = Pattern.compile(searchEngineFunctionRegExp, 2);
        m = p.matcher(qryStr);
        directiveValid = m.find();
        while (directiveValid) {
            foundPattern = qryStr.substring(m.start(), m.end());
            searchedWords.add(new ExtractedQueryWord(m.start(), foundPattern, 1));
            char[] emptyStr = new char[foundPattern.length()];
            Arrays.fill(emptyStr, ' ');
            m.appendReplacement(queryString2, new String(emptyStr));
            directiveValid = m.find();
        }
        m.appendTail(queryString2);
        qryStr = queryString2.toString();
        int pos = qryStr.indexOf(40, 0);
        while (pos >= 0) {
            searchedWords.add(new ExtractedQueryWord(pos, "(", 0));
            pos = qryStr.indexOf("(", pos + 1);
        }
        qryStr = qryStr.replaceAll("\\(", " ");
        pos = qryStr.indexOf(")", 0);
        while (pos >= 0) {
            searchedWords.add(new ExtractedQueryWord(pos, ")", 0));
            pos = qryStr.indexOf(")", pos + 1);
        }
        qryStr = qryStr.replaceAll("\\)", " ");
        queryString2 = new StringBuffer("");
        p = Pattern.compile("(?:[\"'])[^\"']*(?:[\"'])", 2);
        m = p.matcher(qryStr);
        directiveValid = m.find();
        while (directiveValid) {
            foundPattern = qryStr.substring(m.start(), m.end());
            searchedWords.add(new ExtractedQueryWord(m.start(), foundPattern, 9));
            char[] emptyStr = new char[foundPattern.length()];
            Arrays.fill(emptyStr, ' ');
            m.appendReplacement(queryString2, new String(emptyStr));
            directiveValid = m.find();
        }
        m.appendTail(queryString2);
        qryStr = queryString2.toString();
        p = Pattern.compile("[\\*\\?%]*\\b(?:\\w|[\\xC0\\xC1\\xC7\\xC8\\xC9\\xCC\\xCD\\xD1\\xD2\\xD3\\xD9\\xDA\\xDC\\xE0\\xE1\\xE7\\xE8\\xE9\\xEC\\xED\\xEE\\xF1\\xF2\\xF3\\xF9\\xFA\\xFC]|:|/|\\*|\\?|\\.|%)+\\b[\\*\\?\\.%]*", 2);
        m = p.matcher(qryStr);
        directiveValid = m.find();
        while (directiveValid) {
            foundPattern = qryStr.substring(m.start(), m.end());
            if (R01MFullTextQueryUtils._isSearchEngineReservedWord(foundPattern, reservedWordsRegExp)) {
                searchedWords.add(new ExtractedQueryWord(m.start(), foundPattern, 2));
            } else {
                searchedWords.add(new ExtractedQueryWord(m.start(), foundPattern, 9));
            }
            directiveValid = m.find();
        }
        Collections.sort(searchedWords);
        return searchedWords;
    }

    private static boolean _isSearchEngineReservedWord(String word, String reservedWordsRegExp) {
        Pattern p = Pattern.compile(reservedWordsRegExp, 2);
        Matcher m = p.matcher(word);
        return m.matches();
    }

    private static String _filterTags(String searchQueryString) {
        return R01MFullTextQueryUtils.filterWords(searchQueryString, "<(.|\\n)+?>");
    }

    public static void main(String[] args) {
        try {
            String wordsToRemoveRegExp = "delete\\s*=\\s*true";
            String reservedWordsRegExp = "\\b(?:OR|NOT|EOR|XOR|NEAR[0-9]{0,2})\\b";
            String searchEngineFunctionsRegExp = "(?:DREFUZZY|SOUNDEX)\\s*\\([^)]+\\)";
            String queryString = "<script>afafd&\"delete=true\"<script src='asdf'>\u00bfHola*hola*? (Alex:*/_as) NEAR5 drefuzzy(es el mejor) \"programador java\" del mundo 'mundial' eso es lo c'est la vie _unico_cierto";
            long t1 = System.currentTimeMillis();
            int testTimes = 1;
            for (int times = 0; times < testTimes; ++times) {
                R01FLog.to((String)"r01m.test").info(queryString);
                R01FLog.to((String)"r01m.test").info("'" + R01MFullTextQueryUtils.fixSearchQueryString((String)queryString, (int)255, (int)20, (String)wordsToRemoveRegExp, (String)reservedWordsRegExp, (String)searchEngineFunctionsRegExp).fixedQuery + "'");
            }
            long t2 = System.currentTimeMillis();
            R01FLog.to((String)"r01m.test").info("\r\n\r\nTime Elapsed: " + (t2 - t1) / 1000L + "sg - " + (t2 - t1) + "msg");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static class FixedQuery {
        public int wordCount = 0;
        public String query = null;
        public StringBuffer fixedQuery = null;

        public FixedQuery() {
        }

        public FixedQuery(int newWordCount, String newQuery, StringBuffer newFixedQuery) {
            this.wordCount = newWordCount;
            this.query = newQuery;
            this.fixedQuery = newFixedQuery;
        }
    }

    private static class ExtractedQueryWord
    implements Comparable {
        public static final int WORD_TYPE_SYMBOL = 0;
        public static final int WORD_TYPE_FUNC = 1;
        public static final int WORD_TYPE_RES = 2;
        public static final int WORD_TYPE_WORD = 9;
        public int position = -1;
        public String word = "";
        public int type = 9;

        public ExtractedQueryWord(int newPosition, String newWord, int newType) {
            this.position = newPosition;
            this.word = newWord;
            this.type = newType;
        }

        public int compareTo(Object o) {
            ExtractedQueryWord otherExtractedWord = (ExtractedQueryWord)o;
            return new Integer(this.position).compareTo(new Integer(otherExtractedWord.position));
        }
    }
}

