/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.utils.portal;

import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.utils.R01MConstants;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class R01MPortalPathHelpper {
    public static final String TEMPLATES_DIRNAME = XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/filePathNames/templates");
    public static final String IMAGES_DIRNAME = XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/filePathNames/images");
    public static final String STYLES_DIRNAME = XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/filePathNames/styles");
    public static final String STYLETEMPLATES_DIRNAME = XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/filePathNames/styletemplates");
    public static final String SCRIPTS_DIRNAME = XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/filePathNames/scripts");
    public static final String XMLDEF_DIRNAME = XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/filePathNames/data");
    public static final String[] EXT_RESOURCE_IMAGES = XMLProperties.getProperty((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"allowedImageExtFiles", (String)"gif,jpg,bmp,png").split(",");
    public static final String IMPORTSTYLES_SUFFIX = XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/importResources/suffixStyles");
    public static final String IMPORTSTYLES_SASS__SUFFIX = XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/importResources/suffixSASSStyles");
    public static final String IMPORTSCRIPTS_SUFFIX = XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/importResources/suffixScripts");
    public static final String TEMPLATES_TEMP_DIR = XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/fileLocations/templatesTemp");
    public static final String TEMPLATES_DIR = XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/fileLocations/templates");
    public static final String IMAGES_DIR = XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/fileLocations/images", (String)"/[?0]/html/images/");
    public static final String STYLES_DIR = XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/fileLocations/styles", (String)"/[?0]/html/styles/");
    public static final String STYLETEMPLATES_DIR = XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/fileLocations/styletemplates", (String)"/[?0]/html/csst/");
    public static final String SCRIPTS_DIR = XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/fileLocations/scripts", (String)"/[?0]/html/scripts/");
    public static final String PUBLISH_DIR = XMLProperties.getProperty((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/fileLocations/publish", (String)"[?0]/html/publish/");
    public static final String DATA_DIR = XMLProperties.getProperty((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/fileLocations/data", (String)"/[?0]/html/data/");
    public static final String VISUALAREA_DIR = XMLProperties.getProperty((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/fileLocations/visualArea", (String)"/[?0]/html/AV");
    public static final String ADMINPAGES_DIR = XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/fileLocations/adminPages", (String)"/[?0]/html/pages/admin/");
    public static final String STAGEPAGES_DIR = XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/fileLocations/stagePages", (String)"/[?0]/html/pages/stage/");
    public static final String PORTALPAGES_DIR = XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/fileLocations/portalPages", (String)"/[?0]/html/pages/portal/");
    public static final String INDEXES_DIR = XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/fileLocations/indexes", (String)"/[?0]/html/pages/data/[?1]/");
    public static final String PARTIAL_INDEXES_DIR = XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/fileLocations/partialIndexes", (String)"/[?0]/html/pages/data/[?1]/[?2]_[?1]/r01Index/");
    public static final String ALIAS_DIR = XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/fileLocations/alias", (String)"/[?0]/html/r01FriendlyUrl/");
    public static final String HTML_DATA_DIR = XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/fileLocations/htmlData", (String)"/[?0]/html/pages/data/[?1]/[?2]_[?1]/");
    public static final String RESOURCE_DIR = XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/fileLocations/resources", (String)"/[?0]/html/pages/data/");
    public static final String PORTALBASEPATH_DIR = XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/fileLocations/portalBasePath", (String)"/[?0]/html");
    public static final String PORTALRESOURCES_URI = XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/uriLocations/portalResources");
    public static final String ADMINPAGES_URL = XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/uriLocations/pageAdmin");
    public static final String PORTALPAGES_URL = XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/uriLocations/pagePortal");
    public static final String EDITPAGES_URL = XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/uriLocations/pageEdit");
    public static final String PUBLISHPAGES_URL = XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/uriLocations/pagePublish");
    public static final String VISUALAREA_URL = XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/uriLocations/visualArea");
    public static final String VISUALAREARESOURCE_URL = XMLProperties.get((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/uriLocations/visualAreaResource");
    public static final String VA_INSTANCE_FILENAME = XMLProperties.getProperty((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"visualAreas/fileNames/visualAreaInstanceFileName");
    public static final String VA_RESOURCE_FILENAME = XMLProperties.getProperty((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"visualAreas/fileNames/visualAreaResourcesFileName");

    public static String extractPortalElementId(String portalElementFileName) {
        String patternStr = "^[^-]*-([^-.]*)\\.?(?:shtml|html|gif|jpg|css|js)?$$";
        Pattern p = Pattern.compile(patternStr);
        Matcher m = p.matcher(portalElementFileName);
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }

    public static String extractPortalCode(String portalElementFileName) {
        String patternStr = "^([^-]*)-[^-]*$";
        Pattern p = Pattern.compile(patternStr);
        Matcher m = p.matcher(portalElementFileName);
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }

    public static String renamePortalElement(String portalCode, String portalElementFileName) {
        String newName = null;
        String portalPrefix = portalCode.toLowerCase();
        String currName = portalElementFileName;
        int sepPos = -1;
        sepPos = currName.indexOf(45);
        newName = sepPos > 0 ? portalPrefix + "-" + currName.substring(sepPos + 1) : portalPrefix + "-" + currName;
        return newName;
    }

    public static String replacePortalCodeInPath(String path, String portalCode) {
        String outPath = new String(path);
        String patternStr = "^([^$]*)(\\[\\?0\\])([^$]*)$";
        Pattern p = Pattern.compile(patternStr);
        Matcher m = p.matcher(path);
        if (m.matches()) {
            outPath = m.replaceAll("$1" + portalCode + "$3");
        }
        return outPath;
    }

    public static String replacePortalPageCodeInPath(String path, String portalCode, String pageCode) {
        String outPath = new String(path);
        String patternStr = "^([^$]*)(\\[\\?0\\])([^$]*)$";
        Pattern p = Pattern.compile(patternStr);
        Matcher m = p.matcher(path);
        while (m.matches()) {
            outPath = m.replaceAll("$1" + portalCode + "$3");
            m = p.matcher(outPath);
        }
        patternStr = "^([^$]*)(\\[\\?1\\])([^$]*)$";
        p = Pattern.compile(patternStr);
        m = p.matcher(outPath);
        while (m.matches()) {
            outPath = m.replaceAll("$1" + pageCode + "$3");
            m = p.matcher(outPath);
        }
        return outPath;
    }

    public static String replacePortalPageLanguageCodeInPath(String path, String portalCode, String pageCode, String language) {
        String outPath = new String(path);
        String patternStr = "^([^$]*)(\\[\\?0\\])([^$]*)$";
        Pattern p = Pattern.compile(patternStr);
        Matcher m = p.matcher(path);
        while (m.matches()) {
            outPath = m.replaceAll("$1" + portalCode + "$3");
            m = p.matcher(outPath);
        }
        patternStr = "^([^$]*)(\\[\\?1\\])([^$]*)$";
        p = Pattern.compile(patternStr);
        m = p.matcher(outPath);
        while (m.matches()) {
            outPath = m.replaceAll("$1" + pageCode + "$3");
            m = p.matcher(outPath);
        }
        patternStr = "^([^$]*)(\\[\\?2\\])([^$]*)$";
        p = Pattern.compile(patternStr);
        m = p.matcher(outPath);
        while (m.matches()) {
            outPath = m.replaceAll("$1" + language + "$3");
            m = p.matcher(outPath);
        }
        return outPath;
    }

    public static String obtainAdminPageURL(String uiLang, String portalCode, String pageInternalName, String pageLang) {
        Properties vars = new Properties();
        vars.put("uiLang", uiLang);
        vars.put("portalCode", portalCode);
        vars.put("pageInternalName", pageInternalName);
        vars.put("lang", pageLang);
        return StringUtils.replaceVariableValues((String)ADMINPAGES_URL, (char)'$', (Map)vars);
    }

    public static String obtainEditPageURL(String uiLang, String pageOid) {
        Properties vars = new Properties();
        vars.put("uiLang", uiLang);
        vars.put("pageOid", pageOid);
        return StringUtils.replaceVariableValues((String)EDITPAGES_URL, (char)'$', (Map)vars);
    }

    public static String obtainPortalPageURL(String portalCode, String pageInternalName, String pageLang) {
        Properties vars = new Properties();
        vars.put("portalCode", portalCode);
        vars.put("pageInternalName", pageInternalName);
        vars.put("lang", pageLang);
        return StringUtils.replaceVariableValues((String)PORTALPAGES_URL, (char)'$', (Map)vars);
    }

    public static String obtainPublishedPageURL(String portalDomain, String portalCode, String pageInternalName) {
        Properties vars = new Properties();
        vars.put("portalDomain", portalDomain);
        vars.put("portalCode", portalCode);
        vars.put("pageInternalName", pageInternalName);
        return StringUtils.replaceVariableValues((String)PUBLISHPAGES_URL, (char)'$', (Map)vars);
    }

    public static String obtainVisualAreaURL(String portalCode, String avType, String avLang, String avInternalName, String generatedFileExt) {
        Properties vars = new Properties();
        vars.put("portalCode", portalCode);
        vars.put("avType", avType);
        vars.put("avLang", avLang);
        vars.put("avInternalName", avInternalName);
        vars.put("avExtension", generatedFileExt);
        return StringUtils.replaceVariableValues((String)VISUALAREA_URL, (char)'$', (Map)vars);
    }

    public static String obtainVisualAreaResourceURL(String portalCode, String avType, String resourceType, String resourceName) {
        Properties vars = new Properties();
        vars.put("portalCode", portalCode);
        vars.put("avType", avType);
        vars.put("resourceType", resourceType);
        vars.put("resourceName", resourceName);
        return StringUtils.replaceVariableValues((String)VISUALAREARESOURCE_URL, (char)'$', (Map)vars);
    }

    public static String obtainVisualAreaUri(String portalCode, String avType, String avInternalName, String extension) {
        String instanceUri = XMLProperties.getCustomized((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"visualAreas/uriLocations/vaInstance", (String[])new String[]{avType});
        Properties vars = new Properties();
        vars.put("portalOid", portalCode);
        vars.put("visualAreaOid", avType);
        vars.put("avInternalName", avInternalName);
        vars.put("ext", extension);
        if (instanceUri != null) {
            instanceUri = StringUtils.replaceVariableValues((String)(instanceUri + VA_INSTANCE_FILENAME), (char)'$', (Map)vars);
        }
        return instanceUri;
    }

    public static String obtainTemplateUri(String portalCode, String templateId, String templateLang) {
        Properties vars = new Properties();
        vars.put("portalCode", portalCode);
        vars.put("templateId", templateId);
        vars.put("lang", templateLang);
        String templateUri = StringUtils.replaceVariableValues((String)XMLProperties.getProperty((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/uriLocations/template"), (char)'$', (Map)vars);
        return templateUri;
    }

    public static String obtainPortalResourceUri(String resourceType, String resourceName) {
        Properties vars = new Properties();
        vars.put("resourceType", resourceType);
        vars.put("resourceName", resourceName);
        String portalResourceUri = StringUtils.replaceVariableValues((String)PORTALRESOURCES_URI, (char)'$', (Map)vars);
        return portalResourceUri;
    }

    public static String obtainVisualAreaResourceName(String portalCode, String resourceName, String extension) {
        Properties vars = new Properties();
        vars.put("portalOid", portalCode);
        vars.put("avResourceName", resourceName);
        vars.put("ext", extension);
        return StringUtils.replaceVariableValues((String)VA_RESOURCE_FILENAME, (char)'$', (Map)vars);
    }

    public static String getPageStylesFilename(String portalOid, String pageInternalName, boolean includeSSI, boolean styleSASS) {
        StringBuffer fileName = new StringBuffer(50);
        fileName.append(portalOid);
        fileName.append('-');
        fileName.append(pageInternalName);
        if (styleSASS) {
            fileName.append(IMPORTSTYLES_SASS__SUFFIX).append(".css");
        } else {
            fileName.append(IMPORTSTYLES_SUFFIX);
            if (includeSSI) {
                fileName.append(".scss");
            } else {
                fileName.append(".css");
            }
        }
        return fileName.toString();
    }

    public static String getPageMetasFilename(String pageInternalName) {
        StringBuffer fileName = new StringBuffer(50);
        fileName.append("r01");
        fileName.append(pageInternalName);
        fileName.append("PageMetas.inc");
        return fileName.toString();
    }

    public static String getPageVarsFilename(String pageInternalName) {
        StringBuffer fileName = new StringBuffer(50);
        fileName.append("r01");
        fileName.append(pageInternalName);
        fileName.append("PageVars.shtml");
        return fileName.toString();
    }

    public static String getPageHeadFilename(String pageInternalName) {
        StringBuffer fileName = new StringBuffer(50);
        fileName.append("r01");
        fileName.append(pageInternalName);
        fileName.append("PortalHead.shtml");
        return fileName.toString();
    }

    public static String getPageScriptsFilename(String portalOid, String pageInternalName, boolean includeSSI) {
        StringBuffer fileName = new StringBuffer(50);
        fileName.append(portalOid);
        fileName.append('-');
        fileName.append(pageInternalName);
        fileName.append(IMPORTSCRIPTS_SUFFIX);
        if (includeSSI) {
            fileName.append(".sjs");
        } else {
            fileName.append(".js");
        }
        return fileName.toString();
    }

    public static int obtainResourceTypeFromFile(String resourceFileName) {
        int lastDotIndex;
        int resourceType = 0;
        if (!StringUtils.isEmptyString((String)resourceFileName) && (lastDotIndex = resourceFileName.lastIndexOf(".")) != -1) {
            String extension = resourceFileName.substring(lastDotIndex + 1);
            if (extension.equalsIgnoreCase("css")) {
                resourceType = 4;
            } else if (extension.equalsIgnoreCase("scss")) {
                resourceType = 4;
            } else if (extension.equalsIgnoreCase("sjs")) {
                resourceType = 3;
            } else if (extension.equalsIgnoreCase("js")) {
                resourceType = 3;
            } else if (Arrays.asList(EXT_RESOURCE_IMAGES).contains(extension)) {
                resourceType = 2;
            } else if (extension.equalsIgnoreCase("shtml")) {
                resourceType = 1;
            }
        }
        return resourceType;
    }

    public static String obtainResourceDir(int resourceType) {
        String resourceDirName = "";
        resourceDirName = resourceType == 4 ? STYLES_DIRNAME : (resourceType == 3 ? SCRIPTS_DIRNAME : (resourceType == 2 ? IMAGES_DIRNAME : (resourceType == 5 ? STYLETEMPLATES_DIRNAME : (resourceType == 1 ? TEMPLATES_DIRNAME : (resourceType == 6 ? XMLDEF_DIRNAME : "unknow")))));
        return resourceDirName;
    }

    public static String obtainResourceDirFromFile(String resourceFileName) {
        return R01MPortalPathHelpper.obtainResourceDir(R01MPortalPathHelpper.obtainResourceTypeFromFile(resourceFileName));
    }
}

