/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.utils.portal;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.config.objects.cataloguing.R01MAllowedCataloguingBagConfig;
import com.ejie.r01m.config.objects.cataloguing.R01MStructureCataloguingConfig;
import com.ejie.r01m.config.objects.cataloguing.R01MStructureGroupCataloguingConfig;
import com.ejie.r01m.config.objects.storage.R01MWorkArea;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.context.users.R01MUserAppSession;
import com.ejie.r01m.exceptions.R01MCatalogElementNotFoundException;
import com.ejie.r01m.exceptions.R01MCatalogException;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MPortalModelException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.cataloguing.R01MStructureCatalog;
import com.ejie.r01m.objects.cataloguing.structures.R01MBag;
import com.ejie.r01m.objects.cataloguing.structures.R01MStructure;
import com.ejie.r01m.objects.cataloguing.structures.R01MStructureItem;
import com.ejie.r01m.objects.portalmodel.R01MPage;
import com.ejie.r01m.objects.portalmodel.R01MPortal;
import com.ejie.r01m.objects.portalmodel.R01MPortalLocation;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MPortalManagerAPI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;

public class R01MPortalLabelsValidator {
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01m.portalAPI").intValue() != Level.OFF.intValue();

    public static boolean checkPageCatalogation(HttpServletRequest request, R01MUserContext userCtx, String pageOid) throws R01MSecurityException, R01MPortalModelException {
        String opDesc;
        block25: {
            R01MPortalManagerAPI portalAPI = R01MClientFactory.getPortalModelAPI(R01MUserAppSession.getUserContext(request), R01MUserAppSession.getUserPortalOid(request));
            R01MPage page = null;
            opDesc = "";
            try {
                page = portalAPI.loadPortalPage(pageOid);
                if (page == null) break block25;
                String string = opDesc = "Comprobar las catalogaciones de la p\u00e1gina del portal " + page != null ? page.getOid() : "null";
                if (DEBUG) {
                    R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (init): " + opDesc);
                }
                if (R01MPortalLabelsValidator.getMandatoryStructures(page.getPortalOid()).length() > 0) {
                    HashMap<String, R01MStructureCataloguingConfig> mandatoryStructuresNoCatalogued = new HashMap<String, R01MStructureCataloguingConfig>();
                    R01MStructureCataloguingConfig mandatoryStructure = null;
                    R01MWorkArea wa = R01MPortalLabelsValidator._getWorkArea(page.getPortalOid());
                    Map<String, R01MAllowedCataloguingBagConfig> allowedBags = wa.getCataloguingConfig().getAllowedBags();
                    for (Map.Entry<String, R01MStructureCataloguingConfig> me : wa.getCataloguingConfig().getMandatoryStructures().entrySet()) {
                        mandatoryStructure = me.getValue();
                        R01MStructure structureToCheck = null;
                        try {
                            structureToCheck = R01MClientFactory.getCatalogAPI(userCtx).loadStructure(mandatoryStructure.getStructureOid(), false);
                        }
                        catch (R01MCatalogElementNotFoundException e) {
                            R01FLog.to((String)"r01m.portalAPI").info("No existe la structura obligatoria : " + mandatoryStructure.getStructureOid());
                            continue;
                        }
                        R01MBag bagToCheck = R01MClientFactory.getCatalogAPI(userCtx).loadBag(structureToCheck.getSDefinition().getBagId());
                        if (allowedBags != null && !allowedBags.containsKey(bagToCheck.getBagGUID())) continue;
                        boolean bIncluded = false;
                        if (page.getLabels() != null && page.getLabels().size() > 0) {
                            R01MStructureCatalog currCat = null;
                            block9: for (int i = 0; i < page.getLabels().size(); ++i) {
                                currCat = page.getLabels().get(i);
                                if (!currCat.getStructureOid().equals(mandatoryStructure.getStructureOid())) continue;
                                if (mandatoryStructure.getRole() == null || StringUtils.isEmptyString((String)mandatoryStructure.getRole())) {
                                    bIncluded = true;
                                    break;
                                }
                                if (mandatoryStructure.getRole() != null && currCat.getRole() != null) {
                                    if (Integer.parseInt(mandatoryStructure.getRole()) == Integer.parseInt(currCat.role)) {
                                        bIncluded = true;
                                        break;
                                    }
                                    R01MStructure struct = R01MClientFactory.getCatalogAPI(R01MUserAppSession.getUserContext(request)).loadStructure(mandatoryStructure.getStructureOid());
                                    Collection branches = struct.findLabel(currCat.getOid());
                                    if (branches == null) continue;
                                    R01MStructureItem currBranchRootItem2 = null;
                                    R01MStructureItem currItem = null;
                                    for (R01MStructureItem currBranchRootItem2 : branches) {
                                        currItem = struct.findLabelInSubBranch(currBranchRootItem2, currCat.getOid());
                                        if (currItem.getChildren() != null && currItem.getChildren().size() != 0) continue;
                                        bIncluded = true;
                                        continue block9;
                                    }
                                    continue;
                                }
                                if (currCat.getRole() == null) continue;
                            }
                        }
                        if (bIncluded) continue;
                        mandatoryStructuresNoCatalogued.put(me.getKey(), me.getValue());
                    }
                    if (!mandatoryStructuresNoCatalogued.isEmpty()) {
                        return false;
                    }
                }
                if (StringUtils.isEmptyString((String)R01MPortalLabelsValidator.getMandatoryGroups(page.getPortalOid()))) break block25;
                R01MStructureGroupCataloguingConfig mandatoryGroup = null;
                R01MWorkArea wa = R01MPortalLabelsValidator._getWorkArea(page.getPortalOid());
                Map<String, R01MAllowedCataloguingBagConfig> allowedBags = wa.getCataloguingConfig().getAllowedBags();
                for (Map.Entry<String, R01MStructureGroupCataloguingConfig> me : wa.getCataloguingConfig().getMandatoryStructureGroups().entrySet()) {
                    mandatoryGroup = me.getValue();
                    List structuresOfGroup = R01MClientFactory.getCatalogAPI(R01MUserAppSession.getUserContext(request)).loadStructuresInGroup(mandatoryGroup.getGroupOid());
                    ArrayList<String> structuresOfGroupValid = new ArrayList<String>();
                    if (structuresOfGroup != null && !structuresOfGroup.isEmpty()) {
                        for (String structureOidTocheck : structuresOfGroup) {
                            R01MStructure structureToCheck = null;
                            try {
                                structureToCheck = R01MClientFactory.getCatalogAPI(userCtx).loadStructure(structureOidTocheck, false);
                            }
                            catch (R01MCatalogElementNotFoundException e) {
                                R01FLog.to((String)"r01m.portalAPI").info("No existe la structura obligatoria : " + structureOidTocheck);
                                continue;
                            }
                            R01MBag bagToCheck = R01MClientFactory.getCatalogAPI(userCtx).loadBag(structureToCheck.getSDefinition().getBagId());
                            if (allowedBags != null) {
                                if (!allowedBags.containsKey(bagToCheck.getBagGUID())) continue;
                                structuresOfGroupValid.add(structureOidTocheck);
                                continue;
                            }
                            structuresOfGroupValid.add(structureOidTocheck);
                        }
                    }
                    boolean bIncluded = false;
                    if (structuresOfGroupValid.isEmpty()) continue;
                    if (page.getLabels() != null && !page.getLabels().isEmpty()) {
                        R01MStructureCatalog currCat = null;
                        for (int i = 0; i < page.getLabels().size(); ++i) {
                            currCat = page.getLabels().get(i);
                            String structureOfLabel = currCat.getStructureOid();
                            if (!structuresOfGroupValid.contains(structureOfLabel)) continue;
                            bIncluded = true;
                        }
                    }
                    if (bIncluded) continue;
                    return false;
                }
            }
            catch (R01MCatalogElementNotFoundException catNotFoundExc) {
                throw new R01MPortalModelException("No se ha catalogado la p\u00e1gina en las estructuras obligatorias." + catNotFoundExc.getMessage(), (Exception)((Object)catNotFoundExc));
            }
            catch (R01MCatalogException catEx) {
                throw new R01MPortalModelException("No se ha catalogado la p\u00e1gina en las estructuras obligatorias." + catEx.getMessage(), (Exception)((Object)catEx));
            }
            catch (R01MSecurityException secExc) {
                throw secExc;
            }
        }
        if (DEBUG) {
            R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc);
        }
        return true;
    }

    public static String getAllowedBags(String portalOid) throws R01MPortalModelException {
        StringBuffer allowedBagsCollection = new StringBuffer("");
        R01MWorkArea workArea = R01MPortalLabelsValidator._getWorkArea(portalOid);
        if (workArea != null) {
            HashMap<String, R01MAllowedCataloguingBagConfig> allowedBagsMap = new HashMap<String, R01MAllowedCataloguingBagConfig>();
            if (workArea.getCataloguingConfig().getAllowedBags() != null && workArea.getCataloguingConfig().getAllowedBags().size() > 0) {
                allowedBagsMap.putAll(workArea.getCataloguingConfig().getAllowedBags());
            }
            Iterator allowedBagsMapIt = allowedBagsMap.keySet().iterator();
            while (allowedBagsMapIt.hasNext()) {
                allowedBagsCollection.append(allowedBagsMapIt.next());
                allowedBagsCollection.append('$');
            }
        }
        return allowedBagsCollection.toString();
    }

    public static String getWorkAreaBags(String portalOid) throws R01MPortalModelException {
        StringBuffer levelBagsCollection = new StringBuffer();
        R01MWorkArea workArea = R01MPortalLabelsValidator._getWorkArea(portalOid);
        if (workArea != null) {
            HashMap<String, R01MBag> levelBagsMap = new HashMap<String, R01MBag>();
            if (workArea.getCataloguingConfig().getLevelBags() != null && workArea.getCataloguingConfig().getLevelBags().size() > 0) {
                levelBagsMap.putAll(workArea.getCataloguingConfig().getLevelBags());
            }
            Iterator levelBagsMapIt = levelBagsMap.keySet().iterator();
            while (levelBagsMapIt.hasNext()) {
                levelBagsCollection.append(levelBagsMapIt.next());
                levelBagsCollection.append('$');
            }
        }
        return levelBagsCollection.toString();
    }

    public static String getMandatoryStructures(String portalOid) throws R01MPortalModelException {
        StringBuffer mandatoryStructuresCollection = new StringBuffer();
        R01MWorkArea workArea = R01MPortalLabelsValidator._getWorkArea(portalOid);
        if (workArea != null) {
            HashMap<String, R01MStructureCataloguingConfig> mandatoryStructuresMap = new HashMap<String, R01MStructureCataloguingConfig>();
            if (workArea.getCataloguingConfig().getMandatoryStructures() != null && workArea.getCataloguingConfig().getMandatoryStructures().size() > 0) {
                mandatoryStructuresMap.putAll(workArea.getCataloguingConfig().getMandatoryStructures());
            }
            for (String key : mandatoryStructuresMap.keySet()) {
                R01MStructureCataloguingConfig structureCatalogConfig = (R01MStructureCataloguingConfig)mandatoryStructuresMap.get(key);
                mandatoryStructuresCollection.append(structureCatalogConfig.getStructureOid());
                mandatoryStructuresCollection.append(';');
                mandatoryStructuresCollection.append(structureCatalogConfig.getRole());
                mandatoryStructuresCollection.append(';');
                mandatoryStructuresCollection.append(structureCatalogConfig.isUnique());
                mandatoryStructuresCollection.append(';');
                mandatoryStructuresCollection.append(structureCatalogConfig.isSelectParentLabels());
                mandatoryStructuresCollection.append('$');
            }
        }
        return mandatoryStructuresCollection.toString();
    }

    public static String getMandatoryGroups(String portalOid) throws R01MPortalModelException {
        StringBuffer mandatoryGroupsCollection = new StringBuffer("");
        R01MWorkArea workArea = R01MPortalLabelsValidator._getWorkArea(portalOid);
        if (workArea != null) {
            HashMap<String, R01MStructureGroupCataloguingConfig> mandatoryGroupsMap = new HashMap<String, R01MStructureGroupCataloguingConfig>();
            if (workArea.getCataloguingConfig().getMandatoryStructureGroups() != null && workArea.getCataloguingConfig().getMandatoryStructureGroups().size() > 0) {
                mandatoryGroupsMap.putAll(workArea.getCataloguingConfig().getMandatoryStructureGroups());
            }
            for (String key : mandatoryGroupsMap.keySet()) {
                R01MStructureGroupCataloguingConfig structureGroupCatalogConfig = (R01MStructureGroupCataloguingConfig)mandatoryGroupsMap.get(key);
                mandatoryGroupsCollection.append(structureGroupCatalogConfig.getGroupOid());
                mandatoryGroupsCollection.append(';');
                mandatoryGroupsCollection.append(structureGroupCatalogConfig.getDescription());
                mandatoryGroupsCollection.append('$');
            }
        }
        return mandatoryGroupsCollection.toString();
    }

    private static R01MWorkArea _getWorkArea(String portalOid) throws R01MPortalModelException {
        R01MPortal portal = null;
        R01MPortalLocation portalLocation = null;
        R01MWorkArea workArea = null;
        try {
            portal = R01MClientFactory.getPortalConfigAPI().loadPortal(portalOid);
        }
        catch (R01MConfigLoadException clExc) {
            throw new R01MPortalModelException("Error al obtener la configuraci\u00f3n del portal: " + clExc.getMessage(), (Exception)((Object)clExc));
        }
        if (portal == null) {
            return null;
        }
        portalLocation = portal.getStoreLocation();
        if (portalLocation != null) {
            try {
                workArea = R01MClientFactory.getStorageConfigAPI().getWorkAreaConfig(portalLocation.getServerOid(), portalLocation.getDataRepositoryOid(), portalLocation.getAreaOid(), portalLocation.getWorkAreaOid());
            }
            catch (R01MConfigLoadException clExc) {
                throw new R01MPortalModelException("Error al obtener la configuraci\u00f3n de la workArea actual: " + clExc.getMessage(), (Exception)((Object)clExc));
            }
        }
        return workArea;
    }
}

