/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.utils.link;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.NumberUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.link.R01MLink;
import com.ejie.r01m.objects.link.R01MLinkItem;
import com.ejie.r01m.objects.link.R01MPresentationPage;
import com.ejie.r01m.objects.link.R01MWindowAppearance;
import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.objects.urlreference.R01MUrlReference;
import com.ejie.r01m.objects.urlreference.R01MUrlReferencePresentationPage;
import com.ejie.r01m.objects.urlreference.R01MUrlReferenceWindowAppearance;
import com.ejie.r01m.objects.urlreference.R01MUrlResult;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.utils.R01MConstantsUrlReferenceConfig;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineUtils;
import com.ejie.r01m.utils.searchengine.R01MSearchResultsFormatterConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class R01MUrlReferencerToLinkUtils {
    public static R01MLink create(R01MUrlReference urlRef) {
        R01MLink lnkCom = null;
        if (urlRef != null) {
            R01FLog.to((String)"r01m.urlComposer").info("Tranformando objeto urlReference de tipo " + R01MConstantsUrlReferenceConfig.getTypeDescription(urlRef.getRefUrlType()));
            lnkCom = new R01MLink();
            lnkCom.setType(R01MUrlReferencerToLinkUtils.getType(urlRef.getRefUrlType()));
            R01MUrlReferencerToLinkUtils.createLinks(lnkCom, urlRef);
            lnkCom.setWindowAppareance(R01MUrlReferencerToLinkUtils.createWindowAppearance(urlRef.getRefWindowAppearance()));
            lnkCom.setPresentationPage(R01MUrlReferencerToLinkUtils.createPresentationPage(urlRef.getPageObject()));
            lnkCom.setJs(R01MUrlReferencerToLinkUtils.createJs(urlRef.getJsEvents()));
            lnkCom.setData(R01MUrlReferencerToLinkUtils.createLinkData(urlRef));
            if (urlRef.getPageObject().getIsAliasUrlPage().equals("on")) {
                lnkCom.getData().put("pageUrlFriendly", urlRef.getPageObject().getAliasUrlPage());
            } else {
                lnkCom.getData().remove("pageUrlFriendly");
            }
        }
        return lnkCom;
    }

    public static void createLinks(R01MLink linkComposer, R01MUrlReference urlRef) {
        ArrayList<R01MLinkItem> links = new ArrayList<R01MLinkItem>();
        List urlResults = urlRef.getRefResults();
        if (urlResults != null && !urlResults.isEmpty()) {
            boolean doIt = true;
            for (int i = 0; i < urlResults.size(); ++i) {
                if (!doIt) {
                    R01FLog.to((String)"r01m.urlComposer").info("ERROR al establer LINK ");
                }
                R01FLog.to((String)"r01m.urlComposer").info("Estableciendo LINK ................................");
                R01MLinkItem link = new R01MLinkItem();
                R01MUrlResult urlResult = (R01MUrlResult)urlResults.get(i);
                if (!StringUtils.isEmptyString((String)urlResult.getRefText())) {
                    link.setText(urlResult.getRefText());
                }
                if (!StringUtils.isEmptyString((String)urlResult.getRefUrl())) {
                    link.setUrl(urlResult.getRefUrl());
                }
                if (!StringUtils.isEmptyString((String)urlRef.getRefTextAlt())) {
                    link.setTitle(urlRef.getRefTextAlt());
                }
                HashMap<String, String> data = new HashMap<String, String>();
                String contentOid = "";
                if (urlResult.getResultDetail().containsKey(R01MSearchResultsFormatterConstants.CONTENT_OID) && !StringUtils.isEmptyString((String)urlResult.getResultDetail().get(R01MSearchResultsFormatterConstants.CONTENT_OID).toString()) && !StringUtils.isEmptyString((String)(contentOid = urlResult.getResultDetail().get(R01MSearchResultsFormatterConstants.CONTENT_OID).toString()))) {
                    data.put("contentOid", contentOid);
                }
                String documentOid = "";
                if (urlResult.getResultDetail().containsKey(R01MSearchResultsFormatterConstants.DOCUMENT_OID) && !StringUtils.isEmptyString((String)urlResult.getResultDetail().get(R01MSearchResultsFormatterConstants.DOCUMENT_OID).toString()) && !StringUtils.isEmptyString((String)(documentOid = urlResult.getResultDetail().get(R01MSearchResultsFormatterConstants.DOCUMENT_OID).toString()))) {
                    data.put("documentOid", documentOid);
                }
                if (!StringUtils.isEmptyString((String)contentOid)) {
                    try {
                        R01MContent content = R01MClientFactory.getContentModelAPI(R01MAuthManager.createMasterSystemUserContext()).loadContent(contentOid);
                        if (!StringUtils.isEmptyString((String)content.getName())) {
                            data.put("contentName", content.getName());
                        }
                    }
                    catch (R01MSecurityException ex) {
                        R01FLog.to((String)"r01m.urlComposer").info("No se ha cargado el contenido de oid " + urlRef.getRefContentOid());
                    }
                    catch (R01MContentModelException ex) {
                        R01FLog.to((String)"r01m.urlComposer").info("No se ha cargado el contenido de oid " + urlRef.getRefContentOid());
                    }
                    catch (Exception ex) {
                        R01FLog.to((String)"r01m.urlComposer").info("No se ha cargado el contenido de oid " + urlRef.getRefContentOid());
                    }
                }
                String documentName = "";
                if (urlResult.getResultDetail().containsKey(R01MSearchResultsFormatterConstants.DOCUMENT_NAME) && !StringUtils.isEmptyString((String)(documentName = (String)urlResult.getResultDetail().get(R01MSearchResultsFormatterConstants.DOCUMENT_NAME)))) {
                    data.put("documentName", documentName);
                }
                String url = "";
                if (urlResult.getResultDetail().containsKey(R01MSearchResultsFormatterConstants.NORMAL_URL) && !StringUtils.isEmptyString((String)(url = (String)urlResult.getResultDetail().get(R01MSearchResultsFormatterConstants.NORMAL_URL)))) {
                    data.put("url", url);
                }
                String urlFriendly = "";
                if (urlResult.getResultDetail().containsKey(R01MSearchResultsFormatterConstants.DOCUMENT_ALIAS_VIEW_URL)) {
                    urlFriendly = (String)urlResult.getResultDetail().get(R01MSearchResultsFormatterConstants.DOCUMENT_ALIAS_VIEW_URL);
                    if (!StringUtils.isEmptyString((String)url)) {
                        data.put("urlFriendly", urlFriendly);
                    }
                }
                String isUrlFriendly = "off";
                if (urlResult.getResultDetail().containsKey(R01MSearchResultsFormatterConstants.DOCUMENT_VIEW_URL_INFO) && !StringUtils.isEmptyString((String)(isUrlFriendly = (String)urlResult.getResultDetail().get(R01MSearchResultsFormatterConstants.DOCUMENT_VIEW_URL_INFO)))) {
                    if ("on".equals(isUrlFriendly) || "1".equals(isUrlFriendly)) {
                        linkComposer.setUrlFriendly(true);
                    } else {
                        linkComposer.setUrlFriendly(false);
                    }
                }
                if (urlRef.getRefUrlType() == 7) {
                    String fileName = urlResult.getRefUrl().substring(urlResult.getRefUrl().lastIndexOf("/") + 1, urlResult.getRefUrl().length());
                    data.put("attachmentName", fileName);
                }
                String documentPublishRepository = "";
                if (urlResult.getResultDetail().containsKey(R01MSearchResultsFormatterConstants.DOCUMENT_PUBLISH_REPOSITORY)) {
                    documentPublishRepository = (String)urlResult.getResultDetail().get(R01MSearchResultsFormatterConstants.DOCUMENT_PUBLISH_REPOSITORY);
                    if (!StringUtils.isEmptyString((String)url)) {
                        data.put("documentPublishRepository", documentPublishRepository);
                    }
                }
                if (urlResult.getResultDetail().containsKey(R01MSearchResultsFormatterConstants.CONTENT_TYPOLOGY)) {
                    data.put("contentTypology", (String)urlResult.getResultDetail().get(R01MSearchResultsFormatterConstants.CONTENT_TYPOLOGY));
                }
                link.setData(data);
                links.add(link);
                R01FLog.to((String)"r01m.urlComposer").info("LINK Establecido");
                doIt = true;
            }
        }
        linkComposer.setLinks(links);
    }

    public static R01MWindowAppearance createWindowAppearance(R01MUrlReferenceWindowAppearance winAppOld) {
        R01MWindowAppearance winApp = new R01MWindowAppearance();
        if (winAppOld != null) {
            if (NumberUtils.isInteger((String)winAppOld.getRefWindowHeight())) {
                winApp.setHeight(Integer.parseInt(winAppOld.getRefWindowHeight()));
            }
            if (NumberUtils.isInteger((String)winAppOld.getRefWindowWidth())) {
                winApp.setWidth(Integer.parseInt(winAppOld.getRefWindowWidth()));
            }
            if (NumberUtils.isInteger((String)winAppOld.getRefWindowY())) {
                winApp.setY(Integer.parseInt(winAppOld.getRefWindowY()));
            }
            if (NumberUtils.isInteger((String)winAppOld.getRefWindowX())) {
                winApp.setX(Integer.parseInt(winAppOld.getRefWindowX()));
            }
            if (winAppOld.getRefNewWindow().equals("1") || winAppOld.getRefNewWindow().equals("true")) {
                winApp.setNewWindow(true);
            } else {
                winApp.setNewWindow(false);
            }
            winApp.setWindowName(winAppOld.getRefWindowTarget());
        }
        return winApp;
    }

    public static R01MPresentationPage createPresentationPage(R01MUrlReferencePresentationPage pageOld) {
        R01MPresentationPage page = new R01MPresentationPage();
        if (pageOld != null) {
            if (!StringUtils.isEmptyString((String)pageOld.getPageId())) {
                page.setPageOid(pageOld.getPageId());
            }
            if (!StringUtils.isEmptyString((String)pageOld.getPageOid())) {
                page.setPageInternalName(pageOld.getPageOid());
            }
            if (!StringUtils.isEmptyString((String)pageOld.getLanguagePage())) {
                page.setLang(pageOld.getLanguagePage());
            }
            if (!StringUtils.isEmptyString((String)pageOld.getPortalGUID())) {
                page.setPortal(pageOld.getPortalGUID());
            }
        }
        return page;
    }

    public static Map createLinkData(R01MUrlReference urlRef) {
        R01MUrlResult urlResult;
        HashMap<String, String> data = new HashMap<String, String>();
        if (urlRef != null && urlRef.getRefResults() != null && !urlRef.getRefResults().isEmpty() && (urlResult = urlRef.getRefResult(0)).getResultDetail().containsKey(R01MConstantsUrlReferenceConfig.QUERY_XML)) {
            String queryXml = (String)urlResult.getResultDetail().get(R01MConstantsUrlReferenceConfig.QUERY_XML);
            R01FLog.to((String)"r01m.urlComposer").info("Estableciendo QUERY_XML");
            data.put("queryXml", queryXml);
            if (!StringUtils.isEmptyString((String)queryXml)) {
                try {
                    R01MQueryObject queryObject = R01MClientFactory.getSearchEngineSessionAPI().getQueryObjectFromXML(queryXml);
                    String queryUrl = R01MSearchEngineUtils.encodeQueryObjectInURL(queryObject);
                    R01FLog.to((String)"r01m.urlComposer").info("Estableciendo QUERY");
                    data.put("query", queryUrl);
                }
                catch (XOMarshallerException ex) {
                    ex.printStackTrace();
                }
            } else {
                R01FLog.to((String)"r01m.urlComposer").warning("Error al obtener el objeto R01MQueryObject del xml: null\r\nSe lanza la query general (sin parametros)");
            }
        }
        return data;
    }

    public static Map createJs(Map jsOld) {
        HashMap js = new HashMap();
        if (jsOld != null && !jsOld.isEmpty()) {
            for (Map.Entry me : jsOld.entrySet()) {
                if (StringUtils.isEmptyString((String)me.getValue().toString())) continue;
                js.put(me.getKey(), me.getValue());
            }
        }
        return js;
    }

    public static int getType(int type) {
        switch (type) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 7: {
                return 6;
            }
            case 8: {
                return 7;
            }
            case 0: {
                return 8;
            }
        }
        return -1;
    }
}

