/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.utils.link;

import com.ejie.r01f.file.FileUtils;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.servlet.URLDecoder;
import com.ejie.r01f.util.NumberUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MPortalModelException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MDocument;
import com.ejie.r01m.objects.link.R01MLink;
import com.ejie.r01m.objects.link.R01MLinkItem;
import com.ejie.r01m.objects.link.R01MPresentationPage;
import com.ejie.r01m.objects.link.R01MWindowAppearance;
import com.ejie.r01m.objects.resources.R01MLinkedResource;
import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.objects.urlreference.R01MHtmlLink;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MContentModelAPI;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MConstantsUrlReferenceConfig;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineUtils;
import com.ejie.r01m.utils.url.R01MPortalURL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;

public abstract class R01MLinkUtils {
    private static final int N_DISPOSICION = 3444;
    private static final String NEWSLETTER_PATH = "/bopv2/datos/";
    private static final String SSI_PORTAL_BODY = "echo var='PORTAL'";

    public static R01MLinkItem getLink(R01MLink linkComposer, int index) {
        if (linkComposer == null) {
            return null;
        }
        return linkComposer.getLink(index);
    }

    public static R01MLinkItem getLink(R01MLink linkComposer, String documentOid) {
        R01MLinkItem link = null;
        if (linkComposer == null || linkComposer.getLinkItems() == null || linkComposer.getLinkItems().isEmpty()) {
            return link;
        }
        for (int i = 0; !(i >= linkComposer.getLinkItems().size() || (link = linkComposer.getLinkItems().get(i)).getData() != null && (link.getData().containsKey("documentOid") && link.getData().get("documentOid").equals(documentOid) || link.getData().containsKey("pageOid") && link.getData().get("pageOid").equals(documentOid))); ++i) {
            link = null;
        }
        return link;
    }

    public static StringBuffer getHtml(R01MLink linkComposer) {
        return R01MLinkUtils.getHtml(linkComposer, null, 0);
    }

    public static StringBuffer getHtml(R01MLink linkComposer, String htmlToApply) {
        return R01MLinkUtils.getHtml(linkComposer, htmlToApply, 0);
    }

    public static StringBuffer getHtml(R01MLink linkComposer, String htmlToApply, int elementResult) {
        return R01MLinkUtils.getHtml(linkComposer, null, htmlToApply, null, elementResult);
    }

    public static StringBuffer getHtml(R01MLink linkComposer, Properties properties, String htmlToApply, String className, int elementResult) {
        StringBuffer html = new StringBuffer(21);
        R01MLinkItem link = R01MLinkUtils.getLink(linkComposer, elementResult);
        if (link == null) {
            return new StringBuffer("<a href=\"JavaScript:alert('URL NOT Configured');\" />");
        }
        R01MQueryObject queryObject = R01MLinkUtils.getQueryObject(linkComposer);
        String url = link.getUrl();
        if (!StringUtils.isEmptyString((String)link.getText()) && StringUtils.isEmptyString((String)link.getUrl())) {
            html.append(link.getText());
            return html;
        }
        if (linkComposer.getType() == 3 && queryObject != null) {
            String queryString = "r01kQry=" + R01MSearchEngineUtils.encodeQueryObjectInURL(queryObject, false);
            if (link != null && link.getUrl() != null && link.getUrl().indexOf("?") != -1) {
                url = link.getUrl().substring(0, link.getUrl().indexOf("?")) + "?" + queryString;
            }
        }
        if (linkComposer.getType() == 8 && !url.startsWith("/") && !url.startsWith("#") && !"#".equals(url) && StringUtils.isEmptyString((String)R01MLinkUtils.getUrlProtocol(url))) {
            url = "http://" + url;
        }
        html.append("<a");
        html.append(R01MLinkUtils.composeHrefWindowAppearance(url, linkComposer.getWindowAppareance(), linkComposer.getJs()));
        if (!StringUtils.isEmptyString((String)linkComposer.getFirstLinkItem().getTitle())) {
            html.append(" title=\"");
            html.append(linkComposer.getFirstLinkItem().getTitle());
            html.append("\"");
        }
        if (className != null && className.length() > 0) {
            html.append(" class=\"");
            html.append(className);
            html.append("\"");
        }
        if (properties != null && !properties.isEmpty()) {
            for (Map.Entry<Object, Object> meAttribute : properties.entrySet()) {
                html.append(" ");
                html.append(meAttribute.getKey());
                html.append("=\"");
                html.append(meAttribute.getValue());
                html.append("\"");
            }
        }
        if (!StringUtils.isEmptyString((String)linkComposer.getFirstLinkItem().getAccesskey())) {
            html.append(" accesskey=\"" + linkComposer.getFirstLinkItem().getAccesskey() + "\"");
        }
        html.append(">");
        if (htmlToApply != null && htmlToApply.length() > 0) {
            html.append(htmlToApply);
        } else if (link.getText() != null && link.getText().length() > 0) {
            html.append(link.getText());
        } else if (linkComposer.getFirstLinkItem().getTitle() != null && linkComposer.getFirstLinkItem().getTitle().length() > 0) {
            html.append(R01MLinkUtils.filtrarHTML(linkComposer.getFirstLinkItem().getTitle()));
        } else if (linkComposer.getType() == 6) {
            String[] urlSplit = link.getUrl().split("/");
            String fileName = urlSplit[urlSplit.length - 1];
            html.append(fileName);
        } else {
            html.append(url);
        }
        html.append("</a>");
        return html;
    }

    public static StringBuffer composeHrefWindowAppearance(String url, R01MWindowAppearance windowAppearance) {
        return R01MLinkUtils.composeHrefWindowAppearance(url, windowAppearance, null);
    }

    public static StringBuffer composeHrefWindowAppearance(String url, R01MWindowAppearance windowAppearance, Map jsEvents) {
        StringBuffer link = new StringBuffer(20);
        link.append(" href=\"");
        boolean windowOpen = false;
        StringBuffer htmlEvent = new StringBuffer(122);
        if (windowAppearance != null) {
            if (windowAppearance.isNewWindow()) {
                link.append(url);
                link.append("\" target=\"");
                String windowName = windowAppearance.getWindowName();
                if (windowName == null || StringUtils.isEmptyString((String)windowName)) {
                    windowName = "_blank";
                }
                link.append(windowName);
                link.append("\"");
                if (windowAppearance.getPredefType() != 4) {
                    windowOpen = true;
                    htmlEvent.append("window.open('");
                    htmlEvent.append(url);
                    htmlEvent.append("','");
                    htmlEvent.append(windowName);
                    if (windowAppearance.getPredefType() == 1) {
                        htmlEvent.append("', 'height=");
                        htmlEvent.append(600);
                        htmlEvent.append(", width=");
                        htmlEvent.append(800);
                        htmlEvent.append(", left=");
                        htmlEvent.append(250);
                        htmlEvent.append(", top=");
                        htmlEvent.append(250);
                        htmlEvent.append(", menubar=");
                        htmlEvent.append(R01MLinkUtils.getOpenWindowValues(windowAppearance.isMenuBar()));
                        htmlEvent.append(", resizable=");
                        htmlEvent.append(R01MLinkUtils.getOpenWindowValues(windowAppearance.isResizable()));
                        htmlEvent.append(", status=");
                        htmlEvent.append(R01MLinkUtils.getOpenWindowValues(windowAppearance.isStateBar()));
                        htmlEvent.append(", toolbar=");
                        htmlEvent.append(R01MLinkUtils.getOpenWindowValues(windowAppearance.isToolBar()));
                        htmlEvent.append(", location=");
                        htmlEvent.append(R01MLinkUtils.getOpenWindowValues(windowAppearance.isLocationBar()));
                        htmlEvent.append(", scrollbars=");
                        htmlEvent.append(R01MLinkUtils.getOpenWindowValues(windowAppearance.isScrollBar()));
                        htmlEvent.append(" , titlebar=yes, directories=yes');return false;");
                    } else if (windowAppearance.getPredefType() == 2) {
                        htmlEvent.append("', 'fullscreen=yes, scrollbars=yes');return false;");
                    } else if (windowAppearance.getPredefType() == 3) {
                        htmlEvent.append("', 'height=");
                        htmlEvent.append(windowAppearance.getHeight());
                        htmlEvent.append(", width=");
                        htmlEvent.append(windowAppearance.getWidth());
                        htmlEvent.append(", left=");
                        htmlEvent.append(windowAppearance.getY());
                        htmlEvent.append(", top=");
                        htmlEvent.append(windowAppearance.getY());
                        htmlEvent.append(", menubar=");
                        htmlEvent.append(R01MLinkUtils.getOpenWindowValues(windowAppearance.isMenuBar()));
                        htmlEvent.append(", resizable=");
                        htmlEvent.append(R01MLinkUtils.getOpenWindowValues(windowAppearance.isResizable()));
                        htmlEvent.append(", status=");
                        htmlEvent.append(R01MLinkUtils.getOpenWindowValues(windowAppearance.isStateBar()));
                        htmlEvent.append(", toolbar=");
                        htmlEvent.append(R01MLinkUtils.getOpenWindowValues(windowAppearance.isToolBar()));
                        htmlEvent.append(", location=");
                        htmlEvent.append(R01MLinkUtils.getOpenWindowValues(windowAppearance.isLocationBar()));
                        htmlEvent.append(", scrollbars=");
                        htmlEvent.append(R01MLinkUtils.getOpenWindowValues(windowAppearance.isScrollBar()));
                        htmlEvent.append(" , titlebar=yes, directories=yes');return false;");
                    } else {
                        htmlEvent.append("');return false;");
                    }
                }
            } else {
                link.append(url);
                link.append("\"");
            }
        } else {
            link.append(url);
            link.append("\"");
        }
        if (jsEvents != null && !jsEvents.isEmpty()) {
            for (Map.Entry ent : jsEvents.entrySet()) {
                if (StringUtils.isEmptyString((String)ent.getValue().toString())) continue;
                link.append(" ");
                link.append(ent.getKey());
                link.append("=\"");
                link.append(StringEscapeUtils.unescapeJavaScript((String)StringEscapeUtils.unescapeJavaScript((String)ent.getValue().toString())));
                if (!ent.getValue().toString().endsWith(";")) {
                    link.append(";");
                }
                if (ent.getKey().toString().equalsIgnoreCase("ONCLICK") && windowOpen) {
                    link.append(htmlEvent);
                    windowOpen = false;
                }
                link.append("\"");
            }
        }
        if (windowOpen) {
            link.append(" onclick=\"");
            link.append(htmlEvent);
            link.append("\"");
        }
        return link;
    }

    public static String getRefText(R01MLink linkComposer, int elementResult) {
        String text = "";
        R01MLinkItem link = R01MLinkUtils.getLink(linkComposer, elementResult);
        if (link != null) {
            text = link.getText();
        }
        return R01MLinkUtils.filtrarHTML(text);
    }

    public static boolean isEmptyRefText(R01MLink linkComposer) {
        return linkComposer == null || StringUtils.isEmptyString((String)linkComposer.getFirstLinkItem().getText());
    }

    public static R01MLink getUrlReference(String refHTML) {
        return R01MLinkUtils.parseURLToURLReference(refHTML);
    }

    public static R01MLink parseURLToURLReference(String refHTML) {
        String htmlRef = refHTML;
        R01MLink linkComposer = new R01MLink();
        R01MLinkItem link = new R01MLinkItem();
        R01MWindowAppearance windowAppeareance = new R01MWindowAppearance();
        String url = "";
        int type = -1;
        boolean isNewWindow = false;
        String text = "";
        String textAlt = "";
        int windowHeight = 0;
        int windowWidth = 0;
        int posX = 0;
        int posY = 0;
        String windowName = "";
        ArrayList<R01MLinkItem> resultsList = new ArrayList<R01MLinkItem>();
        R01MHtmlLink htmlLink = new R01MHtmlLink();
        R01MPortalURL portalURL = null;
        try {
            String img = null;
            if (htmlRef.indexOf("><") > 0) {
                img = htmlRef.substring(htmlRef.indexOf("><") + 1, htmlRef.lastIndexOf("><") + 1);
                htmlRef = htmlRef.replaceAll(img, "");
            }
            String pathMap = R01MConstants.HTMLTOURLREFERENCER_MAPFILE;
            htmlRef = R01MLinkUtils.encodeXMLEntities(htmlRef);
            if (!StringUtils.isEmptyString((String)(htmlRef = R01MHtmlLink.validateHtmlTagAttributes(htmlRef)))) {
                htmlLink = (R01MHtmlLink)XOManager.getObject((String)pathMap, (String)htmlRef);
            }
            text = img == null ? htmlLink.getA() : img;
            textAlt = htmlLink.getAlt();
            if (textAlt == null || textAlt.equals("")) {
                textAlt = htmlLink.getTitle();
            }
            if (text == null) {
                text = "";
            }
            if (textAlt == null) {
                textAlt = "";
            }
            url = htmlLink.getHref();
            portalURL = new R01MPortalURL(url);
            type = R01MLinkUtils.getUrlType(portalURL.getURLType());
            linkComposer.setType(portalURL.getURLType());
            windowName = htmlLink.getTarget();
            String onmousedown = htmlLink.getOnmousedown();
            if (onmousedown != null && onmousedown.length() > 0) {
                StringTokenizer tokenStr = new StringTokenizer(onmousedown, ",");
                while (tokenStr.hasMoreTokens()) {
                    String token = tokenStr.nextToken().replaceAll(" ", "");
                    if (token.indexOf("window.open") != -1) {
                        String[] aux = null;
                        aux = token.indexOf("'") != -1 ? token.split("'") : token.split("\"");
                        url = aux[1];
                        continue;
                    }
                    if (token.indexOf("height") != -1) {
                        if (!NumberUtils.isNumber((String)token.substring(token.indexOf("height") + "height".length() + 1, token.length()))) continue;
                        windowHeight = Integer.parseInt(token.substring(token.indexOf("height") + "height".length() + 1, token.length()));
                        continue;
                    }
                    if (token.indexOf("width") != -1) {
                        if (!NumberUtils.isNumber((String)token.substring(token.indexOf("width") + "width".length() + 1, token.length()))) continue;
                        windowHeight = Integer.parseInt(token.substring(token.indexOf("width") + "width".length() + 1, token.length()));
                        continue;
                    }
                    if (token.indexOf("left") != -1) {
                        if (!NumberUtils.isNumber((String)token.substring(token.indexOf("left") + "left".length() + 1, token.length()))) continue;
                        posX = Integer.parseInt(token.substring(token.indexOf("left") + "left".length() + 1, token.length()));
                        continue;
                    }
                    if (token.indexOf("top") == -1 || !NumberUtils.isNumber((String)token.substring(token.indexOf("top") + "top".length() + 1, token.length()))) continue;
                    posX = Integer.parseInt(token.substring(token.indexOf("top") + "top".length() + 1, token.length()));
                }
                isNewWindow = true;
            }
            if (windowName != null && !StringUtils.isEmptyString((String)windowName)) {
                isNewWindow = true;
            }
        }
        catch (XOMarshallerException xoEx) {
            R01FLog.to((String)"r01m.urlComposer").severe("Error en la transformacion del link a objeto: " + xoEx.getMessage());
            xoEx.printStackTrace();
            return null;
        }
        link.setUrl(url);
        link.setText(StringUtils.encodeXMLEntities((String)text));
        link.setTitle(textAlt);
        if (type == 1 || type == 3) {
            R01MPresentationPage presentationPage = new R01MPresentationPage();
            presentationPage.setPortal(portalURL.getPortalCode());
            presentationPage.setPageOid(portalURL.getPageCode());
            presentationPage.setLang(portalURL.getPortalLang());
            linkComposer.setPresentationPage(presentationPage);
            if (type == 3) {
                portalURL.getURLPart("queryValue");
                R01MQueryObject queryObject = R01MSearchEngineUtils.obtainQueryObjectFromUrl("?" + portalURL.getURLPart("queryType") + "=" + portalURL.getURLPart("queryValue"));
                String xmlMapping = R01MConstants.QUERY_RESULTS_MAPFILE;
                String queryXML = "";
                if (queryObject != null) {
                    try {
                        queryXML = XOManager.getXML((String)xmlMapping, (Object)queryObject);
                    }
                    catch (XOMarshallerException ex) {
                        R01FLog.to((String)"r01m.urlComposer").severe("Error mappeando el objeto de la query: " + ex.getMessage());
                    }
                }
                linkComposer.getData().put("queryXml", queryXML);
            }
        } else if (type == 5) {
            HashMap<String, String> newsLetterResult = new HashMap<String, String>();
            newsLetterResult.put(R01MConstantsUrlReferenceConfig.NEWSLETTER_PUBLISHYEAR, portalURL.getURLPart("bopvYear"));
            newsLetterResult.put(R01MConstantsUrlReferenceConfig.NEWSLETTER_PUBLISHMONTH, portalURL.getURLPart("bopvMonth"));
            newsLetterResult.put(R01MConstantsUrlReferenceConfig.NEWSLETTER_NUMBERCODE, portalURL.getURLPart("bopvDisp"));
            link.setData(newsLetterResult);
        }
        resultsList.add(link);
        linkComposer.setLinks(resultsList);
        linkComposer.setType(type);
        windowAppeareance.setNewWindow(isNewWindow);
        windowAppeareance.setWindowName(windowName);
        windowAppeareance.setHeight(windowHeight);
        windowAppeareance.setWidth(windowWidth);
        windowAppeareance.setX(posX);
        windowAppeareance.setY(posY);
        windowAppeareance.setWindowName(windowName);
        linkComposer.setWindowAppareance(windowAppeareance);
        return linkComposer;
    }

    public static R01MLink convertURLToURLReference(String url) {
        R01MLink linkComposer = new R01MLink();
        R01MLinkItem link = new R01MLinkItem();
        R01MWindowAppearance windowAppeareance = new R01MWindowAppearance();
        int type = -1;
        String text = "";
        String textAlt = "";
        int windowHeight = 0;
        int windowWidth = 0;
        int posX = 0;
        int posY = 0;
        String windowName = "";
        ArrayList<R01MLinkItem> resultsList = new ArrayList<R01MLinkItem>();
        R01MPortalURL portalURL = null;
        portalURL = new R01MPortalURL(url);
        type = R01MLinkUtils.getUrlType(portalURL.getURLType());
        linkComposer.setType(type);
        link.setUrl(url);
        link.setText(StringUtils.encodeXMLEntities((String)text));
        link.setTitle(textAlt);
        if (type == 1 || type == 3) {
            if (!StringUtils.isEmptyString((String)portalURL.getPortalCode()) && !StringUtils.isEmptyString((String)portalURL.getPageCode())) {
                R01MPresentationPage presentationPage = new R01MPresentationPage();
                presentationPage.setPortal(portalURL.getPortalCode());
                presentationPage.setPageOid(portalURL.getPageCode());
                presentationPage.setLang(portalURL.getPortalLang());
                linkComposer.setPresentationPage(presentationPage);
                if (portalURL.getPortalCode().indexOf(SSI_PORTAL_BODY) != -1) {
                    linkComposer.setSamePage(true);
                } else {
                    linkComposer.setSamePage(false);
                }
            }
            if (type == 3) {
                portalURL.getURLPart("queryValue");
                HashMap<String, String> queryResult = new HashMap<String, String>();
                R01MQueryObject queryObject = R01MSearchEngineUtils.obtainQueryObjectFromUrl("?" + portalURL.getURLPart("queryType") + "=" + portalURL.getURLPart("queryValue"));
                String xmlMapping = R01MConstants.QUERY_RESULTS_MAPFILE;
                String queryXML = "";
                if (queryObject != null) {
                    try {
                        queryXML = XOManager.getXML((String)xmlMapping, (Object)queryObject);
                    }
                    catch (XOMarshallerException ex) {
                        R01FLog.to((String)"r01m.urlComposer").severe("Error mappeando el objeto de la query: " + ex.getMessage());
                    }
                }
                queryResult.put(R01MConstantsUrlReferenceConfig.QUERY_XML, queryXML);
                queryResult.put("query", R01MSearchEngineUtils.encodeQueryObjectInURL(queryObject));
                queryResult.put("url", "?" + portalURL.getURLPart("queryType") + "=" + portalURL.getURLPart("queryValue"));
                link.setData(queryResult);
                linkComposer.setData(queryResult);
            }
        } else if (type == 5) {
            HashMap<String, String> newsLetterResult = new HashMap<String, String>();
            newsLetterResult.put(R01MConstantsUrlReferenceConfig.NEWSLETTER_PUBLISHYEAR, portalURL.getURLPart("bopvYear"));
            newsLetterResult.put(R01MConstantsUrlReferenceConfig.NEWSLETTER_PUBLISHMONTH, portalURL.getURLPart("bopvMonth"));
            newsLetterResult.put(R01MConstantsUrlReferenceConfig.NEWSLETTER_NUMBERCODE, portalURL.getURLPart("bopvDisp"));
            link.setData(newsLetterResult);
        } else if (type == 2) {
            if (!StringUtils.isEmptyString((String)portalURL.getPortalCode()) && !StringUtils.isEmptyString((String)portalURL.getPageCode())) {
                R01MPresentationPage presentationPage = new R01MPresentationPage();
                presentationPage.setPortal(portalURL.getPortalCode());
                presentationPage.setPageOid(portalURL.getPageCode());
                presentationPage.setLang(portalURL.getPortalLang());
                linkComposer.setPresentationPage(presentationPage);
                if (portalURL.getPortalCode().indexOf(SSI_PORTAL_BODY) != -1) {
                    linkComposer.setSamePage(true);
                } else {
                    linkComposer.setSamePage(false);
                }
            }
            try {
                String contentName = portalURL.getURLPart("contentName");
                String contentType = portalURL.getURLPart("contentType");
                String documentName = portalURL.getURLPart("documentInternalName");
                String lang = portalURL.getURLPart("documentLang");
                R01MContentModelAPI api = R01MClientFactory.getContentModelAPI(R01MAuthManager.createMasterSystemUserContext());
                String contentOid = api.getContentOidFromContentTypeAndName(contentType, contentName);
                R01MContent content = api.loadContent(contentOid);
                String documentOid = content.getDocumentsByLanguageAndInternalName(lang, documentName).getOid();
                R01MLink linkTmp = new R01MLink();
                linkTmp.addLinkItemDocument(contentOid, documentOid);
                link = linkTmp.getFirstLinkItem();
            }
            catch (R01MSecurityException e) {
                e.printStackTrace();
            }
            catch (R01MContentModelException e) {
                e.printStackTrace();
            }
        } else if (type == 6) {
            HashMap<String, String> newData = new HashMap<String, String>();
            try {
                String contentName = portalURL.getURLPart("contentName");
                String contentType = portalURL.getURLPart("contentType");
                String documentName = portalURL.getURLPart("documentInternalName");
                String lang = portalURL.getURLPart("documentLang");
                String attachmentName = portalURL.getURLPart("documentFile");
                R01MContentModelAPI api = R01MClientFactory.getContentModelAPI(R01MAuthManager.createMasterSystemUserContext());
                String contentOid = api.getContentOidFromContentTypeAndName(contentType, contentName);
                R01MContent content = api.loadContent(contentOid);
                R01MDocument doc = content.getDocumentsByLanguageAndInternalName(lang, documentName);
                if (content != null) {
                    newData.put("contentOid", content.getOid());
                    newData.put("contentName", content.getName());
                }
                if (doc != null) {
                    newData.put("documentOid", doc.getOid());
                    newData.put("documentName", doc.getName());
                } else {
                    newData.put("documentOid", "");
                    newData.put("documentName", "");
                }
                newData.put("attachmentName", attachmentName);
                link.setData(newData);
            }
            catch (R01MSecurityException e) {
                e.printStackTrace();
            }
            catch (R01MContentModelException e) {
                e.printStackTrace();
            }
        }
        resultsList.add(link);
        linkComposer.setLinks(resultsList);
        linkComposer.setType(type);
        windowAppeareance.setHeight(windowHeight);
        windowAppeareance.setWidth(windowWidth);
        windowAppeareance.setX(posX);
        windowAppeareance.setY(posY);
        windowAppeareance.setWindowName(windowName);
        linkComposer.setWindowAppareance(windowAppeareance);
        return linkComposer;
    }

    public static int getUrlType(int urlType) {
        int returnType = 0;
        switch (urlType) {
            case -1: {
                returnType = -1;
                break;
            }
            case 0: {
                returnType = 8;
                break;
            }
            case 1: {
                returnType = 1;
                break;
            }
            case 2: {
                returnType = 2;
                break;
            }
            case 10: {
                returnType = 2;
                break;
            }
            case 11: {
                returnType = 8;
                break;
            }
            case 12: {
                returnType = 8;
                break;
            }
            case 13: {
                returnType = 5;
                break;
            }
            case 14: {
                returnType = 3;
                break;
            }
            case 21: {
                returnType = 6;
                break;
            }
            default: {
                returnType = 8;
            }
        }
        return returnType;
    }

    public static String encodeUrlSpaces(String cadena) {
        if (cadena == null || cadena.length() == 0) {
            return cadena;
        }
        StringBuffer cadenaAux = new StringBuffer(cadena.length());
        for (int i = 0; i < cadena.length(); ++i) {
            if (cadena.charAt(i) == ' ') {
                cadenaAux.append("%20");
                continue;
            }
            cadenaAux.append(cadena.charAt(i));
        }
        return cadenaAux.toString();
    }

    public static StringBuffer encodeUrlSpaces(StringBuffer cadena) {
        if (cadena == null || StringUtils.isEmptyStringBuffer((StringBuffer)cadena)) {
            return cadena;
        }
        StringBuffer cadenaAux = new StringBuffer(cadena.length());
        for (int i = 0; i < cadena.length(); ++i) {
            if (cadena.charAt(i) == ' ') {
                cadenaAux.append("%20");
                continue;
            }
            cadenaAux.append(cadena.charAt(i));
        }
        return cadenaAux;
    }

    public static R01MLink getLinkComposerObject(String xml) {
        List<R01MLinkItem> results;
        R01MLink linkComposer = null;
        if (!StringUtils.isEmptyString((String)xml)) {
            try {
                linkComposer = (R01MLink)XOManager.getObject((String)R01MConstants.LINK_MAPFILE, (String)xml);
            }
            catch (XOMarshallerException xoEx) {
                R01FLog.to((String)"r01m.urlComposer").severe("Error en la obtenci\u00f3n del objeto que encapsula el xml resultado de realizar una invocaci\u00f3n al referenciador." + xoEx.getMessage());
                return null;
            }
        }
        if (linkComposer != null && (results = linkComposer.getLinkItems()) != null && !results.isEmpty()) {
            for (R01MLinkItem result : results) {
                result.setUrl(R01MLinkUtils.filterAmpCharacter(result.getUrl()));
            }
        }
        return linkComposer;
    }

    public static R01MLinkedResource getLinkedResourceObject(String xml) {
        R01MLinkedResource lnkRes = null;
        if (xml != null && !StringUtils.isEmptyString((String)xml)) {
            try {
                lnkRes = (R01MLinkedResource)XOManager.getObject((String)R01MConstants.LINK_MAPFILE, (String)xml);
            }
            catch (XOMarshallerException xoEx) {
                R01FLog.to((String)"r01m.urlComposer").severe("Error en la obtenci\u00f3n del objeto que encapsula el xml resultado de realizar una invocaci\u00f3n al referenciador." + xoEx.getMessage());
                return null;
            }
        }
        return lnkRes;
    }

    public static String getLinkComposerXML(R01MLink linkComposer) throws R01MPortalModelException {
        String xml = "";
        if (linkComposer != null) {
            try {
                xml = XOManager.getXML((String)R01MConstants.LINK_MAPFILE, (Object)linkComposer);
            }
            catch (XOMarshallerException xoEx) {
                xoEx.printStackTrace(System.out);
                throw new R01MPortalModelException("Error en la obtenci\u00f3n del xml que encapsula la informaci\u00f3n resultado de realizar una invocaci\u00f3n al referenciador." + xoEx.getMessage());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return xml;
    }

    public static String getLinkedResourceXML(R01MLinkedResource lnkResource) throws R01MPortalModelException {
        String xml = "";
        if (lnkResource != null) {
            try {
                xml = XOManager.getXML((String)R01MConstants.LINK_MAPFILE, (Object)lnkResource);
            }
            catch (XOMarshallerException xoEx) {
                xoEx.printStackTrace(System.out);
                throw new R01MPortalModelException("Error en la obtenci\u00f3n del xml que encapsula la informaci\u00f3n de un recurso vinculado." + xoEx.getMessage());
            }
        }
        return xml;
    }

    private static String filterAmpCharacter(String value) {
        String targetValue = "";
        try {
            String patternStr = "&(?![#a-zA-Z0-9]+;)";
            if (value != null && !value.trim().equals("")) {
                Pattern pattern = Pattern.compile(patternStr);
                Matcher matcher = pattern.matcher(value);
                StringBuffer buf = new StringBuffer();
                while (matcher.find()) {
                    String strReplacement = "&amp;";
                    matcher.appendReplacement(buf, "");
                    buf.append(strReplacement);
                }
                matcher.appendTail(buf);
                targetValue = buf.toString();
            }
        }
        catch (Exception e) {
            return value;
        }
        return targetValue;
    }

    public static String getNormalUrl(R01MLinkItem link) {
        String url = null;
        if (link != null) {
            url = link.getData() != null && link.getData().containsKey("url") ? (String)link.getData().get("url") : link.getUrl();
        }
        return url;
    }

    public static String composeNewsPaperUrl(String year, String month, String number, String lang) {
        boolean isNumeric = NumberUtils.isNumber((String)number);
        if (month != null && year != null && lang != null && !StringUtils.isEmptyString((String)number) && isNumeric) {
            month = StringUtils.lPadWithChar((String)month, (char)'0', (int)2);
            number = StringUtils.lPadWithChar((String)number, (char)'0', (int)5);
            String letter = "a";
            if ("eu".equals(lang)) {
                int yearI = Integer.parseInt(year);
                int disp = Integer.parseInt(number);
                if (yearI > 2011) {
                    letter = "e";
                } else if (yearI == 2011 && ("7".equals(month) && 3444 <= disp || 7 < Integer.parseInt(month))) {
                    letter = "e";
                }
            }
            return NEWSLETTER_PATH + year + "/" + month + "/" + year.substring(2, year.length()) + "" + number + letter + ".pdf";
        }
        return "#";
    }

    public static String composeHTML(R01MLink linkComposer) {
        return R01MLinkUtils.composeHTML(linkComposer, 0);
    }

    public static String composeHTML(R01MLink linkComposer, int pos) {
        R01MWindowAppearance windowAppearance;
        R01MLinkItem link;
        if (linkComposer == null) {
            return "";
        }
        if (!linkComposer.getLinkItems().isEmpty() && linkComposer.getLinkItems().size() >= pos) {
            link = linkComposer.getLink(pos);
            windowAppearance = linkComposer.getWindowAppareance();
        } else {
            link = linkComposer.getFirstLinkItem();
            windowAppearance = linkComposer.getWindowAppareance();
        }
        StringBuffer html = new StringBuffer();
        html.append("<a href=\"");
        String url = link.getUrl();
        if (linkComposer.getType() == 8 && !url.startsWith("/") && !url.startsWith("#") && !"#".equals(url) && StringUtils.isEmptyString((String)R01MLinkUtils.getUrlProtocol(url))) {
            url = "http://" + url;
        }
        if (StringUtils.isEmptyString((String)url)) {
            url = "#";
        }
        html.append(url);
        html.append("\"");
        if (linkComposer.getType() == 6 || linkComposer.getType() == 5) {
            String[] splitFileNameAndExtension;
            String extension = "pdf";
            if (linkComposer.getType() == 6 && link != null && link.getData() != null && link.getData().containsKey("attachmentName") && (splitFileNameAndExtension = FileUtils.splitFileNameAndExtension((String)((String)link.getData().get("attachmentName")))).length == 2) {
                extension = splitFileNameAndExtension[1];
            }
            if (!StringUtils.isEmptyString((String)extension)) {
                html.append(" class=\"r01LinkAttach r01LinkAttach_");
                html.append(extension);
                html.append("\"");
            }
        }
        if (link.getTitle() != null && !"".equals(link.getTitle())) {
            html.append(" title=\"");
            html.append(link.getTitle());
            html.append("\"");
        }
        StringBuffer target = new StringBuffer();
        StringBuffer windowOpen = new StringBuffer();
        if (windowAppearance.isNewWindow() && !StringUtils.isEmptyString((String)link.getUrl())) {
            if (windowAppearance.getWindowName() == null || "".equals(windowAppearance.getWindowName())) {
                target.append("target=\"");
                target.append("_blank");
                target.append("\"");
            } else {
                target.append("target=\"");
                target.append(windowAppearance.getWindowName());
                target.append("\"");
            }
            if (windowAppearance.getPredefType() > -1 && windowAppearance.getPredefType() < 4 && link.getUrl() != null && !"".equals(link.getUrl())) {
                windowOpen.append("window.open('");
                windowOpen.append(url);
                windowOpen.append("'");
                if (!StringUtils.isEmptyString((String)windowAppearance.getWindowName())) {
                    windowOpen.append(",'");
                    windowOpen.append(windowAppearance.getWindowName());
                    windowOpen.append("'");
                } else {
                    windowOpen.append(",'_blank'");
                }
                if (windowAppearance.getPredefType() == 1) {
                    windowOpen.append(", 'height=");
                    windowOpen.append(600);
                    windowOpen.append(", width=");
                    windowOpen.append(800);
                    windowOpen.append(", left=");
                    windowOpen.append(250);
                    windowOpen.append(", top=");
                    windowOpen.append(250);
                    windowOpen.append(", menubar=");
                    windowOpen.append(R01MLinkUtils.getOpenWindowValues(windowAppearance.isMenuBar()));
                    windowOpen.append(", resizable=");
                    windowOpen.append(R01MLinkUtils.getOpenWindowValues(windowAppearance.isResizable()));
                    windowOpen.append(", status=");
                    windowOpen.append(R01MLinkUtils.getOpenWindowValues(windowAppearance.isStateBar()));
                    windowOpen.append(", toolbar=");
                    windowOpen.append(R01MLinkUtils.getOpenWindowValues(windowAppearance.isToolBar()));
                    windowOpen.append(", location=");
                    windowOpen.append(R01MLinkUtils.getOpenWindowValues(windowAppearance.isLocationBar()));
                    windowOpen.append(", scrollbars=");
                    windowOpen.append(R01MLinkUtils.getOpenWindowValues(windowAppearance.isScrollBar()));
                    windowOpen.append(" , titlebar=yes, directories=yes');return false;\"");
                } else if (windowAppearance.getPredefType() == 2) {
                    windowOpen.append(", 'fullscreen=yes, scrollbars=yes');return false;\"");
                } else if (windowAppearance.getPredefType() == 3) {
                    windowOpen.append(", 'height=");
                    windowOpen.append(windowAppearance.getHeight());
                    windowOpen.append(", width=");
                    windowOpen.append(windowAppearance.getWidth());
                    windowOpen.append(", left=");
                    windowOpen.append(windowAppearance.getX());
                    windowOpen.append(", top=");
                    windowOpen.append(windowAppearance.getY());
                    windowOpen.append(", menubar=");
                    windowOpen.append(R01MLinkUtils.getOpenWindowValues(windowAppearance.isMenuBar()));
                    windowOpen.append(", resizable=");
                    windowOpen.append(R01MLinkUtils.getOpenWindowValues(windowAppearance.isResizable()));
                    windowOpen.append(", status=");
                    windowOpen.append(R01MLinkUtils.getOpenWindowValues(windowAppearance.isStateBar()));
                    windowOpen.append(", toolbar=");
                    windowOpen.append(R01MLinkUtils.getOpenWindowValues(windowAppearance.isToolBar()));
                    windowOpen.append(", location=");
                    windowOpen.append(R01MLinkUtils.getOpenWindowValues(windowAppearance.isLocationBar()));
                    windowOpen.append(", scrollbars=");
                    windowOpen.append(R01MLinkUtils.getOpenWindowValues(windowAppearance.isScrollBar()));
                    windowOpen.append(" , titlebar=yes, directories=yes');return false;\"");
                } else {
                    windowOpen.append(");return false;\"");
                }
            }
        }
        StringBuffer jsEvents = new StringBuffer();
        jsEvents.append(" ");
        if (linkComposer != null && linkComposer.getJs() != null && !linkComposer.getJs().isEmpty()) {
            for (Map.Entry ent : linkComposer.getJs().entrySet()) {
                jsEvents.append(ent.getKey());
                jsEvents.append("=\"");
                jsEvents.append(StringEscapeUtils.unescapeJavaScript((String)ent.getValue().toString()));
                if ("ONCLICK".equals(ent.getKey().toString().toUpperCase())) {
                    jsEvents.append(" ");
                    if (windowOpen.length() > 0) {
                        jsEvents.append(windowOpen.substring(0, windowOpen.length() - 1));
                    }
                }
                jsEvents.append("\" ");
            }
        } else if (!StringUtils.isEmptyString((String)windowOpen.toString())) {
            jsEvents.append("onclick=\"");
            jsEvents.append(windowOpen);
        }
        html.append(StringEscapeUtils.unescapeJavaScript((String)jsEvents.toString()));
        html.append(" ");
        html.append(target);
        if (!StringUtils.isEmptyString((String)linkComposer.getFirstLinkItem().getAccesskey())) {
            html.append(" accesskey=\"" + linkComposer.getFirstLinkItem().getAccesskey() + "\"");
        }
        html.append(">");
        if (link.getText() != null && !"".equals(link.getText())) {
            html.append(link.getText());
        }
        if (linkComposer.getType() == 6 && link != null && link.getData() != null && link.getData().containsKey("attachmentSizeAndExtension") && link.getData().containsKey("useAttachmentSizeAndExtension") && link.getData().get("useAttachmentSizeAndExtension").toString().equals("1")) {
            html.append(" ");
            html.append(link.getData().get("attachmentSizeAndExtension"));
        }
        if (linkComposer.getWindowAppareance().isOpenWindowIcon()) {
            html.append("<span class=\"new-window-icon\"><img src=\"/AVComun/images/r01new-window.png\" /></span>");
        }
        html.append("</a>");
        return html.toString();
    }

    public static String composeURL(R01MLink linkComposer) {
        return R01MLinkUtils.composeURL(linkComposer, 0);
    }

    public static String composeURL(R01MLink linkComposer, int pos) {
        String url = "";
        String pageUrl = "";
        boolean pageUrlFriendly = false;
        R01MLinkItem link = null;
        if (linkComposer != null) {
            if (linkComposer.getLink(pos) != null) {
                link = linkComposer.getFirstLinkItem() == null ? linkComposer.getFirstLinkItem() : new R01MLinkItem();
            }
        } else {
            link = new R01MLinkItem();
        }
        if (linkComposer != null && linkComposer.isUrlFriendly()) {
            if (linkComposer.getPresentationPage() != null && !StringUtils.isEmptyString((String)linkComposer.getPresentationPage().getPortal())) {
                if (linkComposer.getData().containsKey("pageUrlFriendly") && !StringUtils.isEmptyString((String)((String)linkComposer.getData().get("pageUrlFriendly")))) {
                    pageUrl = pageUrl + linkComposer.getData().get("pageUrlFriendly");
                    pageUrlFriendly = true;
                } else {
                    pageUrl = pageUrl + "/" + linkComposer.getPresentationPage().getPortal() + "-" + linkComposer.getPresentationPage().getPageInternalName();
                    pageUrl = pageUrl + "/" + linkComposer.getPresentationPage().getLang();
                }
            }
            if (3 == linkComposer.getType()) {
                if (link.getUrl().indexOf("r01kQry=") == -1) {
                    pageUrl = pageUrl + "r01kQry=";
                }
                if (link.getUrl().indexOf("?") == -1) {
                    pageUrl = "?" + pageUrl;
                }
            }
            if (link.getUrl() != null && !"".equals(link.getUrl())) {
                if (pageUrlFriendly) {
                    url = 3 == linkComposer.getType() ? url + pageUrl + link.getUrl() : url + pageUrl + "/-/" + link.getUrl();
                } else if (link.getData().containsKey("urlFriendly") && !StringUtils.isEmptyString((String)((String)link.getData().get("urlFriendly")))) {
                    url = url + "/" + link.getUrl() + "/" + pageUrl;
                } else {
                    if (!StringUtils.isEmptyString((String)pageUrl)) {
                        url = url + pageUrl;
                    }
                    url = url + link.getUrl();
                }
            } else {
                url = "#";
            }
        } else {
            if (linkComposer != null && linkComposer.getPresentationPage() != null && !StringUtils.isEmptyString((String)linkComposer.getPresentationPage().getPortal())) {
                url = url + "/" + linkComposer.getPresentationPage().getPortal() + "-" + linkComposer.getPresentationPage().getPageInternalName();
                url = url + "/" + linkComposer.getPresentationPage().getLang();
            }
            if (linkComposer != null && 3 == linkComposer.getType()) {
                if (link.getUrl().indexOf("?") == -1) {
                    url = url + "?";
                }
                if (link.getUrl().indexOf("r01kQry=") == -1) {
                    url = url + "r01kQry=";
                }
            }
            url = link.getUrl() != null && !"".equals(link.getUrl()) ? url + link.getUrl() : "#";
        }
        return url.replaceAll("//", "/");
    }

    public static void setLinksURL(R01MLink linkComposer) {
        String url = "";
        String pageUrl = "";
        boolean pageUrlFriendly = false;
        if (linkComposer != null && linkComposer.getLinkItems() != null && !linkComposer.getLinkItems().isEmpty()) {
            for (int i = 0; i < linkComposer.getLinkItems().size(); ++i) {
                R01MLinkItem link = linkComposer.getLink(i);
                if (linkComposer.isUrlFriendly()) {
                    if (linkComposer.getPresentationPage() != null && !StringUtils.isEmptyString((String)linkComposer.getPresentationPage().getPortal())) {
                        if (linkComposer.getData().containsKey("pageUrlFriendly") && !StringUtils.isEmptyString((String)((String)linkComposer.getData().get("pageUrlFriendly")))) {
                            pageUrl = pageUrl + linkComposer.getData().get("pageUrlFriendly");
                            pageUrlFriendly = true;
                        } else {
                            pageUrl = pageUrl + "/" + linkComposer.getPresentationPage().getPortal() + "-" + linkComposer.getPresentationPage().getPageInternalName();
                            pageUrl = pageUrl + "/" + linkComposer.getPresentationPage().getLang();
                        }
                    }
                    if (3 == linkComposer.getType()) {
                        if (link.getUrl().indexOf("r01kQry=") == -1) {
                            pageUrl = pageUrl + "r01kQry=";
                        }
                        if (link.getUrl().indexOf("?") == -1) {
                            pageUrl = "?" + pageUrl;
                        }
                    }
                    if (linkComposer.getType() == 1) {
                        url = pageUrl;
                    } else if (link.getUrl() != null && !"".equals(link.getUrl())) {
                        if (pageUrlFriendly) {
                            url = 3 == linkComposer.getType() ? url + pageUrl + linkComposer.getData().get("query") : (link.getData().containsKey("urlFriendly") && link.getData().get("urlFriendly") != null && !StringUtils.isEmptyString((String)link.getData().get("urlFriendly").toString()) ? url + pageUrl + "/-" + link.getData().get("urlFriendly") : url + pageUrl + "/-" + link.getData().get("url"));
                        } else if (link.getData().containsKey("urlFriendly") && !StringUtils.isEmptyString((String)((String)link.getData().get("urlFriendly")))) {
                            url = link.getData().get("urlFriendly").toString();
                            if (link.getData().get("urlFriendly").toString().endsWith("/")) {
                                url = url.substring(0, url.length() - 1);
                            }
                            if (!pageUrl.startsWith("/")) {
                                url = url + "/";
                            }
                            url = url + pageUrl;
                        } else {
                            if (!StringUtils.isEmptyString((String)pageUrl)) {
                                url = url + pageUrl;
                            }
                            url = 3 == linkComposer.getType() ? url + linkComposer.getData().get("query") : url + link.getData().get("url");
                        }
                    } else {
                        url = "#";
                    }
                } else {
                    if (linkComposer.getPresentationPage() != null && !StringUtils.isEmptyString((String)linkComposer.getPresentationPage().getPortal())) {
                        url = url + "/" + linkComposer.getPresentationPage().getPortal() + "-" + linkComposer.getPresentationPage().getPageInternalName();
                        url = url + "/" + linkComposer.getPresentationPage().getLang();
                    }
                    if (linkComposer != null && 3 == linkComposer.getType()) {
                        if (link.getUrl().indexOf("?") == -1) {
                            url = url + "?";
                        }
                        if (link.getUrl().indexOf("r01kQry=") == -1) {
                            url = url + "r01kQry=";
                        }
                    }
                    url = link.getUrl() != null && !"".equals(link.getUrl()) ? url + link.getUrl() : "#";
                }
                linkComposer.getLink(i).setUrl(url);
            }
        }
    }

    public static String[] getLinksDocumentOid(R01MLink linkComposer) {
        String[] documentOids = null;
        if (linkComposer.getLinkItems() != null && !linkComposer.getLinkItems().isEmpty()) {
            documentOids = new String[linkComposer.getLinkItems().size()];
            for (int i = 0; i < linkComposer.getLinkItems().size(); ++i) {
                if (linkComposer.getLinkItems().get(i).getData().containsKey("documentOid")) {
                    documentOids[i] = (String)linkComposer.getLinkItems().get(i).getData().get("documentOid");
                }
                if (!linkComposer.getLinkItems().get(i).getData().containsKey("pageOid")) continue;
                documentOids[i] = (String)linkComposer.getLinkItems().get(i).getData().get("pageOid");
            }
        }
        return documentOids;
    }

    public static void deleteLinksInArray(String[] documentOids, R01MLink linkComposer) {
        if (documentOids != null && documentOids.length > 0) {
            block0: for (int i = 0; i < documentOids.length; ++i) {
                String documentOid = "";
                if (linkComposer.getLinkItems() == null || linkComposer.getLinkItems().isEmpty()) continue;
                for (int j = 0; j < linkComposer.getLinkItems().size(); ++j) {
                    R01MLinkItem link = linkComposer.getLink(j);
                    if (link.getData().containsKey("documentOid")) {
                        documentOid = (String)link.getData().get("documentOid");
                    }
                    if (link.getData().containsKey("pageOid")) {
                        documentOid = (String)link.getData().get("pageOid");
                    }
                    if (!documentOid.equals(documentOids[i])) continue;
                    linkComposer.getLinkItems().remove(link);
                    continue block0;
                }
            }
        }
        if (linkComposer.getLinkItems() == null || linkComposer.getLinkItems().isEmpty()) {
            linkComposer.getLinkItems().add(new R01MLinkItem());
        }
    }

    public static void deleteLinks(String[] documentOids, R01MLink linkComposer) {
        if (documentOids != null && documentOids.length > 0) {
            ArrayList<R01MLinkItem> links = new ArrayList<R01MLinkItem>();
            block0: for (int i = 0; i < documentOids.length; ++i) {
                String documentOid = "";
                if (linkComposer.getLinkItems() == null || linkComposer.getLinkItems().isEmpty()) continue;
                for (int j = 0; j < linkComposer.getLinkItems().size(); ++j) {
                    R01MLinkItem link = linkComposer.getLink(j);
                    if (link.getData().containsKey("documentOid")) {
                        documentOid = (String)link.getData().get("documentOid");
                    }
                    if (link.getData().containsKey("pageOid")) {
                        documentOid = (String)link.getData().get("pageOid");
                    }
                    if (!documentOid.equals(documentOids[i])) continue;
                    links.add(link);
                    continue block0;
                }
            }
            linkComposer.setLinks(links);
        }
        if (linkComposer.getLinkItems() == null || linkComposer.getLinkItems().isEmpty()) {
            linkComposer.getLinkItems().add(new R01MLinkItem());
        }
    }

    public static String getFileExtension(String url) {
        String extension = "";
        extension = url.substring(url.lastIndexOf(".") + 1, url.length());
        if ("pdf".equals(extension = extension.toLowerCase()) || "html".equals(extension) || "doc".equals(extension) || "xls".equals(extension) || "zip".equals(extension)) {
            return extension;
        }
        if ("rar".equals(extension)) {
            return "zip";
        }
        return "html";
    }

    public static String filtrarHTML(String cadena) {
        return cadena;
    }

    public static String filtrarEspaciosHTML(String cadena) {
        String resp = "";
        if (cadena != null && cadena.length() > 0) {
            resp = cadena;
            resp = StringUtils.replaceString((String)resp, (String)" ", (String)"&nbsp;");
        }
        return resp;
    }

    private static R01MQueryObject getQueryObject(R01MLink linkComposer) {
        R01MQueryObject queryObject = null;
        if (linkComposer.getData() != null && !linkComposer.getData().isEmpty() && linkComposer.getData().containsKey("query")) {
            String queryUrl = (String)linkComposer.getData().get("query");
            queryUrl = URLDecoder.decode((String)queryUrl, (String)"UTF-8");
            queryObject = R01MSearchEngineUtils.decodeURLInQueryObject(queryUrl);
        }
        return queryObject;
    }

    private static String encodeXMLEntities(String xml) {
        StringBuffer xmlResp = new StringBuffer();
        for (int i = 0; i < xml.length(); ++i) {
            if (xml.charAt(i) == '&') {
                xmlResp.append("&amp;");
                continue;
            }
            xmlResp.append(xml.charAt(i));
        }
        return xmlResp.toString();
    }

    private static String getUrlProtocol(String url) {
        String protocol = null;
        String external_url_regexp = "(([A-Za-z]+:[\\/]+)|([mailto:|javascript:]+))*(.*)";
        Pattern p = null;
        Matcher m = null;
        p = Pattern.compile(external_url_regexp);
        m = p.matcher(url);
        if (m.matches() && m.groupCount() == 4) {
            protocol = m.group(1);
        }
        return protocol;
    }

    public static String composeExtranetHtml(R01MLink link) {
        StringBuffer linkHtml = new StringBuffer();
        String url = "";
        if (link.isSamePage()) {
            url = link.getFirstLinkItem().getUrl();
            String urlTemp = url.replaceFirst("/" + R01MConstants.SSI_PORTAL + "-" + R01MConstants.SSI_PAGE + "/" + link.getPresentationPage().getLang(), "/" + R01MConstants.PREV_PAGE);
            link.getFirstLinkItem().setUrl(urlTemp);
        }
        if (link.getType() == 6 || link.getType() == 5) {
            boolean newWindow = link.getWindowAppareance().isNewWindow();
            link.getWindowAppareance().setNewWindow(true);
            linkHtml.append("<div>");
            linkHtml.append(R01MLinkUtils.composeHTML(link));
            linkHtml.append("</div>");
            link.getWindowAppareance().setNewWindow(newWindow);
        } else {
            String extension = R01MLinkUtils.getFileExtension(link.getLink(0).getUrl());
            if (StringUtils.isEmptyString((String)extension)) {
                extension = "html";
            }
            if (link.getType() == 2) {
                extension = "content";
            } else if (link.getType() == 3) {
                extension = "search";
            }
            linkHtml = R01MLinkUtils.composeExtranetHtmlUsingUrlExtension(link, extension);
        }
        if (!StringUtils.isEmptyString((String)url)) {
            link.getFirstLinkItem().setUrl(url);
        }
        return linkHtml.toString();
    }

    public static StringBuffer composeExtranetHtmlUsingUrlExtension(R01MLink link, String extension) {
        StringBuffer linkHtml = new StringBuffer();
        linkHtml.append("<div class=\"r01LinkAttach r01LinkAttach_" + extension + "\">");
        if (link.getType() == 8 && link.getLink(0).getUrl().startsWith("#")) {
            linkHtml.append(R01MLinkUtils.composeHTML(link));
        } else {
            boolean newWindow = link.getWindowAppareance().isNewWindow();
            link.getWindowAppareance().setNewWindow(true);
            boolean needPage = false;
            String url = link.getFirstLinkItem().getUrl();
            String tmpUrl = "";
            if ((link.getType() == 2 || link.getType() == 3) && link.getPresentationPage() != null && StringUtils.isEmptyString((String)link.getPresentationPage().getPortal())) {
                needPage = true;
            }
            if (needPage && link.getType() == 2) {
                tmpUrl = url;
                tmpUrl = link.getFirstLinkItem().getData() != null && !link.getFirstLinkItem().getData().isEmpty() && link.getFirstLinkItem().getData().containsKey("urlFriendly") ? (tmpUrl.endsWith("/") ? tmpUrl + R01MConstants.PREV_PAGE : tmpUrl + "/" + R01MConstants.PREV_PAGE) : "/" + R01MConstants.PREV_PAGE + tmpUrl;
            }
            if (needPage && link.getType() == 3) {
                tmpUrl = "/" + R01MConstants.PREV_PAGE + url;
            }
            if (needPage) {
                link.getFirstLinkItem().setUrl(tmpUrl);
            }
            linkHtml.append(R01MLinkUtils.composeHTML(link));
            if (needPage) {
                link.getFirstLinkItem().setUrl(url);
            }
            link.getWindowAppareance().setNewWindow(newWindow);
        }
        linkHtml.append("</div>");
        return linkHtml;
    }

    public static StringBuffer composeExtranetHtmlUsingUrlExtension(R01MLink link, int pos) {
        StringBuffer linkHtml = new StringBuffer();
        linkHtml.append("<div class=\"r01LinkAttach r01LinkAttach_content\">");
        boolean newWindow = link.getWindowAppareance().isNewWindow();
        link.getWindowAppareance().setNewWindow(true);
        linkHtml.append(R01MLinkUtils.composeHTML(link, pos));
        link.getWindowAppareance().setNewWindow(newWindow);
        linkHtml.append("</div>");
        return linkHtml;
    }

    public static String composeNewsPaperHtml(R01MLink linkComposer) {
        return R01MLinkUtils.composeExtranetHtml(linkComposer);
    }

    public static String composeAttachmentHTML(R01MLink linkComposer) {
        return R01MLinkUtils.composeAttachmentHTML(linkComposer, 0);
    }

    public static String composeAttachmentHTML(R01MLink linkComposer, int pos) {
        StringBuffer capa = new StringBuffer();
        boolean newWindow = linkComposer.getWindowAppareance().isNewWindow();
        linkComposer.getWindowAppareance().setNewWindow(true);
        capa.append(R01MLinkUtils.composeHTML(linkComposer, pos));
        linkComposer.getWindowAppareance().setNewWindow(newWindow);
        return capa.toString();
    }

    public static String formatLinkHTML(String html, String extension) {
        StringBuffer capa = new StringBuffer();
        capa.append("<div class=\"r01gClsDataGridItem\"><div class=\"r01gCLItemDocLink r01gCLItemTypo_" + extension + "\">");
        capa.append(html);
        capa.append("</div></div>");
        return capa.toString();
    }

    public static void composeHtmlLinks(R01MLink linkComposer) {
        if (linkComposer != null && !linkComposer.getLinkItems().isEmpty() && linkComposer.getFirstLinkItem() != null) {
            if (linkComposer.getType() == 4) {
                for (int i = 0; i < linkComposer.getLinkItems().size(); ++i) {
                    linkComposer.getLink(i).getData().put("resourceHTML", R01MLinkUtils.composeExtranetHtmlUsingUrlExtension(linkComposer, i));
                }
            } else if (!linkComposer.getFirstLinkItem().getData().containsKey("resourceHTML") || StringUtils.isEmptyString((String)((String)linkComposer.getFirstLinkItem().getData().get("resourceHTML")))) {
                linkComposer.getFirstLinkItem().getData().put("resourceHTML", R01MLinkUtils.composeExtranetHtml(linkComposer));
            }
        }
    }

    public static String composePageHTML(R01MLink linkComposer) {
        StringBuffer capa = new StringBuffer();
        capa.append("<div class=\"r01gClsDataGridItem\"><div class=\"r01gCLItemDocLink r01gCLItemTypo_" + R01MLinkUtils.getFileExtension(linkComposer.getFirstLinkItem().getUrl()) + "\">");
        boolean newWindow = linkComposer.getWindowAppareance().isNewWindow();
        linkComposer.getWindowAppareance().setNewWindow(true);
        capa.append(R01MLinkUtils.composeHTML(linkComposer));
        linkComposer.getWindowAppareance().setNewWindow(newWindow);
        capa.append("</div></div>");
        return capa.toString();
    }

    private static String getOpenWindowValues(boolean value) {
        if (value) {
            return "yes";
        }
        return "no";
    }

    public static List contentListLinkToContentLinksList(R01MLink link) {
        ArrayList<R01MLink> links = new ArrayList<R01MLink>();
        if (link.getType() == 4) {
            if (link.getLinkItems() != null && !link.getLinkItems().isEmpty()) {
                if (link.getLinkItems().size() == 1) {
                    link.setType(2);
                    links.add(link);
                } else {
                    for (int i = 0; i < link.getLinkItems().size(); ++i) {
                        R01MLink newLink = new R01MLink();
                        if (!link.getLink(i).getData().containsKey("contentOid") || !link.getLink(i).getData().containsKey("documentOid")) continue;
                        newLink.setData(link.getData());
                        newLink.setPresentationPage(link.getPresentationPage());
                        newLink.setWindowAppareance(link.getWindowAppareance());
                        newLink.setJs(link.getJs());
                        newLink.setType(2);
                        newLink.getLinkItems().add(link.getLink(i));
                        links.add(newLink);
                    }
                }
            }
        } else {
            links.add(link);
        }
        return links;
    }

    public static String getLinkUrlWithPage(String portal, String page, String lang, R01MLink link) {
        String url = "";
        if (link.getFirstLinkItem() != null && !StringUtils.isEmptyString((String)link.getFirstLinkItem().getUrl())) {
            url = link.getFirstLinkItem().getUrl();
            String slash = "";
            if (!url.startsWith("/")) {
                slash = "/";
            }
            if (link.getFirstLinkItem().getData() != null && !link.getFirstLinkItem().getData().isEmpty() && link.getFirstLinkItem().getData().containsKey("urlFriendly") && link.getFirstLinkItem().getData().get("urlFriendly").equals(link.getFirstLinkItem().getUrl())) {
                url = slash + url;
                if (!url.endsWith("/")) {
                    url = url + "/";
                }
                url = url + portal + "-" + page + "/" + lang + "/";
            } else {
                url = "/" + portal + "-" + page + "/" + lang + slash + url;
            }
        }
        return url;
    }
}

