/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.utils.link;

import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.objects.link.R01MLink;
import com.ejie.r01m.objects.link.R01MLinkItem;
import com.ejie.r01m.objects.link.R01MPresentationPage;
import com.ejie.r01m.objects.link.R01MWindowAppearance;
import com.ejie.r01m.objects.urlreference.R01MUrlReference;
import com.ejie.r01m.objects.urlreference.R01MUrlReferencePresentationPage;
import com.ejie.r01m.objects.urlreference.R01MUrlReferenceWindowAppearance;
import com.ejie.r01m.objects.urlreference.R01MUrlResult;
import com.ejie.r01m.utils.R01MConstantsUrlReferenceConfig;
import com.ejie.r01m.utils.searchengine.R01MSearchResultsFormatterConstants;
import com.ejie.r01m.utils.urlreferencer.R01MUrlReferenceUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class R01MLinkToUrlReferencerUtils {
    public static R01MUrlReference create(R01MLink linkComposer) {
        R01MUrlReference urlReference = new R01MUrlReference();
        if (linkComposer != null) {
            urlReference.setRefUrlType(R01MLinkToUrlReferencerUtils.getType(linkComposer.getType()));
            urlReference.setRefTextAlt(linkComposer.getFirstLinkItem().getTitle());
            urlReference.setRefResults(R01MLinkToUrlReferencerUtils.createUrlResults(linkComposer));
            urlReference.setRefWindowAppearance(R01MLinkToUrlReferencerUtils.createWindowAppearance(linkComposer.getWindowAppareance()));
            urlReference.setPageObject(R01MLinkToUrlReferencerUtils.createPresentationPage(linkComposer.getPresentationPage()));
            if (linkComposer.getData().containsKey("pageUrlFriendly")) {
                urlReference.getPageObject().setIsAliasUrlPage("on");
            } else {
                urlReference.getPageObject().setIsAliasUrlPage("off");
            }
            R01MLinkToUrlReferencerUtils.createJs(linkComposer.getJs(), urlReference.getJsEvents());
            urlReference.getRefResult(0).setRefUrlHTML(R01MUrlReferenceUtils.getHtml(urlReference).toString());
        }
        return urlReference;
    }

    public static List createUrlResults(R01MLink linkComposer) {
        List<R01MLinkItem> links = linkComposer.getLinkItems();
        ArrayList<R01MUrlResult> urlResults = new ArrayList<R01MUrlResult>();
        if (links != null && !links.isEmpty()) {
            for (int i = 0; i < links.size(); ++i) {
                R01MLinkItem link = links.get(i);
                R01MUrlResult urlResult = new R01MUrlResult();
                if (!StringUtils.isEmptyString((String)link.getText())) {
                    urlResult.setRefText(link.getText());
                }
                if (!StringUtils.isEmptyString((String)link.getUrl())) {
                    urlResult.setRefUrl(link.getUrl());
                }
                HashMap resultDetail = new HashMap();
                if (link.getData() != null && !link.getData().isEmpty()) {
                    if (link.getData().containsKey("contentOid")) {
                        resultDetail.put("contentOid", link.getData().get("contentOid"));
                    }
                    if (link.getData().containsKey("documentOid")) {
                        resultDetail.put("documentOid", link.getData().get("documentOid"));
                    }
                    if (link.getData().containsKey("pageOid")) {
                        resultDetail.put("documentOid", link.getData().get("pageOid"));
                    }
                    if (link.getData().containsKey("documentName")) {
                        resultDetail.put("documentName", link.getData().get("documentName"));
                    }
                    if (link.getData().containsKey("url")) {
                        String url = link.getData().get("url").toString();
                        if (url.startsWith("/contenidos/")) {
                            url = url.substring(url.indexOf("/contenidos/"), url.length());
                        }
                        resultDetail.put(R01MSearchResultsFormatterConstants.DOCUMENT_VIEW_URL, url);
                    }
                    if (link.getData().containsKey("url")) {
                        resultDetail.put(R01MSearchResultsFormatterConstants.NORMAL_URL, link.getData().get("url"));
                    }
                    if (link.getData().containsKey("urlFriendly")) {
                        resultDetail.put(R01MSearchResultsFormatterConstants.DOCUMENT_ALIAS_VIEW_URL, link.getData().get("urlFriendly"));
                    }
                    if (link.getData().containsKey("documentPublishRepository")) {
                        resultDetail.put(R01MSearchResultsFormatterConstants.DOCUMENT_PUBLISH_REPOSITORY, link.getData().get("documentPublishRepository"));
                    }
                    if (link.getData().containsKey("contentTypology")) {
                        resultDetail.put(R01MSearchResultsFormatterConstants.CONTENT_TYPOLOGY, link.getData().get("contentTypology"));
                    }
                }
                if (linkComposer.isUrlFriendly()) {
                    resultDetail.put(R01MSearchResultsFormatterConstants.DOCUMENT_VIEW_URL_INFO, "1");
                } else {
                    resultDetail.put(R01MSearchResultsFormatterConstants.DOCUMENT_VIEW_URL_INFO, "0");
                }
                if (linkComposer.getType() == 5) {
                    resultDetail.putAll(R01MUrlReferenceUtils.composeNewsletterResultDetail(link.getUrl()));
                }
                if (linkComposer.getData() != null && !linkComposer.getData().isEmpty() && linkComposer.getData().containsKey("queryXml")) {
                    resultDetail.put(R01MConstantsUrlReferenceConfig.QUERY_XML, linkComposer.getData().get("queryXml"));
                }
                urlResult.setResultDetail(resultDetail);
                urlResults.add(urlResult);
            }
        }
        return urlResults;
    }

    public static R01MUrlReferenceWindowAppearance createWindowAppearance(R01MWindowAppearance winAppOld) {
        R01MUrlReferenceWindowAppearance winApp = new R01MUrlReferenceWindowAppearance();
        if (winAppOld != null) {
            winApp.setRefWindowHeight(winAppOld.getHeight() + "");
            winApp.setRefWindowWidth(winAppOld.getWidth() + "");
            winApp.setRefWindowX(winAppOld.getX() + "");
            winApp.setRefWindowY(winAppOld.getY() + "");
            winApp.setRefNewWindow(winAppOld.isNewWindow() + "");
            winApp.setRefWindowTarget(winAppOld.getWindowName());
        }
        return winApp;
    }

    public static void createJs(Map jsOld, Map js) {
        if (jsOld != null && !jsOld.isEmpty()) {
            for (Map.Entry me : jsOld.entrySet()) {
                if (StringUtils.isEmptyString((String)me.getValue().toString())) continue;
                js.put(me.getKey(), me.getValue());
            }
        }
    }

    public static R01MUrlReferencePresentationPage createPresentationPage(R01MPresentationPage pageOld) {
        R01MUrlReferencePresentationPage page = new R01MUrlReferencePresentationPage();
        if (pageOld != null) {
            if (!StringUtils.isEmptyString((String)pageOld.getPageOid())) {
                page.setPageId(pageOld.getPageOid());
            }
            if (!StringUtils.isEmptyString((String)pageOld.getPageInternalName())) {
                page.setPageOid(pageOld.getPageInternalName());
                page.setPageName(pageOld.getPageInternalName());
            }
            if (!StringUtils.isEmptyString((String)pageOld.getLang())) {
                page.setLanguagePage(pageOld.getLang());
            }
            if (!StringUtils.isEmptyString((String)pageOld.getPortal())) {
                page.setPortalGUID(pageOld.getPortal());
            }
        }
        return page;
    }

    public static int getType(int type) {
        switch (type) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 7;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 0;
            }
        }
        return -1;
    }
}

