/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.utils.jms;

import com.ejie.r01f.file.FileUtils;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.config.objects.cataloguing.R01MChangesLabelOperation;
import com.ejie.r01m.config.objects.cataloguing.R01MChangesLabelsOperationsGroup;
import com.ejie.r01m.config.objects.cataloguing.R01MChangesLabelsOperationsList;
import com.ejie.r01m.config.objects.cataloguing.R01MChangesLabelsResponse;
import com.ejie.r01m.exceptions.R01MCatalogException;
import com.ejie.r01m.exceptions.R01MJMSException;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MDateUtils;
import com.ejie.r01m.utils.jms.R01MJmsQueueParam;
import com.ejie.r01m.utils.jms.R01MMessageCallBackBean;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import weblogic.jms.extensions.WLMessageProducer;

public abstract class R01MJMSUtils {
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01m.jmsNotifier").intValue() != Level.OFF.intValue();
    public static final String RESPONSE_PACKET = "packet";
    public static final String RESPONSE_OPERATION = "operation";
    private static final long MSG_EXPIRATION_TIME = Long.parseLong(XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"canalesyserviciosJMSConfig/msgExpirationTimeInMilliseconds", (String)"1200000"));
    public static int MSG_AGGREGATOR_RUN_ITEM_TYPE = 0;
    public static int MSG_AGGREGATOR_ITEM_REPONSE_TYPE = 1;
    public static int MSG_AGGREGATOR_CHECK_TIMEOUT_TYPE = 2;
    public static String MSG_AGGREGATOR_ARRAY_SEP = "##R01_AGGREGATOR_PARAM_SEP##";
    public static final String MSG_TYPE_RESPONSE = "r01ResponseMsg";
    public static final String MSG_TYPE_CACHE_RELOAD = "reloadConfigCache";
    public static final String MSG_TYPE_IMPORTCONTENTS = "r01ImportContents";
    public static final String MSG_TYPE_IMPORTCONTENTFROMFILE = "r01ImportContentFromFile";
    public static final String MSG_TYPE_ZIPCONTENT = "r01ZipContent";
    public static final String MSG_TYPE_ZIPQUERY = "r01ZipQuery";
    public static final String MSG_TYPE_INDEXOBJECT = "r01IndexObject";
    public static final String MSG_TYPE_UNINDEXOBJECT = "r01UnIndexObject";
    public static final String MSG_TYPE_PROCCESSINDEXFINISHED = "r01ProccessIndexFinished";
    public static final String MSG_TYPE_PROCCESSPUBLISHFINISHED = "r01ProccessPublishFinished";
    public static final String MSG_TYPE_PUBLISHOBJECT = "r01PublishObject";
    public static final String MSG_TYPE_UPLOAD_FILE_ASYNC = "r01UploadFileAsync";
    public static final String MSG_TYPE_DOWNLOAD_FILE_ASYNC = "r01DownloadFileAsync";
    public static final String MSG_TYPE_LINKED_RELATIONS = "r01LinkedRelations";
    public static final String MSG_TYPE_UPDATE_ALIAS_STRUCTURE = "r01UpdateAlias";
    public static final String MSG_TYPE_AGGREGATOR = "r01CustomAggregator";
    public static final String MSG_TYPE_CONTENT_HISTORY = "r01ContentHistory";
    public static final String MSG_TYPE_REGENERATE_PORTAL = "r01RegeneratorPortal";
    public static final String MSG_TYPE_REGENERATE_VA = "r01RegeneratorVA";
    public static final String MSG_TYPE_PUBLISH_VA = "r01PublishVA";
    public static final String MSG_TYPE_IMPORTATTACHMENTS = "r01ImportAttachments";
    public static final String MSG_TYPE_GENERATEDATAFILES = "r01GenerateDatafiles";
    public static final String MSG_TYPE_RESET_PORTAL_TEMPLATES = "r01PortalTemplatesCache";
    public static final String MSG_TYPE_AGGREGATOR_RESPONSES_PATTERN = "r01CustomAggregatorResponses";
    public static final String MSG_TYPE_AGGREGATOR_EXECUTOR_PATTERN = "r01CustomAggregatorExecutor";
    public static final String MSG_TYPE_TAG_HTML = "r01TagHtml";
    public static final String MSG_TYPE_SAVE_DOCUMENT_RENDER = "r01SaveDocumentRender";
    public static final String MSG_TYPE_GEOCATALOG_RENDER = "r01GeoCatalogRender";
    public static final String MSG_TYPE_GALLERY_RENDER = "r01GalleryRender";
    public static final String RELOAD_ALL_CONFIG = "allAdminConfig";
    public static final String RELOAD_ENTITIES_CONFIG = "entitiesConfig";
    public static final String RELOAD_LINKED_RELATIONS_CONFIG = "linkedRelationsConfig";
    public static final String RELOAD_RESOURCESCONTAINER_CONFIG = "resourcesContainerConfig";
    public static final String RELOAD_STORAGE_CONFIG = "storageConfig";
    public static final String RELOAD_TYPOLOGY_CONFIG = "typologyConfig";
    public static final String RELOAD_TYPOLOGYMANAGEMENT_CONFIG = "typologyManagementConfig";
    public static final String RELOAD_SEARCHMETADATASTORAGE_CONFIG = "searchMetaDataStorageConfig";
    public static final String RELOAD_MISCELLANEOUS_CONFIG = "miscellaneousConfig";
    public static final String RELOAD_CATALOG_CONFIG = "allCatalogConfig";
    public static final String RELOAD_PORTAL_CONFIG = "allPortalConfig";
    public static final String RELOAD_SEARCH_ENGINE_CONFIG = "searchEngineConfig";
    public static final int MSG_TYPE_RESPONSE_OK = 0;
    public static final int MSG_TYPE_RESPONSE_ERROR = 1;
    public static final String MSG_TYPE_RESPONSE_SOURCE_TYPE = "jmsSourceType";
    public static final String MSG_TYPE_RESPONSE_STATE = "jmsResponseState";
    public static final String MSG_TYPE_RESPONSE_MSGDESC = "msgResponse";
    public static final String MSG_TYPE_RESPONSE_PARAMS = "msgResponseParams";
    public static final String MSG_TYPE_RESPONSE_PARAMS_SEPARATOR = ";";
    public static final String MSG_RETRYNUMS = "retryNums";
    public static final int RETRYNUMS = Integer.parseInt(XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"canalesyserviciosJMSConfig/retryNums", (String)"0"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendResponseToCatalog(R01MChangesLabelsResponse response, String responseType) {
        Queue queue;
        QueueConnectionFactory queueConnectionFactory;
        String queueName = XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"recatalogConfig/recatalogPacketResponse", (String)"r01e.r01eJMSQueue");
        try {
            InitialContext jndiContext = new InitialContext();
            queueConnectionFactory = (QueueConnectionFactory)jndiContext.lookup(XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"recatalogConfig/recatalogStructureConnectionFactory", (String)"r01.r01JMSConnectionFactory"));
            queue = (Queue)jndiContext.lookup(queueName);
        }
        catch (NamingException namExc) {
            R01FLog.to((String)"r01m.jmsNotifier").severe(">>> (sendResponseToCatalog) >>> Error obteniendo la factor\u00eda JMS de Recatalogaci\u00f3n. Error:" + namExc.getMessage());
            return;
        }
        QueueConnection queueConnection = null;
        QueueSession queueSession = null;
        QueueSender sender = null;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01m.jmsNotifier").info(">>> (sendResponseToCatalog) >>> Abrir una conexi\u00f3n JMS.");
            }
            queueConnection = queueConnectionFactory.createQueueConnection();
            queueSession = queueConnection.createQueueSession(false, 1);
            sender = queueSession.createSender(queue);
            ObjectMessage message = queueSession.createObjectMessage((Serializable)response);
            message.setJMSType(responseType);
            if (DEBUG) {
                R01FLog.to((String)"r01m.jmsNotifier").info(">>> (sendResponseToCatalog) >>> Enviando el mensaje de respuesta a la cola de recepci\u00f3n de respuestas del Gestor de Ejes");
            }
            sender.send((Message)message);
        }
        catch (JMSException jmsExc) {
            R01FLog.to((String)"r01m.jmsNotifier").severe(">>> (sendResponseToCatalog) >>> Error en el env\u00edo del mensaje a la cola de respuesta de recatalogaci\u00f3n. Error:" + jmsExc.getMessage());
        }
        finally {
            if (sender != null) {
                try {
                    sender.close();
                }
                catch (JMSException jmsExc) {
                    R01FLog.to((String)"r01m.jmsNotifier").severe(">>> (sendResponseToCatalog) >>> No se ha podido cerrar la sesi\u00f3n de env\u00edo de la cola de mensajes de respuesta de recatalogaci\u00f3n. Error:" + jmsExc.getMessage());
                }
            }
            if (queueSession != null) {
                try {
                    queueSession.close();
                }
                catch (JMSException jmsExc) {
                    R01FLog.to((String)"r01m.jmsNotifier").severe(">>> (sendResponseToCatalog) >>> No se ha podido cerrar la sesi\u00f3n con la cola de mensajes de respuesta de recatalogaci\u00f3n. Error:" + jmsExc.getMessage());
                }
            }
            if (queueConnection != null) {
                try {
                    queueConnection.close();
                }
                catch (JMSException jmsExc) {
                    R01FLog.to((String)"r01m.jmsNotifier").severe(">>> (sendResponseToCatalog) >>> No se ha podido cerrar la conexi\u00f3n con la cola de mensajes de respuesta de recatalogaci\u00f3n. Error:" + jmsExc.getMessage());
                }
            }
        }
    }

    public static void sendContentOperationError(String packetOid, String objectOid, String errorMsg) {
        R01MJMSUtils._sendError(R01MConstants.CONTENTMANAGER_APPCODE, packetOid, objectOid, errorMsg, RESPONSE_OPERATION);
    }

    public static void sendContentOperationOK(String packetOid, String objectOid) {
        R01MJMSUtils._sendOK(R01MConstants.CONTENTMANAGER_APPCODE, packetOid, objectOid, RESPONSE_OPERATION);
    }

    public static void sendContentPacketError(String packetOid, String errorMsg) {
        R01MJMSUtils._sendError(R01MConstants.CONTENTMANAGER_APPCODE, packetOid, null, errorMsg, RESPONSE_PACKET);
    }

    public static void sendPortalOperationError(String packetOid, String objectOid, String errorMsg) {
        R01MJMSUtils._sendError(R01MConstants.PORTALMANAGER_APPCODE, packetOid, objectOid, errorMsg, RESPONSE_OPERATION);
    }

    public static void sendPortalOperationOK(String packetOid, String objectOid) {
        R01MJMSUtils._sendOK(R01MConstants.PORTALMANAGER_APPCODE, packetOid, objectOid, RESPONSE_OPERATION);
    }

    public static void sendPortalPacketError(String packetOid, String errorMsg) {
        R01MJMSUtils._sendError(R01MConstants.PORTALMANAGER_APPCODE, packetOid, null, errorMsg, RESPONSE_PACKET);
    }

    public static void sendJMSConsumerError(String msgType, Message msg, R01MJMSException jmsExc) {
        try {
            ArrayList<R01MJmsQueueParam> params = new ArrayList<R01MJmsQueueParam>();
            params.add(new R01MJmsQueueParam(1, MSG_TYPE_RESPONSE_SOURCE_TYPE, msgType));
            params.add(new R01MJmsQueueParam(1, MSG_TYPE_RESPONSE_STATE, "1"));
            params.add(new R01MJmsQueueParam(1, MSG_TYPE_RESPONSE_MSGDESC, jmsExc.getDetailedMessage()));
            R01MJMSUtils.sendJMSMessage(MSG_TYPE_RESPONSE, params);
        }
        catch (Exception ex) {
            R01FLog.to((String)"r01m.jmsNotifier").severe("Error al notificar la respuesta de la ejecuci\u00f3n del mensaje. Error:" + ex.getMessage());
        }
    }

    public static void writeSimulateRecatalogLog(String packetOid, String typeLog, String msg) {
        String fileLog = XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"recatalogConfig/logPathFile", (String)"/datos/r01mt/file/recatalog/$[packetOid]$-$[type]$.log");
        Properties vars = new Properties();
        vars.put("packetOid", packetOid);
        vars.put("type", typeLog);
        File effectiveFileLog = new File(StringUtils.replaceVariableValues((String)fileLog, (char)'$', (Map)vars));
        try {
            FileUtils.saveFile((File)effectiveFileLog, (InputStream)new ByteArrayInputStream(msg.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace(System.out);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.out);
        }
    }

    public static R01MChangesLabelsOperationsGroup createGroupOperationsObject(int packetType, List<R01MChangesLabelOperation> contentOpGroups) throws R01MCatalogException {
        if (contentOpGroups == null || contentOpGroups.isEmpty()) {
            return null;
        }
        R01MChangesLabelsOperationsGroup groupOperations = new R01MChangesLabelsOperationsGroup();
        R01MChangesLabelsOperationsList operations = new R01MChangesLabelsOperationsList();
        operations.setOperations(contentOpGroups);
        groupOperations.setObjectOid(contentOpGroups.get(0).getObjectOid());
        try {
            groupOperations.setOperationsGroupXML(XOManager.getXML((String)R01MConstants.STRUCTURESMODEL_MAPFILE, (Object)operations));
        }
        catch (XOMarshallerException xoExc) {
            throw new R01MCatalogException("Error al mapear la lista de operaciones a XML: " + xoExc.getMessage(), (Exception)((Object)xoExc));
        }
        groupOperations.setType(packetType);
        return groupOperations;
    }

    public static Map<String, List<R01MChangesLabelOperation>> createGroups(List<R01MChangesLabelOperation> operations) {
        HashMap<String, List<R01MChangesLabelOperation>> contentOperationsGroup = new HashMap<String, List<R01MChangesLabelOperation>>();
        for (R01MChangesLabelOperation operation : operations) {
            if (contentOperationsGroup.containsKey(operation.getObjectOid())) {
                ((List)contentOperationsGroup.get(operation.getObjectOid())).add(operation);
                continue;
            }
            ArrayList<R01MChangesLabelOperation> contentOperations = new ArrayList<R01MChangesLabelOperation>();
            contentOperations.add(operation);
            contentOperationsGroup.put(operation.getObjectOid(), contentOperations);
        }
        return contentOperationsGroup;
    }

    public static void sendJMSMessage(String msgType, List<R01MJmsQueueParam> params) throws R01MJMSException {
        R01MJMSUtils._sendJMSMessage(msgType, params, null, 0, -1L);
    }

    public static void sendJMSMessage(String msgType, List<R01MJmsQueueParam> params, long timeToDeliver) throws R01MJMSException {
        R01MJMSUtils._sendJMSMessage(msgType, params, null, 0, timeToDeliver);
    }

    public static void sendJMSMessage(String msgType, List<R01MJmsQueueParam> params, int jmsPriority) throws R01MJMSException {
        R01MJMSUtils._sendJMSMessage(msgType, params, null, jmsPriority, -1L);
    }

    public static void sendJMSMessage(String msgType, List<R01MJmsQueueParam> params, int jmsPriority, long timeToDeliver) throws R01MJMSException {
        R01MJMSUtils._sendJMSMessage(msgType, params, null, jmsPriority, timeToDeliver);
    }

    public static void sendJMSMessage(String msgType, Message msg) throws R01MJMSException {
        R01MJMSUtils._sendJMSMessage(msgType, null, msg, 0, -1L);
    }

    public static void sendJMSMessage(String msgType, Message msg, long timeToDeliver) throws R01MJMSException {
        R01MJMSUtils._sendJMSMessage(msgType, null, msg, 0, timeToDeliver);
    }

    public static void sendJMSMessage(String msgType, Message msg, int jmsPriority) throws R01MJMSException {
        R01MJMSUtils._sendJMSMessage(msgType, null, msg, jmsPriority, -1L);
    }

    public static void sendJMSMessage(String msgType, Message msg, int jmsPriority, long timeToDeliver) throws R01MJMSException {
        R01MJMSUtils._sendJMSMessage(msgType, null, msg, jmsPriority, timeToDeliver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendJMSCallBackMapMessage(R01MMessageCallBackBean msgCallBack) {
        block28: {
            QueueConnectionFactory queueConnectionFactory;
            InitialContext jndiContext;
            if (msgCallBack == null || StringUtils.isEmptyString((String)msgCallBack.getJmsConnectionFactory()) || StringUtils.isEmptyString((String)msgCallBack.getJmsJNDIName())) {
                if (DEBUG) {
                    R01FLog.to((String)"r01m.jmsNotifier").severe("Los par\u00e1metros de conexion JMS son incorrectos." + (msgCallBack != null ? "factory:" + msgCallBack.getJmsConnectionFactory() + ",jndi:" + StringUtils.isEmptyString((String)msgCallBack.getJmsJNDIName()) : "null"));
                }
                return;
            }
            if (DEBUG) {
                R01FLog.to((String)"r01m.jmsNotifier").info("Enviando un mensaje a la Cola de Mensajes " + msgCallBack.getJmsConnectionFactory() + " - " + msgCallBack.getJmsJNDIName() + " !!!!!!!!!!!!!!!!");
            }
            try {
                jndiContext = new InitialContext();
                queueConnectionFactory = (QueueConnectionFactory)jndiContext.lookup(msgCallBack.getJmsConnectionFactory());
            }
            catch (NamingException namExc) {
                String msg = msgCallBack.getResponseState() + ":" + msgCallBack.getResponseMessage();
                try {
                    if (!StringUtils.isEmptyString((String)msgCallBack.getResponseFileNameAbsolutePath())) {
                        FileUtils.appendToFile((File)new File(msgCallBack.getResponseFileNameAbsolutePath()), (InputStream)new ByteArrayInputStream(msg.getBytes()), (boolean)true);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace(System.out);
                }
                if (DEBUG) {
                    R01FLog.to((String)"r01m.jmsNotifier").severe("Error obteniendo la factor\u00eda JMS." + namExc.getMessage());
                }
                return;
            }
            Queue clientCallBackQueue = null;
            try {
                clientCallBackQueue = (Queue)jndiContext.lookup(msgCallBack.getJmsJNDIName());
            }
            catch (NamingException namExc) {
                R01FLog.to((String)"r01m.jmsNotifier").severe("Error obteniendo la cola JMS. Error:" + namExc.getMessage());
                return;
            }
            QueueConnection queueConnection = null;
            try {
                if (DEBUG) {
                    R01FLog.to((String)"r01m.jmsNotifier").info("Abrir una conexi\u00f3n JMS para notificar.");
                }
                if ((queueConnection = queueConnectionFactory.createQueueConnection()) != null && clientCallBackQueue != null) {
                    QueueSession queueSession = queueConnection.createQueueSession(false, 1);
                    QueueSender clientCallBackSender = queueSession.createSender(clientCallBackQueue);
                    MapMessage mapMessage = queueSession.createMapMessage();
                    mapMessage.setString("processOid", msgCallBack.getProcessOid());
                    mapMessage.setString("jmsFactoryName", msgCallBack.getJmsConnectionFactory());
                    mapMessage.setString("jmsJNDIName", msgCallBack.getJmsJNDIName());
                    mapMessage.setString("fileName", msgCallBack.getFileName());
                    mapMessage.setInt("responseState", msgCallBack.getResponseState());
                    mapMessage.setString("responseMessage", msgCallBack.getResponseMessage());
                    mapMessage.setStringProperty(msgCallBack.getResponseControlDestination(), msgCallBack.getResponseControlDestinationValue());
                    if (DEBUG) {
                        R01FLog.to((String)"r01m.jmsNotifier").info("Enviando el mensaje a la Cola de Mensajes " + msgCallBack.getJmsConnectionFactory() + " - " + msgCallBack.getJmsJNDIName() + ".");
                    }
                    clientCallBackSender.send((Message)mapMessage);
                    break block28;
                }
                R01FLog.to((String)"r01m.jmsNotifier").severe("ERROR:La conexi\u00f3n o el publicador es NULO.");
                return;
            }
            catch (JMSException jmsExc) {
                R01FLog.to((String)"r01m.jmsNotifier").severe("Error en el env\u00edo del mensaje a la Cola de Mensajes " + msgCallBack.getJmsConnectionFactory() + " - " + msgCallBack.getJmsJNDIName() + ". Error:" + jmsExc.getMessage());
                return;
            }
            finally {
                if (queueConnection != null) {
                    try {
                        queueConnection.close();
                    }
                    catch (JMSException jmsExc) {
                        R01FLog.to((String)"r01m.jmsNotifier").severe("No se ha podido cerrar la conexi\u00f3n con la Cola de Mensajes " + msgCallBack.getJmsConnectionFactory() + " - " + msgCallBack.getJmsJNDIName() + ". Error:" + jmsExc.getMessage());
                    }
                }
            }
        }
    }

    private static void _sendError(String listenerAppCode, String packetOid, String objectOid, String errorMsg, String type) {
        R01MChangesLabelsResponse response = new R01MChangesLabelsResponse(listenerAppCode, packetOid, objectOid);
        response.setState(2);
        response.setEndProcessDateTS(R01MDateUtils.today());
        response.setErrorMsg(errorMsg);
        R01MJMSUtils.sendResponseToCatalog(response, type);
    }

    private static void _sendOK(String listenerAppCode, String packetOid, String objectOid, String type) {
        R01MChangesLabelsResponse response = new R01MChangesLabelsResponse(listenerAppCode, packetOid, objectOid);
        response.setState(3);
        response.setEndProcessDateTS(R01MDateUtils.today());
        R01MJMSUtils.sendResponseToCatalog(response, type);
    }

    private static void _sendJMSMessage(String msgType, List<R01MJmsQueueParam> params, Message msg, int jmsPriority, long timeToDeliver) throws R01MJMSException {
        block32: {
            QueueConnectionFactory queueConnectionFactory;
            InitialContext jndiContext;
            String queueJNDIName = XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"canalesyserviciosJMSConfig/canalesyserviciosJMS", (String)"r01n.r01nJMSQueue");
            if (DEBUG) {
                R01FLog.to((String)"r01m.jmsNotifier").info("Enviando un mensaje del tipo " + msgType + " a la Cola de Mensajes General (" + queueJNDIName + ") !!!!!!!!!!!!!!!!");
            }
            try {
                jndiContext = new InitialContext();
                queueConnectionFactory = (QueueConnectionFactory)jndiContext.lookup(XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"canalesyserviciosJMSConfig/canalesyserviciosConnectionFactory", (String)"r01.r01JMSConnectionFactory"));
            }
            catch (NamingException namExc) {
                R01FLog.to((String)"r01m.jmsNotifier").severe("Error obteniendo la factor\u00eda JMS. Error:" + namExc.getMessage());
                throw new R01MJMSException("Error obteniendo la factor\u00eda JMS.", (Exception)namExc);
            }
            Queue queueCanalesYServicios = null;
            try {
                queueCanalesYServicios = (Queue)jndiContext.lookup(queueJNDIName);
            }
            catch (NamingException namExc) {
                R01FLog.to((String)"r01m.jmsNotifier").severe("Error obteniendo la cola JMS. Error:" + namExc.getMessage());
                throw new R01MJMSException("Error obteniendo la cola JMS.", (Exception)namExc);
            }
            QueueConnection queueConnection = null;
            try {
                if (DEBUG) {
                    R01FLog.to((String)"r01m.jmsNotifier").info("Abrir una conexi\u00f3n JMS para notificar.");
                }
                if ((queueConnection = queueConnectionFactory.createQueueConnection()) != null && queueCanalesYServicios != null) {
                    Message message;
                    QueueSender canalesyserviciosSender;
                    QueueSession queueSession = queueConnection.createQueueSession(false, 1);
                    try {
                        canalesyserviciosSender = queueSession.createSender(queueCanalesYServicios);
                    }
                    catch (JMSException jmsSenderExc) {
                        R01FLog.to((String)"r01m.jmsNotifier").severe("Error en el env\u00edo del mensaje a la Cola de Mensajes General (r01nJMSQueue). Error:" + jmsSenderExc.getMessage());
                        throw new R01MJMSException("Error en el env\u00edo del mensaje a la Cola de Mensajes General (r01nJMSQueue).", (Exception)((Object)jmsSenderExc));
                    }
                    if (params != null) {
                        message = queueSession.createMessage();
                        message.setJMSType(msgType);
                        message.setStringProperty("ControlDestination", msgType);
                        message.setJMSExpiration(MSG_EXPIRATION_TIME);
                        if (0 <= jmsPriority && jmsPriority <= 9) {
                            message.setJMSPriority(jmsPriority);
                        }
                        if (params != null && !params.isEmpty()) {
                            for (R01MJmsQueueParam currParam : params) {
                                switch (currParam.getParamType()) {
                                    case 1: {
                                        message.setStringProperty(currParam.getParamKey(), (String)currParam.getParamValue());
                                        R01FLog.to((String)"r01m.jmsNotifier").info("Mensaje param: " + currParam.getParamKey() + " = " + (String)currParam.getParamValue());
                                        break;
                                    }
                                    case 2: {
                                        message.setBooleanProperty(currParam.getParamKey(), Boolean.valueOf((String)currParam.getParamValue()).booleanValue());
                                        R01FLog.to((String)"r01m.jmsNotifier").info("Mensaje param: " + currParam.getParamKey() + " = " + (String)currParam.getParamValue());
                                        break;
                                    }
                                    case 3: {
                                        message.setIntProperty(currParam.getParamKey(), Integer.parseInt((String)currParam.getParamValue()));
                                        R01FLog.to((String)"r01m.jmsNotifier").info("Mensaje param: " + currParam.getParamKey() + " = " + (String)currParam.getParamValue());
                                        break;
                                    }
                                    case 0: {
                                        message.setObjectProperty(currParam.getParamKey(), currParam.getParamValue());
                                        R01FLog.to((String)"r01m.jmsNotifier").info("Mensaje param: " + currParam.getParamKey() + " = Objeto del tipo " + currParam.getParamValue().getClass().getName());
                                    }
                                }
                            }
                            message.setIntProperty(MSG_RETRYNUMS, RETRYNUMS);
                        }
                    } else {
                        message = msg;
                    }
                    if (DEBUG) {
                        R01FLog.to((String)"r01m.jmsNotifier").info("Enviando el mensaje del tipo " + msgType + " a la Cola de Mensajes General (r01nJMSQueue).");
                    }
                    if (timeToDeliver != -1L) {
                        ((WLMessageProducer)canalesyserviciosSender).setTimeToDeliver(timeToDeliver);
                    }
                    canalesyserviciosSender.send(message);
                    break block32;
                }
                R01FLog.to((String)"r01m.jmsNotifier").severe("ERROR:La conexi\u00f3n o el publicador es NULO.");
                throw new R01MJMSException("ERROR:La conexi\u00f3n o el publicador es NULO.");
            }
            catch (JMSException jmsExc) {
                R01FLog.to((String)"r01m.jmsNotifier").severe("Error en el env\u00edo del mensaje a la Cola de Mensajes General (r01nJMSQueue). Error:" + jmsExc.getMessage());
                throw new R01MJMSException("Error en el env\u00edo del mensaje a la Cola de Mensajes General (r01nJMSQueue).", (Exception)((Object)jmsExc));
            }
            finally {
                if (queueConnection != null) {
                    try {
                        queueConnection.close();
                    }
                    catch (JMSException jmsExc) {
                        R01FLog.to((String)"r01m.jmsNotifier").severe("No se ha podido cerrar la conexi\u00f3n con la Cola de Mensajes General (r01nJMSQueue). Error:" + jmsExc.getMessage());
                    }
                }
            }
        }
    }
}

