/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.utils.contentmanager;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01m.config.objects.container.R01MResourcesContainerConfig;
import com.ejie.r01m.config.objects.typology.R01MResourcesRenderConfig;
import com.ejie.r01m.config.objects.typology.R01MResourcesRenderGroup;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.objects.contentmodel.R01MContentLocation;
import com.ejie.r01m.objects.contentmodel.R01MContentTypologyInfo;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.utils.R01MVariables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class R01MDocumentResourcesUtils {
    private static final String LOG_TYPE_ID = "r01m.util";
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01m.util").intValue() != Level.OFF.intValue();

    public static Map<String, R01MResourcesRenderGroup> getTypologyRenders(String typoOid) throws R01MContentModelException {
        try {
            return R01MClientFactory.getTypologyConfigAPI().getTypeConfig(typoOid).getPresentationRenderConfig().getRenderGroups();
        }
        catch (R01MConfigLoadException cfgExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error en la carga de los renderizadores para la tipologia '" + typoOid + "'. Error:" + cfgExc.getMessage());
            throw new R01MContentModelException("Error en la carga de los renderizadores para la tipologia '" + typoOid + "'.", (Exception)((Object)cfgExc));
        }
    }

    public static R01MResourcesRenderGroup getTypologyRenders(R01MContentTypologyInfo typo, String renderGroupType) throws R01MContentModelException {
        return R01MDocumentResourcesUtils.getTypologyRenders(typo.getTypeOid(), renderGroupType);
    }

    public static R01MResourcesRenderGroup getTypologyRenders(String typoOid, String renderGroupType) throws R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("Obtener los renderizadores del tipo '" + renderGroupType + "' para la tipolog\u00eda '" + typoOid + "'.");
        }
        Map<String, R01MResourcesRenderGroup> rendersGroup = R01MDocumentResourcesUtils.getTypologyRenders(typoOid);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("Obtener los renderers y procesar ......");
        }
        R01MResourcesRenderGroup renderGroup = null;
        if (rendersGroup != null && !rendersGroup.isEmpty() && rendersGroup.containsKey(renderGroupType)) {
            renderGroup = rendersGroup.get(renderGroupType);
        }
        if (renderGroup == null) {
            R01FLog.to((String)LOG_TYPE_ID).info("No se han definido renderizadores del tipo '" + renderGroupType + "' para la tipolog\u00eda '" + typoOid + "'.");
        }
        return renderGroup;
    }

    public static List getAllowedContainersFromLocAndTypo(R01MContentLocation loc, R01MContentTypologyInfo typo) throws R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("Obtener los contenedores permitidos para el storage '" + loc.getWorkAreaOid() + "' y la tipolog\u00eda '" + typo.getTypeOid() + "'.");
        }
        R01MResourcesContainerConfig allowedLocCfg = null;
        try {
            allowedLocCfg = R01MClientFactory.getStorageConfigAPI().getWorkAreaConfig(loc.getWorkAreaOid()).getAllowedResourcesContainers();
        }
        catch (R01MConfigLoadException cfgExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error en la carga de los contenedores para la workarea '" + loc.getWorkAreaOid() + "'. Error:" + cfgExc.getMessage());
            throw new R01MContentModelException("Error en la carga de los contenedores para la workarea '" + loc.getWorkAreaOid() + "'.", (Exception)((Object)cfgExc));
        }
        R01MResourcesContainerConfig allowedTypoCfg = null;
        try {
            allowedTypoCfg = R01MClientFactory.getTypologyConfigAPI().getTypeConfig(typo.getTypeOid()).getAllowedResourcesContainers();
        }
        catch (R01MConfigLoadException cfgExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error en la carga de los contenedores para la tipologia '" + typo.getTypeOid() + "'. Error:" + cfgExc.getMessage());
            throw new R01MContentModelException("Error en la carga de los contenedores para la tipologia '" + typo.getTypeOid() + "'.", (Exception)((Object)cfgExc));
        }
        ArrayList<String> containersListToProcess = new ArrayList<String>();
        if (allowedLocCfg != null && allowedLocCfg.getAllowedContainers() != null && !allowedLocCfg.getAllowedContainers().isEmpty()) {
            Iterator<String> itContainers = allowedLocCfg.getAllowedContainers().iterator();
            while (itContainers.hasNext()) {
                containersListToProcess.add(itContainers.next());
            }
        }
        if (allowedTypoCfg != null && allowedTypoCfg.getAllowedContainers() != null && !allowedTypoCfg.getAllowedContainers().isEmpty()) {
            for (String containerTypoId : allowedTypoCfg.getAllowedContainers()) {
                if (containersListToProcess.contains(containerTypoId)) continue;
                containersListToProcess.add(containerTypoId);
            }
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("Fin obtener los contenedores permitidos para el storage '" + loc.getWorkAreaOid() + "' y la tipolog\u00eda '" + typo.getTypeOid() + "'.");
        }
        return containersListToProcess;
    }

    public static String getDocumentResourceGeneratedFileDocumentRelativePath(R01MContentTypologyInfo typo, String renderGroupType, String renderId, String documentLanguage, String documentInternalName, String containerId) throws R01MContentModelException {
        R01MResourcesRenderGroup renderGroup = R01MDocumentResourcesUtils.getTypologyRenders(typo, renderGroupType);
        Properties vars = new Properties();
        vars.put("documentLanguage", documentLanguage);
        vars.put("documentInternalName", documentInternalName);
        vars.put("container", containerId);
        vars.put("renderId", renderId);
        String effectiveGeneratedFileName = ((R01MResourcesRenderConfig)renderGroup.getRenders().get(renderId)).getProperties().get("fileName").toString();
        effectiveGeneratedFileName = R01MVariables.customize(effectiveGeneratedFileName, vars);
        return effectiveGeneratedFileName;
    }

    public static String getDocumentResourceGeneratedFileDocumentRelativePath(R01MContentTypologyInfo typo, String renderGroupType, String renderId, String documentLanguage, String documentInternalName, String containerId, String resourceInternalName) throws R01MContentModelException {
        R01MResourcesRenderGroup renderGroup = R01MDocumentResourcesUtils.getTypologyRenders(typo, renderGroupType);
        Properties vars = new Properties();
        vars.put("documentLanguage", documentLanguage);
        vars.put("documentInternalName", documentInternalName);
        vars.put("container", containerId);
        vars.put("renderId", renderId);
        vars.put("resourceInternalName", resourceInternalName);
        String effectiveGeneratedFileName = ((R01MResourcesRenderConfig)renderGroup.getRenders().get(renderId)).getProperties().get("fileName").toString();
        effectiveGeneratedFileName = R01MVariables.customize(effectiveGeneratedFileName, vars);
        return effectiveGeneratedFileName;
    }
}

