/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.utils.contentmanager;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.utils.XMLParserHelper;
import com.ejie.r01f.xml.utils.XMLSerializerHelper;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.config.objects.storage.R01MWorkArea;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MDataStoreException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MDocument;
import com.ejie.r01m.objects.searchengine.indexer.datafilemetadataextractors.R01MDataFileMetaDataExtractorUtils;
import com.ejie.r01m.objects.searchengine.indexer.datafilemetadataextractors.R01MDataFileMetaDataToExtract;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MContentDataAPI;
import com.ejie.r01m.services.R01MRawDataAPI;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MPathHelpper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.SAXException;

public abstract class R01MDataFileXMLUtils {
    public static final String PARSE_DCR_CHUNKED = XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"parseDCRChunked", (String)"false");
    private static final String PATH_COMMON_DATA = "/data/r01CommonData.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document downloadAndParseDataFile(R01MUserContext userCtx, String contentOid, String documentOid, String dataFileOid) throws R01MSecurityException {
        InputStream dfIs = null;
        try {
            R01MContentDataAPI dataAPI = R01MClientFactory.getContentDataAPI(userCtx, contentOid);
            if (PARSE_DCR_CHUNKED.equalsIgnoreCase("true")) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                long offset = 0L;
                try {
                    byte[] buffer;
                    do {
                        if ((buffer = dataAPI.downloadDataFileChunk(documentOid, dataFileOid, offset, 512)) == null || buffer.length <= 0) continue;
                        offset += Long.valueOf("512").longValue();
                        os.write(buffer);
                    } while (buffer != null && buffer.length > 0);
                }
                catch (Exception ioEx) {
                    ioEx.printStackTrace(System.out);
                    Document document = null;
                    return document;
                }
                finally {
                    if (os != null) {
                        try {
                            os.flush();
                            os.close();
                        }
                        catch (IOException e) {}
                        dfIs = new ByteArrayInputStream(os.toString().getBytes());
                    }
                }
            }
            try {
                dfIs = dataAPI.downloadDataFile(documentOid, dataFileOid);
            }
            catch (R01MContentModelException e) {
                e.printStackTrace(System.out);
                return null;
            }
            if (dfIs != null) return R01MDataFileMetaDataExtractorUtils.parseDCR(dfIs);
            return null;
        }
        catch (SAXException saxEx) {
            saxEx.printStackTrace(System.out);
            return null;
        }
    }

    public static Document downloadAndParseContentMetadataFile(R01MUserContext userCtx, String contentOid) throws R01MSecurityException {
        Document dfContent = null;
        try {
            R01MContent content = R01MClientFactory.getContentModelAPI(R01MAuthManager.createMasterSystemUserContext()).loadContent(contentOid);
            R01MWorkArea wkContent = R01MClientFactory.getStorageConfigAPI().getWorkAreaConfig(content.getStoreLocation().getWorkAreaOid());
            String contentWkRelativePath = R01MPathHelpper.getContentWorkAreaRelativePath(content.getTypo(), content.getStoreLocation(), content.getOid(), content.getName(), content.getName());
            R01MRawDataAPI api = R01MClientFactory.getRawDataAPI(R01MAuthManager.createMasterSystemUserContext());
            if (api.checkFile(wkContent.getAbsolutePath(), contentWkRelativePath + "/" + content.getInternalName() + ".xml")) {
                InputStream isContent = api.readFile(wkContent.getAbsolutePath(), contentWkRelativePath + "/" + content.getInternalName() + ".xml");
                dfContent = R01MDataFileXMLUtils.parseDCR(isContent);
            } else {
                R01FLog.to((String)"r01m.util").warning("El fichero de datos a nivel de contenido del oid : " + contentOid + " no existe.");
            }
        }
        catch (R01MConfigLoadException ex) {
            R01FLog.to((String)"r01m.util").warning("No se ha podido cargar la configuracion de la workarea para el contenido del oid : " + contentOid);
        }
        catch (R01MDataStoreException ex) {
            R01FLog.to((String)"r01m.util").warning("No se ha podido leer en fichero del contenido del oid : " + contentOid);
        }
        catch (R01MContentModelException ex) {
            R01FLog.to((String)"r01m.util").warning("No se ha podido cargar contenido del oid : " + contentOid);
        }
        catch (SAXException ex) {
            R01FLog.to((String)"r01m.util").warning("Error al parsear el fichero del contenido del oid : " + contentOid);
        }
        return dfContent;
    }

    public static Document downloadAndParseCommonDataFile(R01MUserContext userCtx, String contentOid, String documentOid) throws R01MSecurityException {
        Document dfContent = null;
        try {
            R01MContent content = R01MClientFactory.getContentModelAPI(R01MAuthManager.createMasterSystemUserContext()).loadContent(contentOid);
            R01MDocument doc = content.getDocuments().get(documentOid);
            R01MWorkArea wkContent = R01MClientFactory.getStorageConfigAPI().getWorkAreaConfig(content.getStoreLocation().getWorkAreaOid());
            String contentWkRelativePath = R01MPathHelpper.getContentWorkAreaRelativePath(content.getTypo(), content.getStoreLocation(), content.getOid(), content.getName(), content.getName());
            String documentRelativePath = R01MPathHelpper.getDocumentContentRelativePath(content.getTypo(), content.getStoreLocation(), content.getOid(), content.getInternalName(), content.getName(), doc.getOid(), doc.getLanguage(), doc.getInternalName());
            StringBuffer filePath = new StringBuffer(100);
            filePath.append(contentWkRelativePath);
            filePath.append("/").append(documentRelativePath).append(PATH_COMMON_DATA);
            R01MRawDataAPI api = R01MClientFactory.getRawDataAPI(R01MAuthManager.createMasterSystemUserContext());
            if (api.checkFile(wkContent.getAbsolutePath(), filePath.toString())) {
                InputStream isContent = api.readFile(wkContent.getAbsolutePath(), filePath.toString());
                dfContent = R01MDataFileXMLUtils.parseDCR(isContent);
            } else {
                R01FLog.to((String)"r01m.util").warning("El fichero de datos a nivel de contenido del oid : " + contentOid + " no existe.");
            }
        }
        catch (R01MConfigLoadException ex) {
            R01FLog.to((String)"r01m.util").warning("No se ha podido cargar la configuracion de la workarea para el contenido del oid : " + contentOid);
        }
        catch (R01MDataStoreException ex) {
            R01FLog.to((String)"r01m.util").warning("No se ha podido leer en fichero del contenido del oid : " + contentOid);
        }
        catch (R01MContentModelException ex) {
            R01FLog.to((String)"r01m.util").warning("No se ha podido cargar contenido del oid : " + contentOid);
        }
        catch (SAXException ex) {
            R01FLog.to((String)"r01m.util").warning("Error al parsear el fichero del contenido del oid : " + contentOid);
        }
        return dfContent;
    }

    public static Document parseDCR(InputStream dcrIs) throws SAXException {
        String[] ignoredEntities = new String[]{"dcr4.5.dtd"};
        return XMLParserHelper.parseXML((InputStream)dcrIs, (String[])ignoredEntities);
    }

    public static String serializeDCR(Document dcrDoc, String outEncoding) throws TransformerException {
        return XMLSerializerHelper.getXML((Node)dcrDoc, (String)outEncoding);
    }

    public static String encapsulteDCR(Document dcrDoc, String outEncoding) throws TransformerException {
        if (dcrDoc != null) {
            Element newRoot = dcrDoc.createElement("dataFile");
            newRoot.appendChild(dcrDoc.getDocumentElement());
            return XMLSerializerHelper.getXML((Node)newRoot, (String)outEncoding);
        }
        return "";
    }

    public static String changeDCRNameInXML(InputStream xmlIS, String newName) throws R01MDataStoreException {
        StringBuffer result = new StringBuffer(37);
        if (xmlIS == null) {
            return null;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(xmlIS));
        Pattern p = Pattern.compile("<record name=\".*\" type=\"content\">");
        Matcher m = p.matcher("");
        String aLine = null;
        try {
            while ((aLine = in.readLine()) != null) {
                m.reset(aLine);
                result.append(m.replaceAll("<record name=\"" + newName + "\" type=\"content\">"));
                result.append("\n");
            }
            in.close();
        }
        catch (IOException ioEx) {
            throw new R01MDataStoreException("Error al cambiar el atributo name del elemento record del fichero de datos." + ioEx.getMessage(), (Exception)ioEx);
        }
        return result.toString();
    }

    public static Map<String, String> extractDataFileMetaDataUsingXPath(String contentOid, String documentOid, String dataFileOid, Document dfDoc, Map<String, String> metaDataXPaths) {
        if (metaDataXPaths == null || metaDataXPaths.size() == 0) {
            return null;
        }
        HashMap<String, String> outMetaDataValues = new HashMap<String, String>(metaDataXPaths.size());
        String mdOid = null;
        String xPath = null;
        for (Map.Entry<String, String> xme : metaDataXPaths.entrySet()) {
            String mdValue;
            Node node;
            mdOid = xme.getKey();
            xPath = xme.getValue();
            if (xPath == null || StringUtils.isEmptyString((String)xPath)) continue;
            try {
                node = XPathAPI.selectSingleNode((Node)dfDoc.getDocumentElement(), (String)xPath.trim());
            }
            catch (TransformerException tfEx) {
                tfEx.printStackTrace(System.out);
                continue;
            }
            if (node == null) continue;
            if (node.getFirstChild() == null) {
                mdValue = "";
            } else {
                try {
                    mdValue = node.getFirstChild().getNodeValue();
                }
                catch (DOMException domEx) {
                    domEx.printStackTrace(System.out);
                    continue;
                }
            }
            if (mdValue == null || mdValue.length() <= 0) continue;
            mdValue = mdValue.trim();
            mdValue = mdValue.replaceAll("\r|\n", "");
            outMetaDataValues.put(mdOid, mdValue);
        }
        return outMetaDataValues;
    }

    public static String extractDataFileMetaDataUsingXPath(Document dfFile, R01MDataFileMetaDataToExtract extractorData) {
        if (extractorData == null || StringUtils.isEmptyString((String)extractorData.xPath) || dfFile == null) {
            return null;
        }
        Node node = null;
        NodeIterator nodeIt = null;
        String separator = "";
        try {
            R01FLog.to((String)"r01m.util").info("\t\t...metaDato  " + extractorData.metaDataOid + ": " + extractorData.xPath);
            if (extractorData.isMultipleMetaDataValues) {
                nodeIt = XPathAPI.selectNodeIterator((Node)dfFile.getDocumentElement(), (String)extractorData.xPath.trim());
                separator = extractorData.multipleMetaDataValuesSeparator;
            } else {
                node = XPathAPI.selectSingleNode((Node)dfFile.getDocumentElement(), (String)extractorData.xPath.trim());
            }
        }
        catch (TransformerException tfEx) {
            tfEx.printStackTrace(System.out);
            R01FLog.to((String)"r01m.util").warning("Error al obtener el nodo " + extractorData.xPath + " del fichero del archivo de datos de oid " + extractorData.dataFileOid + " del documento de oid " + extractorData.documentOid + " de contenido de oid " + extractorData.contentOid + ": " + tfEx.getMessage());
            node = null;
        }
        if (node != null) {
            String mdValue = null;
            if (node.getFirstChild() == null) {
                mdValue = "";
            } else {
                try {
                    mdValue = node.getFirstChild().getNodeValue();
                }
                catch (DOMException domEx) {
                    domEx.printStackTrace(System.out);
                    R01FLog.to((String)"r01m.util").severe("Error al obtener el valor del nodo " + extractorData.xPath + " del archivo de datos de oid " + extractorData.dataFileOid + " del documento de oid " + extractorData.documentOid + " del contenido de oid " + extractorData.contentOid + ": " + domEx.getMessage());
                    mdValue = null;
                }
            }
            if (mdValue != null && mdValue.length() > 0) {
                mdValue = mdValue.trim();
                mdValue = mdValue.replaceAll("\r|\n", "");
                return mdValue;
            }
        } else {
            if (nodeIt != null) {
                Node n;
                String nvalor = "";
                while ((n = nodeIt.nextNode()) != null) {
                    nvalor = nvalor + n.getFirstChild().getNodeValue();
                    nvalor = nvalor + separator;
                }
                return nvalor;
            }
            R01FLog.to((String)"r01m.util").warning("INDEXDATAFILE >>> En el datafile (DCR) del contenido:documento:dataFile " + extractorData.contentOid + ":" + extractorData.documentOid + ":" + extractorData.dataFileOid + " NO existe el elemento " + extractorData.xPath + ". Puede deberse a dos causas:" + "\r\n\t1.- La plantilla de captura " + extractorData.templateOid + " no es la correcta (no contiene el metaDato)" + "\r\n\t2.- El DCR no tiene este dato (el usuario no lo ha introducido en la plantilla)");
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            long t1 = System.currentTimeMillis();
            String dcr = StringUtils.loadFromFile((String)"c:/dcr.xml");
            Document dcrDoc = R01MDataFileXMLUtils.parseDCR(new ByteArrayInputStream(dcr.getBytes()));
            int testTimes = 1;
            for (int times = 0; times < testTimes; ++times) {
                R01FLog.to((String)"r01m.test").info(R01MDataFileXMLUtils.encapsulteDCR(dcrDoc, null));
            }
            long t2 = System.currentTimeMillis();
            R01FLog.to((String)"r01m.test").info("\r\n\r\nTime Elapsed: " + (t2 - t1) / 1000L + "sg - " + (t2 - t1) + "msg");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

