/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.utils.contentmanager;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.config.objects.storage.R01MWorkArea;
import com.ejie.r01m.config.objects.typology.R01MAllowedTypo;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MCatalogElementNotFoundException;
import com.ejie.r01m.exceptions.R01MCatalogException;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MContentModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.R01MURLAlias;
import com.ejie.r01m.objects.cataloguing.R01MStructureCatalog;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MContentLocation;
import com.ejie.r01m.objects.contentmodel.R01MContentTypologyInfo;
import com.ejie.r01m.objects.contentmodel.R01MDataFile;
import com.ejie.r01m.objects.contentmodel.R01MDocument;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MContentModelAPI;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MURLHelpper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class R01MContentModelObjectsValidator {
    public static void validateContent(R01MUserContext userCtx, R01MContent content) throws R01MContentModelObjectsValidatorException {
        R01FLog.to((String)"r01m.util").info("Validando el contenido...");
        if (content == null) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MContent] No puede ser vac\u00edo.");
        }
        if (content.getDocuments() != null) {
            R01MDocument currDoc = null;
            for (Map.Entry<String, R01MDocument> me : content.getDocuments().entrySet()) {
                if (!(me.getValue() instanceof R01MDocument) || (currDoc = me.getValue()).getDataFiles() == null) continue;
                R01MDataFile currDataFile = null;
                for (Map.Entry<String, R01MDataFile> mefile : currDoc.getDataFiles().entrySet()) {
                    if (!(mefile.getValue() instanceof R01MDataFile)) continue;
                    currDataFile = mefile.getValue();
                    R01MContentModelObjectsValidator._completeDataFile(content, currDoc.getOid(), currDataFile.getOid());
                }
            }
        }
        content.validateObject();
        R01MContentModelObjectsValidator._validateAlias(userCtx, content);
        R01MContentModelObjectsValidator._validateCatalogations(content);
    }

    public static void validateDocument(R01MUserContext userCtx, R01MContent cont, String documentOid) throws R01MContentModelObjectsValidatorException {
        R01FLog.to((String)"r01m.util").info("\t...validando documento");
        if (cont == null || cont.getDocuments() == null) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MContent] No puede ser vac\u00edo y debe tener documentos.");
        }
        R01MDocument doc = cont.getDocuments().get(documentOid);
        if (doc == null) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MDocument (" + documentOid + ")] No puede ser vac\u00edo.");
        }
        if (doc.getDataFiles() != null) {
            R01MDataFile currDataFile = null;
            for (Map.Entry<String, R01MDataFile> mefile : doc.getDataFiles().entrySet()) {
                if (!(mefile.getValue() instanceof R01MDataFile)) continue;
                currDataFile = mefile.getValue();
                R01MContentModelObjectsValidator._completeDataFile(cont, doc.getOid(), currDataFile.getOid());
            }
        }
        doc.validateObject();
        R01MContentModelObjectsValidator._validateAlias(userCtx, doc);
    }

    public static void validateDataFile(R01MContent cont, String docOid, String dataFileOid) throws R01MContentModelObjectsValidatorException {
        R01FLog.to((String)"r01m.util").info("\t\t...validando fichero de datos");
        if (cont == null || cont.getDocuments() == null) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MContent] No puede ser vac\u00edo y debe tener documentos.");
        }
        R01MDocument doc = cont.getDocument(docOid);
        if (doc == null || doc.getDataFiles() == null) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MDocument] No puede ser vac\u00edo y debe tener archivos de datos.");
        }
        R01MDataFile dataFile = doc.getDataFile(dataFileOid);
        if (dataFile == null) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MDataFile (" + dataFileOid + ")] No puede ser vac\u00edo.");
        }
        R01MContentModelObjectsValidator._completeDataFile(cont, docOid, dataFileOid);
        dataFile.validateObject();
    }

    public static boolean validateChangeCluster(R01MContentLocation location, R01MContentTypologyInfo typologyInfo, String clusterOid) throws R01MContentModelObjectsValidatorException {
        R01MWorkArea workArea;
        R01FLog.to((String)"r01m.util").info("\t\t...validando cluster al que se pretende mover el contenido");
        if (typologyInfo.getClusterOid().equals(clusterOid)) {
            return false;
        }
        try {
            workArea = R01MClientFactory.getStorageConfigAPI().getWorkAreaConfig(location.getServerOid(), location.getDataRepositoryOid(), location.getAreaOid(), location.getWorkAreaOid());
        }
        catch (R01MConfigLoadException cfgEx) {
            R01FLog.to((String)"r01m.util").severe("Error al obtener la configuraci\u00f3n del Storage.ServerOid:" + location.getServerOid() + ";RepositoryOid:" + location.getDataRepositoryOid() + ";AreaOid:" + location.getAreaOid() + ";WorkAreaOid:" + location.getWorkAreaOid() + "\n\tDetalle:" + cfgEx.getDetailedMessage());
            throw new R01MContentModelObjectsValidatorException("Error al obtener la configuraci\u00f3n del Storage.ServerOid:" + location.getServerOid() + ";RepositoryOid:" + location.getDataRepositoryOid() + ";AreaOid:" + location.getAreaOid() + ";WorkAreaOid:" + location.getWorkAreaOid() + "\n\tDetalle:" + cfgEx.getDetailedMessage());
        }
        List<R01MAllowedTypo> allowedTypes = workArea.getTypologyConfig().getAllowedTypos();
        if (allowedTypes != null && allowedTypes.size() > 0) {
            for (int i = 0; i < allowedTypes.size(); ++i) {
                R01MAllowedTypo allowedTypo = allowedTypes.get(i);
                if (!allowedTypo.getClusterOid().equals(clusterOid) || !allowedTypo.getFamilyOid().equals(typologyInfo.getFamilyOid()) || !allowedTypo.getTypeOid().equals(typologyInfo.getTypeOid())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean validateChangeLocation(R01MUserContext userCtx, String contentOid, R01MContentLocation locTarget) throws R01MContentModelObjectsValidatorException {
        R01MContent content;
        R01FLog.to((String)"r01m.util").info("\t\t...validando la localizaci\u00f3n a la que se pretende mover el contenido");
        try {
            content = R01MClientFactory.getContentModelAPI(userCtx).loadContent(contentOid);
        }
        catch (R01MSecurityException secEx) {
            R01FLog.to((String)"r01m.util").severe("Error de seguridad al  cargar el contenido ligero  de oid:" + contentOid + "\n\tDetalle:" + secEx.getDetailedMessage());
            throw new R01MContentModelObjectsValidatorException("Error al cargar el contenido ligero  de oid:" + contentOid + "\n\tDetalle:" + secEx.getDetailedMessage());
        }
        catch (R01MContentModelException cmEx) {
            R01FLog.to((String)"r01m.util").severe("Error al cargar el contenido ligero  de oid:" + contentOid + "\n\tDetalle:" + cmEx.getDetailedMessage());
            throw new R01MContentModelObjectsValidatorException("Error al cargar el contenido ligero  de oid:" + contentOid + "\n\tDetalle:" + cmEx.getDetailedMessage());
        }
        if (!content.getStoreLocation().getServerOid().equals(locTarget.getServerOid()) || !content.getStoreLocation().getDataRepositoryOid().equals(locTarget.getDataRepositoryOid())) {
            return false;
        }
        return !content.getStoreLocation().getAreaOid().equals(locTarget.getAreaOid()) || !content.getStoreLocation().getWorkAreaOid().equals(locTarget.getWorkAreaOid());
    }

    public static boolean validateCopyToLocation(String contentOid, R01MContentLocation locTarget, String newContentName, R01MUserContext usrCtx) throws R01MContentModelObjectsValidatorException {
        R01MContent content;
        R01FLog.to((String)"r01m.util").info("\t\t...validando la localizaci\u00f3n a la que se pretende copiar el contenido");
        try {
            content = R01MClientFactory.getContentModelAPI(usrCtx).loadContent(contentOid);
        }
        catch (R01MSecurityException e) {
            R01FLog.to((String)"r01m.util").severe("Error de seguridad al  cargar el contenido ligero  de oid:" + contentOid + "\n\tDetalle:" + e.getDetailedMessage());
            throw new R01MContentModelObjectsValidatorException("Error al cargar el contenido ligero  de oid:" + contentOid + "\n\tDetalle:" + e.getDetailedMessage());
        }
        catch (R01MContentModelException e) {
            R01FLog.to((String)"r01m.util").severe("Error al cargar el contenido ligero  de oid:" + contentOid + "\n\tDetalle:" + e.getDetailedMessage());
            throw new R01MContentModelObjectsValidatorException("Error al cargar el contenido ligero  de oid:" + contentOid + "\n\tDetalle:" + e.getDetailedMessage());
        }
        if (!content.getStoreLocation().getServerOid().equals(locTarget.getServerOid()) || !content.getStoreLocation().getDataRepositoryOid().equals(locTarget.getDataRepositoryOid())) {
            return false;
        }
        if (StringUtils.isEmptyString((String)newContentName) || newContentName.length() > 30 || !R01MContentModelObjectsValidator.isValidName(newContentName)) {
            throw new R01MContentModelObjectsValidatorException("El nombre de contenido " + newContentName + " no es v\u00e1lido.");
        }
        return true;
    }

    public static void validatePairStructureCatalog(R01MUserContext userCtx, R01MStructureCatalog structureCatalog) throws R01MContentModelObjectsValidatorException {
        boolean validateStructure = true;
        if (XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"validateStructures") != null) {
            try {
                if (Integer.parseInt(XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"validateStructures").toString()) == 0) {
                    validateStructure = false;
                }
            }
            catch (Exception e) {
                validateStructure = false;
            }
        }
        if (validateStructure) {
            try {
                R01MClientFactory.getCatalogAPI(userCtx).getStructureItem(structureCatalog.structureOid, structureCatalog.oid, Integer.parseInt(structureCatalog.role), false);
            }
            catch (R01MCatalogElementNotFoundException catExc) {
                throw new R01MContentModelObjectsValidatorException("El par estructura/etiqueta/rol es incorrecto. Revise la catalogaci\u00f3n.", (Exception)((Object)catExc));
            }
            catch (R01MCatalogException e) {
                throw new R01MContentModelObjectsValidatorException("El par estructura/etiqueta/rol es incorrecto. Revise la catalogaci\u00f3n.", (Exception)((Object)e));
            }
        }
    }

    private static void _validateAlias(R01MUserContext userCtx, R01MContent content) throws R01MContentModelObjectsValidatorException {
        if (content.getDocuments() != null) {
            HashMap<String, R01MURLAlias> aliasMap = new HashMap<String, R01MURLAlias>();
            for (R01MDocument object : content.getDocuments().values()) {
                if (!(object instanceof R01MDocument)) continue;
                R01MDocument document = object;
                R01MContentModelObjectsValidator._validateAliasInObject(document, aliasMap);
            }
        }
        if (content.getDocuments() != null) {
            for (R01MDocument object : content.getDocuments().values()) {
                if (!(object instanceof R01MDocument)) continue;
                R01MDocument document = object;
                R01MContentModelObjectsValidator._validateAliasInBD(userCtx, document);
            }
        }
    }

    private static void _validateCatalogations(R01MContent content) {
        ArrayList<String> labelKeys = new ArrayList<String>();
        ArrayList<R01MStructureCatalog> labelsToDelete = new ArrayList<R01MStructureCatalog>();
        if (content != null && content.getLabels() != null && !content.getLabels().isEmpty()) {
            for (R01MStructureCatalog labelObj : content.getLabels()) {
                String key = labelObj.getOid() + labelObj.getStructureOid();
                if (labelKeys.contains(key)) {
                    labelsToDelete.add(labelObj);
                    continue;
                }
                labelKeys.add(key);
            }
            if (labelsToDelete != null && !labelsToDelete.isEmpty()) {
                Iterator itLabelsToDelete = labelsToDelete.iterator();
                while (itLabelsToDelete.hasNext()) {
                    content.getLabels().remove(itLabelsToDelete.next());
                }
            }
        }
    }

    private static void _validateAlias(R01MUserContext userCtx, R01MDocument document) throws R01MContentModelObjectsValidatorException {
        R01MContentModelObjectsValidator._validateAliasInObject(document, null);
        R01MContentModelObjectsValidator._validateAliasInBD(userCtx, document);
    }

    private static void _validateAliasInObject(R01MDocument document, Map<String, R01MURLAlias> aliasMap) throws R01MContentModelObjectsValidatorException {
        if (aliasMap == null) {
            aliasMap = new HashMap<String, R01MURLAlias>();
        }
        if (document != null && document.getUrlAliases() != null && !document.getUrlAliases().isEmpty()) {
            for (R01MURLAlias alias : document.getUrlAliases()) {
                if (alias.getAlias().lastIndexOf("/") != alias.getAlias().length() - 1) {
                    alias.setAlias(alias.getAlias() + "/");
                }
                if (aliasMap.containsKey(alias.getAlias())) {
                    throw new R01MContentModelObjectsValidatorException("El alias '" + alias.getAlias() + "' est\u00e1 repetido.");
                }
                aliasMap.put(alias.getAlias(), alias);
            }
        }
    }

    private static void _validateAliasInBD(R01MUserContext userCtx, R01MDocument document) throws R01MContentModelObjectsValidatorException {
        try {
            R01MDocument documentBD = null;
            R01MContentModelAPI contentAPI = R01MClientFactory.getContentModelAPI(userCtx);
            if (contentAPI.checkDocumentExistence(document.getOid())) {
                documentBD = contentAPI.loadDocument(document.getOid());
            }
            if (document != null && document.getUrlAliases() != null && !document.getUrlAliases().isEmpty()) {
                Iterator<R01MURLAlias> itAlias = document.getUrlAliases().iterator();
                while (itAlias.hasNext()) {
                    boolean found = false;
                    R01MURLAlias alias = itAlias.next();
                    if (alias.getAlias().lastIndexOf("/") != alias.getAlias().length() - 1) {
                        alias.setAlias(alias.getAlias() + "/");
                    }
                    if (documentBD != null && documentBD.getUrlAliases() != null) {
                        for (R01MURLAlias aliasBD : documentBD.getUrlAliases()) {
                            if (aliasBD.getAlias().lastIndexOf("/") != aliasBD.getAlias().length() - 1) {
                                aliasBD.setAlias(aliasBD.getAlias() + "/");
                            }
                            if (!aliasBD.getAlias().equals(alias.getAlias())) continue;
                            found = true;
                            break;
                        }
                    }
                    if (found || !contentAPI.checkAliasExistence(alias.getAlias())) continue;
                    throw new R01MContentModelObjectsValidatorException("El alias '" + alias.getAlias() + "' ya existe.");
                }
            }
        }
        catch (R01MSecurityException ex) {
            throw new R01MContentModelObjectsValidatorException((Exception)((Object)ex));
        }
        catch (R01MContentModelException ex) {
            throw new R01MContentModelObjectsValidatorException((Exception)((Object)ex));
        }
    }

    private static void _completeDataFile(R01MContent cont, String docOid, String dataFileOid) {
        R01FLog.to((String)"r01m.util").info("\t\t...autocompletar fichero de datos");
        R01MDocument doc = cont.getDocuments().get(docOid);
        R01MDataFile dataFile = doc.getDataFiles().get(dataFileOid);
        String urlEdit = dataFile.getEditUrl();
        String urlPreview = dataFile.getPreviewUrl();
        String urlGenerate = dataFile.getGenerateUrl();
        if (dataFile.getEditUrl() == null || StringUtils.isEmptyString((String)dataFile.getEditUrl())) {
            urlEdit = R01MURLHelpper.getDataFileEditionURL(null, cont.getTypo(), cont.getStoreLocation(), cont.getOid(), cont.getName(), cont.getName(), doc.getOid(), doc.getLanguage(), doc.getInternalName(), dataFile.getOid(), dataFile.getName(), dataFile.getName(), dataFile.getTemplateOid());
            dataFile.setEditUrl(urlEdit);
        }
        if (dataFile.getPreviewUrl() == null || StringUtils.isEmptyString((String)dataFile.getPreviewUrl())) {
            dataFile.setPreviewUrl(R01MURLHelpper.getDefaultGeneratedDataFilePreviewURL(doc.getLanguage(), cont.getTypo(), cont.getStoreLocation(), cont.getOid(), cont.getName(), cont.getName(), doc.getOid(), doc.getLanguage(), doc.getInternalName(), dataFile.getOid(), dataFile.getName(), dataFile.getName(), dataFile.getTemplateOid()));
        }
        if (dataFile.getGenerateUrl() == null || StringUtils.isEmptyString((String)dataFile.getGenerateUrl())) {
            urlGenerate = R01MURLHelpper.getDataFileGenerateURL(null, cont.getTypo(), cont.getStoreLocation(), cont.getOid(), cont.getName(), cont.getName(), doc.getOid(), doc.getLanguage(), doc.getInternalName(), dataFile.getOid(), dataFile.getName(), dataFile.getName(), dataFile.getTemplateOid());
            dataFile.setGenerateUrl(urlGenerate);
        }
        R01FLog.to((String)"r01m.util").info("\t\t\turl de edicion fichero datos: " + urlEdit);
        R01FLog.to((String)"r01m.util").info("\t\t\turl de previsualizacion fichero datos: " + urlPreview);
        R01FLog.to((String)"r01m.util").info("\t\t\turl de generacion fichero datos: " + urlGenerate);
    }

    public static R01MDataFile getDataFileInitialDataFile(R01MContent content, String documentOid) {
        if (content.getDocuments() == null) {
            return null;
        }
        R01MDocument document = content.getDocuments().get(documentOid);
        Map<String, R01MDataFile> datafiles = document.getDataFiles();
        R01MDataFile initialDataFile = null;
        R01MDataFile currDataFile = null;
        Map.Entry<String, R01MDataFile> me2 = null;
        for (Map.Entry<String, R01MDataFile> me2 : datafiles.entrySet()) {
            currDataFile = me2.getValue();
            if (currDataFile.getInitialPage() != 1) continue;
            initialDataFile = currDataFile;
        }
        return initialDataFile;
    }

    public static boolean isValidName(String name) {
        if (name.indexOf(13) > 0 || name.indexOf(10) > 0) {
            return false;
        }
        char[] cName = new char[50];
        name.getChars(0, name.length(), cName, 0);
        for (int i = 0; i < name.length(); ++i) {
            if (Character.getNumericValue(cName[i]) >= 10 && Character.getNumericValue(cName[i]) <= 35 || Character.getNumericValue(cName[i]) >= 0 && Character.getNumericValue(cName[i]) <= 9 || String.valueOf(cName[i]).equals("_")) {
                if (Character.getNumericValue(cName[i]) < 10 || Character.getNumericValue(cName[i]) > 35 || !Character.isUpperCase(cName[i])) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

