/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.utils.contentmanager;

import com.ejie.r01m.config.objects.typology.R01MContentCluster;
import com.ejie.r01m.config.objects.typology.R01MContentFamily;
import com.ejie.r01m.config.objects.typology.R01MContentType;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.services.R01MClientFactory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class R01MContentManagerTypologyIterator
implements Iterator,
Serializable {
    private static final long serialVersionUID = -3982565287811887923L;
    LinkedList _list = new LinkedList();
    int _listIndex = -1;

    public R01MContentManagerTypologyIterator() throws R01MConfigLoadException {
        this._initIterator(null, null, null);
    }

    public R01MContentManagerTypologyIterator(String clusterOid, String familyOid, String typeOid) throws R01MConfigLoadException {
        this._initIterator(clusterOid, familyOid, typeOid);
    }

    private void _initIterator(String clusterOid, String familyOid, String typeOid) throws R01MConfigLoadException {
        Map<String, R01MContentCluster> clusters = null;
        if (clusterOid == null) {
            clusters = R01MClientFactory.getTypologyConfigAPI().getAllClusterConfig();
        } else {
            clusters = new HashMap<String, R01MContentCluster>(1);
            clusters.put(clusterOid, R01MClientFactory.getTypologyConfigAPI().getClusterConfig(clusterOid));
        }
        if (clusters != null) {
            for (Map.Entry<String, R01MContentCluster> meCluster : clusters.entrySet()) {
                R01MContentCluster cluster = meCluster.getValue();
                this._list.addLast(cluster);
                Map<String, R01MContentFamily> families = null;
                if (familyOid == null) {
                    families = cluster.getFamilies();
                } else {
                    families = new HashMap<String, R01MContentFamily>(1);
                    families.put(familyOid, R01MClientFactory.getTypologyConfigAPI().getFamilyConfig(clusterOid, familyOid));
                }
                if (families == null) continue;
                for (Map.Entry<String, R01MContentFamily> meFamily : families.entrySet()) {
                    R01MContentFamily family = meFamily.getValue();
                    this._list.addLast(family);
                    Map<String, R01MContentType> types = null;
                    if (typeOid == null) {
                        types = family.getTypes();
                    } else {
                        types = new HashMap<String, R01MContentType>(1);
                        types.put(typeOid, R01MClientFactory.getTypologyConfigAPI().getTypeConfig(clusterOid, familyOid, typeOid));
                    }
                    if (types == null) continue;
                    for (Map.Entry<String, R01MContentType> meType : types.entrySet()) {
                        R01MContentType type = meType.getValue();
                        this._list.addLast(type);
                    }
                }
            }
        }
        if (!this._list.isEmpty()) {
            this._listIndex = 0;
        }
    }

    @Override
    public boolean hasNext() {
        if (this._list != null) {
            return this._listIndex < this._list.size();
        }
        return false;
    }

    public Object next() {
        if (this.hasNext()) {
            return this._list.get(this._listIndex++);
        }
        throw new IndexOutOfBoundsException("NO hay mas elementos en la lista index=" + this._listIndex + " : listSize=" + this._list.size());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("NO se soporta la operaci\u00f3n remove() en el objeto R01MContentManagerTypologyIterator");
    }
}

