/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.utils.contentmanager;

import com.ejie.r01m.config.objects.storage.R01MArea;
import com.ejie.r01m.config.objects.storage.R01MDataRepository;
import com.ejie.r01m.config.objects.storage.R01MServer;
import com.ejie.r01m.config.objects.storage.R01MWorkArea;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.services.R01MClientFactory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class R01MContentManagerStorageIterator
implements Iterator,
Serializable {
    private static final long serialVersionUID = 2924739823968422093L;
    LinkedList _list = new LinkedList();
    int _listIndex = -1;

    public R01MContentManagerStorageIterator() throws R01MConfigLoadException {
        this._initIterator(null, null, null, null);
    }

    public R01MContentManagerStorageIterator(String serverOid, String dataStoreOid, String areaOid, String workAreaOid) throws R01MConfigLoadException {
        this._initIterator(serverOid, dataStoreOid, areaOid, workAreaOid);
    }

    private void _initIterator(String serverOid, String dataStoreOid, String areaOid, String workAreaOid) throws R01MConfigLoadException {
        Map<String, R01MServer> servers = null;
        if (serverOid == null) {
            servers = R01MClientFactory.getStorageConfigAPI().getAllServerConfig();
        } else {
            servers = new HashMap<String, R01MServer>(1);
            servers.put(serverOid, R01MClientFactory.getStorageConfigAPI().getServerConfig(serverOid));
        }
        if (servers != null) {
            for (Map.Entry<String, R01MServer> meServer : servers.entrySet()) {
                R01MServer server = meServer.getValue();
                this._list.addLast(server);
                Map<String, R01MDataRepository> repositorios = null;
                if (dataStoreOid == null) {
                    repositorios = server.getDataRepositories();
                } else {
                    repositorios = new HashMap<String, R01MDataRepository>(1);
                    repositorios.put(dataStoreOid, R01MClientFactory.getStorageConfigAPI().getDataRepositoryConfig(serverOid, dataStoreOid));
                }
                if (repositorios == null) continue;
                for (Map.Entry<String, R01MDataRepository> meRepository : repositorios.entrySet()) {
                    R01MDataRepository repository = meRepository.getValue();
                    this._list.addLast(repository);
                    Map<String, R01MArea> areas = null;
                    if (areaOid == null) {
                        areas = repository.getAreas();
                    } else {
                        areas = new HashMap<String, R01MArea>(1);
                        areas.put(areaOid, R01MClientFactory.getStorageConfigAPI().getAreaConfig(serverOid, dataStoreOid, areaOid));
                    }
                    if (areas == null) continue;
                    for (Map.Entry<String, R01MArea> meArea : areas.entrySet()) {
                        R01MArea area = meArea.getValue();
                        this._list.addLast(area);
                        Map<String, R01MWorkArea> workareas = null;
                        if (workAreaOid == null) {
                            workareas = area.getWorkAreas();
                        } else {
                            workareas = new HashMap<String, R01MWorkArea>(1);
                            workareas.put(workAreaOid, R01MClientFactory.getStorageConfigAPI().getWorkAreaConfig(serverOid, dataStoreOid, areaOid, workAreaOid));
                        }
                        if (workareas == null) continue;
                        for (Map.Entry<String, R01MWorkArea> meWorkarea : workareas.entrySet()) {
                            R01MWorkArea workarea = meWorkarea.getValue();
                            this._list.addLast(workarea);
                        }
                    }
                }
            }
        }
        if (this._list.size() > 0) {
            this._listIndex = 0;
        }
    }

    @Override
    public boolean hasNext() {
        if (this._list != null) {
            return this._listIndex < this._list.size();
        }
        return false;
    }

    public Object next() {
        if (this.hasNext()) {
            return this._list.get(this._listIndex++);
        }
        throw new IndexOutOfBoundsException("NO hay mas elementos en la lista index=" + this._listIndex + " : listSize=" + this._list.size());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("NO se soporta la operaci\u00f3n remove() en el objeto R01MContentManagerStorageIterator");
    }
}

