/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.utils.catalog;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.exceptions.R01MCatalogElementNotFoundException;
import com.ejie.r01m.exceptions.R01MCatalogException;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.cataloguing.R01MStructureCatalog;
import com.ejie.r01m.objects.cataloguing.structures.R01MLabel;
import com.ejie.r01m.objects.cataloguing.structures.R01MStructure;
import com.ejie.r01m.objects.cataloguing.structures.R01MStructureDefinition;
import com.ejie.r01m.objects.cataloguing.structures.R01MStructureItem;
import com.ejie.r01m.services.R01MCatalogManagerAPI;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MContentModelAPI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class R01MCatalogUtils {
    public static boolean existCatalogInList(R01MStructureCatalog catalog, List<R01MStructureCatalog> catalogList) {
        boolean existsLabel = false;
        if (catalogList != null && !catalogList.isEmpty() && catalog != null) {
            for (R01MStructureCatalog currLabel : catalogList) {
                if (currLabel.getStructureOid() == null || catalog.getStructureOid() == null || !currLabel.getStructureOid().equals(catalog.getStructureOid()) || currLabel.getOid() == null || catalog.getOid() == null || !currLabel.getOid().equals(catalog.getOid()) || currLabel.getRole() == null || catalog.getRole() == null || !currLabel.getRole().equals(catalog.getRole())) continue;
                existsLabel = true;
            }
        }
        return existsLabel;
    }

    public static List<R01MStructureCatalog> removeCatalogFromList(R01MStructureCatalog catalog, List<R01MStructureCatalog> catalogList) {
        ArrayList<R01MStructureCatalog> returnList = new ArrayList<R01MStructureCatalog>();
        if (catalogList != null && !catalogList.isEmpty() && catalog != null) {
            for (R01MStructureCatalog currLabel : catalogList) {
                if (currLabel.getStructureOid().equals(catalog.getStructureOid()) && currLabel.getOid().equals(catalog.getOid()) && currLabel.getRole().equals(catalog.getRole())) continue;
                returnList.add(currLabel);
            }
        } else {
            return catalogList;
        }
        return returnList;
    }

    public static List<R01MStructureCatalog> getStructuresConfig(String propXPath) {
        try {
            return R01MClientFactory.getCatalogAPI(null).getStructuresConfig(propXPath);
        }
        catch (R01MCatalogException ex) {
            R01FLog.to((String)"r01m.catalogAPI").warning("Error al obtener la configuraci\u00f3n de las estructuras en el path: " + propXPath);
            return null;
        }
    }

    public static StringBuffer getLabelFormatted(String structureOid, String labelOid, String lang) {
        StringBuffer labelFmt = new StringBuffer();
        R01MCatalogManagerAPI catalogApi = null;
        R01MLabel label = null;
        R01MStructureDefinition structureDefinition = null;
        R01MStructure structure = null;
        StringBuffer structurePath = new StringBuffer(500);
        try {
            catalogApi = R01MClientFactory.getCatalogAPI(R01MAuthManager.createMasterSystemUserContext());
            structure = catalogApi.loadStructure(structureOid);
            Collection branch = structure.findLabel(labelOid);
            label = catalogApi.loadLabel(labelOid);
            structureDefinition = catalogApi.loadStructureDefinition(structureOid);
            if (branch != null) {
                R01MStructureItem currBranchRootItem;
                R01MStructureItem currItem = null;
                Iterator i$ = branch.iterator();
                while (i$.hasNext() && (currItem = structure.findLabelInSubBranch(currBranchRootItem = (R01MStructureItem)i$.next(), labelOid)).getChildren() != null && currItem.getChildren().size() != 0) {
                }
                if (currItem != null && currItem.getParent() != null) {
                    structurePath = R01MCatalogUtils._composeStructurePath(null, currItem.getParent(), lang, catalogApi);
                }
            }
        }
        catch (R01MCatalogElementNotFoundException ex) {
            R01FLog.to((String)"r01m.catalogAPI").warning("Error al obtener el objeto Label " + labelOid + " en la estructura " + structureOid + ". No se encuentra");
        }
        catch (R01MCatalogException ex) {
            R01FLog.to((String)"r01m.catalogAPI").warning("Error al obtener el objeto Label " + labelOid + " en la estructura " + structureOid + ".");
        }
        catch (R01MSecurityException ex) {
            R01FLog.to((String)"r01m.catalogAPI").warning("Error al obtener el objeto Label " + labelOid + " en la estructura " + structureOid + ".");
        }
        if (label != null && structureDefinition != null) {
            labelFmt.append("<span class=\"r01lCCTextoPlano\"><strong class=\"r01oStructureTitle\">[");
            labelFmt.append(structureDefinition.getName(lang));
            labelFmt.append("]:</strong>&nbsp;");
            if (!StringUtils.isEmptyStringBuffer((StringBuffer)structurePath)) {
                labelFmt.append(structurePath);
                labelFmt.append(" > ");
            }
            labelFmt.append(label.getStandarizedTermValue(lang));
            labelFmt.append("</span>");
        }
        return labelFmt;
    }

    public static Map<String, R01MLabel> getContentCatalogLabelsFromStructure(String structureXpath, String contentOid) {
        List<R01MStructureCatalog> structures;
        ConcurrentHashMap<String, R01MLabel> labelsMap = new ConcurrentHashMap<String, R01MLabel>();
        if (!(StringUtils.isEmptyString((String)structureXpath) || StringUtils.isEmptyString((String)contentOid) || (structures = R01MCatalogUtils.getStructuresConfig("structures/" + structureXpath)) == null || structures.isEmpty())) {
            for (int i = 0; i < structures.size(); ++i) {
                List<R01MStructureCatalog> labels;
                R01MContentModelAPI cmAPI;
                R01MStructureCatalog structureConfig = structures.get(i);
                String structureOid = structureConfig.getStructureOid();
                String labelRoleInStructure = structureConfig.getRole();
                if (structureOid == null || labelRoleInStructure == null) {
                    R01FLog.to((String)"r01m.catalogAPI").severe("NO se puede obtener la catalogaci\u00f3n del contenido " + contentOid + " en la estructura " + structureXpath + ":\r\nNO se han definido las propiedades structures/" + structureXpath + "/structure y structures/" + structureXpath + "/level en el fichero r01m.properties.xml que mapean el oid del eje y el rol de la etiqueta a obtener!!!");
                    return null;
                }
                R01FLog.to((String)"r01m.catalogAPI").info("Obtener la catalogaci\u00f3n del contenido " + contentOid + " en la estructura " + structureXpath);
                try {
                    cmAPI = R01MClientFactory.getContentModelAPI(R01MAuthManager.createMasterSystemUserContext());
                }
                catch (R01MSecurityException secEx) {
                    secEx.printStackTrace(System.out);
                    R01FLog.to((String)"r01m.catalogAPI").info("NO se puede obtener la catalogaci\u00f3n del contenido  " + contentOid + " en la estructura " + structureXpath + ". Error de seguridad: " + secEx.getMessage());
                    continue;
                }
                try {
                    labels = cmAPI.loadContentStructureLabels(contentOid, structureOid, labelRoleInStructure, false);
                }
                catch (R01MSecurityException secEx) {
                    secEx.printStackTrace(System.out);
                    R01FLog.to((String)"r01d.templating").info("NO se puede obtener la catalogaci\u00f3n del contenido " + contentOid + " en la estructura " + structureXpath + ". Error de seguridad: " + secEx.getMessage());
                    continue;
                }
                catch (R01MContentModelException cmEx) {
                    cmEx.printStackTrace(System.out);
                    R01FLog.to((String)"r01d.templating").info("NO se puede obtener la catalogaci\u00f3n del contenido  " + contentOid + " en la estructura " + structureXpath + ". Error del modelo,no se puede obtener las estructuras de catalogaci\u00f3n: " + cmEx.getMessage());
                    continue;
                }
                if (labels == null || labels.isEmpty()) {
                    R01FLog.to((String)"r01m.servlet").info("NO se ha podido obtener la catalogaci\u00f3n del contenido " + contentOid + "  en la estructura " + structureOid + " con el rol " + labelRoleInStructure + ". REVISAR LA CATALOGACION DEL CONTENIDO\r\nComo medida paliativa se va a intentar obtener catalogaciones en el mismo eje pero con un rol menor!!!");
                    int currLabelRoleInStructure = Integer.parseInt(labelRoleInStructure) - 1;
                    while (currLabelRoleInStructure > 0) {
                        try {
                            labels = cmAPI.loadContentStructureLabels(contentOid, structureOid, Integer.toString(currLabelRoleInStructure), false);
                        }
                        catch (R01MSecurityException secEx) {
                            secEx.printStackTrace(System.out);
                            R01FLog.to((String)"r01d.templating").info("NO se puede obtener la catalogaci\u00f3n del contenido  " + contentOid + " en la estructura " + structureXpath + ". Error de seguridad: " + secEx.getMessage());
                            continue;
                        }
                        catch (R01MContentModelException cmEx) {
                            cmEx.printStackTrace(System.out);
                            R01FLog.to((String)"r01d.templating").info("NO se puede obtener la catalogaci\u00f3n del contenido " + contentOid + " en la estructura " + structureXpath + ". Error del modelo,no se puede obtener las etiquetas de catalogaci\u00f3n: " + cmEx.getMessage());
                            continue;
                        }
                        if (labels != null && !labels.isEmpty()) break;
                        --currLabelRoleInStructure;
                    }
                }
                if (labels == null || labels.size() <= 0) continue;
                try {
                    R01MCatalogManagerAPI catAPI = R01MClientFactory.getCatalogAPI(R01MAuthManager.createMasterSystemUserContext());
                    for (R01MStructureCatalog currCat : labels) {
                        R01MLabel label;
                        try {
                            label = catAPI.loadLabel(currCat.getOid());
                        }
                        catch (R01MCatalogException catEx) {
                            catEx.printStackTrace(System.out);
                            R01FLog.to((String)"r01d.templating").info("NO se puede obtener la catalogaci\u00f3n del contenido " + contentOid + " en la estructura " + structureXpath + ". Error de catalogaci\u00f3n: " + catEx.getMessage());
                            continue;
                        }
                        String labelOid = label.getOid();
                        labelsMap.put(labelOid, label);
                    }
                    continue;
                }
                catch (R01MSecurityException e) {
                    e.printStackTrace();
                }
            }
        }
        return labelsMap;
    }

    public static Map<String, String> getContentCatalogLabelsNameFromStructure(String structureXpath, String contentOid, String lang) {
        HashMap<String, String> labelsNameMap = new HashMap<String, String>();
        Map<String, R01MLabel> labelsMap = R01MCatalogUtils.getContentCatalogLabelsFromStructure(structureXpath, contentOid);
        if (labelsMap != null && !labelsMap.isEmpty()) {
            for (R01MLabel label : labelsMap.values()) {
                String labelName = label.getStandarizedTermValue(lang);
                labelsNameMap.put(label.getOid(), labelName);
            }
        }
        return labelsNameMap;
    }

    private static StringBuffer _composeStructurePath(StringBuffer path, R01MStructureItem item, String lang, R01MCatalogManagerAPI catalogApi) {
        R01MLabel label = null;
        if (path == null) {
            path = new StringBuffer(500);
        }
        try {
            label = catalogApi.loadLabel(item.getRootLabelOid());
        }
        catch (R01MCatalogException ex) {
            R01FLog.to((String)"r01m.catalogAPI").warning("Error al obtener la etiqueta del elemento de la estructura.");
        }
        if (label != null) {
            path.insert(0, label.getStandarizedTermValue(lang));
        }
        if (item.getParent() != null) {
            path.insert(0, " / ");
            return R01MCatalogUtils._composeStructurePath(path, item.getParent(), lang, catalogApi);
        }
        return path;
    }
}

