/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.utils.cachedmanagers;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01m.config.objects.typology.R01MContentTypeMetaData;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MMetaDataManagerException;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MMetaDataManagerAPI;
import com.ejie.r01m.services.R01MTypologyConfigAPI;
import java.io.Serializable;
import java.util.WeakHashMap;

public class R01MCachedMetaDataManager
implements Serializable {
    private static final long serialVersionUID = -7581142992638751868L;
    private static WeakHashMap _metaDataValuesCache = new WeakHashMap();
    private static WeakHashMap _metaDataValuesListCache = new WeakHashMap();

    public static String[][] getMetaDataValuesAndDescriptions(String lang, String clusterOid, String familyOid, String typeOid, String metaDataOid) {
        String mdKey = lang + "_" + R01MCachedMetaDataManager._composeCacheKey(clusterOid, familyOid, typeOid, metaDataOid);
        String[][] mdValuesAndDescriptions = (String[][])_metaDataValuesListCache.get(mdKey);
        if (mdValuesAndDescriptions == null) {
            try {
                R01MTypologyConfigAPI typoAPI = R01MClientFactory.getTypologyConfigAPI();
                R01MContentTypeMetaData mdCfg = typoAPI.getContentTypeMetaData(clusterOid, familyOid, typeOid, metaDataOid);
                if (mdCfg == null || mdCfg.getValuesManager() == null) {
                    return new String[0][];
                }
                R01MMetaDataManagerAPI mdAPI = R01MClientFactory.getMetaDataManagerAPI();
                mdValuesAndDescriptions = mdAPI.loadMetaDataValuesAndDescriptions(lang, mdCfg);
                if (mdValuesAndDescriptions != null) {
                    _metaDataValuesListCache.put(mdKey, mdValuesAndDescriptions);
                }
            }
            catch (R01MConfigLoadException cfgLoadEx) {
                cfgLoadEx.printStackTrace(System.out);
                R01FLog.to((String)"r01m.util").warning("Error al obtener la descripcion de del valor del metaDato " + mdKey + ": " + cfgLoadEx.getMessage());
            }
            catch (R01MMetaDataManagerException mdEx) {
                R01FLog.to((String)"r01m.util").warning("Error al obtener las descripciones de los valores del metaDato " + mdKey + ": " + mdEx.getMessage());
            }
        }
        return mdValuesAndDescriptions;
    }

    public static String getMetaDataValueDescription(String lang, String clusterOid, String familyOid, String typeOid, String metaDataOid, String metaDataValue) {
        String mdKey = lang + "_" + R01MCachedMetaDataManager._composeCacheKey(clusterOid, familyOid, typeOid, metaDataOid) + "_" + metaDataValue;
        String mdValuesDescription = (String)_metaDataValuesCache.get(mdKey);
        if (mdValuesDescription == null) {
            try {
                R01MTypologyConfigAPI typoAPI = R01MClientFactory.getTypologyConfigAPI();
                R01MContentTypeMetaData mdCfg = typoAPI.getContentTypeMetaData(clusterOid, familyOid, typeOid, metaDataOid);
                if (mdCfg == null || mdCfg.getValuesManager() == null) {
                    return metaDataValue;
                }
                R01MMetaDataManagerAPI mdAPI = R01MClientFactory.getMetaDataManagerAPI();
                mdValuesDescription = mdAPI.loadMetaDataValueDescription(lang, mdCfg, metaDataValue);
                if (mdValuesDescription != null && mdCfg != null && mdCfg.getValuesManager() != null && mdCfg.getValuesManager().isMetaDataValuesCacheables()) {
                    _metaDataValuesCache.put(mdKey, mdValuesDescription);
                }
            }
            catch (R01MConfigLoadException cfgLoadEx) {
                cfgLoadEx.printStackTrace(System.out);
                R01FLog.to((String)"r01m.util").warning("Error al obtener la descripcion de del valor del metaDato " + mdKey + ": " + cfgLoadEx.getMessage());
            }
            catch (R01MMetaDataManagerException mdEx) {
                mdEx.printStackTrace(System.out);
                R01FLog.to((String)"r01m.util").warning("Error al obtener la descripcion de del valor del metaDato " + mdKey + ": " + mdEx.getMessage());
            }
        }
        return mdValuesDescription;
    }

    private static String _composeCacheKey(String clusterOid, String familyOid, String typeOid, String metaDataOid) {
        String clusterKey = clusterOid != null && !clusterOid.equals("null") ? clusterOid : "";
        String familyKey = familyOid != null && !familyOid.equals("null") ? familyOid : "";
        String typeKey = typeOid != null && !typeOid.equals("null") ? typeOid : "";
        String metaDataKey = metaDataOid != null && !metaDataOid.equals("null") ? metaDataOid : "";
        String key = "";
        if (clusterKey.length() > 0) {
            key = key + clusterKey;
        }
        if (key.length() > 0 && familyKey.length() > 0) {
            key = key + "." + familyKey;
        } else if (familyKey.length() > 0) {
            key = key + familyKey;
        }
        key = key.length() > 0 && typeKey.length() > 0 ? key + "." + typeKey : key + typeKey;
        key = key.length() > 0 && metaDataKey.length() > 0 ? key + "." + metaDataKey : key + metaDataKey;
        return key;
    }
}

