/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.utils.cachedmanagers;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.exceptions.R01MCatalogException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.cataloguing.structures.R01MLabel;
import com.ejie.r01m.objects.cataloguing.structures.R01MTerm;
import com.ejie.r01m.services.R01MClientFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class R01MCachedCatalogLabelsManager
implements Serializable {
    private static final long serialVersionUID = -7581142992638751868L;

    public static R01MLabel getLabel(String labelOid) {
        R01MLabel label = null;
        try {
            label = R01MClientFactory.getCatalogAPI(R01MAuthManager.createMasterSystemUserContext()).loadLabel(labelOid, false);
        }
        catch (R01MSecurityException secEx) {
            R01FLog.to((String)"r01m.search").warning("Error de seguridad al obtener la etiqueta " + labelOid + ": " + secEx.getMessage());
        }
        catch (R01MCatalogException catEx) {
            R01FLog.to((String)"r01m.search").warning("Error al obtener la etiqueta " + labelOid + ": " + catEx.getMessage());
        }
        return label;
    }

    public static Map<String, String> getStructureLabelStandarizedTerms(String labelOid) {
        HashMap<String, String> descs = null;
        R01MLabel label = null;
        try {
            label = R01MClientFactory.getCatalogAPI(R01MAuthManager.createMasterSystemUserContext()).loadLabel(labelOid, false);
        }
        catch (R01MSecurityException secEx) {
            R01FLog.to((String)"r01m.search").warning("Error de seguridad al obtener la etiqueta " + labelOid + ": " + secEx.getMessage());
        }
        catch (R01MCatalogException catEx) {
            R01FLog.to((String)"r01m.search").warning("Error al obtener la etiqueta " + labelOid + ": " + catEx.getMessage());
        }
        if (label != null) {
            descs = new HashMap<String, String>();
            if (label.getStandardizedTerms() != null) {
                for (R01MTerm currTerm : label.getStandardizedTerms().values()) {
                    descs.put(currTerm.getLanguage(), currTerm.getValue());
                }
            }
        } else {
            R01FLog.to((String)"r01m.search").warning("No se ha encontrado las descripciones para la etiqueta " + labelOid);
        }
        return descs;
    }

    public static List<String[]> getStructureLabelTerms(String labelOid) {
        ArrayList<String[]> terms = null;
        R01MLabel label = null;
        try {
            label = R01MClientFactory.getCatalogAPI(R01MAuthManager.createMasterSystemUserContext()).loadLabel(labelOid, false);
        }
        catch (R01MSecurityException secEx) {
            R01FLog.to((String)"r01m.search").warning("Error de seguridad al obtener la etiqueta " + labelOid + ": " + secEx.getMessage());
        }
        catch (R01MCatalogException catEx) {
            R01FLog.to((String)"r01m.search").warning("Error al obtener la etiqueta " + labelOid + ": " + catEx.getMessage());
        }
        if (label != null) {
            terms = new ArrayList<String[]>();
            String[] outTerm = null;
            if (label.getStandardizedTerms() != null) {
                for (R01MTerm currTerm : label.getStandardizedTerms().values()) {
                    outTerm = new String[]{currTerm.getLanguage(), currTerm.getValue()};
                    terms.add(outTerm);
                }
            }
            if (label.getLanguageSynonyms() != null) {
                List currSyns = null;
                for (Object synonym : label.getLanguageSynonyms().values()) {
                    if (currSyns == null) continue;
                    if (synonym instanceof R01MTerm) {
                        R01MTerm currTerm = (R01MTerm)synonym;
                        outTerm = new String[]{currTerm.getLanguage(), currTerm.getValue()};
                        terms.add(outTerm);
                        continue;
                    }
                    if (!(synonym instanceof List)) continue;
                    currSyns = (List)synonym;
                    for (R01MTerm currTerm : currSyns) {
                        outTerm = new String[]{currTerm.getLanguage(), currTerm.getValue()};
                        terms.add(outTerm);
                    }
                }
            }
        } else {
            R01FLog.to((String)"r01m.search").warning("No se ha encontrado los terminos para la etiqueta " + labelOid);
        }
        return terms;
    }

    public static Map getGeoLabelStandarizedTerms(String geoAxisOid, String labelOid) {
        return null;
    }

    public static List getGeoLabelTerms(String geoAxisOid, String labelOid) {
        return null;
    }
}

