/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.utils;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.config.objects.publisher.R01MLogicalPublicationInfo;
import com.ejie.r01m.config.objects.publisher.R01MPublisherDestinationSystem;
import com.ejie.r01m.config.objects.typologymanagement.R01MContentTypeManagementConfig;
import com.ejie.r01m.config.objects.typologymanagement.R01MContentTypeTemplateConfig;
import com.ejie.r01m.config.objects.typologymanagement.R01MTypologyManagementConfig;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.objects.R01MBaseLocationObject;
import com.ejie.r01m.objects.contentmodel.R01MContentTypologyInfo;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MPublisherConfigAPI;
import com.ejie.r01m.services.R01MStorageConfigAPI;
import com.ejie.r01m.services.R01MTypologyConfigAPI;
import com.ejie.r01m.services.R01MTypologyManagementConfigAPI;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;

public class R01MVariables
implements Serializable {
    private static final long serialVersionUID = 6897792550762821291L;
    private static R01MStorageConfigAPI storageAPI = R01MClientFactory.getStorageConfigAPI();
    private static R01MTypologyConfigAPI typoAPI = R01MClientFactory.getTypologyConfigAPI();
    private static R01MTypologyManagementConfigAPI typoMgmtAPI = R01MClientFactory.getTypologyManagementConfigAPI();
    private static R01MPublisherConfigAPI publisherAPI = R01MClientFactory.getPublisherConfigAPI();
    public static final String VAR_LANG = "ui.lang";
    public static final String VAR_CONTEXT = "ui.contextOid";
    public static final String VAR_PUBLISHTARGET_OID = "publishTarget.oid";
    public static final String VAR_PUBLISHTARGET_INTERNAL_NAME = "publishTarget.internalName";
    public static final String VAR_PUBLISHTARGET_ALIAS = "publishTarget.alias";
    public static final String VAR_CONTENT_OID = "model.contentOid";
    public static final String VAR_CONTENT_INTERNAL_NAME = "model.contentInternalName";
    public static final String VAR_CONTENT_NAME = "model.contentName";
    public static final String VAR_DOCUMENT_OID = "model.documentOid";
    public static final String VAR_DOCUMENT_LANGUAGE = "model.documentLanguage";
    public static final String VAR_DOCUMENT_INTERNAL_NAME = "model.documentInternalName";
    public static final String VAR_FILE_OID = "model.fileOid";
    public static final String VAR_FILE_INTERNAL_NAME = "model.fileInternalName";
    public static final String VAR_FILE_NAME = "model.fileName";
    public static final String VAR_GENERATED_FILE_NAME = "model.generatedFileName";
    public static final String VAR_STORAGE_SERVER_OID = "storage.serverOid";
    public static final String VAR_STORAGE_SERVER_INTERNAL_NAME = "storage.serverInternalName";
    public static final String VAR_STORAGE_DATASTORE_OID = "storage.dataStore";
    public static final String VAR_STORAGE_DATASTORE_INTERNAL_NAME = "storage.dataStoreInternalName";
    public static final String VAR_STORAGE_AREA_OID = "storage.area";
    public static final String VAR_STORAGE_AREA_INTERNAL_NAME = "storage.areaInternalName";
    public static final String VAR_STORAGE_WORKAREA_OID = "storage.workareaOid";
    public static final String VAR_STORAGE_WORKAREA_INTERNAL_NAME = "storage.workAreaInternalName";
    public static final String VAR_TYPO_CLUSTER_OID = "typo.clusterOid";
    public static final String VAR_TYPO_CLUSTER_INTERNAL_NAME = "typo.clusterInternalName";
    public static final String VAR_TYPO_FAMILY_OID = "typo.familyOid";
    public static final String VAR_TYPO_FAMILY_INTERNAL_NAME = "typo.familyInternalName";
    public static final String VAR_TYPO_TYPE_OID = "typo.contentTypeOid";
    public static final String VAR_TYPO_TYPE_CATEGORY = "typo.typeCategory";
    public static final String VAR_TYPO_TYPE_INTERNAL_NAME = "typo.typeInternalName";
    public static final String VAR_TEMPLATE_OID = "template.oid";
    public static final String VAR_TEMPLATE_INTERNAL_NAME = "template.internalName";
    public static final String VAR_TEMPLATE_CATEGORY = "template.category";
    public static final String VAR_PRESENTATIONTEMPLATE_OID = "presentationTemplate.oid";
    public static final String VAR_PRESENTATIONTEMPLATE_INSTANCEID = "presentationTemplate.instanceId";
    public static final String VAR_PORTAL_OID = "portal.portalOid";
    public static final String VAR_PORTALPAGE_OID = "portal.pageOid";
    public static final String VAR_PORTALPAGE_INTERNAL_NAME = "portal.pageInternalName";
    public static final String VAR_PORTALPAGE_LANGUAGE = "portal.pageLanguage";
    public static final String VAR_PORTALPAGEAV_OID = "portal.pageAVOid";
    public static final String VAR_PORTALPAGEAV_TYPE = "portal.pageAVType";
    public static final String VAR_PORTALPAGEAV_INTERNAL_NAME = "portal.pageAVInternalName";
    public static final String VAR_PORTALPAGEAV_LANGUAGE = "portal.pageAVLanguage";

    public static Properties composeVariableParams(String lang, String uiContextOid, R01MBaseLocationObject storageInfo, R01MContentTypologyInfo typoInfo, String contentOid, String contentInternalName, String contentName, String documentOid, String documentLanguage, String documentInternalName, String fileOid, String fileInternalName, String fileName, String templateOid, String presentationTemplateOid, String presentationTemplateInstanceId, String generatedFileName, String logicalPublicationTargetOid, String publishTargetOid) {
        Properties p = new Properties();
        if (lang != null) {
            p.put(VAR_LANG, lang);
        }
        if (uiContextOid != null) {
            p.put(VAR_CONTEXT, uiContextOid);
        }
        if (contentOid != null) {
            p.put(VAR_CONTENT_OID, contentOid);
        }
        if (contentInternalName != null) {
            p.put(VAR_CONTENT_INTERNAL_NAME, contentInternalName);
        }
        if (contentName != null) {
            p.put(VAR_CONTENT_NAME, contentName);
        }
        if (documentOid != null) {
            p.put(VAR_DOCUMENT_OID, documentOid);
        }
        if (documentInternalName != null) {
            p.put(VAR_DOCUMENT_INTERNAL_NAME, documentInternalName);
        }
        if (documentLanguage != null) {
            p.put(VAR_DOCUMENT_LANGUAGE, documentLanguage);
        }
        if (fileOid != null) {
            p.put(VAR_FILE_OID, fileOid);
        }
        if (fileInternalName != null) {
            p.put(VAR_FILE_INTERNAL_NAME, fileInternalName);
        }
        if (fileName != null) {
            p.put(VAR_FILE_NAME, fileName);
        }
        try {
            Properties pP;
            Properties tP;
            Properties sP = R01MVariables._composeStorageVariableParams(storageInfo);
            if (sP != null) {
                p.putAll((Map<?, ?>)sP);
            }
            if ((tP = R01MVariables._composeTypoVariableParams(typoInfo)) != null) {
                p.putAll((Map<?, ?>)tP);
            }
            if (templateOid != null) {
                p.put(VAR_TEMPLATE_OID, templateOid);
                if (storageInfo != null && storageInfo.getServerOid() != null && storageInfo.getDataRepositoryOid() != null && typoMgmtAPI.getTypologyManagementConfig(storageInfo.getServerOid(), storageInfo.getDataRepositoryOid()) != null) {
                    R01MTypologyManagementConfig cfg = typoMgmtAPI.getTypologyManagementConfig(storageInfo.getServerOid(), storageInfo.getDataRepositoryOid());
                    R01MContentTypeManagementConfig typeCfg = (R01MContentTypeManagementConfig)cfg.getTypes().get(typoInfo.getTypeOid());
                    R01MContentTypeTemplateConfig templateCfg = (R01MContentTypeTemplateConfig)typeCfg.getTemplates().get(templateOid);
                    if (templateCfg != null) {
                        p.put(VAR_TEMPLATE_INTERNAL_NAME, templateCfg.getInternalName());
                        p.put(VAR_TEMPLATE_CATEGORY, templateCfg.getCategory());
                    } else {
                        p.put(VAR_TEMPLATE_INTERNAL_NAME, "error");
                        p.put(VAR_TEMPLATE_CATEGORY, "error");
                    }
                }
            }
            if (presentationTemplateOid != null) {
                p.put(VAR_PRESENTATIONTEMPLATE_OID, presentationTemplateOid);
            }
            if (presentationTemplateInstanceId != null) {
                p.put(VAR_PRESENTATIONTEMPLATE_INSTANCEID, presentationTemplateInstanceId);
            }
            if (generatedFileName != null) {
                p.put(VAR_GENERATED_FILE_NAME, generatedFileName);
            }
            if ((pP = R01MVariables._composePubVariableParams(logicalPublicationTargetOid, publishTargetOid)) != null) {
                p.putAll((Map<?, ?>)pP);
            }
        }
        catch (R01MConfigLoadException clEx) {
            R01FLog.to((String)"r01m.config").severe("Error al obtener datos de configuracion: " + clEx.getMessage());
        }
        return p;
    }

    public static Properties composePortalVariableParams(String lang, String uiContextOid, R01MBaseLocationObject storageInfo, String portalOid, String pageOid, String pageInternalName, String pageLang, String logicalPublicationTargetOid, String publishTargetOid) {
        Properties pP;
        Properties sP;
        Properties p = new Properties();
        if (lang != null) {
            p.put(VAR_LANG, lang);
        }
        if (uiContextOid != null) {
            p.put(VAR_CONTEXT, uiContextOid);
        }
        if (portalOid != null) {
            p.put(VAR_PORTAL_OID, portalOid);
        }
        if (pageOid != null) {
            p.put(VAR_PORTALPAGE_OID, pageOid);
        }
        if (pageInternalName != null) {
            p.put(VAR_PORTALPAGE_INTERNAL_NAME, pageInternalName);
        }
        if (pageLang != null) {
            p.put(VAR_PORTALPAGE_LANGUAGE, pageLang);
        }
        if ((sP = R01MVariables._composeStorageVariableParams(storageInfo)) != null) {
            p.putAll((Map<?, ?>)sP);
        }
        if ((pP = R01MVariables._composePubVariableParams(logicalPublicationTargetOid, publishTargetOid)) != null) {
            p.putAll((Map<?, ?>)pP);
        }
        return p;
    }

    private static Properties _composeStorageVariableParams(R01MBaseLocationObject storageInfo) {
        try {
            if (storageInfo != null) {
                Properties p = new Properties();
                if (storageInfo.getServerOid() != null) {
                    p.put(VAR_STORAGE_SERVER_OID, storageInfo.getServerOid());
                    if (storageInfo.getServerOid() != null && storageAPI.getServerConfig(storageInfo.getServerOid()) != null) {
                        p.put(VAR_STORAGE_SERVER_INTERNAL_NAME, storageAPI.getServerConfig(storageInfo.getServerOid()).getInternalName());
                    }
                }
                if (storageInfo.getDataRepositoryOid() != null) {
                    p.put(VAR_STORAGE_DATASTORE_OID, storageInfo.getDataRepositoryOid());
                    if (storageInfo.getServerOid() != null && storageInfo.getDataRepositoryOid() != null && storageAPI.getDataRepositoryConfig(storageInfo.getServerOid(), storageInfo.getDataRepositoryOid()) != null) {
                        p.put(VAR_STORAGE_DATASTORE_INTERNAL_NAME, storageAPI.getDataRepositoryConfig(storageInfo.getServerOid(), storageInfo.getDataRepositoryOid()).getInternalName());
                    }
                }
                if (storageInfo.getAreaOid() != null) {
                    p.put(VAR_STORAGE_AREA_OID, storageInfo.getAreaOid());
                    if (storageInfo.getServerOid() != null && storageInfo.getDataRepositoryOid() != null && storageInfo.getAreaOid() != null && storageAPI.getAreaConfig(storageInfo.getServerOid(), storageInfo.getDataRepositoryOid(), storageInfo.getAreaOid()) != null) {
                        p.put(VAR_STORAGE_AREA_INTERNAL_NAME, storageAPI.getAreaConfig(storageInfo.getServerOid(), storageInfo.getDataRepositoryOid(), storageInfo.getAreaOid()).getInternalName());
                    }
                }
                if (storageInfo.getWorkAreaOid() != null) {
                    p.put(VAR_STORAGE_WORKAREA_OID, storageInfo.getWorkAreaOid());
                    if (storageInfo.getServerOid() != null && storageInfo.getDataRepositoryOid() != null && storageInfo.getAreaOid() != null && storageInfo.getWorkAreaOid() != null && storageAPI.getWorkAreaConfig(storageInfo.getServerOid(), storageInfo.getDataRepositoryOid(), storageInfo.getAreaOid(), storageInfo.getWorkAreaOid()) != null) {
                        p.put(VAR_STORAGE_WORKAREA_INTERNAL_NAME, storageAPI.getWorkAreaConfig(storageInfo.getServerOid(), storageInfo.getDataRepositoryOid(), storageInfo.getAreaOid(), storageInfo.getWorkAreaOid()).getInternalName());
                    }
                }
                return p;
            }
        }
        catch (R01MConfigLoadException clEx) {
            R01FLog.to((String)"r01m.config").severe("Error al obtener datos de configuracion: " + clEx.getMessage());
        }
        return null;
    }

    private static Properties _composeTypoVariableParams(R01MContentTypologyInfo typoInfo) {
        try {
            if (typoInfo != null) {
                Properties p = new Properties();
                if (typoInfo.getClusterOid() != null) {
                    p.put(VAR_TYPO_CLUSTER_OID, typoInfo.getClusterOid());
                    if (typoInfo.getClusterOid() != null && typoAPI.getClusterConfig(typoInfo.getClusterOid()) != null) {
                        p.put(VAR_TYPO_CLUSTER_INTERNAL_NAME, typoAPI.getClusterConfig(typoInfo.getClusterOid()).getInternalName());
                    } else {
                        p.put(VAR_TYPO_CLUSTER_INTERNAL_NAME, "error");
                    }
                }
                if (typoInfo.getClusterOid() != null) {
                    p.put(VAR_TYPO_FAMILY_OID, typoInfo.getFamilyOid());
                    if (typoInfo.getClusterOid() != null && typoInfo.getFamilyOid() != null && typoAPI.getFamilyConfig(typoInfo.getClusterOid(), typoInfo.getFamilyOid()) != null) {
                        p.put(VAR_TYPO_FAMILY_INTERNAL_NAME, typoAPI.getFamilyConfig(typoInfo.getClusterOid(), typoInfo.getFamilyOid()).getInternalName());
                    } else {
                        p.put(VAR_TYPO_FAMILY_INTERNAL_NAME, "error");
                    }
                }
                if (typoInfo.getClusterOid() != null) {
                    p.put(VAR_TYPO_TYPE_OID, typoInfo.getTypeOid());
                    if (typoInfo.getClusterOid() != null && typoInfo.getFamilyOid() != null && typoInfo.getTypeOid() != null && typoAPI.getTypeConfig(typoInfo.getClusterOid(), typoInfo.getFamilyOid(), typoInfo.getTypeOid()) != null) {
                        p.put(VAR_TYPO_TYPE_INTERNAL_NAME, typoAPI.getTypeConfig(typoInfo.getClusterOid(), typoInfo.getFamilyOid(), typoInfo.getTypeOid()).getInternalName());
                        p.put(VAR_TYPO_TYPE_CATEGORY, typoAPI.getTypeConfig(typoInfo.getClusterOid(), typoInfo.getFamilyOid(), typoInfo.getTypeOid()).getCategory());
                    } else {
                        p.put(VAR_TYPO_TYPE_INTERNAL_NAME, "error");
                        p.put(VAR_TYPO_TYPE_CATEGORY, "error");
                    }
                }
                return p;
            }
        }
        catch (R01MConfigLoadException clEx) {
            R01FLog.to((String)"r01m.config").severe("Error al obtener datos de configuracion: " + clEx.getMessage());
        }
        return null;
    }

    private static Properties _composePubVariableParams(String logicalPublicationTargetOid, String publishTargetOid) {
        try {
            if (publishTargetOid != null) {
                R01MLogicalPublicationInfo logicaldest;
                Properties p = new Properties();
                p.put(VAR_PUBLISHTARGET_OID, publishTargetOid);
                R01MPublisherDestinationSystem dest = publisherAPI.getDestinationSystemConfig(publishTargetOid);
                if (publishTargetOid != null && dest != null && dest.getInternalname() != null) {
                    p.put(VAR_PUBLISHTARGET_INTERNAL_NAME, dest.getInternalname());
                }
                if (logicalPublicationTargetOid != null && (logicaldest = publisherAPI.getLogicalPublicationConfig(logicalPublicationTargetOid)) != null && logicaldest.getContentAlias() != null) {
                    p.put(VAR_PUBLISHTARGET_ALIAS, logicaldest.getContentAlias());
                }
                return p;
            }
        }
        catch (R01MConfigLoadException clEx) {
            R01FLog.to((String)"r01m.config").severe("Error al obtener datos de configuracion: " + clEx.getMessage());
        }
        return null;
    }

    public static String customize(String txt, Properties vars) {
        if (txt == null) {
            return null;
        }
        if (vars == null) {
            return txt;
        }
        return StringUtils.replaceVariableValues((String)txt, (char)'$', (Map)vars);
    }
}

