/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.utils;

import com.ejie.r01f.file.ResourcesLoader;
import com.ejie.r01f.guids.GUIDDispenserDef;
import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01f.guids.GUIDDispenserManager;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.utils.R01MConstants;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class R01MUtils
implements Serializable {
    private static final long serialVersionUID = -6911454312452044334L;
    private static Map _langResourcesCache = new HashMap(5);

    public static String generateNewOid(String appCode) throws GUIDDispenserException {
        return R01MUtils.generateNewOid(appCode, "default");
    }

    public static String generateNewOid(String appCode, String seq) throws GUIDDispenserException {
        GUIDDispenserDef dispDef = new GUIDDispenserDef();
        if (appCode.startsWith("r01")) {
            dispDef.loadConfig(R01MConstants.API_APPCODE, seq);
        } else {
            dispDef.loadConfig(appCode, seq);
        }
        dispDef.setAppCode(appCode);
        String oid = GUIDDispenserManager.createDispenser((GUIDDispenserDef)dispDef).getGUID();
        R01FLog.to((String)"r01m.util").info("Generando oid %%%%%%%% " + oid + " %%%%%%%%");
        return oid;
    }

    public static String shortString(String str, int len) {
        if (str != null && str.trim().length() > len) {
            return str.trim().substring(0, len) + "...";
        }
        return str;
    }

    public static String encodeApostrophe(String cadena) {
        if (cadena == null) {
            return cadena;
        }
        return cadena.replaceAll("'", "&#39;");
    }

    public static String obtainEncoding(String cadena) {
        Pattern p;
        Matcher m;
        String regEx = ".*(?:%C3%81|%C3%80|%C3%82|%C3%84|%C3%83|%C3%85|%C3%89|%C3%8A|%C3%8B|%C3%88|%C3%8D|%C3%8C|%C3%8E|%C3%8F|%C3%93|%C3%92|%C3%94|%C3%96|%C3%95|%C3%9A|%C3%99|%C3%9B|%C3%9C|%C3%A1|%C3%A0|%C3%A2|%C3%A4|%C3%A3|%C3%A5|%C3%A9|%C3%A8|%C3%AA|%C3%AB|%C3%AD|%C3%AC|%C3%AE|%C3%AF|%C3%B3|%C3%B2|%C3%B4|%C3%B6|%C3%B5|%C3%BA|%C3%B9|%C3%BB|%C3%BC|%C3%B1|%C3%91|%C3%A7|%C3%87|%C2%A3|%E2%82%AC).*";
        if (!StringUtils.isEmptyString((String)cadena) && ((m = (p = Pattern.compile(regEx)).matcher(cadena)).matches() || cadena.indexOf(37) < 0)) {
            return "UTF-8";
        }
        return "ISO-8859-1";
    }

    public static String composeDebugInfoOfMap(Map mapa) {
        String result = "Resultado del Mapa:";
        if (mapa != null) {
            for (Map.Entry me : mapa.entrySet()) {
                result = result + "\n\t Clave(" + me.getKey().toString() + "), Valor(" + me.getValue().toString() + ")";
            }
        }
        return result;
    }

    public static String getLiteral(String appCode, String module, String lang, String literalKey) {
        if (lang.length() == 2 && R01MConstants.DOCUMENT_ALLOWED_LANGS.toString().indexOf(lang) > 0) {
            Properties langResources = (Properties)_langResourcesCache.get(module + "_" + lang);
            if (langResources == null) {
                langResources = R01MUtils._loadLanguageResourceFile(appCode, module, lang);
            }
            String outLit = langResources != null && literalKey != null ? langResources.getProperty(literalKey) : null;
            return outLit != null ? outLit : "";
        }
        return "";
    }

    private static Properties _loadLanguageResourceFile(String appCode, String module, String lang) {
        try {
            Properties outProps = null;
            if (_langResourcesCache != null) {
                outProps = (Properties)_langResourcesCache.get(module + "_" + lang);
            }
            if (outProps == null) {
                outProps = new Properties();
                String languageResource = XMLProperties.getProperty((String)appCode, (String)(module + "/" + lang));
                if (languageResource == null) {
                    R01FLog.to((String)"r01m.util").severe("NO se ha definido la propiedad " + appCode + "/" + module + "/" + lang + " donde se referencia el nombre del fichero de recursos de idioma!!!.\r\nREVISA EL FICHERO DE PROPIEDADES DE " + appCode);
                    languageResource = "/html/datos/" + module + "/aa_" + module + "_" + lang + ".properties";
                }
                try {
                    outProps.load(ResourcesLoader.getResourceFileAsStream((String)languageResource));
                    _langResourcesCache.put(module + "_" + lang, outProps);
                }
                catch (IOException e) {
                    languageResource = "/html/datos/" + module + "/aa_" + module + "_" + R01MConstants.DEFAULT_LANG + ".properties";
                    outProps.load(ResourcesLoader.getResourceFileAsStream((String)languageResource));
                    _langResourcesCache.put(module + "_" + lang, outProps);
                }
            }
            return outProps;
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
            R01FLog.to((String)"r01m.util").severe("Error cargando ficheros de idiomas: " + e.toString());
            return new Properties();
        }
    }
}

