/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.utils;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.config.objects.publisher.R01MLogicalPublicationInfo;
import com.ejie.r01m.config.objects.storage.R01MServer;
import com.ejie.r01m.config.objects.typologymanagement.R01MContentTypeTemplateConfig;
import com.ejie.r01m.config.objects.typologymanagement.R01MPresentationTemplateConfig;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MPortalModelException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.R01MBaseLocationObject;
import com.ejie.r01m.objects.R01MURLAlias;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MContentLocation;
import com.ejie.r01m.objects.contentmodel.R01MContentTypologyInfo;
import com.ejie.r01m.objects.contentmodel.R01MDataFile;
import com.ejie.r01m.objects.contentmodel.R01MDocument;
import com.ejie.r01m.objects.contentmodel.R01MDocumentPublicationTarget;
import com.ejie.r01m.objects.portalmodel.R01MPage;
import com.ejie.r01m.objects.portalmodel.R01MPortalLocation;
import com.ejie.r01m.objects.publisher.R01MPublicationDestination;
import com.ejie.r01m.objects.publisher.R01MPublish;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MContentModelAPI;
import com.ejie.r01m.services.R01MStorageConfigAPI;
import com.ejie.r01m.services.R01MTypologyManagementConfigAPI;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MVariables;
import com.ejie.r01m.utils.portal.R01MPortalPathHelpper;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class R01MURLHelpper
implements Serializable {
    private static final long serialVersionUID = 7246820496631566204L;
    private static R01MStorageConfigAPI storageAPI = R01MClientFactory.getStorageConfigAPI();
    private static R01MTypologyManagementConfigAPI typoMgmtAPI = R01MClientFactory.getTypologyManagementConfigAPI();
    private static final String LOG_TYPE_ID = "r01m.util";

    public static void reCalculateContentURLs(R01MContent content) {
        R01FLog.to((String)LOG_TYPE_ID).info("Re calculando URLs del contenido: " + content.getOid() + " (" + (content.getDocuments() != null ? content.getDocuments().size() : 0) + " documents)\r\n");
        Map<String, R01MDocument> documents = content.getDocuments();
        if (documents != null) {
            for (Map.Entry<String, R01MDocument> dMe : documents.entrySet()) {
                Map<String, R01MDataFile> datafiles;
                R01MDocument currDoc = dMe.getValue();
                R01FLog.to((String)LOG_TYPE_ID).info("\t-Documento: " + currDoc.getOid() + "(" + (currDoc.getDataFiles() != null ? currDoc.getDataFiles().size() : 0) + " dataFiles)\r\n");
                List<R01MDocumentPublicationTarget> publications = currDoc.getPublicationInfo();
                if (publications != null) {
                    for (R01MDocumentPublicationTarget pubInTargetInfo : publications) {
                        if (pubInTargetInfo.getState() == 1) {
                            Map<String, R01MDataFile> datafiles2;
                            String[] destSystemsOids;
                            String pubTargetOid = pubInTargetInfo.getOid();
                            try {
                                destSystemsOids = R01MClientFactory.getPublisherConfigAPI().getLogicalPublicationConfig(pubTargetOid).getDestinationSystemsOids();
                            }
                            catch (R01MConfigLoadException cfgLoadEx) {
                                cfgLoadEx.printStackTrace(System.out);
                                destSystemsOids = new String[]{"[error]"};
                            }
                            if ((datafiles2 = currDoc.getDataFiles()) == null || destSystemsOids == null) continue;
                            R01MDataFile datafileInitialPage = currDoc.getDocumentInitialDataFile();
                            if (datafileInitialPage != null) {
                                String publicationURL = R01MURLHelpper.getDefaultGeneratedDataFileViewURL(currDoc.getLanguage(), content.getTypo(), content.getStoreLocation(), content.getOid(), content.getName(), content.getName(), currDoc.getOid(), currDoc.getLanguage(), currDoc.getInternalName(), datafileInitialPage.getOid(), datafileInitialPage.getName(), datafileInitialPage.getName(), datafileInitialPage.getTemplateOid(), pubTargetOid, destSystemsOids[0]);
                                pubInTargetInfo.setUrl(publicationURL);
                                R01FLog.to((String)LOG_TYPE_ID).info("\t\tPublicacion destino: " + pubInTargetInfo.getOid() + " URL=" + publicationURL + "\r\n");
                                continue;
                            }
                            R01FLog.to((String)LOG_TYPE_ID).info("\t\tPublicacion destino: " + pubInTargetInfo.getOid() + " no hay archivo de inicio. No se calcula la url\r\n");
                            continue;
                        }
                        R01FLog.to((String)LOG_TYPE_ID).info("\t\tdocumento NO publicado. No se calculan URLs\r\n");
                    }
                }
                if ((datafiles = currDoc.getDataFiles()) == null) continue;
                for (Map.Entry<String, R01MDataFile> dfMe : datafiles.entrySet()) {
                    R01MDataFile currDataFile = dfMe.getValue();
                    String editURL = R01MURLHelpper.getDataFileEditionURL(null, content.getTypo(), content.getStoreLocation(), content.getOid(), content.getName(), content.getName(), currDoc.getOid(), currDoc.getLanguage(), currDoc.getInternalName(), currDataFile.getOid(), currDataFile.getName(), currDataFile.getName(), currDataFile.getTemplateOid());
                    String previewURL = R01MURLHelpper.getDefaultGeneratedDataFilePreviewURL(null, content.getTypo(), content.getStoreLocation(), content.getOid(), content.getName(), content.getName(), currDoc.getOid(), currDoc.getLanguage(), currDoc.getInternalName(), currDataFile.getOid(), currDataFile.getName(), currDataFile.getName(), currDataFile.getTemplateOid());
                    String generateURL = R01MURLHelpper.getDataFileGenerateURL(null, content.getTypo(), content.getStoreLocation(), content.getOid(), content.getName(), content.getName(), currDoc.getOid(), currDoc.getLanguage(), currDoc.getInternalName(), currDataFile.getOid(), currDataFile.getName(), currDataFile.getName(), currDataFile.getTemplateOid());
                    currDataFile.setEditUrl(editURL);
                    currDataFile.setGenerateUrl(generateURL);
                    currDataFile.setPreviewUrl(previewURL);
                    R01FLog.to((String)LOG_TYPE_ID).info("\t\t\t-dataFile :" + currDataFile.getOid() + "-");
                    R01FLog.to((String)LOG_TYPE_ID).info("Datos de composici\u00f3n de URL : content.getOid=" + content.getOid() + ",content.getName=" + content.getName() + ",document.getOid=" + currDoc.getOid() + ",document.getLanguage=" + currDoc.getLanguage() + ",document.getInternalName=" + currDoc.getInternalName() + ",datafile.getOid=" + currDataFile.getOid() + ",datafile.getName=" + currDataFile.getName() + ",datafile.getName=" + currDataFile.getName() + ",datafile.getTemplateOid=" + currDataFile.getTemplateOid() + ",typo=" + content.getTypo().composeMemoCode() + ",content.store=" + content.getStoreLocation().composeMemoCode() + "\r\n");
                    R01FLog.to((String)LOG_TYPE_ID).info("\t\t\t\tUrl de edici\u00f3n =" + editURL + "\r\n");
                    R01FLog.to((String)LOG_TYPE_ID).info("\t\t\t\tUrl de preview =" + previewURL + "\r\n");
                    R01FLog.to((String)LOG_TYPE_ID).info("\t\t\t\tUrl de generacion =" + generateURL + "\r\n");
                    R01FLog.to((String)LOG_TYPE_ID).info("\t\t\t\t---OK---\r\n");
                }
            }
        }
    }

    public static String getContentServerAdministrationURL(String serverOid) {
        String outURL = null;
        try {
            R01MServer serverCfg = storageAPI.getServerConfig(serverOid);
            outURL = new String((String)serverCfg.getUrls().get("serverAdmin"));
        }
        catch (R01MConfigLoadException cfgLoadEx) {
            cfgLoadEx.printStackTrace(System.out);
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al cargar la configuracion del servidor " + serverOid + ": " + cfgLoadEx.getMessage());
        }
        return outURL;
    }

    public static String getContentEditionURL(String lang, R01MContentTypologyInfo typo, R01MContentLocation loc, String contentOid, String contentInternalName, String contentName) {
        return R01MURLHelpper._obtainServerURLPattern("contentEdit", lang, typo, loc, contentOid, contentInternalName, contentName, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public static String getDocumentEditionURL(String lang, R01MContentTypologyInfo typo, R01MContentLocation loc, String contentOid, String contentInternalName, String contentName, String documentOid, String documentLanguage, String documentInternalName) {
        return R01MURLHelpper._obtainServerURLPattern("documentEdit", lang, typo, loc, contentOid, contentInternalName, contentName, documentOid, documentLanguage, documentInternalName, null, null, null, null, null, null, null, null, null);
    }

    public static String getDocumentPreviewURL(String lang, R01MContentTypologyInfo typo, R01MContentLocation loc, String contentOid, String contentInternalName, String contentName, String documentOid, String documentLanguage, String documentInternalName, String initialDataFileOid, String initialDataFileInternalName, String initialDataFileName, String initialDataFileTemplateOid) {
        return R01MURLHelpper.getDefaultGeneratedDataFilePreviewURL(lang, typo, loc, contentOid, contentInternalName, contentName, documentOid, documentLanguage, documentInternalName, initialDataFileOid, initialDataFileInternalName, initialDataFileName, initialDataFileTemplateOid);
    }

    public static String getDocumentPublicationInRepositoryURL(R01MContent content, String documentOid, String repositoryToPublishOid) {
        R01MLogicalPublicationInfo logicalPublicationInfo;
        String documentPublishURL = "";
        try {
            logicalPublicationInfo = R01MClientFactory.getPublisherConfigAPI().getLogicalPublicationConfig(repositoryToPublishOid);
        }
        catch (R01MConfigLoadException e) {
            return documentPublishURL;
        }
        if (logicalPublicationInfo.getDestinationSystemsOids() != null && logicalPublicationInfo.getDestinationSystemsOids().length > 0) {
            R01MDocument document;
            R01MDataFile datafileInitialPage;
            R01MPublicationDestination logicalDest = new R01MPublicationDestination(logicalPublicationInfo.getDestinationSystemsOids()[0]);
            if (content.getDocuments() != null && content.getDocuments().containsKey(documentOid) && (datafileInitialPage = (document = content.getDocument(documentOid)).getDocumentInitialDataFile()) != null) {
                documentPublishURL = R01MURLHelpper.getDefaultGeneratedDataFileViewURL(document.getLanguage(), content.getTypo(), content.getStoreLocation(), content.getOid(), content.getInternalName(), content.getName(), document.getOid(), document.getLanguage(), document.getInternalName(), datafileInitialPage.getOid(), datafileInitialPage.getInternalName(), datafileInitialPage.getName(), datafileInitialPage.getTemplateOid(), repositoryToPublishOid, logicalDest.getOid());
            }
        }
        return documentPublishURL;
    }

    public static String getDataFileEditionURL(String lang, R01MContentTypologyInfo typo, R01MContentLocation loc, String contentOid, String contentInternalName, String contentName, String documentOid, String documentLanguage, String documentInternalName, String dataFileOid, String dataFileInternalName, String dataFileName, String templateOid) {
        return R01MURLHelpper._obtainContentTypeURLPattern("edit", lang, typo, loc, contentOid, contentInternalName, contentName, documentOid, documentLanguage, documentInternalName, dataFileOid, dataFileInternalName, dataFileName, templateOid, null, null);
    }

    public static String getDataFileGenerateURL(String lang, R01MContentTypologyInfo typo, R01MContentLocation loc, String contentOid, String contentInternalName, String contentName, String documentOid, String documentLanguage, String documentInternalName, String dataFileOid, String dataFileInternalName, String dataFileName, String templateOid) {
        return R01MURLHelpper._obtainContentTypeURLPattern("generate", lang, typo, loc, contentOid, contentInternalName, contentName, documentOid, documentLanguage, documentInternalName, dataFileOid, dataFileInternalName, dataFileName, templateOid, null, null);
    }

    public static String getDefaultGeneratedDataFilePreviewURL(String lang, R01MContentTypologyInfo typo, R01MContentLocation loc, String contentOid, String contentInternalName, String contentName, String documentOid, String documentLanguage, String documentInternalName, String dataFileOid, String dataFileInternalName, String dataFileName, String templateOid) {
        try {
            R01MContentTypeTemplateConfig templateCfg = typoMgmtAPI.getTemplateConfig(loc, typo, templateOid);
            if (templateCfg != null) {
                R01MPresentationTemplateConfig tplCfg = templateCfg.getDefaultPresentationTemplate();
                if (tplCfg == null) {
                    String errMsg = "Plantilla de presentacion " + templateCfg.getDefaultPresentationTemplate() + " NO definida en el fichero typologyManagementConfig.xml para el tipo " + typo.getClusterOid() + ":" + typo.getFamilyOid() + ":" + typo.getTypeOid();
                    R01FLog.to((String)LOG_TYPE_ID).severe(errMsg);
                    return "[error]:[" + errMsg + "]";
                }
                return R01MURLHelpper.getGeneratedDataFilePreviewURL(null, typo, loc, contentOid, contentInternalName, contentName, documentOid, documentLanguage, documentInternalName, dataFileOid, dataFileInternalName, dataFileName, templateOid, tplCfg.getOid(), tplCfg.getInstanceId(), templateCfg.getMainGeneratedFileName());
            }
            String errMsg = "NO se ha encontrado la configuraci\u00f3n de la plantilla " + templateOid + " para el tipo " + typo.getClusterOid() + ":" + typo.getFamilyOid() + ":" + typo.getTypeOid() + ">> Revisa el fichero typologyManagementConfig.xml";
            R01FLog.to((String)LOG_TYPE_ID).severe(errMsg);
            return "[error]:[" + errMsg + "]";
        }
        catch (R01MConfigLoadException cfgLoadEx) {
            cfgLoadEx.printStackTrace(System.out);
            return "[error]:[" + cfgLoadEx.getMessage() + "]";
        }
    }

    public static String getDefaultGeneratedDataFileViewURL(String lang, R01MContentTypologyInfo typo, R01MContentLocation loc, String contentOid, String contentInternalName, String contentName, String documentOid, String documentLanguage, String documentInternalName, String dataFileOid, String dataFileInternalName, String dataFileName, String templateOid, String logicalPublicationTargetOid, String publicationTargetOid) {
        try {
            if (StringUtils.isEmptyString((String)templateOid)) {
                String errMsg = "La plantilla solicitada para el tipo " + typo.getClusterOid() + ":" + typo.getFamilyOid() + ":" + typo.getTypeOid() + " es NULA o vacia.";
                R01FLog.to((String)LOG_TYPE_ID).severe(errMsg);
                return "[error]:[" + errMsg + "]";
            }
            R01MContentTypeTemplateConfig templateCfg = typoMgmtAPI.getTemplateConfig(loc, typo, templateOid);
            if (templateCfg == null) {
                String errMsg = "NO se ha encontrado la configuraci\u00f3n de la plantilla " + templateOid + " para el tipo " + typo.getClusterOid() + ":" + typo.getFamilyOid() + ":" + typo.getTypeOid() + ">> Revisa el fichero typologyManagementConfig.xml";
                R01FLog.to((String)LOG_TYPE_ID).severe(errMsg);
                return "[error]:[" + errMsg + "]";
            }
            R01MPresentationTemplateConfig tplCfg = templateCfg.getDefaultPresentationTemplate();
            if (tplCfg == null) {
                String errMsg = "Plantilla de presentacion " + templateCfg.getDefaultPresentationTemplate() + " NO definida en el fichero typologyManagementConfig.xml para el tipo " + typo.getClusterOid() + ":" + typo.getFamilyOid() + ":" + typo.getTypeOid();
                R01FLog.to((String)LOG_TYPE_ID).severe(errMsg);
                return "[error]:[" + errMsg + "]";
            }
            return R01MURLHelpper.getGeneratedDataFileViewURL(null, typo, loc, contentOid, contentInternalName, contentName, documentOid, documentLanguage, documentInternalName, dataFileOid, dataFileInternalName, dataFileName, templateOid, tplCfg.getOid(), tplCfg.getInstanceId(), templateCfg.getMainGeneratedFileName(), logicalPublicationTargetOid, publicationTargetOid);
        }
        catch (R01MConfigLoadException cfgLoadEx) {
            return "[error]:[" + cfgLoadEx.getMessage() + "]";
        }
    }

    public static String getDefaultGeneratedDataFileViewURL(String documentOid) {
        String msg = "";
        try {
            R01MContentModelAPI contentAPI = R01MClientFactory.getContentModelAPI(R01MAuthManager.createMasterSystemUserContext());
            String contentOid = contentAPI.getDocumentParentContent(documentOid);
            R01MContent content = contentAPI.loadContent(contentOid);
            R01MDocument document = contentAPI.loadDocument(documentOid);
            R01MDataFile dataFile = document.getDocumentInitialDataFile();
            R01MLogicalPublicationInfo logicalPublicationInfo = R01MClientFactory.getPublisherConfigAPI().getLogicalPublicationConfig(R01MPublish.DEFAULT_LOGICAL_PUBLICATION);
            List<String> logicalDestinationNames = Arrays.asList(logicalPublicationInfo.getDestinationSystemsOids());
            return R01MURLHelpper.getDefaultGeneratedDataFileViewURL(null, content.getTypo(), content.getStoreLocation(), contentOid, content.getInternalName(), content.getName(), documentOid, document.getLanguage(), document.getInternalName(), dataFile.getOid(), dataFile.getInternalName(), dataFile.getName(), dataFile.getTemplateOid(), R01MPublish.DEFAULT_LOGICAL_PUBLICATION, logicalDestinationNames.get(0));
        }
        catch (R01MSecurityException ex) {
            msg = ex.getMessage();
        }
        catch (R01MContentModelException ex) {
            msg = ex.getMessage();
        }
        catch (R01MConfigLoadException ex) {
            msg = ex.getMessage();
        }
        return msg;
    }

    public static String getGeneratedDataFilePreviewURL(String lang, R01MContentTypologyInfo typo, R01MContentLocation loc, String contentOid, String contentInternalName, String contentName, String documentOid, String documentLanguage, String documentInternalName, String dataFileOid, String dataFileInternalName, String dataFileName, String templateOid, String presentationTemplateOid, String presentationTemplateInstanceId, String generatedFileName) {
        Properties vars = R01MVariables.composeVariableParams(null, "admin", loc, typo, contentOid, contentInternalName, contentName, documentOid, documentLanguage, documentInternalName, dataFileOid, dataFileInternalName, dataFileName, templateOid, presentationTemplateOid, presentationTemplateInstanceId, generatedFileName, null, null);
        String effectiveGeneratedFileName = new String(generatedFileName);
        effectiveGeneratedFileName = R01MVariables.customize(effectiveGeneratedFileName, vars);
        vars.put("model.generatedFileName", effectiveGeneratedFileName);
        return R01MURLHelpper._obtainServerURLPattern("dataFilePreview", loc, vars);
    }

    public static String getGeneratedDataFileViewURL(String lang, R01MContentTypologyInfo typo, R01MContentLocation loc, String contentOid, String contentInternalName, String contentName, String documentOid, String documentLanguage, String documentInternalName, String dataFileOid, String dataFileInternalName, String dataFileName, String templateOid, String presentationTemplateOid, String presentationTemplateInstanceId, String generatedFileName, String logicalPublicationTargetOid, String publicationTargetOid) {
        Properties vars = R01MVariables.composeVariableParams(null, "admin", loc, typo, contentOid, contentInternalName, contentName, documentOid, documentLanguage, documentInternalName, dataFileOid, dataFileInternalName, dataFileName, templateOid, presentationTemplateOid, presentationTemplateInstanceId, generatedFileName, logicalPublicationTargetOid, publicationTargetOid);
        String effectiveGeneratedFileName = new String(generatedFileName);
        effectiveGeneratedFileName = R01MVariables.customize(effectiveGeneratedFileName, vars);
        vars.put("model.generatedFileName", effectiveGeneratedFileName);
        return R01MURLHelpper._obtainServerURLPattern("dataFileView", loc, vars);
    }

    public static final String getPortalPageEditURL(String lang, R01MPortalLocation loc, String portalOid, String pageOid, String pageInternalName, String pageLang, String logicalPublicationTargetOid, String publicationTargetOid) {
        Properties vars = R01MVariables.composePortalVariableParams(null, "admin", loc, portalOid, pageOid, pageInternalName, pageLang, logicalPublicationTargetOid, publicationTargetOid);
        return R01MURLHelpper._obtainServerURLPattern("portalPageEdit", loc, vars);
    }

    public static final String getPortalPageAdminURL(String lang, R01MPortalLocation loc, String portalOid, String pageOid, String pageInternalName, String pageLang, String logicalPublicationTargetOid, String publicationTargetOid) {
        return R01MPortalPathHelpper.obtainAdminPageURL(lang, portalOid, pageInternalName, pageLang);
    }

    public static final String getPortalPagePreviewURL(String lang, R01MPortalLocation loc, String portalOid, String pageOid, String pageInternalName, String pageLang, String logicalPublicationTargetOid, String publicationTargetOid) {
        return R01MPortalPathHelpper.obtainPortalPageURL(portalOid, pageInternalName, pageLang);
    }

    public static final String getPortalPageViewURL(String lang, R01MPortalLocation loc, String portalOid, String pageOid, String pageInternalName, String pageLang, String logicalPublicationTargetOid, String publicationTargetOid) {
        return R01MPortalPathHelpper.obtainPortalPageURL(portalOid, pageInternalName, pageLang);
    }

    public static String parseUrlAlias(String url) {
        String dashPattern;
        if (StringUtils.isEmptyString((String)url)) {
            return null;
        }
        String sep = XMLProperties.getProperty((String)R01MConstants.API_APPCODE, (String)"aliasManagement/separator");
        String urlToReturn = url.toLowerCase();
        urlToReturn = StringUtils.replaceString((String)urlToReturn, (String)" ", (String)sep);
        urlToReturn = urlToReturn.replaceAll("[\\u00E1\\u00E0\\u00E2\\u00E4]", "a");
        urlToReturn = urlToReturn.replaceAll("[\\u00E9\\u00E8\\u00EA\\u00EB]", "e");
        urlToReturn = urlToReturn.replaceAll("[\\u00ED\\u00EC\\u00EE\\u00EF]", "i");
        urlToReturn = urlToReturn.replaceAll("[\\u00F3\\u00F2\\u00F4\\u00F6]", "o");
        urlToReturn = urlToReturn.replaceAll("[\\u00FA\\u00F9\\u00FB\\u00FC]", "u");
        urlToReturn = urlToReturn.replaceAll("\u00f1", "n");
        if ((urlToReturn = urlToReturn.replaceAll("[^a-z0-9_/+-]", sep)).matches(dashPattern = "^-*(.*[^-]+)-*$")) {
            Pattern pattern = Pattern.compile(dashPattern);
            Matcher matcher = pattern.matcher(urlToReturn);
            matcher.find();
            urlToReturn = matcher.group(1);
        }
        urlToReturn = urlToReturn.replaceAll("(-)\\1+", sep);
        List properties = XMLProperties.getPropertyList((String)R01MConstants.API_APPCODE, (String)"aliasManagement/blackList/element");
        if (properties != null && !properties.isEmpty()) {
            for (String elemento : properties) {
                urlToReturn = StringUtils.replaceString((String)urlToReturn, (String)("/" + elemento + sep), (String)"/");
                urlToReturn = StringUtils.replaceString((String)urlToReturn, (String)(sep + elemento + sep), (String)"");
            }
        }
        if (!(urlToReturn = urlToReturn.replaceAll("//+", "/")).endsWith("/")) {
            urlToReturn = urlToReturn + "/";
        }
        if (urlToReturn.startsWith("/")) {
            urlToReturn = urlToReturn.replaceAll("^/+", "");
        }
        if (urlToReturn.indexOf(47) > -1) {
            String[] urlToReturnParts = urlToReturn.split("/");
            StringBuilder finalUrlToReturn = new StringBuilder();
            for (int i = 0; i < urlToReturnParts.length; ++i) {
                if (urlToReturnParts[i].length() <= R01MURLAlias.FOLDER_MAX_SIZE) {
                    finalUrlToReturn.append(urlToReturnParts[i]).append('/');
                    continue;
                }
                String folderName = urlToReturnParts[i].substring(0, R01MURLAlias.FOLDER_MAX_SIZE - 1);
                while (folderName.endsWith("-") || folderName.endsWith("_") || folderName.endsWith("+") || folderName.endsWith("|")) {
                    folderName = folderName.substring(0, folderName.length() - 1);
                }
                finalUrlToReturn.append(folderName).append('/');
            }
            urlToReturn = finalUrlToReturn.toString();
        }
        if (urlToReturn.length() > R01MURLAlias.ALIAS_MAX_SIZE) {
            int lastPath;
            int lastSeparator = (urlToReturn = urlToReturn.substring(0, R01MURLAlias.ALIAS_MAX_SIZE)).lastIndexOf(45);
            urlToReturn = lastSeparator > (lastPath = urlToReturn.lastIndexOf(47)) ? urlToReturn.substring(0, lastSeparator) + "/" : urlToReturn.substring(0, lastPath + 1);
        }
        return urlToReturn;
    }

    public static String getPortalPageAndDatafileViewUrl(String portalOid, String pageOid, String documentOid) {
        String url = "";
        R01MPage page = null;
        R01MDocument document = null;
        try {
            page = R01MClientFactory.getPortalModelAPI(R01MAuthManager.createMasterSystemUserContext(), portalOid).loadPortalPage(pageOid);
        }
        catch (R01MSecurityException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("No se puede cargar la p\u00e1gina con oid: " + pageOid + " del portal: " + portalOid + "\n" + ex.getDetailedMessage());
        }
        catch (R01MPortalModelException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("No se puede cargar la p\u00e1gina con oid: " + pageOid + " del portal: " + portalOid + "\n" + ex.getDetailedMessage());
        }
        try {
            document = R01MClientFactory.getContentModelAPI(R01MAuthManager.createMasterSystemUserContext()).loadDocument(documentOid);
        }
        catch (R01MSecurityException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("No se puede cargar el documento con oid: " + documentOid + "\n" + ex.getDetailedMessage());
        }
        catch (R01MContentModelException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("No se puede cargar el documento con oid: " + documentOid + "\n" + ex.getDetailedMessage());
        }
        boolean pageUrlFriendly = false;
        boolean documentUrlFriendly = false;
        if (page != null && document != null) {
            int i;
            R01MURLAlias pageAlias = null;
            R01MURLAlias documentAlias = null;
            if (page.getUrlAliases() != null && !page.getUrlAliases().isEmpty()) {
                for (i = 0; i < page.getUrlAliases().size(); ++i) {
                    if (!page.getUrlAliases().get(i).isBaseAlias() || !document.getLanguage().equals(document.getUrlAliases().get(i).getLang())) continue;
                    pageAlias = page.getUrlAliases().get(i);
                    pageUrlFriendly = true;
                    break;
                }
            }
            if (document.getUrlAliases() != null && !document.getUrlAliases().isEmpty()) {
                for (i = 0; i < document.getUrlAliases().size(); ++i) {
                    if (!document.getUrlAliases().get(i).isBaseAlias() || !document.getLanguage().equals(document.getUrlAliases().get(i).getLang())) continue;
                    documentAlias = document.getUrlAliases().get(i);
                    documentUrlFriendly = true;
                    break;
                }
            }
            url = documentUrlFriendly && pageUrlFriendly ? pageAlias.getAlias() + "/-/" + documentAlias.getAlias() : (documentUrlFriendly ? documentAlias.getAlias() + "/" + portalOid + "-" + pageOid + "/" + document.getLanguage() : (pageUrlFriendly ? pageAlias.getAlias() + "/" + R01MURLHelpper.getDefaultGeneratedDataFileViewURL(document.getOid()) : "/" + portalOid + "-" + pageOid + "/" + document.getLanguage() + "/" + R01MURLHelpper.getDefaultGeneratedDataFileViewURL(document.getOid())));
        }
        return url;
    }

    private static String _obtainServerURLPattern(String urlIdx, R01MBaseLocationObject loc, Properties vars) {
        String errMsg = null;
        String outURL = null;
        try {
            if (loc == null || loc.getServerOid() == null || storageAPI.getServerConfig(loc.getServerOid()) == null) {
                errMsg = "NO se puede componer la url " + urlIdx + ": no se ha pasado el servidor en el que se gestiona el contenido o no se encuentra su configuracion!!!!";
            } else if (storageAPI.getServerConfig(loc.getServerOid()).getUrls() == null) {
                errMsg = "NO se puede componer la url " + urlIdx + ": La configuracion del servidor NO tiene una seccion de urls!!!!";
            } else if (storageAPI.getServerConfig(loc.getServerOid()).getUrl(urlIdx) == null) {
                errMsg = "NO se ha definido el patr\u00f3n de la URL " + urlIdx + " en el fichero de configuracion del servidor " + loc.getServerOid();
            } else {
                outURL = storageAPI.getServerConfig(loc.getServerOid()).getUrl(urlIdx);
                outURL = R01MVariables.customize(new String(outURL), vars);
            }
        }
        catch (R01MConfigLoadException cfgLoadEx) {
            errMsg = "Error al utilizar el API de configuracion: " + cfgLoadEx.getMessage();
        }
        if (errMsg != null) {
            R01FLog.to((String)LOG_TYPE_ID).severe(errMsg);
            outURL = "[error]:[" + errMsg + "]";
        }
        return outURL;
    }

    private static String _obtainServerURLPattern(String urlIdx, String lang, R01MContentTypologyInfo typo, R01MContentLocation loc, String contentOid, String contentInternalName, String contentName, String documentOid, String documentLanguage, String documentInternalName, String dataFileOid, String dataFileInternalName, String dataFileName, String templateOid, String presentationTemplateOid, String presentationTemplateInstanceId, String generatedFileName, String logicalPublicationTargetOid, String publicationTargetOid) {
        Properties vars = R01MVariables.composeVariableParams(lang, "admin", loc, typo, contentOid, contentInternalName, contentName, documentOid, documentLanguage, documentInternalName, dataFileOid, dataFileInternalName, dataFileName, templateOid, presentationTemplateOid, presentationTemplateInstanceId, generatedFileName, logicalPublicationTargetOid, publicationTargetOid);
        return R01MURLHelpper._obtainServerURLPattern(urlIdx, loc, vars);
    }

    private static String _obtainContentTypeURLPattern(String urlIdx, String lang, R01MContentTypologyInfo typo, R01MContentLocation loc, String contentOid, String contentInternalName, String contentName, String documentOid, String documentLanguage, String documentInternalName, String dataFileOid, String dataFileInternalName, String dataFileName, String templateOid, String presentationTemplateOid, String presentationTemplateInstanceId) {
        String errMsg = null;
        String outURL = null;
        try {
            if (templateOid == null || typo == null || typo.getTypeOid() == null || loc == null || loc.getServerOid() == null || loc.getDataRepositoryOid() == null || typoMgmtAPI.getTemplateConfig(loc, typo, templateOid) == null) {
                errMsg = "NO se puede componer la url " + urlIdx + ": no se ha pasado el servidor y dataStore en el que se gestiona el contenido o el tipo de contenido. Tambien es posible que NO se encuentre la configuraci\u00f3n de gesti\u00f3n del tipo de contenido y los datos de la plantilla... revisa el XML de gesti\u00f3n de tipos de contenido!!!";
            } else if (typoMgmtAPI.getTemplateConfig(loc, typo, templateOid).getUrls() == null) {
                errMsg = "NO se puede componer la url " + urlIdx + ": No se han definido urls en el fichero de gestion de tipo de contenido " + typo.getTypeOid() + " en el dataStore " + loc.getServerOid() + ":" + loc.getDataRepositoryOid();
            } else if (typoMgmtAPI.getTemplateConfig(loc, typo, templateOid).getUrl(urlIdx) == null) {
                errMsg = "NO se puede componer la url " + urlIdx + ": NO se ha definido dicha url en la seccion urls en el fichero de gestion de tipo de contenido " + typo.getTypeOid() + " en el dataStore " + loc.getServerOid() + ":" + loc.getDataRepositoryOid();
            } else {
                outURL = typoMgmtAPI.getTemplateConfig(loc, typo, templateOid).getUrl(urlIdx);
                Properties vars = R01MVariables.composeVariableParams(lang, "admin", loc, typo, contentOid, contentInternalName, contentName, documentOid, documentLanguage, documentInternalName, dataFileOid, dataFileInternalName, dataFileName, templateOid, presentationTemplateOid, presentationTemplateInstanceId, null, null, null);
                outURL = R01MVariables.customize(new String(outURL), vars);
            }
        }
        catch (R01MConfigLoadException cfgLoadEx) {
            errMsg = "Error al utilizar el API de configuracion: " + cfgLoadEx.getMessage();
        }
        if (errMsg != null) {
            R01FLog.to((String)LOG_TYPE_ID).severe(errMsg);
            outURL = "[error]:[" + errMsg + "]";
        }
        return outURL;
    }
}

