/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.utils;

import com.ejie.r01m.config.objects.storage.R01MBaseStorageObject;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.objects.contentmodel.R01MContentLocation;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MStorageConfigAPI;

public class R01MStorageUtils {
    private static R01MStorageConfigAPI storageAPI = R01MClientFactory.getStorageConfigAPI();

    public static boolean checkLocation(R01MContentLocation loc) {
        if (loc == null) {
            return false;
        }
        R01MBaseStorageObject[] storageObjs = R01MStorageUtils.getStorageConfigObjects(loc);
        return storageObjs[0] != null && storageObjs[1] != null && storageObjs[2] != null && storageObjs[3] != null;
    }

    public static R01MBaseStorageObject[] getStorageConfigObjects(R01MContentLocation loc) {
        R01MBaseStorageObject[] outStorageObjs = new R01MBaseStorageObject[4];
        try {
            if (loc != null && loc.getServerOid() != null) {
                outStorageObjs[0] = storageAPI.getServerConfig(loc.getServerOid());
                if (loc.getDataRepositoryOid() != null && outStorageObjs[0] != null) {
                    outStorageObjs[1] = storageAPI.getDataRepositoryConfig(loc.getServerOid(), loc.getDataRepositoryOid());
                    if (loc.getAreaOid() != null && outStorageObjs[1] != null) {
                        outStorageObjs[2] = storageAPI.getAreaConfig(loc.getServerOid(), loc.getDataRepositoryOid(), loc.getAreaOid());
                        if (loc.getWorkAreaOid() != null && outStorageObjs[2] != null) {
                            outStorageObjs[3] = storageAPI.getWorkAreaConfig(loc.getServerOid(), loc.getDataRepositoryOid(), loc.getAreaOid(), loc.getWorkAreaOid());
                        }
                    }
                }
            }
        }
        catch (R01MConfigLoadException cfgLoadEx) {
            cfgLoadEx.printStackTrace(System.out);
        }
        return outStorageObjs;
    }
}

