/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.utils;

import com.ejie.r01m.objects.contentmodel.R01MDocumentPublicationTarget;
import com.ejie.r01m.objects.publisher.R01MPublish;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItemPublicationInfo;
import java.util.ArrayList;
import java.util.List;

public abstract class R01MPublicationsUtils {
    public static boolean isPublishedInRepository(List publicationsData, String repOid) {
        if (repOid == null) {
            return false;
        }
        boolean isPublished = false;
        if (publicationsData != null && !publicationsData.isEmpty()) {
            ArrayList<R01MSearchResultItemPublicationInfo> targetPublications = new ArrayList<R01MSearchResultItemPublicationInfo>();
            for (Object publicationData : publicationsData) {
                R01MSearchResultItemPublicationInfo publicacion;
                if (publicationData instanceof R01MDocumentPublicationTarget) {
                    publicacion = new R01MSearchResultItemPublicationInfo();
                    publicacion.setDate(((R01MDocumentPublicationTarget)publicationData).getPublishDate());
                    publicacion.setRepositoryOid(((R01MDocumentPublicationTarget)publicationData).getOid());
                    publicacion.setState(((R01MDocumentPublicationTarget)publicationData).getState());
                    if (!publicacion.getRepositoryOid().equals(repOid)) continue;
                    targetPublications.add(publicacion);
                    continue;
                }
                if (publicationData instanceof R01MSearchResultItemPublicationInfo) {
                    publicacion = (R01MSearchResultItemPublicationInfo)publicationData;
                    if (!publicacion.getRepositoryOid().equals(repOid)) continue;
                    targetPublications.add(publicacion);
                    continue;
                }
                return false;
            }
            if (!targetPublications.isEmpty()) {
                for (R01MSearchResultItemPublicationInfo pub1 : targetPublications) {
                    if (pub1.getState() != 1 && pub1.getState() != 3 && pub1.getState() != 5) continue;
                    boolean isUnpublished = false;
                    for (R01MSearchResultItemPublicationInfo pub2 : targetPublications) {
                        if (!pub1.getRepositoryOid().equals(pub2.getRepositoryOid()) || pub2.getState() != 0) continue;
                        isUnpublished = true;
                        if (!pub1.getDate().after(pub2.getDate())) break;
                        isPublished = true;
                        break;
                    }
                    if (isUnpublished) continue;
                    isPublished = true;
                    break;
                }
            }
        }
        return isPublished;
    }

    public static boolean isPublishedInAnyRepository(List publicationsData) {
        if (publicationsData != null && !publicationsData.isEmpty()) {
            return R01MPublicationsUtils.isPublishedInRepository(publicationsData, R01MPublish.DEFAULT_LOGICAL_PUBLICATION) || R01MPublicationsUtils.isPublishedInRepository(publicationsData, "Intra");
        }
        return false;
    }
}

