/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.utils;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MPortalModelException;
import com.ejie.r01m.exceptions.R01MPortalModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.R01MURLAlias;
import com.ejie.r01m.objects.portalmodel.R01MPage;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MPortalManagerAPI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class R01MPortalModelObjectsValidator {
    public static void validatePage(R01MUserContext userCtx, R01MPage page) throws R01MPortalModelObjectsValidatorException {
        R01FLog.to((String)"r01m.util").info("Validando la p\u00e1gina del portal ...");
        if (page == null) {
            throw new R01MPortalModelObjectsValidatorException("[Object R01MPage] No puede ser vac\u00edo.");
        }
        page.validateObject();
    }

    public static void validatePageFriendlyUrl(R01MUserContext userCtx, String portalOid, R01MPage page) throws R01MPortalModelObjectsValidatorException {
        if (page != null && page.getUrlAliases() != null && !page.getUrlAliases().isEmpty()) {
            HashMap<String, R01MURLAlias> aliasMap = new HashMap<String, R01MURLAlias>();
            List<R01MURLAlias> aliasReadyToDelete = null;
            R01MPortalManagerAPI portalAPI = R01MClientFactory.getPortalModelAPI(userCtx, portalOid);
            try {
                aliasReadyToDelete = portalAPI.loadPageAliasesInState(page.getOid(), 0);
            }
            catch (R01MSecurityException ex) {
                throw new R01MPortalModelObjectsValidatorException((Exception)((Object)ex));
            }
            catch (R01MPortalModelException ex) {
                throw new R01MPortalModelObjectsValidatorException((Exception)((Object)ex));
            }
            for (R01MURLAlias alias : page.getUrlAliases()) {
                if (aliasReadyToDelete != null && !aliasReadyToDelete.isEmpty()) {
                    for (R01MURLAlias aliasDeleteBD : aliasReadyToDelete) {
                        if (!aliasDeleteBD.getAlias().equals(alias.getAlias())) continue;
                        alias.setOid(aliasDeleteBD.getOid());
                        break;
                    }
                }
                if (aliasMap.containsKey(alias.getAlias())) {
                    if (!alias.getUrl().equals(((R01MURLAlias)aliasMap.get(alias.getAlias())).getUrl())) {
                        throw new R01MPortalModelObjectsValidatorException("El alias '" + alias.getAlias() + "' est\u00e1 repetido.");
                    }
                } else {
                    aliasMap.put(alias.getAlias(), alias);
                }
                page.setUrlAliases(new ArrayList<R01MURLAlias>(aliasMap.values()));
                try {
                    List<R01MURLAlias> portalAliases;
                    List<R01MURLAlias> pageAliases = portalAPI.loadPageActiveAliasesOfPortal();
                    if (pageAliases != null) {
                        for (R01MURLAlias currentAliasInDB : pageAliases) {
                            if (!currentAliasInDB.getAlias().equals(alias.getAlias()) || currentAliasInDB.getUrl().equals(alias.getUrl())) continue;
                            throw new R01MPortalModelObjectsValidatorException("El alias '" + alias.getAlias() + "' ya existe para otra p\u00e1gina (" + currentAliasInDB.getUrl() + ").");
                        }
                    }
                    if ((portalAliases = portalAPI.loadPortalActiveAliases()) == null) continue;
                    for (R01MURLAlias currentAliasInDB : portalAliases) {
                        if (!currentAliasInDB.getAlias().equals(alias.getAlias())) continue;
                        throw new R01MPortalModelObjectsValidatorException("El alias '" + alias.getAlias() + "' ya existe entre los aliases del portal (" + currentAliasInDB.getUrl() + ").");
                    }
                }
                catch (R01MSecurityException ex) {
                    throw new R01MPortalModelObjectsValidatorException((Exception)((Object)ex));
                }
                catch (R01MPortalModelException ex) {
                    throw new R01MPortalModelObjectsValidatorException((Exception)((Object)ex));
                }
            }
        }
    }
}

