/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.utils;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.config.objects.storage.R01MArea;
import com.ejie.r01m.config.objects.storage.R01MBaseStorageObject;
import com.ejie.r01m.config.objects.storage.R01MDataRepository;
import com.ejie.r01m.config.objects.storage.R01MServer;
import com.ejie.r01m.config.objects.storage.R01MWorkArea;
import com.ejie.r01m.config.objects.typologymanagement.R01MContentTypeTemplateConfig;
import com.ejie.r01m.config.objects.typologymanagement.R01MPresentationTemplateConfig;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.objects.R01MBaseLocationObject;
import com.ejie.r01m.objects.contentmodel.R01MContentLocation;
import com.ejie.r01m.objects.contentmodel.R01MContentTypologyInfo;
import com.ejie.r01m.objects.searchengine.indexer.R01MRispDocument;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MStorageConfigAPI;
import com.ejie.r01m.services.R01MTypologyManagementConfigAPI;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MVariables;
import com.ejie.r01m.utils.portal.R01MPortalPathHelpper;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public abstract class R01MPathHelpper
implements Serializable {
    private static final long serialVersionUID = -7872880926274948303L;
    private static R01MStorageConfigAPI storageAPI = R01MClientFactory.getStorageConfigAPI();
    private static R01MTypologyManagementConfigAPI typoMgmtAPI = R01MClientFactory.getTypologyManagementConfigAPI();
    public static final String URL_SEPARATOR = "/";

    public static String getStorageObjectPath(R01MBaseStorageObject storageObj) {
        if (storageObj instanceof R01MServer) {
            return R01MPathHelpper._obtainContentServerPathPattern("locationServerAbsolutePath", null, new R01MContentLocation(storageObj.getOid(), null, null, null), null, null, null, null, null, null, null, null, null, null);
        }
        if (storageObj instanceof R01MDataRepository) {
            return R01MPathHelpper._obtainContentServerPathPattern("locationDataStoreAbsolutePath", null, new R01MContentLocation(storageObj.getParentObj().getOid(), storageObj.getOid(), null, null), null, null, null, null, null, null, null, null, null, null);
        }
        if (storageObj instanceof R01MArea) {
            return R01MPathHelpper._obtainContentServerPathPattern("locationAreaAbsolutePath", null, new R01MContentLocation(storageObj.getParentObj().getParentObj().getOid(), storageObj.getParentObj().getOid(), storageObj.getOid(), null), null, null, null, null, null, null, null, null, null, null);
        }
        if (storageObj instanceof R01MWorkArea) {
            return R01MPathHelpper._obtainContentServerPathPattern("locationWorkAreaAbsolutePath", null, new R01MContentLocation(storageObj.getParentObj().getParentObj().getParentObj().getOid(), storageObj.getParentObj().getParentObj().getOid(), storageObj.getParentObj().getOid(), storageObj.getOid()), null, null, null, null, null, null, null, null, null, null);
        }
        return null;
    }

    public static String getLocationPath(R01MBaseLocationObject loc) {
        return R01MPathHelpper._obtainContentServerPathPattern("locationWorkAreaAbsolutePath", null, loc, null, null, null, null, null, null, null, null, null, null);
    }

    public static String getStagingLocationPath(R01MBaseLocationObject loc) {
        return R01MPathHelpper._obtainContentServerPathPattern("locationStaggingAbsolutePath", null, loc, null, null, null, null, null, null, null, null, null, null);
    }

    public static String getContentWorkAreaRelativePath(R01MContentTypologyInfo typo, R01MBaseLocationObject loc, String contentOid, String contentInternalName, String contentName) {
        return R01MPathHelpper._obtainContentServerPathPattern("contentWorkAreaRelative", typo, loc, contentOid, contentInternalName, contentName, null, null, null, null, null, null, null);
    }

    public static String getContentStagingRelativePath(R01MContentTypologyInfo typo, R01MBaseLocationObject loc, String contentOid, String contentInternalName, String contentName) {
        return R01MPathHelpper._obtainContentServerPathPattern("contentStagingRelative", typo, loc, contentOid, contentInternalName, contentName, null, null, null, null, null, null, null);
    }

    public static String getIndexableContentWorkAreaRelativePath(String contentOid, String contentInternalName, String contentName, R01MContentTypologyInfo typo, R01MBaseLocationObject loc) {
        return R01MPathHelpper._obtainContentServerPathPattern("indexableContentWorkAreaRelative", typo, loc, contentOid, contentInternalName, contentName, null, null, null, null, null, null, null);
    }

    public static Map<String, R01MRispDocument> composeRispContentDocumentsInfo(String waPath, String contentWARelPath, String contentInternalName) {
        HashMap<String, R01MRispDocument> contentRispDocumentsInfo = new HashMap<String, R01MRispDocument>();
        Properties vars = new Properties();
        vars.setProperty("contentInternalName", contentInternalName);
        Properties generatesFilesRelativePaths = XMLProperties.getProperties((String)R01MConstants.API_APPCODE, (String)"rispContentGeneratedData");
        Enumeration<Object> e = generatesFilesRelativePaths.keys();
        while (e.hasMoreElements()) {
            String obj = (String)e.nextElement();
            String fileContentRelPath = StringUtils.replaceVariableValues((String)generatesFilesRelativePaths.getProperty(obj.toString()), (char)'$', (Map)vars);
            String fileSize = "";
            try {
                fileSize = R01MClientFactory.getRawDataAPI(R01MAuthManager.createMasterSystemUserContext()).getFileAttributes(waPath, contentWARelPath + fileContentRelPath).getProperty("size");
            }
            catch (Exception ex) {
                // empty catch block
            }
            R01MRispDocument rispDoc = new R01MRispDocument(obj, fileContentRelPath, fileSize);
            contentRispDocumentsInfo.put(obj, rispDoc);
        }
        return contentRispDocumentsInfo;
    }

    public static String getDocumentWorkAreaRelativePath(R01MContentTypologyInfo typo, R01MBaseLocationObject loc, String contentOid, String contentInternalName, String contentName, String documentOid, String documentLanguage, String documentInternalName) {
        return R01MPathHelpper._obtainContentServerPathPattern("documentWorkAreaRelative", typo, loc, contentOid, contentInternalName, contentName, documentOid, documentLanguage, documentInternalName, null, null, null, null);
    }

    public static String getDocumentContentRelativePath(R01MContentTypologyInfo typo, R01MBaseLocationObject loc, String contentOid, String contentInternalName, String contentName, String documentOid, String documentLanguage, String documentInternalName) {
        return R01MPathHelpper._obtainContentServerPathPattern("documentContentRelative", typo, loc, contentOid, contentInternalName, contentName, documentOid, documentLanguage, documentInternalName, null, null, null, null);
    }

    public static String getDocumentDataFolderWorkAreaRelativePath(R01MContentTypologyInfo typo, R01MBaseLocationObject loc, String contentOid, String contentInternalName, String contentName, String documentOid, String documentLanguage, String documentInternalName) {
        return R01MPathHelpper._obtainContentServerPathPattern("documentDataFolderWorkAreaRelative", typo, loc, contentOid, contentInternalName, contentName, documentOid, documentLanguage, documentInternalName, null, null, null, null);
    }

    public static String getDocumentStagingRelativePath(R01MContentTypologyInfo typo, R01MBaseLocationObject loc, String contentOid, String contentInternalName, String contentName, String documentOid, String documentLanguage, String documentInternalName) {
        return R01MPathHelpper._obtainContentServerPathPattern("documentStagingRelative", typo, loc, contentOid, contentInternalName, contentName, documentOid, documentLanguage, documentInternalName, null, null, null, null);
    }

    public static String getIndexableDocumentWorkAreaRelativePath(R01MContentTypologyInfo typo, R01MBaseLocationObject loc, String contentOid, String contentInternalName, String contentName, String documentOid, String documentLanguage, String documentInternalName) {
        return R01MPathHelpper._obtainContentServerPathPattern("indexableDocumentWorkAreaRelative", typo, loc, contentOid, contentInternalName, contentName, documentOid, documentLanguage, documentInternalName, null, null, null, null);
    }

    public static String getDataFileWorkAreaRelativePath(R01MContentTypologyInfo typo, R01MBaseLocationObject loc, String contentOid, String contentInternalName, String contentName, String documentOid, String documentLanguage, String documentInternalName, String dataFileOid, String dataFileInternalName, String dataFileName, String templateOid) {
        return R01MPathHelpper._obtainContentServerPathPattern("dataFileWorkAreaRelative", typo, loc, contentOid, contentInternalName, contentName, documentOid, documentLanguage, documentInternalName, dataFileOid, dataFileInternalName, dataFileName, templateOid);
    }

    public static String getDataFileInDocumentFolderWorkAreaRelativePath(R01MContentTypologyInfo typo, R01MBaseLocationObject loc, String contentOid, String contentInternalName, String contentName, String documentOid, String documentLanguage, String documentInternalName, String dataFileOid, String dataFileInternalName, String dataFileName, String templateOid) {
        return R01MPathHelpper._obtainContentServerPathPattern("dataFileInDocumentWorkAreaRelative", typo, loc, contentOid, contentInternalName, contentName, documentOid, documentLanguage, documentInternalName, dataFileOid, dataFileInternalName, dataFileName, templateOid);
    }

    public static String getGeneratedDataFileDocumentRelativePath(R01MContentTypologyInfo typo, R01MBaseLocationObject loc, String contentOid, String contentInternalName, String contentName, String documentOid, String documentLanguage, String documentInternalName, String dataFileOid, String dataFileInternalName, String dataFileName, String templateOid, String presentationTemplateOid, String presentationTemplateInstanceId, String generatedFileName) {
        Properties vars = R01MVariables.composeVariableParams(null, "admin", loc, typo, contentOid, contentInternalName, contentName, documentOid, documentLanguage, documentInternalName, dataFileOid, dataFileInternalName, dataFileName, templateOid, presentationTemplateOid, presentationTemplateInstanceId, null, null, null);
        String effectiveGeneratedFileName = new String(generatedFileName);
        effectiveGeneratedFileName = R01MVariables.customize(effectiveGeneratedFileName, vars);
        return effectiveGeneratedFileName;
    }

    public static String getGeneratedDataFileWorkAreaRelativePath(R01MContentTypologyInfo typo, R01MBaseLocationObject loc, String contentOid, String contentInternalName, String contentName, String documentOid, String documentLanguage, String documentInternalName, String dataFileOid, String dataFileInternalName, String dataFileName, String templateOid, String presentationTemplateOid, String presentationTemplateInstanceId, String generatedFileName) {
        String effectiveGeneratedFileName = R01MPathHelpper.getGeneratedDataFileDocumentRelativePath(typo, loc, contentOid, contentInternalName, contentName, documentOid, documentLanguage, documentInternalName, dataFileOid, dataFileInternalName, dataFileName, templateOid, presentationTemplateOid, presentationTemplateInstanceId, generatedFileName);
        String documentWorkAreaRelativePath = R01MPathHelpper.getDocumentWorkAreaRelativePath(typo, loc, contentOid, contentInternalName, contentName, documentOid, documentLanguage, documentInternalName);
        return documentWorkAreaRelativePath + URL_SEPARATOR + effectiveGeneratedFileName;
    }

    public static String getDefaultGeneratedDataFileDocumentRelativePath(R01MContentTypologyInfo typo, R01MContentLocation loc, String contentOid, String contentInternalName, String contentName, String documentOid, String documentLanguage, String documentInternalName, String dataFileOid, String dataFileInternalName, String dataFileName, String templateOid) {
        try {
            R01MContentTypeTemplateConfig templateCfg = typoMgmtAPI.getTemplateConfig(loc, typo, templateOid);
            if (templateCfg == null) {
                String errMsg = "NO se ha encontrado la configuraci\u00f3n de la plantilla " + templateOid + " para el tipo " + typo.getClusterOid() + ":" + typo.getFamilyOid() + ":" + typo.getTypeOid() + ">> Revisa el fichero typologyManagementConfig.xml";
                R01FLog.to((String)"r01m.util").severe(errMsg);
                return "[error]:[" + errMsg + "]";
            }
            R01MPresentationTemplateConfig tplCfg = templateCfg.getDefaultPresentationTemplate();
            if (tplCfg == null) {
                String errMsg = "Plantilla de presentacion " + templateCfg.getDefaultPresentationTemplate() + " NO definida en el fichero typologyManagementConfig.xml para el tipo " + typo.getClusterOid() + ":" + typo.getFamilyOid() + ":" + typo.getTypeOid();
                R01FLog.to((String)"r01m.util").severe(errMsg);
                return "[error]:[" + errMsg + "]";
            }
            return R01MPathHelpper.getGeneratedDataFileDocumentRelativePath(typo, loc, contentOid, contentInternalName, contentName, documentOid, documentLanguage, documentInternalName, dataFileOid, dataFileInternalName, dataFileName, templateOid, tplCfg.getOid(), tplCfg.getInstanceId(), tplCfg.getMainGeneratedFile());
        }
        catch (R01MConfigLoadException cfgLoadEx) {
            return "[error]:[" + cfgLoadEx.getMessage() + "]";
        }
    }

    public static String getDefaultGeneratedDataFileWorkAreaRelativePath(R01MContentTypologyInfo typo, R01MContentLocation loc, String contentOid, String contentInternalName, String contentName, String documentOid, String documentLanguage, String documentInternalName, String dataFileOid, String dataFileInternalName, String dataFileName, String templateOid) {
        String effectiveGeneratedFileName = R01MPathHelpper.getDefaultGeneratedDataFileDocumentRelativePath(typo, loc, contentOid, contentInternalName, contentName, documentOid, documentLanguage, documentInternalName, dataFileOid, dataFileInternalName, dataFileName, templateOid);
        String documentWorkAreaRelativePath = R01MPathHelpper.getDocumentWorkAreaRelativePath(typo, loc, contentOid, contentInternalName, contentName, documentOid, documentLanguage, documentInternalName);
        return documentWorkAreaRelativePath + URL_SEPARATOR + effectiveGeneratedFileName;
    }

    public static String getIndexableDataFileWorkAreaRelativePath(R01MContentTypologyInfo typo, R01MBaseLocationObject loc, String contentOid, String contentInternalName, String contentName, String documentOid, String documentLanguage, String documentInternalName, String dataFileOid, String dataFileInternalName, String dataFileName, String templateOid) {
        return R01MPathHelpper._obtainContentServerPathPattern("indexableDataFileWorkAreaRelative", typo, loc, contentOid, contentInternalName, contentName, documentOid, documentLanguage, documentInternalName, dataFileOid, dataFileInternalName, dataFileName, templateOid);
    }

    public static String getDocumentLinkedDescriptorDocumentRelativePath(String documentLanguage, String documentInternalName) {
        Properties vars = new Properties();
        vars.put("documentLanguage", documentLanguage);
        vars.put("documentInternalName", documentInternalName);
        String effectiveGeneratedFileName = XMLProperties.get((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"contentServices/contentDirectories/contentFilesPathsAndNames/docLinkedDescriptorPath");
        effectiveGeneratedFileName = R01MVariables.customize(effectiveGeneratedFileName, vars);
        return effectiveGeneratedFileName;
    }

    public static String getDocumentGalleryDescriptorDocumentRelativePath(String documentLanguage, String documentInternalName) {
        Properties vars = new Properties();
        vars.put("documentLanguage", documentLanguage);
        vars.put("documentInternalName", documentInternalName);
        String effectiveGeneratedFileName = XMLProperties.get((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"contentServices/contentDirectories/contentFilesPathsAndNames/docGalleryDescriptorPath");
        effectiveGeneratedFileName = R01MVariables.customize(effectiveGeneratedFileName, vars);
        return effectiveGeneratedFileName;
    }

    public static String getGeoCatalogDescriptorContentRelativePath(String contentInternalName) {
        Properties vars = new Properties();
        vars.put("contentInternalName", contentInternalName);
        String effectiveGeneratedFileName = XMLProperties.get((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"contentServices/contentDirectories/contentFilesPathsAndNames/contGeocatalogDescriptorPath");
        effectiveGeneratedFileName = R01MVariables.customize(effectiveGeneratedFileName, vars);
        return effectiveGeneratedFileName;
    }

    public static String getPortalAbsolutePath(R01MBaseLocationObject locationObj, String portalOid) {
        String portalPath = R01MPortalPathHelpper.replacePortalCodeInPath(R01MPortalPathHelpper.PORTALBASEPATH_DIR, portalOid);
        if (portalPath.startsWith(URL_SEPARATOR)) {
            portalPath = portalPath.substring(1);
        }
        String portalAbsolutePath = R01MPathHelpper.getLocationPath(locationObj) + portalPath;
        return portalAbsolutePath;
    }

    public static String getPortalAdminPageWorkAreaRelativePath(String portalOid, String pageInternalName) {
        String pagesAdminDir = R01MPortalPathHelpper.replacePortalCodeInPath(R01MPortalPathHelpper.ADMINPAGES_DIR, portalOid);
        String pagesAdminFinalFileName = R01MPortalPathHelpper.renamePortalElement(portalOid, pageInternalName);
        if (!pagesAdminFinalFileName.endsWith(".shtml")) {
            pagesAdminFinalFileName = pagesAdminFinalFileName + ".shtml";
        }
        String pagesAdminPath = pagesAdminDir + pagesAdminFinalFileName;
        return pagesAdminPath;
    }

    public static String getPortalPageWorkAreaRelativePath(String portalOid, String pageInternalName) {
        String pagesPortalDir = R01MPortalPathHelpper.replacePortalCodeInPath(R01MPortalPathHelpper.PORTALPAGES_DIR, portalOid);
        String portalPageFileName = R01MPortalPathHelpper.renamePortalElement(portalOid, pageInternalName);
        if (!portalPageFileName.endsWith(".shtml")) {
            portalPageFileName = portalPageFileName + ".shtml";
        }
        String pagesPortalPath = pagesPortalDir + portalPageFileName;
        return pagesPortalPath;
    }

    public static String getPortalIndexablePageWorkAreaRelativePath(String portalOid, String pageInternalName) {
        String pagesPortalDir = R01MPortalPathHelpper.replacePortalPageCodeInPath(R01MPortalPathHelpper.INDEXES_DIR, portalOid, pageInternalName);
        String indexPortalPageFileNam = R01MPortalPathHelpper.renamePortalElement(portalOid, pageInternalName);
        if (indexPortalPageFileNam.endsWith(".shtml")) {
            indexPortalPageFileNam = indexPortalPageFileNam.substring(0, indexPortalPageFileNam.length() - ".shtml".length());
        }
        indexPortalPageFileNam = indexPortalPageFileNam + "-idxPage.xml";
        String pagesPortalPath = pagesPortalDir + indexPortalPageFileNam;
        return pagesPortalPath;
    }

    public static String getPortalAliasWorkAreaRelativePath(String portalOid) {
        String dataPortalDir = R01MPortalPathHelpper.replacePortalCodeInPath(R01MPortalPathHelpper.DATA_DIR, portalOid);
        String portalAliasFileName = portalOid + "alias.xml";
        return dataPortalDir + portalAliasFileName;
    }

    public static String getPortalInitialPageWorkAreaRelativePath(String portalOid, String pageInternalName) {
        String pagesPortalDir = R01MPortalPathHelpper.replacePortalCodeInPath(R01MPortalPathHelpper.PORTALBASEPATH_DIR, portalOid);
        String pagesPortalPath = pagesPortalDir + URL_SEPARATOR + pageInternalName;
        return pagesPortalPath;
    }

    public static String getPortalTemplateWorkAreaRelativePath(String portalOid, String templateInternalName) {
        String templatesDir = R01MPortalPathHelpper.replacePortalCodeInPath(R01MPortalPathHelpper.TEMPLATES_DIR, portalOid);
        String templateFinalFileName = R01MPortalPathHelpper.renamePortalElement(portalOid, templateInternalName);
        if (!templateFinalFileName.endsWith(".shtml")) {
            templateFinalFileName = templateFinalFileName + ".shtml";
        }
        String templatePath = templatesDir + templateFinalFileName;
        return templatePath;
    }

    public static String getPortalAVWorkAreaRelativePath(String portalOid, String avType, String avLang, String avInternalName, String generatedFileExt) {
        String visualAreasDir = R01MPortalPathHelpper.replacePortalCodeInPath(R01MPortalPathHelpper.VISUALAREA_DIR, portalOid);
        String visualAreaFinalFileName = R01MPortalPathHelpper.obtainVisualAreaURL(portalOid, avType, avLang, avInternalName, generatedFileExt);
        String visualAreaPath = visualAreasDir + visualAreaFinalFileName;
        return visualAreaPath;
    }

    public static String getPortalAVResourceWorkAreaRelativePath(String portalOid, String avType, String resourceType, String resourceName) {
        String visualAreasDir = R01MPortalPathHelpper.replacePortalCodeInPath(R01MPortalPathHelpper.VISUALAREA_DIR, portalOid);
        String visualAreaResourceFinalFileName = R01MPortalPathHelpper.obtainVisualAreaResourceURL(portalOid, avType, resourceType, resourceName);
        String visualAreaPath = visualAreasDir + visualAreaResourceFinalFileName;
        return visualAreaPath;
    }

    public static String getPortalResourceWorkAreaRelativePath(String portalOid, int resourceType, String resourceName) {
        String portalResourceDir = R01MPortalPathHelpper.PORTALBASEPATH_DIR;
        if (resourceType == 2) {
            portalResourceDir = R01MPortalPathHelpper.IMAGES_DIR;
        } else if (resourceType == 3) {
            portalResourceDir = R01MPortalPathHelpper.SCRIPTS_DIR;
        } else if (resourceType == 4) {
            portalResourceDir = R01MPortalPathHelpper.STYLES_DIR;
        } else if (resourceType == 12) {
            portalResourceDir = R01MPortalPathHelpper.ALIAS_DIR;
        } else {
            if (resourceType == 8) {
                return null;
            }
            if (resourceType == 9 || resourceType == 10) {
                return null;
            }
        }
        String portalResourcePath = R01MPortalPathHelpper.replacePortalCodeInPath(portalResourceDir, portalOid) + resourceName;
        return portalResourcePath;
    }

    public static String getPortalResourceWorkAreaRelativePath(String portalOid, String pageInternalName, int resourceType, String resourceName) {
        String portalResourceDir = R01MPortalPathHelpper.PORTALBASEPATH_DIR;
        if (resourceType == 2) {
            portalResourceDir = R01MPortalPathHelpper.IMAGES_DIR;
        } else if (resourceType == 3) {
            portalResourceDir = R01MPortalPathHelpper.SCRIPTS_DIR;
        } else if (resourceType == 4) {
            portalResourceDir = R01MPortalPathHelpper.STYLES_DIR;
        } else if (resourceType == 8) {
            portalResourceDir = R01MPortalPathHelpper.INDEXES_DIR;
        } else if (resourceType == 9 || resourceType == 10) {
            return null;
        }
        String portalResourcePath = resourceType == 8 ? R01MPortalPathHelpper.replacePortalPageCodeInPath(portalResourceDir, portalOid, pageInternalName) + resourceName : R01MPortalPathHelpper.replacePortalCodeInPath(portalResourceDir, portalOid) + resourceName;
        return portalResourcePath;
    }

    public static String getPortalResourceWorkAreaRelativePath(String portalOid, String pageInternalName, String language, int resourceType, String resourceName) {
        String portalResourceDir = R01MPortalPathHelpper.PORTALBASEPATH_DIR;
        if (resourceType == 2) {
            portalResourceDir = R01MPortalPathHelpper.IMAGES_DIR;
        } else if (resourceType == 3) {
            portalResourceDir = R01MPortalPathHelpper.SCRIPTS_DIR;
        } else if (resourceType == 4) {
            portalResourceDir = R01MPortalPathHelpper.STYLES_DIR;
        } else if (resourceType == 8) {
            portalResourceDir = R01MPortalPathHelpper.INDEXES_DIR;
        } else if (resourceType == 9) {
            portalResourceDir = R01MPortalPathHelpper.HTML_DATA_DIR;
        } else if (resourceType == 10) {
            portalResourceDir = R01MPortalPathHelpper.PARTIAL_INDEXES_DIR;
        } else if (resourceType == 7) {
            portalResourceDir = R01MPortalPathHelpper.HTML_DATA_DIR;
        }
        String portalResourcePath = resourceType == 8 ? R01MPortalPathHelpper.replacePortalPageCodeInPath(portalResourceDir, portalOid, pageInternalName) + resourceName : (resourceType == 9 || resourceType == 10 || resourceType == 7 ? R01MPortalPathHelpper.replacePortalPageLanguageCodeInPath(portalResourceDir, portalOid, pageInternalName, language) + resourceName : R01MPortalPathHelpper.replacePortalCodeInPath(portalResourceDir, portalOid) + resourceName);
        return portalResourcePath;
    }

    public static String getPortalPublicationFilelistFolderWorkAreaRelativePath(String portalOid) {
        String filelistDir = R01MPortalPathHelpper.replacePortalCodeInPath(R01MPortalPathHelpper.PUBLISH_DIR, portalOid);
        return filelistDir;
    }

    public static String getPortalPagePublicationPath(String portalOid, String pageInternalName) {
        String pageWARelativePath = R01MPathHelpper.getPortalPageWorkAreaRelativePath(portalOid, pageInternalName);
        return pageWARelativePath.substring(portalOid.length() + 6, pageWARelativePath.length());
    }

    public static String getPortalInitialPublicationPath(String portalOid, String pageInternalName) {
        String pageWARelativePath = R01MPathHelpper.getPortalInitialPageWorkAreaRelativePath(portalOid, pageInternalName);
        return pageWARelativePath.substring(portalOid.length() + 6, pageWARelativePath.length());
    }

    public static String getPortalResourcePublicationPath(String portalOid, int resourceType, String resourceName) {
        String portalResourceWARelativePath = R01MPathHelpper.getPortalResourceWorkAreaRelativePath(portalOid, resourceType, resourceName);
        if (portalResourceWARelativePath != null) {
            return portalResourceWARelativePath.substring(portalOid.length() + 6, portalResourceWARelativePath.length());
        }
        return null;
    }

    public static String getPortalResourcePublicationPath(String portalOid, String pageInternalName, int resourceType, String resourceName) {
        String portalResourceWARelativePath = R01MPathHelpper.getPortalResourceWorkAreaRelativePath(portalOid, pageInternalName, resourceType, resourceName);
        return portalResourceWARelativePath.substring(portalOid.length() + 6, portalResourceWARelativePath.length());
    }

    public static String getPortalResourcePublicationPath(String portalOid, String pageInternalName, String language, int resourceType, String resourceName) {
        String portalResourceWARelativePath = R01MPathHelpper.getPortalResourceWorkAreaRelativePath(portalOid, pageInternalName, language, resourceType, resourceName);
        return portalResourceWARelativePath.substring(portalResourceWARelativePath.indexOf("/pages"));
    }

    public static String getPortalAVPublicationPath(String portalOid, String avType, String avLang, String avInternalName, String generatedFileExt) {
        String portalAVWARelativePath = R01MPathHelpper.getPortalAVWorkAreaRelativePath(portalOid, avType, avLang, avInternalName, generatedFileExt);
        return portalAVWARelativePath.substring(portalOid.length() + 6, portalAVWARelativePath.length());
    }

    public static String getPortalAVResourcePublicationPath(String portalOid, String avType, String resourceType, String resourceName) {
        String portalAVResourceWARelativePath = R01MPathHelpper.getPortalAVResourceWorkAreaRelativePath(portalOid, avType, resourceType, resourceName);
        return portalAVResourceWARelativePath.substring(portalOid.length() + 6, portalAVResourceWARelativePath.length());
    }

    private static String _obtainContentServerPathPattern(String pathIdx, R01MContentTypologyInfo typo, R01MBaseLocationObject loc, String contentOid, String contentInternalName, String contentName, String documentOid, String documentLanguage, String documentInternalName, String dataFileOid, String dataFileInternalName, String dataFileName, String templateOid) {
        String errMsg = null;
        String outPath = null;
        try {
            if (loc == null || StringUtils.isEmptyString((String)loc.getServerOid()) || storageAPI.getServerConfig(loc.getServerOid()) == null) {
                errMsg = "NO se puede componer el path " + pathIdx + ": no se ha pasado el servidor en el que se gestiona el contenido o no se encuentra su configuracion!!!!";
            } else {
                outPath = storageAPI.getServerConfig(loc.getServerOid()).getPath(pathIdx);
                if (outPath == null) {
                    errMsg = "NO se ha definido el patr\u00f3n del path " + pathIdx + " en el fichero de configuracion del servidor " + loc.getServerOid();
                } else {
                    Properties vars = R01MVariables.composeVariableParams(null, "admin", loc, typo, contentOid, contentInternalName, contentName, documentOid, documentLanguage, documentInternalName, dataFileOid, dataFileInternalName, dataFileName, templateOid, null, null, null, null, null);
                    if ((outPath = R01MVariables.customize(new String(outPath), vars)).indexOf("$typo.typeInternalName$") > -1) {
                        errMsg = "NO se puede componer el path " + pathIdx + " para el servidor " + loc.getServerOid() + ": no se ha pasado la tipolog\u00eda en la que se gestiona el contenido o no se encuentra su configuracion!!!!" + (typo != null ? typo.composeMemoCode() : "null");
                        throw new IllegalArgumentException("[error]:[" + errMsg + "]");
                    }
                }
            }
        }
        catch (R01MConfigLoadException cfgLoadEx) {
            errMsg = "Error al utilizar el API de configuracion: " + cfgLoadEx.getMessage();
        }
        if (errMsg != null) {
            R01FLog.to((String)"r01m.util").severe(errMsg);
            throw new IllegalArgumentException("[error]:[" + errMsg + "]");
        }
        return outPath;
    }
}

