/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.utils;

import com.ejie.r01f.jvt.JVTComparator;
import com.ejie.r01m.objects.cataloguing.R01MStructureCatalog;
import com.ejie.r01m.objects.cataloguing.picks.R01MGeoPick;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MDataFile;
import com.ejie.r01m.objects.contentmodel.R01MDocument;
import com.ejie.r01m.objects.contentmodel.R01MDocumentPublicationRequested;
import com.ejie.r01m.objects.misc.R01MOperationInModelObjectInfo;
import java.util.ArrayList;
import java.util.List;

public class R01MJVTOperationToModelOperationConverter {
    private static final transient int PARENT_OBJECT = 0;
    private static final transient int CHILD_OBJECT = 1;

    public static R01MOperationInModelObjectInfo[] convertJVTOperationsToOperationsInModdel(R01MContent content, List planTable) {
        if (planTable == null || planTable.size() == 0) {
            return null;
        }
        ArrayList<R01MOperationInModelObjectInfo> outOps = new ArrayList<R01MOperationInModelObjectInfo>();
        for (JVTComparator.PlanTableOperation operation : planTable) {
            Object obj;
            Object[] arrParentChild = operation.args;
            Object objParent = null;
            if (arrParentChild.length == 1) {
                obj = arrParentChild[0];
            } else {
                obj = arrParentChild[1];
                objParent = arrParentChild[0];
            }
            R01MOperationInModelObjectInfo opInfo = new R01MOperationInModelObjectInfo();
            opInfo.addAttribute("contentName", content.getName());
            opInfo.addAttribute("contentStorage", content.getStoreLocation().composeMemoCode());
            opInfo.addAttribute("contentTypo", content.getTypo().composeMemoCode());
            opInfo.addAttribute("contentStructureLabels", content.composeStructureLabelsMemoCode());
            if (obj instanceof R01MContent) {
                opInfo.setParentObjectOid(null);
                opInfo.setObjectOid(content.getOid());
                opInfo.setObjectDescription(content.getName());
                opInfo.setObjectType(0);
            } else if (obj instanceof R01MDocument) {
                R01MDocument document = (R01MDocument)obj;
                opInfo.setParentObjectOid(content.getOid());
                opInfo.setObjectOid(content.getOid());
                opInfo.setObjectDescription(document.getInternalName() + "-" + document.getName());
                opInfo.setObjectType(1);
                opInfo.addAttribute("documentInternalName", document.getInternalName());
                opInfo.addAttribute("documentLanguage", document.getLanguage());
                opInfo.addAttribute("documentName", document.getName());
            } else if (obj instanceof R01MDataFile) {
                R01MDataFile datafile = (R01MDataFile)obj;
                R01MDocument document = (R01MDocument)objParent;
                opInfo.setParentObjectOid(document.getOid());
                opInfo.setObjectOid(datafile.getOid());
                opInfo.setObjectDescription(datafile.getName());
                opInfo.setObjectType(2);
                opInfo.addAttribute("documentInternalName", document.getInternalName());
                opInfo.addAttribute("documentLanguage", document.getLanguage());
                opInfo.addAttribute("documentName", document.getName());
                opInfo.addAttribute("dataFileName", datafile.getName());
                opInfo.addAttribute("dataFileTemplate", datafile.getTemplateOid());
            } else if (obj instanceof R01MStructureCatalog) {
                R01MStructureCatalog catalog = (R01MStructureCatalog)obj;
                opInfo.setParentObjectOid(content.getOid());
                opInfo.setObjectOid(catalog.getOid());
                opInfo.setObjectDescription(catalog.getOid());
                opInfo.setObjectType(0);
            } else if (obj instanceof R01MDocumentPublicationRequested && objParent != null) {
                R01MDocument document = (R01MDocument)objParent;
                opInfo.setParentObjectOid(document.getOid());
                opInfo.setObjectOid(document.getOid());
                opInfo.setObjectDescription(document.getInternalName() + "-" + document.getName());
                opInfo.setObjectType(1);
                opInfo.addAttribute("documentInternalName", document.getInternalName());
                opInfo.addAttribute("documentLanguage", document.getLanguage());
                opInfo.addAttribute("documentName", document.getName());
            }
            boolean setOperationtType = true;
            switch (operation.operation) {
                case 1: {
                    if (obj instanceof R01MContent) {
                        opInfo.setOperationType(1);
                        break;
                    }
                    setOperationtType = false;
                    break;
                }
                case 0: {
                    if (obj instanceof R01MContent) {
                        opInfo.setOperationType(4);
                        break;
                    }
                    if (obj instanceof R01MDocument) {
                        opInfo.setOperationType(5);
                        break;
                    }
                    if (obj instanceof R01MDataFile) {
                        opInfo.setOperationType(6);
                        break;
                    }
                    setOperationtType = false;
                    break;
                }
                case 5: {
                    if (obj instanceof R01MDocument) {
                        opInfo.setOperationType(2);
                        break;
                    }
                    if (obj instanceof R01MDataFile) {
                        opInfo.setOperationType(3);
                        break;
                    }
                    if (obj instanceof R01MStructureCatalog || obj instanceof R01MGeoPick) {
                        opInfo.setOperationType(9);
                        break;
                    }
                    if (obj instanceof R01MDocumentPublicationRequested) {
                        opInfo.setOperationType(5);
                        break;
                    }
                    setOperationtType = false;
                    break;
                }
                case 6: {
                    if (obj instanceof R01MDocument) {
                        opInfo.setOperationType(-2);
                        break;
                    }
                    if (obj instanceof R01MDataFile) {
                        opInfo.setOperationType(-3);
                        break;
                    }
                    if (obj instanceof R01MStructureCatalog || obj instanceof R01MGeoPick) {
                        opInfo.setOperationType(-9);
                        break;
                    }
                    if (obj instanceof R01MDocumentPublicationRequested) {
                        opInfo.setOperationType(5);
                        break;
                    }
                    setOperationtType = false;
                    break;
                }
                default: {
                    setOperationtType = false;
                }
            }
            if (!setOperationtType) continue;
            outOps.add(opInfo);
        }
        return outOps.toArray(new R01MOperationInModelObjectInfo[outOps.size()]);
    }
}

