/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.utils;

import com.ejie.r01f.util.StringUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public abstract class R01MExcelUtils {
    public static final int COLUMN_RECATALOG_CONTENT_SERVER = 0;
    public static final int COLUMN_RECATALOG_CONTENT_DATASTORE = 1;
    public static final int COLUMN_RECATALOG_CONTENT_AREA = 2;
    public static final int COLUMN_RECATALOG_CONTENT_WORKAREA = 3;
    public static final int COLUMN_RECATALOG_CONTENT_GUID = 4;
    public static final int COLUMN_RECATALOG_CONTENT_NAME = 5;
    public static final int COLUMN_RECATALOG_CONTENT_CLUSTER = 6;
    public static final int COLUMN_RECATALOG_CONTENT_FAMILY = 7;
    public static final int COLUMN_RECATALOG_CONTENT_TYPE = 8;

    public static List extractColumnValueFromExcel(String inputPath, int cellNumber) throws IOException {
        ArrayList<String> cellValueList = new ArrayList<String>();
        POIFSFileSystem inputFile = new POIFSFileSystem((InputStream)new FileInputStream(inputPath));
        HSSFWorkbook workBook = new HSSFWorkbook(inputFile);
        for (int i = 0; i < workBook.getNumberOfSheets(); ++i) {
            HSSFSheet sheet = workBook.getSheetAt(i);
            Iterator rowIter = sheet.rowIterator();
            while (rowIter.hasNext()) {
                HSSFRow row = (HSSFRow)rowIter.next();
                HSSFCell cell = row.getCell((short)cellNumber);
                if (cell == null || StringUtils.isEmptyString((String)cell.getStringCellValue())) continue;
                cellValueList.add(cell.getStringCellValue());
            }
        }
        return cellValueList;
    }

    public static String extractColumnValueFromExcel(String inputPath, int cellNumber, int rowNumber, int SheetNumber) throws IOException {
        POIFSFileSystem inputFile = new POIFSFileSystem((InputStream)new FileInputStream(inputPath));
        HSSFWorkbook workBook = new HSSFWorkbook(inputFile);
        HSSFSheet sheet = workBook.getSheetAt(SheetNumber);
        HSSFRow row = sheet.getRow(rowNumber);
        if (row != null) {
            HSSFCell cell = row.getCell((short)cellNumber);
            return cell.getStringCellValue();
        }
        return null;
    }

    public static List extractValuesFromExcel(String inputPath) throws IOException {
        ArrayList rowsList = new ArrayList();
        POIFSFileSystem inputFile = new POIFSFileSystem((InputStream)new FileInputStream(inputPath));
        HSSFWorkbook workBook = new HSSFWorkbook(inputFile);
        for (int i = 0; i < workBook.getNumberOfSheets(); ++i) {
            HSSFSheet sheet = workBook.getSheetAt(i);
            Iterator rowIter = sheet.rowIterator();
            while (rowIter.hasNext()) {
                HSSFRow row = (HSSFRow)rowIter.next();
                ArrayList<String> rowValues = new ArrayList<String>();
                for (int e = 0; e < row.getLastCellNum() + 1; ++e) {
                    HSSFCell cell = row.getCell((short)e);
                    if (cell == null || StringUtils.isEmptyString((String)cell.getStringCellValue())) continue;
                    rowValues.add(cell.getStringCellValue());
                }
                rowsList.add(rowValues);
            }
        }
        return rowsList;
    }
}

