/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.utils;

import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.utils.R01MConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.sf.dozer.util.mapping.DozerBeanMapper;
import net.sf.dozer.util.mapping.MappingException;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class R01MDozerMappingUtils {
    private static Properties mappingFiles = new Properties();
    private static Map<String, DozerBeanMapper> dozerMappers = null;

    R01MDozerMappingUtils() {
    }

    public static Object map(String appCode, Object sourceObj, Class destClass) throws MappingException {
        DozerBeanMapper mapper = null;
        if (mappingFiles.get(appCode) != null && (mapper = dozerMappers.get(appCode)) == null) {
            mapper = new DozerBeanMapper();
            ArrayList<Object> currFile = new ArrayList<Object>(1);
            currFile.add(mappingFiles.get(appCode));
            mapper.setMappingFiles(currFile);
            dozerMappers.put(appCode, mapper);
        }
        if (mapper == null) {
            throw new MappingException("NO se ha podido cargar el mapper de dozer para " + appCode);
        }
        return mapper.map(sourceObj, destClass);
    }

    public static void map(String appCode, Object sourceObj, Object destObj) throws MappingException {
        DozerBeanMapper mapper = null;
        if (mappingFiles.get(appCode) != null && (mapper = dozerMappers.get(appCode)) == null) {
            mapper = new DozerBeanMapper();
            ArrayList<Object> currFile = new ArrayList<Object>(1);
            currFile.add(mappingFiles.get(appCode));
            mapper.setMappingFiles(currFile);
            dozerMappers.put(appCode, mapper);
        }
        if (mapper == null) {
            throw new MappingException("NO se ha podido cargar el mapper de dozer para " + appCode);
        }
        mapper.map(sourceObj, destObj);
    }

    static {
        NodeIterator dozerMappingFiles = XMLProperties.getPropertyNodeIterator((String)R01MConstants.API_APPCODE, (String)"mapFiles/mapperObjects");
        Node node = dozerMappingFiles.nextNode();
        if (node != null) {
            int count = 0;
            do {
                String objsMappingFile;
                if ((objsMappingFile = node.getFirstChild().getNodeValue()).startsWith("/")) {
                    objsMappingFile = objsMappingFile.substring(1);
                }
                mappingFiles.put(node.getAttributes().getNamedItem("id").getNodeValue(), objsMappingFile);
                node = dozerMappingFiles.nextNode();
                ++count;
            } while (node != null);
            dozerMappers = new HashMap<String, DozerBeanMapper>(count);
        }
    }
}

