/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.utils;

import com.ejie.r01f.log.R01FLog;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import weblogic.utils.StringUtils;

public abstract class R01MDateUtils {
    public static final String LANGUAGE_CASTELLANO = "es";
    public static final String LANGUAGE_EUSKERA = "eu";

    public static Date parseDate(String date) {
        return R01MDateUtils.parseDate(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static Date parseDate(String date, String format) {
        Date outDate;
        SimpleDateFormat df = new SimpleDateFormat(format);
        try {
            outDate = df.parse(date);
        }
        catch (ParseException parseEx) {
            R01FLog.to((String)"r01m.gestorcontenidos").severe("Error al transformar la fecha " + date + ": " + parseEx.getMessage());
            return null;
        }
        return outDate;
    }

    public static Date str2Date(String strDate, String lang) throws IllegalArgumentException {
        boolean bResult = true;
        if (strDate == null || strDate.trim().equals("")) {
            return null;
        }
        Date date = new Date();
        if (strDate.length() - strDate.lastIndexOf("/") < 4 && lang.equals(LANGUAGE_CASTELLANO)) {
            return null;
        }
        if (strDate.indexOf("/") < 4 && lang.equals(LANGUAGE_EUSKERA)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        if (lang.equals(LANGUAGE_EUSKERA)) {
            df = new SimpleDateFormat("yyyy/MM/dd");
        }
        df.setLenient(false);
        if (R01MDateUtils._isNotEmpty(strDate)) {
            try {
                date.setTime(df.parse(strDate).getTime());
            }
            catch (ParseException pcEx) {
                bResult = false;
            }
        } else {
            bResult = false;
        }
        if (!bResult) {
            throw new IllegalArgumentException("Error al transformar la fecha [" + strDate + "] al idioma " + lang);
        }
        return date;
    }

    public static String dateToStr(Date date, String lang) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        if (lang.equals(LANGUAGE_EUSKERA)) {
            df.applyPattern("yyyy/MM/dd");
        }
        return df.format(date);
    }

    public static String timeToStr(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("HH:mm");
        return df.format(date);
    }

    public static String timeSecondsToStr(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
        return df.format(date);
    }

    public static Date strTimeToDate(Date date, String strHour) {
        SimpleDateFormat df = null;
        Calendar cal = null;
        StringBuffer sFecha = new StringBuffer();
        cal = Calendar.getInstance();
        cal.setTime(date);
        sFecha.append(R01MDateUtils._fillZeroLeft(String.valueOf(cal.get(1)), 4));
        sFecha.append('/');
        sFecha.append(R01MDateUtils._fillZeroLeft(String.valueOf(cal.get(2) + 1), 2));
        sFecha.append('/');
        sFecha.append(R01MDateUtils._fillZeroLeft(String.valueOf(cal.get(5)), 2));
        sFecha.append('-');
        sFecha.append(strHour);
        df = new SimpleDateFormat("yyyy/MM/dd-HH:mm");
        df.setLenient(false);
        try {
            date.setTime(df.parse(sFecha.toString()).getTime());
        }
        catch (Exception e) {
            return null;
        }
        return date;
    }

    public static String dateTimeToStr(Date date, String userLanguage) {
        return R01MDateUtils.dateToStr(date, userLanguage) + " " + R01MDateUtils.timeToStr(date);
    }

    public static String dateTimeSecondsToStr(Date date, String userLanguage) {
        return R01MDateUtils.dateToStr(date, userLanguage) + " " + R01MDateUtils.timeSecondsToStr(date);
    }

    public static Date today() {
        return Calendar.getInstance().getTime();
    }

    public static String getTodayYear() {
        return "" + Calendar.getInstance().get(1);
    }

    private static boolean _isNotEmpty(String str) {
        return str != null && str.length() > 0;
    }

    private static StringBuffer _fillZeroLeft(String cadena, int length) {
        StringBuffer cadenaChanged = new StringBuffer(cadena);
        if (!StringUtils.isEmptyString((String)cadena)) {
            while (cadenaChanged.length() < length) {
                cadenaChanged.insert(0, '0');
            }
        }
        return cadenaChanged;
    }
}

