/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.utils;

import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MDocument;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MContentDataAPI;
import com.ejie.r01m.services.R01MContentModelAPI;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class R01MContHeadUtils
implements Serializable {
    private static final long serialVersionUID = 4799560865604644111L;

    public static InputStream readContHead(String documentOid, String sourceAction, String sourceContent) throws R01MContentModelException {
        R01MContentModelAPI api = null;
        R01MContentDataAPI contentDataAPI = null;
        try {
            api = R01MClientFactory.getContentModelAPI(R01MAuthManager.createMasterSystemUserContext());
        }
        catch (R01MSecurityException secEx) {
            throw new R01MContentModelException("Error al obtener el API del modelo de contenidos datos para generar el contentHead para el documento " + documentOid + ".\r\n" + "Error: " + secEx.getMessage(), (Exception)((Object)secEx));
        }
        R01MContent content = null;
        try {
            String contentOid = api.getDocumentParentContent(documentOid);
            content = api.loadContent(contentOid);
        }
        catch (R01MSecurityException secEx) {
            throw new R01MContentModelException("Error al obtener el contenido del que depende el documento: " + documentOid + "\r\n" + "Error: " + secEx.getMessage(), (Exception)((Object)secEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new R01MContentModelException("Error al obtener el contenido del que depende el documento:" + documentOid + "\r\n" + "Error: " + cmEx.getMessage(), (Exception)((Object)cmEx));
        }
        try {
            contentDataAPI = R01MClientFactory.getContentDataAPI(R01MAuthManager.createMasterSystemUserContext(), content);
        }
        catch (R01MSecurityException secEx) {
            throw new R01MContentModelException("Error al obtener el API de datos para generar el contentHead para los documentos del contenido " + content.getOid() + ".\r\n" + "Error: " + secEx.getMessage(), (Exception)((Object)secEx));
        }
        InputStream is = null;
        try {
            is = contentDataAPI.downloadAttachmentFile(documentOid, "r01Index/r01ContHead." + sourceAction + ".shml");
        }
        catch (R01MSecurityException e) {
            e.printStackTrace();
        }
        return is;
    }

    public static void setContHead(R01MContent content, String sourceAction, String sourceContent) throws R01MContentModelException {
        R01MContentDataAPI contentDataAPI = null;
        try {
            contentDataAPI = R01MClientFactory.getContentDataAPI(R01MAuthManager.createMasterSystemUserContext(), content);
        }
        catch (R01MSecurityException secEx) {
            throw new R01MContentModelException("Error al obtener el API de datos para generar el contentHead para los documentos del contenido " + content.getOid() + ".\r\n" + "Error: " + secEx.getMessage(), (Exception)((Object)secEx));
        }
        for (R01MDocument currentDocument : content.getDocuments().values()) {
            R01MContHeadUtils._uploadPartialContHead(contentDataAPI, sourceAction, currentDocument.getOid(), content.getOid(), sourceContent);
        }
    }

    public static void setContHead(String documentOid, String sourceAction, String sourceContent) throws R01MContentModelException {
        R01MContentModelAPI api = null;
        R01MContentDataAPI contentDataAPI = null;
        try {
            api = R01MClientFactory.getContentModelAPI(R01MAuthManager.createMasterSystemUserContext());
        }
        catch (R01MSecurityException secEx) {
            throw new R01MContentModelException("Error al obtener el API del modelo de contenidos datos para generar el contentHead para el documento " + documentOid + ".\r\n" + "Error: " + secEx.getMessage(), (Exception)((Object)secEx));
        }
        R01MContent content = null;
        try {
            String contentOid = api.getDocumentParentContent(documentOid);
            content = api.loadContent(contentOid);
        }
        catch (R01MSecurityException secEx) {
            throw new R01MContentModelException("Error al obtener el contenido del que depende el documento: " + documentOid + "\r\n" + "Error: " + secEx.getMessage(), (Exception)((Object)secEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new R01MContentModelException("Error al obtener el contenido del que depende el documento:" + documentOid + "\r\n" + "Error: " + cmEx.getMessage(), (Exception)((Object)cmEx));
        }
        try {
            contentDataAPI = R01MClientFactory.getContentDataAPI(R01MAuthManager.createMasterSystemUserContext(), content);
        }
        catch (R01MSecurityException secEx) {
            throw new R01MContentModelException("Error al obtener el API de datos para generar el contentHead para los documentos del contenido " + content.getOid() + ".\r\n" + "Error: " + secEx.getMessage(), (Exception)((Object)secEx));
        }
        R01MContHeadUtils._uploadPartialContHead(contentDataAPI, sourceAction, documentOid, content.getOid(), sourceContent);
    }

    public static void removeContHead(R01MContent content, String sourceAction) throws R01MContentModelException {
        R01MContentDataAPI contentDataAPI = null;
        try {
            contentDataAPI = R01MClientFactory.getContentDataAPI(R01MAuthManager.createMasterSystemUserContext(), content);
        }
        catch (R01MSecurityException secEx) {
            throw new R01MContentModelException("Error al obtener el API de datos para borrar el contentHead para los documentos del contenido " + content.getOid() + ".\r\n" + "Error: " + secEx.getMessage(), (Exception)((Object)secEx));
        }
        for (R01MDocument currentDocument : content.getDocuments().values()) {
            try {
                contentDataAPI.deleteAttachmentFile(currentDocument.getOid(), "r01Index/r01ContHead." + sourceAction + ".shml");
            }
            catch (R01MSecurityException secEx) {
                throw new R01MContentModelException("Error al borrar el fichero ContHead de los documentos del contenido " + content.getOid() + ".\r\n" + "Error: " + secEx.getMessage(), (Exception)((Object)secEx));
            }
            catch (R01MContentModelException cmEx) {
                throw new R01MContentModelException("Error al borrar el fichero ContHead de los documentos del contenido " + content.getOid() + ".\r\n" + "Error: " + cmEx.getMessage(), (Exception)((Object)cmEx));
            }
        }
    }

    public static void removeContHead(String documentOid, String sourceAction) throws R01MContentModelException {
        R01MContentModelAPI api = null;
        try {
            api = R01MClientFactory.getContentModelAPI(R01MAuthManager.createMasterSystemUserContext());
        }
        catch (R01MSecurityException secEx) {
            throw new R01MContentModelException("Error al obtener el API del model de contenidos datos para borrar el contentHead para el documento " + documentOid + ".\r\n" + "Error: " + secEx.getMessage(), (Exception)((Object)secEx));
        }
        R01MContent content = null;
        try {
            String contentOid = api.getDocumentParentContent(documentOid);
            content = api.loadContent(contentOid);
        }
        catch (R01MSecurityException secEx) {
            throw new R01MContentModelException("Error al obtener el contenido del que depende el documento: " + documentOid + "\r\n" + "Error: " + secEx.getMessage(), (Exception)((Object)secEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new R01MContentModelException("Error al obtener el contenido del que depende el documento:" + documentOid + "\r\n" + "Error: " + cmEx.getMessage(), (Exception)((Object)cmEx));
        }
        R01MContentDataAPI contentDataAPI = null;
        try {
            contentDataAPI = R01MClientFactory.getContentDataAPI(R01MAuthManager.createMasterSystemUserContext(), content);
        }
        catch (R01MSecurityException secEx) {
            throw new R01MContentModelException("Error al obtener el API de datos para borrar el contentHead para los documentos del contenido " + content.getOid() + ".\r\n" + "Error: " + secEx.getMessage(), (Exception)((Object)secEx));
        }
        try {
            contentDataAPI.deleteAttachmentFile(documentOid, "r01Index/r01ContHead." + sourceAction + ".shml");
        }
        catch (R01MSecurityException secEx) {
            throw new R01MContentModelException("Error al subir el fichero ContHead del documento: " + documentOid + ".\r\n" + "Error: " + secEx.getMessage(), (Exception)((Object)secEx));
        }
    }

    private static void _uploadPartialContHead(R01MContentDataAPI contentDataAPI, String sourceAction, String documentOid, String contentOid, String sourceContent) throws R01MContentModelException {
        try {
            if (!StringUtils.isEmptyString((String)sourceContent)) {
                contentDataAPI.uploadAttachmentFile(documentOid, "r01Index/r01ContHead." + sourceAction + ".shml", StringUtils.getInputStream((String)sourceContent));
            } else {
                contentDataAPI.deleteAttachmentFile(documentOid, "r01Index/r01ContHead." + sourceAction + ".shml");
            }
        }
        catch (UnsupportedEncodingException uEx) {
            throw new R01MContentModelException("Error al subir el fichero ContHead de los documentos del contenido " + contentOid + ".\r\n" + "Error: " + uEx.getMessage(), (Exception)uEx);
        }
        catch (R01MSecurityException secEx) {
            throw new R01MContentModelException("Error al subir el fichero ContHead de los documentos del contenido " + contentOid + ".\r\n" + "Error: " + secEx.getMessage(), (Exception)((Object)secEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new R01MContentModelException("Error al subir el fichero ContHead de los documentos del contenido " + contentOid + ".\r\n" + "Error: " + cmEx.getMessage(), (Exception)((Object)cmEx));
        }
        try {
            if (contentDataAPI.checkAttachmentFile(documentOid, "r01ContHead.shml")) {
                InputStream file = contentDataAPI.downloadAttachmentFile(documentOid, "r01Index/r01ContHead." + sourceAction + ".shml");
                String r01ContHeadValue = StringUtils.loadFromStream((InputStream)file);
                String patternStr = "(.*r01ContHead." + sourceAction + ".shml.*\r\n)";
                Pattern p = Pattern.compile(patternStr);
                Matcher m = p.matcher(r01ContHeadValue);
                if (!m.find()) {
                    r01ContHeadValue = r01ContHeadValue + "<!--#include virtual=\"r01Index/r01ContHead." + sourceAction + ".shml -->\r\n";
                } else if (StringUtils.isEmptyString((String)sourceContent)) {
                    m.replaceAll("");
                }
            } else if (!StringUtils.isEmptyString((String)sourceContent)) {
                contentDataAPI.uploadAttachmentFile(documentOid, "r01ContHead.shml", StringUtils.getInputStream((String)("<!--#include virtual=\"r01Index/r01ContHead." + sourceAction + ".shml -->\r\n")));
            }
        }
        catch (R01MSecurityException secEx) {
            throw new R01MContentModelException("Error al obtener el fichero de previsualizaci\u00f3n para los documentos del contenido: " + contentOid + ".\r\n" + "Error: " + secEx.getMessage(), (Exception)((Object)secEx));
        }
        catch (UnsupportedEncodingException uEx) {
            throw new R01MContentModelException("Error al actualizar el fichero de previsualizaci\u00f3n para los documentos del contenido: " + contentOid + ".\r\n" + "Error: " + uEx.getMessage(), (Exception)uEx);
        }
        catch (IOException ioEx) {
            throw new R01MContentModelException("Error al cargar el contenido del fichero de previsualizaci\u00f3n para los documentos del contenido: " + contentOid + ".\r\n" + "Error: " + ioEx.getMessage(), (Exception)ioEx);
        }
    }
}

