/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.services;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01m.config.objects.userinterface.R01MAppHelps;
import com.ejie.r01m.config.objects.userinterface.R01MAppParameters;
import com.ejie.r01m.config.objects.userinterface.R01MAppTips;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.services.R01MBaseConfigAPI;
import com.ejie.r01m.services.bzd.R01MUserInterfaceConfigLoaderBzd;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class R01MUserInterfaceConfigAPI
extends R01MBaseConfigAPI {
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01p.configAPI").intValue() != Level.OFF.intValue();

    R01MUserInterfaceConfigAPI() {
        super("userInterfaceConfig");
    }

    public R01MAppHelps getUserInterfaceHelps(String appCode) throws R01MConfigLoadException {
        Map<Object, Object> uiConfigCache = this.getAllObjectConfig() != null ? this.getAllObjectConfig().get("userInterfaceHelpsCache") : null;
        R01MAppHelps appHelpsConfig = null;
        if (uiConfigCache != null) {
            if (DEBUG) {
                R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: La configuraci\u00f3n de ayudas para la aplicaci\u00f3n " + appCode + " est\u00e1 en la cache... NO SE CARGA");
            }
            if ((appHelpsConfig = (R01MAppHelps)uiConfigCache.get("helps." + appCode)) != null) {
                return appHelpsConfig;
            }
        } else if (DEBUG) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: La cach\u00e9 se ha reseteado,se vuelve a cargar la configuracion de ayudas para la aplicaci\u00f3n " + appCode + "... RECARGA");
        }
        if (DEBUG) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: No se hab\u00eda cargado la configuraci\u00f3n de ayudas para la aplicaci\u00f3n " + appCode + ", se cargan ahora");
        }
        try {
            appHelpsConfig = ((R01MUserInterfaceConfigLoaderBzd)this.getBzd("userInterfaceConfig")).loadUIHelpsAppConfig(appCode);
        }
        catch (R01MConfigLoadException cfgExc) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: No se hab\u00eda cargado la configuraci\u00f3n de ayudas para la aplicaci\u00f3n " + appCode);
            return null;
        }
        if (uiConfigCache == null) {
            uiConfigCache = new HashMap<Object, Object>();
        }
        uiConfigCache.put("helps." + appCode, appHelpsConfig);
        this.cacheObjectConfig("userInterfaceHelpsCache", uiConfigCache);
        return appHelpsConfig;
    }

    public R01MAppTips getUserInterfaceTips(String appCode) throws R01MConfigLoadException {
        R01MAppTips appTipsConfig;
        Map<Object, Object> uiConfigCache;
        Map<Object, Object> map = uiConfigCache = this.getAllObjectConfig() != null ? this.getAllObjectConfig().get("userInterfaceTipsCache") : null;
        if (uiConfigCache != null) {
            if (DEBUG) {
                R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: La configuraci\u00f3n de tips para la aplicaci\u00f3n " + appCode + " est\u00e1 en la cache... NO SE CARGA");
            }
            if ((appTipsConfig = (R01MAppTips)uiConfigCache.get("tips." + appCode)) != null) {
                return appTipsConfig;
            }
        } else if (DEBUG) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: La cach\u00e9 se ha reseteado,se vuelve a cargar la configuracion de tips para la aplicaci\u00f3n " + appCode + "... RECARGA");
        }
        if (DEBUG) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: No se hab\u00eda cargado la configuraci\u00f3n de tips para la aplicaci\u00f3n " + appCode + ", se cargan ahora");
        }
        try {
            appTipsConfig = ((R01MUserInterfaceConfigLoaderBzd)this.getBzd("userInterfaceConfig")).loadUITipsAppConfig(appCode);
        }
        catch (R01MConfigLoadException cfgExc) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: No se hab\u00eda cargado la configuraci\u00f3n de tips para la aplicaci\u00f3n " + appCode);
            return null;
        }
        catch (Throwable th) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: No se hab\u00eda cargado la configuraci\u00f3n de tips por  " + th.getMessage());
            return null;
        }
        if (uiConfigCache == null) {
            uiConfigCache = new HashMap<Object, Object>();
        }
        uiConfigCache.put("tips." + appCode, appTipsConfig);
        this.cacheObjectConfig("userInterfaceTipsCache", uiConfigCache);
        return appTipsConfig;
    }

    @Override
    public void reset() throws R01MConfigLoadException {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Reset (cliente + servidor) de configuraci\u00f3n completa de intefaces de usuario.");
        this.resetClient();
        this.resetServer();
    }

    @Override
    public void resetClient() {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Reset (solo cliente) de configuraci\u00f3n completa de intefaces de usuario.");
        super.resetCacheObjectConfig();
    }

    @Override
    public void resetServer() throws R01MConfigLoadException {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Reset (servidor) de configuraci\u00f3n completa de intefaces de usuario.");
        ((R01MUserInterfaceConfigLoaderBzd)this.getBzd("userInterfaceConfig")).reset();
    }

    public R01MAppParameters getUserInterfaceLoadParameter(String appCode) throws R01MConfigLoadException {
        R01MAppParameters appParameterConfig;
        Map<Object, Object> uiConfigCache;
        Map<Object, Object> map = uiConfigCache = this.getAllObjectConfig() != null ? this.getAllObjectConfig().get("userInterfaceParameterCache") : null;
        if (uiConfigCache != null) {
            if (DEBUG) {
                R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: La configuraci\u00f3n de parametrizaci\u00f3n para la aplicaci\u00f3n " + appCode + " est\u00e1 en la cache... NO SE CARGA");
            }
            if ((appParameterConfig = (R01MAppParameters)uiConfigCache.get("parameters." + appCode)) != null) {
                return appParameterConfig;
            }
        } else if (DEBUG) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: La cach\u00e9 se ha reseteado,se vuelve a cargar la configuracion de parametrizaci\u00f3n para la aplicaci\u00f3n " + appCode + "... RECARGA");
        }
        if (DEBUG) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: No se hab\u00eda cargado la configuraci\u00f3n de parametrizaci\u00f3n para la aplicaci\u00f3n " + appCode + ", se cargan ahora");
        }
        try {
            appParameterConfig = ((R01MUserInterfaceConfigLoaderBzd)this.getBzd("userInterfaceConfig")).loadUIParametersAppConfig(appCode);
        }
        catch (R01MConfigLoadException cfgExc) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: No se hab\u00eda cargado la configuraci\u00f3n de parametrizaci\u00f3n para la aplicaci\u00f3n " + appCode);
            return null;
        }
        catch (Throwable th) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: No se hab\u00eda cargado la configuraci\u00f3n de parametrizaci\u00f3n por  " + th.getMessage());
            return null;
        }
        if (uiConfigCache == null) {
            uiConfigCache = new HashMap<Object, Object>();
        }
        uiConfigCache.put("parameters." + appCode, appParameterConfig);
        this.cacheObjectConfig("userInterfaceParametersCache", uiConfigCache);
        return appParameterConfig;
    }
}

